/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.powers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Power;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.jdom.Element;

public class Absorption
extends Power {
    private static String xmlID = "ABSORPTION";

    public Absorption(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getDamageDisplay() {
        if (this.display.toUpperCase().indexOf("[LVL]") >= 0) {
            return "";
        }
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return this.getLevels() + " BODY";
        }
        if (this.getLevelValue() == 0.0 || this.getLevelCost() == 0.0) {
            return "";
        }
        String string = "" + this.getLevels() + "d6";
        int n = 0;
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.getXMLID().equals("PLUSONEPIP")) {
                adder.setDisplayInString(false);
                string = this.getLevels() > 0 ? this.getLevels() + "d6+1" : "1 point";
                ++n;
            }
            if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
                adder.setDisplayInString(false);
                string = this.getLevels() + " 1/2d6";
                ++n;
            }
            if (!adder.getXMLID().equals("MINUSONEPIP")) continue;
            adder.setDisplayInString(false);
            string = "" + (this.getLevels() + 1);
            string = this.getLevels() + 1 + "d6-1";
            ++n;
        }
        if (this.useStandardEffect()) {
            string = string + " (standard effect: " + (this.getLevels() * 3 + n) + " point" + (this.getLevels() > 0 ? "s" : "") + ")";
        }
        return string;
    }

    @Override
    public String getColumn2Output() {
        Object object;
        String string = this.getAlias() + " " + this.getDamageDisplay();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + "  (";
            if (this.getSelectedOption() != null) {
                string = string + this.getSelectedOption().getAlias() + ", ";
            }
            string = string + this.getInput() + ")";
        } else if (this.getSelectedOption() != null) {
            string = string + "  (";
            string = string + this.getSelectedOption().getAlias() + ")";
        }
        int n = this.getLevels() * 6;
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "PLUSONEHALFDIE") != null) {
            n += 3;
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "MINUSONEPIP") != null) {
            n += 3;
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "PLUSONEPIP") != null) {
            ++n;
        }
        ArrayList<Adder> arrayList = new ArrayList<Adder>();
        boolean bl = false;
        for (Adder object22 : this.getAssignedAdders()) {
            if (object22.getXMLID().equals("INCREASEDMAX")) {
                n += object22.getLevels();
                bl = true;
                continue;
            }
            arrayList.add(object22);
        }
        if (bl) {
            string = string + ", Can Absorb Maximum Of " + NumberFormat.getIntegerInstance().format(n) + " Points'";
            if (this.getSelectedOption() != null) {
                string = string + " Worth Of ";
                object = this.getSelectedOption().getAlias();
                object = ((String)object).substring(0, 1).toUpperCase() + ((String)object).substring(1, ((String)object).length());
                object = (String)object + " Damage";
                string = string + (String)object;
            }
        }
        object = this.assignedAdders;
        this.setAssignedAdders(arrayList);
        String string2 = this.getAdderString();
        this.setAssignedAdders((ArrayList<Adder>)object);
        if (string2.trim().length() > 0) {
            string = string + ", " + string2;
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }
}

