/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.perks;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.perks.Perk;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.VehicleDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class Vehicle
extends Perk {
    private static String xmlID = "VEHICLE_BASE";
    private int overCost = 1;
    private int overVal = 1;
    private int multiplierCost = 5;
    private int multiplierVal = 2;
    private int multiples = 1;
    private int basePoints = 0;
    private int disadPoints = 0;
    private String filePath;

    public Vehicle(Element element) {
        super(element, xmlID);
    }

    public void clearFilePath() {
        this.filePath = null;
    }

    public int getBasePoints() {
        return this.basePoints;
    }

    @Override
    public String getColumn2Output() {
        String string;
        String string2 = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string2 = "<i>" + this.getName() + ":</i>  " + string2;
        }
        if ((string = this.getAdderString()).trim().length() > 0) {
            string2 = string2 + " (";
            string2 = string2 + string;
            string2 = string2 + ")";
        }
        string2 = string2 + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string2 = this.getUseENDReserve() ? string2 + " (uses END Reserve)" : string2 + " (uses Personal END)";
        }
        return string2;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        VehicleDialog vehicleDialog = new VehicleDialog(this, bl, bl2);
        return vehicleDialog;
    }

    public int getDisadPoints() {
        return this.disadPoints;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getMultiples() {
        return this.multiples;
    }

    public int getMultiplierCost() {
        return this.multiplierCost;
    }

    public int getMultiplierVal() {
        return this.multiplierVal;
    }

    public int getOverCost() {
        return this.overCost;
    }

    public int getOverVal() {
        return this.overVal;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("NUMBER", "" + this.getMultiples());
        element.setAttribute("BASEPOINTS", "" + this.basePoints);
        element.setAttribute("DISADPOINTS", "" + this.disadPoints);
        if (this.filePath != null) {
            element.setAttribute("FILE_ASSOCIATION", this.filePath);
        }
        return element;
    }

    @Override
    public double getTotalCost() {
        int n;
        this.enhancerApplied = null;
        double d = this.getBaseCost();
        int n2 = HeroDesigner.getActiveHero().getBasePoints() + HeroDesigner.getActiveHero().getDisadPoints() + HeroDesigner.getActiveHero().getExperience();
        if (HeroDesigner.getActiveTemplate().is6E()) {
            n2 -= HeroDesigner.getActiveHero().getDisadPoints();
        }
        if (this.basePoints + this.disadPoints <= n2 || HeroDesigner.getActiveTemplate().is6E()) {
            d += (double)this.basePoints / this.levelValue * this.levelCost;
        } else {
            n = n2 >= this.getBasePoints() ? this.getBasePoints() : n2;
            int n3 = this.getBasePoints() + this.getDisadPoints() - n2;
            d += (double)n3 / (double)this.overVal * (double)this.overCost;
            d += (double)n / this.levelValue * this.levelCost;
        }
        n = 0;
        double d2 = this.multiples;
        while (d2 > 1.0) {
            d2 /= (double)this.getMultiplierVal();
            ++n;
        }
        d += (double)(n * this.getMultiplierCost());
        for (Adder object : this.getAssignedAdders()) {
            if (!(object.getRealCost() > 0.0)) continue;
            d += object.getRealCost();
        }
        if ((d = (double)Rounder.roundHalfDown(d)) < this.minimumCost && this.minSet) {
            d = this.getMinimumCost();
        } else if (d > this.maxCost && this.maxSet) {
            d = this.getMaxCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!(adder.getRealCost() < 0.0)) continue;
            d += adder.getRealCost();
        }
        if (this.getTypes() != null && this.getTypes().size() > 0) {
            ArrayList<GenericObject> arrayList = HeroDesigner.getActiveHero().getSkills();
            Iterator iterator = arrayList.iterator();
            block3: while (iterator.hasNext()) {
                GenericObject genericObject = (GenericObject)iterator.next();
                if (!(genericObject instanceof Enhancer)) continue;
                Enhancer enhancer = (Enhancer)genericObject;
                for (String string : this.getTypes()) {
                    if (!enhancer.appliesToType(string)) continue;
                    this.enhancerApplied = enhancer;
                    if (d > (double)enhancer.getCostSavings()) {
                        d -= (double)enhancer.getCostSavings();
                        break block3;
                    }
                    if (!(d > 0.0)) break block3;
                    d = 1.0;
                    break block3;
                }
            }
        }
        return d;
    }

    @Override
    protected void init(Element element) {
        this.display = "Vehicles & Bases";
        this.alias = "Vehicle";
        this.baseCost = 0.0;
        this.levelCost = 1.0;
        this.levelValue = 5.0;
        this.minimumCost = 1.0;
        this.maxCost = 10.0;
        super.init(element);
        String string = XMLUtility.getValue(element, "OVERCOST");
        if (string != null && string.trim().length() > 0) {
            try {
                this.overCost = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "OVERVAL")) != null && string.trim().length() > 0) {
            try {
                this.overVal = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "MULTIPLIERCOST")) != null && string.trim().length() > 0) {
            try {
                this.multiplierCost = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "MULTIPLIERVAL")) != null && string.trim().length() > 0) {
            try {
                this.multiplierVal = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "NUMBER");
        if (string != null && string.trim().length() > 0) {
            try {
                this.multiples = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "BASEPOINTS")) != null && string.trim().length() > 0) {
            try {
                this.basePoints = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "DISADPOINTS")) != null && string.trim().length() > 0) {
            try {
                this.disadPoints = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "FILE_ASSOCIATION")) != null && string.trim().length() > 0) {
            this.setFilePath(string);
        }
    }

    public void setBasePoints(int n) {
        this.basePoints = n;
    }

    public void setDisadPoints(int n) {
        this.disadPoints = n;
    }

    public void setFilePath(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file = new File(HeroDesigner.getInstance().getPrefs().getSaveDir() + File.separator + file.getName());
        }
        if (file.exists() && file.canRead()) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder(false);
                Document document = sAXBuilder.build(file);
                sAXBuilder = null;
                Element element = document.getRootElement();
                Element element2 = element.getChild("BASIC_CONFIGURATION");
                String string2 = XMLUtility.getValue(element2, "BASE_POINTS");
                if (string2 != null && string2.trim().length() > 0) {
                    try {
                        this.basePoints = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = XMLUtility.getValue(element2, "DISAD_POINTS")) != null && string2.trim().length() > 0) {
                    try {
                        this.disadPoints = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string2 = XMLUtility.getValue(element2, "EXPERIENCE")) != null && string2.trim().length() > 0) {
                    try {
                        this.basePoints += Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.filePath = string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setMultiples(int n) {
        this.multiples = n;
    }

    public void setMultiplierCost(int n) {
        this.multiplierCost = n;
    }

    public void setMultiplierVal(int n) {
        this.multiplierVal = n;
    }

    public void setOverCost(int n) {
        this.overCost = n;
    }

    public void setOverVal(int n) {
        this.overVal = n;
    }
}

