/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.perks;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.perks.Perk;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.ResourcePoolDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class ResourcePool
extends Perk {
    protected static String xmlID = "RESOURCE_POOL";
    private int freePoints = 0;

    public ResourcePool(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        if (this.getSelectedOption() != null && this.getSelectedOption().getAlias().trim().length() > 0) {
            string = this.getSelectedOption().getAlias();
        }
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + " (" + this.getInput() + ")";
        }
        string = string + ": " + (this.getLevels() + this.getFreePoints());
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + "; " + string2;
        }
        string = string + this.getModifierString();
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        ResourcePoolDialog resourcePoolDialog = new ResourcePoolDialog(this, bl, bl2);
        return resourcePoolDialog;
    }

    public int getFreePoints() {
        return this.freePoints;
    }

    @Override
    public double getRealCostPreList() {
        if (this.getLevels() == 0) {
            Cloneable cloneable;
            this.enhancerApplied = null;
            double d = this.getActiveCost();
            boolean bl = false;
            double d2 = 0.0;
            for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
                cloneable = this.getAssignedModifiers().get(i);
                if (!(((Modifier)cloneable).getTotalValue() < 0.0)) continue;
                d2 += ((Modifier)cloneable).getTotalValue();
                bl = true;
            }
            List list = this.getParentList();
            if (this.getMainPower() != null) {
                list = this.getMainPower().getParentList();
            }
            if (list != null) {
                cloneable = list.getAssignedModifiers();
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    Modifier modifier = (Modifier)((ArrayList)cloneable).get(i);
                    if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() < 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER")) continue;
                    d2 += modifier.getTotalValue();
                    bl = true;
                }
            }
            double d3 = d / (1.0 + Math.abs(d2));
            if (bl) {
                d3 = Rounder.roundHalfDown(d3);
            }
            if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
                d3 *= this.getMultiplier();
                d3 = Rounder.roundHalfDown(d3);
            } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && list != null && list.getMultiplier() != 1.0) {
                d3 *= list.getMultiplier();
                d3 = Rounder.roundHalfDown(d3);
            }
            if (this.getQuantity() > 1) {
                int n = 0;
                for (double d4 = (double)this.getQuantity(); d4 > 1.0; d4 /= 2.0) {
                    ++n;
                }
                d3 += (double)(n * 5);
            }
            return d3;
        }
        return super.getRealCostPreList();
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("FREE_POINTS", "" + this.getFreePoints());
        return element;
    }

    private void init() {
        this.baseCost = 0.0;
        this.minimumCost = 0.0;
        this.maxCost = 999.0;
        this.levels = 0;
        this.minimumLevel = 0;
        this.levelValue = 1.0;
        this.levelCost = 5.0;
        this.levelPower = 1;
        this.minSet = true;
        this.maxCost = 999.0;
        this.maxSet = false;
        this.freePoints = 0;
        this.types = new ArrayList();
        this.userInput = false;
        this.otherInputAllowed = false;
        this.optionLbl = "Type";
        this.abbreviation = "Resource Pool";
        this.name = "";
        this.allowsOtherModifiers = true;
        this.allowsOtherAdders = true;
    }

    @Override
    public void init(Element element) {
        this.init();
        super.init(element);
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        this.availableModifiers = new ArrayList();
        String string = XMLUtility.getValue(element, "FREE_POINTS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.freePoints = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.freePoints = 0;
            }
        }
    }

    public void setFreePoints(int n) {
        this.freePoints = n;
    }
}

