/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.perks;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.perks.Perk;
import com.hero.objects.powers.Automaton;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class Reputation
extends Perk {
    private static String xmlID = "REPUTATION";

    public Reputation(Element element) {
        super(element, xmlID);
    }

    @Override
    public double getBaseCost() {
        return this.baseCost;
    }

    @Override
    public String getColumn2Output() {
        if (this.getOptions().size() > 0) {
            return this.getOldColumn2Output();
        }
        String string = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        Adder adder = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "HOWWELL");
        Adder adder2 = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "HOWWIDE");
        adder.setDisplayInString(false);
        adder2.setDisplayInString(false);
        string = string + " (";
        string = string + adder2.getSelectedOption().getAlias();
        string = string + ")";
        string = string + " " + adder.getSelectedOption().getAlias();
        string = string + ", +" + this.getLevels() + "/+" + this.getLevels() + "d6";
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + " (" + string2 + ")";
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public double getLevelCost() {
        if (this.getOptions().size() > 0) {
            return super.getLevelCost();
        }
        double d = 0.0;
        for (int i = 0; i < this.getAssignedAdders().size(); ++i) {
            Adder adder = this.getAssignedAdders().get(i);
            if (adder.getXMLID().equals("HOWWELL")) {
                d += adder.getBaseCost();
                continue;
            }
            if (!adder.getXMLID().equals("HOWWIDE")) continue;
            d += adder.getBaseCost();
        }
        if (d < 1.0) {
            d = 1.0;
        }
        return d;
    }

    public String getOldColumn2Output() {
        String string = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        string = string + " (";
        string = string + this.getSelectedOption().getAlias();
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + "; " + string2;
        }
        string = string + ")";
        string = string + " +" + this.getLevels() + "/+" + this.getLevels() + "d6";
        string = string + this.getModifierString();
        return string;
    }

    @Override
    public double getTotalCost() {
        double d = this.getBaseCost();
        if (this.getLevelValue() != 0.0) {
            d += (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
            if (this.getLevelCost() < this.getLevelValue()) {
                d = d > 0.0 && d < 1.0 ? 1.0 : (double)Rounder.roundHalfDown(d);
            }
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isRequired() || adder.getXMLID().equals("HOWWELL") || adder.getXMLID().equals("HOWWIDE")) continue;
            d += adder.getRealCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.isRequired() || !(adder.getRealCost() > 0.0)) continue;
            d += adder.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        Object object = this.getAssignedAdders().iterator();
        while (object.hasNext()) {
            Adder adder;
            adder = object.next();
            if (adder.isRequired() || !(adder.getRealCost() < 0.0)) continue;
            d += adder.getRealCost();
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(object = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d *= (double)((Automaton)object).getDefenseCostMultiplier();
        }
        return d;
    }

    @Override
    public void restoreFromSave(Element element) {
        block11: {
            String string;
            String string2;
            String string3;
            GenericObject genericObject;
            Adder adder;
            block12: {
                String string4;
                super.restoreFromSave(element);
                if (this.getOptions().size() != 0 || GenericObject.findObjectByID(this.getAvailableAdders(), "HOWWELL") == null || GenericObject.findObjectByID(this.getAvailableAdders(), "HOWWIDE") == null) break block11;
                adder = (Adder)GenericObject.findObjectByID(this.getAvailableAdders(), "HOWWELL");
                if (GenericObject.findObjectByID(this.getAssignedAdders(), "HOWWELL") != null) {
                    adder = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "HOWWELL");
                } else {
                    this.getAssignedAdders().add(adder);
                }
                genericObject = GenericObject.findObjectByID(this.getAvailableAdders(), "HOWWIDE");
                if (GenericObject.findObjectByID(this.getAssignedAdders(), "HOWWIDE") != null) {
                    genericObject = GenericObject.findObjectByID(this.getAssignedAdders(), "HOWWIDE");
                } else {
                    this.getAssignedAdders().add((Adder)genericObject);
                }
                string3 = XMLUtility.getValue(element, "OPTIONID");
                string2 = string4 = XMLUtility.getValue(element, "OPTION_ALIAS");
                string = "";
                if (string4.indexOf(";") > 0) {
                    string2 = string4.substring(0, string4.lastIndexOf(";"));
                    string = string4.substring(string4.lastIndexOf(";"), string4.length());
                } else if (string4.indexOf(",") > 0) {
                    string2 = string4.substring(0, string4.lastIndexOf(","));
                    string = string4.substring(string4.lastIndexOf(","), string4.length());
                }
                if (string3 == null || string3.trim().length() <= 0) break block12;
                for (Adder adder2 : genericObject.getOptions()) {
                    if (!string3.startsWith(adder2.getXMLID())) continue;
                    adder2.setAlias(string2);
                    genericObject.setSelectedOption(adder2);
                    break;
                }
                for (Adder adder2 : adder.getOptions()) {
                    if (!string3.endsWith(adder2.getXMLID())) continue;
                    adder2.setAlias(string);
                    adder.setSelectedOption(adder2);
                    break block11;
                }
                break block11;
            }
            string3 = XMLUtility.getValue(element, "OPTION");
            if (string3 == null || string3.trim().length() <= 0) break block11;
            for (Adder adder3 : genericObject.getOptions()) {
                if (!string3.startsWith(adder3.getDisplay())) continue;
                adder3.setAlias(string2);
                genericObject.setSelectedOption(adder3);
                break;
            }
            for (Adder adder3 : adder.getOptions()) {
                if (!string3.endsWith(adder3.getDisplay())) continue;
                adder3.setAlias(string);
                adder.setSelectedOption(adder3);
                break;
            }
        }
    }
}

