/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.perks;

import com.hero.objects.perks.Perk;
import com.hero.ui.dialog.CustomPerkDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class CustomPerk
extends Perk {
    private static String xmlID = "CUSTOMPERK";
    private int roll;

    public CustomPerk(Element element) {
        super(element, xmlID);
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        CustomPerkDialog customPerkDialog = new CustomPerkDialog(this, bl, bl2);
        return customPerkDialog;
    }

    @Override
    public String getRoll() {
        if (this.roll == 0) {
            return "";
        }
        return this.roll + "-";
    }

    public int getRollValue() {
        return this.roll;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("ROLL", "" + this.roll);
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "ROLL");
        if (string != null && string.trim().length() > 0) {
            try {
                this.roll = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.roll = 0;
            }
        } else {
            this.roll = 0;
        }
    }

    public void setRoll(int n) {
        this.roll = n;
    }
}

