/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.ui.dialog.VariableLimitationsDialog;
import com.hero.util.Rounder;
import org.jdom.Element;

public class VariableLimitations
extends Modifier {
    private static String xmlID = "VARIABLELIMITATIONS";

    public VariableLimitations(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + genericObject.getAlias();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ":  ";
            }
            string2 = string2 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        double d2 = (double)this.getLevels() * this.getLevelCost() + this.getBaseCost() / (this.getLevelCost() / this.getLevelValue());
        d2 = (double)Rounder.roundDown(d2 * 4.0) / 4.0;
        string2 = string2 + "requires " + this.getFraction(d2) + " worth of Limitations; ";
        if (string.trim().length() > 0) {
            string2 = string2 + string + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        return string2;
    }

    @Override
    public ModifierDialog getDialog(GenericObject genericObject, boolean bl) {
        return new VariableLimitationsDialog(this, bl, genericObject);
    }

    @Override
    public int getLevels() {
        int n = this.levels;
        return n;
    }

    @Override
    public double getTotalValue() {
        double d = this.getBaseCost();
        for (Adder adder : this.getAssignedAdders()) {
            d += adder.getDoubleTotal();
        }
        if (this.getLevelCost() != 0.0) {
            int n = 1;
            if (this.getLevelValue() < 0.0 && this.getLevelCost() < 0.0) {
                n = -1;
            }
            double d2 = (double)this.getLevels() * this.getLevelValue() * this.getLevelCost();
            d2 = (double)Rounder.roundDown(d2 * 4.0) / 4.0;
            d += (d2 *= (double)n);
        }
        double d3 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d3 += modifier.getTotalValue();
        }
        double d4 = d * (1.0 + d3);
        double d5 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d5 += Math.abs(modifier.getTotalValue());
        }
        d = d4 / (1.0 + d5);
        d *= 4.0;
        int n = 1;
        if (d < 0.0) {
            n = -1;
        }
        d *= (double)n;
        d = Rounder.roundHalfUp(d);
        d *= (double)n;
        if ((d /= 4.0) < this.getMinimumCost() && this.isMinSet()) {
            return this.getMinimumCost();
        }
        if (d > this.getMaxCost() && this.isMaxSet()) {
            return this.getMaxCost();
        }
        return d;
    }

    @Override
    public boolean isLimitation() {
        return true;
    }

    public boolean isValueModifiable() {
        return false;
    }

    @Override
    public boolean noDisplayDialog() {
        return false;
    }

    @Override
    public void restoreFromSave(Element element) {
        double d = this.baseCost;
        super.restoreFromSave(element);
        if (this.baseCost != d && this.getLevelValue() != 0.0 && this.getLevelCost() != 0.0) {
            double d2 = this.baseCost - d;
            this.levels = (int)Rounder.roundDown(d2 * this.getLevelValue() / this.getLevelCost() / this.getLevelCost());
            this.baseCost = d;
        }
    }
}

