/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.ForceWall;
import java.util.ArrayList;
import org.jdom.Element;

public class Transparent
extends Modifier {
    private static String xmlID = "TRANSPARENT";
    private ArrayList<Adder> origAdders;

    public Transparent(Element element) {
        super(element, xmlID);
    }

    @Override
    public ArrayList<Adder> getAssignedAdders() {
        ArrayList<Adder> arrayList = super.getAssignedAdders();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Adder adder = arrayList.get(i);
            if (this.includeAdder(adder.getXMLID())) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        ArrayList arrayList = (ArrayList)super.getAvailableAdders().clone();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Adder adder = (Adder)arrayList.get(i);
            if (this.includeAdder(adder.getXMLID())) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        string = string + this.getAlias();
        string = string + " to ";
        ArrayList<Adder> arrayList = this.getAssignedAdders();
        if (arrayList.size() == 0) {
            return this.getAlias() + " to [no types selected]";
        }
        int n = -1;
        for (Adder adder : arrayList) {
            if (++n == arrayList.size() - 1 && n > 0) {
                string = n > 1 ? string + ", " : string + " ";
                string = string + "and ";
            } else if (n > 0) {
                string = string + ", ";
            }
            string = string + adder.getAlias();
        }
        string = string + " Attacks";
        double d = this.getTotalValue();
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string.trim().length() > 0) {
                string = string + " ";
            }
            string = string + this.getInput();
        }
        string = string.trim();
        int n2 = 0;
        int n3 = 0;
        while (string.indexOf("(", n2) >= 0) {
            ++n3;
            n2 = string.indexOf("(", n2) + 1;
        }
        n2 = 0;
        while (string.indexOf(")", n2) >= 0) {
            --n3;
            n2 = string.indexOf(")", n2) + 1;
        }
        string = n3 <= 0 ? string + " (" : string + "; ";
        if (this.getComments().trim().length() > 0) {
            string = string + this.getComments() + "; ";
        }
        if (d > this.maxCost && this.maxSet) {
            d = this.maxCost;
        }
        if (d < this.minimumCost && this.minSet) {
            d = this.minimumCost;
        }
        string = string + this.getFraction(d) + ")";
        --n3;
        while (n3 > 0) {
            string = string + ")";
            --n3;
        }
        return string;
    }

    private boolean includeAdder(String string) {
        if (this.getProgenitor() == null) {
            return false;
        }
        ForceWall forceWall = (ForceWall)this.getProgenitor();
        if (string.equalsIgnoreCase("PD")) {
            return forceWall.getEdLevels() > 0 && forceWall.getPdLevels() == 0;
        }
        if (string.equalsIgnoreCase("ED")) {
            return forceWall.getPdLevels() > 0 && forceWall.getEdLevels() == 0;
        }
        if (string.equalsIgnoreCase("MD")) {
            return (forceWall.getPowdLevels() > 0 || this.providesFlashDefense()) && forceWall.getMdLevels() == 0;
        }
        if (string.equalsIgnoreCase("POWD")) {
            return (forceWall.getMdLevels() > 0 || this.providesFlashDefense()) && forceWall.getPowdLevels() == 0;
        }
        if (string.equalsIgnoreCase("FLASHD")) {
            return (forceWall.getMdLevels() > 0 || forceWall.getPowdLevels() > 0) && !this.providesFlashDefense();
        }
        return true;
    }

    @Override
    public String included(GenericObject genericObject) {
        if (this.forceAllow()) {
            return "";
        }
        if (genericObject instanceof ForceWall) {
            return "";
        }
        return "Transparent may only be applied to Force Walls.";
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        this.origAdders = this.availableAdders;
    }

    @Override
    public boolean isLimitation() {
        return false;
    }

    private boolean providesFlashDefense() {
        if (this.getProgenitor() == null) {
            return false;
        }
        if (this.getProgenitor().getAssignedAdders() == null) {
            return false;
        }
        for (Adder adder : this.getProgenitor().getAssignedAdders()) {
            if (!adder.getXMLID().equals("FLASHDEFENSE")) continue;
            return adder.getLevels() > 0;
        }
        return false;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        if (this.selectedOption != null) {
            for (int i = 0; i < this.origAdders.size(); ++i) {
                Adder adder = this.origAdders.get(i);
                if (!adder.getXMLID().equals(this.selectedOption.getXMLID())) continue;
                Adder adder2 = adder.clone();
                adder2.setSelected(true);
                this.getAssignedAdders().add(adder2);
                return;
            }
        }
    }
}

