/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.ForceWall;
import com.hero.objects.powers.MindControl;
import com.hero.objects.powers.Telepathy;
import java.util.ArrayList;
import org.jdom.Element;

public class TimeLimit
extends Modifier {
    private static String xmlID = "TIMELIMIT";

    public TimeLimit(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        this.recalcOptions();
        String string = this.getAlias().trim();
        if (this.getSelectedOption() != null && this.getSelectedOption().getAlias().trim().length() > 0) {
            string = string + " (" + this.getSelectedOption().getAlias().trim();
            if (this.getInput() != null && this.getInput().trim().length() > 0) {
                string = string + ", " + this.getInput().trim();
            }
            if (this.getComments() != null && this.getComments().trim().length() > 0) {
                string = string + ", " + this.getComments().trim();
            }
            string = string + "; " + this.getFraction(this.getTotalValue()) + ")";
        } else {
            string = string + " (" + this.getFraction(this.getTotalValue()) + ")";
        }
        return string;
    }

    @Override
    public double getTotalValue() {
        this.recalcOptions();
        return super.getTotalValue();
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (!(genericObject.getDuration().equals("PERSISTENT") || genericObject.getDuration().equals("CONSTANT") || genericObject.getDuration().equals("INSTANT"))) {
            return this.getDisplay() + " can only be applied to Persistent, Constant, or Instant Powers";
        }
        if (genericObject.usesEND() && !genericObject.getDuration().equals("INSTANT")) {
            GenericObject genericObject2;
            if (TimeLimit.findObjectByID(genericObject.getAssignedModifiers(), "COSTSENDONLYTOACTIVATE") != null) {
                return "";
            }
            if (TimeLimit.findObjectByID(genericObject.getAssignedModifiers(), "COSTSEND") != null && (genericObject2 = TimeLimit.findObjectByID(genericObject.getAssignedModifiers(), "COSTSEND")).getSelectedOption() != null && (genericObject2.getSelectedOption().getXMLID().equals("ACTIVATE") || genericObject2.getSelectedOption().getXMLID().equals("ONLYTOCHANGE"))) {
                return "";
            }
            return this.getDisplay() + " can only be applied to abilities which cost 0 END or which cost END only to activate";
        }
        return "";
    }

    private ArrayList<Adder> getLimitationTable() {
        ArrayList<Adder> arrayList = new ArrayList<Adder>();
        Adder adder = new Adder();
        adder.setDisplay("Extra Phase");
        adder.setBaseCost(-3.0);
        adder.setXMLID("EXTRAPHASE");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("");
        arrayList2.add("+1 Phase per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        adder = new Adder();
        adder.setDisplay("1 Turn");
        adder.setBaseCost(-2.5);
        adder.setXMLID("1TURN");
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.add("+1 Turn per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        adder = new Adder();
        adder.setDisplay("1 Minute");
        adder.setBaseCost(-2.0);
        adder.setXMLID("1MINUTE");
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.add("+1 Minute per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        adder = new Adder();
        adder.setDisplay("5 Minutes");
        adder.setBaseCost(-1.5);
        adder.setXMLID("5MINUTES");
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.add("+5 Minutes per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        adder = new Adder();
        adder.setDisplay("20 Minutes");
        adder.setBaseCost(-1.0);
        adder.setXMLID("20MINUTES");
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.add("+20 Minutes per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        adder = new Adder();
        adder.setDisplay("1 Hour");
        adder.setBaseCost(-0.75);
        adder.setXMLID("1HOUR");
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.add("+1 Hour per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        adder = new Adder();
        adder.setDisplay("6 Hours");
        adder.setBaseCost(-0.5);
        adder.setXMLID("6HOURS");
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.add("+6 Hours per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        adder = new Adder();
        adder.setDisplay("1 Day");
        adder.setBaseCost(-0.25);
        adder.setXMLID("1DAY");
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.add("+1 Day per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        adder = new Adder();
        adder.setDisplay("1 Week");
        adder.setBaseCost(0.0);
        adder.setXMLID("1WEEK");
        arrayList2 = new ArrayList();
        arrayList2.add("");
        arrayList2.add("+1 Week per point the Skill Roll succeeds by");
        adder.setExamples(arrayList2);
        arrayList.add(adder);
        return arrayList;
    }

    @Override
    public boolean isLimitation() {
        this.recalcOptions();
        return super.isLimitation();
    }

    @Override
    public void setParent(GenericObject genericObject) {
        super.setParent(genericObject);
        this.recalcOptions();
    }

    @Override
    public void setSelectedOption(Adder adder) {
        super.setSelectedOption(adder);
        this.recalcOptions();
    }

    @Override
    public Adder getSelectedOption() {
        this.recalcOptions();
        return super.getSelectedOption();
    }

    private void recalcOptions() {
        int n;
        ArrayList<String> arrayList;
        Adder adder;
        if (this.availableCheck) {
            return;
        }
        ArrayList<Object> arrayList2 = new ArrayList();
        if (this.parent == null) {
            return;
        }
        if (this.parent.getDuration().equals("INSTANT")) {
            if (this.parent instanceof Telepathy || this.parent instanceof MindControl || this.parent instanceof Entangle || this.parent instanceof ForceWall) {
                arrayList2 = this.getLimitationTable();
            } else {
                adder = new Adder();
                adder.setDisplay("Extra Phase");
                adder.setBaseCost(0.25);
                adder.setXMLID("EXTRAPHASE");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Phase per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Turn");
                adder.setBaseCost(0.5);
                adder.setXMLID("1TURN");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Turn per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Minute");
                adder.setBaseCost(0.75);
                adder.setXMLID("1MINUTE");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Minute per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("5 Minutes");
                adder.setBaseCost(1.0);
                adder.setXMLID("5MINUTES");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+5 Minutes per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("20 Minutes");
                adder.setBaseCost(1.25);
                adder.setXMLID("20MINUTES");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+20 Minutes per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Hour");
                adder.setBaseCost(1.5);
                adder.setXMLID("1HOUR");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Hour per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("6 Hours");
                adder.setBaseCost(1.75);
                adder.setXMLID("6HOURS");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+6 Hours per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Day");
                adder.setBaseCost(2.0);
                adder.setXMLID("1DAY");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Day per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Week");
                adder.setBaseCost(2.25);
                adder.setXMLID("1WEEK");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Week per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Month");
                adder.setBaseCost(2.5);
                adder.setXMLID("1MONTH");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Month per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Season");
                adder.setBaseCost(2.75);
                adder.setXMLID("1SEASON");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Season per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Year");
                adder.setBaseCost(3.0);
                adder.setXMLID("1YEAR");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Year per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("5 Years");
                adder.setBaseCost(3.25);
                adder.setXMLID("5YEARS");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+5 Years per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("25 Years");
                adder.setBaseCost(3.5);
                adder.setXMLID("25YEARS");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+25 Years per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
                adder = new Adder();
                adder.setDisplay("1 Century");
                adder.setBaseCost(3.75);
                adder.setXMLID("1CENTURY");
                arrayList = new ArrayList();
                arrayList.add("");
                arrayList.add("+1 Century per point the Skill Roll succeeds by");
                adder.setExamples(arrayList);
                arrayList2.add(adder);
            }
        } else if (TimeLimit.findObjectByID(this.parent.getAllAssignedModifiers(), "PERSISTENT") == null && (this.parent.getDuration().equals("CONSTANT") || this.parent.getDuration().equals("PERSISTENT") && (GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "COSTSEND") != null || GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "COSTSENDTOMAINTAIN") != null || GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "COSTSENDONLYTOACTIVATE") != null))) {
            adder = new Adder();
            adder.setDisplay("1 Turn");
            adder.setBaseCost(0.25);
            adder.setXMLID("1TURN");
            arrayList = new ArrayList<String>();
            arrayList.add("");
            arrayList.add("+1 Turn per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("1 Minute");
            adder.setBaseCost(0.5);
            adder.setXMLID("1MINUTE");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+1 Minute per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("5 Minutes");
            adder.setBaseCost(0.75);
            adder.setXMLID("5MINUTES");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+5 Minutes per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("20 Minutes");
            adder.setBaseCost(1.0);
            adder.setXMLID("20MINUTES");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+20 Minutes per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("1 Hour");
            adder.setBaseCost(1.25);
            adder.setXMLID("1HOUR");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+1 Hour per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("6 Hours");
            adder.setBaseCost(1.5);
            adder.setXMLID("6HOURS");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+6 Hours per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("1 Day");
            adder.setBaseCost(1.75);
            adder.setXMLID("1DAY");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+1 Day per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("1 Week");
            adder.setBaseCost(2.0);
            adder.setXMLID("1WEEK");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+1 Week per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("1 Month");
            adder.setBaseCost(2.25);
            adder.setXMLID("1MONTH");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+1 Month per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("1 Season");
            adder.setBaseCost(2.5);
            adder.setXMLID("1SEASON");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+1 Season per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("1 Year");
            adder.setBaseCost(2.75);
            adder.setXMLID("1YEAR");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+1 Year per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("5 Years");
            adder.setBaseCost(3.0);
            adder.setXMLID("5YEARS");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+5 Years per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("25 Years");
            adder.setBaseCost(3.25);
            adder.setXMLID("25YEARS");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+25 Years per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
            adder = new Adder();
            adder.setDisplay("1 Century");
            adder.setBaseCost(3.5);
            adder.setXMLID("1CENTURY");
            arrayList = new ArrayList();
            arrayList.add("");
            arrayList.add("+1 Century per point the Skill Roll succeeds by");
            adder.setExamples(arrayList);
            arrayList2.add(adder);
        } else if (this.parent.getDuration().equals("PERSISTENT") || TimeLimit.findObjectByID(this.parent.getAllAssignedModifiers(), "PERSISTENT") != null) {
            arrayList2 = this.getLimitationTable();
        }
        adder = this.selectedOption;
        boolean bl = false;
        if (this.options != null && this.options.size() != arrayList2.size()) {
            bl = true;
            this.setOptions(arrayList2);
        } else if (this.options != null) {
            for (n = 0; n < this.options.size(); ++n) {
                Adder adder2 = (Adder)this.options.get(n);
                Adder adder3 = (Adder)arrayList2.get(n);
                if (adder2.getXMLID().equals(adder3.getXMLID()) && adder2.getBaseCost() == adder3.getBaseCost()) continue;
                bl = true;
            }
            if (bl) {
                this.setOptions(arrayList2);
            }
        } else {
            bl = true;
            this.setOptions(arrayList2);
        }
        n = 0;
        if (adder != null) {
            for (Adder adder3 : this.options) {
                if (!adder3.getXMLID().equals(adder.getXMLID())) continue;
                adder = adder3;
                n = 1;
                break;
            }
        }
        if (n != 0) {
            if (this.selectedOption == null && arrayList2 != null && arrayList2.size() > 0) {
                this.selectedOption = (Adder)arrayList2.get(0);
            } else if (arrayList2 != null && arrayList2.size() > 0) {
                this.selectedOption = adder;
            }
        }
    }
}

