/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class SideEffects
extends Modifier {
    private static String xmlID = "SIDEEFFECTS";
    private double constantPowerWithActivation = -0.25;

    public SideEffects(Element element) {
        super(element, xmlID);
    }

    @Override
    public double getBaseCost() {
        double d = this.baseCost;
        GenericObject genericObject = this.parent;
        if (genericObject == null) {
            return d;
        }
        if ((genericObject.getDuration().equals("CONSTANT") || genericObject.getDuration().equals("PERSISTENT") || genericObject.getDuration().equals("INHERENT")) && (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "ACTIVATIONROLL") != null || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "REQUIRESSKILLROLL") != null)) {
            d += this.constantPowerWithActivation;
        }
        return d;
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + genericObject.getAlias();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ":  ";
            }
            string2 = string2 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        if (string.trim().length() > 0) {
            string2 = string2 + string + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        return string2;
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        String string = XMLUtility.getValue(element, "CONSTANTPOWERWITHACTIVATION");
        if (string != null && string.trim().length() > 0) {
            try {
                this.constantPowerWithActivation = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

