/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.Intelligence;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.ui.dialog.RequiresSkillRollDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class RequiresSkillRoll
extends Modifier {
    public static final int backgroundType = 1;
    public static final int charType = 2;
    public static final int perType = 3;
    public static final int skillType = 0;
    private static String xmlID = "REQUIRESASKILLROLL";
    private double backgroundSkill;
    private int characteristic;
    private int characteristic2;
    private boolean refreshOnUpdate;
    private double roll10;
    private double roll11;
    private double roll12;
    private double roll13;
    private double roll14;
    private double roll15;
    private double roll8;
    private double roll9;
    private String rollAlias = "Skill";
    private String rollAlias2 = "Skill";
    private int type;
    private int type2;

    public RequiresSkillRoll(Element element) {
        super(element, xmlID);
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        if (this.getSelectedOption() == null || this.getSelectedOption().getXMLID().equals("BASICRSR") || this.getSelectedOption().getXMLID().equals("TWOROLLS")) {
            return this.availableAdders;
        }
        ArrayList arrayList = (ArrayList)this.availableAdders.clone();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Adder adder = (Adder)arrayList.get(i);
            if (!adder.getXMLID().equals("VARIABLERSR") && !adder.getXMLID().equals("SKILLVSSKILL")) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    @Override
    public double getBaseCost() {
        this.setSelectedOption(this.getSelectedOption());
        double d = super.getBaseCost();
        if (this.getSelectedOption() == null || this.getSelectedOption().getXMLID().equals("BASICRSR")) {
            Characteristic characteristic;
            Intelligence intelligence;
            if (this.type == 0) {
                return d;
            }
            if (this.type == 1) {
                return d += this.backgroundSkill;
            }
            d = this.type == 3 ? (HeroDesigner.getActiveHero() != null ? ((intelligence = (Intelligence)HeroDesigner.getActiveHero().getCharacteristic(5)) != null ? this.getRollAdjustment(intelligence.getPrimaryPERRoll()) : this.roll11) : this.roll11) : (HeroDesigner.getActiveHero() != null ? ((characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.characteristic)) != null ? this.getRollAdjustment((int)(9L + Rounder.roundHalfUp(characteristic.getPrimaryValue() / 5.0))) : this.roll11) : this.roll11);
        } else if (this.getSelectedOption().getXMLID().equals("TWOROLLS")) {
            if (this.type == 0 && this.type2 == 0) {
                return d;
            }
            return d + this.backgroundSkill;
        }
        return d;
    }

    public int getCharacteristic() {
        return this.characteristic;
    }

    public int getCharacteristic2() {
        return this.characteristic2;
    }

    @Override
    public String getColumn2Output() {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            String string = "";
            String string2 = "";
            string2 = string2 + this.getAlias();
            double d = this.getTotalValue();
            for (Adder genericObject : this.getAssignedAdders()) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + genericObject.getAlias();
            }
            if (this.getInput() != null && this.getInput().trim().length() > 0) {
                if (string2.trim().length() > 0) {
                    string2 = string2 + ":  ";
                }
                string2 = string2 + this.getInput();
            }
            for (Modifier modifier : this.getAssignedModifiers()) {
                string2 = string2 + ", " + modifier.getAlias();
            }
            string2 = string2 + " (";
            string2 = string2 + this.getSelectedOption().getAlias() + "; ";
            if (string.trim().length() > 0) {
                string2 = string2 + string + "; ";
            }
            if (this.getComments().trim().length() > 0) {
                string2 = string2 + this.getComments() + "; ";
            }
            string2 = string2 + this.getFraction(d) + ")";
            return string2;
        }
        String string = "";
        String string3 = "";
        string3 = string3 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder adder : this.getAssignedAdders()) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + adder.getAlias();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string3.trim().length() > 0) {
                string3 = string3 + ":  ";
            }
            string3 = string3 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string3 = string3 + ", " + modifier.getAlias();
        }
        string3 = string3 + " (";
        if (string.trim().length() > 0) {
            string3 = string3 + string + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string3 = string3 + this.getComments() + "; ";
        }
        string3 = string3 + this.getFraction(d) + ")";
        return string3;
    }

    @Override
    public ModifierDialog getDialog(GenericObject genericObject, boolean bl) {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return new ModifierDialog(this, bl, genericObject);
        }
        return new RequiresSkillRollDialog(this, bl, genericObject);
    }

    public String getRoll2Alias() {
        if (this.rollAlias2 == null) {
            this.rollAlias2 = "Skill";
        }
        return this.rollAlias2;
    }

    private double getRollAdjustment(int n) {
        if (n <= 8) {
            return this.roll8;
        }
        if (n <= 9) {
            return this.roll9;
        }
        if (n <= 10) {
            return this.roll10;
        }
        if (n <= 11) {
            return this.roll11;
        }
        if (n <= 12) {
            return this.roll12;
        }
        if (n <= 13) {
            return this.roll13;
        }
        if (n <= 14) {
            return this.roll14;
        }
        return this.roll15;
    }

    public String getRollAlias() {
        if (this.rollAlias == null) {
            this.rollAlias = "Skill";
        }
        return this.rollAlias;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        if (this.getSelectedOption() != null) {
            if (this.getSelectedOption().getXMLID().equals("BASICRSR")) {
                element.setAttribute("TYPE", "" + this.type);
                if (this.type == 2) {
                    element.setAttribute("CHARACTERISTIC", "" + this.characteristic);
                }
                element.setAttribute("ROLLALIAS", this.rollAlias);
            } else if (this.getSelectedOption().getXMLID().equals("TWOROLLS")) {
                element.setAttribute("TYPE", "" + this.type);
                element.setAttribute("TYPE2", "" + this.type2);
                if (this.type == 2) {
                    element.setAttribute("CHARACTERISTIC", "" + this.characteristic);
                }
                if (this.type2 == 2) {
                    element.setAttribute("CHARACTERISTIC2", "" + this.characteristic2);
                }
                element.setAttribute("ROLLALIAS", this.rollAlias);
                element.setAttribute("ROLLALIAS2", this.rollAlias2);
            }
        }
        return element;
    }

    public int getType() {
        if (this.type < 0 || this.type > 3) {
            this.type = 0;
        }
        return this.type;
    }

    public int getType2() {
        if (this.type2 < 0 || this.type2 > 3) {
            this.type2 = 0;
        }
        return this.type2;
    }

    @Override
    protected void init(Element element) {
        this.backgroundSkill = 0.25;
        this.roll8 = -2.0;
        this.roll9 = -1.5;
        this.roll10 = -1.25;
        this.roll11 = -1.0;
        this.roll12 = -0.75;
        this.roll13 = -0.75;
        this.roll14 = -0.5;
        this.roll15 = -0.25;
        this.rollAlias = "Skill";
        this.type = 0;
        this.type2 = 0;
        super.init(element);
        String string = XMLUtility.getValue(element, "BACKGROUNDSKILL");
        if (string != null && string.trim().length() > 0) {
            try {
                this.backgroundSkill = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ROLL8")) != null && string.trim().length() > 0) {
            try {
                this.roll8 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ROLL9")) != null && string.trim().length() > 0) {
            try {
                this.roll9 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ROLL10")) != null && string.trim().length() > 0) {
            try {
                this.roll10 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ROLL11")) != null && string.trim().length() > 0) {
            try {
                this.roll11 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ROLL12")) != null && string.trim().length() > 0) {
            try {
                this.roll12 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ROLL13")) != null && string.trim().length() > 0) {
            try {
                this.roll13 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ROLL14")) != null && string.trim().length() > 0) {
            try {
                this.roll14 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ROLL15")) != null && string.trim().length() > 0) {
            try {
                this.roll15 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean refreshAddersOnUpdate() {
        boolean bl = this.refreshOnUpdate;
        this.refreshOnUpdate = false;
        return bl;
    }

    @Override
    public void restoreFromSave(Element element) {
        String string;
        super.restoreFromSave(element);
        if (this.getSelectedOption() != null) {
            if (this.getSelectedOption().getXMLID().equals("BASICRSR")) {
                string = XMLUtility.getValue(element, "TYPE");
                if (string != null && string.trim().length() > 0) {
                    try {
                        this.type = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string = XMLUtility.getValue(element, "CHARACTERISTIC")) != null && string.trim().length() > 0) {
                    try {
                        this.characteristic = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string = XMLUtility.getValue(element, "ROLLALIAS")) != null && string.trim().length() > 0) {
                    this.rollAlias = string;
                } else if (this.type == 0) {
                    this.rollAlias = "Skill";
                } else if (this.type == 1) {
                    this.rollAlias = "Background Skill";
                } else if (this.type == 3) {
                    this.rollAlias = "PER";
                } else if (this.type == 2) {
                    this.rollAlias = "Characteristic";
                }
            } else if (this.getSelectedOption().getXMLID().equals("TWOROLLS")) {
                string = XMLUtility.getValue(element, "TYPE");
                if (string != null && string.trim().length() > 0) {
                    try {
                        this.type = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string = XMLUtility.getValue(element, "CHARACTERISTIC")) != null && string.trim().length() > 0) {
                    try {
                        this.characteristic = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string = XMLUtility.getValue(element, "ROLLALIAS")) != null && string.trim().length() > 0) {
                    this.rollAlias = string;
                } else if (this.type == 0) {
                    this.rollAlias = "Skill";
                } else if (this.type == 1) {
                    this.rollAlias = "Background Skill";
                } else if (this.type == 3) {
                    this.rollAlias = "PER";
                } else if (this.type == 2) {
                    this.rollAlias = "Characteristic";
                }
                string = XMLUtility.getValue(element, "TYPE2");
                if (string != null && string.trim().length() > 0) {
                    try {
                        this.type2 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string = XMLUtility.getValue(element, "CHARACTERISTIC2")) != null && string.trim().length() > 0) {
                    try {
                        this.characteristic2 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((string = XMLUtility.getValue(element, "ROLLALIAS2")) != null && string.trim().length() > 0) {
                    this.rollAlias2 = string;
                } else if (this.type2 == 0) {
                    this.rollAlias2 = "Skill";
                } else if (this.type2 == 1) {
                    this.rollAlias2 = "Background Skill";
                } else if (this.type2 == 3) {
                    this.rollAlias2 = "PER";
                } else if (this.type2 == 2) {
                    this.rollAlias2 = "Characteristic";
                }
            }
        }
        if ((string = XMLUtility.getValue(element, "ALIAS")) != null && string.trim().length() > 0) {
            this.setAlias(string);
        }
    }

    public void setCharacteristic(int n) {
        this.characteristic = n;
    }

    public void setCharacteristic2(int n) {
        this.characteristic2 = n;
    }

    @Override
    public void setRefreshAddersOnUpdate(boolean bl) {
        this.refreshOnUpdate = bl;
    }

    public synchronized void setRoll2Alias(String string) {
        String string2 = " " + this.rollAlias2.trim() + " ";
        if (string2.trim().length() == 0) {
            string2 = null;
        }
        this.rollAlias2 = string;
        if (string2 != null && this.getAlias().indexOf(this.getRollAlias()) >= 0) {
            String string3;
            char c;
            String string4 = this.getAlias().substring(0, this.getAlias().indexOf(this.getRollAlias()));
            if (!string4.trim().toLowerCase().endsWith("a") && !string4.trim().toLowerCase().endsWith("an")) {
                string4 = string4.trim() + " a ";
            }
            String string5 = this.getAlias().substring(this.getAlias().indexOf(this.getRollAlias()) + this.getRollAlias().length(), this.getAlias().length());
            String string6 = "";
            if (this.getSelectedOption() != null && this.getSelectedOption().getXMLID().equals("TWOROLLS")) {
                if (this.getAlias().lastIndexOf(string2) > this.getAlias().indexOf(this.getRollAlias())) {
                    string5 = this.getAlias().substring(this.getAlias().indexOf(this.getRollAlias()) + this.getRollAlias().length(), this.getAlias().lastIndexOf(string2));
                    if (!string5.trim().toLowerCase().endsWith("a") && !string5.trim().toLowerCase().endsWith("an")) {
                        string5 = string5.trim() + " a ";
                    }
                    string6 = this.getAlias().substring(this.getAlias().lastIndexOf(string2) + string2.length(), this.getAlias().length());
                    string6 = " " + this.rollAlias2.trim() + " " + string6.trim();
                    c = this.rollAlias2.trim().toUpperCase().charAt(0);
                    if (this.rollAlias2.trim().toLowerCase().startsWith("a ") || this.rollAlias2.trim().toLowerCase().startsWith("an ")) {
                        string5 = string5.substring(0, string5.toLowerCase().lastIndexOf("a"));
                    } else if (string5.trim().toUpperCase().endsWith("N") && c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 'U' && c != 'Y' && c != 'H') {
                        string5 = string5.substring(0, string5.toUpperCase().lastIndexOf("N"));
                        string3 = "";
                        if (string5.startsWith(" ")) {
                            string3 = " ";
                        }
                        string5 = string5.trim();
                        string5 = string3 + string5;
                    } else if (string5.trim().toUpperCase().endsWith("A") && (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y' || c == 'H')) {
                        string3 = "";
                        if (string5.startsWith(" ")) {
                            string3 = " ";
                        }
                        string5 = string5.trim();
                        string5 = string3 + string5 + "n";
                    }
                } else if (this.getAlias().lastIndexOf(string2) >= 0) {
                    string4 = this.getAlias().substring(0, this.getAlias().lastIndexOf(string2));
                    c = this.rollAlias2.trim().toUpperCase().charAt(0);
                    if (this.rollAlias2.trim().toLowerCase().startsWith("a ") || this.rollAlias2.trim().toLowerCase().startsWith("an ")) {
                        string4 = string4.substring(0, string4.toLowerCase().lastIndexOf("a"));
                    } else if (string4.trim().toUpperCase().endsWith("N") && c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 'U' && c != 'Y' && c != 'H') {
                        string4 = string4.substring(0, string4.toUpperCase().lastIndexOf("N"));
                        string3 = "";
                        if (string4.startsWith(" ")) {
                            string3 = " ";
                        }
                        string4 = string4.trim();
                        string4 = string3 + string4;
                    } else if (string4.trim().toUpperCase().endsWith("A") && (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y' || c == 'H')) {
                        string3 = "";
                        if (string4.startsWith(" ")) {
                            string3 = " ";
                        }
                        string4 = string4.trim();
                        string4 = string3 + string4 + "n";
                    }
                    string4 = string4 + " " + this.rollAlias2.trim() + " ";
                    string5 = this.getAlias().substring(this.getAlias().lastIndexOf(string2) + string2.length(), this.getAlias().indexOf(this.getRollAlias()));
                    string6 = this.getAlias().substring(this.getAlias().indexOf(this.getRollAlias()) + this.getRollAlias().length(), this.getAlias().length());
                }
            }
            c = this.getRollAlias().trim().toUpperCase().charAt(0);
            if (this.getRollAlias().trim().toLowerCase().startsWith("a ") || this.getRollAlias().trim().toLowerCase().startsWith("an ")) {
                string4 = string4.substring(0, string4.toLowerCase().lastIndexOf("a"));
            } else if (string4.trim().toUpperCase().endsWith("N") && c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 'U' && c != 'Y' && c != 'H') {
                string4 = string4.substring(0, string4.toUpperCase().lastIndexOf("N"));
                string3 = "";
                if (string4.startsWith(" ")) {
                    string3 = " ";
                }
                string4 = string4.trim();
                string4 = string3 + string4 + "n";
            } else if (string4.trim().toUpperCase().endsWith("A") && (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y' || c == 'H')) {
                string3 = "";
                if (string4.startsWith(" ")) {
                    string3 = " ";
                }
                string4 = string4.trim();
                string4 = string3 + string4 + "n";
            }
            this.setAlias(string4.trim() + " " + this.getRollAlias().trim() + " " + string5.trim() + " " + string6.trim());
        }
    }

    public synchronized void setRollAlias(String string) {
        String string2 = this.rollAlias;
        string2 = " " + string2.trim() + " ";
        if (string2.trim().length() == 0) {
            string2 = null;
        }
        this.rollAlias = string;
        if (string2 != null && this.getAlias().indexOf(string2) >= 0) {
            String string3;
            char c;
            String string4 = this.getAlias().substring(0, this.getAlias().indexOf(string2));
            if (!string4.trim().toLowerCase().endsWith("a") && !string4.trim().toLowerCase().endsWith("an")) {
                string4 = string4.trim() + " a ";
            }
            String string5 = this.getAlias().substring(this.getAlias().indexOf(string2) + string2.length(), this.getAlias().length());
            String string6 = "";
            if (this.getSelectedOption() != null && this.getSelectedOption().getXMLID().equals("TWOROLLS")) {
                if (this.getAlias().indexOf(this.getRoll2Alias(), this.getAlias().indexOf(string2) + string2.length()) > 0) {
                    string5 = this.getAlias().substring(this.getAlias().indexOf(string2) + string2.length(), this.getAlias().indexOf(this.getRoll2Alias(), this.getAlias().indexOf(string2) + string2.length()));
                    if (!string5.trim().toLowerCase().endsWith("a") && !string5.trim().toLowerCase().endsWith("an")) {
                        string5 = string5.trim() + " a ";
                    }
                    string6 = this.getAlias().substring(this.getAlias().indexOf(this.getRoll2Alias(), this.getAlias().indexOf(string2) + string2.length()) + this.getRoll2Alias().length(), this.getAlias().length());
                    string6 = " " + this.getRoll2Alias() + " " + string6;
                    c = this.getRoll2Alias().trim().toUpperCase().charAt(0);
                    if (this.getRoll2Alias().trim().toLowerCase().startsWith("a ") || this.getRoll2Alias().trim().toLowerCase().startsWith("an ")) {
                        string5 = string5.substring(0, string5.toLowerCase().lastIndexOf("a"));
                    }
                    if (string5.trim().toUpperCase().endsWith("N") && c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 'U' && c != 'Y' && c != 'H') {
                        string5 = string5.substring(0, string5.toUpperCase().lastIndexOf("N"));
                    } else if (string5.trim().toUpperCase().endsWith("A") && (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y' || c == 'H')) {
                        string3 = "";
                        if (string5.startsWith(" ")) {
                            string3 = " ";
                        }
                        string5 = string5.trim();
                        string5 = string3 + string5 + "n";
                    }
                } else if (this.getAlias().indexOf(this.getRoll2Alias()) >= 0) {
                    string4 = this.getAlias().substring(0, this.getAlias().indexOf(this.getRoll2Alias()));
                    c = this.getRoll2Alias().trim().toUpperCase().charAt(0);
                    if (this.getRoll2Alias().trim().toLowerCase().startsWith("a ") || this.getRoll2Alias().trim().toLowerCase().startsWith("an ")) {
                        string4 = string4.substring(0, string4.toLowerCase().lastIndexOf("a"));
                    } else if (string4.trim().toUpperCase().endsWith("N") && c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 'U' && c != 'Y' && c != 'H') {
                        string4 = string4.substring(0, string4.toUpperCase().lastIndexOf("N"));
                    } else if (string4.trim().toUpperCase().endsWith("A") && (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y' || c == 'H')) {
                        string3 = "";
                        if (string4.startsWith(" ")) {
                            string3 = " ";
                        }
                        string4 = string4.trim();
                        string4 = string3 + string4 + "n";
                    }
                    string4 = string4 + this.getRoll2Alias();
                    string5 = this.getAlias().substring(this.getAlias().indexOf(this.getRoll2Alias()) + this.getRoll2Alias().length(), this.getAlias().indexOf(string2));
                    string6 = this.getAlias().substring(this.getAlias().indexOf(string2) + string2.length(), this.getAlias().length());
                }
            }
            c = this.rollAlias.trim().toUpperCase().charAt(0);
            if (this.rollAlias.trim().toLowerCase().startsWith("a ") || this.rollAlias.trim().toLowerCase().startsWith("an ")) {
                string4 = string4.substring(0, string4.toLowerCase().lastIndexOf("a"));
            } else if (string4.trim().toUpperCase().endsWith("N") && c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 'U' && c != 'Y' && c != 'H') {
                string4 = string4.substring(0, string4.toUpperCase().lastIndexOf("N"));
            } else if (string4.trim().toUpperCase().endsWith("A") && (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y' || c == 'H')) {
                string3 = "";
                if (string4.startsWith(" ")) {
                    string3 = " ";
                }
                string4 = string4.trim();
                string4 = string3 + string4 + "n";
            }
            this.setAlias(string4.trim() + " " + this.rollAlias.trim() + " " + string5.trim() + " " + string6.trim());
            if (this.getSelectedOption() != null && this.getSelectedOption().getXMLID().equals("TWOROLLS")) {
                this.setRoll2Alias(this.getRoll2Alias());
            }
        }
    }

    @Override
    public void setSelectedOption(Adder adder) {
        Adder adder2 = this.getSelectedOption();
        super.setSelectedOption(adder);
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return;
        }
        if (adder != null) {
            this.baseCost = adder.getBaseCost();
            if (adder2 != null && adder.getXMLID() == adder2.getXMLID()) {
                return;
            }
            if (this.getAlias().startsWith("Requires")) {
                if (adder.getXMLID().equals("ONELUCK")) {
                    this.setAlias("Requires A Luck Roll");
                } else if (adder.getXMLID().equals("TWOLUCK")) {
                    this.setAlias("Requires Two Levels of Luck");
                } else if (adder.getXMLID().equals("THREELUCK")) {
                    this.setAlias("Requires Three Levels of Luck");
                } else if (adder.getXMLID().equals("TWOROLLS")) {
                    this.setAlias("Requires A " + this.getRollAlias() + " Roll And A " + this.getRoll2Alias() + " Roll");
                } else {
                    this.setAlias("Requires A " + this.getRollAlias() + " Roll");
                }
            }
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setType2(int n) {
        this.type2 = n;
    }
}

