/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.Strength;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.CustomPower;
import com.hero.objects.powers.NakedModifier;
import org.jdom.Element;

public class ReducedEND
extends Modifier {
    private static String xmlID = "REDUCEDEND";

    public ReducedEND(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        string2 = string2 + " (";
        if (this.getSelectedOption() != null) {
            string2 = string2 + this.getSelectedOption().getAlias();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + " ";
            }
            string2 = string2 + this.getInput();
        }
        string2 = string2.trim();
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        int n = 0;
        int n2 = 0;
        while (string2.indexOf("(", n) >= 0) {
            ++n2;
            n = string2.indexOf("(", n) + 1;
        }
        n = 0;
        while (string2.indexOf(")", n) >= 0) {
            --n2;
            n = string2.indexOf(")", n) + 1;
        }
        string2 = n2 <= 0 ? string2 + " (" : string2 + "; ";
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isSelected() || adder.getColumn2Output().trim().length() <= 0) continue;
            string2 = string2 + adder.getColumn2Output().trim() + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        if (d > this.maxCost && this.maxSet) {
            d = this.maxCost;
        }
        if (d < this.minimumCost && this.minSet) {
            d = this.minimumCost;
        }
        string2 = string2 + this.getFraction(d) + ")";
        --n2;
        while (n2 > 0) {
            string2 = string2 + ")";
            --n2;
        }
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public double getTotalValue() {
        double d = super.getTotalValue();
        if (this.parent != null && GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "AUTOFIRE") != null) {
            d *= 2.0;
        }
        return d;
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        genericObject = genericObject.clone();
        genericObject.setParent(null);
        genericObject.setMainPower(null);
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "INCREASEDEND") != null) {
            return this.getDisplay() + " cannot be applied to an ability with the Increased END Limitation.";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "COSTSEND") != null) {
            return this.getDisplay() + " cannot be applied to an ability with the Costs END Limitation.";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "COSTSENDONLYTOACTIVATE") != null) {
            return this.getDisplay() + " cannot be applied to an ability with Costs END Only To Activate.";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "COSTSENDTOMAINTAIN") != null) {
            return this.getDisplay() + " cannot be applied to an ability with Costs END To Maintain.";
        }
        if (genericObject instanceof Multipower || genericObject instanceof ElementalControl) {
            return "";
        }
        if ((genericObject instanceof NakedModifier || genericObject instanceof CustomPower) && genericObject.getAPPerEnd() != 0) {
            return "";
        }
        GenericObject genericObject2 = GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "CHARGES");
        if (genericObject2 != null) {
            genericObject.getAssignedModifiers().remove(genericObject2);
        }
        if (genericObject instanceof Characteristic) {
            Characteristic characteristic = (Characteristic)genericObject;
            if (characteristic.addModifiersToBase() && HeroDesigner.getActiveHero() != null) {
                characteristic = HeroDesigner.getActiveHero().getCharacteristic(characteristic.getType());
                int n = characteristic.getEndUsage();
                if (characteristic instanceof Strength) {
                    Strength strength = (Strength)characteristic;
                    n = strength.getPrimaryEND();
                }
                if (n == 0 && genericObject.getEndUsage() == 0) {
                    if (genericObject2 != null) {
                        genericObject.getAssignedModifiers().add((Modifier)genericObject2);
                    }
                    return genericObject.getDisplay() + " does not cost END.";
                }
                if (genericObject2 != null) {
                    genericObject.getAssignedModifiers().add((Modifier)genericObject2);
                }
                return "";
            }
            if (genericObject.getEndUsage() == 0) {
                if (genericObject2 != null) {
                    genericObject.getAssignedModifiers().add((Modifier)genericObject2);
                }
                return genericObject.getDisplay() + " does not cost END.";
            }
            if (genericObject2 != null) {
                genericObject.getAssignedModifiers().add((Modifier)genericObject2);
            }
            return "";
        }
        if (genericObject.getEndUsage() == 0) {
            if (genericObject2 != null) {
                genericObject.getAssignedModifiers().add((Modifier)genericObject2);
            }
            return genericObject.getDisplay() + " does not cost END.";
        }
        if (genericObject2 != null) {
            genericObject.getAssignedModifiers().add((Modifier)genericObject2);
        }
        return "";
    }
}

