/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Duplication;
import com.hero.objects.powers.HandToHandAttack;
import org.jdom.Element;

public class RangeBasedOnSTR
extends Modifier {
    private static String xmlID = "RANGEBASEDONSTR";

    public RangeBasedOnSTR(Element element) {
        super(element, xmlID);
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject instanceof Multipower || genericObject instanceof ElementalControl) {
            return "";
        }
        if (genericObject instanceof Duplication) {
            return this.getDisplay() + " cannot be applied to Duplication.";
        }
        if (genericObject instanceof HandToHandAttack) {
            return this.getDisplay() + " cannot be applied to HTH Attack.";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "RANGED") != null) {
            return this.getDisplay() + " cannot be applied to Powers that have taken the Ranged Advantage.  Use the options on the Ranged Advantage instead.";
        }
        if (genericObject.getRangeValue() == 0) {
            return this.getDisplay() + " can only be applied to Ranged Powers.";
        }
        return "";
    }
}

