/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import org.jdom.Element;

public class Persistent
extends Modifier {
    private static String xmlID = "PERSISTENT";

    public Persistent(Element element) {
        super(element, xmlID);
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject.getXMLID().equals("COMBAT_LEVELS")) {
            return this.getDisplay() + " cannot be applied to Combat Skill Levels of any form.";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "UOO") != null) {
            return "";
        }
        if (genericObject.getEndUsage() > 0) {
            if (HeroDesigner.getActiveTemplate().is6E()) {
                if (!genericObject.costsENDToMaintain()) {
                    return this.getDisplay() + " cannot be applied to Powers which cost END only to Activate.";
                }
            } else {
                return this.getDisplay() + " cannot be applied to Powers which cost END.";
            }
        }
        if (HeroDesigner.getActiveTemplate().is6E() && genericObject.getDuration().equals("INSTANT") && !genericObject.continuingEffect()) {
            return this.getDisplay() + " cannot be applied to Instant Powers -- apply Constant first.";
        }
        if (genericObject.getDuration().equals("PERSISTENT") || genericObject.getOrigDuration().equals("PERSISTENT")) {
            return genericObject.getDisplay() + " is already Persistent.";
        }
        if (genericObject.getDuration().equals("INHERENT") && GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "INHERENT") == null) {
            return genericObject.getDisplay() + " is already Inherent.";
        }
        return string;
    }
}

