/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Body;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.Def;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Clairsentience;
import com.hero.util.Rounder;
import org.jdom.Element;

public class PartialCoverage
extends Modifier {
    private static String xmlID = "PARTIALCOVERAGE";

    public PartialCoverage(Element element) {
        super(element, xmlID);
    }

    private double getArea(int n) {
        Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(15);
        if (HeroDesigner.getActiveTemplate().is6E()) {
            double d = 8.0;
            if (n > 0) {
                d *= Math.pow(characteristic.getHeightIncrease(), (double)n / (double)characteristic.getHeightIncreaseLevels());
            }
            double d2 = 4.0;
            if (n > 0) {
                d2 *= Math.pow(characteristic.getWidthIncrease(), (double)n / (double)characteristic.getWidthIncreaseLevels());
            }
            double d3 = d * d2;
            double d4 = d * d2 * d2;
            return d4;
        }
        int n2 = n;
        double d = 4.0;
        if (n2 != 0) {
            d *= Math.pow(characteristic.getHeightIncrease(), (double)n2 / (double)characteristic.getHeightIncreaseLevels());
        }
        double d5 = 2.0;
        if (n2 != 0) {
            d5 *= Math.pow(characteristic.getWidthIncrease(), (double)n2 / (double)characteristic.getWidthIncreaseLevels());
        }
        double d6 = d * d5;
        return d6;
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        if (!this.showOptionOnly) {
            string2 = string2 + this.getAlias();
        }
        double d = this.getTotalValue();
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + " ";
            }
            string2 = string2 + this.getInput();
        }
        string2 = string2.trim();
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        int n = 0;
        int n2 = 0;
        while (string2.indexOf("(", n) >= 0) {
            ++n2;
            n = string2.indexOf("(", n) + 1;
        }
        n = 0;
        while (string2.indexOf(")", n) >= 0) {
            --n2;
            n = string2.indexOf(")", n) + 1;
        }
        string2 = n2 <= 0 ? string2 + " (" : string2 + "; ";
        string2 = HeroDesigner.getActiveTemplate().is6E() ? string2 + "covers " + this.getLevels() + " m^3; " : string2 + "covers " + this.getLevels() + " Hexes; ";
        if (this.getSelectedOption() != null && this.getSelectedOption().displayInString() && this.getSelectedOption().getAlias().trim().length() > 0) {
            string2 = string2 + this.getSelectedOption().getAlias() + "; ";
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isSelected() || adder.getColumn2Output().trim().length() <= 0) continue;
            string2 = string2 + adder.getColumn2Output().trim() + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        if (d > this.maxCost && this.maxSet) {
            d = this.maxCost;
        }
        if (d < this.minimumCost && this.minSet) {
            d = this.minimumCost;
        }
        string2 = string2 + this.getFraction(d) + ")";
        --n2;
        while (n2 > 0) {
            string2 = string2 + ")";
            --n2;
        }
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public int getMaxLevel() {
        Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(15);
        int n = (int)Rounder.roundHalfUp(characteristic.getPrimaryValue());
        double d = this.getArea(n);
        return (int)Rounder.roundHalfUp(d);
    }

    private int getSizeLevels() {
        Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(15);
        int n = (int)Rounder.roundHalfUp(characteristic.getPrimaryValue());
        double d = this.getArea(n);
        int n2 = 0;
        while ((double)this.getLevels() < d && n2 < n) {
            d = this.getArea(n - ++n2);
        }
        if (this.getArea(n - n2) < (double)this.getLevels()) {
            --n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    @Override
    public double getTotalValue() {
        double d = this.getBaseCost();
        for (Adder adder : this.getAssignedAdders()) {
            d += adder.getDoubleTotal();
        }
        if (this.getLevelValue() > 0.0) {
            d += (double)this.getSizeLevels() / this.getLevelValue() * this.getLevelCost();
        }
        double d2 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        double d3 = d * (1.0 + d2);
        double d4 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d4 += Math.abs(modifier.getTotalValue());
        }
        d = d3 / (1.0 + d4);
        d *= 4.0;
        int n = 1;
        if (d < 0.0) {
            n = -1;
        }
        d *= (double)n;
        d = Rounder.roundHalfUp(d);
        d *= (double)n;
        if ((d /= 4.0) < this.getMinimumCost() && this.isMinSet()) {
            return this.getMinimumCost();
        }
        if (d > this.getMaxCost() && this.isMaxSet()) {
            return this.getMaxCost();
        }
        return d;
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (!(genericObject instanceof Body || genericObject instanceof Def || genericObject instanceof Clairsentience || genericObject.getTypes().contains("DEFENSE"))) {
            return this.getDisplay() + " may only be applied to BODY, Clairsentience, and Defense Powers.";
        }
        return "";
    }
}

