/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Duplication;
import org.jdom.Element;

public class NoRange
extends Modifier {
    private static String xmlID = "NORANGE";

    public NoRange(Element element) {
        super(element, xmlID);
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject instanceof Multipower || genericObject instanceof ElementalControl) {
            return "";
        }
        if (genericObject instanceof Duplication) {
            return this.getDisplay() + " cannot be applied to Duplication.";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "RANGED") != null) {
            return this.getDisplay() + " cannot be applied to Powers that have taken the Ranged Advantage.";
        }
        if (genericObject.getRangeValue() == 0) {
            return this.getDisplay() + " can only be applied to Ranged Powers.";
        }
        return "";
    }
}

