/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.disads.Disadvantage;
import com.hero.objects.modifiers.AVAD;
import com.hero.objects.modifiers.AVLD;
import com.hero.objects.modifiers.ActivationRoll;
import com.hero.objects.modifiers.AffectsDesolid;
import com.hero.objects.modifiers.AffectsPhysicalWorld;
import com.hero.objects.modifiers.AlternateCombatValue;
import com.hero.objects.modifiers.AlwaysOn;
import com.hero.objects.modifiers.AreaEffect;
import com.hero.objects.modifiers.ArmorPiercing;
import com.hero.objects.modifiers.Autofire;
import com.hero.objects.modifiers.BasedOnECV;
import com.hero.objects.modifiers.Beam;
import com.hero.objects.modifiers.CanBeMissileDeflected;
import com.hero.objects.modifiers.CannotEscapeWithTeleport;
import com.hero.objects.modifiers.Charges;
import com.hero.objects.modifiers.Concentration;
import com.hero.objects.modifiers.Continuous;
import com.hero.objects.modifiers.CostsEND;
import com.hero.objects.modifiers.CostsENDOnlyToActivate;
import com.hero.objects.modifiers.CostsENDToMaintain;
import com.hero.objects.modifiers.Cumulative;
import com.hero.objects.modifiers.DamageOverTime;
import com.hero.objects.modifiers.DamageShield;
import com.hero.objects.modifiers.DelayedEND;
import com.hero.objects.modifiers.DelayedEffect;
import com.hero.objects.modifiers.DelayedReturnRate;
import com.hero.objects.modifiers.DifficultToDispel;
import com.hero.objects.modifiers.DoesBODY;
import com.hero.objects.modifiers.DoesKB;
import com.hero.objects.modifiers.DoesNotProvideMentalAwareness;
import com.hero.objects.modifiers.DoubleEnduranceCost;
import com.hero.objects.modifiers.DoubleKB;
import com.hero.objects.modifiers.Dropped;
import com.hero.objects.modifiers.ENDReserveOrEND;
import com.hero.objects.modifiers.Explosion;
import com.hero.objects.modifiers.ExtraTime;
import com.hero.objects.modifiers.Feedback;
import com.hero.objects.modifiers.Focus;
import com.hero.objects.modifiers.Gestures;
import com.hero.objects.modifiers.HalfRangeModifier;
import com.hero.objects.modifiers.Hardened;
import com.hero.objects.modifiers.HoleInTheMiddle;
import com.hero.objects.modifiers.Incantations;
import com.hero.objects.modifiers.IncreasedEND;
import com.hero.objects.modifiers.IncreasedMaxRange;
import com.hero.objects.modifiers.Indirect;
import com.hero.objects.modifiers.Inherent;
import com.hero.objects.modifiers.Instant;
import com.hero.objects.modifiers.Invisible;
import com.hero.objects.modifiers.LimitedArcOfFire;
import com.hero.objects.modifiers.LimitedRange;
import com.hero.objects.modifiers.LineOfSight;
import com.hero.objects.modifiers.Lingering;
import com.hero.objects.modifiers.Linked;
import com.hero.objects.modifiers.Megascale;
import com.hero.objects.modifiers.Mobile;
import com.hero.objects.modifiers.NND;
import com.hero.objects.modifiers.NoKB;
import com.hero.objects.modifiers.NoRange;
import com.hero.objects.modifiers.NoRangeModifier;
import com.hero.objects.modifiers.Nonpersistent;
import com.hero.objects.modifiers.NormalRange;
import com.hero.objects.modifiers.NotThroughMindLink;
import com.hero.objects.modifiers.OnlyOnAppropriateTerrain;
import com.hero.objects.modifiers.OnlyToActivate;
import com.hero.objects.modifiers.OnlyToStarting;
import com.hero.objects.modifiers.OthersOnly;
import com.hero.objects.modifiers.PartialCoverage;
import com.hero.objects.modifiers.Penetrating;
import com.hero.objects.modifiers.Persistent;
import com.hero.objects.modifiers.PersonalImmunity;
import com.hero.objects.modifiers.PhysicalManifestation;
import com.hero.objects.modifiers.RangeBasedOnSTR;
import com.hero.objects.modifiers.Ranged;
import com.hero.objects.modifiers.RealWeapon;
import com.hero.objects.modifiers.ReducedByRange;
import com.hero.objects.modifiers.ReducedEND;
import com.hero.objects.modifiers.RequiredHands;
import com.hero.objects.modifiers.RequiresSkillRoll;
import com.hero.objects.modifiers.Restrainable;
import com.hero.objects.modifiers.SelfOnly;
import com.hero.objects.modifiers.SemiArmorPiercing;
import com.hero.objects.modifiers.SideEffects;
import com.hero.objects.modifiers.Sticky;
import com.hero.objects.modifiers.SubjectToRangeModifier;
import com.hero.objects.modifiers.TimeLimit;
import com.hero.objects.modifiers.Transdimensional;
import com.hero.objects.modifiers.Transparent;
import com.hero.objects.modifiers.Trigger;
import com.hero.objects.modifiers.TurnMode;
import com.hero.objects.modifiers.Uncontrolled;
import com.hero.objects.modifiers.UsableOnOthers;
import com.hero.objects.modifiers.VariableAdvantage;
import com.hero.objects.modifiers.VariableEffect;
import com.hero.objects.modifiers.VariableLimitations;
import com.hero.objects.modifiers.VariableTarget;
import com.hero.objects.modifiers.Visible;
import com.hero.objects.powers.NakedModifier;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class Modifier
extends GenericObject {
    protected boolean isLimitation;
    protected boolean isLimitationSet;
    protected boolean availableCheck;
    protected boolean isMultiplier;
    protected ArrayList<String> excludes;
    protected GenericObject parent;
    protected ArrayList<String> requires;
    protected String duration;
    protected boolean requiresAll;
    protected boolean fullDisplay;
    protected boolean showOptionOnly;
    protected boolean showOptionInParens;
    protected boolean showInputInParens;
    protected boolean privateMod;
    protected boolean displayInString = true;
    protected String comments;
    protected boolean forceAllow = false;

    public static Modifier getInstance(Element element) {
        String string = XMLUtility.getValue(element, "XMLID");
        if (string == null || string.trim().length() == 0) {
            string = "GENERIC_OBJECT";
        }
        if ((string = string.trim().toUpperCase()).equals("ONLYTOACTIVATE")) {
            return new OnlyToActivate(element);
        }
        if (string.equals("TIMELIMIT")) {
            return new TimeLimit(element);
        }
        if (string.equals("HALFRANGEMODIFIER")) {
            return new HalfRangeModifier(element);
        }
        if (string.equals("DAMAGEOVERTIME")) {
            return new DamageOverTime(element);
        }
        if (string.equals("AVAD")) {
            return new AVAD(element);
        }
        if (string.equals("DOUBLEENDCOST")) {
            return new DoubleEnduranceCost(element);
        }
        if (string.equals("PHYSICALMANIFESTATION")) {
            return new PhysicalManifestation(element);
        }
        if (string.equals("TRANSPARENT")) {
            return new Transparent(element);
        }
        if (string.equals("SEMIARMORPIERCING")) {
            return new SemiArmorPiercing(element);
        }
        if (string.equals("PARTIALCOVERAGE")) {
            return new PartialCoverage(element);
        }
        if (string.equals("NOTELEPORT")) {
            return new CannotEscapeWithTeleport(element);
        }
        if (string.equals("LIMITEDARCOFFIRE")) {
            return new LimitedArcOfFire(element);
        }
        if (string.equals("REQUIREDHANDS")) {
            return new RequiredHands(element);
        }
        if (string.equals("REALWEAPON")) {
            return new RealWeapon(element);
        }
        if (string.equals("MOBILE")) {
            return new Mobile(element);
        }
        if (string.equals("LINGERING")) {
            return new Lingering(element);
        }
        if (string.equals("VARIABLETARGETS")) {
            return new VariableTarget(element);
        }
        if (string.equals("FEEDBACK")) {
            return new Feedback(element);
        }
        if (string.equals("ONLYONAPPROPRIATETERRAIN")) {
            return new OnlyOnAppropriateTerrain(element);
        }
        if (string.equals("DROPPED")) {
            return new Dropped(element);
        }
        if (string.equals("DELAYEDRETURNRATE")) {
            return new DelayedReturnRate(element);
        }
        if (string.equals("VARIABLEEFFECT")) {
            return new VariableEffect(element);
        }
        if (string.equals("ONLYTOSTARTING")) {
            return new OnlyToStarting(element);
        }
        if (string.equals("SELFONLY")) {
            return new SelfOnly(element);
        }
        if (string.equals("OTHERSONLY")) {
            return new OthersOnly(element);
        }
        if (string.equals("BEAM")) {
            return new Beam(element);
        }
        if (string.equals("CANBEMISSILEDEFLECTED")) {
            return new CanBeMissileDeflected(element);
        }
        if (string.equals("NOKB")) {
            return new NoKB(element);
        }
        if (string.equals("COSTSENDONLYTOACTIVATE")) {
            return new CostsENDOnlyToActivate(element);
        }
        if (string.equals("HARDENED")) {
            return new Hardened(element);
        }
        if (string.equals("DOESNOTPROVIDEMENTALAWARENESS")) {
            return new DoesNotProvideMentalAwareness(element);
        }
        if (string.equals("NOTTHROUGHMINDLINK")) {
            return new NotThroughMindLink(element);
        }
        if (string.equals("COSTSENDTOMAINTAIN")) {
            return new CostsENDToMaintain(element);
        }
        if (string.equals("NORMALRANGE")) {
            return new NormalRange(element);
        }
        if (string.equals("TURNMODE")) {
            return new TurnMode(element);
        }
        if (string.equals("AFFECTSDESOLID")) {
            return new AffectsDesolid(element);
        }
        if (string.equals("AOE")) {
            return new AreaEffect(element);
        }
        if (string.equals("ARMORPIERCING")) {
            return new ArmorPiercing(element);
        }
        if (string.equals("AVLD")) {
            return new AVLD(element);
        }
        if (string.equals("AUTOFIRE")) {
            return new Autofire(element);
        }
        if (string.equals("BOECV")) {
            return new BasedOnECV(element);
        }
        if (string.equals("CUMULATIVE")) {
            return new Cumulative(element);
        }
        if (string.equals("DAMAGESHIELD")) {
            return new DamageShield(element);
        }
        if (string.equals("DELAYEDEFFECT")) {
            return new DelayedEffect(element);
        }
        if (string.equals("DIFFICULTTODISPEL")) {
            return new DifficultToDispel(element);
        }
        if (string.equals("DOESBODY")) {
            return new DoesBODY(element);
        }
        if (string.equals("DOESKB")) {
            return new DoesKB(element);
        }
        if (string.equals("DOUBLEKB")) {
            return new DoubleKB(element);
        }
        if (string.equals("CONTINUOUS")) {
            return new Continuous(element);
        }
        if (string.equals("PERSISTENT")) {
            return new Persistent(element);
        }
        if (string.equals("INHERENT")) {
            return new Inherent(element);
        }
        if (string.equals("EXPLOSION")) {
            return new Explosion(element);
        }
        if (string.equals("HOLEINTHEMIDDLE")) {
            return new HoleInTheMiddle(element);
        }
        if (string.equals("INDIRECT")) {
            return new Indirect(element);
        }
        if (string.equals("INVISIBLE")) {
            return new Invisible(element);
        }
        if (string.equals("MEGASCALE")) {
            return new Megascale(element);
        }
        if (string.equals("NND")) {
            return new NND(element);
        }
        if (string.equals("PENETRATING")) {
            return new Penetrating(element);
        }
        if (string.equals("PERSONALIMMUNITY")) {
            return new PersonalImmunity(element);
        }
        if (string.equals("INCREASEDMAXRANGE")) {
            return new IncreasedMaxRange(element);
        }
        if (string.equals("LOS")) {
            return new LineOfSight(element);
        }
        if (string.equals("NORANGEMODIFIER")) {
            return new NoRangeModifier(element);
        }
        if (string.equals("RANGED")) {
            return new Ranged(element);
        }
        if (string.equals("REDUCEDEND")) {
            return new ReducedEND(element);
        }
        if (string.equals("DELAYEDEND")) {
            return new DelayedEND(element);
        }
        if (string.equals("STICKY")) {
            return new Sticky(element);
        }
        if (string.equals("TRANSDIMENSIONAL")) {
            return new Transdimensional(element);
        }
        if (string.equals("TRIGGER")) {
            return new Trigger(element);
        }
        if (string.equals("UNCONTROLLED")) {
            return new Uncontrolled(element);
        }
        if (string.equals("UOO")) {
            return new UsableOnOthers(element);
        }
        if (string.equals("VARIABLEADVANTAGE")) {
            return new VariableAdvantage(element);
        }
        if (string.equals("ACTIVATIONROLL")) {
            return new ActivationRoll(element);
        }
        if (string.equals("ALWAYSON")) {
            return new AlwaysOn(element);
        }
        if (string.equals("CHARGES")) {
            return new Charges(element);
        }
        if (string.equals("CONCENTRATION")) {
            return new Concentration(element);
        }
        if (string.equals("INSTANT")) {
            return new Instant(element);
        }
        if (string.equals("NONPERSISTENT")) {
            return new Nonpersistent(element);
        }
        if (string.equals("COSTSEND")) {
            return new CostsEND(element);
        }
        if (string.equals("INCREASEDEND")) {
            return new IncreasedEND(element);
        }
        if (string.equals("EXTRATIME")) {
            return new ExtraTime(element);
        }
        if (string.equals("FOCUS")) {
            return new Focus(element);
        }
        if (string.equals("GESTURES")) {
            return new Gestures(element);
        }
        if (string.equals("INCANTATIONS")) {
            return new Incantations(element);
        }
        if (string.equals("LINKED")) {
            return new Linked(element);
        }
        if (string.equals("NORANGE")) {
            return new NoRange(element);
        }
        if (string.equals("LIMITEDRANGE")) {
            return new LimitedRange(element);
        }
        if (string.equals("RANGEBASEDONSTR")) {
            return new RangeBasedOnSTR(element);
        }
        if (string.equals("REDUCEDBYRANGE")) {
            return new ReducedByRange(element);
        }
        if (string.equals("SUBJECTTORANGEMODIFIER")) {
            return new SubjectToRangeModifier(element);
        }
        if (string.equals("REQUIRESASKILLROLL")) {
            return new RequiresSkillRoll(element);
        }
        if (string.equals("RESTRAINABLE")) {
            return new Restrainable(element);
        }
        if (string.equals("SIDEEFFECTS")) {
            return new SideEffects(element);
        }
        if (string.equals("VARIABLELIMITATIONS")) {
            return new VariableLimitations(element);
        }
        if (string.equals("VISIBLE")) {
            return new Visible(element);
        }
        if (string.equals("AFFECTSPHYSICALWORLD")) {
            return new AffectsPhysicalWorld(element);
        }
        if (string.equals("ENDRESERVEOREND")) {
            return new ENDReserveOrEND(element);
        }
        if (string.equals("ACV")) {
            return new AlternateCombatValue(element);
        }
        return new Modifier(element);
    }

    protected Modifier(Element element) {
        super(element);
        this.privateMod = this.getTypes().contains("VPP") || this.getTypes().contains("MP") || this.getTypes().contains("EC") || this.getTypes().contains("LIST");
        this.xmlID = "MODIFIER";
        String string = XMLUtility.getValue(element, "XMLID");
        if (string != null && string.trim().length() > 0) {
            this.xmlID = string;
        }
        if ((string = XMLUtility.getValue(element, "ISLIMITATION")) != null && string.trim().length() > 0) {
            this.isLimitationSet = true;
            this.isLimitation = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "MINCOST")) == null || string.trim().length() == 0) {
            this.minimumCost = -10.0;
        }
        if ((string = XMLUtility.getValue(element, "MAXCOST")) == null || string.trim().length() == 0) {
            this.maxCost = 10.0;
        }
        this.minSet = true;
        this.maxSet = true;
        string = XMLUtility.getValue(element, "FIXEDVALUE");
        if (string == null || string.trim().length() == 0) {
            this.fixedValue = true;
        }
        this.resetID();
    }

    protected Modifier(Element element, String string) {
        super(element);
        String string2 = XMLUtility.getValue(element, "XMLID");
        if (!string2.equals(string)) {
            System.out.println("Error initing " + string + ", check = " + string2);
        }
    }

    @Override
    public Modifier clone() {
        Modifier modifier = (Modifier)super.clone();
        modifier.setParent(this.parent);
        modifier.setSelectedOption(this.getSelectedOption());
        modifier.setForceAllow(this.forceAllow);
        return modifier;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Modifier) {
            return this.toString().compareTo(object.toString());
        }
        return this.toString().compareTo(object.toString());
    }

    @Override
    public boolean containsType(String string) {
        if (this.types == null) {
            this.types = new ArrayList();
        }
        if (this.types.size() == 0) {
            return true;
        }
        return this.types.contains(string);
    }

    public boolean displayInString() {
        return this.displayInString;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        Modifier modifier;
        block8: {
            if (!(object instanceof Modifier)) return false;
            modifier = (Modifier)object;
            if (modifier.getXMLID().equals(this.getXMLID())) {
                if (!(this.getXMLID().equals("CUSTOM_MODIFIER") || this.getXMLID().equals("GENERIC_OBJECT") || this.getXMLID().equals("MODIFIER"))) {
                    if (this.isAvailableCheck()) return true;
                    if (modifier.isAvailableCheck()) {
                        return true;
                    }
                    if (!this.isAvailableCheck() && !modifier.isAvailableCheck()) {
                        if (this.getID() != modifier.getID()) return false;
                        return true;
                    }
                    break block8;
                } else {
                    if (modifier.getID() != this.getID()) return false;
                    return true;
                }
            }
            if (!(this.getXMLID().equals("CUSTOM_MODIFIER") || this.getXMLID().equals("GENERIC_OBJECT") || modifier.getXMLID().equals("GENERIC_OBJECT") || modifier.getXMLID().equals("CUSTOM_MODIFIER"))) {
                return false;
            }
            if (!this.getXMLID().equals(modifier.getXMLID())) {
                return false;
            }
        }
        if (this.isAvailableCheck()) return this.getDisplay().equals(modifier.getDisplay());
        if (modifier.isAvailableCheck()) {
            return this.getDisplay().equals(modifier.getDisplay());
        }
        if (!this.getAlias().equals(modifier.getAlias())) return false;
        if (this.getBaseCost() != modifier.getBaseCost()) return false;
        return true;
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        if (!this.showOptionOnly) {
            string2 = string2 + this.getAlias();
        }
        double d = this.getTotalValue();
        if (!this.showOptionInParens && this.getSelectedOption() != null && this.getSelectedOption().displayInString() && this.getSelectedOption().getAlias().trim().length() > 0) {
            string2 = string2 + " " + this.getSelectedOption().getAlias();
            string2 = string2.trim();
        }
        if (!this.showInputInParens && this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + " ";
            }
            string2 = string2 + this.getInput();
        }
        string2 = string2.trim();
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        int n = 0;
        int n2 = 0;
        while (string2.indexOf("(", n) >= 0) {
            ++n2;
            n = string2.indexOf("(", n) + 1;
        }
        n = 0;
        while (string2.indexOf(")", n) >= 0) {
            --n2;
            n = string2.indexOf(")", n) + 1;
        }
        string2 = n2 <= 0 ? string2 + " (" : string2 + "; ";
        if (this.showOptionInParens && this.getSelectedOption() != null && this.getSelectedOption().displayInString() && this.getSelectedOption().getAlias().trim().length() > 0) {
            string2 = string2 + this.getSelectedOption().getAlias().trim() + "; ";
        }
        if (this.showInputInParens && this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + this.getInput() + "; ";
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isSelected() || adder.getColumn2Output().trim().length() <= 0) continue;
            string2 = string2 + adder.getColumn2Output().trim() + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        if (d > this.maxCost && this.maxSet) {
            d = this.maxCost;
        }
        if (d < this.minimumCost && this.minSet) {
            d = this.minimumCost;
        }
        string2 = string2 + this.getFraction(d) + ")";
        --n2;
        while (n2 > 0) {
            string2 = string2 + ")";
            --n2;
        }
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    public String getComments() {
        if (this.comments == null) {
            this.comments = "";
        }
        return this.comments;
    }

    public ModifierDialog getDialog(GenericObject genericObject, boolean bl) {
        return new ModifierDialog(this, bl, genericObject);
    }

    public ArrayList<String> getExcludes() {
        return this.excludes;
    }

    public String getFraction(double d) {
        return this.getFraction(d, this.useMultiplier());
    }

    private String getFraction(double d, boolean bl) {
        String string = "";
        String string2 = "";
        if (HeroDesigner.getInstance().getPrefs().flagForcedModifiers() && this.forceAllow()) {
            string2 = "*";
        }
        if (d == 0.0) {
            if (bl) {
                return "x1" + string2;
            }
            if (this.isLimitation()) {
                return "-0" + string2;
            }
            return "+0" + string2;
        }
        if (bl) {
            string = "x";
            boolean bl2 = false;
            if (d < 0.0) {
                bl2 = true;
                d = Math.abs(d);
            }
            String string3 = "";
            long l = Rounder.roundDown(d + 1.0E-7);
            if ((double)l < d) {
                GenericObject genericObject = this.parent;
                this.parent = null;
                string3 = this.getFraction(d - (double)l, false);
                this.parent = genericObject;
                if (string3.startsWith("+")) {
                    string3 = string3.substring(1, string3.length());
                }
            }
            if (string3.trim().length() > 0) {
                string3 = " " + string3;
            }
            string = bl2 ? string + "1/" + l + string3 : string + ++l + string3;
            return string + string2;
        }
        string = d < 0.0 ? string + "-" : string + "+";
        if ((d = Math.abs(d)) > 1.0) {
            string = this.useMultiplier() ? string + (int)Rounder.roundDown(d + 1.0) : string + (int)Rounder.roundDown(d);
            d -= (double)Rounder.roundDown(d);
        }
        if (d == 0.0) {
            return string + string2;
        }
        String string4 = "";
        double d2 = 1.0;
        if (Math.abs(0.25 - d) < d2) {
            d2 = Math.abs(0.25 - d);
            string4 = "1/4";
        }
        if (Math.abs(0.5 - d) < d2) {
            d2 = Math.abs(0.5 - d);
            string4 = "1/2";
        }
        if (Math.abs(0.75 - d) < d2) {
            d2 = Math.abs(0.75 - d);
            string4 = "3/4";
        }
        if (Math.abs(1.0 - d) < d2) {
            string4 = "";
            if (string.length() > 1) {
                int n = Integer.parseInt(string.substring(1, string.length()));
                string = string.substring(0, 1) + (n + 1);
            } else {
                string = string.length() == 1 && !string.equals("+") && !string.equals("-") && !string.equals("x") ? "" + (Integer.parseInt(string) + 1) : (string.trim().length() == 0 || string.trim().equals("+") ? "+1" : "-1");
            }
        }
        if (string.length() > 1) {
            string = string + " ";
        }
        string = string + string4;
        string = string.trim();
        return string + string2;
    }

    public String getLevelInfo() {
        return "";
    }

    @Override
    public double getMaxCost() {
        if (this.getXMLID().equals("GENERIC_OBJECT") || this.getXMLID().equals("CUSTOM_MODIFIER")) {
            return 10.0;
        }
        return super.getMaxCost();
    }

    @Override
    public double getMinimumCost() {
        if (this.getXMLID().equals("GENERIC_OBJECT") || this.getXMLID().equals("CUSTOM_MODIFIER")) {
            return -10.0;
        }
        return super.getMinimumCost();
    }

    public GenericObject getProgenitor() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof Modifier) {
            return ((Modifier)this.parent).getProgenitor();
        }
        return this.parent;
    }

    public ArrayList<String> getRequires() {
        return this.requires;
    }

    public void setForceAllow(boolean bl) {
        this.forceAllow = bl;
    }

    public boolean forceAllow() {
        return this.forceAllow;
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("MODIFIER");
        element.setAttribute("COMMENTS", this.getComments());
        element.setAttribute("PRIVATE", this.isPrivate() ? "Yes" : "No");
        element.setAttribute("FORCEALLOW", this.forceAllow() ? "Yes" : "No");
        return element;
    }

    public double getTotalValue() {
        double d = this.getBaseCost();
        for (Adder adder : this.getAssignedAdders()) {
            d += adder.getDoubleTotal();
        }
        if (this.getLevelValue() > 0.0) {
            d += (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
        }
        double d2 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        double d3 = d * (1.0 + d2);
        double d4 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d4 += Math.abs(modifier.getTotalValue());
        }
        d = d3 / (1.0 + d4);
        d *= 4.0;
        int n = 1;
        if (d < 0.0) {
            n = -1;
        }
        d *= (double)n;
        d = Rounder.roundHalfUp(d);
        d *= (double)n;
        if ((d /= 4.0) < this.getMinimumCost() && this.isMinSet()) {
            return this.getMinimumCost();
        }
        if (d > this.getMaxCost() && this.isMaxSet()) {
            return this.getMaxCost();
        }
        return d;
    }

    @Override
    public int hashCode() {
        return this.getXMLID().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public String included(GenericObject genericObject) {
        Cloneable cloneable;
        String string = "";
        boolean bl = false;
        if (genericObject == null) {
            return "";
        }
        if (genericObject instanceof Modifier) {
            bl = true;
            cloneable = (Modifier)genericObject;
            if ((genericObject = ((Modifier)cloneable).getProgenitor()) == null) {
                return "";
            }
        }
        if (this.forceAllow()) {
            return string;
        }
        if (this.duration != null && this.duration.trim().length() > 0) {
            if (this.duration.equalsIgnoreCase("INSTANT")) {
                if (!genericObject.getDuration().equals("INSTANT")) {
                    return this.getDisplay() + " can only be applied to Instant Powers.";
                }
            } else if (this.duration.equalsIgnoreCase("CONSTANT")) {
                if (genericObject.getDuration().equals("INSTANT")) {
                    return this.getDisplay() + " can only be applied to Constant Powers.";
                }
            } else if (this.duration.equalsIgnoreCase("PERSISTENT")) {
                if (genericObject.getDuration().equals("INSTANT") || genericObject.getDuration().equals("CONSTANT")) {
                    return this.getDisplay() + " can only be applied to Persistent Powers.";
                }
            } else if (this.duration.equalsIgnoreCase("INHERENT") && (genericObject.getDuration().equals("INSTANT") || genericObject.getDuration().equals("CONSTANT") || genericObject.getDuration().equals("PERSISTENT"))) {
                return this.getDisplay() + " can only be applied to Inherent Powers.";
            }
        }
        if (genericObject instanceof ElementalControl && !this.isLimitation() && !bl) {
            return this.getDisplay() + " cannot be applied to an Elemental Control.  Advantages should be applied to each slot individually.";
        }
        if (this.types == null || this.types.size() == 0 || genericObject instanceof List) {
            string = this.types == null || this.types.size() == 0 ? "" : (!(genericObject instanceof VariablePowerPool) && this.types.contains("VPP") ? this.getDisplay() + " can only be applied to a Variable Power Pool." : (!(genericObject instanceof Multipower) && this.types.contains("MP") ? this.getDisplay() + " can only be applied to a Multipower." : (!(genericObject instanceof ElementalControl) && this.types.contains("EC") ? this.getDisplay() + " can only be applied to an Elemental Control." : (!(genericObject instanceof List) && this.types.contains("LIST") ? this.getDisplay() + " can only be applied to a List." : ""))));
        } else {
            string = this.getDisplay() + " can only be applied to abilities of type ";
            for (int i = 0; i < this.types.size(); ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                if (i == this.types.size() - 1 && i > 0) {
                    string = string + "or ";
                }
                string = string + ((String)this.types.get(i)).toString().toLowerCase();
            }
            cloneable = genericObject.getTypes();
            if (cloneable == null) {
                cloneable = new ArrayList();
            }
            for (String string2 : cloneable) {
                if (!this.containsType(string2)) continue;
                string = "";
            }
        }
        if (string.trim().length() == 0) {
            Cloneable cloneable2;
            Object object;
            Cloneable cloneable32;
            if (this.excludes == null) {
                this.excludes = new ArrayList();
            }
            for (String string3 : this.excludes) {
                String string4 = string3.toUpperCase().trim();
                ArrayList<Modifier> arrayList = genericObject.getAssignedModifiers();
                for (Cloneable cloneable32 : arrayList) {
                    if (!((GenericObject)cloneable32).getXMLID().toUpperCase().trim().equals(string4)) continue;
                    return this.getDisplay() + " cannot be applied to abilties which have " + ((GenericObject)cloneable32).getDisplay();
                }
                if (genericObject.getXMLID().toUpperCase().trim().equals(string4)) {
                    return this.getDisplay() + " cannot be applied to " + genericObject.getDisplay();
                }
                object = genericObject.getAssignedAdders();
                cloneable32 = ((ArrayList)object).iterator();
                while (cloneable32.hasNext()) {
                    cloneable2 = (Adder)cloneable32.next();
                    if (!((GenericObject)cloneable2).getXMLID().toUpperCase().trim().equals(string4) || !((Adder)cloneable2).isSelected()) continue;
                    return this.getDisplay() + " cannot be applied to abilties which have " + ((GenericObject)cloneable2).getDisplay();
                }
            }
            if (this.requires == null) {
                this.requires = new ArrayList();
            }
            if (this.requires.size() > 0) {
                string = this.requires.size() > 1 ? (this.requiresAll ? this.getDisplay() + " requires the following modifiers:  " : this.getDisplay() + " requires at least one of the following: ") : this.getDisplay() + " requires " + this.requires.get(0);
                for (int i = 0; i < this.requires.size(); ++i) {
                    if (i > 0) {
                        string = string + ", ";
                    }
                    if (i == this.requires.size() - 1) {
                        string = string + (this.requiresAll ? "and " : "or ");
                    }
                    string = string + this.requires.get(i);
                }
            }
            boolean bl2 = false;
            block6: for (String string5 : this.requires) {
                void var6_20;
                String string6 = string5.toUpperCase().trim();
                object = null;
                if (string6.indexOf(".") > 0 && string6.indexOf(".") < string6.length() - 1) {
                    object = string6.substring(string6.indexOf(".") + 1, string6.length());
                    if (((String)object).trim().length() == 0) {
                        object = null;
                    }
                    String string7 = string6.substring(0, string6.indexOf("."));
                }
                if (genericObject.getXMLID().toUpperCase().trim().equals(var6_20) && (object == null || genericObject.getSelectedOption() != null && genericObject.getSelectedOption().getXMLID().equalsIgnoreCase((String)object))) {
                    if (this.requiresAll) continue;
                    string = "";
                    break;
                }
                cloneable32 = genericObject.getAssignedModifiers();
                for (Modifier modifier : cloneable32) {
                    if (!modifier.getXMLID().toUpperCase().trim().equals(var6_20) || object != null && (modifier.getSelectedOption() == null || !modifier.getSelectedOption().getXMLID().equalsIgnoreCase((String)object))) continue;
                    if (this.requiresAll) continue block6;
                    string = "";
                    break block6;
                }
                cloneable2 = genericObject.getAssignedAdders();
                for (Adder adder : cloneable2) {
                    if (!adder.getXMLID().toUpperCase().trim().equals(var6_20) || object != null && (adder.getSelectedOption() == null || !adder.getSelectedOption().getXMLID().equalsIgnoreCase((String)object))) continue;
                    if (this.requiresAll) continue block6;
                    string = "";
                    break block6;
                }
                bl2 = true;
                if (!this.requiresAll) continue;
                break;
            }
            if (!bl2) {
                string = "";
            }
        }
        return string;
    }

    @Override
    protected void init(Element element) {
        this.requires = new ArrayList();
        this.excludes = new ArrayList();
        this.fullDisplay = false;
        this.showOptionOnly = false;
        super.init(element);
        this.availableCheck = false;
        String string = XMLUtility.getValue(element, "XMLID");
        if (string != null && string.trim().length() > 0) {
            this.setXMLID(string);
        }
        if ((string = XMLUtility.getValue(element, "SHOWOPTIONONLY")) != null && string.trim().toUpperCase().startsWith("Y")) {
            this.showOptionOnly = true;
        }
        if ((string = XMLUtility.getValue(element, "DURATION")) != null && string.trim().length() > 0) {
            this.duration = string;
        }
        this.showOptionInParens = (string = XMLUtility.getValue(element, "SHOWOPTIONINPARENS")) != null && string.trim().toUpperCase().startsWith("Y");
        string = XMLUtility.getValue(element, "SHOWINPUTINPARENS");
        this.showInputInParens = string != null && string.trim().toUpperCase().startsWith("Y");
        string = XMLUtility.getValue(element, "MULTIPLIER");
        if (string != null && string.toUpperCase().startsWith("Y")) {
            this.isMultiplier = true;
        }
        this.requiresAll = (string = XMLUtility.getValue(element, "REQUIRESALL")) != null && string.trim().toUpperCase().startsWith("Y");
        java.util.List list = element.getChildren("EXCLUDES");
        for (Element element2 : list) {
            if (element2.getText() == null || element2.getText().trim().length() <= 0) continue;
            this.excludes.add(element2.getText());
        }
        list = element.getChildren("REQUIRES");
        for (Element element2 : list) {
            if (element2.getText() == null || element2.getText().trim().length() <= 0) continue;
            this.requires.add(element2.getText());
        }
    }

    public boolean isAvailableCheck() {
        return this.availableCheck;
    }

    public boolean isLimitation() {
        if (this.isLimitationSet) {
            return this.isLimitation;
        }
        if (this.getOptions() != null && this.getOptions().size() > 0) {
            boolean bl = false;
            boolean bl2 = false;
            for (Adder adder : this.getOptions()) {
                if (adder.getBaseCost() < 0.0) {
                    bl2 = true;
                }
                if (adder.getBaseCost() > 0.0) {
                    bl = true;
                }
                if (adder.getLevelCost() > 0.0) {
                    bl = true;
                }
                if (!(adder.getLevelCost() < 0.0)) continue;
                bl2 = true;
            }
            if (bl && bl2) {
                return this.getTotalValue() < 0.0;
            }
            if (bl) {
                return false;
            }
            if (bl2) {
                return true;
            }
            return true;
        }
        return this.getTotalValue() < 0.0;
    }

    public boolean isPrivate() {
        if (this.getProgenitor() != null && !(this.getProgenitor() instanceof List) && !(this.getProgenitor() instanceof NakedModifier)) {
            return false;
        }
        return this.privateMod;
    }

    public boolean noDisplayDialog() {
        return false;
    }

    public boolean refreshAddersOnUpdate() {
        return false;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "PRIVATE");
        this.privateMod = string != null && string.trim().toUpperCase().startsWith("Y") ? true : (string != null && string.trim().toUpperCase().startsWith("N") ? false : this.getTypes().contains("VPP") || this.getTypes().contains("MP") || this.getTypes().contains("EC") || this.getTypes().contains("LIST"));
        string = XMLUtility.getValue(element, "FORCEALLOW");
        this.forceAllow = string != null && string.trim().toUpperCase().startsWith("Y");
        this.comments = XMLUtility.getValue(element, "COMMENTS");
    }

    public void setAvailableCheck(boolean bl) {
        this.availableCheck = bl;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public void setDisplayInString(boolean bl) {
        this.displayInString = bl;
    }

    public void setFullDisplay(boolean bl) {
        this.fullDisplay = bl;
    }

    public void setParent(GenericObject genericObject) {
        this.parent = genericObject;
    }

    public void setPrivate(boolean bl) {
        this.privateMod = bl;
    }

    public void setRefreshAddersOnUpdate(boolean bl) {
    }

    @Override
    public String toString() {
        if (this.fullDisplay) {
            return "<html>" + this.getColumn2Output() + "</html>";
        }
        return this.getDisplay();
    }

    public boolean useMultiplier() {
        if (this.isMultiplier) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        if (this.parent instanceof Modifier) {
            return true;
        }
        return this.parent instanceof Disadvantage;
    }
}

