/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.MindScan;
import com.hero.objects.powers.Sense;
import com.hero.ui.dialog.MegascaleDialog;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.util.XMLUtility;
import java.text.NumberFormat;
import org.jdom.Element;

public class Megascale
extends Modifier {
    private static String xmlID = "MEGASCALE";
    private String scale;

    public Megascale(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + genericObject.getColumn2Output() + " (" + this.getFraction(genericObject.getBaseCost()) + ")";
            d -= genericObject.getBaseCost();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ":  ";
            }
            string2 = string2 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        string2 = string2 + this.getScale() + "; ";
        if (this.getSelectedOption() != null) {
            string2 = string2 + this.getSelectedOption().getAlias();
            string2 = string2 + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public ModifierDialog getDialog(GenericObject genericObject, boolean bl) {
        return new MegascaleDialog(this, bl, genericObject);
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        element.setAttribute("SCALE", this.getScale());
        return element;
    }

    public String getScale() {
        String string = this.getScaleValue();
        if (this.scale == null || this.scale.trim().length() == 0 || this.scale.equals(string)) {
            return string;
        }
        return this.scale;
    }

    public String getScaleValue() {
        String string = "1\" = ";
        if (HeroDesigner.getActiveTemplate().is6E()) {
            string = "1m = ";
        }
        int n = 0;
        if (this.getProgenitor() instanceof MindScan) {
            n = 5;
        }
        if (HeroDesigner.getActiveTemplate().is6E()) {
            ++n;
        }
        double d = 1.0;
        if (HeroDesigner.getActiveTemplate().is6E() && this.getLevels() == 1) {
            d = 10.0;
        }
        if (this.getLevels() > 1 || !HeroDesigner.getActiveTemplate().is6E()) {
            d = Math.pow(this.getLevelPower(), this.getLevels() - 1 + n);
        }
        double d2 = 0.0;
        if (this.getLevels() > 2 || !HeroDesigner.getActiveTemplate().is6E()) {
            d2 = Math.pow(this.getLevelPower(), this.getLevels() - 2 + n);
        }
        if (d <= 0.0 || d < d2) {
            string = string + "a LONG way";
        } else if (d < 1000000.0) {
            string = string + NumberFormat.getIntegerInstance().format(d) + " km";
        } else if (d < 1.0E9) {
            string = string + NumberFormat.getIntegerInstance().format(d / 1000000.0) + " million km";
        } else if (d < 1.0E12) {
            string = string + NumberFormat.getIntegerInstance().format(d / 1.0E9) + " billion km";
        } else if (d < 1.0E13) {
            string = string + NumberFormat.getIntegerInstance().format(d / 1.0E12) + " trillion km";
        } else if (d < 1.0E31) {
            if ((d /= 1.0E13) < 1000000.0) {
                string = string + NumberFormat.getIntegerInstance().format(d) + " lightyear" + (d < 1.5 ? "" : "s");
            } else if (d < 1.0E9) {
                string = string + NumberFormat.getIntegerInstance().format(d / 1000000.0) + " million lightyears";
            } else if (d < 1.0E12) {
                string = string + NumberFormat.getIntegerInstance().format(d / 1.0E9) + " billion lightyears";
            } else if (d < 1.0E15) {
                string = string + NumberFormat.getIntegerInstance().format(d / 1.0E12) + " trillion lightyears";
            } else if (d < 1.0E18) {
                string = string + NumberFormat.getIntegerInstance().format(d / 1.0E15) + " quadrillion lightyears";
            }
        } else {
            string = string + "a LONG way";
        }
        return string;
    }

    @Override
    public String included(GenericObject genericObject) {
        Sense sense;
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject.getTarget().equals("HEX")) {
            return "";
        }
        if (genericObject.getTypes().contains("MOVEMENT") && !genericObject.getXMLID().equals("FTL") && !genericObject.getXMLID().equals("EXTRADIMENSIONALMOVEMENT")) {
            return "";
        }
        if (genericObject.getRangeValue() > 0) {
            return "";
        }
        if (genericObject instanceof MindScan) {
            return "";
        }
        if (genericObject instanceof Sense && (sense = (Sense)genericObject).getBuiltInSenseAdders().contains("RANGE")) {
            return "";
        }
        return this.getDisplay() + " can only be applied to Powers which already affect an area, Movement Powers (except Extradimensional Movement and FTL Travel), and Powers which work at Range.";
    }

    @Override
    public boolean noDisplayDialog() {
        return false;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "SCALE");
        if (string != null && string.trim().length() > 0) {
            this.setScale(string);
        }
    }

    @Override
    public void setLevels(int n) {
        String string = this.getScaleValue();
        super.setLevels(n);
        if (this.scale == null || this.scale.trim().length() == 0 || this.scale.equals(string)) {
            this.setScale(this.getScaleValue());
        }
    }

    public void setScale(String string) {
        this.scale = string != null && string.trim().length() > 0 ? string : this.getScaleValue();
    }
}

