/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class Linked
extends Modifier {
    private static String xmlID = "LINKED";
    private double lesserValue;
    private long linkedToID;
    private double origBase;

    public Linked(Element element) {
        super(element, xmlID);
    }

    @Override
    public Linked clone() {
        Linked linked = (Linked)super.clone();
        linked.setSelectedOption(this.getSelectedOption());
        linked.setLinkedToID(this.linkedToID);
        return linked;
    }

    @Override
    public double getBaseCost() {
        GenericObject genericObject = this.getValue();
        if (genericObject == null) {
            return this.origBase;
        }
        if (this.parent == null) {
            return this.origBase;
        }
        if (genericObject.getXMLID().equals(this.parent.getXMLID()) || genericObject instanceof Linked) {
            this.setLinkedToID(-1L);
            return this.origBase;
        }
        List list = null;
        Linked linked = null;
        Linked linked2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        if (this.parent.getParentList() != null) {
            list = this.parent.getParentList();
            this.parent.setParent(null);
        }
        for (Modifier modifier : this.parent.getAssignedModifiers()) {
            ++n3;
            if (!modifier.getXMLID().equals(this.getXMLID())) continue;
            linked = (Linked)modifier;
            this.parent.getAssignedModifiers().remove(n3);
            n = n3;
            break;
        }
        for (Modifier modifier : genericObject.getAssignedModifiers()) {
            ++n4;
            if (!modifier.getXMLID().equals(this.getXMLID())) continue;
            linked2 = (Linked)modifier;
            genericObject.getAssignedModifiers().remove(n4);
            n2 = n4;
            break;
        }
        double d = this.lesserValue;
        if (genericObject.getActiveCost() >= this.parent.getActiveCost()) {
            d = this.origBase;
        }
        if (linked != null) {
            this.parent.getAssignedModifiers().add(n, linked);
        }
        if (linked2 != null) {
            genericObject.getAssignedModifiers().add(n2, linked2);
        }
        this.parent.setParent(list);
        return d;
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (string.length() > 0) {
                string = string + "; ";
            }
            string = string + genericObject.getAlias();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ":  ";
            }
            string2 = string2 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        GenericObject genericObject = this.getValue();
        string2 = string2 + (genericObject == null ? "???" : (genericObject.getName().trim().length() > 0 ? genericObject.getName() : genericObject.getAlias()));
        string2 = string2 + "; ";
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        if (string.trim().length() > 0) {
            string2 = string2 + string + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        return string2;
    }

    @Override
    public ModifierDialog getDialog(GenericObject genericObject, boolean bl) {
        this.parent = genericObject;
        ArrayList<Adder> arrayList = this.getOptionVector(genericObject);
        this.setOptions(arrayList);
        ModifierDialog modifierDialog = super.getDialog(genericObject, bl);
        modifierDialog.optionsLbl.setText("Linked To:");
        modifierDialog.optionsCB.setEditable(false);
        int n = 0;
        int n2 = -1;
        for (Adder adder : arrayList) {
            ++n2;
            if (adder.getID() != this.linkedToID) continue;
            n = n2;
            break;
        }
        if (n >= 0 && n < modifierDialog.optionsCB.getItemCount()) {
            modifierDialog.optionsCB.setSelectedIndex(n);
        }
        return modifierDialog;
    }

    private ArrayList<Adder> getOptionVector(GenericObject genericObject) {
        GenericObject genericObject2;
        GenericObject genericObject3;
        GenericObject genericObject4;
        GenericObject genericObject5;
        GenericObject genericObject62;
        ArrayList<Adder> arrayList = new ArrayList<Adder>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (GenericObject object : HeroDesigner.getActiveHero().getPowers()) {
            if (genericObject.getParentList() != null && (genericObject.getParentList() instanceof Multipower || genericObject.getParentList() instanceof ElementalControl || genericObject.getParentList() instanceof VariablePowerPool) && object.getParentList() != null && (object.getParentList() instanceof Multipower || object.getParentList() instanceof ElementalControl || object.getParentList() instanceof VariablePowerPool) || (genericObject instanceof Multipower || genericObject instanceof ElementalControl || genericObject instanceof VariablePowerPool) && object.getParentList() != null || genericObject.getParentList() != null && genericObject.getParentList().getID() == object.getID() || genericObject.getMainPower() != null && genericObject.getMainPower().getID() == object.getID() || object instanceof List || object.getID() == genericObject.getID() || (genericObject62 = GenericObject.findObjectByID(object.getAssignedModifiers(), "LINKED")) != null && genericObject62.getSelectedOption() != null && (genericObject5 = genericObject62).getSelectedOption().getID() == this.getID()) continue;
            genericObject5 = new Adder();
            genericObject5.setDisplay(object.getAlias());
            if (object.getName().trim().length() > 0) {
                genericObject5.setDisplay(object.getName());
            }
            genericObject5.setBaseCost(object.getActiveCost());
            ((Adder)genericObject5).setXMLID(object.getXMLID());
            genericObject5.setID(object.getID());
            arrayList.add((Adder)genericObject5);
            arrayList2.add(object.getID());
            if (!(object instanceof CompoundPower)) continue;
            genericObject4 = (CompoundPower)object;
            for (GenericObject genericObject7 : ((CompoundPower)genericObject4).getPowers()) {
                if (genericObject7 instanceof List || genericObject7.getID() == genericObject.getID() || (genericObject3 = GenericObject.findObjectByID(genericObject7.getAssignedModifiers(), "LINKED")) != null && genericObject3.getSelectedOption() != null && (genericObject2 = genericObject3).getSelectedOption().getID() == this.getID()) continue;
                genericObject2 = new Adder();
                genericObject2.setDisplay(genericObject7.getAlias());
                if (genericObject7.getName().trim().length() > 0) {
                    genericObject2.setDisplay(genericObject7.getName());
                }
                genericObject2.setBaseCost(genericObject7.getActiveCost());
                ((Adder)genericObject2).setXMLID(genericObject7.getXMLID());
                genericObject2.setID(genericObject7.getID());
                arrayList.add((Adder)genericObject2);
                arrayList2.add(genericObject7.getID());
            }
        }
        for (GenericObject genericObject8 : HeroDesigner.getActiveHero().getEquipment()) {
            if (genericObject.getParentList() != null && (genericObject.getParentList() instanceof Multipower || genericObject.getParentList() instanceof ElementalControl || genericObject.getParentList() instanceof VariablePowerPool) && genericObject8.getParentList() != null && (genericObject8.getParentList() instanceof Multipower || genericObject8.getParentList() instanceof ElementalControl || genericObject8.getParentList() instanceof VariablePowerPool) || (genericObject instanceof Multipower || genericObject instanceof ElementalControl || genericObject instanceof VariablePowerPool) && genericObject8.getParentList() != null || genericObject.getParentList() != null && genericObject.getParentList().getID() == genericObject8.getID() || genericObject.getMainPower() != null && genericObject.getMainPower().getID() == genericObject8.getID() || genericObject8 instanceof List || genericObject8.getID() == genericObject.getID() || (genericObject62 = GenericObject.findObjectByID(genericObject8.getAssignedModifiers(), "LINKED")) != null && genericObject62.getSelectedOption() != null && (genericObject5 = genericObject62).getSelectedOption().getID() == this.getID()) continue;
            genericObject5 = new Adder();
            genericObject5.setDisplay(genericObject8.getAlias());
            if (genericObject8.getName().trim().length() > 0) {
                genericObject5.setDisplay(genericObject8.getName());
            }
            genericObject5.setBaseCost(genericObject8.getActiveCost());
            ((Adder)genericObject5).setXMLID(genericObject8.getXMLID());
            genericObject5.setID(genericObject8.getID());
            arrayList.add((Adder)genericObject5);
            arrayList2.add(genericObject8.getID());
            if (!(genericObject8 instanceof CompoundPower)) continue;
            genericObject4 = (CompoundPower)genericObject8;
            for (GenericObject genericObject7 : ((CompoundPower)genericObject4).getPowers()) {
                if (genericObject7 instanceof List || genericObject7.getID() == genericObject.getID() || (genericObject3 = GenericObject.findObjectByID(genericObject7.getAssignedModifiers(), "LINKED")) != null && genericObject3.getSelectedOption() != null && (genericObject2 = genericObject3).getSelectedOption().getID() == this.getID()) continue;
                genericObject2 = new Adder();
                genericObject2.setDisplay(genericObject7.getAlias());
                if (genericObject7.getName().trim().length() > 0) {
                    genericObject2.setDisplay(genericObject7.getName());
                }
                genericObject2.setBaseCost(genericObject7.getActiveCost());
                ((Adder)genericObject2).setXMLID(genericObject7.getXMLID());
                genericObject2.setID(genericObject7.getID());
                arrayList.add((Adder)genericObject2);
                arrayList2.add(genericObject7.getID());
            }
        }
        if (genericObject.getMainPower() != null) {
            CompoundPower compoundPower = genericObject.getMainPower();
            for (GenericObject genericObject62 : compoundPower.getPowers()) {
                if (genericObject62 instanceof List || genericObject62.getID() == genericObject.getID() || (genericObject5 = GenericObject.findObjectByID(genericObject62.getAssignedModifiers(), "LINKED")) != null && genericObject5.getSelectedOption() != null && (genericObject4 = genericObject5).getSelectedOption().getID() == this.getID()) continue;
                genericObject4 = new Adder();
                genericObject4.setDisplay(genericObject62.getAlias());
                if (genericObject62.getName().trim().length() > 0) {
                    genericObject4.setDisplay(genericObject62.getName());
                }
                genericObject4.setBaseCost(genericObject62.getActiveCost());
                ((Adder)genericObject4).setXMLID(genericObject62.getXMLID());
                genericObject4.setID(genericObject62.getID());
                if (arrayList2.contains(genericObject62.getID())) continue;
                arrayList.add((Adder)genericObject4);
                arrayList2.add(genericObject62.getID());
            }
        }
        return arrayList;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        this.getValue();
        element.setAttribute("LINKED_ID", "" + this.linkedToID);
        return element;
    }

    @Override
    public double getTotalValue() {
        double d = this.getBaseCost();
        for (Adder adder : this.getAssignedAdders()) {
            d += adder.getDoubleTotal();
        }
        if (this.getLevelValue() > 0.0) {
            d += (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
        }
        double d2 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        double d3 = d * (1.0 + d2);
        double d4 = 0.0;
        for (Modifier modifier : this.assignedModifiers) {
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d4 += Math.abs(modifier.getTotalValue());
        }
        d = d3 / (1.0 + d4);
        if (d < this.getMinimumCost() && this.isMinSet()) {
            return this.getMinimumCost();
        }
        if (d > this.getMaxCost() && this.isMaxSet()) {
            return this.getMaxCost();
        }
        return d;
    }

    public GenericObject getValue() {
        if (HeroDesigner.getActiveHero() == null) {
            return null;
        }
        this.purifyLinkedObject();
        if (this.linkedToID < 0L) {
            return null;
        }
        for (GenericObject genericObject : HeroDesigner.getActiveHero().getPowers()) {
            if (genericObject.getID() == this.linkedToID) {
                return genericObject;
            }
            if (!(genericObject instanceof CompoundPower)) continue;
            CompoundPower compoundPower = (CompoundPower)genericObject;
            for (GenericObject genericObject2 : compoundPower.getPowers()) {
                if (genericObject2.getID() != this.linkedToID) continue;
                return genericObject2;
            }
        }
        if (this.parent != null && this.parent.getMainPower() != null) {
            for (GenericObject genericObject : this.parent.getMainPower().getPowers()) {
                if (genericObject.getID() != this.linkedToID) continue;
                return genericObject;
            }
        }
        return null;
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (!genericObject.isPower() && !(genericObject instanceof Power)) {
            return this.getDisplay() + " can only be applied to Powers.";
        }
        if (this.getOptionVector(genericObject).size() > 0) {
            return "";
        }
        return "There are no other abilities on the character that can be Linked to.";
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        this.lesserValue = -0.25;
        this.origBase = this.baseCost;
        String string = XMLUtility.getValue(element, "LESSERVALUE");
        if (string != null && string.trim().length() > 0) {
            try {
                this.lesserValue = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isLimitation() {
        return true;
    }

    private void purifyLinkedObject() {
        if (this.getProgenitor() != null && (this.getProgenitor().getParentList() != null && this.getProgenitor().getParentList().getID() == this.linkedToID || this.getProgenitor().getMainPower() != null && this.getProgenitor().getMainPower().getID() == this.linkedToID)) {
            this.linkedToID = -1L;
        }
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "LINKED_ID");
        if (string != null && string.trim().length() > 0) {
            try {
                this.linkedToID = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.linkedToID = -1L;
        }
    }

    public void setLinkedToID(long l) {
        this.linkedToID = l;
    }

    @Override
    public void setSelectedOption(Adder adder) {
        this.linkedToID = adder != null && adder.getID() > 0L ? adder.getID() : -1L;
        super.setSelectedOption(adder);
        if (adder == null) {
            return;
        }
        if (adder.getBaseCost() > this.parent.getActiveCost()) {
            this.setBaseCost(this.origBase);
        } else {
            this.setBaseCost(this.lesserValue);
        }
    }
}

