/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import org.jdom.Element;

public class LimitedRange
extends Modifier {
    private static String xmlID = "LIMITEDRANGE";

    public LimitedRange(Element element) {
        super(element, xmlID);
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "RANGED") != null) {
            return this.getDisplay() + " cannot be applied to Powers that have taken the Ranged Advantage.  Use the options on the Ranged Advantage instead.";
        }
        if (genericObject.getRangeValue() == 0) {
            return this.getDisplay() + " can only be applied to Ranged Powers.";
        }
        if (genericObject.getRangeValue() < 0) {
            return this.getDisplay() + "cannot be applied to Line Of Sight Powers.  You should first take the Normal Range Limitation.";
        }
        return "";
    }
}

