/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.util.Rounder;
import java.text.NumberFormat;
import org.jdom.Element;

public class IncreasedMaxRange
extends Modifier {
    private static String xmlID = "INCREASEDMAXRANGE";

    public IncreasedMaxRange(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + genericObject.getAlias() + " (" + this.getFraction(genericObject.getBaseCost()) + ")";
            d -= genericObject.getBaseCost();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ":  ";
            }
            string2 = string2 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        string2 = HeroDesigner.getActiveTemplate().is6E() ? string2 + "" + NumberFormat.getInstance().format(this.getMaxRange(this.parent)) + "m; " : string2 + "" + NumberFormat.getInstance().format(this.getMaxRange(this.parent)) + "\"; ";
        if (this.getSelectedOption() != null) {
            string2 = string2 + this.getSelectedOption().getAlias();
            string2 = string2 + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public String getLevelInfo() {
        String string = "" + this.getMaxRange(this.parent);
        string = HeroDesigner.getActiveTemplate().is6E() ? string + "m" : string + "\"";
        return string;
    }

    public int getMaxRange(GenericObject genericObject) {
        int n = 0;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            double d = genericObject.getTotalCost();
            for (Adder adder : genericObject.getAssignedAdders()) {
                if (adder.includeInBase() || adder.isCustom()) continue;
                d -= adder.getTotalCost();
            }
            return (int)Rounder.roundHalfUp(d * 10.0 * Math.pow(this.getLevelPower(), this.getLevels()));
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), this.getXMLID()) != null) {
            double d = genericObject.getActiveCost(this.getXMLID());
            n = (int)Rounder.roundHalfUp(d * Math.pow(this.getLevelPower(), this.getLevels() + 1));
        } else {
            n = (int)Rounder.roundHalfUp(genericObject.getActiveCost() * Math.pow(this.getLevelPower(), this.getLevels() + 1));
        }
        return n;
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject.getRangeValue() <= 0) {
            return this.getDisplay() + " can only be applied to Ranged Powers.";
        }
        return "";
    }
}

