/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.ChangeEnvironment;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.util.Rounder;
import org.jdom.Element;

public class Explosion
extends Modifier {
    private static String xmlID = "EXPLOSION";

    public Explosion(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + genericObject.getAlias() + " (" + this.getFraction(genericObject.getBaseCost()) + ")";
            d -= genericObject.getBaseCost();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ":  ";
            }
            string2 = string2 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        if (this.getSelectedOption() != null && this.getSelectedOption().getAlias().trim().length() > 0 && !this.getSelectedOption().getAlias().equals("Normal (Radius)")) {
            string2 = string2 + this.getSelectedOption().getAlias();
            string2 = string2 + "; ";
        }
        if (this.getLevels() > 0) {
            int n = this.getLevels();
            if (this.getSelectedOption() != null && this.getSelectedOption().getLevelMultiplier() != 0) {
                n *= this.getSelectedOption().getLevelMultiplier();
            }
            if (n != 1) {
                string2 = string2 + "-1 DC/" + n + "\"; ";
            }
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public ModifierDialog getDialog(GenericObject genericObject, boolean bl) {
        ModifierDialog modifierDialog = new ModifierDialog(this, bl, genericObject);
        modifierDialog.levelsLbl.setText("Fade Rate (1 DC/ X\")");
        return modifierDialog;
    }

    @Override
    public double getTotalValue() {
        double d = this.getBaseCost();
        for (Adder adder : this.getAssignedAdders()) {
            d += adder.getDoubleTotal();
        }
        if (this.getLevelValue() > 0.0) {
            d += (double)(this.getLevels() - this.getMinimumLevel()) * this.getLevelCost();
        }
        double d2 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        double d3 = d * (1.0 + d2);
        double d4 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d4 += Math.abs(modifier.getTotalValue());
        }
        d = d3 / (1.0 + d4);
        d *= 4.0;
        int n = 1;
        if (d < 0.0) {
            n = -1;
        }
        d *= (double)n;
        d = Rounder.roundHalfUp(d);
        d *= (double)n;
        if ((d /= 4.0) < this.getMinimumCost() && this.isMinSet()) {
            return this.getMinimumCost();
        }
        if (d > this.getMaxCost() && this.isMaxSet()) {
            return this.getMaxCost();
        }
        return d;
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject instanceof ChangeEnvironment) {
            return "";
        }
        if (genericObject.getTarget().equals("HEX")) {
            return this.getDisplay() + " cannot be applied to Powers which already affect an area.";
        }
        if (!genericObject.getTarget().equals("DCV") && !genericObject.getTarget().equals("ECV")) {
            return this.getDisplay() + " can only be applied to Powers which are targeted on others.";
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "AOE") != null) {
            return this.getDisplay() + " cannot be applied to abilities which already affect an area.";
        }
        return "";
    }
}

