/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import org.jdom.Element;

public class DelayedEND
extends Modifier {
    private static String xmlID = "DELAYEDEND";

    public DelayedEND(Element element) {
        super(element, xmlID);
    }

    @Override
    public double getTotalValue() {
        double d = super.getTotalValue();
        if (this.parent != null && GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "AUTOFIRE") != null) {
            d *= 2.0;
        }
        return d;
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        genericObject = genericObject.clone();
        genericObject.setParent(null);
        genericObject.setMainPower(null);
        if (genericObject.getEndUsage() <= 0) {
            return this.getDisplay() + " can only be applied to abilities which cost END to use.";
        }
        if (!genericObject.getDuration().equalsIgnoreCase("CONSTANT")) {
            return this.getDisplay() + " can only be applied to Constant/Continuous abilities.";
        }
        return "";
    }
}

