/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.NakedModifier;
import com.hero.util.Rounder;
import org.jdom.Element;

public class DamageOverTime
extends Modifier {
    private static String xmlID = "DAMAGEOVERTIME";

    public DamageOverTime(Element element) {
        super(element, xmlID);
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject instanceof NakedModifier) {
            return "";
        }
        if (!(genericObject.getTypes().contains("ATTACK") && !genericObject.getTarget().equals("SELFONLY") && !genericObject.getTarget().equals("N/A") && genericObject.doesDamage() || genericObject.getTypes().contains("MENTAL") || genericObject.getTypes().contains("ADJUSTMENT") && !genericObject.getTarget().equals("SELFONLY") && !genericObject.getTarget().equals("N/A"))) {
            return this.getDisplay() + " can only be applied to Attack Powers and Powers which affect others.";
        }
        return "";
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        if (!this.showOptionOnly) {
            string2 = string2 + this.getAlias();
        }
        double d = this.getTotalValue();
        if (!this.showOptionInParens && this.getSelectedOption() != null && this.getSelectedOption().displayInString() && this.getSelectedOption().getAlias().trim().length() > 0) {
            string2 = string2 + " " + this.getSelectedOption().getAlias();
            string2 = string2.trim();
        }
        if (!this.showInputInParens && this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + " ";
            }
            string2 = string2 + this.getInput();
        }
        string2 = string2.trim();
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        int n = 0;
        int n2 = 0;
        while (string2.indexOf("(", n) >= 0) {
            ++n2;
            n = string2.indexOf("(", n) + 1;
        }
        n = 0;
        while (string2.indexOf(")", n) >= 0) {
            --n2;
            n = string2.indexOf(")", n) + 1;
        }
        string2 = n2 <= 0 ? string2 + " (" : string2 + "; ";
        if (this.showOptionInParens && this.getSelectedOption() != null && this.getSelectedOption().displayInString() && this.getSelectedOption().getAlias().trim().length() > 0) {
            string2 = string2 + this.getSelectedOption().getAlias().trim() + "; ";
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.getXMLID().equals("INCREMENTS")) continue;
            string2 = string2 + adder.getSelectedOption().getAlias() + " damage increments, ";
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.getXMLID().equals("TIMEBETWEEN")) continue;
            string2 = string2 + "damage occurs every " + adder.getSelectedOption().getAlias() + ", ";
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isSelected() || adder.getXMLID().equals("INCREMENTS") || adder.getXMLID().equals("TIMEBETWEEN") || adder.getColumn2Output().trim().length() <= 0) continue;
            string2 = string2 + adder.getColumn2Output().trim() + ", ";
        }
        if (this.showInputInParens && this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + this.getInputLabel() + " " + this.getInput() + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        if (d > this.maxCost && this.maxSet) {
            d = this.maxCost;
        }
        if (d < this.minimumCost && this.minSet) {
            d = this.minimumCost;
        }
        string2 = string2 + this.getFraction(d) + ")";
        --n2;
        while (n2 > 0) {
            string2 = string2 + ")";
            --n2;
        }
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public double getTotalValue() {
        double d = this.getBaseCost();
        double d2 = 0.0;
        double d3 = 0.0;
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.getXMLID().equals("INCREMENTS")) {
                d2 = adder.getDoubleTotal();
                continue;
            }
            if (adder.getXMLID().equals("TIMEBETWEEN")) {
                d3 = adder.getDoubleTotal();
                continue;
            }
            d += adder.getDoubleTotal();
        }
        if (this.getLevelValue() > 0.0) {
            d += (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
        }
        double d4 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (modifier.getXMLID().equals("ONEDEFENSE")) {
                d2 *= 2.0;
                continue;
            }
            if (modifier.getXMLID().equals("LOCKOUT")) {
                if (d3 > 0.0) {
                    d3 = 0.0;
                    continue;
                }
                d3 *= 2.0;
                continue;
            }
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d4 += modifier.getTotalValue();
        }
        d = d + d2 + d3;
        double d5 = d * (1.0 + d4);
        double d6 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (modifier.getXMLID().equals("ONEDEFENSE") || modifier.getXMLID().equals("LOCKOUT") || !(modifier.getTotalValue() < 0.0)) continue;
            d6 += Math.abs(modifier.getTotalValue());
        }
        d = d5 / (1.0 + d6);
        d *= 4.0;
        int n = 1;
        if (d < 0.0) {
            n = -1;
        }
        d *= (double)n;
        d = Rounder.roundHalfUp(d);
        d *= (double)n;
        if ((d /= 4.0) < this.getMinimumCost() && this.isMinSet()) {
            return this.getMinimumCost();
        }
        if (d > this.getMaxCost() && this.isMaxSet()) {
            return this.getMaxCost();
        }
        return d;
    }
}

