/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Absorption;
import com.hero.objects.powers.Aid;
import com.hero.objects.powers.Healing;
import com.hero.objects.powers.Succor;
import com.hero.objects.powers.Transform;
import com.hero.util.Rounder;
import org.jdom.Element;

public class Cumulative
extends Modifier {
    private static String xmlID = "CUMULATIVE";

    public Cumulative(Element element) {
        super(element, xmlID);
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + genericObject.getAlias() + " (" + this.getFraction(genericObject.getBaseCost()) + ")";
            d -= genericObject.getBaseCost();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        if (this.getLevels() > 0) {
            string2 = string2 + this.getLevelInfo() + "; ";
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + this.getInput();
            string2 = string2 + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public String getLevelInfo() {
        int n = this.getLevels();
        if (this.getProgenitor() != null) {
            int n2 = this.getProgenitor().getLevels() * 6;
            for (Adder adder : this.getProgenitor().getAssignedAdders()) {
                if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
                    n2 += 3;
                    continue;
                }
                if (!adder.getXMLID().equals("PLUSONEPIP")) continue;
                ++n2;
            }
            n = (int)Rounder.roundHalfUp((double)n2 * Math.pow(2.0, n));
        }
        return n + " points";
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject instanceof Absorption || genericObject instanceof Aid || genericObject instanceof Healing || genericObject instanceof Succor) {
            return genericObject.getDisplay() + " cannot have Cumulative applied to it, since it already has its own rules for how many Character points can be added to a particular Characteristic or Power and how and at what rate they're added.";
        }
        if (genericObject instanceof Transform) {
            return genericObject.getDisplay() + " is already cumulative in nature.";
        }
        if (genericObject.doesDamage()) {
            return this.getDisplay() + " cannot be applied to abilities that cause STUN or BODY damage.";
        }
        if (genericObject.getDefense().equals("NONE")) {
            return this.getDisplay() + " can only be applied to abilities which act against a target's Defenses";
        }
        if (genericObject.getTarget().equals("SELFONLY") || genericObject.getTarget().equals("N/A")) {
            return this.getDisplay() + " can only be applied to abilities which require an Attack Roll.";
        }
        return "";
    }
}

