/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Power;
import java.util.ArrayList;
import org.jdom.Element;

public class Concentration
extends Modifier {
    private static String xmlID = "CONCENTRATION";

    public Concentration(Element element) {
        super(element, xmlID);
    }

    @Override
    public ArrayList<Modifier> getAssignedModifiers() {
        ArrayList<Modifier> arrayList = super.getAssignedModifiers();
        if (!HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
            return arrayList;
        }
        if (this.getProgenitor() == null || !(this.getProgenitor() instanceof Power)) {
            return arrayList;
        }
        GenericObject genericObject = this.getProgenitor();
        if (HeroDesigner.getActiveHero() == null || HeroDesigner.getActiveHero().isLoading() || !genericObject.getDuration().equals("INSTANT") || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "EXTRATIME") != null || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "REGENEXTRATIME") != null || this.getProgenitor().getXMLID().equals("MINDCONTROL") || this.getProgenitor().getXMLID().equals("MINDSCAN") || this.getProgenitor().getXMLID().equals("MINDLINK") || this.getProgenitor().getXMLID().equals("TELEPATHY") || this.getProgenitor().getXMLID().equals("FORCEWALL")) {
            return arrayList;
        }
        for (Modifier modifier : arrayList) {
            if (!modifier.getXMLID().equals("CONTINUOUSCONCENTRATION")) continue;
            arrayList.remove(modifier);
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public ArrayList<Modifier> getAvailableModifiers() {
        ArrayList arrayList = (ArrayList)super.getAvailableModifiers().clone();
        if (this.getProgenitor() == null || !(this.getProgenitor() instanceof Power)) {
            return arrayList;
        }
        if (HeroDesigner.getActiveHero() == null || !HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn() || HeroDesigner.getActiveHero().isLoading()) {
            return arrayList;
        }
        GenericObject genericObject = this.getProgenitor();
        if (!genericObject.getDuration().equals("INSTANT") || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "EXTRATIME") != null || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "REGENEXTRATIME") != null || this.getProgenitor().getXMLID().equals("MINDCONTROL") || this.getProgenitor().getXMLID().equals("MINDSCAN") || this.getProgenitor().getXMLID().equals("MINDLINK") || this.getProgenitor().getXMLID().equals("TELEPATHY") || this.getProgenitor().getXMLID().equals("FORCEWALL")) {
            return arrayList;
        }
        for (Modifier modifier : arrayList) {
            if (!modifier.getXMLID().equals("CONTINUOUSCONCENTRATION")) continue;
            arrayList.remove(modifier);
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        if (!this.showOptionOnly) {
            string2 = string2 + this.getAlias();
        }
        double d = this.getTotalValue();
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + " ";
            }
            string2 = string2 + this.getInput();
        }
        string2 = string2.trim();
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        int n = 0;
        int n2 = 0;
        while (string2.indexOf("(", n) >= 0) {
            ++n2;
            n = string2.indexOf("(", n) + 1;
        }
        n = 0;
        while (string2.indexOf(")", n) >= 0) {
            --n2;
            n = string2.indexOf(")", n) + 1;
        }
        string2 = n2 <= 0 ? string2 + " (" : string2 + "; ";
        if (this.getSelectedOption() != null && this.getSelectedOption().displayInString() && this.getSelectedOption().getAlias().trim().length() > 0) {
            string2 = string2 + this.getSelectedOption().getAlias() + "; ";
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isSelected() || adder.getColumn2Output().trim().length() <= 0) continue;
            string2 = string2 + adder.getColumn2Output().trim() + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        if (d > this.maxCost && this.maxSet) {
            d = this.maxCost;
        }
        if (d < this.minimumCost && this.minSet) {
            d = this.minimumCost;
        }
        string2 = string2 + this.getFraction(d) + ")";
        --n2;
        while (n2 > 0) {
            string2 = string2 + ")";
            --n2;
        }
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }
}

