/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Power;
import com.hero.objects.talents.MageSight;
import com.hero.objects.talents.Talent;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jdom.Element;

public class Charges
extends Modifier {
    private static String xmlID = "CHARGES";
    private int clipsLevel;
    private int clipsMultiplier;
    private int clipsAdvantageMultiplier;
    private int boostableLevel;
    private int recoverableLevel;
    private boolean refreshOnUpdate = false;
    private int currentLevels = 0;
    private ArrayList<Adder> availAds = new ArrayList();
    long lastCall = 0L;

    public Charges(Element element) {
        super(element, xmlID);
    }

    @Override
    public void resetInternal() {
        this.lastCall = 0L;
    }

    /*
     * WARNING - void declaration
     */
    private boolean childUsesEND(GenericObject genericObject) {
        void var5_6;
        if (genericObject == null) {
            return false;
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "LINGERING") != null) {
            return false;
        }
        List list = genericObject.getParentList();
        ArrayList arrayList = (ArrayList)genericObject.getAssignedModifiers().clone();
        ArrayList arrayList2 = (ArrayList)genericObject.getAssignedModifiers().clone();
        int bl = arrayList2.size() - 1;
        while (var5_6 >= 0) {
            Modifier modifier = (Modifier)arrayList2.get((int)var5_6);
            if (modifier.getXMLID().equals("CHARGES")) {
                arrayList2.remove((int)var5_6);
            }
            --var5_6;
        }
        genericObject.setParent(null);
        genericObject.setAssignedModifiers(arrayList2);
        boolean bl2 = genericObject.usesEND();
        genericObject.setParent(list);
        genericObject.setAssignedModifiers(arrayList);
        return bl2;
    }

    private void cleanAssignedAdders() {
        ArrayList<Adder> arrayList = new ArrayList<Adder>();
        for (Adder adder : this.assignedAdders) {
            if (adder.getXMLID().equals("CONTINUING") || adder.getXMLID().indexOf("FUEL") >= 0) {
                if (this.parent != null && HeroDesigner.getActiveHero() != null && !HeroDesigner.getActiveHero().isLoading() && !this.getProgenitor().getIsPrefab()) {
                    if (this.parent instanceof Power) {
                        Power power = (Power)this.parent;
                        if (power.getDuration().equals("INSTANT") && GenericObject.findObjectByID(power.getAssignedModifiers(), "LINGERING") == null && GenericObject.findObjectByID(power.getAssignedModifiers(), "TIMELIMIT") == null) continue;
                        arrayList.add(adder);
                        continue;
                    }
                    if (this.parent instanceof Characteristic) {
                        arrayList.add(adder);
                        continue;
                    }
                    if (this.parent instanceof Talent || this.parent instanceof MageSight) {
                        arrayList.add(adder);
                        continue;
                    }
                    if (this.parent instanceof List) {
                        arrayList.add(adder);
                        continue;
                    }
                    arrayList.add(adder);
                    continue;
                }
                arrayList.add(adder);
                continue;
            }
            arrayList.add(adder);
        }
        this.assignedAdders = arrayList;
    }

    @Override
    public ArrayList<Adder> getAssignedAdders() {
        ArrayList<Adder> arrayList;
        ArrayList<Adder> arrayList2 = super.getAssignedAdders();
        if (this.parent == null || GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "LINGERING") == null || this.getProgenitor().getIsPrefab()) {
            return arrayList2;
        }
        GenericObject genericObject = GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "LINGERING");
        GenericObject genericObject2 = GenericObject.findObjectByID(arrayList2, "CONTINUING");
        if (genericObject2 != null) {
            arrayList2.remove(genericObject2);
        }
        if ((genericObject2 = GenericObject.findObjectByID(arrayList = this.getAvailableAdders(), "CONTINUING")) != null) {
            Adder adder = new Adder(genericObject2);
            adder.setOptions((ArrayList)adder.getOptions().clone());
            int n = 0;
            for (Adder adder2 : genericObject.getOptions()) {
                ++n;
                if (!adder2.equals(genericObject.getSelectedOption())) continue;
                adder.setSelectedOption(adder.getOptions().get(n - 1));
                adder.getOptions().clear();
                adder.getOptions().add(adder.getSelectedOption());
            }
            adder.setSelected(true);
            arrayList2.add(adder);
        }
        return arrayList2;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        this.availAds = new ArrayList();
        block0: for (Adder adder : this.availableAdders) {
            if (adder.getXMLID().equals("CLIPS")) {
                for (Object object : this.assignedAdders) {
                    if (!((GenericObject)object).getXMLID().equals("CLIPS")) continue;
                    this.availAds.add((Adder)object);
                    continue block0;
                }
            }
            if (adder.getXMLID().equals("CONTINUING") || adder.getXMLID().indexOf("FUEL") >= 0) {
                if (this.parent != null && HeroDesigner.getActiveHero() != null && !HeroDesigner.getActiveHero().isLoading() && !this.getProgenitor().getIsPrefab()) {
                    Object object;
                    if (!this.parent.getDuration().equals("INSTANT") || GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "LINGERING") != null || GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "TIMELIMIT") != null) {
                        this.availAds.add(adder);
                        continue;
                    }
                    if (!(this.parent instanceof List)) continue;
                    boolean bl = true;
                    object = ((List)this.parent).getObjects().iterator();
                    while (object.hasNext()) {
                        GenericObject genericObject = (GenericObject)object.next();
                        if (!genericObject.getDuration().equals("INSTANT") || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "LINGERING") != null || GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "TIMELIMIT") != null) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    this.availAds.add(adder);
                    continue;
                }
                this.availAds.add(adder);
                continue;
            }
            this.availAds.add(adder);
        }
        return this.availAds;
    }

    @Override
    public String getColumn2Output() {
        this.validationCheck();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        boolean bl = true;
        try {
            int n = Integer.parseInt(this.getSelectedOption().getAlias());
            bl = n != 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (genericObject.getXMLID().equals("CLIPS")) {
                string = genericObject.getAlias() + " of";
                continue;
            }
            if (genericObject.getXMLID().equals("CONTINUING")) {
                string4 = genericObject.getAlias();
                if (bl) {
                    string5 = "lasting " + (genericObject.getSelectedOption() != null ? genericObject.getSelectedOption().getAlias() : "???") + " each";
                    continue;
                }
                string5 = "lasting " + (genericObject.getSelectedOption() != null ? genericObject.getSelectedOption().getAlias() : "???");
                continue;
            }
            if (genericObject.getXMLID().equals("FUEL")) {
                string6 = genericObject.getAlias();
                continue;
            }
            if (genericObject.getXMLID().equals("BOOSTABLE")) {
                string2 = genericObject.getAlias();
                continue;
            }
            if (genericObject.getXMLID().equals("RECOVERABLE")) {
                string3 = genericObject.getAlias();
                continue;
            }
            if (genericObject.getXMLID().equals("INCREASEDTIME")) {
                if (bl) {
                    string7 = "which Recover every " + genericObject.getSelectedOption().getAlias();
                    continue;
                }
                string7 = "which Recovers every " + genericObject.getSelectedOption().getAlias();
                continue;
            }
            if (genericObject.getXMLID().equals("NEVERRECOVER")) {
                string7 = "which Never Recover";
                if (bl) continue;
                string7 = string7 + "s";
                continue;
            }
            if (!genericObject.displayInString()) continue;
            if (string8.length() > 0) {
                string8 = string8 + "; ";
            }
            string8 = string8 + genericObject.getAlias();
            if (genericObject.getSelectedOption() == null || genericObject.getSelectedOption().getAlias().trim().length() <= 0) continue;
            string8 = string8 + ": " + genericObject.getSelectedOption().getAlias().trim();
        }
        string9 = string;
        string9 = string9.trim();
        if (this.getSelectedOption() != null) {
            string9 = string9 + " " + this.getSelectedOption().getAlias();
        }
        string9 = string9 + " " + string2;
        string9 = string9.trim();
        string9 = string9 + " " + string3;
        string9 = string9.trim();
        string9 = string9 + " " + string4;
        string9 = string9.trim();
        string9 = string9 + " " + string6;
        string9 = string9.trim();
        string9 = bl || !this.getAlias().trim().toUpperCase().endsWith("S") ? string9 + " " + this.getAlias() : string9 + " " + this.getAlias().substring(0, this.getAlias().length() - 1);
        string9 = string9.trim();
        string9 = string9 + " " + string5;
        string9 = string9.trim();
        string9 = string9 + " " + string7;
        string9 = string9.trim();
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string9.trim().length() > 0) {
                string9 = string9 + ":  ";
            }
            string9 = string9 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string9 = string9 + ", " + modifier.getAlias();
        }
        string9 = string9 + " (";
        if (string8.trim().length() > 0) {
            string9 = string9 + string8 + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string9 = string9 + this.getComments() + "; ";
        }
        string9 = string9 + this.getFraction(d) + ")";
        return string9;
    }

    @Override
    public double getLevelCost() {
        return 0.0;
    }

    @Override
    public double getLevelValue() {
        return -1.0;
    }

    @Override
    public Element getSaveXML() {
        Element element = super.getSaveXML();
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "CLIPS") != null) {
            Adder adder = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "CLIPS");
            element.setAttribute("CLIPS_COST", "" + adder.getBaseCost());
        }
        return element;
    }

    @Override
    public double getTotalValue() {
        if (this.parent == null) {
            return 0.0;
        }
        boolean bl = false;
        double d = 1.0;
        if (!this.parentUsesEND()) {
            d = 0.0;
            bl = true;
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "BOOSTABLE") != null) {
            GenericObject genericObject = GenericObject.findObjectByID(this.getAssignedAdders(), "BOOSTABLE");
            d += genericObject.getTotalCost();
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "CONTINUING") == null) {
            bl = true;
        }
        if (bl) {
            this.maxSet = true;
            this.setMaxCost(d);
        } else {
            this.maxSet = false;
        }
        this.minSet = false;
        double d2 = super.getTotalValue();
        return d2;
    }

    @Override
    protected void init(Element element) {
        this.clipsLevel = 1;
        this.clipsMultiplier = 2;
        this.clipsAdvantageMultiplier = 4;
        this.boostableLevel = 1;
        this.recoverableLevel = 1;
        super.init(element);
        String string = XMLUtility.getValue(element, "CLIPSLEVEL");
        if (string != null && string.trim().length() > 0) {
            try {
                this.clipsLevel = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "CLIPSMULTIPLIER")) != null && string.trim().length() > 0) {
            try {
                this.clipsMultiplier = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "CLIPSADVANTAGEMULTIPLIER")) != null && string.trim().length() > 0) {
            try {
                this.clipsAdvantageMultiplier = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "BOOSTABLELEVEL")) != null && string.trim().length() > 0) {
            try {
                this.boostableLevel = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "RECOVERABLELEVEL")) != null && string.trim().length() > 0) {
            try {
                this.recoverableLevel = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.availableAdders == null) {
            this.availableAdders = new ArrayList();
        }
        for (Adder adder : this.availableAdders) {
            if (!adder.getXMLID().equals("CLIPS")) continue;
            adder.setLevelCost(0.0);
            adder.setBaseCost(0.0);
            adder.setMinimumCost(0.0);
            adder.setMaxCost(0.0);
        }
    }

    @Override
    public boolean isLimitation() {
        return true;
    }

    private boolean parentUsesEND() {
        Cloneable cloneable;
        if (this.parent == null) {
            return false;
        }
        if (GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "LINGERING") != null) {
            return false;
        }
        if (this.parent instanceof List) {
            List list = (List)this.parent;
            for (GenericObject genericObject : list.getObjects()) {
                if (!this.childUsesEND(genericObject)) continue;
                return true;
            }
            return false;
        }
        ArrayList<Modifier> arrayList = this.parent.getAssignedModifiers();
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        if (GenericObject.findObjectByID(arrayList, this.getXMLID()) != null) {
            arrayList2.remove(GenericObject.findObjectByID(arrayList, this.getXMLID()));
        }
        this.parent.setAssignedModifiers(arrayList2);
        boolean bl = this.parent.usesEND();
        this.parent.setAssignedModifiers(arrayList);
        if (bl && HeroDesigner.getActiveHero() != null) {
            bl = HeroDesigner.getActiveHero().getRules().getAPPerEND() > 0;
        }
        ArrayList arrayList3 = (ArrayList)this.parent.getAssignedModifiers().clone();
        if (this.parent.getParentList() != null) {
            cloneable = this.parent.getParentList().getAssignedModifiers();
            Iterator<Modifier> iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                Modifier modifier = iterator.next();
                if (modifier.getXMLID().equals("CHARGES")) continue;
                if (this.parent.getParentList() instanceof ElementalControl) {
                    if (!(modifier.getTotalValue() < 0.0)) continue;
                    arrayList3.add(modifier);
                    continue;
                }
                arrayList3.add(modifier);
            }
        }
        if (GenericObject.findObjectByID(arrayList3, "COSTSEND") != null) {
            bl = true;
        }
        if (GenericObject.findObjectByID(arrayList3, "REDUCEDEND") != null) {
            cloneable = GenericObject.findObjectByID(arrayList3, "REDUCEDEND");
            bl = ((GenericObject)cloneable).getSelectedOption().getXMLID().equals("HALFEND");
        }
        return bl;
    }

    @Override
    public boolean refreshAddersOnUpdate() {
        return this.refreshOnUpdate;
    }

    @Override
    public void restoreFromSave(Element element) {
        Cloneable cloneable2;
        for (Cloneable cloneable2 : element.getChildren("ADDER")) {
            if (((Element)cloneable2).getAttributeValue("XMLID") == null || !((Element)cloneable2).getAttributeValue("XMLID").equals("CONTINUING")) continue;
            if (((Element)cloneable2).getAttributeValue("OPTIONID") == null || !((Element)cloneable2).getAttributeValue("OPTIONID").equals("GENERIC_OBJECT")) break;
            ((Element)cloneable2).setAttribute("OPTIONID", "FIVEYEARS");
            ((Element)cloneable2).setAttribute("OPTION", "FIVEYEARS");
            break;
        }
        super.restoreFromSave(element);
        this.cleanAssignedAdders();
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "CLIPS") != null) {
            cloneable2 = GenericObject.findObjectByID(this.getAssignedAdders(), "CLIPS");
            String string = XMLUtility.getValue(element, "CLIPS_COST");
            if (string != null && string.trim().length() > 0) {
                try {
                    ((GenericObject)cloneable2).setBaseCost(Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        cloneable2 = this.getSelectedOption();
        this.selectedOption = null;
        this.setSelectedOption((Adder)cloneable2);
    }

    @Override
    public void setRefreshAddersOnUpdate(boolean bl) {
        this.refreshOnUpdate = bl;
    }

    @Override
    public void setSelectedOption(Adder adder) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        double d;
        this.currentLevels = 0;
        long l = System.currentTimeMillis();
        Adder adder2 = this.getSelectedOption();
        ArrayList<Adder> arrayList = this.getAssignedAdders();
        ArrayList<Adder> arrayList2 = this.getAvailableAdders();
        if (adder == null) {
            super.setSelectedOption(null);
            return;
        }
        if (l - this.lastCall > 1000L) {
            this.lastCall = l;
            if (adder2 == null || adder != null && adder.getID() != adder2.getID()) {
                this.refreshOnUpdate = true;
            } else if (adder2 != null && adder2.getXMLID().equals(adder.getXMLID())) {
                return;
            }
        }
        super.setSelectedOption(adder);
        Collections.sort(this.getOptions(), new Comparator<Adder>(){

            @Override
            public int compare(Adder adder, Adder adder2) {
                try {
                    int n = Integer.parseInt(adder.getDisplay());
                    int n2 = Integer.parseInt(adder2.getDisplay());
                    return n - n2;
                }
                catch (Exception exception) {
                    return adder.getDisplay().compareTo(adder2.getDisplay());
                }
            }
        });
        int n7 = this.getOptions().indexOf(adder);
        if (n7 < 0) {
            n7 = 0;
        }
        this.baseCost = adder.getBaseCost();
        for (Adder adder3 : arrayList) {
            Adder adder4;
            Adder adder5;
            if (adder3.getXMLID().equals("CONTINUING") && adder3.getSelectedOption() != null) {
                int n8 = (int)adder3.getSelectedOption().getLevelValue();
                double d2 = this.getOptions().get(this.getOptions().size() - 1).getBaseCost();
                d = this.getOptions().get(this.getOptions().size() - 2).getBaseCost();
                if (n7 + n8 + this.currentLevels < this.getOptions().size()) {
                    object = this.getOptions().get(n7 + n8 + this.currentLevels);
                    Adder adder6 = this.getOptions().get(n7 + this.currentLevels);
                    adder3.getSelectedOption().setBaseCost(((GenericObject)object).getBaseCost() - adder6.getBaseCost());
                } else if (n7 + this.currentLevels < this.getOptions().size() - 1) {
                    object = this.getOptions().get(n7 + this.currentLevels);
                    double d3 = d2 - ((GenericObject)object).getBaseCost();
                    n6 = n7 + n8 + this.currentLevels - (this.getOptions().size() - 1);
                    for (n5 = 0; n5 < n6; ++n5) {
                        d3 += d2 - d;
                    }
                    adder3.getSelectedOption().setBaseCost(d3);
                } else {
                    double d4 = 0.0;
                    for (n4 = 0; n4 < n8; ++n4) {
                        d4 += d2 - d;
                    }
                    adder3.getSelectedOption().setBaseCost(d4);
                }
                for (Adder adder6 : adder3.getOptions()) {
                    n4 = (int)adder6.getLevelValue();
                    if (n7 + n4 + this.currentLevels < this.getOptions().size()) {
                        Adder adder7 = this.getOptions().get(n7 + n4 + this.currentLevels);
                        Adder adder8 = this.getOptions().get(n7 + this.currentLevels);
                        adder6.setBaseCost(adder7.getBaseCost() - adder8.getBaseCost());
                        continue;
                    }
                    if (n7 + this.currentLevels < this.getOptions().size() - 1) {
                        Adder adder9 = this.getOptions().get(n7 + this.currentLevels);
                        double d5 = d2 - adder9.getBaseCost();
                        n3 = n7 + n4 + this.currentLevels - (this.getOptions().size() - 1);
                        for (n2 = 0; n2 < n3; ++n2) {
                            d5 += d2 - d;
                        }
                        adder6.setBaseCost(d5);
                        continue;
                    }
                    double d6 = 0.0;
                    for (n = 0; n < n4; ++n) {
                        d6 += d2 - d;
                    }
                    adder6.setBaseCost(d6);
                }
                object = adder3.getSelectedOption();
                adder3.setSelectedOption((Adder)object);
                this.currentLevels += n8;
                continue;
            }
            if (adder3.getXMLID().equals("BOOSTABLE")) {
                Adder adder10;
                Adder adder11;
                if (adder.getLevelValue() < 2.0) {
                    adder3.setSelectable(false);
                } else {
                    adder3.setSelectable(true);
                }
                if (n7 < this.getOptions().size() - this.boostableLevel - this.currentLevels) {
                    adder11 = this.getOptions().get(n7 + this.currentLevels);
                    adder10 = this.getOptions().get(n7 + this.boostableLevel + this.currentLevels);
                    adder3.setBaseCost(adder10.getBaseCost() - adder11.getBaseCost());
                    adder3.setMinimumCost(adder10.getBaseCost() - adder11.getBaseCost());
                    adder3.setMaxCost(adder10.getBaseCost() - adder11.getBaseCost());
                } else {
                    adder11 = this.getOptions().get(this.getOptions().size() - this.boostableLevel - 1);
                    adder10 = this.getOptions().get(this.getOptions().size() - 1);
                    adder3.setBaseCost(adder10.getBaseCost() - adder11.getBaseCost());
                    adder3.setMinimumCost(adder10.getBaseCost() - adder11.getBaseCost());
                    adder3.setMaxCost(adder10.getBaseCost() - adder11.getBaseCost());
                }
                this.currentLevels += this.boostableLevel;
                continue;
            }
            if (!adder3.getXMLID().equals("RECOVERABLE")) continue;
            if (n7 < this.getOptions().size() - this.recoverableLevel - this.currentLevels) {
                adder5 = this.getOptions().get(n7 + this.currentLevels);
                adder4 = this.getOptions().get(n7 + this.recoverableLevel + this.currentLevels);
                adder3.setBaseCost(adder4.getBaseCost() - adder5.getBaseCost());
                adder3.setMinimumCost(adder4.getBaseCost() - adder5.getBaseCost());
                adder3.setMaxCost(adder4.getBaseCost() - adder5.getBaseCost());
            } else {
                adder5 = this.getOptions().get(this.getOptions().size() - this.recoverableLevel - 1);
                adder4 = this.getOptions().get(this.getOptions().size() - 1);
                adder3.setBaseCost(adder4.getBaseCost() - adder5.getBaseCost());
                adder3.setMinimumCost(adder4.getBaseCost() - adder5.getBaseCost());
                adder3.setMaxCost(adder4.getBaseCost() - adder5.getBaseCost());
            }
            this.currentLevels += this.recoverableLevel;
        }
        this.updateClips();
        for (Adder adder3 : arrayList2) {
            if (adder3.getXMLID().equals("CONTINUING")) {
                int n9 = (int)adder3.getSelectedOption().getLevelValue();
                double d7 = this.getOptions().get(this.getOptions().size() - 1).getBaseCost();
                d = this.getOptions().get(this.getOptions().size() - 2).getBaseCost();
                if (n7 + n9 + this.currentLevels < this.getOptions().size()) {
                    object = this.getOptions().get(n7 + n9 + this.currentLevels);
                    Adder adder12 = this.getOptions().get(n7 + this.currentLevels);
                    adder3.getSelectedOption().setBaseCost(((GenericObject)object).getBaseCost() - adder12.getBaseCost());
                } else if (n7 + this.currentLevels < this.getOptions().size() - 1) {
                    object = this.getOptions().get(n7 + this.currentLevels);
                    double d8 = d7 - ((GenericObject)object).getBaseCost();
                    n6 = n7 + n9 + this.currentLevels - (this.getOptions().size() - 1);
                    for (n5 = 0; n5 < n6; ++n5) {
                        d8 += d7 - d;
                    }
                    adder3.getSelectedOption().setBaseCost(d8);
                } else {
                    double d9 = 0.0;
                    for (n4 = 0; n4 < n9; ++n4) {
                        d9 += d7 - d;
                    }
                    adder3.getSelectedOption().setBaseCost(d9);
                }
                for (Adder adder13 : adder3.getOptions()) {
                    n4 = (int)adder13.getLevelValue();
                    if (n7 + n4 + this.currentLevels < this.getOptions().size()) {
                        Adder adder14 = this.getOptions().get(n7 + n4 + this.currentLevels);
                        Adder adder15 = this.getOptions().get(n7 + this.currentLevels);
                        adder13.setBaseCost(adder14.getBaseCost() - adder15.getBaseCost());
                        continue;
                    }
                    if (n7 + this.currentLevels < this.getOptions().size() - 1) {
                        Adder adder16 = this.getOptions().get(n7 + this.currentLevels);
                        double d10 = d7 - adder16.getBaseCost();
                        n3 = n7 + n4 + this.currentLevels - (this.getOptions().size() - 1);
                        for (n2 = 0; n2 < n3; ++n2) {
                            d10 += d7 - d;
                        }
                        adder13.setBaseCost(d10);
                        continue;
                    }
                    double d11 = 0.0;
                    for (n = 0; n < n4; ++n) {
                        d11 += d7 - d;
                    }
                    adder13.setBaseCost(d11);
                }
                object = adder3.getSelectedOption();
                adder3.setSelectedOption((Adder)object);
                continue;
            }
            if (adder3.getXMLID().equals("BOOSTABLE")) {
                if (adder.getLevelValue() < 2.0) {
                    adder3.setSelectable(false);
                } else {
                    adder3.setSelectable(true);
                }
                if (n7 < this.getOptions().size() - this.boostableLevel - this.currentLevels) {
                    Adder adder17 = this.getOptions().get(n7 + this.currentLevels);
                    Adder adder18 = this.getOptions().get(n7 + this.boostableLevel + this.currentLevels);
                    adder3.setBaseCost(adder18.getBaseCost() - adder17.getBaseCost());
                    adder3.setMinimumCost(adder18.getBaseCost() - adder17.getBaseCost());
                    adder3.setMaxCost(adder18.getBaseCost() - adder17.getBaseCost());
                    continue;
                }
                Adder adder19 = this.getOptions().get(this.getOptions().size() - this.boostableLevel - 1);
                Adder adder20 = this.getOptions().get(this.getOptions().size() - 1);
                adder3.setBaseCost(adder20.getBaseCost() - adder19.getBaseCost());
                adder3.setMinimumCost(adder20.getBaseCost() - adder19.getBaseCost());
                adder3.setMaxCost(adder20.getBaseCost() - adder19.getBaseCost());
                continue;
            }
            if (!adder3.getXMLID().equals("RECOVERABLE")) continue;
            if (n7 < this.getOptions().size() - this.recoverableLevel - this.currentLevels) {
                Adder adder21 = this.getOptions().get(n7 + this.currentLevels);
                Adder adder22 = this.getOptions().get(n7 + this.recoverableLevel + this.currentLevels);
                adder3.setBaseCost(adder22.getBaseCost() - adder21.getBaseCost());
                adder3.setMinimumCost(adder22.getBaseCost() - adder21.getBaseCost());
                adder3.setMaxCost(adder22.getBaseCost() - adder21.getBaseCost());
                continue;
            }
            Adder adder23 = this.getOptions().get(this.getOptions().size() - 1);
            if (this.getOptions().size() - this.recoverableLevel - this.currentLevels - 1 >= 0) {
                adder23 = this.getOptions().get(this.getOptions().size() - this.recoverableLevel - this.currentLevels - 1);
            }
            Adder adder24 = this.getOptions().get(this.getOptions().size() - 2);
            if (this.getOptions().size() - this.currentLevels - 1 >= 0) {
                adder24 = this.getOptions().get(this.getOptions().size() - this.currentLevels - 1);
            }
            adder3.setBaseCost(adder24.getBaseCost() - adder23.getBaseCost());
            adder3.setMinimumCost(adder24.getBaseCost() - adder23.getBaseCost());
            adder3.setMaxCost(adder24.getBaseCost() - adder23.getBaseCost());
        }
    }

    private void updateClips() {
        try {
            int n;
            Adder adder;
            Adder adder2 = null;
            GenericObject genericObject = null;
            ArrayList arrayList = this.availableAdders;
            ArrayList arrayList2 = this.assignedAdders;
            double d = 0.0;
            double d2 = this.getBaseCost();
            for (Adder adder3 : arrayList) {
                if (!adder3.getXMLID().equals("CLIPS")) continue;
                adder2 = adder3;
                break;
            }
            for (Adder adder3 : arrayList2) {
                if (adder3.getXMLID().equals("CLIPS")) {
                    genericObject = adder3;
                    continue;
                }
                d += adder3.getTotalCost();
            }
            if (this.getSelectedOption() == null) {
                return;
            }
            double d3 = adder2.getBaseCost();
            if (genericObject != null) {
                d3 = genericObject.getBaseCost();
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = this.getOptions().indexOf(this.getSelectedOption());
            if (n4 < 0) {
                n4 = 0;
            }
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            Adder adder4 = this.getOptions().get(this.getOptions().size() - 1);
            Adder adder5 = this.getOptions().get(this.getOptions().size() - this.clipsLevel - 1);
            d5 = adder4.getBaseCost() - adder5.getBaseCost();
            if (d5 <= 0.0) {
                d5 = 0.25;
            }
            if (n4 + this.currentLevels < this.getOptions().size()) {
                d2 = this.getOptions().get(n4 + this.currentLevels).getBaseCost();
            } else {
                d2 = this.getOptions().get(this.getOptions().size() - 1).getBaseCost();
                for (int i = this.getOptions().size(); i < n4 + this.currentLevels; ++i) {
                    d2 += d5;
                }
            }
            if (n4 + this.currentLevels < this.getOptions().size() - this.clipsLevel) {
                Adder adder6 = this.getOptions().get(n4 + this.clipsLevel + this.currentLevels);
                adder = this.getOptions().get(n4 + this.currentLevels);
                d4 = adder6.getBaseCost() - adder.getBaseCost();
            } else {
                d4 = d5;
            }
            if (n4 + this.currentLevels < this.getOptions().size() - this.clipsLevel) {
                Adder adder7 = this.getOptions().get(n4 + this.clipsLevel + this.currentLevels);
                adder = this.getOptions().get(n4 + this.currentLevels);
                d6 = adder7.getBaseCost() - adder.getBaseCost();
            } else {
                d6 = d4;
            }
            if (genericObject == null) {
                d3 = d4;
            }
            boolean bl = false;
            for (n = n4 + 1 + this.currentLevels; n < this.getOptions().size() && n >= 0; n += this.clipsLevel) {
                double d7 = this.getOptions().get(n).getBaseCost();
                if (d7 <= d2 + d3) {
                    ++n2;
                    double d8 = this.getOptions().get(n - this.currentLevels).getBaseCost() + d;
                    if (!(d8 > 0.0)) continue;
                    ++n3;
                    continue;
                }
                bl = true;
                break;
            }
            if (!bl) {
                for (n = this.getOptions().size(); n < n4 + this.currentLevels; ++n) {
                    ++n2;
                    if (!(adder4.getBaseCost() + d + d4 * (double)(n - this.getOptions().size()) > 0.0)) continue;
                    ++n3;
                }
            }
            if (n4 + this.currentLevels < this.getOptions().size() - this.clipsLevel * n2 && n4 + this.currentLevels >= 0) {
                Adder adder8 = this.getOptions().get(n4 + this.currentLevels);
                Adder adder9 = this.getOptions().get(n4 + this.currentLevels + this.clipsLevel * n2);
                adder2.setBaseCost(adder9.getBaseCost() - adder8.getBaseCost());
                adder2.setLevelCost(0.0);
                adder2.setLevels(n2);
                adder2.setMinimumLevel(1);
                adder2.setMinimumCost(d4);
                adder2.setMaxCost(10.0);
                if (genericObject != null) {
                    genericObject.setBaseCost(adder9.getBaseCost() - adder8.getBaseCost());
                    genericObject.setLevelCost(0.0);
                    genericObject.setLevels(n2);
                    genericObject.setMinimumLevel(1);
                    genericObject.setMinimumCost(d4);
                    genericObject.setMaxCost(10.0);
                }
            } else {
                adder2.setBaseCost((double)n2 * d4);
                adder2.setMinimumCost(d4);
                adder2.setMinimumLevel(1);
                adder2.setLevels(n2);
                adder2.setLevelCost(0.0);
                adder2.setMaxCost(10.0);
                if (genericObject != null) {
                    adder2.setLevels(n2);
                    adder2.setMinimumLevel(1);
                    genericObject.setBaseCost((double)n2 * d4);
                    genericObject.setLevelCost(0.0);
                    genericObject.setMinimumCost(d4);
                    genericObject.setMaxCost(10.0);
                }
            }
            int n5 = 1;
            n5 = (int)Math.pow(this.clipsMultiplier, n2 - n3);
            if (n3 > 0) {
                if (n2 - n3 <= 0) {
                    n5 = 1;
                }
                n5 *= (int)Math.pow(this.clipsAdvantageMultiplier, n3);
            }
            adder2.setDisplay(n5 + " clips");
            adder2.setAlias(adder2.getDisplay());
            if (genericObject != null) {
                genericObject.setDisplay(n5 + " clips");
                genericObject.setAlias(genericObject.getDisplay());
                this.currentLevels += this.clipsLevel * n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean useMultiplier() {
        return false;
    }

    private void validationCheck() {
        if (this.getProgenitor() == null || GenericObject.findObjectByID(this.getProgenitor().getAssignedModifiers(), "LINGERING") != null || GenericObject.findObjectByID(this.getProgenitor().getAssignedModifiers(), "TIMELIMIT") != null || !(this.getProgenitor() instanceof Power) || !((Power)this.getProgenitor()).getDuration().equals("INSTANT") || this.getProgenitor().getIsPrefab()) {
            return;
        }
        for (int i = this.getAssignedAdders().size() - 1; i >= 0; --i) {
            Adder adder = this.getAssignedAdders().get(i);
            if (adder.getXMLID().equals("CONTINUING")) {
                this.getAssignedAdders().remove(i);
                continue;
            }
            if (adder.getXMLID().indexOf("FUEL") < 0) continue;
            this.getAssignedAdders().remove(i);
        }
    }
}

