/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Strength;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Absorption;
import com.hero.objects.powers.Aid;
import com.hero.objects.powers.Dispel;
import com.hero.objects.powers.Drain;
import com.hero.objects.powers.Healing;
import com.hero.objects.powers.Images;
import com.hero.objects.powers.NakedModifier;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.Succor;
import com.hero.objects.powers.Suppress;
import com.hero.objects.powers.Transfer;
import com.hero.objects.powers.Transform;
import com.hero.util.Rounder;
import java.util.ArrayList;
import org.jdom.Element;

public class Autofire
extends Modifier {
    private static String xmlID = "AUTOFIRE";
    private boolean surcharge;

    public Autofire(Element element) {
        super(element, xmlID);
    }

    public boolean surchargeIncluded() {
        this.getTotalValue();
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "ODDPOWER") != null) {
            return true;
        }
        return this.surcharge;
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject instanceof Strength) {
            return "";
        }
        if (genericObject instanceof Maneuver) {
            return "";
        }
        if (genericObject instanceof Absorption) {
            return "";
        }
        if (genericObject.getTarget().equals("SELFONLY") || genericObject.getTarget().equals("N/A")) {
            return this.getDisplay() + " can only be applied to abilities which require an Attack Roll";
        }
        return "";
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        int n = this.getSelectedOption().getLevels();
        if (!this.getSelectedOption().getAlias().equals(this.getSelectedOption().getDisplay())) {
            String string3 = "";
            for (int i = 0; i < this.getSelectedOption().getAlias().length(); ++i) {
                if (Character.isDigit(this.getSelectedOption().getAlias().charAt(i))) {
                    string3 = string3 + this.getSelectedOption().getAlias().charAt(i);
                    continue;
                }
                if (i > 0) break;
            }
            if (string3.length() > 0) {
                n = Integer.parseInt(string3);
            }
        }
        int n2 = 1;
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (genericObject.getXMLID().equals("DOUBLE")) {
                n2 = (int)Math.pow(genericObject.getLevelPower(), genericObject.getLevels());
                continue;
            }
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + genericObject.getAlias() + " (" + this.getFraction(genericObject.getBaseCost()) + ")";
            d -= genericObject.getBaseCost();
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ":  ";
            }
            string2 = string2 + this.getInput();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        string2 = string2 + n * n2 + " shots;";
        string2 = string2 + " ";
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public double getTotalValue() {
        double d = this.getBaseCost();
        for (Adder adder : this.getAssignedAdders()) {
            d += adder.getDoubleTotal();
        }
        if (this.getLevelValue() > 0.0) {
            d += (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
        }
        double d2 = 0.0;
        for (Modifier modifier : this.getAssignedModifiers()) {
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        double d3 = d * (1.0 + d2);
        double d4 = 0.0;
        for (GenericObject genericObject : this.assignedModifiers) {
            if (!(((Modifier)genericObject).getTotalValue() < 0.0)) continue;
            d4 += Math.abs(((Modifier)genericObject).getTotalValue());
        }
        d = d3 / (1.0 + d4);
        d *= 4.0;
        int n = 1;
        if (d < 0.0) {
            n = -1;
        }
        d *= (double)n;
        d = Rounder.roundHalfUp(d);
        d *= (double)n;
        d /= 4.0;
        this.surcharge = false;
        if (this.parent != null) {
            if (this.parent instanceof Power && !(this.parent instanceof NakedModifier) && !(this.parent instanceof Images) && !(this.parent instanceof Absorption)) {
                GenericObject genericObject;
                genericObject = (Power)this.parent;
                ArrayList<Modifier> arrayList = genericObject.getAssignedModifiers();
                ArrayList<Modifier> arrayList2 = genericObject.getAllAssignedModifiers();
                genericObject.setAssignedModifiers(arrayList2);
                if (!genericObject.getTarget().equals("DCV")) {
                    this.surcharge = true;
                }
                if (genericObject.getTypes().contains("MENTAL")) {
                    this.surcharge = true;
                }
                if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "NND") != null) {
                    this.surcharge = true;
                }
                if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "AVLD") != null) {
                    this.surcharge = true;
                }
                genericObject.setAssignedModifiers(arrayList);
                if (genericObject instanceof Drain) {
                    this.surcharge = true;
                }
                if (genericObject instanceof Transform) {
                    this.surcharge = true;
                }
                if (genericObject instanceof Transfer) {
                    this.surcharge = true;
                }
                if (genericObject instanceof Aid) {
                    this.surcharge = true;
                }
                if (genericObject instanceof Dispel) {
                    this.surcharge = true;
                }
                if (genericObject instanceof Healing) {
                    this.surcharge = true;
                }
                if (genericObject instanceof Succor) {
                    this.surcharge = true;
                }
                if (genericObject instanceof Suppress) {
                    this.surcharge = true;
                }
            }
            if (GenericObject.findObjectByID(this.getAssignedAdders(), "ODDPOWER") != null) {
                this.surcharge = false;
            }
        }
        if (this.surcharge && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
            d += 1.0;
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            return this.getMinimumCost();
        }
        if (d > this.getMaxCost() && this.isMaxSet()) {
            return this.getMaxCost();
        }
        return d;
    }
}

