/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Autofire;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Absorption;
import com.hero.objects.powers.LifeSupport;
import com.hero.objects.powers.NakedModifier;
import com.hero.util.Rounder;
import java.text.NumberFormat;
import org.jdom.Element;

public class AreaEffect
extends Modifier {
    private static String xmlID = "AOE";

    public AreaEffect(Element element) {
        super(element, xmlID);
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject instanceof NakedModifier || genericObject instanceof LifeSupport || genericObject instanceof Absorption) {
            return "";
        }
        if (genericObject.getXMLID().equals("POSSESSION")) {
            return this.getDisplay() + " cannot be applied to Possession.";
        }
        if (genericObject.getXMLID().equals("IMAGES") && HeroDesigner.getActiveTemplate().is6E()) {
            return "";
        }
        if (genericObject.getTarget().equals("HEX")) {
            if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "AOE") == null) {
                return this.getDisplay() + " cannot be applied to Powers which already affect an area.";
            }
        }
        if (!(genericObject.getTarget().equals("DCV") || genericObject.getTarget().equals("ECV") || genericObject.getTarget().equals("OCV") || genericObject.getTarget().equals("OMCV") || genericObject.getTarget().equals("MCV") || genericObject.getTarget().equals("DMCV"))) {
            if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "AOE") == null) {
                return this.getDisplay() + " can only be applied to Powers which are targeted on others.";
            }
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "EXPLOSION") != null) {
            return this.getDisplay() + " cannot be applied to abilities which already affect an area.";
        }
        return "";
    }

    @Override
    public String getLevelInfo() {
        return this.getArea(null);
    }

    public String getArea(GenericObject genericObject) {
        GenericObject genericObject2;
        String string = "";
        if (HeroDesigner.getActiveTemplate().is6E()) {
            Adder adder = this.getSelectedOption();
            if (adder == null) {
                return string;
            }
            String string2 = "" + NumberFormat.getInstance().format(this.getLevels());
            if (adder.getXMLID().equals("RADIUS")) {
                string = string + string2 + "m Radius";
            } else if (adder.getXMLID().equals("CONE")) {
                string = string + string2 + "m Cone";
            } else if (adder.getXMLID().equals("LINE")) {
                Object object;
                string = string + string2 + "m";
                if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT") != null) {
                    object = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT");
                    ((Adder)object).setDisplayInString(false);
                    this.multiplier = ((GenericObject)object).getLevels();
                    string = string + " Long, " + NumberFormat.getInstance().format(this.multiplier) + "m Tall";
                }
                if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEWIDTH") != null) {
                    object = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEWIDTH");
                    ((Adder)object).setDisplayInString(false);
                    this.multiplier = ((GenericObject)object).getLevels();
                    string = GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT") != null ? string + ", " + NumberFormat.getInstance().format(this.multiplier) + "m Wide" : string + " Long, 2m Tall, " + NumberFormat.getInstance().format(this.multiplier) + "m Wide";
                } else if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT") != null) {
                    string = string + ", 2m Wide";
                }
                string = string + " Line";
            } else if (adder.getXMLID().equals("ANY")) {
                string = string + string2 + " 2m Areas";
            } else if (adder.getXMLID().equals("SURFACE")) {
                string = string + string2 + "m Surface";
            }
            for (Adder adder2 : this.getAssignedAdders()) {
                if (!adder2.getXMLID().equals("EXPLOSION")) continue;
                adder2.setDisplayInString(false);
                string = string + " Explosion";
            }
            return string;
        }
        if (genericObject == null) {
            return "";
        }
        Adder adder = this.getSelectedOption();
        if (adder == null) {
            return "";
        }
        if (adder.getXMLID().equals("TRAIL")) {
            return adder.getAlias();
        }
        int n = 1;
        double d = this.parent.getActiveCost(this.getXMLID());
        if (GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "AUTOFIRE") != null && ((Autofire)(genericObject2 = (Autofire)GenericObject.findObjectByID(this.parent.getAssignedModifiers(), "AUTOFIRE"))).surchargeIncluded()) {
            d -= this.parent.getTotalCost();
        }
        if (this.parent instanceof NakedModifier) {
            genericObject2 = (NakedModifier)this.parent;
            d = ((CharAffectingObject)genericObject2).getLevels();
            string = "up to ";
        }
        double d2 = 0.0;
        for (int i = 0; i < this.parent.getAssignedModifiers().size(); ++i) {
            Modifier modifier = this.parent.getAssignedModifiers().get(i);
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        Adder adder3 = null;
        for (Adder adder4 : this.getAssignedAdders()) {
            if (!adder4.getXMLID().equals("DOUBLEAREA")) continue;
            adder3 = adder4;
            adder4.setDisplayInString(false);
            n = (int)Math.pow(adder4.getLevelPower(), adder4.getLevels());
            break;
        }
        int n2 = 1;
        int n3 = (int)Rounder.roundHalfUp(d / 10.0);
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = (int)Rounder.roundHalfUp((double)n * (double)n3);
        n2 = n3;
        if (n4 < 1) {
            n4 = 1;
            n2 = 1;
        }
        int n5 = (int)Rounder.roundHalfUp((double)n * d / 5.0);
        if (d < 5.0) {
            n5 = (int)Rounder.roundHalfUp((double)n * 1.0);
        }
        if (adder.getXMLID().equals("HEX")) {
            if (n > 1) {
                if (n >= n2) {
                    if (adder3 != null && adder3.getLevels() == 1) {
                        this.getAssignedAdders().remove(adder3);
                    }
                    adder3.setLevels(adder3.getLevels() - 1);
                    return this.getArea(genericObject);
                }
                string = string + n + "\" radius";
            } else {
                string = string + "One Hex";
            }
        } else if (adder.getXMLID().equals("RADIUS")) {
            string = string + n4 + "\" Radius";
        } else if (adder.getXMLID().equals("CONE")) {
            string = string + (1 + n5) + "\" Cone";
        } else if (adder.getXMLID().equals("LINE")) {
            Adder adder5;
            string = string + n5 * 2 + "\"";
            if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLELENGTH") != null) {
                adder5 = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLELENGTH");
                adder5.setDisplayInString(false);
                if (n == 1) {
                    n = 0;
                }
                n5 = (int)Rounder.roundHalfUp((double)(n += (int)Math.pow(adder5.getLevelPower(), adder5.getLevels())) * d / 5.0);
                string = n5 * 2 + "\"";
            }
            if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT") != null) {
                adder5 = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT");
                adder5.setDisplayInString(false);
                n = (int)Math.pow(adder5.getLevelPower(), adder5.getLevels());
                string = string + " Long, " + n + "\" Tall";
            }
            if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEWIDTH") != null) {
                adder5 = (Adder)GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEWIDTH");
                adder5.setDisplayInString(false);
                n = (int)Math.pow(adder5.getLevelPower(), adder5.getLevels());
                string = GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT") != null ? string + ", " + n + "\" Wide" : string + " Long, 1\" Tall, " + n + "\" Wide";
            } else if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT") != null) {
                string = string + ", 1\" Wide";
            }
            string = string + " Line";
        } else if (adder.getXMLID().equals("ANY")) {
            string = string + n4 + "\" Any Area";
        }
        return string;
    }

    @Override
    public double getTotalValue() {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            int n;
            double d = this.getBaseCost();
            for (Adder adder : this.getAvailableAdders()) {
                if (!adder.getXMLID().equals("DOUBLEHEIGHT") && !adder.getXMLID().equals("DOUBLEWIDTH")) continue;
                adder.setDisplayInString(false);
                n = (int)Math.ceil(Math.log((double)adder.getLevels() / (double)adder.getLevelMultiplier()) / Math.log(adder.getLevelPower()));
                if (--n < 1) {
                    n = 1;
                }
                adder.setBaseCost(0.0);
                adder.setBaseCost((double)n * adder.getLevelCost() - adder.getDoubleTotal());
            }
            for (Adder adder : this.getAssignedAdders()) {
                if (adder.getXMLID().equals("DOUBLEHEIGHT") || adder.getXMLID().equals("DOUBLEWIDTH")) {
                    adder.setDisplayInString(false);
                    n = (int)Math.ceil(Math.log((double)adder.getLevels() / (double)adder.getLevelMultiplier()) / Math.log(adder.getLevelPower()));
                    if (--n < 1) {
                        n = 1;
                    }
                    d += (double)n * adder.getLevelCost();
                    adder.setBaseCost(0.0);
                    adder.setBaseCost((double)n * adder.getLevelCost() - adder.getDoubleTotal());
                    continue;
                }
                if (adder.getXMLID().equals("MOBILE")) {
                    n = (int)Math.ceil(Math.log((double)adder.getLevels() / (double)adder.getLevelMultiplier()) / Math.log(adder.getLevelPower()));
                    if (n < 1) {
                        n = 1;
                    }
                    d += (double)n * adder.getLevelCost() + adder.getOrigBaseCost();
                    adder.setBaseCost(0.0);
                    adder.setBaseCost(adder.getOrigBaseCost() + (double)n * adder.getLevelCost() - adder.getDoubleTotal());
                    continue;
                }
                d += adder.getDoubleTotal();
            }
            int n2 = (int)Math.ceil(Math.log((double)this.getLevels() / (double)this.getLevelMultiplier()) / Math.log(this.getLevelPower()));
            if (n2 < 1) {
                n2 = 1;
            }
            if (this.getProgenitor() != null && this.getProgenitor().getXMLID().equals("IMAGES") && this.getLevels() == 1) {
                n2 = 0;
            }
            d += (double)n2 * this.getLevelCost();
            double d2 = 0.0;
            for (Modifier modifier : this.getAssignedModifiers()) {
                if (!(modifier.getTotalValue() > 0.0)) continue;
                d2 += modifier.getTotalValue();
            }
            double d3 = d * (1.0 + d2);
            double d4 = 0.0;
            for (Modifier modifier : this.getAssignedModifiers()) {
                if (!(modifier.getTotalValue() < 0.0)) continue;
                d4 += Math.abs(modifier.getTotalValue());
            }
            d = d3 / (1.0 + d4);
            d *= 4.0;
            int n3 = 1;
            if (d < 0.0) {
                n3 = -1;
            }
            d *= (double)n3;
            d = Rounder.roundHalfUp(d);
            d *= (double)n3;
            if ((d /= 4.0) < this.getMinimumCost() && this.isMinSet()) {
                return this.getMinimumCost();
            }
            if (d > this.getMaxCost() && this.isMaxSet()) {
                return this.getMaxCost();
            }
            return d;
        }
        return super.getTotalValue();
    }

    @Override
    public void setSelectedOption(Adder adder) {
        boolean bl = false;
        if (this.getSelectedOption() != null && this.getSelectedOption().equals(adder)) {
            bl = true;
        }
        super.setSelectedOption(adder);
        if (bl) {
            return;
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEAREA") != null) {
            this.getAssignedAdders().remove(GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEAREA"));
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLELENGTH") != null) {
            this.getAssignedAdders().remove(GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLELENGTH"));
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEWIDTH") != null) {
            this.getAssignedAdders().remove(GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEWIDTH"));
        }
        if (GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT") != null) {
            this.getAssignedAdders().remove(GenericObject.findObjectByID(this.getAssignedAdders(), "DOUBLEHEIGHT"));
        }
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = this.getArea(this.parent);
        String string3 = this.getAlias();
        double d = this.getTotalValue();
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.getXMLID().equals("ACCURATE")) {
                string3 = string3 + " " + adder.getAlias();
                adder.setDisplayInString(false);
                continue;
            }
            if (adder.getXMLID().equals("NONSELECTIVETARGET")) {
                string3 = string3 + " " + adder.getAlias();
                continue;
            }
            if (adder.getXMLID().equals("DOUBLEAREA")) continue;
            if (adder.getXMLID().equals("MOBILE")) {
                if (string.trim().length() > 0) {
                    string = string + ", ";
                }
                string = string + adder.getAlias();
                int n = (int)Math.ceil(Math.log((double)adder.getLevels() / (double)adder.getLevelMultiplier()) / Math.log(adder.getLevelPower()));
                if (n < 1) {
                    n = 1;
                }
                string = string + " (" + adder.getLevels() + "m per Phase; " + this.getFraction(adder.getDoubleTotal()) + ")";
                adder.setDisplayInString(false);
                continue;
            }
            if (!adder.displayInString()) continue;
            d -= adder.getBaseCost();
            if (string.trim().length() > 0) {
                string = string + ", ";
            }
            string = string + adder.getAlias() + " (" + this.getFraction(adder.getBaseCost()) + ")";
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            if (string3.trim().length() > 0) {
                string3 = string3 + ":  ";
            }
            string3 = string3 + this.getInput();
        }
        string3 = string3 + " (" + string2 + "; ";
        if (this.getComments().trim().length() > 0) {
            string3 = string3 + this.getComments() + "; ";
        }
        string3 = string3 + this.getFraction(d) + ")";
        if (string.trim().length() > 0) {
            string3 = string3 + ", ";
            string3 = string3 + string;
        }
        return string3;
    }
}

