/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.modifiers;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.NakedModifier;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class AVLD
extends Modifier {
    private static String xmlID = "AVLD";
    private double nonStandardCost = 0.75;
    private Adder commonDefense = new Adder();

    public AVLD(Element element) {
        super(element, xmlID);
        this.commonDefense.setFixedValue(true);
        this.commonDefense.setXMLID("COMMONDEFENSE");
        this.commonDefense.setSelectable(true);
        this.commonDefense.setDisplayInString(false);
        this.commonDefense.setDisplay("Defense is Extraordinarily Common");
        this.commonDefense.setBaseCost(0.0);
        this.commonDefense.setExclusive(true);
    }

    @Override
    public double getBaseCost() {
        if (this.isStandardDefense() && AVLD.findObjectByID(this.getAssignedAdders(), "COMMONDEFENSE") == null) {
            return this.baseCost;
        }
        return this.nonStandardCost;
    }

    @Override
    public ArrayList<Adder> getAvailableAdders() {
        ArrayList arrayList = (ArrayList)super.getAvailableAdders().clone();
        if (this.isStandardDefense() && AVLD.findObjectByID(this.getAssignedAdders(), "COMMONDEFENSE") == null) {
            arrayList.add(this.commonDefense);
        } else if (this.isStandardDefense()) {
            arrayList.add((Adder)AVLD.findObjectByID(this.getAssignedAdders(), "COMMONDEFENSE"));
        }
        return arrayList;
    }

    private boolean isStandardDefense() {
        return this.parent == null || this.parent.getDefense("AVLD").equals("NORMAL") || this.parent instanceof NakedModifier;
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        String string2 = "";
        string2 = string2 + this.getAlias();
        double d = this.getTotalValue();
        for (Adder genericObject : this.getAssignedAdders()) {
            if (genericObject.displayInString()) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + genericObject.getAlias() + " (" + this.getFraction(genericObject.getBaseCost()) + ")";
            }
            d -= genericObject.getBaseCost();
        }
        for (Modifier modifier : this.getAssignedModifiers()) {
            string2 = string2 + ", " + modifier.getAlias();
        }
        string2 = string2 + " (";
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string2 = string2 + this.getInput();
            string2 = string2 + "; ";
        }
        if (this.getComments().trim().length() > 0) {
            string2 = string2 + this.getComments() + "; ";
        }
        string2 = string2 + this.getFraction(d) + ")";
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    @Override
    public double getMaxCost() {
        return this.getBaseCost();
    }

    @Override
    public double getMinimumCost() {
        return this.getBaseCost();
    }

    @Override
    public String included(GenericObject genericObject) {
        String string = super.included(genericObject);
        if (string.trim().length() > 0) {
            return string;
        }
        if (this.forceAllow()) {
            return string;
        }
        if (genericObject instanceof NakedModifier) {
            return "";
        }
        if (genericObject.getTarget().equals("SELFONLY") || genericObject.getTarget().equals("N/A")) {
            return this.getDisplay() + " can only be applied to abilities which affect others.";
        }
        if (genericObject.getDefense().equals("NONE")) {
            return this.getDisplay() + " can only be applied to abilities which act against one of the standard Defense types (Normal, Power, Flash, Mental).";
        }
        return "";
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        this.availableCheck = false;
        String string = XMLUtility.getValue(element, "NONSTANDARDDEFENSE");
        if (string != null && string.trim().length() > 0) {
            try {
                this.nonStandardCost = Double.parseDouble(string);
            }
            catch (Exception exception) {
                this.nonStandardCost = 0.75;
            }
        }
    }
}

