/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.martialarts;

import com.hero.HeroDesigner;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.martialarts.ExtraDamageClasses;
import com.hero.objects.martialarts.RangedDamageClasses;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Automaton;
import com.hero.ui.dialog.CustomManeuverDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.ManeuverDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Element;

public class Maneuver
extends GenericObject {
    public static final int NONE = 0;
    public static final int STR = 1;
    public static final int NORMAL = 2;
    public static final int KILLING = 3;
    public static final int NND = 4;
    public static final int FLASH = 5;
    private int damageType = 0;
    private boolean custom = false;
    private String OCV;
    private String DCV;
    private String phase;
    private String effect;
    private String weaponEffect;
    private int ranged;
    private String category;
    private boolean useWeapon;
    private int dcs;
    private boolean addSTR;
    private int activeCost;
    private int maxSTR;
    private int STRMultiplier;

    public int getDamageType() {
        return this.damageType;
    }

    public void setDamageType(int n) {
        this.damageType = n;
    }

    @Override
    public double getActiveCost() {
        return this.getRealCostPreList();
    }

    private double getActiveCostForEND(GenericObject genericObject) {
        double d = 0.0;
        double d2 = this.getBaseCost();
        this.baseCost = this.getEffectiveActiveCost();
        if (this.baseCost > 0.0) {
            double d3 = this.getTotalCost();
            double d4 = 0.0;
            boolean bl = false;
            for (Modifier object : this.getAssignedModifiers()) {
                if (genericObject != null && object.getXMLID().equals(genericObject.getXMLID()) || !(object.getTotalValue() > 0.0)) continue;
                d4 += object.getTotalValue();
                bl = true;
            }
            Object object = this.getParentList();
            if (object == null && this.getMainPower() != null) {
                object = this.getMainPower().getParentList();
            }
            if (object != null) {
                for (Modifier modifier : ((GenericObject)object).getAssignedModifiers()) {
                    if (genericObject != null && modifier.getXMLID().equals(genericObject.getXMLID()) || modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && object instanceof Multipower || !(modifier.getTotalValue() > 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER") || object instanceof Multipower || object instanceof ElementalControl) continue;
                    d4 += modifier.getTotalValue();
                    bl = true;
                }
            }
            double d5 = d3 * (1.0 + d4);
            if (bl) {
                d5 = Rounder.roundHalfDown(d5);
            }
            d += d5 - this.baseCost;
        }
        this.baseCost = d2;
        return d;
    }

    @Override
    public double getRealCostPreList() {
        double d;
        double d2 = d = this.getBaseCost();
        this.baseCost = this.getEffectiveActiveCost();
        if (this.baseCost > 0.0) {
            if ((d += super.getActiveCost("REDUCEDEND") - this.baseCost) < d2) {
                d = d2;
            }
            ArrayList arrayList = (ArrayList)this.getAssignedModifiers().clone();
            if (this.getParentList() != null) {
                arrayList.addAll(this.getParentList().getAssignedModifiers());
            }
            if (GenericObject.findObjectByID(arrayList, "REDUCEDEND") != null) {
                Modifier modifier = (Modifier)GenericObject.findObjectByID(arrayList, "REDUCEDEND");
                int n = (int)Rounder.roundHalfDown((d - d2) * (1.0 + modifier.getTotalValue()) - (d - d2));
                d += (double)n;
            }
            boolean bl = false;
            double d3 = 0.0;
            for (Object object : this.assignedModifiers) {
                if (!(((Modifier)object).getTotalValue() < 0.0)) continue;
                d3 += ((Modifier)object).getTotalValue();
                bl = true;
            }
            Object object = this.getParentList();
            if (object == null && this.getMainPower() != null) {
                object = this.getMainPower().getParentList();
            }
            if (object != null) {
                for (Modifier modifier : ((GenericObject)object).getAssignedModifiers()) {
                    if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() < 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER")) continue;
                    d3 += modifier.getTotalValue();
                    bl = true;
                }
            }
            d /= 1.0 + Math.abs(d3);
            if (bl) {
                d = Rounder.roundHalfDown(d);
            }
            if (d < 1.0) {
                d = 1.0;
            }
        }
        this.baseCost = d2;
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d *= this.getMultiplier();
            d = Rounder.roundHalfDown(d);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
            d *= this.getParentList().getMultiplier();
            d = Rounder.roundHalfDown(d);
        }
        if (this.getQuantity() > 1) {
            int n = 0;
            for (double d4 = (double)this.getQuantity(); d4 > 1.0; d4 /= 2.0) {
                ++n;
            }
            d += (double)(n * 5);
        }
        return d;
    }

    @Override
    public String getXMLID() {
        return "MANEUVER";
    }

    public Maneuver(Element element) {
        super(element);
        this.target = "DCV";
        this.doesBODY = true;
        if (this.effect.indexOf("NNDDC") >= 0) {
            this.doesBODY = false;
        }
        if (this.effect.indexOf("FLASHDC") >= 0) {
            this.doesBODY = false;
        }
        if (this.effect.indexOf("FLASHDC") >= 0) {
            this.doesKnockback = false;
        }
        this.killing = false;
        if (this.effect.indexOf("KILLINGDC") >= 0) {
            this.killing = true;
        }
        this.visible = true;
        this.usesEND = true;
    }

    public double getEffectiveActiveCost() {
        double d = this.activeCost;
        if (this.addSTR) {
            HeroDesigner.getInstance();
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(1);
            if (characteristic != null) {
                double d2 = characteristic.getSecondaryValue();
                if (this.maxSTR > 0 && d2 > (double)this.maxSTR) {
                    d2 = this.maxSTR;
                }
                d += d2 * characteristic.getLevelCost() / characteristic.getLevelValue() * (double)this.STRMultiplier;
            }
        }
        if (this.doesDamage()) {
            boolean bl = this.getCategory().trim().toUpperCase().startsWith("HAND");
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getManeuvers()) {
                if (bl && genericObject.getXMLID().equals("EXTRADC")) {
                    d += (double)(genericObject.getLevels() * 5);
                    continue;
                }
                if (bl || !genericObject.getXMLID().equals("RANGEDDC")) continue;
                d += (double)(genericObject.getLevels() * 5);
            }
        }
        if (d < 1.0) {
            d = 1.0;
        }
        return d;
    }

    public void setManeuverActiveCost(int n) {
        this.activeCost = n;
    }

    public int getManeuverActiveCost() {
        return this.activeCost;
    }

    public static String getFraction(double d) {
        String string = "";
        if (d == 0.0) {
            return "+0";
        }
        string = d < 0.0 ? string + "-" : string + "+";
        if ((d = Math.abs(d)) > 1.0) {
            string = string + (int)Rounder.roundDown(d);
            d -= (double)Rounder.roundDown(d);
        }
        if (d == 0.0) {
            return string;
        }
        String string2 = "";
        double d2 = 1.0;
        if (Math.abs(0.25 - d) < d2) {
            d2 = Math.abs(0.25 - d);
            string2 = "1/4";
        }
        if (Math.abs(0.5 - d) < d2) {
            d2 = Math.abs(0.5 - d);
            string2 = "1/2";
        }
        if (Math.abs(0.75 - d) < d2) {
            d2 = Math.abs(0.75 - d);
            string2 = "3/4";
        }
        if (Math.abs(1.0 - d) < d2) {
            string2 = "";
            if (string.length() > 1) {
                int n = Integer.parseInt(string.substring(1, string.length()));
                string = string.substring(0, 1) + (n + 1);
            } else {
                string = string + 1;
            }
        }
        if (string.length() > 1) {
            string = string + " ";
        }
        string = string + string2;
        string = string.trim();
        return string;
    }

    public void setCustom(boolean bl) {
        this.custom = bl;
        this.minimumCost = 1.0;
        this.minSet = true;
        this.maxSet = true;
        this.maxCost = 5.0;
    }

    public int getOCVValue() {
        String string = this.OCV.trim();
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getDCVValue() {
        String string = this.DCV.trim();
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    protected void init(Element element) {
        int n;
        this.display = "???";
        this.alias = "???";
        this.baseCost = 3.0;
        this.levelCost = 0.0;
        this.levelValue = 0.0;
        this.minimumCost = 3.0;
        this.minimumLevel = 0;
        this.OCV = "--";
        this.DCV = "--";
        this.phase = "1/2";
        this.effect = "";
        this.weaponEffect = "";
        this.ranged = 0;
        this.category = "Hand To Hand";
        this.dcs = 0;
        this.useWeapon = false;
        super.init(element);
        if (this.types == null) {
            this.types = new ArrayList();
        }
        this.types.add("ATTACK");
        String string = XMLUtility.getValue(element, "OCV");
        if (string != null && string.trim().length() > 0) {
            try {
                this.OCV = string;
                n = Integer.parseInt(string);
                if (n >= 0) {
                    this.OCV = "+" + this.OCV;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.custom = (string = XMLUtility.getValue(element, "CUSTOM")) != null && string.trim().toUpperCase().startsWith("Y");
        string = XMLUtility.getValue(element, "ALLOWSOTHERADDERS");
        this.allowsOtherAdders = string != null && string.trim().toUpperCase().startsWith("Y");
        string = XMLUtility.getValue(element, "DCV");
        if (string != null && string.trim().length() > 0) {
            try {
                this.DCV = string;
                n = Integer.parseInt(string);
                if (n >= 0) {
                    this.DCV = "+" + this.DCV;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "RANGE")) != null && string.trim().length() > 0) {
            try {
                this.ranged = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "ACTIVECOST")) != null && string.trim().length() > 0) {
            try {
                this.activeCost = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "MAXSTR")) != null && string.trim().length() > 0) {
            try {
                this.maxSTR = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "STRMULT")) != null && string.trim().length() > 0) {
            try {
                this.STRMultiplier = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.STRMultiplier = 1;
            }
        } else {
            this.STRMultiplier = 1;
        }
        if (this.STRMultiplier < 1) {
            this.STRMultiplier = 1;
        }
        this.addSTR = (string = XMLUtility.getValue(element, "ADDSTR")) != null && string.trim().toUpperCase().startsWith("Y");
        string = XMLUtility.getValue(element, "DC");
        if (string != null && string.trim().length() > 0) {
            try {
                this.dcs = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "CATEGORY")) != null && string.trim().length() > 0) {
            this.category = string;
        }
        if ((string = XMLUtility.getValue(element, "PHASE")) != null && string.trim().length() > 0) {
            this.phase = string;
        }
        if ((string = XMLUtility.getValue(element, "EFFECT")) != null && string.trim().length() > 0) {
            this.effect = string;
        }
        if ((string = XMLUtility.getValue(element, "WEAPONEFFECT")) != null && string.trim().length() > 0) {
            this.weaponEffect = string;
        }
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Maneuver) {
            Maneuver maneuver = (Maneuver)object;
            if (this.getCategory().equals(maneuver.getCategory())) {
                return this.getDisplay().compareTo(maneuver.getDisplay());
            }
            return this.getCategory().compareTo(maneuver.getCategory());
        }
        return this.toString().compareTo(object.toString());
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public void setDCV(String string) {
        this.DCV = string;
    }

    public String getDCV() {
        return this.DCV;
    }

    String replace(String string, String string2, String string3) {
        while (string.indexOf(string2) >= 0) {
            if (string.indexOf(string2) == 0) {
                string = string3.trim() + " " + string.substring(string2.length(), string.length()).trim();
                continue;
            }
            if (string3.trim().length() == 0) {
                string3 = " ";
            }
            String string4 = string.substring(0, string.indexOf(string2));
            String string5 = string.substring(string.indexOf(string2) + string2.length(), string.length());
            string = string4.trim() + " " + string3.trim() + " " + string5.trim();
        }
        return string.trim();
    }

    public double getTotalDC(boolean bl, boolean bl2) {
        double d;
        double d2 = d = (double)this.getTotalDCNoSTR();
        if (this.addSTR) {
            HeroDesigner.getInstance();
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(1);
            if (characteristic != null) {
                if (bl) {
                    if (characteristic.getPrimaryValue() > 0.0) {
                        d += characteristic.getPrimaryValue() / 5.0;
                    }
                } else if (characteristic.getSecondaryValue() > 0.0) {
                    d += characteristic.getSecondaryValue() / 5.0;
                }
            }
        }
        if (bl2 && d > d2 * 2.0) {
            d = d2 * 2.0;
        }
        if (bl2 && this.maxSTR > 0) {
            this.maxSTR = (int)(d - d2) * 5;
        }
        return d;
    }

    public int getTotalDCNoSTR() {
        int n = this.dcs;
        boolean bl = true;
        if (this.getCategory().equalsIgnoreCase("RANGED")) {
            bl = false;
        }
        if (HeroDesigner.getActiveHero() != null) {
            for (GenericObject genericObject : HeroDesigner.getActiveHero().getManeuvers()) {
                if (genericObject instanceof ExtraDamageClasses && bl) {
                    n += genericObject.getLevels();
                    continue;
                }
                if (!(genericObject instanceof RangedDamageClasses) || bl) continue;
                n += genericObject.getLevels();
            }
        }
        return n;
    }

    public String getNormalDC() {
        double d = this.getTotalDC(true, false);
        double d2 = this.getTotalDC(false, false);
        if (d < 0.5 && d2 < 0.5) {
            return "";
        }
        String string = " ";
        string = string + Rounder.roundDown(d) + "";
        if (d - (double)Rounder.roundDown(d) >= 0.5) {
            string = string + " 1/2";
        }
        string = string + "d6";
        if (d != d2) {
            string = string + " / ";
            string = string + Rounder.roundDown(d2) + "";
            if (d2 - (double)Rounder.roundDown(d2) >= 0.5) {
                string = string + " 1/2";
            }
            string = string + "d6";
        }
        return string;
    }

    public String getWeaponDC() {
        int n = this.getTotalDCNoSTR();
        if (n == 0) {
            return "";
        }
        String string = " ";
        if (n > 0) {
            string = string + "+";
        }
        string = string + n + " DC ";
        return string;
    }

    public String getFlashDC() {
        double d = this.getTotalDC(true, false);
        double d2 = this.getTotalDC(false, false);
        if (d < 0.5 && d2 < 0.5) {
            return "";
        }
        String string = " Flash ";
        string = string + Rounder.roundDown(d) + "";
        if (d - (double)Rounder.roundDown(d) >= 0.5) {
            string = string + " 1/2";
        }
        string = string + "d6";
        if (d != d2) {
            string = string + " / ";
            string = string + Rounder.roundDown(d2) + "";
            if (d2 - (double)Rounder.roundDown(d2) >= 0.5) {
                string = string + " 1/2";
            }
            string = string + "d6";
        }
        return string;
    }

    public String getNNDDC() {
        double d = this.getTotalDC(true, true);
        double d2 = this.getTotalDC(false, true);
        if (d < 0.5 && d2 < 0.5) {
            return "";
        }
        double d3 = d / 2.0;
        double d4 = d2 / 2.0;
        String string = " ";
        String string2 = Maneuver.getFraction(d3);
        string2 = string2.substring(1, string2.length());
        string = string + string2 + "d6 NND";
        if (d3 != d4) {
            string2 = Maneuver.getFraction(d3);
            string2 = string2.substring(1, string2.length());
            string = string + " / " + string2 + "d6 NND";
        }
        return string;
    }

    public String getSTRDC() {
        double d = this.getTotalDC(true, false);
        double d2 = this.getTotalDC(false, false);
        if (d < 0.5 && d2 < 0.5) {
            return "";
        }
        String string = " ";
        string = string + NumberFormat.getIntegerInstance().format(d * 5.0) + " STR ";
        if (d != d2) {
            string = string + " / " + NumberFormat.getIntegerInstance().format(d2 * 5.0) + " STR ";
        }
        return string;
    }

    public String getKillingDC() {
        double d = this.getTotalDCNoSTR();
        double d2 = this.getTotalDC(true, true);
        double d3 = this.getTotalDC(false, true);
        double d4 = 2.0;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            d4 = 1.0;
        }
        if (HeroDesigner.getActiveTemplate().is6E()) {
            d2 = this.getTotalDC(true, false);
            d3 = this.getTotalDC(false, false);
        } else {
            d2 = d / d4 + (d2 - d >= d / d4 ? d / d4 : d2 - d);
            d3 = d / d4 + (d3 - d >= d / d4 ? d / d4 : d3 - d);
        }
        if (d2 < 0.5 && d3 < 0.5) {
            return "";
        }
        String string = "";
        int n = (int)Rounder.roundDown(d2 / 3.0);
        int n2 = (int)(d2 % 3.0);
        string = "" + n;
        string = n2 == 1 ? string + "d6 +1" : (n2 == 2 ? string + " 1/2d6" : string + "d6");
        String string2 = " HKA " + string;
        if (d2 != d3) {
            n = (int)Rounder.roundDown(d3 / 3.0);
            n2 = (int)(d3 % 3.0);
            string = "" + n;
            string = n2 == 1 ? string + "d6 +1" : (n2 == 2 ? string + " 1/2d6" : string + "d6");
            string2 = string2 + " / HKA " + string;
        }
        return string2;
    }

    public String getWeaponKillingDC() {
        int n = this.getTotalDCNoSTR();
        double d = 2.0;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            d = 1.0;
        }
        if ((n = (int)Rounder.roundDown((double)n / d)) == 0) {
            return "";
        }
        String string = " HKA ";
        string = string + n + " DC ";
        return string;
    }

    public String getEffect() {
        String string = this.effect;
        string = this.replace(string, "[NORMALDC]", this.getNormalDC());
        string = this.replace(string, "[WEAPONDC]", this.getWeaponDC());
        string = this.replace(string, "[FLASHDC]", this.getFlashDC());
        string = this.replace(string, "[NNDDC]", this.getNNDDC());
        string = this.replace(string, "[STRDC]", this.getSTRDC());
        string = this.replace(string, "[KILLINGDC]", this.getKillingDC());
        string = this.replace(string, "[WEAPONKILLINGDC]", this.getWeaponKillingDC());
        string = string + this.getModifierString();
        return string;
    }

    public String getDamageString() {
        String string = "";
        if (this.useWeapon()) {
            return ("Weapon " + this.getWeaponDC()).trim();
        }
        switch (this.getDamageType()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getSTRDC();
            }
            case 2: {
                return this.getNormalDC();
            }
            case 3: {
                return this.getKillingDC();
            }
            case 4: {
                return this.getNNDDC();
            }
            case 5: {
                return this.getFlashDC();
            }
        }
        return string;
    }

    public void setOCV(String string) {
        this.OCV = string;
    }

    public String getOCV() {
        return this.OCV;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String string) {
        this.phase = string;
    }

    public String getWeaponEffect() {
        String string = this.weaponEffect;
        string = this.replace(string, "[NORMALDC]", this.getNormalDC());
        string = this.replace(string, "[WEAPONDC]", this.getWeaponDC());
        string = this.replace(string, "[FLASHDC]", this.getFlashDC());
        string = this.replace(string, "[NNDDC]", this.getNNDDC());
        string = this.replace(string, "[STRDC]", this.getSTRDC());
        string = this.replace(string, "[KILLINGDC]", this.getKillingDC());
        string = this.replace(string, "[WEAPONKILLINGDC]", this.getWeaponKillingDC());
        string = string + this.getModifierString();
        return string;
    }

    public int getRanged() {
        return this.ranged;
    }

    public void setRanged(int n) {
        this.ranged = n;
        this.category = n >= 0 ? "Ranged" : "Hand to Hand";
    }

    public void setUseWeapon(boolean bl) {
        this.useWeapon = bl;
    }

    public boolean useWeapon() {
        return this.useWeapon;
    }

    public void setEffect(String string) {
        this.effect = string;
        this.weaponEffect = string;
    }

    @Override
    public String getColumn3Output() {
        if (this.getEndUsage() == 0) {
            return null;
        }
        return "" + this.getEndUsage();
    }

    public boolean isCustom() {
        return this.custom;
    }

    public String getManeuverEffect() {
        String string = "";
        String string2 = "";
        string2 = this.useWeapon() ? string2 + this.getWeaponEffect() : string2 + this.getEffect();
        if (string2.indexOf("[DAMAGE]") >= 0) {
            string2 = string2.replaceAll("\\[DAMAGE\\]", this.getDamageString());
            string = string + string2;
        } else {
            String string3 = this.getDamageString();
            if (string3 != null && string3.trim().length() > 0) {
                string = string + string3 + ", ";
            }
            string = string + string2;
        }
        return string;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        string = string + ":  " + this.getPhase() + " Phase, " + this.getOCV() + " OCV, " + this.getDCV() + " DCV, ";
        if (this.getCategory().equalsIgnoreCase("Ranged")) {
            string = string + "Range " + (this.getRanged() >= 0 ? "+" : "-") + this.getRanged() + ", ";
        }
        string = this.custom ? string + this.getManeuverEffect() : (this.useWeapon() ? string + this.getWeaponEffect() : string + this.getEffect());
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    public int getDC() {
        return this.dcs;
    }

    public void setDC(int n) {
        this.dcs = n;
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("MANEUVER");
        if (this.custom) {
            element.setAttribute("CUSTOM", "Yes");
        }
        element.setAttribute("CATEGORY", this.getCategory());
        element.setAttribute("DISPLAY", "" + this.display);
        element.setAttribute("OCV", "" + this.getOCV());
        element.setAttribute("DCV", "" + this.getDCV());
        element.setAttribute("DC", "" + this.getDC());
        element.setAttribute("PHASE", this.getPhase());
        element.setAttribute("EFFECT", this.effect);
        element.setAttribute("ADDSTR", this.addSTR ? "Yes" : "No");
        element.setAttribute("ACTIVECOST", "" + this.activeCost);
        element.setAttribute("DAMAGETYPE", "" + this.damageType);
        element.setAttribute("MAXSTR", "" + this.maxSTR);
        element.setAttribute("STRMULT", "" + this.STRMultiplier);
        element.setAttribute("USEWEAPON", this.useWeapon ? "Yes" : "No");
        if (this.getWeaponEffect() != null && this.getWeaponEffect().trim().length() > 0) {
            element.setAttribute("WEAPONEFFECT", this.weaponEffect);
        }
        if (this.getCategory() != null && this.getCategory().equalsIgnoreCase("Ranged")) {
            element.setAttribute("RANGE", "" + this.getRanged());
        }
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "CATEGORY");
        if (string != null && string.trim().length() > 0) {
            this.category = string;
        }
        if ((string = XMLUtility.getValue(element, "OCV")) != null && string.trim().length() > 0) {
            this.OCV = string;
        }
        if ((string = XMLUtility.getValue(element, "DCV")) != null && string.trim().length() > 0) {
            this.DCV = string;
        }
        if ((string = XMLUtility.getValue(element, "DAMAGETYPE")) != null && string.trim().length() > 0) {
            try {
                this.damageType = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "RANGE")) != null && string.trim().length() > 0) {
            try {
                this.ranged = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "DC")) != null && string.trim().length() > 0) {
            try {
                this.dcs = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "PHASE")) != null && string.trim().length() > 0) {
            this.phase = string;
        }
        if ((string = XMLUtility.getValue(element, "EFFECT")) != null && string.trim().length() > 0) {
            this.effect = string;
        }
        if (this.effect.indexOf("STR [NORMALDC]") >= 0) {
            this.effect = this.effect.substring(0, this.effect.indexOf("STR [NORMALDC]")) + this.effect.substring(this.effect.indexOf("STR [NORMALDC]") + 4, this.effect.length());
        }
        if ((string = XMLUtility.getValue(element, "WEAPONEFFECT")) != null && string.trim().length() > 0) {
            this.weaponEffect = string;
        }
        this.useWeapon = (string = XMLUtility.getValue(element, "USEWEAPON")) != null && string.trim().toUpperCase().startsWith("Y");
        string = XMLUtility.getValue(element, "ACTIVECOST");
        try {
            this.activeCost = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = XMLUtility.getValue(element, "CUSTOM");
        if (string != null) {
            this.custom = string.startsWith("Y");
        }
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        if (this.custom) {
            return new CustomManeuverDialog(this, bl, bl2);
        }
        return new ManeuverDialog(this, bl, bl2);
    }

    @Override
    public int getEndUsage() {
        Cloneable cloneable;
        int n = HeroDesigner.getActiveHero().getRules().getAPPerEND();
        double d = 0.0;
        double d2 = this.getActiveCostForEND(null);
        double d3 = 1.0;
        ArrayList arrayList = (ArrayList)this.getAssignedModifiers().clone();
        List list = this.getParentList();
        if (list == null && this.getMainPower() != null) {
            list = this.getMainPower().getParentList();
        }
        if (list != null) {
            cloneable = list.getAssignedModifiers();
            Iterator<Modifier> iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                Modifier modifier = iterator.next();
                if (this.getParentList() instanceof ElementalControl) {
                    arrayList.add(modifier);
                    continue;
                }
                arrayList.add(modifier);
            }
        }
        if (GenericObject.findObjectByID(arrayList, "CHARGES") != null) {
            n = 0;
        }
        if (GenericObject.findObjectByID(arrayList, "COSTSEND") != null) {
            n = HeroDesigner.getActiveHero().getRules().getAPPerEND();
        }
        if (GenericObject.findObjectByID(arrayList, "REDUCEDEND") != null) {
            cloneable = GenericObject.findObjectByID(arrayList, "REDUCEDEND");
            if (((GenericObject)cloneable).getSelectedOption().getXMLID().equals("HALFEND")) {
                d3 = 0.5;
            } else {
                n = 0;
            }
            d2 = this.getActiveCostForEND((GenericObject)cloneable);
        }
        if (GenericObject.findObjectByID(arrayList, "COSTSENDONLYTOACTIVATE") != null) {
            cloneable = GenericObject.findObjectByID(arrayList, "COSTSENDONLYTOACTIVATE");
            d2 = this.getActiveCostForEND((GenericObject)cloneable);
        }
        if (GenericObject.findObjectByID(arrayList, "INCREASEDEND") != null && GenericObject.findObjectByID(((GenericObject)(cloneable = GenericObject.findObjectByID(arrayList, "INCREASEDEND"))).getAssignedAdders(), "CIRCUMSTANCE") == null) {
            d3 = (int)Rounder.roundHalfUp(((GenericObject)cloneable).getSelectedOption().getLevelValue());
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(cloneable = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d2 /= (double)((Automaton)cloneable).getDefenseCostMultiplier();
        }
        if (n != 0) {
            d = d2 / (double)n;
        }
        if (Rounder.roundHalfDown(d) == 0L && d2 > 0.0 && n != 0) {
            d = 1.0;
        }
        d = Rounder.roundHalfDown(d);
        if (Rounder.roundHalfDown(d *= d3) == 0L && d2 > 0.0 && n != 0) {
            d = 1.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return (int)Rounder.roundHalfDown(d);
    }

    @Override
    public boolean usesEND() {
        boolean bl = this.usesEND;
        if (this.apperend != -1) {
            this.usesEND = this.apperend > 0;
        }
        ArrayList arrayList = (ArrayList)this.getAssignedModifiers().clone();
        List list = this.getParentList();
        if (list == null && this.getMainPower() != null) {
            list = this.getMainPower().getParentList();
        }
        if (list != null) {
            ArrayList<Modifier> arrayList2 = list.getAssignedModifiers();
            for (Modifier modifier : arrayList2) {
                if (this.getParentList() instanceof ElementalControl) {
                    if (!(modifier.getTotalValue() < 0.0)) continue;
                    arrayList.add(modifier);
                    continue;
                }
                arrayList.add(modifier);
            }
        }
        boolean bl2 = false;
        for (Modifier modifier : arrayList) {
            if (!(modifier.getTotalValue() > 0.0)) continue;
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        if (GenericObject.findObjectByID(arrayList, "CHARGES") != null) {
            bl = false;
        }
        if (GenericObject.findObjectByID(arrayList, "COSTSEND") != null) {
            bl = true;
        }
        if (GenericObject.findObjectByID(arrayList, "REDUCEDEND") != null) {
            GenericObject genericObject = GenericObject.findObjectByID(arrayList, "REDUCEDEND");
            bl = genericObject.getSelectedOption().getXMLID().equals("HALFEND");
        }
        return bl;
    }

    @Override
    public boolean allowsOtherModifiers() {
        return this.getManeuverActiveCost() > 0;
    }
}

