/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.enhancers;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.powers.Automaton;
import com.hero.objects.skills.Language;
import com.hero.objects.skills.Skill;
import com.hero.ui.dialog.EnhancerDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import org.jdom.Element;

public class Enhancer
extends List {
    protected int costSavings;
    protected int intBasedCost = 3;
    protected int generalCost = 2;
    protected boolean intBased = false;

    public Enhancer(Element element) {
        super(element);
    }

    public int getCostSavings() {
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers() && !this.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) {
            return 0;
        }
        return this.costSavings;
    }

    public void setIntBased(boolean bl) {
        this.intBased = bl;
    }

    public boolean getIntBased() {
        return this.intBased;
    }

    public boolean appliesToType(String string) {
        return this.types.contains(string);
    }

    @Override
    protected void init(Element element) {
        this.display = "Generic Enhancer";
        this.alias = "Generic Enhancer";
        this.baseCost = 3.0;
        this.levelCost = 0.0;
        this.levelValue = 0.0;
        this.minimumCost = 3.0;
        this.minimumLevel = 0;
        super.init(element);
        String string = XMLUtility.getValue(element, "COSTSAVINGS");
        if (string != null && string.trim().length() > 0) {
            try {
                this.costSavings = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.costSavings = 1;
            }
        } else {
            this.costSavings = 1;
        }
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName(this.getXMLID());
        element.setAttribute("INTBASED", this.intBased ? "YES" : "NO");
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        this.alias = this.display;
        String string = XMLUtility.getValue(element, "INTBASED");
        this.intBased = string != null && string.trim().toUpperCase().startsWith("Y");
    }

    @Override
    public String getColumn1Output() {
        return "" + Rounder.roundHalfDown(this.getRealCost());
    }

    @Override
    public String getColumn1Suffix(GenericObject genericObject) {
        return "";
    }

    @Override
    public String getColumn2Prefix(GenericObject genericObject) {
        this.updateChildPositions();
        int n = this.getObjects().indexOf(genericObject);
        ++n;
        return genericObject.getPosition() - this.getPosition() + ")  ";
    }

    @Override
    public boolean objectAllowed(GenericObject genericObject, boolean bl) {
        return false;
    }

    @Override
    public String getRejectionMessage() {
        return "";
    }

    @Override
    public double getRealCostForChild(GenericObject genericObject) {
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers() && !this.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) {
            if (genericObject instanceof Language) {
                if (this.getIntBased()) {
                    if (genericObject.getSelectedOption().getXMLID().equals("BASIC")) {
                        return genericObject.getRealCostPreList() - 1.0;
                    }
                    return genericObject.getRealCostPreList() - 2.0;
                }
                return genericObject.getRealCostPreList() - 1.0;
            }
            if (genericObject instanceof Skill) {
                Skill skill = (Skill)genericObject;
                if (this.getIntBased()) {
                    skill.setCharacteristic(5);
                } else {
                    skill.setCharacteristic(0);
                }
            }
            double d = genericObject.getRealCostPreList();
            double d2 = d - genericObject.getBaseCost();
            return d2;
        }
        return super.getRealCostForChild(genericObject);
    }

    @Override
    public double getBaseCost() {
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers() && !this.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) {
            return (double)this.getLevels() * this.getLevelCost();
        }
        return super.getBaseCost();
    }

    @Override
    public double getLevelCost() {
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers() && !this.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) {
            if (this.getIntBased()) {
                return 3.0;
            }
            return 2.0;
        }
        return super.getLevelCost();
    }

    @Override
    public int getLevels() {
        if (HeroDesigner.getActiveHero().getRules().useSkillMultipliers() && !this.getXMLID().equalsIgnoreCase("WELL_CONNECTED")) {
            int n = this.getObjects().size();
            int n2 = 1;
            double d = Math.pow(2.0, n2 - 1);
            while (d < (double)n) {
                d = Math.pow(2.0, n2);
                ++n2;
            }
            return n2;
        }
        return super.getLevels();
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new EnhancerDialog(this, bl);
    }

    @Override
    public double getTotalCost() {
        Adder adder2;
        double d = this.getBaseCost();
        ArrayList<Adder> arrayList = this.getAvailableAdders();
        for (Adder adder2 : this.getAssignedAdders()) {
            if (adder2.isRequired()) {
                d += adder2.getRealCost();
            }
            if (adder2.isRequired() || GenericObject.findObjectByID(arrayList, adder2.getXMLID()) == null) continue;
            d += adder2.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        for (int i = 0; i < this.getAssignedAdders().size() && this.getPrivateAdders().size() == 0; ++i) {
            adder2 = this.getAssignedAdders().get(i);
            if (adder2.isRequired() || GenericObject.findObjectByID(arrayList, adder2.getXMLID()) != null) continue;
            d += adder2.getRealCost();
        }
        Object object = this.getPrivateAdders().iterator();
        while (object.hasNext()) {
            adder2 = object.next();
            d += adder2.getRealCost();
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(object = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d *= (double)((Automaton)object).getDefenseCostMultiplier();
        }
        return d;
    }
}

