/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.characteristics;

import com.hero.HeroDesigner;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.powers.CompoundPower;
import com.hero.util.Rounder;
import java.util.ArrayList;
import org.jdom.Element;

public class Swimming
extends Characteristic {
    private static String xmlID = "SWIMMING";

    public Swimming(Element element) {
        super(element, xmlID);
    }

    @Override
    public void init(Element element) {
        this.display = "Swimming";
        this.levelCost = 1.0;
        this.levelValue = 1.0;
        this.minimumCost = 1.0;
        this.baseCost = 0.0;
        super.init(element);
    }

    public boolean verified() {
        return true;
    }

    @Override
    public String getDamageDisplay() {
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        double d = this.getPrimaryValue();
        double d2 = this.getSecondaryValue();
        String string = Rounder.roundHalfUp(d) + (bl ? "m" : "\"");
        if (d != d2) {
            string = string + "/" + Rounder.roundHalfUp(d2) + (bl ? "m" : "\"");
        }
        string = (this.getLevels() > 0 && this.getAffectTotal() ? "+" : "") + this.getLevels() + (bl ? "m" : "\"") + (this.getAffectTotal() ? " (" + string + " total)" : "");
        return string;
    }

    @Override
    public int getType() {
        return 18;
    }

    @Override
    public String getRoll() {
        return "";
    }

    @Override
    public String getColumn2Output() {
        if (this.getLevels() == 0 && this.addModifiersToBase() && this.getModifierString().trim().length() > 0) {
            String string = this.getModifierString();
            if (string.trim().startsWith(",")) {
                string = string.trim().substring(1, string.length()).trim();
            }
            string = string + " applied to " + this.getAlias();
            if (this.getName() != null && this.getName().trim().length() > 0) {
                string = "<i>" + this.getName() + ":</i>  " + string;
            }
            return string;
        }
        String string = this.getAlias() + " " + this.getDamageDisplay();
        String string2 = "";
        if (string.indexOf("(") > 0) {
            string2 = " " + string.substring(string.indexOf("("), string.length());
            string = string.substring(0, string.indexOf("(")).trim();
        }
        string = string + string2;
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + "; " + string3;
            }
            string = string + ")";
        } else {
            String string4 = this.getAdderString();
            if (string4.trim().length() > 0) {
                string = string + " (" + string4 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getValueDisplay() {
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        if (this.getPrimaryValue() != this.getSecondaryValue()) {
            return Rounder.roundHalfUp(this.getPrimaryValue()) + (bl ? "m" : "\"") + "/" + Rounder.roundHalfUp(this.getSecondaryValue()) + (bl ? "m" : "\"");
        }
        return "" + Rounder.roundHalfUp(this.getPrimaryValue()) + (bl ? "m" : "\"");
    }

    @Override
    public String getDisplayNotes() {
        String string = "";
        string = string + "END [";
        int n = this.getPrimaryEND();
        string = string + n;
        int n2 = this.getSecondaryEND();
        string = n != n2 ? string + "/" + n2 + "]" : string + "]";
        return string;
    }

    public int getSecondaryEND() {
        double d;
        double d2;
        CharAffectingObject charAffectingObject;
        CharAffectingObject charAffectingObject2;
        int n;
        double d3 = this.getBaseEND();
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (!charAffectingObject2.getAffectTotal()) continue;
                d3 += (double)charAffectingObject2.getEndUsage();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d3 += (double)charAffectingObject.getEndUsage();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                    if (this.getAPPerEnd() <= 0) continue;
                    d = d2 * this.getLevelCost() / (double)this.getAPPerEnd();
                    d3 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
            double d4 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d4 += charAffectingObject2.getIncreaseValue(this.getType(), true);
            if (this.getAPPerEnd() <= 0) continue;
            d2 = Rounder.roundHalfDown(d4 * this.getLevelCost() / (double)this.getAPPerEnd());
            d3 += d2;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (!charAffectingObject2.getAffectTotal()) continue;
                d3 += (double)charAffectingObject2.getEndUsage();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d3 += (double)charAffectingObject.getEndUsage();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                    if (this.getAPPerEnd() <= 0) continue;
                    d = d2 * this.getLevelCost() / (double)this.getAPPerEnd();
                    d3 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
            double d5 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d5 += charAffectingObject2.getIncreaseValue(this.getType(), true);
            if (this.getAPPerEnd() <= 0) continue;
            d2 = Rounder.roundHalfDown(d5 * this.getLevelCost() / (double)this.getAPPerEnd());
            d3 += d2;
        }
        return (int)Rounder.roundHalfDown(d3);
    }

    public int getPrimaryEND() {
        double d;
        double d2;
        CharAffectingObject charAffectingObject;
        CharAffectingObject charAffectingObject2;
        int n;
        double d3 = this.getBaseEND();
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (!charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d3 += (double)charAffectingObject2.getEndUsage();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d3 += (double)charAffectingObject.getEndUsage();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                    if (this.getAPPerEnd() <= 0) continue;
                    d = d2 * this.getLevelCost() / (double)this.getAPPerEnd();
                    d3 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
            double d4 = charAffectingObject2.getIncreaseValue(this.getType(), true);
            if (this.getAPPerEnd() <= 0) continue;
            d2 = d4 * this.getLevelCost() / (double)this.getAPPerEnd();
            d3 += d2;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (!charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d3 += (double)charAffectingObject2.getEndUsage();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d3 += (double)charAffectingObject.getEndUsage();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                    if (this.getAPPerEnd() <= 0) continue;
                    d = d2 * this.getLevelCost() / (double)this.getAPPerEnd();
                    d3 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
            double d5 = charAffectingObject2.getIncreaseValue(this.getType(), true);
            if (this.getAPPerEnd() <= 0) continue;
            d2 = d5 * this.getLevelCost() / (double)this.getAPPerEnd();
            d3 += d2;
        }
        return (int)Rounder.roundHalfDown(d3);
    }

    public int getBaseEND() {
        GenericObject genericObject;
        double d = 0.0;
        double d2 = 0.0;
        if (HeroDesigner.getActiveHero() != null) {
            d2 = this.origBaseLevel;
            for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
                Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
                if (characteristic.getXMLID().equals(this.getXMLID()) || characteristic.getIncreaseLevels(this.getType()) <= 0 || characteristic.getIncrease(this.getType()) == 0.0) continue;
                double d3 = characteristic.getValue(true, this.getType()) * characteristic.getIncrease(this.getType()) / (double)characteristic.getIncreaseLevels(this.getType());
                d += d3;
            }
        }
        d2 = d2 + d + (double)this.getLevels() > (double)this.maxVal ? (double)this.maxVal : d2 + d + (double)this.getLevels();
        double d4 = d2 / this.getLevelValue() * this.getLevelCost();
        int n = this.getAPPerEnd();
        double d5 = 0.0;
        double d6 = 1.0;
        ArrayList arrayList = (ArrayList)this.getAssignedModifiers().clone();
        if (this.getParentList() != null) {
            arrayList.addAll(this.getParentList().getAssignedModifiers());
        }
        if (GenericObject.findObjectByID(arrayList, "CHARGES") != null) {
            n = 0;
        }
        if (GenericObject.findObjectByID(arrayList, "COSTSEND") != null) {
            n = HeroDesigner.getActiveHero().getRules().getAPPerEND();
        }
        if (GenericObject.findObjectByID(arrayList, "REDUCEDEND") != null) {
            genericObject = GenericObject.findObjectByID(arrayList, "REDUCEDEND");
            n = genericObject.getSelectedOption().getXMLID().equals("HALFEND") ? (n *= 2) : 0;
        }
        if (GenericObject.findObjectByID(arrayList, "INCREASEDEND") != null && GenericObject.findObjectByID((genericObject = GenericObject.findObjectByID(arrayList, "INCREASEDEND")).getAssignedAdders(), "CIRCUMSTANCE") == null) {
            d6 = genericObject.getSelectedOption().getLevelValue();
        }
        if (n != 0) {
            d5 = d4 / (double)n;
        }
        if ((d5 *= d6) < 0.0) {
            d5 = 0.0;
        }
        if (Rounder.roundHalfDown(d5) == 0L && d4 > 0.0 && n != 0) {
            d5 = 1.0;
        }
        return (int)Rounder.roundHalfDown(d5);
    }
}

