/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.characteristics;

import com.hero.HeroDesigner;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.powers.CompoundPower;
import com.hero.util.Rounder;
import java.util.ArrayList;
import org.jdom.Element;

public class Strength
extends Characteristic {
    private static String xmlID = "STR";

    public Strength(Element element) {
        super(element, xmlID);
    }

    @Override
    public int getType() {
        return 1;
    }

    public double getPrimaryLift() {
        double d = 25.0;
        double d2 = this.getPrimaryValue() / 5.0;
        d = d2 > 0.0 ? Math.pow(2.0, d2) * d : (d /= Math.pow(2.0, Math.abs(d2)));
        return d;
    }

    public double getSecondaryLift() {
        double d = 25.0;
        double d2 = this.getSecondaryValue() / 5.0;
        d = d2 > 0.0 ? Math.pow(2.0, d2) * d : (d /= Math.pow(2.0, Math.abs(d2)));
        return d;
    }

    @Override
    public String getDisplayNotes() {
        String string = "HTH Damage ";
        String string2 = "";
        string = string + this.getHthDamageString();
        string = string + "  END [";
        int n = this.getPrimaryEND();
        string = string + n;
        int n2 = this.getSecondaryEND();
        string = n != n2 ? string + "/" + n2 + "]" : string + "]";
        return string;
    }

    public String getHthDamageString() {
        String string;
        double d = (this.getPrimaryValue() - (double)((int)this.getPrimaryValue() % 5)) / 5.0;
        if (d < 0.0) {
            d = 0.0;
        }
        int n = (int)this.getPrimaryValue() % 5;
        if (HeroDesigner.getActiveHero().getRules().useIncreasedDamageDifferentiation()) {
            string = n == 4 ? Rounder.roundHalfUp(d + 1.0) + "d6-1" : (n == 3 ? (d > 0.0 ? Rounder.roundHalfUp(d) + " 1/2d6" : "1/2d6") : (n == 2 ? (d > 0.0 ? Rounder.roundHalfUp(d) + "d6+1" : "1 pip") : "" + Rounder.roundHalfUp(d) + "d6"));
        } else {
            string = n > 2 && d > 0.0 ? Rounder.roundHalfUp(d) + " 1/2" : (n > 2 ? "1/2" : "" + Rounder.roundHalfUp(d));
            string = string + "d6";
        }
        String string2 = "";
        double d2 = (this.getSecondaryValue() - (double)(Rounder.roundDown(this.getSecondaryValue()) % 5L)) / 5.0;
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        int n2 = (int)Rounder.roundDown(this.getSecondaryValue()) % 5;
        if (HeroDesigner.getActiveHero().getRules().useIncreasedDamageDifferentiation()) {
            string2 = n2 == 4 ? Rounder.roundHalfUp(d2 + 1.0) + "d6-1" : (n2 == 3 ? (d2 > 0.0 ? Rounder.roundHalfUp(d2) + " 1/2d6" : "1/2d6") : (n2 == 2 ? (d2 > 0.0 ? Rounder.roundHalfUp(d2) + "d6+1" : "1 pip") : "" + Rounder.roundHalfUp(d2) + "d6"));
        } else {
            string2 = n2 > 2 && d2 > 0.0 ? Rounder.roundHalfUp(d2) + " 1/2" : (n2 > 2 ? "1/2" : "" + Rounder.roundHalfUp(d2));
            string2 = string2 + "d6";
        }
        if (string.equals(string2)) {
            return string;
        }
        return string + "/" + string2;
    }

    public int getSecondaryEND() {
        double d;
        double d2;
        CharAffectingObject charAffectingObject;
        CharAffectingObject charAffectingObject2;
        int n;
        double d3 = this.getBaseEND();
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (!charAffectingObject2.getAffectTotal()) continue;
                d3 += (double)charAffectingObject2.getEndUsage();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d3 += (double)charAffectingObject.getEndUsage();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject)) continue;
                    charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i);
                    if (this.getOrigAPPerEnd() <= 0 || charAffectingObject.getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                    d = d2 * this.getLevelCost() / (double)this.getOrigAPPerEnd();
                    d3 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CharAffectingObject)) continue;
            charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n);
            if (this.getOrigAPPerEnd() <= 0 || charAffectingObject2.getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
            double d4 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d2 = Rounder.roundHalfDown((d4 += charAffectingObject2.getIncreaseValue(this.getType(), true)) * this.getLevelCost() / (double)this.getOrigAPPerEnd());
            d3 += d2;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (!charAffectingObject2.getAffectTotal()) continue;
                d3 += (double)charAffectingObject2.getEndUsage();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d3 += (double)charAffectingObject.getEndUsage();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject)) continue;
                    charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i);
                    if (this.getOrigAPPerEnd() <= 0 || charAffectingObject.getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                    d = d2 * this.getLevelCost() / (double)this.getOrigAPPerEnd();
                    d3 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CharAffectingObject)) continue;
            charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n);
            if (this.getOrigAPPerEnd() <= 0 || charAffectingObject2.getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
            double d5 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d2 = Rounder.roundHalfDown((d5 += charAffectingObject2.getIncreaseValue(this.getType(), true)) * this.getLevelCost() / (double)this.getOrigAPPerEnd());
            d3 += d2;
        }
        return (int)Rounder.roundHalfDown(d3);
    }

    public int getPrimaryEND() {
        double d;
        double d2;
        CharAffectingObject charAffectingObject;
        CharAffectingObject charAffectingObject2;
        int n;
        double d3 = this.getBaseEND();
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (!charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d3 += (double)charAffectingObject2.getEndUsage();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d3 += (double)charAffectingObject.getEndUsage();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject)) continue;
                    charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i);
                    if (this.getOrigAPPerEnd() <= 0 || charAffectingObject.getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                    d = d2 * this.getLevelCost() / (double)this.getOrigAPPerEnd();
                    d3 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CharAffectingObject)) continue;
            charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n);
            if (this.getOrigAPPerEnd() <= 0 || charAffectingObject2.getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
            double d4 = charAffectingObject2.getIncreaseValue(this.getType(), true);
            d2 = d4 * this.getLevelCost() / (double)this.getOrigAPPerEnd();
            d3 += d2;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (!charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d3 += (double)charAffectingObject2.getEndUsage();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d3 += (double)charAffectingObject.getEndUsage();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject)) continue;
                    charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i);
                    if (this.getOrigAPPerEnd() <= 0 || charAffectingObject.getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                    d = d2 * this.getLevelCost() / (double)this.getOrigAPPerEnd();
                    d3 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CharAffectingObject)) continue;
            charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n);
            if (this.getOrigAPPerEnd() <= 0 || charAffectingObject2.getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
            double d5 = charAffectingObject2.getIncreaseValue(this.getType(), true);
            d2 = d5 * this.getLevelCost() / (double)this.getOrigAPPerEnd();
            d3 += d2;
        }
        return (int)Rounder.roundHalfDown(d3);
    }

    public int getBaseEND() {
        GenericObject genericObject;
        double d = 0.0;
        double d2 = 0.0;
        if (HeroDesigner.getActiveHero() != null) {
            d2 = this.origBaseLevel;
            for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
                Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
                if (characteristic.getXMLID().equals(this.getXMLID()) || characteristic.getIncreaseLevels(this.getType()) <= 0 || characteristic.getIncrease(this.getType()) == 0.0) continue;
                double d3 = characteristic.getValue(true, this.getType()) * characteristic.getIncrease(this.getType()) / (double)characteristic.getIncreaseLevels(this.getType());
                d += d3;
            }
        }
        d2 = d2 + d + (double)this.getLevels() > (double)this.maxVal ? (double)this.maxVal : d2 + d + (double)this.getLevels();
        double d4 = d2 / this.getLevelValue() * this.getLevelCost();
        int n = this.getAPPerEnd();
        double d5 = 0.0;
        double d6 = 1.0;
        ArrayList arrayList = (ArrayList)this.getAssignedModifiers().clone();
        if (this.getParentList() != null) {
            arrayList.addAll(this.getParentList().getAssignedModifiers());
        }
        if (GenericObject.findObjectByID(arrayList, "CHARGES") != null) {
            n = 0;
        }
        if (GenericObject.findObjectByID(arrayList, "COSTSEND") != null) {
            n = HeroDesigner.getActiveHero().getRules().getSTRAPPerEND();
        }
        if (GenericObject.findObjectByID(arrayList, "REDUCEDEND") != null) {
            genericObject = GenericObject.findObjectByID(arrayList, "REDUCEDEND");
            n = genericObject.getSelectedOption().getXMLID().equals("HALFEND") ? (n *= 2) : 0;
        }
        if (GenericObject.findObjectByID(arrayList, "INCREASEDEND") != null && GenericObject.findObjectByID((genericObject = GenericObject.findObjectByID(arrayList, "INCREASEDEND")).getAssignedAdders(), "CIRCUMSTANCE") == null) {
            d6 = genericObject.getSelectedOption().getLevelValue();
        }
        if (n != 0) {
            d5 = d4 / (double)n;
        }
        if ((d5 *= d6) < 0.0) {
            d5 = 0.0;
        }
        if (Rounder.roundHalfDown(d5) == 0L && d4 > 0.0 && n != 0) {
            d5 = 1.0;
        }
        return (int)Rounder.roundHalfDown(d5);
    }
}

