/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.characteristics;

import com.hero.HeroDesigner;
import com.hero.objects.characteristics.Characteristic;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.math.BigDecimal;
import java.text.NumberFormat;
import org.jdom.Element;

public class Size
extends Characteristic {
    private static String xmlID = "SIZE";
    private double startWidth;
    private double startLength;
    private int startDCV;

    public Size(Element element) {
        super(element, xmlID);
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        this.startWidth = 0.5;
        this.startLength = 1.0;
        this.startDCV = 0;
        String string = XMLUtility.getValue(element, "STARTWIDTH");
        if (string != null && string.trim().length() > 0) {
            try {
                this.startWidth = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "STARTHEIGHT")) != null && string.trim().length() > 0) {
            try {
                this.startLength = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "STARTDCV")) != null && string.trim().length() > 0) {
            try {
                this.startDCV = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public String getRoll() {
        return "";
    }

    @Override
    public int getHeightIncreaseLevels() {
        if (super.getHeightIncreaseLevels() == 0) {
            return 1;
        }
        return super.getHeightIncreaseLevels();
    }

    @Override
    public int getWidthIncreaseLevels() {
        if (super.getWidthIncreaseLevels() == 0) {
            return 1;
        }
        return super.getWidthIncreaseLevels();
    }

    @Override
    public int getDcvEffect(boolean bl) {
        if (this.getDcvIncreaseLevels() != 0) {
            int n = this.getDcvIncrease() < 0.0 ? -1 : 1;
            double d = 0.0;
            double d2 = bl ? this.getPrimaryValue() : this.getSecondaryValue();
            d = Rounder.roundDown(Math.abs(d2 * this.getDcvIncrease() / (double)this.getDcvIncreaseLevels()));
            d *= (double)n;
            d = Rounder.roundHalfUp(d);
            return (int)d;
        }
        return 0;
    }

    @Override
    public double getPREIncreaseValue() {
        if (this.getIncreaseLevels(7) > 0 && this.getIncrease(7) != 0.0) {
            return this.getIncrease(7) * Math.floor(this.getCharacteristicValue() / (double)this.getIncreaseLevels(7));
        }
        return 0.0;
    }

    @Override
    public String getDisplayNotes() {
        BigDecimal bigDecimal;
        double d;
        int n;
        int n2;
        int n3;
        double d2 = this.startLength;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (this.getLevels() != 0) {
            d2 *= Math.pow(this.getHeightIncrease(), (double)this.getLevels() / (double)this.getHeightIncreaseLevels());
        }
        double d3 = this.startWidth;
        if (this.getLevels() != 0) {
            d3 *= Math.pow(this.getWidthIncrease(), (double)this.getLevels() / (double)this.getWidthIncreaseLevels());
        }
        double d4 = d2 * d3;
        double d5 = d2 * d3 * d3;
        long l = 100L;
        if (this.getLevels() != 0) {
            n3 = this.getLevels() / this.getMassMultiplierLevels();
            n2 = (int)Rounder.roundHalfUp(Math.pow(this.getMassMultiplier(), n3));
            n = (int)Rounder.roundHalfUp(Math.pow(this.getMassMultiplier(), n3 + 1));
            int n4 = n - n2;
            l *= (long)((double)Rounder.roundHalfUp(Math.pow(this.getMassMultiplier(), n3)) + (double)n4 * (double)this.getLevels() % (double)this.getMassMultiplierLevels() / (double)this.getMassMultiplierLevels());
        }
        n3 = this.startDCV;
        int n5 = n2 = this.getDcvIncrease() < 0.0 ? -1 : 1;
        if (this.getDcvIncreaseLevels() != 0) {
            n3 += n2 * (int)Rounder.roundDown(Math.abs(this.getDcvIncrease()) * (double)this.getLevels() / (double)this.getDcvIncreaseLevels());
        }
        n = Math.abs(n3);
        String string = "";
        if (l / 1000L < 1L) {
            string = numberFormat.format(l) + " kg";
        } else if (l / 1000L < 1000L) {
            d = (double)l / 1000.0;
            bigDecimal = new BigDecimal(d);
            bigDecimal = bigDecimal.setScale(1, 4);
            string = numberFormat.format(bigDecimal.doubleValue()) + " ton";
        } else {
            d = (double)l / 1000000.0;
            bigDecimal = new BigDecimal(d);
            bigDecimal = bigDecimal.setScale(1, 4);
            string = numberFormat.format(bigDecimal.doubleValue()) + " kton";
        }
        int n6 = 0;
        if (this.getLevels() != 0) {
            int n7 = this.getLevels() / this.getKbIncreaseLevels();
            int n8 = 1;
            int n9 = (int)Rounder.roundHalfUp(this.getKbIncrease());
            if (n9 < 0) {
                n8 = -1;
                n9 = Math.abs(n9);
            }
            int n10 = (int)Rounder.roundHalfUp(Math.pow(n9, n7));
            int n11 = (int)Rounder.roundHalfUp(Math.pow(n9, n7 + 1));
            int n12 = n11 - n10;
            n6 = (int)((double)(n9 * n7) + (double)n12 * (double)this.getLevels() % (double)n9 / (double)this.getKbIncreaseLevels()) * n8;
        }
        BigDecimal bigDecimal2 = new BigDecimal(d2);
        bigDecimal2 = bigDecimal2.setScale(2, 4);
        BigDecimal bigDecimal3 = new BigDecimal(d3);
        bigDecimal3 = bigDecimal3.setScale(2, 4);
        BigDecimal bigDecimal4 = new BigDecimal(d4);
        bigDecimal4 = bigDecimal4.setScale(2, 4);
        BigDecimal bigDecimal5 = new BigDecimal(d5);
        bigDecimal5 = bigDecimal5.setScale(2, 4);
        String string2 = "Length " + numberFormat.format(bigDecimal2.doubleValue()) + "\",  Width " + numberFormat.format(bigDecimal3.doubleValue()) + "\",   Area " + numberFormat.format(bigDecimal4.doubleValue()) + "\"   Mass " + string + "   KB " + n6;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            string2 = "Length " + numberFormat.format(bigDecimal2.doubleValue()) + "m,  Width " + numberFormat.format(bigDecimal3.doubleValue()) + "m,  Height " + numberFormat.format(bigDecimal3.doubleValue()) + "m,  Volume " + numberFormat.format(bigDecimal5.doubleValue()) + "m^3  Mass " + string + ",  OCV +" + n + ",  KB " + n6;
        }
        return string2;
    }

    @Override
    public double getIncreaseValue(int n, boolean bl) {
        if (n == 7) {
            if (this.getIncreaseLevels(n) == 0) {
                return 0.0;
            }
            if (!(!bl || this.getAffectPrimary() && this.getAffectTotal())) {
                return 0.0;
            }
            if (!(bl || !this.getAffectPrimary() && this.getAffectTotal())) {
                return 0.0;
            }
            if (!this.getAffectTotal()) {
                return 0.0;
            }
            return this.getIncrease(n) * Math.floor(this.getLevels() / this.getIncreaseLevels(n));
        }
        return super.getIncreaseValue(n, bl);
    }
}

