/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.characteristics;

import com.hero.HeroDesigner;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.Power;
import com.hero.util.Rounder;
import java.math.BigDecimal;
import org.jdom.Element;

public class Leaping
extends Characteristic {
    private static String xmlID = "LEAPING";
    protected double primaryForward;
    protected long primaryForwardCalcTime;
    protected double primaryUpward;
    protected long primaryUpwardCalcTime;
    protected double secondaryForward;
    protected long secondaryForwardCalcTime;
    protected double secondaryUpward;
    protected long secondaryUpwardCalcTime;

    public Leaping(Element element) {
        super(element, xmlID);
    }

    @Override
    protected void calcBaseValue() {
        double d = 0.0;
        this.doubleBase = 0.0;
        if (HeroDesigner.getActiveHero() != null) {
            double d2;
            CharAffectingObject charAffectingObject;
            CharAffectingObject charAffectingObject2;
            int n;
            for (n = 0; n < HeroDesigner.getActiveHero().getCharacteristics().size(); ++n) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(n);
                if (charAffectingObject2.getXMLID().equals(this.getXMLID()) || charAffectingObject2.getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0) continue;
                double d3 = ((Characteristic)charAffectingObject2).getCharacteristicValue() * charAffectingObject2.getIncrease(this.getType()) / (double)charAffectingObject2.getIncreaseLevels(this.getType());
                this.doubleBase += d3;
                d += (double)Rounder.roundDown(d3 * 2.0) / 2.0;
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) continue;
                if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) || !(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Characteristic) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d2;
                        d += (double)Rounder.roundDown(d2 * 2.0) / 2.0;
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof Characteristic) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d4 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d4;
                d += (double)Rounder.roundDown(d4 * 2.0) / 2.0;
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
                if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) continue;
                if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) || !(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Characteristic) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d2;
                        d += (double)Rounder.roundDown(d2 * 2.0) / 2.0;
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Characteristic) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d5 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d5;
                d += (double)Rounder.roundDown(d5 * 2.0) / 2.0;
            }
        }
        this.baseValue = this.baseLevel + (d = (double)Rounder.roundDown(this.doubleBase * 2.0) / 2.0) < (double)this.minimumLevel ? (double)this.minimumLevel : (this.baseLevel + d < (double)this.maxVal ? this.baseLevel + d : (double)this.maxVal - d);
        this.baseValueCalcTime = System.currentTimeMillis();
    }

    protected void calcPrimaryForward() {
        double d = 0.0;
        if (HeroDesigner.getActiveHero() != null) {
            double d2;
            CharAffectingObject charAffectingObject;
            CharAffectingObject charAffectingObject2;
            int n;
            this.doubleBase = super.getCharacteristicValue();
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers().get(n).getAssignedModifiers(), "UPWARDMOVEMENTONLY") == null) {
                    charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                    if (!charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                    d += (double)charAffectingObject2.getLevels();
                    this.doubleBase += (double)charAffectingObject2.getLevels();
                    continue;
                }
                if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(((CompoundPower)charAffectingObject2).getPowers().get(i).getAssignedModifiers(), "UPWARDMOVEMENTONLY") == null) {
                            charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                            if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                            d += (double)charAffectingObject.getLevels();
                            this.doubleBase += (double)charAffectingObject.getLevels();
                            continue;
                        }
                        if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Power) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d2;
                        d += d2;
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof Power) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d3 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d3;
                d += d3;
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
                if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment().get(n).getAssignedModifiers(), "UPWARDMOVEMENTONLY") == null) {
                    charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                    if (!charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                    d += (double)charAffectingObject2.getLevels();
                    this.doubleBase += (double)charAffectingObject2.getLevels();
                    continue;
                }
                if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(((CompoundPower)charAffectingObject2).getPowers().get(i).getAssignedModifiers(), "UPWARDMOVEMENTONLY") == null) {
                            charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                            if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                            d += (double)charAffectingObject.getLevels();
                            this.doubleBase += (double)charAffectingObject.getLevels();
                            continue;
                        }
                        if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Power) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d2;
                        d += d2;
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Power) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d4 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d4;
                d += d4;
            }
        }
        this.primaryForward = this.doubleBase < (double)this.maxVal ? this.doubleBase : (double)this.maxVal;
        this.primaryForwardCalcTime = System.currentTimeMillis();
    }

    protected void calcPrimaryUpward() {
        double d = 0.0;
        if (HeroDesigner.getActiveHero() != null) {
            double d2;
            CharAffectingObject charAffectingObject;
            CharAffectingObject charAffectingObject2;
            int n;
            this.doubleBase = super.getCharacteristicValue();
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers().get(n).getAssignedModifiers(), "FORWARDMOVEMENTONLY") == null) {
                    charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                    if (!charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                    d += (double)charAffectingObject2.getLevels();
                    this.doubleBase += (double)charAffectingObject2.getLevels();
                    if (GenericObject.findObjectByID(((Characteristic)charAffectingObject2).getAssignedModifiers(), "NOGRAVITYPENALTY") == null) continue;
                    d += (double)charAffectingObject2.getLevels();
                    this.doubleBase += (double)charAffectingObject2.getLevels();
                    continue;
                }
                if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(((CompoundPower)charAffectingObject2).getPowers().get(i).getAssignedModifiers(), "FORWARDMOVEMENTONLY") == null) {
                            charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                            if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                            d += (double)charAffectingObject.getLevels();
                            this.doubleBase += (double)charAffectingObject.getLevels();
                            if (GenericObject.findObjectByID(((Characteristic)charAffectingObject).getAssignedModifiers(), "NOGRAVITYPENALTY") == null) continue;
                            d += (double)charAffectingObject.getLevels();
                            this.doubleBase += (double)charAffectingObject.getLevels();
                            continue;
                        }
                        if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Power) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d2;
                        d += d2;
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof Power) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d3 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d3;
                d += d3;
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
                if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment().get(n).getAssignedModifiers(), "FORWARDMOVEMENTONLY") == null) {
                    charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                    if (!charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                    d += (double)charAffectingObject2.getLevels();
                    this.doubleBase += (double)charAffectingObject2.getLevels();
                    if (GenericObject.findObjectByID(((Characteristic)charAffectingObject2).getAssignedModifiers(), "NOGRAVITYPENALTY") == null) continue;
                    d += (double)charAffectingObject2.getLevels();
                    this.doubleBase += (double)charAffectingObject2.getLevels();
                    continue;
                }
                if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(((CompoundPower)charAffectingObject2).getPowers().get(i).getAssignedModifiers(), "FORWARDMOVEMENTONLY") == null) {
                            charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                            if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                            d += (double)charAffectingObject.getLevels();
                            this.doubleBase += (double)charAffectingObject.getLevels();
                            if (GenericObject.findObjectByID(((Characteristic)charAffectingObject).getAssignedModifiers(), "NOGRAVITYPENALTY") == null) continue;
                            d += (double)charAffectingObject.getLevels();
                            this.doubleBase += (double)charAffectingObject.getLevels();
                            continue;
                        }
                        if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Power) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d2;
                        d += d2;
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Power) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d4 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d4;
                d += d4;
            }
        }
        this.primaryUpward = this.doubleBase / 2.0 < (double)this.maxVal ? this.doubleBase / 2.0 : (double)this.maxVal;
        this.primaryUpwardCalcTime = System.currentTimeMillis();
    }

    protected void calcSecondaryForward() {
        double d;
        CharAffectingObject charAffectingObject;
        CharAffectingObject charAffectingObject2;
        int n;
        double d2 = 0.0;
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers().get(n).getAssignedModifiers(), "UPWARDMOVEMENTONLY") == null) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d2 += (double)charAffectingObject2.getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(((CompoundPower)charAffectingObject2).getPowers().get(i).getAssignedModifiers(), "UPWARDMOVEMENTONLY") == null) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d = charAffectingObject.getIncreaseValue(this.getType(), false);
                    d2 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType())) continue;
            double d3 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d2 += d3;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment().get(n).getAssignedModifiers(), "UPWARDMOVEMENTONLY") == null) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d2 += (double)charAffectingObject2.getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(((CompoundPower)charAffectingObject2).getPowers().get(i).getAssignedModifiers(), "UPWARDMOVEMENTONLY") == null) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d = charAffectingObject.getIncreaseValue(this.getType(), false);
                    d2 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType())) continue;
            double d4 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d2 += d4;
        }
        this.secondaryForward = (d2 += this.getPrimaryForward()) < (double)this.maxVal ? d2 : (double)this.maxVal;
        this.secondaryForwardCalcTime = System.currentTimeMillis();
    }

    protected void calcSecondaryUpward() {
        double d;
        CharAffectingObject charAffectingObject;
        CharAffectingObject charAffectingObject2;
        int n;
        double d2 = 0.0;
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers().get(n).getAssignedModifiers(), "FORWARDMOVEMENTONLY") == null) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d2 += (double)charAffectingObject2.getLevels();
                if (GenericObject.findObjectByID(((Characteristic)charAffectingObject2).getAssignedModifiers(), "NOGRAVITYPENALTY") == null) continue;
                d2 += (double)charAffectingObject2.getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(((CompoundPower)charAffectingObject2).getPowers().get(i).getAssignedModifiers(), "FORWARDMOVEMENTONLY") == null) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        if (GenericObject.findObjectByID(((Characteristic)charAffectingObject).getAssignedModifiers(), "NOGRAVITYPENALTY") == null) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d = charAffectingObject.getIncreaseValue(this.getType(), false);
                    this.doubleBase += d;
                    d2 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType())) continue;
            double d3 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d2 += d3;
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment().get(n).getAssignedModifiers(), "FORWARDMOVEMENTONLY") == null) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d2 += (double)charAffectingObject2.getLevels();
                if (GenericObject.findObjectByID(((Characteristic)charAffectingObject2).getAssignedModifiers(), "NOGRAVITYPENALTY") == null) continue;
                d2 += (double)charAffectingObject2.getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) && GenericObject.findObjectByID(((CompoundPower)charAffectingObject2).getPowers().get(i).getAssignedModifiers(), "FORWARDMOVEMENTONLY") == null) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        if (GenericObject.findObjectByID(((Characteristic)charAffectingObject).getAssignedModifiers(), "NOGRAVITYPENALTY") == null) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d = charAffectingObject.getIncreaseValue(this.getType(), false);
                    this.doubleBase += d;
                    d2 += d;
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType())) continue;
            double d4 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d2 += d4;
        }
        double d5 = d2 / 2.0 + this.getPrimaryUpward();
        this.secondaryUpward = d5 < (double)this.maxVal ? d5 : (double)this.maxVal;
        this.secondaryUpwardCalcTime = System.currentTimeMillis();
    }

    @Override
    public String getCharacteristicBase() {
        BigDecimal bigDecimal = new BigDecimal((double)Rounder.roundDown(this.getBaseValue() * 2.0) / 2.0);
        bigDecimal = bigDecimal.setScale(1, 4);
        return bigDecimal.toString();
    }

    @Override
    public String getColumn2Output() {
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        if (this.getLevels() == 0 && this.addModifiersToBase() && this.getModifierString().trim().length() > 0) {
            String string = this.getModifierString();
            if (string.trim().startsWith(",")) {
                string = string.trim().substring(1, string.length()).trim();
            }
            string = string + " applied to " + this.getAlias();
            if (this.getName() != null && this.getName().trim().length() > 0) {
                string = "<i>" + this.getName() + ":</i>  " + string;
            }
            return string;
        }
        String string = this.getAlias();
        if (this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        string = this.getAffectTotal() && this.getLevels() > 0 ? string + " +" : string + " ";
        string = string + this.getLevels() + (bl ? "m" : "\"");
        if (this.getAffectTotal()) {
            string = string + " (" + this.getDisplayNotes() + ")";
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string2 = this.getAdderString();
            if (string2.trim().length() > 0) {
                string = string + "; " + string2;
            }
            string = string + ")";
        } else {
            String string3 = this.getAdderString();
            if (string3.trim().length() > 0) {
                string = string + " (" + string3 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        return string;
    }

    @Override
    public String getDisplayNotes() {
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        String string = "";
        double d = this.getPrimaryForward();
        double d2 = this.getPrimaryUpward();
        double d3 = this.getSecondaryForward();
        double d4 = this.getSecondaryUpward();
        String string2 = "";
        string2 = d - (double)Rounder.roundDown(d) >= 0.5 && (d > 1.0 || this.getLevels() >= 0) ? Rounder.roundDown(d) + " 1/2" + (bl ? "m" : "\"") : Rounder.roundDown(d) + (bl ? "m" : "\"");
        String string3 = "";
        string3 = d2 - (double)Rounder.roundDown(d2) >= 0.5 && (d2 > 1.0 || this.getLevels() >= 0) ? Rounder.roundDown(d2) + " 1/2" + (bl ? "m" : "\"") : (d2 - (double)Rounder.roundDown(d2) >= 0.5 && (d2 > 0.0 || this.getLevels() >= 0) ? "1/2" + (bl ? "m" : "\"") : Rounder.roundDown(d2) + (bl ? "m" : "\""));
        String string4 = "";
        string4 = d3 - (double)Rounder.roundDown(d3) >= 0.5 && (d3 > 1.0 || this.getLevels() >= 0) ? Rounder.roundDown(d3) + " 1/2" + (bl ? "m" : "\"") : Rounder.roundDown(d3) + (bl ? "m" : "\"");
        String string5 = "";
        string5 = d4 - (double)Rounder.roundDown(d4) >= 0.5 && (d4 > 1.0 || this.getLevels() >= 0) ? Rounder.roundDown(d4) + " 1/2" + (bl ? "m" : "\"") : (d4 - (double)Rounder.roundDown(d4) >= 0.5 && (d4 > 0.0 || this.getLevels() >= 0) ? "1/2" + (bl ? "m" : "\"") : Rounder.roundDown(d4) + (bl ? "m" : "\""));
        string = d != d3 || d2 != d4 ? string2 + "/" + string4 + " forward, " + string3 + "/" + string5 + " upward" : string2 + " forward, " + string3 + " upward";
        return string;
    }

    public double getPrimaryForward() {
        if (this.primaryForwardCalcTime <= 0L || this.primaryForwardCalcTime < HeroDesigner.lastEdit) {
            this.calcPrimaryForward();
        }
        return this.primaryForward;
    }

    public double getPrimaryUpward() {
        if (this.primaryUpwardCalcTime <= 0L || this.primaryUpwardCalcTime < HeroDesigner.lastEdit) {
            this.calcPrimaryUpward();
        }
        return this.primaryUpward;
    }

    @Override
    public String getRoll() {
        return "";
    }

    public double getSecondaryForward() {
        if (this.secondaryForwardCalcTime <= 0L || this.secondaryForwardCalcTime < HeroDesigner.lastEdit) {
            this.calcSecondaryForward();
        }
        return this.secondaryForward;
    }

    public double getSecondaryUpward() {
        if (this.secondaryUpwardCalcTime <= 0L || this.secondaryUpwardCalcTime < HeroDesigner.lastEdit) {
            this.calcSecondaryUpward();
        }
        return this.secondaryUpward;
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public String getValueDisplay() {
        boolean bl = HeroDesigner.getActiveTemplate().is6E();
        String string = "";
        double d = this.getPrimaryForward();
        double d2 = this.getSecondaryForward();
        String string2 = "";
        string2 = d - (double)Rounder.roundDown(d) >= 0.5 && (d > 1.0 || this.getLevels() >= 0) ? Rounder.roundDown(d) + " 1/2" + (bl ? "m" : "\"") : Rounder.roundDown(d) + (bl ? "m" : "\"");
        String string3 = "";
        string3 = d2 - (double)Rounder.roundDown(d2) >= 0.5 && (d2 > 1.0 || this.getLevels() >= 0) ? Rounder.roundDown(d2) + " 1/2" + (bl ? "m" : "\"") : Rounder.roundDown(d2) + (bl ? "m" : "\"");
        string = d != d2 ? string2 + "/" + string3 : string2;
        return string;
    }

    @Override
    public void init(Element element) {
        this.display = "Leaping";
        this.levelCost = 1.0;
        this.levelValue = 1.0;
        this.minimumCost = 1.0;
        this.baseCost = 0.0;
        super.init(element);
    }

    @Override
    public boolean isFigured() {
        return false;
    }

    public boolean verified() {
        return true;
    }

    @Override
    public double getCharacteristicValue() {
        double d = super.getCharacteristicValue();
        return Math.floor(d);
    }

    @Override
    public void setValue(double d) {
        double d2 = this.getCharacteristicValue();
        double d3 = Math.floor(this.getBaseValue());
        if (d == d2) {
            return;
        }
        if (d < (double)this.minimumLevel) {
            this.setLevels((int)Rounder.roundHalfDown((double)this.minimumLevel - d));
        }
        if (d < (double)this.maxVal) {
            this.setLevels((int)Rounder.roundHalfDown(d - d3));
        } else {
            this.setLevels((int)Rounder.roundHalfDown((double)this.maxVal - d));
        }
    }
}

