/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.characteristics;

import com.hero.HeroDesigner;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.DamageResistance;
import com.hero.objects.powers.Power;
import com.hero.objects.talents.CombatLuck;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import org.jdom.Element;

public class EnergyDefense
extends Characteristic {
    private static String xmlID = "ED";
    protected int edResistance;
    protected long edResistanceCalcTime;
    protected int primaryResistantTotal;
    protected long primaryResistantTotalCalcTime;
    protected int secondaryResistantTotal;
    protected long secondaryResistantTotalCalcTime;
    protected boolean isResistant;

    @Override
    protected void init(Element element) {
        super.init(element);
        String string = XMLUtility.getValue(element, "RESISTANT");
        this.isResistant = string != null && string.trim().length() > 0 && string.toUpperCase().startsWith("Y");
    }

    public EnergyDefense(Element element) {
        super(element, xmlID);
    }

    @Override
    protected void calcBaseValue() {
        Automaton automaton;
        double d = 0.0;
        double d2 = 1.0;
        if (HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && (automaton = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON")).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d2 = automaton.getBasePDEDDenomenator();
        }
        if (HeroDesigner.getActiveHero() != null) {
            double d3;
            CharAffectingObject charAffectingObject;
            CharAffectingObject charAffectingObject2;
            int n;
            this.baseLevel = this.origBaseLevel / d2;
            this.doubleBase = this.origBaseLevel / d2;
            for (n = 0; n < HeroDesigner.getActiveHero().getCharacteristics().size(); ++n) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(n);
                if (charAffectingObject2.getXMLID().equals(this.getXMLID()) || charAffectingObject2.getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType())) continue;
                double d4 = ((Characteristic)charAffectingObject2).getCharacteristicValue() * charAffectingObject2.getIncrease(this.getType()) / (double)charAffectingObject2.getIncreaseLevels(this.getType());
                if (!charAffectingObject2.getTypes().contains("DEFENSE")) {
                    d4 /= d2;
                }
                this.doubleBase += d4;
                d += (double)Rounder.roundHalfUp(d4);
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) continue;
                if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) || !(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Characteristic) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d3 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d3 / d2;
                        d += (double)Rounder.roundHalfUp(d3 / d2);
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof Characteristic) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d5 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d5 / d2;
                d += (double)Rounder.roundHalfUp(d5 / d2);
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
                if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) continue;
                if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) || !(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Characteristic) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d3 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d3 / d2;
                        d += (double)Rounder.roundHalfUp(d3 / d2);
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Characteristic) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d6 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d6 / d2;
                d += (double)Rounder.roundHalfUp(d6 / d2);
            }
        }
        this.baseValue = this.baseLevel + d < (double)this.maxVal ? this.baseLevel + d : (double)this.maxVal;
        this.baseValueCalcTime = System.currentTimeMillis();
    }

    protected void calcEdResistance() {
        CharAffectingObject charAffectingObject;
        int n;
        CharAffectingObject charAffectingObject2;
        int n2;
        int n3 = 0;
        if (this.isResistant) {
            n3 = (int)((double)n3 + this.getValue(this.isFigured(), this.getType()));
        }
        for (n2 = 0; n2 < HeroDesigner.getActiveHero().getPowers().size(); ++n2) {
            if (HeroDesigner.getActiveHero().getPowers().get(n2) instanceof DamageResistance) {
                charAffectingObject2 = (DamageResistance)HeroDesigner.getActiveHero().getPowers().get(n2);
                n3 += ((DamageResistance)charAffectingObject2).getEdLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n2).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (EnergyDefense)HeroDesigner.getActiveHero().getPowers().get(n2);
                if (this.isResistant) {
                    n3 += charAffectingObject2.getLevels();
                    continue;
                }
                if (EnergyDefense.findObjectByID(((Characteristic)charAffectingObject2).getAssignedModifiers(), "RESISTANT") == null) continue;
                if (((Characteristic)charAffectingObject2).addModifiersToBase()) {
                    n3 = (int)((double)n3 + this.getValue(this.isFigured(), this.getType()));
                }
                if (!charAffectingObject2.getAffectTotal()) continue;
                n3 += charAffectingObject2.getLevels();
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n2) instanceof CompoundPower)) continue;
            charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n2);
            for (n = 0; n < ((CompoundPower)charAffectingObject2).getPowers().size(); ++n) {
                if (((CompoundPower)charAffectingObject2).getPowers().get(n) instanceof DamageResistance) {
                    charAffectingObject = (DamageResistance)((CompoundPower)charAffectingObject2).getPowers().get(n);
                    n3 += ((DamageResistance)charAffectingObject).getEdLevels();
                    continue;
                }
                if (!((CompoundPower)charAffectingObject2).getPowers().get(n).getXMLID().equals(this.getXMLID())) continue;
                charAffectingObject = (EnergyDefense)((CompoundPower)charAffectingObject2).getPowers().get(n);
                if (this.isResistant) {
                    n3 += charAffectingObject.getLevels();
                    continue;
                }
                if (EnergyDefense.findObjectByID(((Characteristic)charAffectingObject).getAssignedModifiers(), "RESISTANT") == null) continue;
                if (((Characteristic)charAffectingObject).addModifiersToBase()) {
                    n3 = (int)((double)n3 + this.getValue(this.isFigured(), this.getType()));
                }
                if (!charAffectingObject.getAffectTotal()) continue;
                n3 += charAffectingObject.getLevels();
            }
        }
        for (n2 = 0; n2 < HeroDesigner.getActiveHero().getEquipment().size(); ++n2) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n2) instanceof DamageResistance) {
                charAffectingObject2 = (DamageResistance)HeroDesigner.getActiveHero().getEquipment().get(n2);
                n3 += ((DamageResistance)charAffectingObject2).getEdLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n2).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (EnergyDefense)HeroDesigner.getActiveHero().getEquipment().get(n2);
                if (this.isResistant) {
                    n3 += charAffectingObject2.getLevels();
                    continue;
                }
                if (EnergyDefense.findObjectByID(((Characteristic)charAffectingObject2).getAssignedModifiers(), "RESISTANT") == null) continue;
                if (((Characteristic)charAffectingObject2).addModifiersToBase()) {
                    n3 = (int)((double)n3 + this.getValue(this.isFigured(), this.getType()));
                }
                if (!charAffectingObject2.getAffectTotal()) continue;
                n3 += charAffectingObject2.getLevels();
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n2) instanceof CompoundPower)) continue;
            charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n2);
            for (n = 0; n < ((CompoundPower)charAffectingObject2).getPowers().size(); ++n) {
                if (((CompoundPower)charAffectingObject2).getPowers().get(n) instanceof DamageResistance) {
                    charAffectingObject = (DamageResistance)((CompoundPower)charAffectingObject2).getPowers().get(n);
                    n3 += ((DamageResistance)charAffectingObject).getEdLevels();
                    continue;
                }
                if (!((CompoundPower)charAffectingObject2).getPowers().get(n).getXMLID().equals(this.getXMLID())) continue;
                charAffectingObject = (EnergyDefense)((CompoundPower)charAffectingObject2).getPowers().get(n);
                if (this.isResistant) {
                    n3 += charAffectingObject.getLevels();
                    continue;
                }
                if (EnergyDefense.findObjectByID(((Characteristic)charAffectingObject).getAssignedModifiers(), "RESISTANT") == null) continue;
                if (((Characteristic)charAffectingObject).addModifiersToBase()) {
                    n3 = (int)((double)n3 + this.getValue(this.isFigured(), this.getType()));
                }
                if (!charAffectingObject.getAffectTotal()) continue;
                n3 += charAffectingObject.getLevels();
            }
        }
        this.edResistance = n3;
        this.edResistanceCalcTime = System.currentTimeMillis();
    }

    @Override
    protected void calcPrimaryValue() {
        double d;
        GenericObject genericObject;
        GenericObject genericObject2;
        int n;
        Automaton automaton;
        double d2 = this.getCharacteristicValue();
        double d3 = 1.0;
        if (HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && (automaton = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON")).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d3 = automaton.getBasePDEDDenomenator();
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) {
                genericObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (!((CharAffectingObject)genericObject2).getAffectPrimary() || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
                d2 += (double)((CharAffectingObject)genericObject2).getLevels();
                this.doubleBase += (double)((CharAffectingObject)genericObject2).getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                genericObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)genericObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)genericObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        genericObject = (Characteristic)((CompoundPower)genericObject2).getPowers().get(i);
                        if (!((CharAffectingObject)genericObject).getAffectPrimary() || !((CharAffectingObject)genericObject).getAffectTotal()) continue;
                        d2 += (double)((CharAffectingObject)genericObject).getLevels();
                        this.doubleBase += (double)((CharAffectingObject)genericObject).getLevels();
                        continue;
                    }
                    if (((CompoundPower)genericObject2).getPowers().get(i) instanceof CombatLuck) {
                        genericObject = (CombatLuck)((CompoundPower)genericObject2).getPowers().get(i);
                        if (((CombatLuck)genericObject).getEdIncreaseLevels() <= 0 || !((CombatLuck)genericObject).getAffectPrimary() || !((CombatLuck)genericObject).getAffectTotal()) continue;
                        d2 += (double)Rounder.roundHalfUp((double)((CombatLuck)genericObject).getEdIncrease() * (double)genericObject.getLevels() / (double)((CombatLuck)genericObject).getEdIncreaseLevels());
                        continue;
                    }
                    if (!(((CompoundPower)genericObject2).getPowers().get(i) instanceof CharAffectingObject) || ((CompoundPower)genericObject2).getPowers().get(i) instanceof Characteristic || ((CharAffectingObject)(genericObject = (CharAffectingObject)((CompoundPower)genericObject2).getPowers().get(i))).getIncreaseLevels(this.getType()) <= 0 || ((CharAffectingObject)genericObject).getIncrease(this.getType()) == 0.0 || !((CharAffectingObject)genericObject).getAffectPrimary() || !CharAffectingObject.checkFigured(genericObject, this.getType()) || !((CharAffectingObject)genericObject).getAffectTotal()) continue;
                    d = ((CharAffectingObject)genericObject).getIncreaseValue(this.getType(), true);
                    this.doubleBase += d;
                    d2 += (double)Rounder.roundHalfUp(d);
                }
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CombatLuck) {
                genericObject2 = (CombatLuck)HeroDesigner.getActiveHero().getPowers().get(n);
                if (((CombatLuck)genericObject2).getEdIncreaseLevels() <= 0 || !((CombatLuck)genericObject2).getAffectPrimary() || !((CombatLuck)genericObject2).getAffectTotal()) continue;
                d2 += (double)Rounder.roundHalfUp((double)((CombatLuck)genericObject2).getEdIncrease() * (double)genericObject2.getLevels() / (double)((CombatLuck)genericObject2).getEdIncreaseLevels());
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CharAffectingObject) || HeroDesigner.getActiveHero().getPowers().get(n) instanceof Characteristic || ((CharAffectingObject)(genericObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n))).getIncreaseLevels(this.getType()) <= 0 || ((CharAffectingObject)genericObject2).getIncrease(this.getType()) == 0.0 || !((CharAffectingObject)genericObject2).getAffectPrimary() || !CharAffectingObject.checkFigured(genericObject2, this.getType()) || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
            double d4 = ((CharAffectingObject)genericObject2).getIncreaseValue(this.getType(), true);
            this.doubleBase += d4;
            d2 += (double)Rounder.roundHalfUp(d4);
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) {
                genericObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (!((CharAffectingObject)genericObject2).getAffectPrimary() || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
                d2 += (double)((CharAffectingObject)genericObject2).getLevels();
                this.doubleBase += (double)((CharAffectingObject)genericObject2).getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                genericObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)genericObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)genericObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        genericObject = (Characteristic)((CompoundPower)genericObject2).getPowers().get(i);
                        if (!((CharAffectingObject)genericObject).getAffectPrimary() || !((CharAffectingObject)genericObject).getAffectTotal()) continue;
                        d2 += (double)((CharAffectingObject)genericObject).getLevels();
                        this.doubleBase += (double)((CharAffectingObject)genericObject).getLevels();
                        continue;
                    }
                    if (((CompoundPower)genericObject2).getPowers().get(i) instanceof CombatLuck) {
                        genericObject = (CombatLuck)((CompoundPower)genericObject2).getPowers().get(i);
                        if (((CombatLuck)genericObject).getEdIncreaseLevels() <= 0 || !((CombatLuck)genericObject).getAffectPrimary() || !((CombatLuck)genericObject).getAffectTotal()) continue;
                        d2 += (double)Rounder.roundHalfUp((double)((CombatLuck)genericObject).getEdIncrease() * (double)genericObject.getLevels() / (double)((CombatLuck)genericObject).getEdIncreaseLevels());
                        continue;
                    }
                    if (!(((CompoundPower)genericObject2).getPowers().get(i) instanceof CharAffectingObject) || ((CompoundPower)genericObject2).getPowers().get(i) instanceof Characteristic || ((CharAffectingObject)(genericObject = (CharAffectingObject)((CompoundPower)genericObject2).getPowers().get(i))).getIncreaseLevels(this.getType()) <= 0 || ((CharAffectingObject)genericObject).getIncrease(this.getType()) == 0.0 || !((CharAffectingObject)genericObject).getAffectPrimary() || !CharAffectingObject.checkFigured(genericObject, this.getType()) || !((CharAffectingObject)genericObject).getAffectTotal()) continue;
                    d = ((CharAffectingObject)genericObject).getIncreaseValue(this.getType(), true);
                    this.doubleBase += d;
                    d2 += (double)Rounder.roundHalfUp(d);
                }
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CombatLuck) {
                genericObject2 = (CombatLuck)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (((CombatLuck)genericObject2).getEdIncreaseLevels() <= 0 || !((CombatLuck)genericObject2).getAffectPrimary() || !((CombatLuck)genericObject2).getAffectTotal()) continue;
                d2 += (double)Rounder.roundHalfUp((double)((CombatLuck)genericObject2).getEdIncrease() * (double)genericObject2.getLevels() / (double)((CombatLuck)genericObject2).getEdIncreaseLevels());
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CharAffectingObject) || HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Characteristic || ((CharAffectingObject)(genericObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n))).getIncreaseLevels(this.getType()) <= 0 || ((CharAffectingObject)genericObject2).getIncrease(this.getType()) == 0.0 || !((CharAffectingObject)genericObject2).getAffectPrimary() || !CharAffectingObject.checkFigured(genericObject2, this.getType()) || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
            double d5 = ((CharAffectingObject)genericObject2).getIncreaseValue(this.getType(), true);
            this.doubleBase += d5;
            d2 += (double)Rounder.roundHalfUp(d5);
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getTalents().size(); ++n) {
            if (!(HeroDesigner.getActiveHero().getTalents().get(n) instanceof CombatLuck) || !((CombatLuck)(genericObject2 = (CombatLuck)HeroDesigner.getActiveHero().getTalents().get(n))).getAffectPrimary() || !((CombatLuck)genericObject2).getAffectTotal()) continue;
            Rounder.roundHalfUp(d2 += (double)((CombatLuck)genericObject2).getEdIncrease() * (double)genericObject2.getLevels() / (double)((CombatLuck)genericObject2).getEdIncreaseLevels());
        }
        this.primaryValue = d2;
        this.primaryValueCalcTime = System.currentTimeMillis();
    }

    protected void calcResistantTotal(boolean bl) {
        int n;
        GenericObject genericObject;
        int n2;
        GenericObject genericObject2;
        int n3;
        double d = 0.0;
        for (n3 = 0; n3 < HeroDesigner.getActiveHero().getPowers().size(); ++n3) {
            if (HeroDesigner.getActiveHero().getPowers().get(n3) instanceof CompoundPower) {
                genericObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n3);
                for (n2 = 0; n2 < ((CompoundPower)genericObject2).getPowers().size(); ++n2) {
                    if (((CompoundPower)genericObject2).getPowers().get(n2) instanceof Power) {
                        genericObject = (Power)((CompoundPower)genericObject2).getPowers().get(n2);
                        if (((CharAffectingObject)genericObject).getEdIncreaseLevels() <= 0 || !((Power)genericObject).resistantDefenses() || !((CharAffectingObject)genericObject).getAffectPrimary() && bl || !((CharAffectingObject)genericObject).getAffectTotal()) continue;
                        d += (double)Rounder.roundHalfUp(((CharAffectingObject)genericObject).getEdIncrease() * (double)((CharAffectingObject)genericObject).getLevels() / (double)((CharAffectingObject)genericObject).getEdIncreaseLevels());
                        continue;
                    }
                    if (!(((CompoundPower)genericObject2).getPowers().get(n2) instanceof CombatLuck) || ((CombatLuck)(genericObject = (CombatLuck)((CompoundPower)genericObject2).getPowers().get(n2))).getEdIncreaseLevels() <= 0 || !((CombatLuck)genericObject).getAffectPrimary() && bl || !((CombatLuck)genericObject).getAffectTotal()) continue;
                    d += (double)Rounder.roundHalfUp((double)((CombatLuck)genericObject).getEdIncrease() * (double)genericObject.getLevels() / (double)((CombatLuck)genericObject).getEdIncreaseLevels());
                }
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n3) instanceof Power) {
                genericObject2 = (Power)HeroDesigner.getActiveHero().getPowers().get(n3);
                if (((CharAffectingObject)genericObject2).getEdIncreaseLevels() <= 0 || !((Power)genericObject2).resistantDefenses() || !((CharAffectingObject)genericObject2).getAffectPrimary() && bl || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
                d += (double)Rounder.roundHalfUp(((CharAffectingObject)genericObject2).getEdIncrease() * (double)((CharAffectingObject)genericObject2).getLevels() / (double)((CharAffectingObject)genericObject2).getEdIncreaseLevels());
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n3) instanceof CombatLuck) || ((CombatLuck)(genericObject2 = (CombatLuck)HeroDesigner.getActiveHero().getPowers().get(n3))).getEdIncreaseLevels() <= 0 || !((CombatLuck)genericObject2).getAffectPrimary() && bl || !((CombatLuck)genericObject2).getAffectTotal()) continue;
            d += (double)Rounder.roundHalfUp((double)((CombatLuck)genericObject2).getEdIncrease() * (double)genericObject2.getLevels() / (double)((CombatLuck)genericObject2).getEdIncreaseLevels());
        }
        for (n3 = 0; n3 < HeroDesigner.getActiveHero().getEquipment().size(); ++n3) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n3) instanceof CompoundPower) {
                genericObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n3);
                for (n2 = 0; n2 < ((CompoundPower)genericObject2).getPowers().size(); ++n2) {
                    if (((CompoundPower)genericObject2).getPowers().get(n2) instanceof Power) {
                        genericObject = (Power)((CompoundPower)genericObject2).getPowers().get(n2);
                        if (((CharAffectingObject)genericObject).getEdIncreaseLevels() <= 0 || !((Power)genericObject).resistantDefenses() || !((CharAffectingObject)genericObject).getAffectPrimary() && bl || !((CharAffectingObject)genericObject).getAffectTotal()) continue;
                        d += (double)Rounder.roundHalfUp(((CharAffectingObject)genericObject).getEdIncrease() * (double)((CharAffectingObject)genericObject).getLevels() / (double)((CharAffectingObject)genericObject).getEdIncreaseLevels());
                        continue;
                    }
                    if (!(((CompoundPower)genericObject2).getPowers().get(n2) instanceof CombatLuck) || ((CombatLuck)(genericObject = (CombatLuck)((CompoundPower)genericObject2).getPowers().get(n2))).getEdIncreaseLevels() <= 0 || !((CombatLuck)genericObject).getAffectPrimary() && bl || !((CombatLuck)genericObject).getAffectTotal()) continue;
                    d += (double)Rounder.roundHalfUp((double)((CombatLuck)genericObject).getEdIncrease() * (double)genericObject.getLevels() / (double)((CombatLuck)genericObject).getEdIncreaseLevels());
                }
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n3) instanceof Power) {
                genericObject2 = (Power)HeroDesigner.getActiveHero().getEquipment().get(n3);
                if (((CharAffectingObject)genericObject2).getEdIncreaseLevels() <= 0 || !((Power)genericObject2).resistantDefenses() || !((CharAffectingObject)genericObject2).getAffectPrimary() && bl || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
                d += (double)Rounder.roundHalfUp(((CharAffectingObject)genericObject2).getEdIncrease() * (double)((CharAffectingObject)genericObject2).getLevels() / (double)((CharAffectingObject)genericObject2).getEdIncreaseLevels());
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n3) instanceof CombatLuck) || ((CombatLuck)(genericObject2 = (CombatLuck)HeroDesigner.getActiveHero().getEquipment().get(n3))).getEdIncreaseLevels() <= 0 || !((CombatLuck)genericObject2).getAffectPrimary() && bl || !((CombatLuck)genericObject2).getAffectTotal()) continue;
            d += (double)Rounder.roundHalfUp((double)((CombatLuck)genericObject2).getEdIncrease() * (double)genericObject2.getLevels() / (double)((CombatLuck)genericObject2).getEdIncreaseLevels());
        }
        for (n3 = 0; n3 < HeroDesigner.getActiveHero().getTalents().size(); ++n3) {
            if (!(HeroDesigner.getActiveHero().getTalents().get(n3) instanceof CombatLuck) || !((CombatLuck)(genericObject2 = (CombatLuck)HeroDesigner.getActiveHero().getTalents().get(n3))).getAffectPrimary() && bl || !((CombatLuck)genericObject2).getAffectTotal()) continue;
            Rounder.roundHalfUp(d += (double)((CombatLuck)genericObject2).getEdIncrease() * (double)genericObject2.getLevels() / (double)((CombatLuck)genericObject2).getEdIncreaseLevels());
        }
        n3 = this.getEdResistance();
        if (n3 <= (n = this.getNonresistantTotal(bl))) {
            d += (double)n3;
        } else if (n > 0) {
            d += (double)n;
        }
        if (bl) {
            this.primaryResistantTotal = (int)Rounder.roundHalfUp(d);
            this.primaryResistantTotalCalcTime = System.currentTimeMillis();
        } else {
            this.secondaryResistantTotal = (int)Rounder.roundHalfUp(d);
            this.secondaryResistantTotalCalcTime = System.currentTimeMillis();
        }
    }

    @Override
    protected void calcSecondaryValue() {
        CombatLuck combatLuck;
        int n;
        GenericObject genericObject;
        int n2;
        super.calcSecondaryValue();
        double d = this.secondaryValue;
        for (n2 = 0; n2 < HeroDesigner.getActiveHero().getTalents().size(); ++n2) {
            if (!(HeroDesigner.getActiveHero().getTalents().get(n2) instanceof CombatLuck) || ((CombatLuck)(genericObject = (CombatLuck)HeroDesigner.getActiveHero().getTalents().get(n2))).getAffectPrimary() || !((CombatLuck)genericObject).getAffectTotal()) continue;
            d += (double)((CombatLuck)genericObject).getEdIncrease() * (double)genericObject.getLevels() / (double)((CombatLuck)genericObject).getEdIncreaseLevels();
        }
        for (n2 = 0; n2 < HeroDesigner.getActiveHero().getPowers().size(); ++n2) {
            if (HeroDesigner.getActiveHero().getPowers().get(n2) instanceof CombatLuck) {
                genericObject = (CombatLuck)HeroDesigner.getActiveHero().getPowers().get(n2);
                if (((CombatLuck)genericObject).getAffectPrimary() || !((CombatLuck)genericObject).getAffectTotal()) continue;
                d += (double)((CombatLuck)genericObject).getEdIncrease() * (double)genericObject.getLevels() / (double)((CombatLuck)genericObject).getEdIncreaseLevels();
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n2) instanceof CompoundPower)) continue;
            genericObject = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n2);
            for (n = 0; n < ((CompoundPower)genericObject).getPowers().size(); ++n) {
                if (!(((CompoundPower)genericObject).getPowers().get(n) instanceof CombatLuck) || (combatLuck = (CombatLuck)((CompoundPower)genericObject).getPowers().get(n)).getAffectPrimary() || !combatLuck.getAffectTotal()) continue;
                d += (double)combatLuck.getEdIncrease() * (double)combatLuck.getLevels() / (double)combatLuck.getEdIncreaseLevels();
            }
        }
        for (n2 = 0; n2 < HeroDesigner.getActiveHero().getEquipment().size(); ++n2) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n2) instanceof CombatLuck) {
                genericObject = (CombatLuck)HeroDesigner.getActiveHero().getEquipment().get(n2);
                if (((CombatLuck)genericObject).getAffectPrimary() || !((CombatLuck)genericObject).getAffectTotal()) continue;
                d += (double)((CombatLuck)genericObject).getEdIncrease() * (double)genericObject.getLevels() / (double)((CombatLuck)genericObject).getEdIncreaseLevels();
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n2) instanceof CompoundPower)) continue;
            genericObject = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n2);
            for (n = 0; n < ((CompoundPower)genericObject).getPowers().size(); ++n) {
                if (!(((CompoundPower)genericObject).getPowers().get(n) instanceof CombatLuck) || (combatLuck = (CombatLuck)((CompoundPower)genericObject).getPowers().get(n)).getAffectPrimary() || !combatLuck.getAffectTotal()) continue;
                d += (double)combatLuck.getEdIncrease() * (double)combatLuck.getLevels() / (double)combatLuck.getEdIncreaseLevels();
            }
        }
        this.secondaryValue = d;
    }

    @Override
    public String getDisplayNotes() {
        int n = this.getResistantTotal(true);
        int n2 = this.getResistantTotal(false);
        int n3 = this.getNonresistantTotal(true);
        int n4 = this.getNonresistantTotal(false);
        String string = n3 + "";
        if (n3 != n4) {
            string = string + "/" + n4;
        }
        string = string + " ED (" + n;
        if (n != n2) {
            string = string + "/" + n2;
        }
        string = string + " rED)";
        return string;
    }

    public int getEdResistance() {
        if (this.edResistance <= 0 || (long)this.edResistance < HeroDesigner.lastEdit) {
            this.calcEdResistance();
        }
        return this.edResistance;
    }

    public int getNonresistantTotal(boolean bl) {
        double d;
        double d2 = d = 0.0;
        d2 = bl ? (d2 += this.getPrimaryValue()) : (d2 += this.getSecondaryValue());
        if (d2 < (double)this.maxVal) {
            return (int)Rounder.roundHalfUp(d2);
        }
        return this.maxVal;
    }

    public int getResistantTotal(boolean bl) {
        if (bl) {
            if (this.primaryResistantTotalCalcTime <= 0L || this.primaryResistantTotalCalcTime < HeroDesigner.lastEdit) {
                this.calcResistantTotal(bl);
            }
            return this.primaryResistantTotal;
        }
        if (this.secondaryResistantTotalCalcTime <= 0L || this.secondaryResistantTotalCalcTime < HeroDesigner.lastEdit) {
            this.calcResistantTotal(bl);
        }
        return this.secondaryResistantTotal;
    }

    @Override
    public String getRoll() {
        return "";
    }

    @Override
    public int getType() {
        return 10;
    }
}

