/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.characteristics;

import com.hero.HeroDesigner;
import com.hero.objects.characteristics.Characteristic;
import com.hero.util.Rounder;
import org.jdom.Element;

public class Dexterity
extends Characteristic {
    private static String xmlID = "DEX";

    public Dexterity(Element element) {
        super(element, xmlID);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getDisplayNotes() {
        String string = "";
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return "";
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
            Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
            if (characteristic.getOcvIncreaseLevels() != 0) {
                int n = characteristic.getOcvIncrease() < 0.0 ? -1 : 1;
                double d3 = 0.0;
                d3 = Math.abs(characteristic.getOcvIncrease()) * characteristic.getPrimaryValue() / (double)characteristic.getOcvIncreaseLevels();
                d += (d3 *= (double)n);
            }
            if (characteristic.getDcvIncreaseLevels() == 0) continue;
            d2 += (double)characteristic.getDcvEffect(true);
        }
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
            Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
            if (characteristic.getOcvIncreaseLevels() != 0) {
                int n = characteristic.getOcvIncrease() < 0.0 ? -1 : 1;
                double d6 = 0.0;
                d6 = Math.abs(characteristic.getOcvIncrease()) * characteristic.getSecondaryValue() / (double)characteristic.getOcvIncreaseLevels();
                d4 += (d6 *= (double)n);
            }
            if (characteristic.getDcvIncreaseLevels() == 0) continue;
            d5 += (double)characteristic.getDcvEffect(false);
        }
        string = "OCV " + Rounder.roundHalfUp(d);
        if (d != d4) {
            string = string + "/" + Rounder.roundHalfUp(d4);
        }
        string = string + " DCV " + Rounder.roundHalfUp(d2);
        if (d2 != d5) {
            string = string + "/" + Rounder.roundHalfUp(d5);
        }
        return string;
    }
}

