/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.characteristics;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.Power;
import com.hero.ui.dialog.CharacteristicDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jdom.Element;

public class Characteristic
extends CharAffectingObject {
    protected boolean addModifiersToBase;
    protected long assignedModifiersCalcTime;
    protected ArrayList<Modifier> assignedMods;
    protected double baseLevel;
    protected double baseValue;
    protected long baseValueCalcTime;
    protected double doubleBase;
    protected double figuredMinValue;
    protected long figuredMinValueCalcTime;
    protected int maxVal;
    double ncmCharValue;
    double ncmCharValueCalcTime;
    protected Hashtable<String, Integer> ncmLevels;
    protected double origBaseLevel;
    protected double primaryValue;
    protected long primaryValueCalcTime;
    protected double secondaryValue;
    protected long secondaryValueCalcTime;
    protected boolean showRoll;

    public Characteristic(Element element, String string) {
        super(element, string);
        this.affectsPrimary = true;
    }

    public boolean addModifiersToBase() {
        if (!this.isPower()) {
            return false;
        }
        return this.addModifiersToBase;
    }

    void calcAssignedModifiers() {
        ArrayList arrayList = super.getAssignedModifiers();
        if (this.getParentList() != null && (this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl || this.getParentList() instanceof VariablePowerPool) && GenericObject.findObjectByID(arrayList, "NOFIGURED") == null && GenericObject.findObjectByID(this.availableModifiers, "NOFIGURED") != null && HeroDesigner.getActiveHero().getRules().automaticallyApplyNoFigured()) {
            Modifier modifier = (Modifier)GenericObject.findObjectByID(this.availableModifiers, "NOFIGURED");
            modifier.setParent(this);
            arrayList.add(modifier);
        }
        if (this.isPower()) {
            this.assignedMods = arrayList;
            return;
        }
        arrayList = (ArrayList)arrayList.clone();
        if (!this.isPower() && HeroDesigner.getActiveHero() != null) {
            CharAffectingObject charAffectingObject;
            int n;
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof Characteristic) {
                    charAffectingObject = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                    if (!charAffectingObject.getXMLID().equals(this.getXMLID()) || !((Characteristic)charAffectingObject).addModifiersToBase() || charAffectingObject.getID() == this.getID()) continue;
                    for (Modifier modifier : ((Characteristic)charAffectingObject).getAssignedModifiers()) {
                        if (GenericObject.findObjectByID(arrayList, modifier.getXMLID()) != null) continue;
                        arrayList.add(modifier);
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower)) continue;
                charAffectingObject = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject).getPowers().size(); ++i) {
                    Characteristic characteristic;
                    if (!(((CompoundPower)charAffectingObject).getPowers().get(i) instanceof Characteristic) || !(characteristic = (Characteristic)((CompoundPower)charAffectingObject).getPowers().get(i)).getXMLID().equals(this.getXMLID()) || !characteristic.addModifiersToBase() || characteristic.getID() == this.getID()) continue;
                    for (Modifier modifier : characteristic.getAssignedModifiers()) {
                        if (GenericObject.findObjectByID(arrayList, modifier.getXMLID()) != null) continue;
                        arrayList.add(modifier);
                    }
                }
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
                if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Characteristic) {
                    charAffectingObject = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                    if (!charAffectingObject.getXMLID().equals(this.getXMLID()) || !((Characteristic)charAffectingObject).addModifiersToBase() || charAffectingObject.getID() == this.getID()) continue;
                    for (Modifier modifier : ((Characteristic)charAffectingObject).getAssignedModifiers()) {
                        if (GenericObject.findObjectByID(arrayList, modifier.getXMLID()) != null) continue;
                        arrayList.add(modifier);
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower)) continue;
                charAffectingObject = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject).getPowers().size(); ++i) {
                    Characteristic characteristic;
                    if (!(((CompoundPower)charAffectingObject).getPowers().get(i) instanceof Characteristic) || !(characteristic = (Characteristic)((CompoundPower)charAffectingObject).getPowers().get(i)).getXMLID().equals(this.getXMLID()) || !characteristic.addModifiersToBase() || characteristic.getID() == this.getID()) continue;
                    for (Modifier modifier : characteristic.getAssignedModifiers()) {
                        if (GenericObject.findObjectByID(arrayList, modifier.getXMLID()) != null) continue;
                        arrayList.add(modifier);
                    }
                }
            }
        }
        this.assignedMods = arrayList;
        this.assignedModifiersCalcTime = System.currentTimeMillis();
    }

    void calcBaseValue() {
        double d = 0.0;
        if (HeroDesigner.getActiveHero() != null) {
            double d2;
            CharAffectingObject charAffectingObject;
            CharAffectingObject charAffectingObject2;
            int n;
            for (n = 0; n < HeroDesigner.getActiveHero().getCharacteristics().size(); ++n) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(n);
                if (charAffectingObject2.getXMLID().equals(this.getXMLID()) || charAffectingObject2.getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0) continue;
                double d3 = ((Characteristic)charAffectingObject2).getCharacteristicValue() * charAffectingObject2.getIncrease(this.getType()) / (double)charAffectingObject2.getIncreaseLevels(this.getType());
                this.doubleBase += d3;
                d += (double)Rounder.roundHalfUp(d3);
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) continue;
                if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) || !(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Characteristic) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d2;
                        d += (double)Rounder.roundHalfUp(d2);
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof Characteristic) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d4 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d4;
                d += (double)Rounder.roundHalfUp(d4);
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
                if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) continue;
                if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                    charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                    for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                        if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID()) || !(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof Characteristic) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                        d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                        this.doubleBase += d2;
                        d += (double)Rounder.roundHalfUp(d2);
                    }
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Characteristic) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject2.getIncrease(this.getType()) == 0.0 || !charAffectingObject2.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType()) || !charAffectingObject2.getAffectTotal()) continue;
                double d5 = charAffectingObject2.getIncreaseValue(this.getType(), true);
                this.doubleBase += d5;
                d += (double)Rounder.roundHalfUp(d5);
            }
        }
        this.baseValue = this.baseLevel + d < (double)this.maxVal ? this.baseLevel + d : (double)this.maxVal;
        this.baseValueCalcTime = System.currentTimeMillis();
    }

    public double getPREIncreaseValue() {
        if (this.getIncreaseLevels(7) > 0 && this.getIncrease(7) != 0.0) {
            return this.getCharacteristicValue() * this.getIncrease(7) / (double)this.getIncreaseLevels(7);
        }
        return 0.0;
    }

    void calcFiguredMinValue() {
        double d = 0.0;
        if (HeroDesigner.getActiveHero() != null) {
            double d2;
            CharAffectingObject charAffectingObject;
            int n;
            this.baseLevel = this.origBaseLevel;
            this.doubleBase = this.origBaseLevel;
            for (n = 0; n < HeroDesigner.getActiveHero().getCharacteristics().size(); ++n) {
                charAffectingObject = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(n);
                if (charAffectingObject.getXMLID().equals(this.getXMLID()) || charAffectingObject.getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0) continue;
                d2 = ((Characteristic)charAffectingObject).getCharacteristicValue() * charAffectingObject.getIncrease(this.getType()) / (double)charAffectingObject.getIncreaseLevels(this.getType());
                this.doubleBase += d2;
                d += (double)Rounder.roundHalfUp(d2);
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
                if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID()) || !(HeroDesigner.getActiveHero().getPowers().get(n) instanceof Power) || (charAffectingObject = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType())) continue;
                d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                this.doubleBase += d2;
                d += (double)Rounder.roundHalfUp(d2);
            }
            for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
                if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID()) || !(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Power) || (charAffectingObject = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType())) continue;
                d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                this.doubleBase += d2;
                d += (double)Rounder.roundHalfUp(d2);
            }
        }
        this.figuredMinValue = this.baseLevel + d < (double)this.maxVal ? this.baseLevel + d : (double)this.maxVal;
        this.figuredMinValueCalcTime = System.currentTimeMillis();
    }

    void calcNCMCharValue() {
        double d = (double)this.getLevels() + this.origBaseLevel;
        if (HeroDesigner.getActiveHero() != null) {
            for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
                Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
                if (characteristic.getXMLID().equals(this.getXMLID()) || characteristic.getIncreaseLevels(this.getType()) <= 0 || characteristic.getIncrease(this.getType()) == 0.0) continue;
                double d2 = characteristic.getNCMCharValue() * characteristic.getIncrease(this.getType()) / (double)characteristic.getIncreaseLevels(this.getType());
                this.doubleBase += d2;
                d += (double)Rounder.roundHalfUp(d2);
            }
            this.ncmCharValue = d < (double)this.maxVal ? d : (double)this.maxVal;
            this.ncmCharValueCalcTime = System.currentTimeMillis();
        }
    }

    void calcPrimaryValue() {
        double d;
        CharAffectingObject charAffectingObject;
        int n;
        GenericObject genericObject2;
        double d2 = this.getCharacteristicValue();
        if (this.isPower) {
            for (GenericObject genericObject2 : HeroDesigner.getActiveHero().getCharacteristics()) {
                if (!genericObject2.getXMLID().equals(this.getXMLID())) continue;
                this.doubleBase += (double)genericObject2.getLevels();
            }
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) {
                genericObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (!((CharAffectingObject)genericObject2).getAffectPrimary() || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
                d2 += (double)((CharAffectingObject)genericObject2).getLevels();
                this.doubleBase += (double)((CharAffectingObject)genericObject2).getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                genericObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)genericObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)genericObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)genericObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        this.doubleBase += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (!(((CompoundPower)genericObject2).getPowers().get(i) instanceof Power) || (charAffectingObject = (CharAffectingObject)((CompoundPower)genericObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d = charAffectingObject.getIncreaseValue(this.getType(), true);
                    this.doubleBase += d;
                    d2 += (double)Rounder.roundHalfUp(d);
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof Power) || ((CharAffectingObject)(genericObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n))).getIncreaseLevels(this.getType()) <= 0 || ((CharAffectingObject)genericObject2).getIncrease(this.getType()) == 0.0 || !((CharAffectingObject)genericObject2).getAffectPrimary() || !CharAffectingObject.checkFigured(genericObject2, this.getType()) || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
            double d3 = ((CharAffectingObject)genericObject2).getIncreaseValue(this.getType(), true);
            this.doubleBase += d3;
            d2 += (double)Rounder.roundHalfUp(d3);
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) {
                genericObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (!((CharAffectingObject)genericObject2).getAffectPrimary() || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
                d2 += (double)((CharAffectingObject)genericObject2).getLevels();
                this.doubleBase += (double)((CharAffectingObject)genericObject2).getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                genericObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)genericObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)genericObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)genericObject2).getPowers().get(i);
                        if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        this.doubleBase += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (!(((CompoundPower)genericObject2).getPowers().get(i) instanceof Power) || (charAffectingObject = (CharAffectingObject)((CompoundPower)genericObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !charAffectingObject.getAffectPrimary() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType()) || !charAffectingObject.getAffectTotal()) continue;
                    d = charAffectingObject.getIncreaseValue(this.getType(), true);
                    this.doubleBase += d;
                    d2 += (double)Rounder.roundHalfUp(d);
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof Power) || ((CharAffectingObject)(genericObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n))).getIncreaseLevels(this.getType()) <= 0 || ((CharAffectingObject)genericObject2).getIncrease(this.getType()) == 0.0 || !((CharAffectingObject)genericObject2).getAffectPrimary() || !CharAffectingObject.checkFigured(genericObject2, this.getType()) || !((CharAffectingObject)genericObject2).getAffectTotal()) continue;
            double d4 = ((CharAffectingObject)genericObject2).getIncreaseValue(this.getType(), true);
            this.doubleBase += d4;
            d2 += (double)Rounder.roundHalfUp(d4);
        }
        this.primaryValue = d2;
        this.primaryValueCalcTime = System.currentTimeMillis();
    }

    void calcSecondaryValue() {
        double d;
        CharAffectingObject charAffectingObject;
        CharAffectingObject charAffectingObject2;
        int n;
        double d2 = 0.0;
        for (n = 0; n < HeroDesigner.getActiveHero().getPowers().size(); ++n) {
            if (HeroDesigner.getActiveHero().getPowers().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n);
                if (charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d2 += (double)charAffectingObject2.getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getPowers().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getPowers().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject, this.getType())) continue;
                    d = charAffectingObject.getIncreaseValue(this.getType(), false);
                    d2 += (double)Rounder.roundHalfUp(d);
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getPowers().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType())) continue;
            double d3 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d2 += (double)Rounder.roundHalfUp(d3);
        }
        for (n = 0; n < HeroDesigner.getActiveHero().getEquipment().size(); ++n) {
            if (HeroDesigner.getActiveHero().getEquipment().get(n).getXMLID().equals(this.getXMLID())) {
                charAffectingObject2 = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n);
                if (charAffectingObject2.getAffectPrimary() || !charAffectingObject2.getAffectTotal()) continue;
                d2 += (double)charAffectingObject2.getLevels();
                continue;
            }
            if (HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CompoundPower) {
                charAffectingObject2 = (CompoundPower)HeroDesigner.getActiveHero().getEquipment().get(n);
                for (int i = 0; i < ((CompoundPower)charAffectingObject2).getPowers().size(); ++i) {
                    if (((CompoundPower)charAffectingObject2).getPowers().get(i).getXMLID().equals(this.getXMLID())) {
                        charAffectingObject = (Characteristic)((CompoundPower)charAffectingObject2).getPowers().get(i);
                        if (charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal()) continue;
                        d2 += (double)charAffectingObject.getLevels();
                        continue;
                    }
                    if (!(((CompoundPower)charAffectingObject2).getPowers().get(i) instanceof CharAffectingObject) || (charAffectingObject = (CharAffectingObject)((CompoundPower)charAffectingObject2).getPowers().get(i)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject, this.getType())) continue;
                    d = charAffectingObject.getIncreaseValue(this.getType(), false);
                    d2 += (double)Rounder.roundHalfUp(d);
                }
                continue;
            }
            if (!(HeroDesigner.getActiveHero().getEquipment().get(n) instanceof CharAffectingObject) || (charAffectingObject2 = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n)).getIncreaseLevels(this.getType()) <= 0 || !CharAffectingObject.checkFigured(charAffectingObject2, this.getType())) continue;
            double d4 = charAffectingObject2.getIncreaseValue(this.getType(), false);
            d2 += (double)Rounder.roundHalfUp(d4);
        }
        this.secondaryValue = this.getPrimaryValue() + d2 < (double)this.maxVal ? this.getPrimaryValue() + d2 : (double)this.maxVal;
        this.secondaryValueCalcTime = System.currentTimeMillis();
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof GenericObject) {
            GenericObject genericObject = (GenericObject)object;
            return this.getPosition() - genericObject.getPosition();
        }
        return this.toString().compareTo(object.toString());
    }

    @Override
    public double getActiveCost() {
        Characteristic characteristic;
        double d = this.getTotalCost();
        if (!this.isPower()) {
            return d;
        }
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
            Modifier modifier = this.getAssignedModifiers().get(i);
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        if (this.getParentList() != null) {
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            for (int i = 0; i < arrayList.size(); ++i) {
                Modifier modifier = arrayList.get(i);
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() > 0.0) || GenericObject.findObjectByID(this.getAssignedModifiers(), modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") || this.getParentList() instanceof Multipower || this.getParentList() instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        if (this.addModifiersToBase() && (characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.getType())) != null) {
            Automaton automaton;
            double d5 = characteristic.getCharacteristicValue();
            double d6 = d5 * characteristic.getLevelCost() / characteristic.getLevelValue();
            if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && (automaton = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON")).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
                d6 *= (double)automaton.getDefenseCostMultiplier();
            }
            double d7 = d6 * (1.0 + d2) - d6;
            d4 = Rounder.roundHalfDown(d7);
        }
        double d8 = d * (1.0 + d2);
        d3 = d * (1.0 + d2);
        if (bl) {
            d8 = Rounder.roundHalfDown(d8);
        }
        if (d8 == 0.0 && d3 > 0.0) {
            d8 = 1.0;
        }
        return d8 += d4;
    }

    @Override
    public ArrayList<Modifier> getAssignedModifiers() {
        if (this.assignedModifiersCalcTime <= 0L || this.assignedModifiersCalcTime < HeroDesigner.lastEdit) {
            this.calcAssignedModifiers();
        }
        return this.assignedMods;
    }

    public double getBaseValue() {
        if (this.baseValueCalcTime <= 0L || this.baseValueCalcTime < HeroDesigner.lastEdit) {
            this.calcBaseValue();
        }
        return this.baseValue;
    }

    @Override
    public double getBodyIncrease() {
        if (!CharAffectingObject.checkFigured(this, 4)) {
            return 0.0;
        }
        if (this.bodyIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.bodyIncrease;
    }

    @Override
    public double getCustom1Increase() {
        if (!CharAffectingObject.checkFigured(this, 20)) {
            return 0.0;
        }
        if (this.custom1Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom1Increase;
    }

    @Override
    public double getCustom2Increase() {
        if (!CharAffectingObject.checkFigured(this, 21)) {
            return 0.0;
        }
        if (this.custom2Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom2Increase;
    }

    public int getMdLevels() {
        if (this.getMDIncreaseLevels() != 0) {
            return (int)Rounder.roundHalfUp(this.getSecondaryValue() / (double)this.getMDIncreaseLevels() * this.getMDIncrease());
        }
        return 0;
    }

    @Override
    public double getCustom3Increase() {
        if (!CharAffectingObject.checkFigured(this, 22)) {
            return 0.0;
        }
        if (this.custom3Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom3Increase;
    }

    @Override
    public double getCustom4Increase() {
        if (!CharAffectingObject.checkFigured(this, 23)) {
            return 0.0;
        }
        if (this.custom4Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom4Increase;
    }

    @Override
    public double getCustom5Increase() {
        if (!CharAffectingObject.checkFigured(this, 24)) {
            return 0.0;
        }
        if (this.custom5Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom5Increase;
    }

    @Override
    public double getCustom6Increase() {
        if (!CharAffectingObject.checkFigured(this, 25)) {
            return 0.0;
        }
        if (this.custom6Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom6Increase;
    }

    @Override
    public double getCustom7Increase() {
        if (!CharAffectingObject.checkFigured(this, 26)) {
            return 0.0;
        }
        if (this.custom7Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom7Increase;
    }

    @Override
    public double getCustom8Increase() {
        if (!CharAffectingObject.checkFigured(this, 27)) {
            return 0.0;
        }
        if (this.custom8Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom8Increase;
    }

    @Override
    public double getCustom9Increase() {
        if (!CharAffectingObject.checkFigured(this, 28)) {
            return 0.0;
        }
        if (this.custom9Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom9Increase;
    }

    @Override
    public double getCustom10Increase() {
        if (!CharAffectingObject.checkFigured(this, 29)) {
            return 0.0;
        }
        if (this.custom10Increase == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.custom10Increase;
    }

    public String getCharacteristicBase() {
        return "" + Rounder.roundHalfUp(this.getBaseValue());
    }

    public double getCharacteristicValue() {
        double d = 0.0;
        if (!this.isPower()) {
            d = this.getBaseValue() + (double)this.getLevels();
        } else {
            Characteristic characteristic;
            d = this.getBaseValue();
            if (HeroDesigner.getActiveHero() != null && (characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.getType())) != null) {
                d += (double)characteristic.getLevels();
            }
        }
        if (d < (double)this.minimumLevel) {
            return this.minimumLevel;
        }
        if (d > (double)this.maxVal) {
            return this.maxVal;
        }
        return d;
    }

    @Override
    public String getColumn2Output() {
        String string;
        if (this.getLevels() == 0 && this.addModifiersToBase() && this.getModifierString().trim().length() > 0) {
            String string2 = this.getModifierString();
            if (string2.trim().startsWith(",")) {
                string2 = string2.trim().substring(1, string2.length()).trim();
            }
            string2 = string2 + " applied to " + this.getAlias();
            if (this.getName() != null && this.getName().trim().length() > 0) {
                string2 = "<i>" + this.getName() + ":</i>  " + string2;
            }
            return string2;
        }
        String string3 = string = this.getLevels() >= 0 ? "+" : "";
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        string = string + this.getLevels() + " " + this.getAlias();
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + ":  " + this.getInput();
        }
        if (this.getSelectedOption() != null) {
            string = string + " (";
            string = string + this.getSelectedOption().getAlias();
            String string4 = this.getAdderString();
            if (string4.trim().length() > 0) {
                string = string + "; " + string4;
            }
            string = string + ")";
        } else {
            String string5 = this.getAdderString();
            if (string5.trim().length() > 0) {
                string = string + " (" + string5 + ")";
            }
        }
        string = string + this.getModifierString();
        if (this.getEndUsage() > 0 && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") != null && GenericObject.findObjectByID(this.getAssignedModifiers(), "ENDRESERVEOREND") == null && !HeroDesigner.getInstance().getPrefs().useWG()) {
            string = this.getUseENDReserve() ? string + " (uses END Reserve)" : string + " (uses Personal END)";
        }
        if (this.addModifiersToBase()) {
            string = string + " (Modifiers affect Base Characteristic)";
        }
        return string;
    }

    @Override
    public String getColumn3Output() {
        if (this.getEndUsage() > 0) {
            return "" + this.getEndUsage();
        }
        return "";
    }

    @Override
    public double getComIncrease() {
        if (!CharAffectingObject.checkFigured(this, 8)) {
            return 0.0;
        }
        if (this.comIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.comIncrease;
    }

    @Override
    public double getConIncrease() {
        if (!CharAffectingObject.checkFigured(this, 3)) {
            return 0.0;
        }
        if (this.conIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.conIncrease;
    }

    public String getDamageDisplay() {
        return "";
    }

    public int getDcvEffect(boolean bl) {
        if (this.getDcvIncreaseLevels() != 0) {
            int n = this.getDcvIncrease() < 0.0 ? -1 : 1;
            double d = 0.0;
            double d2 = bl ? this.getPrimaryValue() : this.getSecondaryValue();
            d = Math.abs(this.getDcvIncrease()) * d2 / (double)this.getDcvIncreaseLevels();
            d *= (double)n;
            d = Rounder.roundHalfUp(d);
            return (int)d;
        }
        return 0;
    }

    @Override
    public double getDexIncrease() {
        if (!CharAffectingObject.checkFigured(this, 2)) {
            return 0.0;
        }
        if (this.dexIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.dexIncrease;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        CharacteristicDialog characteristicDialog = new CharacteristicDialog(this, bl, bl2);
        return characteristicDialog;
    }

    @Override
    public String getDisplayNotes() {
        return "";
    }

    @Override
    public double getEdIncrease() {
        if (!CharAffectingObject.checkFigured(this, 10)) {
            return 0.0;
        }
        if (this.edIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.edIncrease;
    }

    @Override
    public double getEgoIncrease() {
        if (!CharAffectingObject.checkFigured(this, 6)) {
            return 0.0;
        }
        if (this.egoIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.egoIncrease;
    }

    @Override
    public double getEndIncrease() {
        if (!CharAffectingObject.checkFigured(this, 13)) {
            return 0.0;
        }
        if (this.endIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.endIncrease;
    }

    public double getFiguredBaseValue(int n) {
        double d = 0.0;
        if (HeroDesigner.getActiveHero() != null) {
            double d2;
            CharAffectingObject charAffectingObject;
            int n2;
            this.baseLevel = this.origBaseLevel;
            this.doubleBase = this.origBaseLevel;
            for (n2 = 0; n2 < HeroDesigner.getActiveHero().getCharacteristics().size(); ++n2) {
                charAffectingObject = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(n2);
                if (charAffectingObject.getXMLID().equals(this.getXMLID()) || charAffectingObject.getIncreaseLevels(this.getType()) <= 0 || charAffectingObject.getIncrease(this.getType()) == 0.0 || !CharAffectingObject.checkFigured(charAffectingObject, this.getType())) continue;
                d2 = ((Characteristic)charAffectingObject).getCharacteristicValue() * charAffectingObject.getIncrease(this.getType()) / (double)charAffectingObject.getIncreaseLevels(this.getType());
                this.doubleBase += d2;
                d += (double)Rounder.roundHalfUp(d2);
            }
            for (n2 = 0; n2 < HeroDesigner.getActiveHero().getPowers().size(); ++n2) {
                if (HeroDesigner.getActiveHero().getPowers().get(n2).getXMLID().equals(this.getXMLID())) {
                    charAffectingObject = (Characteristic)HeroDesigner.getActiveHero().getPowers().get(n2);
                    if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal() || !CharAffectingObject.checkFigured(charAffectingObject, n)) continue;
                    d += (double)charAffectingObject.getLevels();
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getPowers().get(n2) instanceof Power) || (charAffectingObject = (CharAffectingObject)HeroDesigner.getActiveHero().getPowers().get(n2)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType())) continue;
                d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                this.doubleBase += d2;
                d += (double)Rounder.roundHalfUp(d2);
            }
            for (n2 = 0; n2 < HeroDesigner.getActiveHero().getEquipment().size(); ++n2) {
                if (HeroDesigner.getActiveHero().getEquipment().get(n2).getXMLID().equals(this.getXMLID())) {
                    charAffectingObject = (Characteristic)HeroDesigner.getActiveHero().getEquipment().get(n2);
                    if (!charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal() || !CharAffectingObject.checkFigured(charAffectingObject, n)) continue;
                    d += (double)charAffectingObject.getLevels();
                    continue;
                }
                if (!(HeroDesigner.getActiveHero().getEquipment().get(n2) instanceof Power) || (charAffectingObject = (CharAffectingObject)HeroDesigner.getActiveHero().getEquipment().get(n2)).getIncreaseLevels(this.getType()) <= 0 || !charAffectingObject.getAffectPrimary() || !charAffectingObject.getAffectTotal() || !CharAffectingObject.checkFigured(charAffectingObject, this.getType())) continue;
                d2 = charAffectingObject.getIncreaseValue(this.getType(), true);
                this.doubleBase += d2;
                d += (double)Rounder.roundHalfUp(d2);
            }
        }
        if (this.baseLevel + d < (double)this.maxVal) {
            return this.baseLevel + d;
        }
        return this.maxVal;
    }

    public double getFiguredMinValue() {
        if (this.figuredMinValueCalcTime <= 0L || this.figuredMinValueCalcTime < HeroDesigner.lastEdit) {
            this.calcFiguredMinValue();
        }
        return this.figuredMinValue;
    }

    @Override
    public double getIntIncrease() {
        if (!CharAffectingObject.checkFigured(this, 5)) {
            return 0.0;
        }
        if (this.intIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.intIncrease;
    }

    @Override
    public double getKbIncrease() {
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.kbIncrease;
    }

    @Override
    public double getMassMultiplier() {
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.massMultiplier;
    }

    public int getMaxVal() {
        return this.maxVal;
    }

    public double getMinLevels() {
        if (this.isPower()) {
            return 0.0;
        }
        double d = this.getBaseValue();
        return 0.0 - d;
    }

    @Override
    public int getMinimumLevel() {
        if (this.isPower()) {
            return 0;
        }
        return super.getMinimumLevel();
    }

    @Override
    protected void getModifierSaveXML(Element element) {
        for (int i = 0; i < this.getModifiers().size(); ++i) {
            Modifier modifier = this.getModifiers().get(i);
            element.addContent(modifier.getSaveXML());
        }
    }

    public double getNCMCharValue() {
        if (this.ncmCharValueCalcTime <= 0.0 || this.ncmCharValueCalcTime < (double)HeroDesigner.lastEdit) {
            this.calcNCMCharValue();
        }
        return this.ncmCharValue;
    }

    public int getNCMLevel() {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return HeroDesigner.getActiveHero().getRules().getCharacteristicMaxima(this.getXMLID());
        }
        Adder adder = HeroDesigner.getActiveHero().getFullNCMObject();
        if (adder == null) {
            return 9999;
        }
        String string = adder.getXMLID();
        if (adder.getSelectedOption() != null) {
            string = adder.getSelectedOption().getXMLID();
        }
        if (this.ncmLevels.get(string) == null) {
            return 9999;
        }
        Integer n = this.ncmLevels.get(string);
        return n;
    }

    @Override
    public double getPdIncrease() {
        if (!CharAffectingObject.checkFigured(this, 9)) {
            return 0.0;
        }
        if (this.pdIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.pdIncrease;
    }

    @Override
    public double getPreIncrease() {
        if (!CharAffectingObject.checkFigured(this, 7)) {
            return 0.0;
        }
        if (this.preIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.preIncrease;
    }

    public double getPrimaryValue() {
        if (this.isPower() || this.primaryValueCalcTime <= 0L || this.primaryValueCalcTime < HeroDesigner.lastEdit) {
            this.calcPrimaryValue();
        }
        return this.primaryValue;
    }

    @Override
    public double getReachIncrease() {
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.reachIncrease;
    }

    @Override
    public double getRealCostPreList() {
        double d = this.getActiveCost();
        if (!this.isPower()) {
            return d;
        }
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
            Modifier modifier = this.getAssignedModifiers().get(i);
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        if (this.getParentList() != null) {
            ArrayList<Modifier> arrayList = this.getParentList().getAssignedModifiers();
            for (int i = 0; i < arrayList.size(); ++i) {
                Modifier modifier = arrayList.get(i);
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() < 0.0 && GenericObject.findObjectByID(this.getAssignedModifiers(), modifier.getXMLID()) == null || modifier.getXMLID().equals("GENERIC_OBJECT") || modifier.getXMLID().equals("CUSTOM_MODIFIER")) && !modifier.getXMLID().equals("MODIFIER")) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        if (this.addModifiersToBase()) {
            Automaton automaton;
            Characteristic characteristic = HeroDesigner.getActiveHero().getCharacteristic(this.getType());
            double d4 = characteristic.getCharacteristicValue();
            double d5 = d4 * characteristic.getLevelCost() / characteristic.getLevelValue();
            if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && (automaton = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON")).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
                d5 *= (double)automaton.getDefenseCostMultiplier();
            }
            double d6 = d5 - d5 / (1.0 + Math.abs(d2));
            d3 = Rounder.roundHalfDown(d6);
        }
        double d7 = d / (1.0 + Math.abs(d2));
        if (bl) {
            d7 = Rounder.roundHalfDown(d7);
        }
        if (d7 == 0.0 && (d > 0.0 || this.getLevels() > 0 && this.getAssignedAdders().size() == 0 && this.getBaseCost() >= 0.0)) {
            d7 = 1.0;
        }
        d7 -= d3;
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d7 *= this.getMultiplier();
            d7 = Rounder.roundHalfDown(d7);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
            d7 *= this.getParentList().getMultiplier();
            d7 = Rounder.roundHalfDown(d7);
        }
        if (this.getQuantity() > 1) {
            int n = 0;
            for (double d8 = (double)this.getQuantity(); d8 > 1.0; d8 /= 2.0) {
                ++n;
            }
            d7 += (double)(n * 5);
        }
        return d7;
    }

    @Override
    public double getRecIncrease() {
        if (!CharAffectingObject.checkFigured(this, 12)) {
            return 0.0;
        }
        if (this.recIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.recIncrease;
    }

    public boolean showRoll() {
        return this.showRoll;
    }

    public String getRoll() {
        int n = 9;
        double d = 5.0;
        if (HeroDesigner.getActiveHero() != null) {
            n = HeroDesigner.getActiveHero().getRules().getCharRollBase();
            d = HeroDesigner.getActiveHero().getRules().getCharRollDenominator();
        }
        if (this.showRoll) {
            int n2;
            int n3 = (int)((long)n + Rounder.roundHalfUp(this.getPrimaryValue() / d));
            if (n3 != (n2 = (int)((long)n + Rounder.roundHalfUp(this.getSecondaryValue() / d)))) {
                return n3 + "- / " + n2 + "-";
            }
            return n3 + "-";
        }
        return "";
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName(this.getXMLID());
        element.setAttribute("AFFECTS_PRIMARY", this.getAffectPrimary() ? "Yes" : "No");
        element.setAttribute("AFFECTS_TOTAL", this.getAffectTotal() ? "Yes" : "No");
        if (this.isPower() && this.getUseENDReserve()) {
            element.setAttribute("USE_END_RESERVE", "Yes");
        }
        if (this.isPower()) {
            element.setAttribute("ADD_MODIFIERS_TO_BASE", this.addModifiersToBase ? "Yes" : "No");
        }
        return element;
    }

    public double getSecondaryValue() {
        if (!(this.secondaryValueCalcTime > 0L && this.secondaryValueCalcTime >= HeroDesigner.lastEdit || !this.isPower() && HeroDesigner.getActiveHero().getCharacteristic(this.getType()).hashCode() != this.hashCode())) {
            this.calcSecondaryValue();
        }
        return this.secondaryValue;
    }

    @Override
    public double getSpdIncrease() {
        if (!CharAffectingObject.checkFigured(this, 11)) {
            return 0.0;
        }
        if (this.spdIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.spdIncrease;
    }

    @Override
    public double getStrIncrease() {
        if (!CharAffectingObject.checkFigured(this, 1)) {
            return 0.0;
        }
        if (this.strIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.strIncrease;
    }

    @Override
    public double getStunIncrease() {
        if (!CharAffectingObject.checkFigured(this, 14)) {
            return 0.0;
        }
        if (this.stunIncrease == 0.0) {
            return 0.0;
        }
        if (this.getCharacteristicValue() < 0.0) {
            return 0.0;
        }
        return this.stunIncrease;
    }

    @Override
    public double getTotalCost() {
        this.enhancerApplied = null;
        double d = this.getBaseCost();
        d += (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
        if ((HeroDesigner.getActiveTemplate().is6E() && !this.isPower() || HeroDesigner.getActiveHero().isNCMSelected() && HeroDesigner.getActiveTemplate() != null && HeroDesigner.getActiveTemplate().getNcmCostMultiplier() > 0 && !this.isPower() && (this.getLevels() > 0 || this.getTrueBase() > (double)this.getNCMLevel())) && this.getNCMCharValue() > (double)this.getNCMLevel()) {
            double d2 = this.getNCMCharValue() - (double)this.getNCMLevel();
            if (d2 > (double)this.getLevels() && this.getTrueBase() < (double)this.getNCMLevel()) {
                d2 = this.getLevels();
            }
            double d3 = d2 / this.getLevelValue() * this.getLevelCost() * (double)(HeroDesigner.getActiveTemplate().getNcmCostMultiplier() - 1);
            d += d3;
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!(adder.getRealCost() > 0.0)) continue;
            d += adder.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        Object object = this.getAssignedAdders().iterator();
        while (object.hasNext()) {
            Adder adder;
            adder = object.next();
            if (!(adder.getRealCost() < 0.0)) continue;
            d += adder.getRealCost();
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(object = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d *= (double)((Automaton)object).getDefenseCostMultiplier();
        }
        return d;
    }

    public double getTrueBase() {
        return this.origBaseLevel;
    }

    @Override
    public int getType() {
        return 0;
    }

    public double getValue(boolean bl, int n) {
        double d;
        double d2 = d = bl ? this.getFiguredBaseValue(n) : this.getBaseValue();
        if (d + (double)this.getLevels() < (double)this.minimumLevel) {
            this.setLevels((int)Rounder.roundHalfDown((double)this.minimumLevel - d));
            return this.minimumLevel;
        }
        if (d + (double)this.getLevels() < (double)this.maxVal) {
            return d + (double)this.getLevels();
        }
        this.setLevels((int)Rounder.roundHalfDown((double)this.maxVal - d));
        return this.maxVal;
    }

    public String getValueDisplay() {
        if (this.getPrimaryValue() != this.getSecondaryValue()) {
            return Rounder.roundHalfUp(this.getPrimaryValue()) + "/" + Rounder.roundHalfUp(this.getSecondaryValue());
        }
        return "" + Rounder.roundHalfUp(this.getPrimaryValue());
    }

    @Override
    protected void init(Element element) {
        String string;
        this.baseCost = 0.0;
        this.baseLevel = 0.0;
        this.maxVal = 999;
        this.affectsPrimary = true;
        this.addModifiersToBase = false;
        this.ncmLevels = new Hashtable();
        this.duration = "PERSISTENT";
        super.init(element);
        this.target = "SELFONLY";
        if (!this.types.contains("STANDARD")) {
            this.types.add("STANDARD");
        }
        if ((string = XMLUtility.getValue(element, "TARGET")) != null && string.trim().length() > 0) {
            this.target = string;
        }
        if ((string = XMLUtility.getValue(element, "BASE")) != null && string.trim().length() > 0) {
            try {
                this.baseLevel = Double.parseDouble(string);
            }
            catch (Exception exception) {
                this.baseLevel = 0.0;
            }
        }
        this.origBaseLevel = this.baseLevel;
        string = XMLUtility.getValue(element, "MAXVAL");
        if (string != null && string.trim().length() > 0) {
            try {
                this.maxVal = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.maxVal = 999;
            }
        }
        this.showRoll = (string = XMLUtility.getValue(element, "SHOWROLL")) != null && string.trim().length() > 0 ? string.trim().toUpperCase().startsWith("Y") : true;
        if (HeroDesigner.getActiveTemplate() != null) {
            int n;
            Adder adder = HeroDesigner.getActiveTemplate().getNCMObject();
            if (adder != null && (string = XMLUtility.getValue(element, adder.getXMLID())) != null && string.trim().toUpperCase().length() > 0) {
                try {
                    n = Integer.parseInt(string);
                    this.ncmLevels.put(adder.getXMLID(), new Integer(n));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (adder != null && adder.getOptions() != null) {
                for (n = 0; n < adder.getOptions().size(); ++n) {
                    Adder adder2 = adder.getOptions().get(n);
                    string = XMLUtility.getValue(element, adder2.getXMLID());
                    if (string == null || string.trim().toUpperCase().length() <= 0) continue;
                    try {
                        int n2 = Integer.parseInt(string);
                        this.ncmLevels.put(adder2.getXMLID(), new Integer(n2));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public boolean isFigured() {
        for (int i = 0; i < HeroDesigner.getActiveHero().getCharacteristics().size(); ++i) {
            Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(i);
            if (!(characteristic.getIncrease(this.getType()) > 0.0) || characteristic.getIncreaseLevels(this.getType()) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPower() {
        boolean bl = super.isPower();
        if (bl) {
            return true;
        }
        if (HeroDesigner.getActiveHero() == null) {
            return bl;
        }
        bl = true;
        for (GenericObject genericObject : HeroDesigner.getActiveHero().getCharacteristics()) {
            if (genericObject.getID() != this.getID()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "AFFECTS_PRIMARY");
        if (string != null && string.trim().length() > 0) {
            this.affectsPrimary = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "AFFECTS_TOTAL")) != null && string.trim().length() > 0) {
            this.affectsTotal = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "ADD_MODIFIERS_TO_BASE")) != null && string.trim().length() > 0) {
            this.addModifiersToBase = string.trim().toUpperCase().startsWith("Y");
        }
        this.assignedModifiersCalcTime = 0L;
        this.baseValueCalcTime = 0L;
        this.figuredMinValueCalcTime = 0L;
        this.ncmCharValueCalcTime = 0.0;
        this.primaryValueCalcTime = 0L;
        this.secondaryValueCalcTime = 0L;
    }

    public void setAddModifiersToBase(boolean bl) {
        this.addModifiersToBase = bl;
    }

    @Override
    public void setLevels(int n) {
        this.levels = n;
    }

    public void setValue(double d) {
        double d2 = this.getCharacteristicValue();
        double d3 = this.getBaseValue();
        if (d == d2) {
            return;
        }
        if (d < (double)this.minimumLevel) {
            this.setLevels((int)Rounder.roundHalfDown((double)this.minimumLevel - d));
        }
        if (d < (double)this.maxVal) {
            this.setLevels((int)Rounder.roundHalfDown(d - d3));
        } else {
            this.setLevels((int)Rounder.roundHalfDown((double)this.maxVal - d));
        }
    }
}

