/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects.characteristics;

import com.hero.HeroDesigner;
import com.hero.objects.characteristics.Characteristic;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.math.BigDecimal;
import java.text.NumberFormat;
import org.jdom.Element;

public class BaseSize
extends Characteristic {
    private static String xmlID = "BASESIZE";
    private double startWidth;
    private double startLength;
    private int startDCV;

    public BaseSize(Element element) {
        super(element, xmlID);
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        this.startWidth = 0.5;
        this.startLength = 1.0;
        this.startDCV = -4;
        String string = XMLUtility.getValue(element, "STARTWIDTH");
        if (string != null && string.trim().length() > 0) {
            try {
                this.startWidth = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "STARTHEIGHT")) != null && string.trim().length() > 0) {
            try {
                this.startLength = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "STARTDCV")) != null && string.trim().length() > 0) {
            try {
                this.startDCV = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public String getRoll() {
        return "";
    }

    @Override
    public int getHeightIncreaseLevels() {
        if (super.getHeightIncreaseLevels() == 0) {
            return 1;
        }
        return super.getHeightIncreaseLevels();
    }

    @Override
    public int getWidthIncreaseLevels() {
        if (super.getWidthIncreaseLevels() == 0) {
            return 1;
        }
        return super.getWidthIncreaseLevels();
    }

    @Override
    public String getDisplayNotes() {
        int n;
        int n2;
        int n3;
        double d = this.startLength;
        if (this.getLevels() != 0) {
            d *= Math.pow(this.getHeightIncrease(), (double)this.getLevels() / (double)this.getHeightIncreaseLevels());
        }
        double d2 = this.startWidth;
        if (this.getLevels() != 0) {
            d2 *= Math.pow(this.getWidthIncrease(), (double)this.getLevels() / (double)this.getWidthIncreaseLevels());
        }
        double d3 = d * d2;
        double d4 = d * d2 * d2;
        long l = 100L;
        if (this.getLevels() != 0) {
            n3 = this.getLevels() / this.getMassMultiplierLevels();
            n2 = (int)Rounder.roundHalfUp(Math.pow(this.getMassMultiplier(), n3));
            n = (int)Rounder.roundHalfUp(Math.pow(this.getMassMultiplier(), n3 + 1));
            int n4 = n - n2;
            l *= (long)((double)Rounder.roundHalfUp(Math.pow(this.getMassMultiplier(), n3)) + (double)n4 * (double)this.getLevels() % (double)this.getMassMultiplierLevels() / (double)this.getMassMultiplierLevels());
        }
        n3 = this.startDCV;
        int n5 = n2 = this.getDcvIncrease() < 0.0 ? -1 : 1;
        if (this.getDcvIncreaseLevels() != 0) {
            n3 += n2 * (int)Rounder.roundDown(Math.abs(this.getDcvIncrease()) * (double)this.getLevels() / (double)this.getDcvIncreaseLevels());
        }
        n = Math.abs(n3);
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(2, 4);
        BigDecimal bigDecimal2 = new BigDecimal(d2);
        bigDecimal2 = bigDecimal2.setScale(2, 4);
        BigDecimal bigDecimal3 = new BigDecimal(d3);
        bigDecimal3 = bigDecimal3.setScale(2, 4);
        BigDecimal bigDecimal4 = new BigDecimal(d4);
        bigDecimal4 = bigDecimal4.setScale(2, 4);
        NumberFormat numberFormat = NumberFormat.getInstance();
        String string = "Length " + numberFormat.format(bigDecimal.doubleValue()) + "\",  Width " + numberFormat.format(bigDecimal2.doubleValue()) + "\",   Area " + numberFormat.format(bigDecimal3.doubleValue()) + "\"   DCV " + n3;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            string = "Length " + numberFormat.format(bigDecimal.doubleValue()) + "m,  Width " + numberFormat.format(bigDecimal2.doubleValue()) + "m,  Height " + numberFormat.format(bigDecimal2.doubleValue()) + "m,  Volume " + numberFormat.format(bigDecimal4.doubleValue()) + "m^3   OCV +" + n;
        }
        return string;
    }
}

