/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.modifiers.Linked;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.CompoundPower;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.VPPDialog;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jdom.Element;

public class VariablePowerPool
extends List {
    protected String xmlID = "VPP";

    public VariablePowerPool(Element element) {
        super(element);
        if (HeroDesigner.getActiveTemplate().is6E()) {
            this.levelValue = 1.0;
            this.levelCost = 1.0;
            Adder adder = (Adder)VariablePowerPool.findObjectByID(this.getAvailableAdders(), "CONTROLCOST");
            if (adder == null) {
                Adder adder2 = new Adder();
                adder2.setDisplay("Control Cost");
                adder2.setXMLID("CONTROLCOST");
                adder2.setBaseCost(0.0);
                adder2.setDisplayInString(false);
                adder2.setExclusive(true);
                adder2.setLevelCost(1.0);
                adder2.setLevelValue(2.0);
                adder2.setMinimumLevel(0);
                adder2.setMaxLevel(99999);
                adder2.setRequired(true);
                adder2.setSelected(true);
                this.getAssignedAdders().add(adder2);
                this.getAvailableAdders().add(adder2);
            } else {
                adder.setRequired(true);
            }
        }
    }

    public VariablePowerPool(String string) {
        super(string);
        this.name = "";
        this.baseCost = 0.0;
        this.minimumCost = 1.0;
        this.maxCost = 9999.0;
        this.levels = 10;
        this.minimumLevel = 1;
        this.minSet = true;
        this.maxSet = false;
        this.types = new ArrayList();
        this.types.add("VPP");
        this.userInput = true;
        this.otherInputAllowed = true;
        this.setOptions(new ArrayList<Adder>());
        this.inputLabel = "Type";
        this.allowsOtherModifiers = true;
        this.allowsOtherAdders = true;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            this.levelValue = 1.0;
            this.levelCost = 1.0;
            Adder adder = (Adder)VariablePowerPool.findObjectByID(this.getAssignedAdders(), "CONTROLCOST");
            if (adder == null) {
                Adder adder2 = new Adder();
                adder2.setDisplay("Control Cost");
                adder2.setXMLID("CONTROLCOST");
                adder2.setBaseCost(0.0);
                adder2.setDisplayInString(false);
                adder2.setExclusive(true);
                adder2.setLevelCost(1.0);
                adder2.setLevelValue(2.0);
                adder2.setMinimumLevel(0);
                adder2.setMaxLevel(99999);
                adder2.setRequired(true);
                adder2.setSelected(true);
                this.getAssignedAdders().add(adder2);
                this.getAvailableAdders().add(adder2);
            }
        }
        this.resetID();
    }

    @Override
    public double getActiveCost() {
        Modifier modifier;
        int n;
        Adder adder;
        double d = this.getTotalCost();
        double d2 = 0.0;
        if (this.getLevelValue() != 0.0) {
            d2 = (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
        }
        double d3 = d2 / 2.0;
        if (HeroDesigner.getActiveTemplate().is6E() && (adder = (Adder)VariablePowerPool.findObjectByID(this.getAssignedAdders(), "CONTROLCOST")) != null) {
            d3 = adder.getTotalCost();
        }
        double d4 = 0.0;
        boolean bl = false;
        for (n = 0; n < this.assignedModifiers.size(); ++n) {
            modifier = (Modifier)this.assignedModifiers.get(n);
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d4 += modifier.getTotalValue();
            bl = true;
        }
        for (n = 0; n < this.getPrivateMods().size(); ++n) {
            modifier = this.getPrivateMods().get(n);
            if (modifier.isLimitation() || !(modifier.getTotalValue() > 0.0)) continue;
            d4 += modifier.getTotalValue();
            bl = true;
        }
        double d5 = (d - d2) * (1.0 + d4);
        d5 += d2;
        if (bl) {
            d5 = Rounder.roundHalfDown(d5);
        }
        return d5;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        if (this.getName() != null && this.getName().trim().length() > 0) {
            string = "<i>" + this.getName() + ":</i>  " + string;
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            string = string + " (" + this.getInput() + ")";
        }
        Adder adder = (Adder)VariablePowerPool.findObjectByID(this.getAssignedAdders(), "CONTROLCOST");
        long l = 0L;
        if (adder != null) {
            l = adder.getLevels();
        } else {
            double d = 0.0;
            if (this.getLevelValue() != 0.0) {
                d = (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
            }
            l = Rounder.roundHalfDown(d / 2.0);
        }
        string = string + ", " + this.getLevels() + " base + " + l + " control cost";
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + "; " + string2;
        }
        string = string + this.getModifierString();
        return string;
    }

    @Override
    public String getColumn2Prefix(GenericObject genericObject) {
        this.updateChildPositions();
        int n = this.getObjects().indexOf(genericObject);
        return ++n + ") ";
    }

    @Override
    public String getColumn2Suffix(GenericObject genericObject) {
        return " Real Cost: " + Rounder.roundHalfDown(genericObject.getRealCostPreList());
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        VPPDialog vPPDialog = new VPPDialog(this, bl, bl2);
        return vPPDialog;
    }

    @Override
    public String getDisplay() {
        return "Variable Power Pool";
    }

    @Override
    public ArrayList<String> getExamples() {
        this.examples = new ArrayList();
        this.examples.add("Gadget Pool");
        this.examples.add("Magic Pool");
        this.examples.add("Mimicry Pool");
        return this.examples;
    }

    @Override
    public double getLevelCost() {
        return 1.0;
    }

    @Override
    public double getLevelValue() {
        return 1.0;
    }

    @Override
    public double getRealCostForChild(GenericObject genericObject) {
        return 0.0;
    }

    @Override
    public double getRealCostPreList() {
        Modifier modifier;
        int n;
        double d = this.getActiveCost();
        double d2 = 0.0;
        if (this.getLevelValue() != 0.0) {
            d2 = (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
        }
        double d3 = d2 / 2.0;
        boolean bl = false;
        double d4 = 0.0;
        for (n = 0; n < this.assignedModifiers.size(); ++n) {
            modifier = (Modifier)this.assignedModifiers.get(n);
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d4 += modifier.getTotalValue();
            bl = true;
        }
        for (n = 0; n < this.getPrivateMods().size(); ++n) {
            modifier = this.getPrivateMods().get(n);
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d4 += modifier.getTotalValue();
            bl = true;
        }
        double d5 = (d - d2) / (1.0 + Math.abs(d4));
        d5 += d2;
        if (bl) {
            d5 = Rounder.roundHalfDown(d5);
        }
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        if (d5 < 1.0 && d > 0.0) {
            d5 = 1.0;
        }
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d5 *= this.getMultiplier();
            d5 = Rounder.roundHalfDown(d5);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getParentList() != null && this.getParentList().getMultiplier() != 1.0) {
            d5 *= this.getParentList().getMultiplier();
            d5 = Rounder.roundHalfDown(d5);
        }
        if (this.getQuantity() > 1) {
            int n2 = 0;
            for (double d6 = (double)this.getQuantity(); d6 > 1.0; d6 /= 2.0) {
                ++n2;
            }
            d5 += (double)(n2 * 5);
        }
        return d5;
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("VPP");
        element.setAttribute("QUANTITY", this.getQuantity() + "");
        return element;
    }

    @Override
    public double getTotalCost() {
        double d = 0.0;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            Adder adder;
            int n;
            if (this.getLevelValue() != 0.0) {
                double d2 = (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
                d += (double)Rounder.roundHalfDown(d2);
                Adder adder2 = (Adder)VariablePowerPool.findObjectByID(this.getAssignedAdders(), "CONTROLCOST");
                if (adder2 != null) {
                    d += adder2.getTotalCost();
                }
            }
            for (n = 0; n < this.getAssignedAdders().size(); ++n) {
                adder = this.getAssignedAdders().get(n);
                if (adder.isRequired()) continue;
                d += adder.getTotalCost();
            }
            for (n = 0; n < this.getPrivateAdders().size(); ++n) {
                adder = this.getPrivateAdders().get(n);
                if (adder.isRequired()) continue;
                d += adder.getTotalCost();
            }
        } else {
            Adder adder;
            int n;
            if (this.getLevelValue() != 0.0) {
                double d3 = (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
                d += (double)Rounder.roundHalfDown(d3);
                d += (double)Rounder.roundHalfDown(d3 / 2.0);
            }
            for (n = 0; n < this.getAssignedAdders().size() && this.getPrivateAdders().size() == 0; ++n) {
                adder = this.getAssignedAdders().get(n);
                d += adder.getTotalCost();
            }
            for (n = 0; n < this.getPrivateAdders().size(); ++n) {
                adder = this.getPrivateAdders().get(n);
                d += adder.getTotalCost();
            }
        }
        return d;
    }

    @Override
    public void init(Element element) {
        super.init(element);
        this.baseCost = 0.0;
        this.minimumCost = 1.0;
        this.maxCost = 999.0;
        this.levels = 10;
        this.minimumLevel = 1;
        this.minSet = true;
        this.maxCost = 999.0;
        this.maxSet = false;
        this.types = new ArrayList();
        this.types.add("VPP");
        this.userInput = true;
        this.otherInputAllowed = true;
        this.setOptions(new ArrayList<Adder>());
        this.inputLabel = "Type";
        this.abbreviation = "VPP";
    }

    @Override
    public boolean objectAllowed(GenericObject genericObject, boolean bl) {
        Object object;
        Object object2;
        Cloneable cloneable;
        GenericObject genericObject2;
        boolean bl2 = true;
        if (this.getAlias().trim().length() == 0) {
            this.error = "";
            return false;
        }
        if (genericObject instanceof CompoundPower) {
            genericObject2 = (CompoundPower)genericObject;
            for (int i = 0; i < genericObject2.getPowers().size(); ++i) {
                cloneable = genericObject2.getPowers().get(i);
                boolean bl3 = this.objectAllowed((GenericObject)cloneable, bl);
                if (bl3) continue;
                return bl3;
            }
        }
        if (!genericObject.allowsOtherModifiers() && this.getAssignedModifiers().size() > 0) {
            this.error = genericObject.getAlias() + " is not allowed to have Modifiers assigned to it in its current configuration.\n\n" + genericObject.getAlias() + " will be placed outside of the list.";
            return false;
        }
        if (genericObject instanceof List) {
            this.error = "You cannot add a List into a VPP.  New list will be placed outside of selection.";
            return false;
        }
        if (genericObject instanceof VariablePowerPool) {
            this.error = "You cannot add a VPP into another VPP.  The Variable Power Pool will be placed outside of the selection.";
            return false;
        }
        if (this.getAssignedModifiers().size() > 0 && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
            Modifier modifier;
            int n;
            genericObject2 = genericObject.getParentList();
            genericObject.setParent(null);
            ArrayList<Modifier> arrayList = this.getAssignedModifiers();
            cloneable = genericObject.getAssignedModifiers();
            ArrayList arrayList2 = (ArrayList)((ArrayList)cloneable).clone();
            ArrayList<Modifier> arrayList3 = new ArrayList<Modifier>();
            for (n = 0; n < arrayList.size(); ++n) {
                modifier = arrayList.get(n);
                if (GenericObject.findObjectByID((ArrayList<? extends GenericObject>)cloneable, modifier.getXMLID()) != null) continue;
                arrayList3.add(modifier);
            }
            arrayList2.addAll(arrayList3);
            genericObject.setAssignedModifiers(arrayList2);
            for (n = arrayList3.size() - 1; n >= 0; --n) {
                modifier = (Modifier)arrayList3.get(n);
                arrayList2.remove(modifier);
                genericObject.setAssignedModifiers(arrayList2);
                String string = modifier.included(genericObject);
                if (string.trim().length() > 0) {
                    this.error = modifier.getAlias() + " cannot be applied to " + genericObject.getAlias() + ".\n\nReason:  " + string + "\n\n" + genericObject.getAlias() + " will be placed outside of the VPP.";
                    bl2 = false;
                    break;
                }
                arrayList2.add(modifier);
            }
            genericObject.setAssignedModifiers((ArrayList<Modifier>)cloneable);
            genericObject.setParent((List)genericObject2);
        }
        long l = this.getLevels();
        if (HeroDesigner.getActiveTemplate().is6E()) {
            cloneable = (Adder)VariablePowerPool.findObjectByID(this.getAssignedAdders(), "CONTROLCOST");
            long l2 = 0L;
            l2 = cloneable != null ? (long)((GenericObject)cloneable).getLevels() : Rounder.roundHalfDown(this.getRealCost() - (double)this.getLevels());
            l = l2;
        }
        long l3 = 0L;
        double d = 1.0;
        double d2 = 1.0;
        for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
            object2 = this.getAssignedModifiers().get(i);
            if (((GenericObject)object2).getTypes().contains("VPP")) continue;
            if (((Modifier)object2).getTotalValue() > 0.0) {
                d += ((Modifier)object2).getTotalValue();
                continue;
            }
            d2 += -1.0 * ((Modifier)object2).getTotalValue();
        }
        l3 = l = Rounder.roundHalfDown((double)l * d);
        List list = genericObject.getParentList();
        genericObject.setParent(this);
        if (genericObject.getRealCostPreList() > (double)this.getLevels()) {
            this.error = "Real Cost for " + genericObject.getAlias() + " exceeds the available points in the VPP.  Item will be placed outside of the Pool's sample powers list.";
            genericObject.setParent(list);
            return false;
        }
        if (genericObject.getActiveCost() > (double)l3) {
            this.error = "The Active Cost of " + genericObject.getAlias() + " exceeds the Pool Cost of the VPP.  " + genericObject.getAlias() + " will be placed outside of this VPP.";
            if (HeroDesigner.getActiveTemplate().is6E()) {
                this.error = "The Active Cost of " + genericObject.getAlias() + " exceeds the Control Cost of the VPP.  " + genericObject.getAlias() + " will be placed outside of this VPP.";
            }
            genericObject.setParent(list);
            bl2 = false;
        } else if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "LINKED") != null && HeroDesigner.getActiveHero().getRules().getLinkAcrossFramework() > 0) {
            genericObject.setParent(list);
            object2 = (Linked)GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "LINKED");
            object = ((Linked)object2).getValue();
            if (object != null && ((GenericObject)object).getParentList() != null && (genericObject.getMainPower() == null || ((GenericObject)object).getMainPower() == null || !genericObject.getMainPower().equals(((GenericObject)object).getMainPower())) && (((GenericObject)object).getParentList() instanceof Multipower || ((GenericObject)object).getParentList() instanceof ElementalControl || ((GenericObject)object).getParentList() instanceof VariablePowerPool)) {
                if (HeroDesigner.getActiveHero().getRules().getLinkAcrossFramework() == 2) {
                    this.error = "You cannot Link two different slots of a Power Framework";
                    bl2 = false;
                } else {
                    String string = "Warning!  You should not Link two different slots of a Power Framework.  Use a Compound Power instead.";
                    if (bl) {
                        PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), string, true);
                        popupMessage.setVisible(true);
                        bl = false;
                    }
                }
            }
        }
        if (!bl2) {
            genericObject.setParent(list);
            return bl2;
        }
        genericObject.setParent(list);
        if (genericObject.getTypes().contains("SPECIAL") && HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() > 0) {
            object2 = "Warning!  " + genericObject.getDisplay() + " should not be placed in an Variable Power Pool (or any other Power Framework).";
            if (bl && HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() == 1) {
                object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), (String)object2, true);
                ((PopupMessage)object).setVisible(true);
            } else if (HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() == 2) {
                this.error = object2;
                return false;
            }
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void restoreFromSave(Element element) {
        if (VariablePowerPool.findObjectByID(this.getAssignedAdders(), "CONTROLCOST") != null) {
            this.getAssignedAdders().remove(VariablePowerPool.findObjectByID(this.getAssignedAdders(), "CONTROLCOST"));
        }
        super.restoreFromSave(element);
        Object object = this.getAssignedAdders().iterator();
        while (object.hasNext()) {
            Adder adder = object.next();
            System.out.println("FOUND " + adder.getXMLID() + ", levels = " + adder.getLevels() + ", basecost = " + adder.getBaseCost() + ", total cost = " + adder.getTotalCost());
        }
        if (!HeroDesigner.getActiveTemplate().is6E()) {
            this.availableModifiers = new ArrayList();
        }
        if ((object = XMLUtility.getValue(element, "QUANTITY")) != null && ((String)object).trim().length() > 0) {
            try {
                this.quantity = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                this.quantity = 1;
            }
        } else {
            this.quantity = 1;
        }
    }
}

