/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects;

import com.hero.HeroDesigner;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.modifiers.Linked;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.CompoundPower;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.MultipowerDialog;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jdom.Element;

public class Multipower
extends List {
    private String error;

    public Multipower(Element element) {
        super(element);
        this.minimumCost = 1.0;
        this.maxCost = 9999.0;
        this.minSet = true;
        this.maxSet = true;
    }

    public Multipower(Element element, String string) {
        super(element, string);
        this.minimumCost = 1.0;
        this.maxCost = 9999.0;
        this.minSet = true;
        this.maxSet = true;
    }

    public Multipower(String string) {
        super(string);
        this.minimumCost = 1.0;
        this.baseCost = 5.0;
        this.maxCost = 9999.0;
        this.minSet = true;
        this.maxSet = true;
    }

    @Override
    public String getColumn1Suffix(GenericObject genericObject) {
        this.updateChildPositions();
        if (HeroDesigner.getActiveTemplate().is6E()) {
            if (genericObject.isUltra()) {
                return "f";
            }
            return "v";
        }
        if (genericObject.isUltra()) {
            return "u";
        }
        return "m";
    }

    @Override
    public String getColumn2Output() {
        String string = "";
        if (this.getName().trim().length() > 0) {
            string = string + "<i>" + this.getName() + ":</i>  ";
        }
        string = string + this.getAlias() + ", " + (int)this.getBaseCost() + "-point reserve";
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + ", " + string2;
        }
        String string3 = this.getModifierString();
        string = string + string3;
        return string;
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new MultipowerDialog(this, bl);
    }

    @Override
    public double getRealCostForChild(GenericObject genericObject) {
        double d = super.getRealCostForChild(genericObject);
        boolean bl = true;
        if (d == 0.0 || d < 0.0) {
            bl = false;
        }
        d = genericObject.isUltra() ? (d /= 10.0) : (d /= 5.0);
        d = Rounder.roundHalfDown(d);
        if (bl && d < 1.0) {
            d = 1.0;
        }
        return d;
    }

    @Override
    public String getRejectionMessage() {
        if (this.error == null) {
            return "You cannot add a List into a Multipower.  New list will be placed outside of Multipower.";
        }
        return this.error;
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("MULTIPOWER");
        element.setAttribute("QUANTITY", this.getQuantity() + "");
        return element;
    }

    @Override
    public void init(Element element) {
        super.init(element);
        this.abbreviation = "MP";
    }

    @Override
    public boolean objectAllowed(GenericObject genericObject, boolean bl) {
        GenericObject genericObject2;
        Object object;
        Object object2;
        boolean bl2 = true;
        genericObject = genericObject.clone();
        genericObject.setMainPower(null);
        List list = genericObject.getParentList();
        genericObject.setParent(this);
        if (genericObject instanceof CompoundPower) {
            genericObject.setParent(null);
            object2 = (CompoundPower)genericObject;
            for (int i = 0; i < ((CompoundPower)object2).getPowers().size(); ++i) {
                object = ((CompoundPower)object2).getPowers().get(i);
                boolean bl3 = this.objectAllowed((GenericObject)object, bl);
                if (bl3) continue;
                genericObject.setParent(list);
                return bl3;
            }
            if (genericObject.getActiveCost() > this.getBaseCost()) {
                this.error = "The Active Cost of " + genericObject.getAlias() + " exceeds the Base Cost of the Multipower.  " + genericObject.getAlias() + " will be placed outside of this Multipower.";
                genericObject.setParent(list);
                return false;
            }
            if (((CompoundPower)object2).getPowers().size() > 0) {
                genericObject.setParent(list);
                return true;
            }
        }
        if (!genericObject.allowsOtherModifiers() && this.getAssignedModifiers().size() > 0) {
            this.error = genericObject.getAlias() + " is not allowed to have Modifiers assigned to it in its current configuration.\n\n" + genericObject.getAlias() + " will be placed outside of the list.";
            return false;
        }
        if (genericObject instanceof List) {
            this.error = "You cannot add a List into a Multipower.  New list will be placed outside of Multipower.";
            bl2 = false;
        } else if (genericObject instanceof VariablePowerPool) {
            this.error = "You cannot add a VPP into a Multipower.  The Variable Power Pool will be placed outside of Multipower.";
            bl2 = false;
        } else if (genericObject.getActiveCost() > this.getBaseCost()) {
            this.error = "The Active Cost of " + genericObject.getAlias() + " exceeds the Base Cost of the Multipower.  " + genericObject.getAlias() + " will be placed outside of this Multipower.";
            bl2 = false;
        } else if (this.getAssignedModifiers().size() > 0 && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
            Modifier modifier;
            int n;
            object2 = genericObject.getParentList();
            genericObject.setParent(null);
            ArrayList<Modifier> arrayList = this.getAssignedModifiers();
            object = genericObject.getAssignedModifiers();
            ArrayList arrayList2 = (ArrayList)((ArrayList)object).clone();
            ArrayList<Modifier> arrayList3 = new ArrayList<Modifier>();
            for (n = 0; n < arrayList.size(); ++n) {
                modifier = arrayList.get(n);
                if (GenericObject.findObjectByID((ArrayList<? extends GenericObject>)object, modifier.getXMLID()) != null) continue;
                arrayList3.add(modifier);
            }
            arrayList2.addAll(arrayList3);
            genericObject.setAssignedModifiers(arrayList2);
            for (n = arrayList3.size() - 1; n >= 0; --n) {
                modifier = (Modifier)arrayList3.get(n);
                arrayList2.remove(modifier);
                genericObject.setAssignedModifiers(arrayList2);
                String string = modifier.included(genericObject);
                if (string.trim().length() > 0) {
                    this.error = modifier.getAlias() + " cannot be applied to " + genericObject.getAlias() + ".\n\nReason:  " + string + "\n\n" + genericObject.getAlias() + " will be placed outside of the Multipower.";
                    bl2 = false;
                    break;
                }
                arrayList2.add(modifier);
                genericObject.setAssignedModifiers(arrayList2);
            }
            genericObject.setAssignedModifiers((ArrayList<Modifier>)object);
            genericObject.setParent((List)object2);
        }
        if (!bl2) {
            genericObject.setParent(list);
            return bl2;
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "LINKED") != null && HeroDesigner.getActiveHero().getRules().getLinkAcrossFramework() > 0 && (genericObject2 = ((Linked)(object2 = (Linked)GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "LINKED"))).getValue()) != null && genericObject2.getParentList() != null && (genericObject.getMainPower() == null || genericObject2.getMainPower() == null || !genericObject.getMainPower().equals(genericObject2.getMainPower())) && (genericObject2.getParentList() instanceof Multipower || genericObject2.getParentList() instanceof ElementalControl || genericObject2.getParentList() instanceof VariablePowerPool)) {
            if (HeroDesigner.getActiveHero().getRules().getLinkAcrossFramework() == 2) {
                this.error = "You cannot Link two different slots of a Power Framework";
                bl2 = false;
            } else {
                object = "Warning!  You should not Link two different slots of a Power Framework.  Use a Compound Power instead.";
                if (bl) {
                    PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), (String)object, true);
                    popupMessage.setVisible(true);
                    bl = false;
                }
            }
        }
        if (!bl2) {
            return bl2;
        }
        if (genericObject.getTypes().contains("SPECIAL") && HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() > 0) {
            object2 = "Warning!  " + genericObject.getDisplay() + " should not be placed in an Multipower (or any other Power Framework).";
            if (bl && HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() == 1) {
                PopupMessage popupMessage = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), (String)object2, true);
                popupMessage.setVisible(true);
            } else if (HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() == 2) {
                this.error = object2;
                return false;
            }
            bl2 = true;
        }
        genericObject.setParent(list);
        return bl2;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "QUANTITY");
        if (string != null && string.trim().length() > 0) {
            try {
                this.quantity = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.quantity = 1;
            }
        } else {
            this.quantity = 1;
        }
    }
}

