/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.CompoundPower;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.ListDialog;
import com.hero.util.Rounder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jdom.Element;

public class List
extends GenericObject {
    protected ArrayList<GenericObject> containedObjects;
    private ArrayList<Modifier> privateMods;
    private ArrayList<Adder> privateAdders;
    private int objectSizeCheck = -1;
    protected String error;

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        this.separatePrivateMods();
        this.separatePrivateAdders();
    }

    private void separatePrivateMods() {
        for (int i = this.getAssignedModifiers().size() - 1; i >= 0; --i) {
            Modifier modifier = this.getAssignedModifiers().get(i);
            if (!modifier.isPrivate()) continue;
            this.getAssignedModifiers().remove(i);
            this.getPrivateMods().add(modifier);
        }
    }

    private void separatePrivateAdders() {
        for (int i = this.getAssignedAdders().size() - 1; i >= 0; --i) {
            Adder adder = this.getAssignedAdders().get(i);
            if (!adder.isPrivate()) continue;
            this.getAssignedAdders().remove(i);
            this.getPrivateAdders().add(adder);
        }
    }

    public List(Element element, String string) {
        super(element, string);
    }

    public List(Element element) {
        super(element);
    }

    public List(String string) {
        this.containedObjects = new ArrayList();
        this.init(new Element("LIST"));
        this.display = string;
        this.alias = string;
        this.resetID();
    }

    @Override
    protected void init(Element element) {
        this.containedObjects = new ArrayList();
        this.duration = "";
        super.init(element);
        this.availableModifiers = new ArrayList();
        this.availableAdders = new ArrayList();
    }

    @Override
    public List clone() {
        List list = (List)super.clone();
        list.containedObjects = (ArrayList)this.containedObjects.clone();
        if (this.privateMods == null) {
            this.privateMods = new ArrayList();
        }
        list.privateMods = new ArrayList();
        if (this.privateAdders == null) {
            this.privateAdders = new ArrayList();
        }
        list.privateAdders = new ArrayList();
        for (Modifier modifier : this.privateMods) {
            Modifier genericObject = modifier.clone();
            list.privateMods.add(genericObject);
        }
        for (Adder adder : this.privateAdders) {
            Adder adder2 = adder.clone();
            list.privateAdders.add(adder);
        }
        return list;
    }

    public void addObject(GenericObject genericObject) {
        for (int i = 0; i < this.containedObjects.size() && genericObject.getID() > 1L; ++i) {
            if (this.containedObjects.get(i).getID() != genericObject.getID()) continue;
            this.containedObjects.set(i, genericObject);
            return;
        }
        this.containedObjects.add(genericObject);
    }

    public ArrayList<GenericObject> getObjects() {
        if (this.containedObjects != null && this.containedObjects.size() != this.objectSizeCheck) {
            this.cleanupObjects();
            this.objectSizeCheck = this.containedObjects.size();
        }
        return this.containedObjects;
    }

    private void cleanupObjects() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = this.containedObjects.size() - 1; i >= 0; --i) {
            if (arrayList.contains(this.containedObjects.get(i).getID())) {
                this.containedObjects.remove(i);
                continue;
            }
            arrayList.add(this.containedObjects.get(i).getID());
        }
    }

    public void remove(GenericObject genericObject) {
        for (int i = this.containedObjects.size() - 1; i >= 0; --i) {
            GenericObject genericObject2 = this.containedObjects.get(i);
            if (genericObject2.getID() != genericObject.getID()) continue;
            this.containedObjects.remove(i);
        }
        this.updateChildPositions();
    }

    public void setObjects(ArrayList<GenericObject> arrayList) {
        this.containedObjects = arrayList;
    }

    public void removeObject(int n) {
        this.updateChildPositions();
        this.containedObjects.remove(n);
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("LIST");
        return element;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAlias();
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + ", " + string2;
        }
        String string3 = this.getModifierString();
        string = string + string3;
        return string;
    }

    public double getRealCostForChild(GenericObject genericObject) {
        ArrayList<Adder> arrayList = genericObject.getAssignedAdders();
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        arrayList2.addAll(this.getAssignedAdders());
        genericObject.setAssignedAdders(arrayList2);
        double d = genericObject.getRealCostPreList();
        genericObject.setAssignedAdders(arrayList);
        return d;
    }

    public String getColumn2Prefix(GenericObject genericObject) {
        String string = "";
        this.updateChildPositions();
        int n = genericObject.getPosition() - this.getPosition();
        string = n < 10 ? n + ")  " : n + ") ";
        return string;
    }

    public String getColumn2Suffix(GenericObject genericObject) {
        return "";
    }

    public String getColumn1Suffix(GenericObject genericObject) {
        return "";
    }

    public void updateChildPositions() {
        for (int i = this.getObjects().size() - 1; i >= 0; --i) {
            if (this.getObjects().get(i) != null) continue;
            this.getObjects().remove(i);
        }
        Collections.sort(this.getObjects(), new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof GenericObject && object2 instanceof GenericObject) {
                    GenericObject genericObject = (GenericObject)object;
                    GenericObject genericObject2 = (GenericObject)object2;
                    return genericObject.getPosition() - genericObject2.getPosition();
                }
                return object.toString().compareTo(object2.toString());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new ListDialog(this, bl);
    }

    public boolean objectAllowed(GenericObject genericObject) {
        return this.objectAllowed(genericObject, true);
    }

    public boolean objectAllowed(GenericObject genericObject, boolean bl) {
        Cloneable cloneable;
        GenericObject genericObject2;
        if (this.getAlias().trim().length() == 0) {
            this.error = "";
            return false;
        }
        if (genericObject instanceof CompoundPower) {
            genericObject2 = (CompoundPower)genericObject;
            for (int i = 0; i < genericObject2.getPowers().size(); ++i) {
                cloneable = genericObject2.getPowers().get(i).clone();
                ((GenericObject)cloneable).setMainPower(null);
                boolean bl2 = this.objectAllowed((GenericObject)cloneable, bl);
                if (bl2) continue;
                return bl2;
            }
            if (genericObject2.getPowers().size() > 0) {
                return true;
            }
        }
        if (!genericObject.allowsOtherModifiers() && this.getAssignedModifiers().size() > 0) {
            this.error = genericObject.getAlias() + " is not allowed to have Modifiers assigned to it in its current configuration.\n\n" + genericObject.getAlias() + " will be placed outside of the list.";
            return false;
        }
        if (genericObject instanceof List) {
            this.error = "You cannot add a List into another List.  New list will be placed outside of selection.";
            return false;
        }
        if (genericObject instanceof VariablePowerPool) {
            this.error = "You cannot add a VPP into a List.  The Variable Power Pool will be placed outside of the selection.";
            return false;
        }
        if (this.getAssignedModifiers().size() > 0 && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
            Modifier modifier;
            int n;
            genericObject2 = genericObject.getParentList();
            genericObject.setParent(null);
            genericObject.setListModCheck(true);
            ArrayList<Modifier> arrayList = this.getAssignedModifiers();
            cloneable = genericObject.getAssignedModifiers();
            ArrayList arrayList2 = (ArrayList)((ArrayList)cloneable).clone();
            ArrayList<Modifier> arrayList3 = new ArrayList<Modifier>();
            for (n = 0; n < arrayList.size(); ++n) {
                modifier = arrayList.get(n);
                if (GenericObject.findObjectByID((ArrayList<? extends GenericObject>)cloneable, modifier.getXMLID()) != null) continue;
                arrayList3.add(modifier);
            }
            arrayList2.addAll(arrayList3);
            genericObject.setAssignedModifiers(arrayList2);
            for (n = arrayList3.size() - 1; n >= 0; --n) {
                modifier = (Modifier)arrayList3.get(n);
                arrayList2.remove(modifier);
                genericObject.setAssignedModifiers(arrayList2);
                String string = modifier.included(genericObject);
                if (string.trim().length() > 0) {
                    genericObject.setListModCheck(false);
                    this.error = modifier.getAlias() + " cannot be applied to " + genericObject.getAlias() + ".\n\nReason:  " + string + "\n\n" + genericObject.getAlias() + " will be placed outside of the list.";
                    return false;
                }
                arrayList2.add(modifier);
            }
            genericObject.setAssignedModifiers((ArrayList<Modifier>)cloneable);
            genericObject.setListModCheck(false);
            genericObject.setParent((List)genericObject2);
        }
        return true;
    }

    public String getRejectionMessage() {
        if (this.error == null) {
            return "You cannot add a List into another List.  New list will be placed outside of selection.";
        }
        return this.error;
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = "";
        }
        if (string.trim().length() > 0) {
            string = string + ":  ";
        }
        string = string + this.getAlias();
        return string;
    }

    @Override
    public String getColumn3Output() {
        return "";
    }

    public ArrayList<Modifier> getPrivateMods() {
        if (this.privateMods == null) {
            this.privateMods = new ArrayList();
        }
        return this.privateMods;
    }

    public ArrayList<Adder> getPrivateAdders() {
        if (this.privateAdders == null) {
            this.privateAdders = new ArrayList();
        }
        return this.privateAdders;
    }

    public void setPrivateAdders(ArrayList<Adder> arrayList) {
        this.privateAdders = arrayList;
    }

    public void setPrivateMods(ArrayList<Modifier> arrayList) {
        this.privateMods = arrayList;
    }

    @Override
    protected void getModifierSaveXML(Element element) {
        Modifier modifier;
        int n;
        for (n = 0; n < this.getModifiers().size(); ++n) {
            modifier = this.getModifiers().get(n);
            element.addContent(modifier.getSaveXML());
        }
        for (n = 0; n < this.getPrivateMods().size(); ++n) {
            modifier = this.getPrivateMods().get(n);
            element.addContent(modifier.getSaveXML());
        }
    }

    @Override
    protected void getAdderSaveXML(Element element) {
        super.getAdderSaveXML(element);
        for (Adder adder : this.getPrivateAdders()) {
            if (!adder.isSelected()) continue;
            element.addContent(adder.getSaveXML());
        }
    }

    @Override
    public String getModifierString() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        ArrayList arrayList = (ArrayList)this.assignedModifiers.clone();
        ArrayList arrayList2 = (ArrayList)this.getPrivateMods().clone();
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof Modifier && object2 instanceof Modifier) {
                    Modifier modifier = (Modifier)object;
                    Modifier modifier2 = (Modifier)object2;
                    return (int)((modifier.getTotalValue() - modifier2.getTotalValue()) * 100.0);
                }
                return -1;
            }
        };
        Collections.sort(arrayList, comparator);
        Collections.sort(arrayList2, comparator);
        for (Modifier modifier : arrayList) {
            if (modifier.getTotalValue() >= 0.0) {
                if (string.trim().length() > 0) {
                    string = string + ", ";
                }
                string = string + modifier.getColumn2Output();
            }
            if (!(modifier.getTotalValue() < 0.0)) continue;
            if (string3.trim().length() > 0) {
                string3 = string3 + ", ";
            }
            string3 = string3 + modifier.getColumn2Output();
        }
        for (Modifier modifier : arrayList2) {
            if (modifier.getTotalValue() >= 0.0) {
                if (string2.trim().length() > 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + modifier.getColumn2Output();
            }
            if (!(modifier.getTotalValue() < 0.0)) continue;
            if (string4.trim().length() > 0) {
                string4 = string4 + ", ";
            }
            string4 = string4 + modifier.getColumn2Output();
        }
        if (string2.trim().length() > 0) {
            string5 = string5 + string2;
        }
        if (string.trim().length() > 0) {
            if (string5.trim().length() > 0) {
                string5 = string5 + "; ";
            }
            string5 = string5 + "all slots " + string;
        }
        if (this.displayActiveCost && (this.getActiveCost() != this.getTotalCost() || this.getRealCost() != this.getTotalCost())) {
            string5 = string5 + " (" + Rounder.roundUp(this.getActiveCost()) + " Active Points)";
        }
        if (string4.trim().length() > 0) {
            if (string5.trim().length() > 0) {
                string5 = string5 + "; ";
            }
            string5 = string5 + string4;
        }
        if (string3.trim().length() > 0) {
            if (string5.trim().length() > 0) {
                string5 = string5 + "; ";
            }
            string5 = string5 + "all slots " + string3;
        }
        if (string5.trim().length() > 0) {
            string5 = ", " + string5;
        }
        return string5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getAdderString() {
        void var6_18;
        void var6_16;
        boolean bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (Adder object : this.getAssignedAdders()) {
            if ((object.getAvailableAdders().size() > 0 || object.isGroup()) && object.isSelected()) {
                object.addAliasToVector(arrayList3);
                continue;
            }
            object.addAliasToVector(arrayList);
        }
        for (Adder adder : this.getPrivateAdders()) {
            adder.addAliasToVector(arrayList2);
        }
        Collections.sort(arrayList3, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object.toString().toUpperCase();
                String string2 = object2.toString().toUpperCase();
                return string.compareTo(string2);
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object.toString().toUpperCase();
                String string2 = object2.toString().toUpperCase();
                return string.compareTo(string2);
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object.toString().toUpperCase();
                String string2 = object2.toString().toUpperCase();
                return string.compareTo(string2);
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList2) {
            if (string.toString().trim().length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string.toString().trim());
        }
        boolean bl2 = false;
        for (String string : arrayList3) {
            if (string.toString().trim().length() <= 0) continue;
            boolean bl3 = true;
            break;
        }
        for (String string : arrayList) {
            if (string.trim().length() <= 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append("all slots: ");
        }
        boolean bl4 = false;
        while (var6_16 < arrayList3.size()) {
            if (arrayList3.get((int)var6_16).trim().length() > 0) {
                if (var6_16 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(arrayList3.get((int)var6_16).trim());
            }
            ++var6_16;
        }
        boolean bl5 = false;
        while (var6_18 < arrayList.size()) {
            if (arrayList.get((int)var6_18).trim().length() > 0) {
                if (var6_18 > 0 || arrayList3.size() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(arrayList.get((int)var6_18).trim());
            }
            ++var6_18;
        }
        return stringBuffer.toString();
    }

    @Override
    public String getColumn1Output() {
        if (this.getAlias().trim().length() == 0 || this.getRealCost() == 0.0 && !(this instanceof Multipower) && !(this instanceof ElementalControl) && !(this instanceof VariablePowerPool)) {
            if (this.isEquipment() && this.getPrice() != 0.0) {
                BigDecimal bigDecimal = new BigDecimal(this.getTotalPrice());
                bigDecimal = bigDecimal.setScale(HeroDesigner.getActiveHero().getRules().getEquipmentCostDecimalPlaces(), 4);
                String string = "" + bigDecimal.toString();
                string = HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix() ? HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits() + string : string + HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits();
                return string;
            }
            return "";
        }
        return super.getColumn1Output();
    }

    @Override
    public double getActiveCost() {
        Modifier modifier;
        int n;
        double d = this.getTotalCost();
        double d2 = 0.0;
        boolean bl = false;
        for (n = 0; n < this.assignedModifiers.size(); ++n) {
            modifier = (Modifier)this.assignedModifiers.get(n);
            if (!(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        for (n = 0; n < this.getPrivateMods().size(); ++n) {
            modifier = this.getPrivateMods().get(n);
            if (modifier.getXMLID().equals("LINKED") || !(modifier.getTotalValue() > 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        double d3 = d * (1.0 + d2);
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        return d3;
    }

    @Override
    public double getActiveCost(String string) {
        Modifier modifier;
        int n;
        double d = this.getTotalCost();
        double d2 = 0.0;
        boolean bl = false;
        for (n = 0; n < this.assignedModifiers.size(); ++n) {
            modifier = (Modifier)this.assignedModifiers.get(n);
            if (!(modifier.getTotalValue() > 0.0) || modifier.getXMLID().equals(string)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        for (n = 0; n < this.getPrivateMods().size(); ++n) {
            modifier = this.getPrivateMods().get(n);
            if (!(modifier.getTotalValue() > 0.0) || modifier.getXMLID().equals(string)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        double d3 = d * (1.0 + d2);
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        return d3;
    }

    @Override
    public double getRealCostPreList() {
        Modifier modifier;
        int n;
        this.enhancerApplied = null;
        double d = this.getActiveCost();
        boolean bl = false;
        double d2 = 0.0;
        for (n = 0; n < this.assignedModifiers.size(); ++n) {
            modifier = (Modifier)this.assignedModifiers.get(n);
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        for (n = 0; n < this.getPrivateMods().size(); ++n) {
            modifier = this.getPrivateMods().get(n);
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl = true;
        }
        double d3 = d / (1.0 + Math.abs(d2));
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        if (d3 < 1.0 && (d > 0.0 || this.getLevels() > 0 && this.getAssignedAdders().size() == 0 && this.getBaseCost() >= 0.0)) {
            d3 = 1.0;
        }
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d3 *= this.getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        }
        if (this.getQuantity() > 1) {
            int n2 = 0;
            for (double d4 = (double)this.getQuantity(); d4 > 1.0; d4 /= 2.0) {
                ++n2;
            }
            d3 += (double)(n2 * 5);
        }
        return d3;
    }

    @Override
    public double getTotalCost() {
        Automaton automaton;
        int n;
        Adder adder2;
        double d = this.getBaseCost();
        ArrayList<Adder> arrayList = this.getAvailableAdders();
        if (this.getLevelValue() != 0.0) {
            d += (double)this.getLevels() / this.getLevelValue() * this.getLevelCost();
            if (this.getLevelCost() < this.getLevelValue()) {
                d = d > 0.0 && d < 1.0 ? 1.0 : (double)Rounder.roundHalfDown(d);
            }
        }
        for (Adder adder2 : this.getAssignedAdders()) {
            if (adder2.isRequired()) {
                d += adder2.getRealCost();
            }
            if (adder2.isRequired() || GenericObject.findObjectByID(arrayList, adder2.getXMLID()) == null) continue;
            d += adder2.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        for (n = 0; n < this.getAssignedAdders().size() && this.getPrivateAdders().size() == 0; ++n) {
            adder2 = this.getAssignedAdders().get(n);
            if (adder2.isRequired() || GenericObject.findObjectByID(arrayList, adder2.getXMLID()) != null) continue;
            d += adder2.getRealCost();
        }
        for (n = 0; n < this.getPrivateAdders().size(); ++n) {
            adder2 = this.getPrivateAdders().get(n);
            d += adder2.getRealCost();
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && (automaton = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON")).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d *= (double)automaton.getDefenseCostMultiplier();
        }
        return d;
    }
}

