/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.ElementalControl;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.disads.Disadvantage;
import com.hero.objects.enhancers.Enhancer;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.martialarts.WeaponElement;
import com.hero.objects.modifiers.Linked;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.Automaton;
import com.hero.objects.powers.CompoundPower;
import com.hero.objects.powers.EnduranceReserveRecovery;
import com.hero.objects.powers.MentalAwareness;
import com.hero.objects.powers.MentalIllusions;
import com.hero.objects.powers.NakedModifier;
import com.hero.objects.skills.Skill;
import com.hero.objects.skills.TransportFamiliarity;
import com.hero.objects.skills.WeaponFamiliarity;
import com.hero.ui.dialog.GenericDialog;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.jdom.Element;

public class GenericObject
implements Cloneable,
Comparable {
    private static long idCount;
    private static Hashtable<String, String> idTranslations;
    public static long lastEdit;
    protected String abbreviation;
    protected boolean adjustAliasWithLevels = true;
    protected String alias;
    protected boolean allowsOtherAdders;
    protected boolean allowsOtherModifiers;
    private boolean appAdjusted = false;
    protected int apperend;
    public ArrayList<Adder> assignedAdders;
    protected ArrayList<Modifier> assignedModifiers;
    protected ArrayList<Adder> availableAdders;
    protected ArrayList<Modifier> availableModifiers;
    protected double baseCost;
    protected boolean carried;
    protected String defense;
    protected String definition;
    public String display;
    public String textOutput;
    protected boolean displayActiveCost;
    protected boolean doesBODY;
    protected boolean doesDamage;
    protected boolean doesKnockback;
    protected String duration;
    protected boolean dynamicDisplay;
    protected Enhancer enhancerApplied;
    protected ArrayList<String> examples;
    protected boolean exclusive;
    protected boolean fixedValue;
    protected long id;
    protected boolean includedInTemplate;
    protected boolean includeNotesInPrintout;
    protected String input;
    protected String inputLabel;
    protected boolean isEquipment;
    protected boolean isPower;
    protected boolean isPrefab;
    protected boolean killing;
    protected double levelCost;
    protected int levelMultiplier;
    protected int levelPower;
    protected int levels;
    protected String levelsLbl;
    protected double levelValue;
    protected CompoundPower mainPower;
    protected double maxCost;
    protected int maxLevel;
    protected boolean maxSet;
    protected double minimumCost;
    protected int minimumLevel;
    protected boolean minSet;
    protected double multiplier;
    protected String name;
    protected String notes;
    protected String optionLbl;
    protected ArrayList<Adder> options;
    protected double origBaseCost;
    protected String origDisplay;
    protected boolean otherInputAllowed;
    protected List parent;
    protected long parentID;
    protected int position;
    protected boolean positionLocked;
    protected double price;
    protected String range;
    protected Adder selectedOption;
    protected boolean showBuildDialog;
    protected boolean showOption;
    protected boolean stopSign;
    protected String target;
    protected ArrayList<String> types;
    protected boolean ultra;
    protected boolean useENDReserve;
    protected boolean userInput;
    protected boolean usesEND;
    protected boolean visible;
    protected boolean warnSign;
    protected double weight;
    protected String wgAbbreviation;
    protected String xmlID;
    protected String graphic;
    protected String color;
    protected String sfx;
    private boolean listModCheck = false;
    protected int quantity = 1;
    private boolean costsENDToMaintain = true;
    private boolean continuingEffect = false;
    protected ArrayList<String> sources;
    protected static ArrayList<String> allSources;
    public static final String[] standardSFX;

    public void setListModCheck(boolean bl) {
        this.listModCheck = bl;
    }

    public boolean isListModCheck() {
        return this.listModCheck;
    }

    public String getGraphic() {
        if (this.graphic == null || this.graphic.trim().length() == 0) {
            this.graphic = "Burst";
        }
        if (this.getParentList() != null && this.getParentList() instanceof ElementalControl) {
            return this.getParentList().getGraphic();
        }
        return this.graphic;
    }

    public String getColor() {
        if (this.color == null || this.color.trim().length() == 0) {
            this.color = "255 255 255";
        }
        if (this.getParentList() != null && this.getParentList() instanceof ElementalControl) {
            return this.getParentList().getColor();
        }
        return this.color;
    }

    public String getSFX() {
        if (this.sfx == null || this.sfx.trim().length() == 0) {
            this.sfx = "Default";
        }
        if (this.getParentList() != null && this.getParentList() instanceof ElementalControl) {
            return this.getParentList().getSFX();
        }
        return this.sfx;
    }

    public void setSFX(String string) {
        boolean bl = true;
        if (!this.getGraphic().equalsIgnoreCase(GenericObject.getGraphicForSFX(this.getSFX()))) {
            bl = false;
        }
        if (!this.getColor().equalsIgnoreCase(GenericObject.getColorForSFX(this.getSFX()))) {
            bl = false;
        }
        this.sfx = string;
        if (bl) {
            this.graphic = GenericObject.getGraphicForSFX(this.sfx);
            this.color = GenericObject.getColorForSFX(this.sfx);
        }
    }

    public static String getGraphicForSFX(String string) {
        if (string.trim().toUpperCase().equals("ACID")) {
            return "block";
        }
        if (string.trim().toUpperCase().equals("ALIEN")) {
            return "zap";
        }
        if (string.trim().toUpperCase().equals("AIR/WIND")) {
            return "rads";
        }
        if (string.trim().toUpperCase().equals("ANIMAL")) {
            return "block";
        }
        if (string.trim().toUpperCase().equals("BIOCHEMICAL")) {
            return "clump";
        }
        if (string.trim().toUpperCase().equals("BODY CONTROL")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("CHI")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("COSMIC ENERGY")) {
            return "burst";
        }
        if (string.trim().toUpperCase().equals("CYBERKINESIS")) {
            return "rads";
        }
        if (string.trim().toUpperCase().equals("DARKNESS")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("DENSITY ALTERATION")) {
            return "clump";
        }
        if (string.trim().toUpperCase().equals("DIMENSIONAL MANIPULATION")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("EARTH/STONE")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("ELECTRICITY")) {
            return "zap";
        }
        if (string.trim().toUpperCase().equals("EMOTION CONTROL")) {
            return "block";
        }
        if (string.trim().toUpperCase().equals("FIRE/HEAT")) {
            return "zap";
        }
        if (string.trim().toUpperCase().equals("FORCE")) {
            return "burst";
        }
        if (string.trim().toUpperCase().equals("GRAVITY")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("ICE/COLD")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("ILLUSION")) {
            return "clump";
        }
        if (string.trim().toUpperCase().equals("KINETIC ENERGY")) {
            return "rads";
        }
        if (string.trim().toUpperCase().equals("LIGHT")) {
            return "burst";
        }
        if (string.trim().toUpperCase().equals("LUCK")) {
            return "block";
        }
        if (string.trim().toUpperCase().equals("MAGIC/MYSTIC")) {
            return "rads";
        }
        if (string.trim().toUpperCase().equals("MAGNETISM")) {
            return "zap";
        }
        if (string.trim().toUpperCase().equals("MARTIAL ARTS")) {
            return "block";
        }
        if (string.trim().toUpperCase().equals("MATTER MANIPULATION")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("MENTAL PSIONIC")) {
            return "burst";
        }
        if (string.trim().toUpperCase().equals("METAMORPHIC")) {
            return "burst";
        }
        if (string.trim().toUpperCase().equals("MUTANT")) {
            return "clump";
        }
        if (string.trim().toUpperCase().equals("PLASMA")) {
            return "block";
        }
        if (string.trim().toUpperCase().equals("PRECOGNITION")) {
            return "burst";
        }
        if (string.trim().toUpperCase().equals("RADIATION")) {
            return "rads";
        }
        if (string.trim().toUpperCase().equals("SERUM BASED")) {
            return "burst";
        }
        if (string.trim().toUpperCase().equals("SHAPE ALTERATION")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("SIZE ALTERATION")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("SLEEP/DREAM")) {
            return "burst";
        }
        if (string.trim().toUpperCase().equals("SOLAR/CELESTIAL")) {
            return "zap";
        }
        if (string.trim().toUpperCase().equals("SONIC")) {
            return "zap";
        }
        if (string.trim().toUpperCase().equals("SPEEDSTER")) {
            return "rads";
        }
        if (string.trim().toUpperCase().equals("STRENGTH/TOUGHNESS")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("STRETCHING")) {
            return "block";
        }
        if (string.trim().toUpperCase().equals("TELEKINETIC")) {
            return "clump";
        }
        if (string.trim().toUpperCase().equals("TELEPORTATION")) {
            return "zap";
        }
        if (string.trim().toUpperCase().equals("TIME")) {
            return "rads";
        }
        if (string.trim().toUpperCase().equals("VIBRATION")) {
            return "clump";
        }
        if (string.trim().toUpperCase().equals("WATER")) {
            return "clump";
        }
        if (string.trim().toUpperCase().equals("WEATHER")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("WOOD/PLANT")) {
            return "hole";
        }
        if (string.trim().toUpperCase().equals("MISCELLANEOUS")) {
            return "burst";
        }
        return "burst";
    }

    public static String getColorForSFX(String string) {
        if (string.trim().toUpperCase().equals("ACID")) {
            return "180 255 0";
        }
        if (string.trim().toUpperCase().equals("ALIEN")) {
            return "180 0 180";
        }
        if (string.trim().toUpperCase().equals("AIR/WIND")) {
            return "0 255 255";
        }
        if (string.trim().toUpperCase().equals("ANIMAL")) {
            return "255 180 0";
        }
        if (string.trim().toUpperCase().equals("BIOCHEMICAL")) {
            return "0 255 0";
        }
        if (string.trim().toUpperCase().equals("BODY CONTROL")) {
            return "180 0 255";
        }
        if (string.trim().toUpperCase().equals("CHI")) {
            return "0 255 180";
        }
        if (string.trim().toUpperCase().equals("COSMIC ENERGY")) {
            return "255 100 0";
        }
        if (string.trim().toUpperCase().equals("CYBERKINESIS")) {
            return "127 127 127";
        }
        if (string.trim().toUpperCase().equals("DARKNESS")) {
            return "0 0 0";
        }
        if (string.trim().toUpperCase().equals("DENSITY ALTERATION")) {
            return "0 0 180";
        }
        if (string.trim().toUpperCase().equals("DIMENSIONAL MANIPULATION")) {
            return "90 180 90";
        }
        if (string.trim().toUpperCase().equals("EARTH/STONE")) {
            return "255 180 0";
        }
        if (string.trim().toUpperCase().equals("ELECTRICITY")) {
            return "255 255 0";
        }
        if (string.trim().toUpperCase().equals("EMOTION CONTROL")) {
            return "180 180 255";
        }
        if (string.trim().toUpperCase().equals("FIRE/HEAT")) {
            return "255 0 0 ";
        }
        if (string.trim().toUpperCase().equals("FORCE")) {
            return "0 0 255";
        }
        if (string.trim().toUpperCase().equals("GRAVITY")) {
            return "50 100 200";
        }
        if (string.trim().toUpperCase().equals("ICE/COLD")) {
            return "255 255 255";
        }
        if (string.trim().toUpperCase().equals("ILLUSION")) {
            return "255 0 255";
        }
        if (string.trim().toUpperCase().equals("KINETIC ENERGY")) {
            return "200 100 50";
        }
        if (string.trim().toUpperCase().equals("LIGHT")) {
            return "255 255 255";
        }
        if (string.trim().toUpperCase().equals("LUCK")) {
            return "0 255 0";
        }
        if (string.trim().toUpperCase().equals("MAGIC/MYSTIC")) {
            return "255 0 180";
        }
        if (string.trim().toUpperCase().equals("MAGNETISM")) {
            return "255 0 0";
        }
        if (string.trim().toUpperCase().equals("MARTIAL ARTS")) {
            return "255 255 255";
        }
        if (string.trim().toUpperCase().equals("MATTER MANIPULATION")) {
            return "100 100 100";
        }
        if (string.trim().toUpperCase().equals("MENTAL PSIONIC")) {
            return "0 100 255";
        }
        if (string.trim().toUpperCase().equals("METAMORPHIC")) {
            return "200 100 0";
        }
        if (string.trim().toUpperCase().equals("MUTANT")) {
            return "0 255 0";
        }
        if (string.trim().toUpperCase().equals("PLASMA")) {
            return "255 0 255";
        }
        if (string.trim().toUpperCase().equals("PRECOGNITION")) {
            return "100 100 100";
        }
        if (string.trim().toUpperCase().equals("RADIATION")) {
            return "0 255 0";
        }
        if (string.trim().toUpperCase().equals("SERUM BASED")) {
            return "255 255 0";
        }
        if (string.trim().toUpperCase().equals("SHAPE ALTERATION")) {
            return "180 180 255";
        }
        if (string.trim().toUpperCase().equals("SIZE ALTERATION")) {
            return "255 180 0";
        }
        if (string.trim().toUpperCase().equals("SLEEP/DREAM")) {
            return "255 100 255";
        }
        if (string.trim().toUpperCase().equals("SOLAR/CELESTIAL")) {
            return "255 255 0";
        }
        if (string.trim().toUpperCase().equals("SONIC")) {
            return "0 0 255";
        }
        if (string.trim().toUpperCase().equals("SPEEDSTER")) {
            return "255 0 0";
        }
        if (string.trim().toUpperCase().equals("STRENGTH/TOUGHNESS")) {
            return "180 255 0";
        }
        if (string.trim().toUpperCase().equals("STRETCHING")) {
            return "0 180 255";
        }
        if (string.trim().toUpperCase().equals("TELEKINETIC")) {
            return "0 255 180";
        }
        if (string.trim().toUpperCase().equals("TELEPORTATION")) {
            return "90 90 90";
        }
        if (string.trim().toUpperCase().equals("TIME")) {
            return "180 0 255";
        }
        if (string.trim().toUpperCase().equals("VIBRATION")) {
            return "255 0 255";
        }
        if (string.trim().toUpperCase().equals("WATER")) {
            return "0 0 255";
        }
        if (string.trim().toUpperCase().equals("WEATHER")) {
            return "180 0 255";
        }
        if (string.trim().toUpperCase().equals("WOOD/PLANT")) {
            return "0 255 0";
        }
        if (string.trim().toUpperCase().equals("MISCELLANEOUS")) {
            return "255 255 255";
        }
        return "255 255 255";
    }

    public GenericObject() {
        this.includedInTemplate = true;
        this.resetID();
    }

    public GenericObject(Element element) {
        this.id = System.currentTimeMillis() + idCount;
        if (element == null) {
            this.includedInTemplate = false;
        } else {
            String string = XMLUtility.getValue(element, "XMLID");
            if (string != null && string.trim().length() > 0) {
                this.xmlID = string;
            }
            this.init(element);
            this.includedInTemplate = true;
        }
    }

    public GenericObject(Element element, String string) {
        this.id = System.currentTimeMillis() + idCount;
        this.xmlID = string;
        if (element == null) {
            this.includedInTemplate = false;
        } else {
            Element element2 = element.getChild(string);
            if (element2 == null) {
                this.includedInTemplate = false;
            } else {
                this.init(element2);
                this.includedInTemplate = true;
            }
        }
    }

    public static GenericObject findObjectByID(ArrayList<? extends GenericObject> arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            GenericObject genericObject;
            GenericObject genericObject2;
            GenericObject genericObject3 = arrayList.get(i);
            if (genericObject3 instanceof List && (genericObject2 = GenericObject.findObjectByID(((List)(genericObject = (List)genericObject3)).getObjects(), string)) != null) {
                return genericObject2;
            }
            if (genericObject3.getXMLID().equals("COMPOUNDPOWER") && (genericObject2 = GenericObject.findObjectByID(((CompoundPower)(genericObject = (CompoundPower)genericObject3)).getPowers(), string)) != null) {
                return genericObject2;
            }
            if (!genericObject3.getXMLID().equals(string.trim().toUpperCase())) continue;
            return genericObject3;
        }
        return null;
    }

    protected static Hashtable<String, String> getIDTranslations() {
        if (idTranslations == null) {
            idTranslations = new Hashtable();
            idTranslations.put("RADIOTRANSMISSION", "RADIOPERCEIVETRANSMIT");
            idTranslations.put("IRPERCEPTION", "INFRAREDPERCEPTION");
            idTranslations.put("NRAY", "NRAYPERCEPTION");
            idTranslations.put("UVPERCEPTION", "ULTRAVIOLETPERCEPTION");
            idTranslations.put("HEARING", "HEARINGGROUP");
            idTranslations.put("RADIO", "RADIOGROUP");
            idTranslations.put("SIGHT", "SIGHTGROUP");
            idTranslations.put("MENAL", "MENTALGROUP");
            idTranslations.put("SMELL", "SMELLGROUP");
            idTranslations.put("TOUCH", "TOUCHGROUP");
        }
        return idTranslations;
    }

    public boolean allowsOtherAdders() {
        return this.allowsOtherAdders;
    }

    public boolean allowsOtherModifiers() {
        return this.allowsOtherModifiers;
    }

    public boolean canAdd(Adder adder) {
        return true;
    }

    public void resetInternal() {
    }

    public GenericObject clone() {
        GenericObject genericObject;
        GenericObject genericObject2 = this;
        try {
            genericObject2 = (GenericObject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        genericObject2.setID(this.getID());
        genericObject2.setPower(this.isPower());
        ArrayList<Adder> arrayList = new ArrayList<Adder>();
        if (this.assignedAdders != null) {
            for (int i = 0; i < this.assignedAdders.size(); ++i) {
                Adder adder = this.assignedAdders.get(i);
                if ((adder = adder.clone()).isExclusive() && GenericObject.findObjectByID(arrayList, adder.getXMLID()) != null) continue;
                arrayList.add(adder);
            }
        }
        genericObject2.setAssignedAdders(arrayList);
        ArrayList<Modifier> arrayList2 = new ArrayList<Modifier>();
        if (this.assignedModifiers == null) {
            this.assignedModifiers = new ArrayList();
        }
        for (int i = 0; i < this.assignedModifiers.size(); ++i) {
            Modifier modifier = this.assignedModifiers.get(i);
            modifier = modifier.clone();
            modifier.setParent(genericObject2);
            arrayList2.add(modifier);
        }
        genericObject2.setAssignedModifiers(arrayList2);
        if (this.availableAdders != null) {
            ArrayList<Adder> arrayList3 = new ArrayList<Adder>();
            for (int i = 0; i < this.availableAdders.size(); ++i) {
                genericObject = this.availableAdders.get(i);
                genericObject = ((Adder)genericObject).clone();
                arrayList3.add((Adder)genericObject);
            }
            genericObject2.setAvailableAdders(arrayList3);
        }
        if (this.availableModifiers != null) {
            ArrayList<Modifier> arrayList4 = new ArrayList<Modifier>();
            for (int i = 0; i < this.availableModifiers.size(); ++i) {
                genericObject = this.availableModifiers.get(i);
                genericObject = ((Modifier)genericObject).clone();
                arrayList4.add((Modifier)genericObject);
            }
            genericObject2.setAvailableModifiers(arrayList4);
        }
        if (this.examples != null) {
            genericObject2.setExamples((ArrayList)this.examples.clone());
        }
        genericObject2.setTypes((ArrayList)this.getTypes().clone());
        if (this.options != null) {
            ArrayList<Adder> arrayList5 = new ArrayList<Adder>();
            for (int i = 0; i < this.options.size(); ++i) {
                genericObject = this.options.get(i);
                genericObject = ((Adder)genericObject).clone();
                arrayList5.add((Adder)genericObject);
            }
            genericObject2.setOptions(arrayList5);
        }
        genericObject2.resetInternal();
        if (this.getSelectedOption() != null) {
            Adder adder = this.getSelectedOption().clone();
            adder.setID(this.getSelectedOption().getID());
            genericObject2.setSelectedOption(adder);
        } else {
            genericObject2.setSelectedOption(null);
        }
        genericObject2.resetID();
        return genericObject2;
    }

    public int compareTo(Object object) {
        if (object instanceof GenericObject) {
            GenericObject genericObject = (GenericObject)object;
            if (this.getPosition() == genericObject.getPosition()) {
                return this.getSortingValue().compareTo(genericObject.getSortingValue());
            }
            return this.getPosition() - genericObject.getPosition();
        }
        return this.toString().compareTo(object.toString());
    }

    public boolean containsType(String string) {
        return this.types.contains(string);
    }

    public boolean doesBODY() {
        boolean bl = this.doesBODY;
        if (bl) {
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "AVAD") != null) {
                bl = false;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NND") != null) {
                bl = false;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "AVLD") != null) {
                bl = false;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV") != null) {
                bl = false;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "STUNONLY") != null) {
                bl = false;
            }
        }
        if (!bl && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DOESBODY") != null) {
            bl = true;
        }
        return bl;
    }

    public boolean doesDamage() {
        boolean bl = this.doesDamage;
        return bl;
    }

    public boolean doesKnockback() {
        boolean bl = this.doesKnockback;
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "STUNONLY") != null) {
            bl = false;
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NND") != null) {
            bl = false;
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "AVLD") != null) {
            bl = false;
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV") != null) {
            bl = false;
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DOESBODY") != null) {
            bl = true;
        }
        if (!bl && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DOESKB") != null) {
            bl = true;
        }
        if (bl && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NOKB") != null) {
            bl = false;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object instanceof GenericObject) {
            long l = ((GenericObject)object).getID();
            return l == this.id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public String getAbbr() {
        if (this.abbreviation == null) {
            this.abbreviation = this.getAlias();
        }
        if (HeroDesigner.getInstance().getPrefs().useWG()) {
            this.abbreviation = this.wgAbbreviation == null ? this.getAlias() : this.wgAbbreviation;
        }
        if (this.display != null && this.display.indexOf("[LVL]") >= 0 && (this.adjustAliasWithLevels || this.abbreviation.indexOf("[LVL]") >= 0)) {
            boolean bl = this.abbreviation.equals(this.display);
            String string = "";
            String string2 = "";
            if (this.display.indexOf("[LVL]") > 0) {
                string = this.display.substring(0, this.display.indexOf("[LVL]"));
            }
            if (this.display.indexOf("[LVL]") + 5 < this.display.length()) {
                string2 = this.display.substring(this.display.indexOf("[LVL]") + 5, this.display.length());
            }
            String string3 = "" + NumberFormat.getInstance().format(this.getLevels() * this.getLevelMultiplier());
            if (this.levelPower != 1) {
                string3 = "" + NumberFormat.getInstance().format((long)((double)this.getLevelMultiplier() * Math.pow(this.levelPower, this.getLevels())));
            }
            if (bl) {
                this.abbreviation = string + string3 + string2;
            } else if (this.abbreviation.indexOf("[LVL]") >= 0) {
                string = "";
                string2 = "";
                if (this.abbreviation.indexOf("[LVL]") > 0) {
                    string = this.abbreviation.substring(0, this.abbreviation.indexOf("[LVL]"));
                }
                if (this.abbreviation.indexOf("[LVL]") + 5 < this.abbreviation.length()) {
                    string2 = this.abbreviation.substring(this.abbreviation.indexOf("[LVL]") + 5, this.abbreviation.length());
                }
                this.abbreviation = string + string3 + string2;
            } else {
                int n = -1;
                int n2 = -1;
                for (int i = 0; i < this.abbreviation.length(); ++i) {
                    char c = this.abbreviation.charAt(i);
                    if (Character.isDigit(c) && n == -1) {
                        n = i;
                        continue;
                    }
                    if (Character.isDigit(c) || c == ',' || n < 0 || n2 != -1) continue;
                    n2 = i;
                    break;
                }
                if (n >= 0) {
                    string = this.abbreviation.substring(0, n);
                    string2 = n2 > n ? this.abbreviation.substring(n2, this.abbreviation.length()) : "";
                    this.abbreviation = string + string3 + string2;
                }
            }
        }
        return this.abbreviation == null ? "" : this.abbreviation;
    }

    public void setQuantity(int n) {
        this.quantity = n;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public double getActiveCost() {
        Cloneable cloneable;
        double d = this.getTotalCost();
        double d2 = 0.0;
        boolean bl = false;
        for (int i = 0; i < this.assignedModifiers.size(); ++i) {
            cloneable = this.assignedModifiers.get(i);
            ((Modifier)cloneable).setParent(this);
            if (!(((Modifier)cloneable).getTotalValue() > 0.0)) continue;
            d2 += ((Modifier)cloneable).getTotalValue();
            bl = true;
        }
        List list = this.getParentList();
        if (this.getMainPower() != null) {
            list = this.getMainPower().getParentList();
        }
        if (list != null) {
            cloneable = list.getAssignedModifiers();
            for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                Modifier modifier = (Modifier)((ArrayList)cloneable).get(i);
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && list instanceof Multipower || modifier instanceof Linked || !(modifier.getTotalValue() > 0.0) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER") || list instanceof Multipower || list instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        double d3 = d * (1.0 + d2);
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
            if (d > 0.0 && d3 < 1.0) {
                d3 = 1.0;
            }
        }
        return d3;
    }

    public double getActiveCost(String string) {
        Cloneable cloneable;
        double d = this.getTotalCost();
        double d2 = 0.0;
        boolean bl = false;
        for (int i = 0; i < this.assignedModifiers.size(); ++i) {
            cloneable = this.assignedModifiers.get(i);
            ((Modifier)cloneable).setParent(this);
            if (!(((Modifier)cloneable).getTotalValue() > 0.0) || ((GenericObject)cloneable).getXMLID().equals(string)) continue;
            d2 += ((Modifier)cloneable).getTotalValue();
            bl = true;
        }
        List list = this.getParentList();
        if (this.getMainPower() != null) {
            list = this.getMainPower().getParentList();
        }
        if (list != null) {
            cloneable = list.getAssignedModifiers();
            for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                Modifier modifier = (Modifier)((ArrayList)cloneable).get(i);
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && list instanceof Multipower || !(modifier.getTotalValue() > 0.0) || modifier.getXMLID().equals(string) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER") || list instanceof Multipower || list instanceof ElementalControl) continue;
                d2 += modifier.getTotalValue();
                bl = true;
            }
        }
        double d3 = d * (1.0 + d2);
        if (bl) {
            d3 = Rounder.roundHalfDown(d3);
        }
        return d3;
    }

    protected void getAdderSaveXML(Element element) {
        for (Adder adder : this.getAssignedAdders()) {
            element.addContent(adder.getSaveXML());
        }
    }

    public String getAdderString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Adder object : this.getAssignedAdders()) {
            if ((object.getAvailableAdders().size() > 0 || object.isGroup()) && object.isSelected()) {
                object.addAliasToVector(arrayList2);
                continue;
            }
            object.addAliasToVector(arrayList);
        }
        Collections.sort(arrayList2, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object.toString().toUpperCase();
                String string2 = object2.toString().toUpperCase();
                return string.compareTo(string2);
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = object.toString().toUpperCase();
                String string2 = object2.toString().toUpperCase();
                return string.compareTo(string2);
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList2) {
            if (string.trim().length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string.trim());
        }
        for (String string : arrayList) {
            if (string.trim().length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string.trim());
        }
        return stringBuffer.toString();
    }

    public String getAlias() {
        if (this.alias == null) {
            this.alias = HeroDesigner.getInstance().getPrefs().useWG() && HeroDesigner.getInstance().getPrefs().useAbbreviations() && this.wgAbbreviation != null ? this.wgAbbreviation : (!HeroDesigner.getInstance().getPrefs().useWG() && HeroDesigner.getInstance().getPrefs().useAbbreviations() && this.abbreviation != null ? this.abbreviation : this.display);
        }
        if (this.alias == null) {
            this.alias = "";
        }
        if (this.display != null && this.display.indexOf("[LVL]") >= 0 && (this.adjustAliasWithLevels || this.alias.indexOf("[LVL]") >= 0)) {
            boolean bl = this.alias.equals(this.display);
            String string = "";
            String string2 = "";
            if (this.display.indexOf("[LVL]") > 0) {
                string = this.display.substring(0, this.display.indexOf("[LVL]"));
            }
            if (this.display.indexOf("[LVL]") + 5 < this.display.length()) {
                string2 = this.display.substring(this.display.indexOf("[LVL]") + 5, this.display.length());
            }
            String string3 = "" + NumberFormat.getInstance().format(this.getLevels() * this.getLevelMultiplier());
            if (this.levelPower != 1) {
                string3 = "" + NumberFormat.getInstance().format((long)((double)this.getLevelMultiplier() * Math.pow(this.levelPower, this.getLevels())));
            }
            if (bl) {
                this.alias = string + string3 + string2;
            } else if (this.alias.indexOf("[LVL]") >= 0) {
                string = "";
                string2 = "";
                if (this.alias.indexOf("[LVL]") > 0) {
                    string = this.alias.substring(0, this.alias.indexOf("[LVL]"));
                }
                if (this.alias.indexOf("[LVL]") + 5 < this.alias.length()) {
                    string2 = this.alias.substring(this.alias.indexOf("[LVL]") + 5, this.alias.length());
                }
                this.alias = string + string3 + string2;
            } else {
                int n = -1;
                int n2 = -1;
                for (int i = 0; i < this.alias.length(); ++i) {
                    char c = this.alias.charAt(i);
                    if (Character.isDigit(c) && n == -1) {
                        n = i;
                        continue;
                    }
                    if (Character.isDigit(c) || c == ',' || n < 0 || n2 != -1) continue;
                    n2 = i;
                    break;
                }
                if (n >= 0) {
                    string = this.alias.substring(0, n);
                    string2 = n2 > n ? this.alias.substring(n2, this.alias.length()) : "";
                    this.alias = string + string3 + string2;
                }
            }
        }
        return this.alias == null ? "" : this.alias;
    }

    public ArrayList<Modifier> getAllAssignedModifiers() {
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
        arrayList.addAll(this.getAssignedModifiers());
        List list = this.getParentList();
        if (this.getMainPower() != null) {
            list = this.getMainPower().getParentList();
        }
        if (list != null) {
            for (Modifier modifier : list.getAssignedModifiers()) {
                if (GenericObject.findObjectByID(arrayList, modifier.getXMLID()) != null) continue;
                arrayList.add(modifier);
            }
        }
        return arrayList;
    }

    public int getAPPerEnd() {
        int n = 10;
        if (HeroDesigner.getActiveHero() != null) {
            n = HeroDesigner.getActiveHero().getRules().getAPPerEND();
            if (this.getXMLID().equals("STR")) {
                n = HeroDesigner.getActiveHero().getRules().getSTRAPPerEND();
            }
        }
        if (this.apperend >= 0) {
            n = this.apperend;
        }
        if (this.usesEND()) {
            return n;
        }
        return 0;
    }

    public ArrayList<Adder> getAssignedAdders() {
        if (this.assignedAdders == null) {
            this.assignedAdders = new ArrayList();
        }
        if (this.availableAdders == null) {
            this.availableAdders = new ArrayList();
        }
        for (Adder adder : this.availableAdders) {
            if (!adder.isRequired() || GenericObject.findObjectByID(this.assignedAdders, adder.getXMLID()) != null) continue;
            adder = adder.clone();
            adder.setSelected(true);
            this.assignedAdders.add(adder);
        }
        return this.assignedAdders;
    }

    public ArrayList<Modifier> getAssignedModifiers() {
        if (this.assignedModifiers == null) {
            this.assignedModifiers = new ArrayList();
        }
        return this.assignedModifiers;
    }

    public ArrayList<Adder> getAvailableAdders() {
        if (this.availableAdders == null) {
            this.availableAdders = new ArrayList();
        }
        ArrayList<Adder> arrayList = new ArrayList<Adder>();
        arrayList.addAll(this.availableAdders);
        if (this.getSelectedOption() != null) {
            arrayList.addAll(this.getSelectedOption().getAvailableAdders());
        }
        if (this.getTarget() != null && this.getTarget().equals("HEX") && this.getDuration() != null && (this.getDuration().equals("CONSTANT") || this.getDuration().equals("PERSISTENT") || this.getDuration().equals("INHERENT")) && GenericObject.findObjectByID(this.assignedAdders, "ALTERABLESIZE") == null && GenericObject.findObjectByID(arrayList, "ALTERABLESIZE") == null) {
            Adder adder = new Adder();
            adder.setXMLID("ALTERABLESIZE");
            adder.setDisplay("Alterable Size");
            adder.setFixedValue(true);
            adder.setExclusive(true);
            adder.setBaseCost(5.0);
            arrayList.add(adder);
        }
        return arrayList;
    }

    public ArrayList<Modifier> getAvailableModifiers() {
        if (this.availableModifiers == null) {
            this.availableModifiers = new ArrayList();
        }
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
        arrayList.addAll(this.availableModifiers);
        for (Modifier modifier : arrayList) {
            modifier.setParent(this);
        }
        if (this.getSelectedOption() != null) {
            for (Modifier modifier : this.getSelectedOption().getAvailableModifiers()) {
                if (GenericObject.findObjectByID(arrayList, modifier.getXMLID()) != null) continue;
                modifier.setParent(this);
                arrayList.add(modifier);
            }
        }
        if (this instanceof Modifier) {
            return arrayList;
        }
        return arrayList;
    }

    public double getBaseCost() {
        return this.baseCost;
    }

    public double getOrigBaseCost() {
        return this.origBaseCost;
    }

    public String getColumn1Output() {
        String string = "" + Rounder.roundUp(this.getRealCost());
        if (this.isEquipment() && this.getPrice() != 0.0) {
            BigDecimal bigDecimal = new BigDecimal(this.getTotalPrice());
            bigDecimal = bigDecimal.setScale(HeroDesigner.getActiveHero().getRules().getEquipmentCostDecimalPlaces(), 4);
            string = "" + bigDecimal.toString();
            string = HeroDesigner.getActiveHero().getRules().isEquipmentUnitsPrefix() ? HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits() + string : string + HeroDesigner.getActiveHero().getRules().getEquipmentCostUnits();
        } else if (this.isEquipment()) {
            string = "";
        }
        string = string + this.getColumn1Suffix();
        return string;
    }

    public String getColumn1Suffix() {
        if (this.parent != null) {
            return this.parent.getColumn1Suffix(this);
        }
        return "";
    }

    public String getColumn2Output() {
        return this.getDisplay();
    }

    public String getColumn3Output() {
        if (this.getEndUsage() > 0) {
            return "" + this.getEndUsage();
        }
        return "";
    }

    public String getDefense() {
        String string = this.defense;
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BASEDONCON") != null) {
            string = "NORMAL";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV") != null) {
            GenericObject genericObject = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV");
            string = genericObject.getSelectedOption() != null && genericObject.getSelectedOption().getXMLID().equals("STANDARD") ? "NORMAL" : "MENTAL";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO") != null) {
            string = "POWER";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NND") != null) {
            string = "SPECIAL";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "AVLD") != null) {
            string = "SPECIAL";
        }
        return string;
    }

    public String getDefense(String string) {
        String string2 = this.defense;
        if (!string.equals("BASEDONCON") && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BASEDONCON") != null) {
            string2 = "NORMAL";
        }
        if (!string.equals("BOECV") && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV") != null) {
            GenericObject genericObject = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV");
            string2 = genericObject.getSelectedOption() != null && genericObject.getSelectedOption().getXMLID().equals("STANDARD") ? "NORMAL" : "MENTAL";
        }
        if (!string.equals("UOO") && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO") != null) {
            string2 = "POWER";
        }
        if (!string.equals("NND") && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NND") != null) {
            string2 = "SPECIAL";
        }
        if (!string.equals("AVLD") && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "AVLD") != null) {
            string2 = "SPECIAL";
        }
        return string2;
    }

    public String getDefinition() {
        return this.definition;
    }

    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return null;
    }

    public String getDisplay() {
        String string;
        if (this.display == null || this.display.trim().length() == 0) {
            this.display = "";
        }
        if ((string = this.display).toUpperCase().indexOf("[LVL]") >= 0) {
            String string2 = string.substring(0, string.toUpperCase().indexOf("[LVL]"));
            String string3 = string.substring(string.toUpperCase().indexOf("[LVL]") + 5, string.length());
            String string4 = "" + NumberFormat.getInstance().format(this.getLevels());
            if (this.levelPower != 1) {
                string4 = "" + NumberFormat.getInstance().format((long)Math.pow(this.levelPower, this.getLevels()));
            }
            return string2 + string4 + string3;
        }
        return string;
    }

    public boolean getDisplayActiveCost() {
        return this.displayActiveCost;
    }

    public String getDuration() {
        if (this.duration == null) {
            this.duration = "";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INSTANT") != null) {
            return "INSTANT";
        }
        if (HeroDesigner.getActiveTemplate().is6E()) {
            if (this.duration.equals("PERSISTENT") || this.duration.equals("INHERENT")) {
                if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NONPERSISTENT") != null) {
                    if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INSTANT") != null) {
                        return "INSTANT";
                    }
                    return "CONSTANT";
                }
                if (this.usesEND()) {
                    if (GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSENDTOMAINTAIN") != null) {
                        return this.duration;
                    }
                    return "CONSTANT";
                }
                return this.duration;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INHERENT") != null) {
                if (this.usesEND()) {
                    if (GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSENDTOMAINTAIN") != null) {
                        return "INHERENT";
                    }
                    return "CONSTANT";
                }
                return "INHERENT";
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "PERSISTENT") != null) {
                if (this.usesEND()) {
                    if (GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSENDTOMAINTAIN") != null || GenericObject.findObjectByID(this.getAllAssignedModifiers(), "REDUCEDEND") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "REDUCEDEND").getSelectedOption().getXMLID().equals("ZERO")) {
                        return "PERSISTENT";
                    }
                    return "CONSTANT";
                }
                return "PERSISTENT";
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "CONTINUOUS") != null) {
                return "CONSTANT";
            }
            if (this.duration.equals("CONSTANT")) {
                if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INSTANT") != null) {
                    return "INSTANT";
                }
                return "CONSTANT";
            }
            return "INSTANT";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NONPERSISTENT") != null || (this.duration.equals("PERSISTENT") || this.duration.equals("INHERENT")) && this.usesEND()) {
            return "CONSTANT";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INHERENT") != null) {
            return "INHERENT";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "PERSISTENT") != null) {
            return "PERSISTENT";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "CONTINUOUS") != null) {
            return "CONSTANT";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NONPERSISTENT") != null) {
            return "CONSTANT";
        }
        return this.duration.trim().toUpperCase();
    }

    public String getOrigDuration() {
        return this.duration;
    }

    public int getEndUsage() {
        Cloneable cloneable;
        int n = this.getAPPerEnd();
        double d = 0.0;
        double d2 = this.getActiveCost();
        double d3 = 1.0;
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
        arrayList.addAll(this.getAssignedModifiers());
        List list = this.getParentList();
        if (this.getMainPower() != null) {
            list = this.getMainPower().getParentList();
        }
        if (list != null) {
            cloneable = list.getAssignedModifiers();
            Iterator<Modifier> iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                Modifier modifier = iterator.next();
                if (this.getParentList() instanceof ElementalControl) {
                    arrayList.add(modifier);
                    continue;
                }
                arrayList.add(modifier);
            }
        }
        if (GenericObject.findObjectByID(arrayList, "CHARGES") != null) {
            n = 0;
        }
        if (GenericObject.findObjectByID(arrayList, "COSTSEND") != null) {
            n = HeroDesigner.getActiveHero().getRules().getAPPerEND();
            cloneable = GenericObject.findObjectByID(arrayList, "COSTSEND");
            if (((GenericObject)cloneable).getSelectedOption() != null && ((GenericObject)cloneable).getSelectedOption().getXMLID().equals("HALFEND")) {
                d3 = 0.5;
            }
        }
        if (GenericObject.findObjectByID(arrayList, "REDUCEDEND") != null) {
            cloneable = GenericObject.findObjectByID(arrayList, "REDUCEDEND");
            if (((GenericObject)cloneable).getSelectedOption().getXMLID().equals("HALFEND")) {
                d3 = 0.5;
            } else {
                n = 0;
            }
            d2 = this.getActiveCost(((GenericObject)cloneable).getXMLID());
        }
        if (GenericObject.findObjectByID(arrayList, "COSTSENDONLYTOACTIVATE") != null) {
            cloneable = GenericObject.findObjectByID(arrayList, "COSTSENDONLYTOACTIVATE");
            d2 = this.getActiveCost(((GenericObject)cloneable).getXMLID());
        }
        if (GenericObject.findObjectByID(arrayList, "INCREASEDEND") != null && GenericObject.findObjectByID(((GenericObject)(cloneable = GenericObject.findObjectByID(arrayList, "INCREASEDEND"))).getAssignedAdders(), "CIRCUMSTANCE") == null) {
            d3 = Rounder.roundHalfUp(((GenericObject)cloneable).getSelectedOption().getLevelValue());
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(cloneable = GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d2 /= (double)((Automaton)cloneable).getDefenseCostMultiplier();
        }
        if (n != 0) {
            d = d2 / (double)n;
        }
        if (Rounder.roundHalfDown(d) == 0L && d2 > 0.0 && n != 0) {
            d = 1.0;
        }
        d = Rounder.roundHalfDown(d);
        if (Rounder.roundHalfDown(d *= d3) == 0L && d2 > 0.0 && n != 0) {
            d = 1.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return (int)Rounder.roundHalfDown(d);
    }

    public Enhancer getEnhancerApplied() {
        return this.enhancerApplied;
    }

    public ArrayList<String> getExamples() {
        return this.examples;
    }

    public void setTextOutput(String string) {
        String string2 = this.getTextOutput();
        String string3 = this.getColumn2Output();
        if (string3.equals(string)) {
            this.textOutput = null;
            return;
        }
        this.textOutput = string;
        if (!string2.equals(this.getTextOutput())) {
            HeroDesigner.getActiveHero().setDirty(true);
        }
    }

    public String getTextOutput() {
        if (this.textOutput == null || this.textOutput.trim().length() == 0) {
            return this.getColumn2Output();
        }
        return this.textOutput;
    }

    public final Element getGeneralSaveXML() {
        Element element = new Element("GENERIC_OBJECT");
        element.setAttribute("XMLID", this.getXMLID());
        element.setAttribute("ID", "" + this.getID());
        element.setAttribute("BASECOST", "" + this.getBaseCost());
        element.setAttribute("LEVELS", "" + this.getLevels());
        element.setAttribute("ALIAS", "" + this.getAlias());
        if (this.textOutput != null && this.textOutput.trim().length() > 0) {
            element.setAttribute("TEXT", "" + this.getTextOutput());
        }
        element.setAttribute("POSITION", "" + this.getPosition());
        element.setAttribute("MULTIPLIER", "" + this.multiplier);
        element.setAttribute("GRAPHIC", this.getGraphic());
        element.setAttribute("COLOR", this.getColor());
        element.setAttribute("SFX", this.getSFX());
        if (this.getUseENDReserve()) {
            element.setAttribute("USE_END_RESERVE", "Yes");
        }
        element.setAttribute("SHOW_ACTIVE_COST", this.displayActiveCost ? "Yes" : "No");
        if (this.isEquipment()) {
            element.setAttribute("PRICE", "" + this.price);
            element.setAttribute("WEIGHT", "" + this.weight);
            element.setAttribute("CARRIED", this.carried ? "Yes" : "No");
        }
        if (this.getSelectedOption() != null) {
            element.setAttribute("OPTION", this.getSelectedOption().getXMLID());
            element.setAttribute("OPTIONID", this.getSelectedOption().getXMLID());
            element.setAttribute("OPTION_ALIAS", this.getSelectedOption().getAlias());
        }
        element.setAttribute("LEVELS", "" + this.getLevels());
        Element element2 = new Element("NOTES");
        element2.setText(this.getNotes());
        element.addContent(element2);
        element.setAttribute("INCLUDE_NOTES_IN_PRINTOUT", this.isIncludeNotesInPrintout() ? "Yes" : "No");
        if (this.getParentID() > 0L) {
            element.setAttribute("PARENTID", "" + this.getParentID());
            if (this.getParentList() instanceof Multipower) {
                element.setAttribute("ULTRA_SLOT", this.isUltra() ? "Yes" : "No");
            }
        }
        if (this.getName() != null) {
            element.setAttribute("NAME", this.getName());
        }
        if (this.getInput() != null && this.getInput().trim().length() > 0) {
            element.setAttribute("INPUT", this.getInput() == null ? "" : this.getInput());
        }
        this.getAdderSaveXML(element);
        this.getModifierSaveXML(element);
        return element;
    }

    public long getID() {
        return this.id;
    }

    public String getInput() {
        return this.input;
    }

    public String getInputLabel() {
        return this.inputLabel;
    }

    public double getLevelCost() {
        return this.levelCost;
    }

    public int getLevelMultiplier() {
        return this.levelMultiplier;
    }

    public int getLevelPower() {
        return this.levelPower;
    }

    public int getLevels() {
        int n = this.levels;
        if (n < this.getMinimumLevel()) {
            n = this.getMinimumLevel();
        }
        return n;
    }

    public String getLevelsLabel() {
        if (this.levelsLbl == null || this.levelsLbl.trim().length() == 0) {
            this.levelsLbl = "Levels";
        }
        return this.levelsLbl;
    }

    public double getLevelValue() {
        return this.levelValue;
    }

    public CompoundPower getMainPower() {
        return this.mainPower;
    }

    public double getMaxCost() {
        return this.maxCost;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getMinimumCost() {
        return this.minimumCost;
    }

    public int getMinimumLevel() {
        return this.minimumLevel;
    }

    protected ArrayList<Modifier> getModifiers() {
        if (this.assignedModifiers == null) {
            this.assignedModifiers = new ArrayList();
        }
        return this.assignedModifiers;
    }

    protected void getModifierSaveXML(Element element) {
        for (int i = 0; i < this.getModifiers().size(); ++i) {
            GenericObject genericObject = this.getModifiers().get(i);
            element.addContent(genericObject.getSaveXML());
        }
    }

    public String getModifierString() {
        String string = "";
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
        arrayList.addAll(this.getAssignedModifiers());
        if (this.getParentList() != null && HeroDesigner.getInstance().getPrefs().showCommonLimitations()) {
            ArrayList<Modifier> arrayList2 = this.getParentList().getAssignedModifiers();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Modifier modifier = (Modifier)arrayList2.get(i);
                if (modifier.getTypes().contains("VPP") || modifier.getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(modifier.getTotalValue() < 0.0) && !(this.getParentList() instanceof VariablePowerPool) || GenericObject.findObjectByID(this.assignedModifiers, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER")) continue;
                arrayList.add(modifier);
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof Modifier && object2 instanceof Modifier) {
                    Modifier modifier = (Modifier)object;
                    Modifier modifier2 = (Modifier)object2;
                    return (int)((modifier.getTotalValue() - modifier2.getTotalValue()) * 100.0);
                }
                return -1;
            }
        });
        for (Modifier modifier : arrayList) {
            if (!(modifier.getTotalValue() >= 0.0) || !modifier.displayInString() || modifier.isLimitation()) continue;
            string = string + ", ";
            string = string + modifier.getColumn2Output();
        }
        if (this.displayActiveCost && (this.getActiveCost() != this.getTotalCost() || this.getRealCost() != this.getTotalCost())) {
            string = string + " (" + Rounder.roundUp(this.getActiveCost()) + " Active Points)";
        }
        int n = 0;
        for (Modifier modifier : arrayList) {
            if (!(modifier.getTotalValue() < 0.0) && !modifier.isLimitation() || !modifier.displayInString()) continue;
            string = ++n == 1 ? string + "; " : string + ", ";
            string = string + modifier.getColumn2Output();
        }
        return string;
    }

    public double getMultiplier() {
        double d = this.multiplier;
        if (d == 1.0 && this.getMainPower() != null && this.getMainPower().getMultiplier() != 1.0) {
            d = this.getMainPower().getMultiplier();
        } else if (d == 1.0 && this.getParentList() != null) {
            d = this.getParentList().getMultiplier();
        }
        return d;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public String getNamelessColumn2Output() {
        String string = this.getName();
        this.setName("");
        String string2 = this.getTextOutput();
        this.setName(string);
        return string2;
    }

    public String getOutputNotes() {
        if (this.getQuantity() == 1) {
            return this.notes;
        }
        if (this.notes == null || this.notes.trim().length() == 0) {
            return "(x" + this.getQuantity() + " number of items)";
        }
        return "(x" + this.getQuantity() + " number of items)\n\n" + this.notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getOptionLabel() {
        if (this.optionLbl == null || this.optionLbl.trim().length() == 0) {
            this.optionLbl = "Options";
        }
        return this.optionLbl;
    }

    public ArrayList<Adder> getOptions() {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        return this.options;
    }

    public int getOrigAPPerEnd() {
        int n = 10;
        if (HeroDesigner.getActiveHero() != null) {
            n = HeroDesigner.getActiveHero().getRules().getAPPerEND();
            if (this.getXMLID().equals("STR")) {
                n = HeroDesigner.getActiveHero().getRules().getSTRAPPerEND();
            }
        }
        if (!this.usesEND) {
            n = 0;
        }
        if (this.apperend >= 0) {
            n = this.apperend;
        }
        return n;
    }

    public long getParentID() {
        return this.parentID;
    }

    public List getParentList() {
        return this.parent;
    }

    public int getPosition() {
        return this.position;
    }

    public double getPrice() {
        if (HeroDesigner.getActiveHero() == null) {
            return this.price;
        }
        return this.price / HeroDesigner.getActiveHero().getRules().getEquipmentCostConversion();
    }

    public double getTotalPrice() {
        return (double)this.getQuantity() * this.getPrice();
    }

    public String getRange() {
        return this.range;
    }

    public String getRangeDisplay() {
        Cloneable cloneable;
        if (this.getRangeValue() < 0) {
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "EYECONTACTREQUIRED") != null) {
                return "varies";
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NORANGE") != null) {
                return "0";
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "LIMITEDRANGE") != null) {
                return "var.";
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "RANGEBASEDONSTR") != null) {
                return "var.";
            }
            return "LOS";
        }
        if (this.getRangeValue() == 0) {
            return "";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NORANGE") != null) {
            return "0";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "LIMITEDRANGE") != null) {
            return "var.";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "RANGEBASEDONSTR") != null) {
            return "var.";
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "RANGED") != null && ((GenericObject)(cloneable = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "RANGED"))).getSelectedOption() != null && !((GenericObject)cloneable).getSelectedOption().getXMLID().equals("RANGED") && !((GenericObject)cloneable).getSelectedOption().getXMLID().equals("RANGE")) {
            return "var.";
        }
        cloneable = NumberFormat.getInstance();
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return ((NumberFormat)cloneable).format(this.getRangeValue()) + "m";
        }
        return ((NumberFormat)cloneable).format(this.getRangeValue()) + "\"";
    }

    public int getRangeValue() {
        if (this.range == null) {
            this.range = "No";
        }
        if ((this.range.trim().toUpperCase().equals("YES") || GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BASEDONCON") != null) && (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "MOBILE") == null || HeroDesigner.getActiveTemplate().is6E())) {
            Modifier modifier;
            int n;
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NORANGE") != null) {
                return 0;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DAMAGESHIELD") != null) {
                return 0;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV") != null && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NORMALRANGE") == null) {
                return -1;
            }
            if (GenericObject.findObjectByID(this.getAssignedModifiers(), "INCREASEDMAXRANGE") != null && (n = (modifier = (Modifier)GenericObject.findObjectByID(this.getAssignedModifiers(), "INCREASEDMAXRANGE")).getLevels()) > 0) {
                double d = modifier.getLevelValue();
                int n2 = modifier.getLevelPower();
                double d2 = Math.pow(n2, (double)n * d);
                if (d2 > 0.0) {
                    this.getAssignedModifiers().remove(modifier);
                    double d3 = (double)n * modifier.getLevelCost();
                    int n3 = this.getRangeValue();
                    this.getAssignedModifiers().add(modifier);
                    return (int)Rounder.roundHalfDown(d2 * (double)n3);
                }
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "LOS") != null) {
                return -1;
            }
            int n4 = (int)Rounder.roundHalfUp(this.getActiveCost() * 5.0);
            if (HeroDesigner.getActiveTemplate().is6E()) {
                double d = this.getTotalCost();
                for (Adder adder : this.getAssignedAdders()) {
                    if (adder.includeInBase() || adder.isCustom()) continue;
                    d -= adder.getTotalCost();
                }
                n4 = (int)Rounder.roundHalfUp(d * 10.0);
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO") != null) {
                GenericObject genericObject = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO");
                if (genericObject.getSelectedOption() != null && genericObject.getSelectedOption().equals("UAA")) {
                    if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "LOS") != null) {
                        return -1;
                    }
                    if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "RANGED") != null) {
                        return n4;
                    }
                    return 0;
                }
                return n4;
            }
            return n4;
        }
        if (this.range.trim().toUpperCase().equals("LOS") && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BASEDONCON") == null && (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "MOBILE") == null || HeroDesigner.getActiveTemplate().is6E())) {
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "DAMAGESHIELD") != null) {
                return 0;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "NORMALRANGE") != null) {
                Modifier modifier;
                int n;
                if (GenericObject.findObjectByID(this.getAssignedModifiers(), "INCREASEDMAXRANGE") != null && (n = (modifier = (Modifier)GenericObject.findObjectByID(this.getAssignedModifiers(), "INCREASEDMAXRANGE")).getLevels()) > 0) {
                    double d = modifier.getLevelValue();
                    int n5 = modifier.getLevelPower();
                    double d4 = Math.pow(n5, (double)n * d);
                    if (d4 > 0.0) {
                        this.getAssignedModifiers().remove(modifier);
                        double d5 = (double)n * modifier.getLevelCost();
                        int n6 = this.getRangeValue();
                        this.getAssignedModifiers().add(modifier);
                        return (int)Rounder.roundHalfDown(d4 * (double)n6);
                    }
                }
                if (HeroDesigner.getActiveTemplate().is6E()) {
                    double d = this.getTotalCost();
                    for (Adder adder : this.getAssignedAdders()) {
                        if (adder.includeInBase() || adder.isCustom()) continue;
                        d -= adder.getTotalCost();
                    }
                    return (int)Rounder.roundHalfUp(d * 10.0);
                }
                return (int)Rounder.roundHalfDown(this.getActiveCost() * 5.0);
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "SKINCONTACTREQUIRED") != null) {
                return 0;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO") != null) {
                GenericObject genericObject = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO");
                if (genericObject.getSelectedOption() != null && genericObject.getSelectedOption().equals("UAA")) {
                    if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "LOS") != null) {
                        return -1;
                    }
                    if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "RANGED") != null) {
                        if (HeroDesigner.getActiveTemplate().is6E()) {
                            double d = this.getTotalCost();
                            for (Adder adder : this.getAssignedAdders()) {
                                if (adder.includeInBase() || adder.isCustom()) continue;
                                d -= adder.getTotalCost();
                            }
                            return (int)Rounder.roundHalfDown(d * 10.0);
                        }
                        return (int)Rounder.roundHalfDown(this.getActiveCost() * 5.0);
                    }
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "RANGED") != null || GenericObject.findObjectByID(this.getAllAssignedModifiers(), "RANGEDRECOMBINATION") != null) {
            Modifier modifier;
            int n;
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV") != null) {
                return -1;
            }
            if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "LOS") != null) {
                return -1;
            }
            if (GenericObject.findObjectByID(this.getAssignedModifiers(), "INCREASEDMAXRANGE") != null && (n = (modifier = (Modifier)GenericObject.findObjectByID(this.getAssignedModifiers(), "INCREASEDMAXRANGE")).getLevels()) > 0) {
                double d = modifier.getLevelValue();
                int n7 = modifier.getLevelPower();
                double d6 = Math.pow(n7, (double)n * d);
                if (d6 > 0.0) {
                    this.getAssignedModifiers().remove(modifier);
                    double d7 = (double)n * modifier.getLevelCost();
                    int n8 = this.getRangeValue();
                    this.getAssignedModifiers().add(modifier);
                    return (int)Rounder.roundHalfDown(d6 * (double)n8);
                }
            }
            if (HeroDesigner.getActiveTemplate().is6E()) {
                double d = this.getTotalCost();
                for (Adder adder : this.getAssignedAdders()) {
                    if (adder.includeInBase() || adder.isCustom()) continue;
                    d -= adder.getTotalCost();
                }
                return (int)Rounder.roundHalfDown(d * 10.0);
            }
            return (int)Rounder.roundHalfDown(this.getActiveCost() * 5.0);
        }
        return 0;
    }

    public double getRealCost() {
        if (this.parent != null) {
            return this.parent.getRealCostForChild(this);
        }
        return this.getRealCostPreList();
    }

    public double getRealCostPreList() {
        Cloneable cloneable;
        this.enhancerApplied = null;
        boolean bl = false;
        double d = this.getActiveCost();
        boolean bl2 = false;
        double d2 = 0.0;
        if (this instanceof MentalAwareness) {
            bl = true;
        } else if (this instanceof TransportFamiliarity) {
            bl = this.getAssignedAdders().size() > 0;
        } else if (this instanceof WeaponFamiliarity) {
            bl = true;
        } else if (this instanceof WeaponElement) {
            bl = true;
        }
        for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
            Modifier modifier = this.getAssignedModifiers().get(i);
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d2 += modifier.getTotalValue();
            bl2 = true;
        }
        if (!bl) {
            ArrayList<Adder> arrayList = this.getAvailableAdders();
            for (int i = 0; i < this.getAssignedAdders().size(); ++i) {
                Adder adder = this.getAssignedAdders().get(i);
                if (GenericObject.findObjectByID(arrayList, adder.getXMLID()) != null && !adder.getXMLID().equalsIgnoreCase("GENERIC_OBJECT") || !(adder.getTotalCost() <= 0.0)) continue;
                bl = true;
                break;
            }
        }
        List list = this.getParentList();
        if (this.getMainPower() != null) {
            list = this.getMainPower().getParentList();
        }
        if (list != null) {
            ArrayList<Modifier> arrayList = list.getAssignedModifiers();
            for (int i = 0; i < arrayList.size(); ++i) {
                cloneable = arrayList.get(i);
                if (((GenericObject)cloneable).getTypes().contains("VPP") || ((GenericObject)cloneable).getXMLID().equals("CHARGES") && this.getParentList() instanceof Multipower || !(((Modifier)cloneable).getTotalValue() < 0.0) || GenericObject.findObjectByID(this.assignedModifiers, ((GenericObject)cloneable).getXMLID()) != null && !((GenericObject)cloneable).getXMLID().equals("GENERIC_OBJECT") && !((GenericObject)cloneable).getXMLID().equals("CUSTOM_MODIFIER") && !((GenericObject)cloneable).getXMLID().equals("MODIFIER")) continue;
                d2 += ((Modifier)cloneable).getTotalValue();
                bl2 = true;
            }
        }
        double d3 = d / (1.0 + Math.abs(d2));
        if (bl2) {
            d3 = Rounder.roundHalfDown(d3);
        }
        if (!(this.getTypes() == null || this.getTypes().size() <= 0 || this instanceof Enhancer || HeroDesigner.getActiveHero() == null || this instanceof Skill && ((Skill)this).levelsOnly())) {
            Enhancer enhancer;
            int n;
            cloneable = HeroDesigner.getActiveHero().getSkills();
            block3: for (n = 0; n < ((ArrayList)cloneable).size(); ++n) {
                if (!(((ArrayList)cloneable).get(n) instanceof Enhancer)) continue;
                enhancer = (Enhancer)((ArrayList)cloneable).get(n);
                for (String string : this.getTypes()) {
                    if (!enhancer.appliesToType(string)) continue;
                    this.enhancerApplied = enhancer;
                    if (!enhancer.getObjects().contains(this)) {
                        enhancer.getObjects().add(this);
                    }
                    if (d3 > (double)enhancer.getCostSavings()) {
                        d3 -= (double)enhancer.getCostSavings();
                        break block3;
                    }
                    if (!(d3 > 0.0)) break block3;
                    d3 = 1.0;
                    break block3;
                }
            }
            cloneable = HeroDesigner.getActiveHero().getPerks();
            block5: for (n = 0; n < ((ArrayList)cloneable).size(); ++n) {
                if (!(((ArrayList)cloneable).get(n) instanceof Enhancer)) continue;
                enhancer = (Enhancer)((ArrayList)cloneable).get(n);
                for (String string : this.getTypes()) {
                    if (!enhancer.appliesToType(string)) continue;
                    this.enhancerApplied = enhancer;
                    if (d3 > (double)enhancer.getCostSavings()) {
                        d3 -= (double)enhancer.getCostSavings();
                        break block5;
                    }
                    if (!(d3 > 0.0)) break block5;
                    d3 = 1.0;
                    break block5;
                }
            }
        }
        if (!(this instanceof Adder || this instanceof Modifier || this instanceof Disadvantage || this instanceof EnduranceReserveRecovery)) {
            if (d3 < 1.0 && (d > 0.0 || this.getLevels() > 0 && this.getAssignedAdders().size() == 0 && this.getBaseCost() >= 0.0) && !bl) {
                d3 = 1.0;
            }
            if (d3 < 1.0 && !bl) {
                d3 = 1.0;
            }
        }
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d3 *= this.getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && list != null && list.getMultiplier() != 1.0) {
            d3 *= list.getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        }
        if (this.getQuantity() > 1) {
            int n = 0;
            for (double d4 = (double)this.getQuantity(); d4 > 1.0; d4 /= 2.0) {
                ++n;
            }
            d3 += (double)(n * 5);
        }
        return d3;
    }

    public Element getSaveXML() {
        Element element = new Element("GENERIC_OBJECT");
        return element;
    }

    public Adder getSelectedOption() {
        if (this.selectedOption == null && this.options != null && this.options.size() > 0) {
            this.selectedOption = this.options.get(0);
        }
        return this.selectedOption;
    }

    public String getSortingValue() {
        return this.toString();
    }

    public String getTableColumn2Output(int n) {
        Object object2;
        if (this instanceof CompoundPower) {
            object2 = (CompoundPower)this;
            for (GenericObject object3 : ((CompoundPower)object2).getPowers()) {
                if (!object3.appAdjusted) continue;
                this.appAdjusted = true;
                break;
            }
        }
        object2 = "";
        if (this.appAdjusted) {
            object2 = " color=\"red\" ";
        } else if (!this.getTextOutput().equals(this.getColumn2Output())) {
            object2 = " color=\"blue\" ";
        }
        Object object4 = "<html><table width=" + n + " cellpadding=0 cellspacing=0 border=0><tr>";
        String string = this.getTextOutput();
        if (this.getParentList() != null) {
            object4 = (String)object4 + "<td width=\"35\" valign=\"top\" align=\"right\"" + (String)object2 + ">&nbsp;" + this.getParentList().getColumn2Prefix(this).trim() + "&nbsp;&nbsp;</td>";
            object4 = (String)object4 + "<td valign=\"top\" align=\"left\" colspan=2 width=" + (n - 35) + (String)object2 + ">" + string + this.getParentList().getColumn2Suffix(this) + "</td></tr>";
        } else {
            object4 = (String)object4 + "<td valign=\"top\" align=\"left\" colspan=3 width=" + n + (String)object2 + ">" + string + "</td></tr>";
        }
        if (this.getNotes() != null && this.getNotes().trim().length() > 0 && this.isIncludeNotesInPrintout()) {
            String string2 = this.getOutputNotes();
            string2 = string2.replaceAll("<", "&lt;");
            string2 = string2.replaceAll(">", "&gt;");
            object4 = (String)object4 + "<tr><td></td><td width=\"10\"></td><td valign=\"top\" align=\"left\" width=" + (this.getParentList() != null ? n - 45 : n - 10) + (String)object2 + "><b>Notes:&nbsp;</b>" + string2 + "</td></tr>";
        } else if (this.getQuantity() > 1) {
            String string3 = "(x" + this.getQuantity() + " number of items)";
            object4 = (String)object4 + "<tr><td></td><td width=\"10\"></td><td valign=\"top\" align=\"left\" width=" + (this.getParentList() != null ? n - 45 : n - 10) + (String)object2 + "><b>Notes:&nbsp;</b>" + string3 + "</td></tr>";
        }
        object4 = (String)object4 + "</table></html>";
        return object4;
    }

    public String getTarget() {
        String string = this.target;
        ArrayList<Modifier> arrayList = this.getAllAssignedModifiers();
        if (GenericObject.findObjectByID(arrayList, "BASEDONCON") != null) {
            string = "DCV";
        }
        if (GenericObject.findObjectByID(arrayList, "UOO") != null) {
            string = "DCV";
        }
        if (GenericObject.findObjectByID(arrayList, "BOECV") != null) {
            string = "ECV";
        }
        if (GenericObject.findObjectByID(arrayList, "AOE") != null) {
            string = "HEX";
        }
        if (GenericObject.findObjectByID(arrayList, "EXPLOSION") != null) {
            string = "HEX";
        }
        if (GenericObject.findObjectByID(arrayList, "SELFONLY") != null && !(this instanceof MentalIllusions)) {
            string = "SELFONLY";
        }
        return string;
    }

    public double getTotalCost() {
        double d = this.getBaseCost();
        ArrayList<Adder> arrayList = this.getAvailableAdders();
        if (this.getLevelValue() != 0.0) {
            double d2 = Math.floor((double)this.getLevels() / this.getLevelValue());
            if ((double)this.getLevels() % this.getLevelValue() != 0.0 && this.getLevelValue() > 1.0) {
                d2 += 1.0;
            }
            d += d2 * this.getLevelCost();
            if (this.getLevelCost() < this.getLevelValue()) {
                d = d > 0.0 && d < 1.0 ? 1.0 : (double)Rounder.roundHalfDown(d);
            }
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (!adder.isRequired()) continue;
            d += adder.getRealCost();
        }
        for (Adder adder : this.getAssignedAdders()) {
            if (adder.isRequired() || GenericObject.findObjectByID(arrayList, adder.getXMLID()) == null) continue;
            d += adder.getRealCost();
        }
        if (d < this.getMinimumCost() && this.isMinSet()) {
            d = this.getMinimumCost();
        } else if (d > this.getMaxCost() && this.isMaxSet()) {
            d = this.getMaxCost();
        }
        Object object = this.getAssignedAdders().iterator();
        while (object.hasNext()) {
            Adder adder;
            adder = object.next();
            if (adder.isRequired() || GenericObject.findObjectByID(arrayList, adder.getXMLID()) != null) continue;
            d += adder.getRealCost();
        }
        if (this.getTypes().contains("DEFENSE") && HeroDesigner.getActiveHero() != null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON") != null && ((GenericObject)(object = (Automaton)GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "AUTOMATON"))).getSelectedOption().getXMLID().toUpperCase().startsWith("NOSTUN")) {
            d *= (double)((Automaton)object).getDefenseCostMultiplier();
        }
        return d;
    }

    public ArrayList<String> getTypes() {
        GenericObject genericObject;
        if (this.types == null) {
            this.types = new ArrayList();
        }
        ArrayList arrayList = (ArrayList)this.types.clone();
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO") != null && (genericObject = GenericObject.findObjectByID(this.getAllAssignedModifiers(), "UOO")).getSelectedOption() != null && genericObject.getSelectedOption().getXMLID().equals("UAA")) {
            arrayList.add("ATTACK");
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BOECV") != null) {
            arrayList.add("MENTAL");
        }
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "ABSORPTIONASDEFENSE") != null) {
            arrayList.add("DEFENSE");
        }
        return arrayList;
    }

    public boolean getUseENDReserve() {
        if (HeroDesigner.getActiveHero() == null) {
            return false;
        }
        if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(), "ENDURANCERESERVE") == null && GenericObject.findObjectByID(HeroDesigner.getActiveHero().getEquipment(), "ENDURANCERESERVE") == null) {
            return false;
        }
        if (this.getEndUsage() == 0) {
            return false;
        }
        return this.useENDReserve;
    }

    public double getWeight() {
        if (!HeroDesigner.getInstance().getPrefs().isMetric()) {
            return this.weight;
        }
        return this.weight * 453.5924 / 1000.0;
    }

    public double getTotalWeight() {
        return (double)this.getQuantity() * this.getWeight();
    }

    public String getXMLID() {
        Hashtable<String, String> hashtable;
        if (this.xmlID == null) {
            this.xmlID = "GENERIC_OBJECT";
        }
        if ((hashtable = GenericObject.getIDTranslations()).get(this.xmlID) != null) {
            return hashtable.get(this.xmlID);
        }
        return this.xmlID;
    }

    public boolean includedInTemplate() {
        if (!this.includedInTemplate) {
            return false;
        }
        if (HeroDesigner.getInstance().getPrefs().getSources().size() > 0) {
            for (String string : HeroDesigner.getInstance().getPrefs().getSources()) {
                if (!this.sources.contains(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setContinuingEffect(boolean bl) {
        this.continuingEffect = bl;
    }

    public boolean continuingEffect() {
        return this.continuingEffect;
    }

    public void setCostsENDToMaintain(boolean bl) {
        this.costsENDToMaintain = bl;
    }

    public boolean costsENDToMaintain() {
        if (GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSENDTOMAINTAIN") != null) {
            return true;
        }
        if (!this.getDuration().equals("INSTANT")) {
            Modifier modifier;
            if (GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSEND") != null && (modifier = (Modifier)GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSEND")).getSelectedOption() != null && modifier.getSelectedOption().getXMLID().equals("ACTIVATE")) {
                return false;
            }
            if (GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSENDONLYTOACTIVATE") != null) {
                return false;
            }
            if (this.getEndUsage() <= 0) {
                return false;
            }
            return this.costsENDToMaintain;
        }
        return GenericObject.findObjectByID(this.getAssignedModifiers(), "COSTSENDTOMAINTAIN") != null;
    }

    protected void init(Element element) {
        Object object;
        Object object22;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        ++idCount;
        this.isPrefab = false;
        this.availableModifiers = new ArrayList();
        this.assignedModifiers = new ArrayList();
        this.availableAdders = new ArrayList();
        this.assignedAdders = new ArrayList();
        this.types = new ArrayList();
        this.examples = new ArrayList();
        this.exclusive = true;
        this.definition = "N/A";
        this.display = "";
        this.origDisplay = "";
        this.abbreviation = "";
        this.alias = null;
        this.baseCost = 0.0;
        this.levelCost = 0.0;
        this.levelValue = -1.0;
        this.levelPower = 1;
        this.levelMultiplier = 1;
        this.minimumCost = -9999.0;
        this.multiplier = 1.0;
        this.minimumLevel = 0;
        this.maxLevel = 9999;
        this.maxCost = 9999.0;
        this.range = "SELF";
        this.showOption = true;
        this.levels = 0;
        this.notes = "";
        this.includeNotesInPrintout = true;
        this.parentID = 0L;
        this.parent = null;
        this.position = -1;
        this.price = 0.0;
        this.weight = 0.0;
        this.carried = true;
        this.dynamicDisplay = false;
        this.enhancerApplied = null;
        this.options = new ArrayList();
        this.fixedValue = true;
        this.minSet = false;
        this.maxSet = false;
        this.name = "";
        this.ultra = true;
        this.input = "";
        this.allowsOtherModifiers = true;
        this.allowsOtherAdders = true;
        this.displayActiveCost = HeroDesigner.getInstance().getPrefs().displayActivePoints();
        this.defense = "NONE";
        this.doesBODY = false;
        this.killing = false;
        this.visible = false;
        this.usesEND = false;
        this.doesDamage = false;
        this.doesKnockback = false;
        this.target = "N/A";
        this.stopSign = false;
        this.warnSign = false;
        this.showBuildDialog = true;
        this.sources = new ArrayList();
        String string8 = XMLUtility.getValue(element, "EXCLUSIVE");
        this.exclusive = string8 == null || !string8.toUpperCase().trim().startsWith("N");
        String string9 = XMLUtility.getValue(element, "DEFINITION");
        if (string9 != null) {
            this.definition = string9;
        }
        this.costsENDToMaintain = (string9 = XMLUtility.getValue(element, "COSTSENDTOMAINTAIN")) == null || !string9.trim().toUpperCase().startsWith("N");
        string9 = XMLUtility.getValue(element, "CONTINUINGEFFECT");
        this.continuingEffect = string9 != null && string9.trim().toUpperCase().startsWith("Y");
        string9 = XMLUtility.getValue(element, "DURATION");
        if (string9 != null && string9.trim().length() > 0) {
            this.duration = string9;
        }
        if ((string9 = XMLUtility.getValue(element, "SHOWDIALOG")) != null && string9.trim().toUpperCase().startsWith("N")) {
            this.showBuildDialog = false;
        }
        if ((string9 = XMLUtility.getValue(element, "DISPLAY")) != null) {
            this.display = string9;
            this.origDisplay = string9;
        }
        if ((string9 = XMLUtility.getValue(element, "TARGET")) != null && string9.trim().length() > 0) {
            this.target = string9.trim().toUpperCase();
        }
        this.abbreviation = (string9 = XMLUtility.getValue(element, "ABBREVIATION")) != null && element.getAttribute("ABBREVIATION") != null ? string9 : this.display;
        string9 = XMLUtility.getValue(element, "WGABBREVIATION");
        this.wgAbbreviation = string9 != null && element.getAttribute("WGABBREVIATION") != null ? string9 : this.display;
        string9 = XMLUtility.getValue(element, "XMLID");
        if (string9 != null && string9.trim().length() > 0) {
            this.xmlID = string9;
        }
        if ((string9 = XMLUtility.getValue(element, "ALIAS")) != null && element.getAttribute("ALIAS") != null) {
            this.alias = string9;
            if (this.abbreviation.equals(this.display)) {
                this.abbreviation = string9;
            }
            if (this.wgAbbreviation.equals(this.display)) {
                this.wgAbbreviation = string9;
            }
        } else {
            this.alias = HeroDesigner.getInstance().getPrefs().useWG() && HeroDesigner.getInstance().getPrefs().useAbbreviations() && this.wgAbbreviation != null ? this.wgAbbreviation : (!HeroDesigner.getInstance().getPrefs().useWG() && HeroDesigner.getInstance().getPrefs().useAbbreviations() && this.abbreviation != null ? this.abbreviation : this.display);
        }
        if ((string9 = XMLUtility.getValue(element, "DEFENSE")) != null && string9.trim().length() > 0) {
            this.defense = string9;
        }
        if ((string9 = XMLUtility.getValue(element, "RANGE")) != null && string9.trim().length() > 0) {
            this.range = string9;
        }
        if ((string9 = XMLUtility.getValue(element, "STOPSIGN")) != null && string9.trim().toUpperCase().startsWith("Y")) {
            this.stopSign = true;
        }
        if ((string9 = XMLUtility.getValue(element, "SHOWOPTION")) != null && string9.trim().toUpperCase().startsWith("N")) {
            this.showOption = false;
        }
        if ((string9 = XMLUtility.getValue(element, "WARNSIGN")) != null && string9.trim().toUpperCase().startsWith("Y")) {
            this.warnSign = true;
        }
        if ((string9 = XMLUtility.getValue(element, "DOESBODY")) != null && string9.trim().toUpperCase().startsWith("Y")) {
            this.doesBODY = true;
        }
        if ((string9 = XMLUtility.getValue(element, "KILLING")) != null && string9.trim().toUpperCase().startsWith("Y")) {
            this.killing = true;
        }
        if ((string9 = XMLUtility.getValue(element, "VISIBLE")) != null && string9.trim().toUpperCase().startsWith("Y")) {
            this.visible = true;
        }
        if ((string9 = XMLUtility.getValue(element, "USESEND")) != null && string9.trim().toUpperCase().startsWith("Y")) {
            this.usesEND = true;
        }
        if ((string9 = XMLUtility.getValue(element, "DOESDAMAGE")) != null && string9.trim().toUpperCase().startsWith("Y")) {
            this.doesDamage = true;
        }
        if ((string9 = XMLUtility.getValue(element, "DOESKNOCKBACK")) != null && string9.trim().toUpperCase().startsWith("Y")) {
            this.doesKnockback = true;
        }
        this.fixedValue = (string9 = XMLUtility.getValue(element, "FIXEDVALUE")) == null || !string9.trim().toUpperCase().startsWith("N");
        string9 = XMLUtility.getValue(element, "PRICE");
        if (string9 != null) {
            try {
                this.price = Double.parseDouble(string9);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string9 = XMLUtility.getValue(element, "WEIGHT")) != null) {
            try {
                this.weight = Double.parseDouble(string9);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.carried = (string9 = XMLUtility.getValue(element, "CARRIED")) == null || !string9.trim().toUpperCase().startsWith("N");
        String string10 = XMLUtility.getValue(element, "BASECOST");
        if (string10 != null) {
            try {
                this.origBaseCost = this.baseCost = Double.parseDouble(string10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string7 = XMLUtility.getValue(element, "LVLCOST")) != null) {
            try {
                this.levelCost = Double.parseDouble(string7);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string6 = XMLUtility.getValue(element, "LVLVAL")) != null) {
            try {
                this.levelValue = Double.parseDouble(string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string5 = XMLUtility.getValue(element, "LVLPOWER")) != null) {
            try {
                this.levelPower = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string4 = XMLUtility.getValue(element, "LVLMULTIPLIER")) != null) {
            try {
                this.levelMultiplier = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string3 = XMLUtility.getValue(element, "LEVELSTART")) != null) {
            try {
                this.levels += Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string2 = XMLUtility.getValue(element, "MINCOST")) != null) {
            try {
                this.minimumCost = Double.parseDouble(string2);
                this.minSet = true;
            }
            catch (Exception exception) {
                this.minimumCost = this.baseCost;
                this.minSet = false;
            }
        } else {
            this.minimumCost = this.baseCost;
            this.minSet = false;
        }
        if ((string2 = XMLUtility.getValue(element, "MAXCOST")) != null) {
            try {
                this.maxCost = Double.parseDouble(string2);
                this.maxSet = true;
            }
            catch (Exception exception) {
                this.maxCost = this.baseCost;
                this.maxSet = false;
            }
        } else {
            this.maxCost = this.baseCost;
            this.maxSet = false;
        }
        if ((string = XMLUtility.getValue(element, "MINVAL")) != null) {
            try {
                this.minimumLevel = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "MAXVAL")) != null) {
            try {
                this.maxLevel = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        java.util.List list = element.getChildren("ADDER");
        for (Object object22 : list) {
            object = new Adder((Element)object22);
            if (!((Adder)object).includedInTemplate()) continue;
            this.availableAdders.add((Adder)object);
        }
        list = element.getChildren("SOURCE");
        for (Object object22 : list) {
            object = ((Element)object22).getTextTrim();
            if (!this.sources.contains(object)) {
                this.sources.add((String)object);
            }
            if (allSources.contains(object)) continue;
            allSources.add((String)object);
        }
        if (this.sources.size() == 0) {
            this.sources.add("Hero System Fifth Edition Rule Book");
        }
        list = element.getChildren("MODIFIER");
        for (Object object22 : list) {
            object = Modifier.getInstance((Element)object22);
            if (object == null || !((GenericObject)object).includedInTemplate()) continue;
            this.availableModifiers.add((Modifier)object);
        }
        object22 = element.getChildren("TYPE");
        Iterator iterator = object22.iterator();
        this.types = new ArrayList();
        while (iterator.hasNext()) {
            object = (Element)iterator.next();
            this.types.add(((Element)object).getText());
        }
        object = XMLUtility.getValue(element, "POSITION");
        if (object != null && ((String)object).trim().length() > 0) {
            try {
                this.position = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string9 = XMLUtility.getValue(element, "APPEREND")) != null && string9.trim().length() > 0) {
            try {
                this.apperend = Integer.parseInt(string9);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.apperend = -1;
        }
        this.allowsOtherModifiers = (string9 = XMLUtility.getValue(element, "ALLOWSOTHERMODIFIERS")) != null && string9.trim().length() > 0 ? !string9.trim().toUpperCase().startsWith("N") : true;
        string9 = XMLUtility.getValue(element, "ALLOWSOTHERADDERS");
        this.allowsOtherAdders = string9 != null && string9.trim().length() > 0 ? !string9.trim().toUpperCase().startsWith("N") : true;
        list = element.getChildren("EXAMPLE");
        iterator = list.iterator();
        this.examples = new ArrayList();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            boolean bl = true;
            if (element2.getChildren("SOURCE") != null) {
                bl = false;
                Iterator iterator2 = element2.getChildren("SOURCE").iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    ++n;
                    Element element3 = (Element)iterator2.next();
                    if (!GenericObject.getAllSources().contains(element3.getTextTrim())) {
                        GenericObject.getAllSources().add(element3.getTextTrim());
                    }
                    if (!HeroDesigner.getInstance().getPrefs().getSources().contains(element3.getTextTrim())) continue;
                    bl = true;
                    break;
                }
                if (n == 0) {
                    bl = HeroDesigner.getInstance().getPrefs().getSources().contains("Hero System Fifth Edition Rule Book");
                }
            }
            if (!bl) continue;
            this.examples.add(element2.getText().trim());
        }
        if (this.examples.size() > 0) {
            Collections.sort(this.examples);
            this.input = this.examples.get(0).toString();
        }
        if ((string9 = XMLUtility.getValue(element, "OPTIONLABEL")) != null && string9.trim().length() > 0) {
            this.optionLbl = string9;
        }
        if ((string9 = XMLUtility.getValue(element, "LEVELSLABEL")) != null && string9.trim().length() > 0) {
            this.levelsLbl = string9;
        }
        if ((string9 = XMLUtility.getValue(element, "INPUTLABEL")) != null && string9.trim().length() > 0) {
            this.inputLabel = string9;
            this.userInput = true;
        } else {
            this.inputLabel = null;
            this.userInput = false;
        }
        string9 = XMLUtility.getValue(element, "OTHERINPUT");
        this.otherInputAllowed = string9 != null && string9.trim().toUpperCase().startsWith("Y");
        this.setDisplay(this.display);
        list = element.getChildren("OPTION");
        for (Element element2 : list) {
            Adder adder = new Adder(element2);
            if (!adder.includedInTemplate()) continue;
            this.options.add(adder);
        }
        if (this.options.size() > 0) {
            this.setSelectedOption(this.options.get(0));
        }
        if (this.alias == null || this.alias.trim().length() == 0) {
            this.alias = this.getDisplay();
        }
    }

    public ArrayList<String> getSources() {
        if (this.sources.size() == 0) {
            this.sources.add("Hero System Fifth Edition Rule Book");
        }
        return this.sources;
    }

    public static ArrayList<String> getAllSources() {
        if (!allSources.contains("Hero System Fifth Edition Rule Book")) {
            allSources.add("Hero System Fifth Edition Rule Book");
        }
        return allSources;
    }

    public boolean isCarried() {
        return this.carried;
    }

    public boolean isDynamicDisplay() {
        return this.dynamicDisplay;
    }

    public boolean isEquipment() {
        if (this.getMainPower() != null) {
            return false;
        }
        return this.isEquipment;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isFixedValue() {
        return this.fixedValue;
    }

    public boolean isIncludeNotesInPrintout() {
        return this.includeNotesInPrintout;
    }

    public boolean isKilling() {
        boolean bl = this.killing;
        return bl;
    }

    public boolean isMaxSet() {
        return this.maxSet;
    }

    public boolean isMinSet() {
        return this.minSet;
    }

    public boolean isOtherInputAllowed() {
        return this.otherInputAllowed;
    }

    public boolean isPower() {
        if (this.isEquipment()) {
            return true;
        }
        if (this.getMainPower() != null) {
            return this.getMainPower().isPower();
        }
        return this.isPower;
    }

    public boolean isStopSign() {
        return this.stopSign;
    }

    public boolean isUltra() {
        return this.ultra;
    }

    public boolean isUserInput() {
        return this.userInput;
    }

    public boolean isVisible() {
        boolean bl = this.visible;
        if (GenericObject.findObjectByID(this.getAllAssignedModifiers(), "BASEDONCON") != null) {
            bl = true;
        }
        if (!bl && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "COSTSEND") != null) {
            bl = true;
        }
        if (!bl && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "VISIBLE") != null) {
            bl = true;
        }
        if (bl && GenericObject.findObjectByID(this.getAllAssignedModifiers(), "INVISIBLE") != null) {
            bl = false;
        }
        return bl;
    }

    public boolean isWarnSign() {
        return this.warnSign;
    }

    public boolean otherInputAllowed() {
        return this.otherInputAllowed;
    }

    public void resetID() {
        this.id = System.currentTimeMillis() + idCount++;
    }

    /*
     * WARNING - void declaration
     */
    public void restoreFromSave(Element element) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = XMLUtility.getValue(element, "ALIAS");
        if (string5 != null) {
            this.alias = string5;
            this.abbreviation = string5;
            this.wgAbbreviation = string5;
        } else if (this.alias == null) {
            this.alias = this.display;
        }
        string5 = XMLUtility.getValue(element, "TEXT");
        this.textOutput = string5 != null ? string5.trim() : null;
        string5 = XMLUtility.getValue(element, "SFX");
        if (string5 != null) {
            this.sfx = string5;
            string5 = XMLUtility.getValue(element, "GRAPHIC");
            this.graphic = string5 != null ? string5 : GenericObject.getGraphicForSFX(this.sfx);
            string5 = XMLUtility.getValue(element, "COLOR");
            this.color = string5 != null ? string5 : GenericObject.getColorForSFX(this.sfx);
        } else {
            string5 = XMLUtility.getValue(element, "GRAPHIC");
            if (string5 != null) {
                this.graphic = string5;
            }
            if ((string5 = XMLUtility.getValue(element, "COLOR")) != null) {
                this.color = string5;
            }
        }
        string5 = XMLUtility.getValue(element, "NOTES");
        this.notes = string5 != null ? string5 : "";
        String string6 = XMLUtility.getValue(element, "LEVELS");
        if (string6 != null && string6.trim().length() > 0) {
            try {
                this.levels = Integer.parseInt(string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string4 = XMLUtility.getValue(element, "BASECOST")) != null && string4.trim().length() > 0) {
            try {
                this.baseCost = Double.parseDouble(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string3 = XMLUtility.getValue(element, "MULTIPLIER")) != null && string3.trim().length() > 0) {
            try {
                this.multiplier = Double.parseDouble(string3);
            }
            catch (Exception exception) {
                this.multiplier = 1.0;
            }
        } else {
            this.multiplier = 1.0;
        }
        if ((string2 = XMLUtility.getValue(element, "ID")) != null && string2.trim().length() > 0) {
            try {
                this.id = Long.parseLong(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string2 = XMLUtility.getValue(element, "PARENTID")) != null && string2.trim().length() > 0) {
            try {
                this.parentID = Long.parseLong(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "POSITION")) != null && string.trim().length() > 0) {
            try {
                this.position = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string5 = XMLUtility.getValue(element, "NAME")) != null && string5.trim().length() > 0) {
            this.name = string5;
        }
        if ((string5 = XMLUtility.getValue(element, "USE_END_RESERVE")) != null && string5.trim().length() > 0) {
            this.useENDReserve = string5.trim().toUpperCase().startsWith("Y");
        }
        if ((string5 = XMLUtility.getValue(element, "PRICE")) != null) {
            try {
                this.price = Double.parseDouble(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string5 = XMLUtility.getValue(element, "WEIGHT")) != null) {
            try {
                this.weight = Double.parseDouble(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.carried = (string5 = XMLUtility.getValue(element, "CARRIED")) == null || !string5.trim().toUpperCase().startsWith("N");
        string5 = XMLUtility.getValue(element, "ULTRA_SLOT");
        if (string5 != null && string5.trim().length() > 0) {
            this.ultra = string5.trim().toUpperCase().startsWith("Y");
        }
        if ((string5 = XMLUtility.getValue(element, "SHOW_ACTIVE_COST")) != null && string5.trim().length() > 0) {
            this.displayActiveCost = string5.trim().toUpperCase().startsWith("Y");
        }
        this.includeNotesInPrintout = (string5 = XMLUtility.getValue(element, "INCLUDE_NOTES_IN_PRINTOUT")) != null && string5.trim().toUpperCase().startsWith("Y");
        string5 = XMLUtility.getValue(element, "OPTIONID");
        if (string5 != null && string5.trim().length() > 0) {
            for (Adder object32 : this.options) {
                if (!object32.getXMLID().equals(string5)) continue;
                Adder adder = object32.clone();
                string5 = XMLUtility.getValue(element, "OPTION_ALIAS");
                if (string5 != null) {
                    adder.setAlias(string5);
                }
                this.setSelectedOption(adder);
                break;
            }
        } else {
            string5 = XMLUtility.getValue(element, "OPTION");
            if (string5 != null && string5.trim().length() > 0) {
                for (Adder adder : this.options) {
                    if (!adder.getDisplay().equals(string5) && !adder.getXMLID().equals(string5)) continue;
                    Adder adder2 = adder.clone();
                    string5 = XMLUtility.getValue(element, "OPTION_ALIAS");
                    if (string5 != null && string5.trim().length() > 0) {
                        adder2.setAlias(string5);
                    }
                    this.setSelectedOption(adder2);
                    break;
                }
            }
        }
        Object object4 = element.getChildren("ADDER");
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            void var11_26;
            object = (Element)iterator.next();
            Adder adder = new Adder((Element)object);
            adder.setAvailableCheck(true);
            boolean bl = false;
            Iterator<GenericObject> iterator2 = this.getAvailableAdders();
            Iterator<Adder> iterator3 = ((ArrayList)((Object)iterator2)).iterator();
            while (iterator3.hasNext()) {
                Adder adder3 = iterator3.next();
                if (!adder3.getXMLID().equals(adder.getXMLID()) && !adder3.equals(adder)) continue;
                adder.setAvailableCheck(false);
                adder3.setAvailableCheck(false);
                Adder adder4 = adder3.clone();
                bl = true;
                break;
            }
            if (!bl) {
                var11_26.setExclusive(false);
            }
            var11_26.setAvailableCheck(false);
            var11_26.restoreFromSave((Element)object);
            if (var11_26.isExclusive()) {
                if (GenericObject.findObjectByID(this.assignedAdders, var11_26.getXMLID()) != null) {
                    this.assignedAdders.set(this.assignedAdders.indexOf(GenericObject.findObjectByID(this.assignedAdders, var11_26.getXMLID())), (Adder)var11_26);
                    continue;
                }
                this.assignedAdders.add((Adder)var11_26);
                continue;
            }
            this.assignedAdders.add((Adder)var11_26);
        }
        object4 = element.getChildren("MODIFIER");
        Iterator iterator4 = object4.iterator();
        while (iterator4.hasNext()) {
            object = (Element)iterator4.next();
            String string7 = XMLUtility.getValue((Element)object, "XMLID");
            Modifier modifier = null;
            if (string7 != null && string7.trim().length() > 0) {
                for (Modifier modifier2 : this.getAvailableModifiers()) {
                    if (!modifier2.getXMLID().equals(string7)) continue;
                    modifier = modifier2.clone();
                    break;
                }
                if (modifier == null) {
                    for (GenericObject genericObject : HeroDesigner.getActiveTemplate().getModifiers()) {
                        if (!genericObject.getXMLID().equals(string7)) continue;
                        modifier = (Modifier)genericObject.clone();
                        break;
                    }
                }
            }
            if (modifier == null) {
                modifier = Modifier.getInstance((Element)object);
            }
            if (modifier == null) continue;
            modifier.setParent(this);
            modifier.restoreFromSave((Element)object);
            if (modifier.getDisplay() == null || modifier.getDisplay().trim().length() == 0) {
                modifier.setDisplay(modifier.getAlias());
            }
            this.assignedModifiers.add(modifier);
        }
        for (Modifier modifier : this.assignedModifiers) {
            modifier.setParent(this);
        }
        object = XMLUtility.getValue(element, "INPUT");
        if (object != null) {
            this.input = object;
        }
        this.setAlias(this.alias);
    }

    public void setAlias(String string) {
        if (HeroDesigner.getInstance().getPrefs().useAbbreviations() && this.abbreviation != null && this.abbreviation.trim().length() > 0) {
            this.abbreviation = string;
        }
        if (HeroDesigner.getInstance().getPrefs().useAbbreviations() && this.wgAbbreviation != null && this.wgAbbreviation.trim().length() > 0) {
            this.wgAbbreviation = string;
        }
        this.alias = string;
        if (string == null) {
            return;
        }
        if (this.display.indexOf("[LVL]") < 0) {
            return;
        }
        String string2 = "" + NumberFormat.getInstance().format(this.getLevels() * this.getLevelMultiplier());
        if (this.levelPower != 1) {
            string2 = "" + NumberFormat.getInstance().format((long)((double)this.getLevelMultiplier() * Math.pow(this.levelPower, this.getLevels())));
        }
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.alias.length(); ++i) {
            char c = this.alias.charAt(i);
            if (Character.isDigit(c) && n == -1) {
                n = i;
                continue;
            }
            if (Character.isDigit(c) || c == ',' || n < 0 || n2 != -1) continue;
            n2 = i;
            break;
        }
        if (n >= 0) {
            String string3;
            if (n2 <= n) {
                n2 = this.alias.length();
            }
            this.adjustAliasWithLevels = (string3 = this.alias.substring(n, n2)).equals(string2);
        }
    }

    public void setAppAdjusted(boolean bl) {
        this.appAdjusted = bl;
    }

    public void setAssignedAdders(ArrayList<Adder> arrayList) {
        this.assignedAdders = arrayList;
    }

    public void setAssignedModifiers(ArrayList<Modifier> arrayList) {
        this.assignedModifiers = arrayList;
    }

    public void setAvailableAdders(ArrayList<Adder> arrayList) {
        this.availableAdders = arrayList;
    }

    public void setAvailableModifiers(ArrayList<Modifier> arrayList) {
        this.availableModifiers = arrayList;
    }

    public void setBaseCost(double d) {
        this.baseCost = d;
    }

    public void setCarried(boolean bl) {
        this.carried = bl;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public void setDisplay(String string) {
        this.display = string;
        this.dynamicDisplay = this.display != null && this.display.indexOf("[LVL]") >= 0;
    }

    public void setDisplayActiveCost(boolean bl) {
        this.displayActiveCost = bl;
    }

    public void setExamples(ArrayList<String> arrayList) {
        this.examples = arrayList;
    }

    public void setExclusive(boolean bl) {
        this.exclusive = bl;
    }

    public void setFixedValue(boolean bl) {
        this.fixedValue = bl;
    }

    public void setID(long l) {
        this.id = l;
    }

    public void setIncludeNotesInPrintout(boolean bl) {
        this.includeNotesInPrintout = bl;
    }

    public void setInput(String string) {
        this.input = string;
    }

    public void setInputExamples(ArrayList<String> arrayList) {
        this.examples = arrayList;
    }

    public void setIsEquipment(boolean bl) {
        this.isEquipment = bl;
    }

    public void setIsPrefab(boolean bl) {
        this.isPrefab = bl;
    }

    public boolean getIsPrefab() {
        return this.isPrefab;
    }

    public void setLevelCost(double d) {
        this.levelCost = d;
    }

    public void setLevelMultiplier(int n) {
        this.levelMultiplier = n;
    }

    public void setLevelPower(int n) {
        this.levelPower = n;
    }

    public void setLevels(int n) {
        this.levels = n < this.minimumLevel ? this.minimumLevel : (n > this.maxLevel ? this.maxLevel : n);
    }

    public void setLevelValue(double d) {
        this.levelValue = d;
    }

    public void setMainPower(CompoundPower compoundPower) {
        this.mainPower = compoundPower;
    }

    public void setMaxCost(double d) {
        this.maxCost = d;
        this.maxSet = true;
    }

    public void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    public void setMinimumCost(double d) {
        this.minimumCost = d;
    }

    public void setMinimumLevel(int n) {
        this.minimumLevel = n;
    }

    public void setMultiplier(double d) {
        this.multiplier = d;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNotes(String string) {
        this.notes = string;
    }

    public void setOptions(ArrayList<Adder> arrayList) {
        this.options = arrayList;
    }

    public void setParent(List list) {
        this.parent = list;
        this.parentID = list != null ? list.getID() : -1L;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public void setPower(boolean bl) {
        this.isPower = bl;
    }

    public void setPrice(double d) {
        if (HeroDesigner.getActiveHero() == null) {
            return;
        }
        this.price = d * HeroDesigner.getActiveHero().getRules().getEquipmentCostConversion();
    }

    public void setSelectedOption(Adder adder) {
        if (adder != null) {
            long l = adder.getID();
            adder = adder.clone();
            adder.setID(l);
        }
        Adder adder2 = this.selectedOption;
        this.selectedOption = adder;
        if (adder == null) {
            return;
        }
        if (adder2 != null && this.selectedOption != null && adder2.getXMLID().equals(this.selectedOption.getXMLID()) && !adder2.isFixedValue()) {
            this.selectedOption.setBaseCost(adder2.getBaseCost());
        }
        if (this.options != null && adder != null) {
            for (Adder adder3 : this.options) {
                if (adder3.getXMLID().equals(adder.getXMLID())) {
                    adder3.setSelected(true);
                    continue;
                }
                adder3.setSelected(false);
            }
        }
        this.selectedOption.setSelected(true);
        this.setBaseCost(adder.getBaseCost());
        if (adder.isMinSet()) {
            this.setMinimumCost(adder.getMinimumCost());
            this.minSet = true;
        }
        if (adder.isMaxSet()) {
            this.setMaxCost(adder.getMaxCost());
            this.maxSet = true;
        }
        if (adder.getLevelCost() > 0.0) {
            this.setLevelCost(adder.getLevelCost());
        }
        if (adder.getLevelMultiplier() > 0) {
            this.setLevelMultiplier(adder.getLevelMultiplier());
        }
        if (adder.getLevelPower() > 1) {
            this.setLevelPower(adder.getLevelPower());
        }
        if (adder.getLevelValue() != 0.0) {
            this.setLevelValue(adder.getLevelValue());
        }
        if (adder.getMinimumLevel() != 0) {
            this.setMinimumLevel(adder.getMinimumLevel());
        }
        if (adder.getDefinition() != null && adder.getDefinition().trim().length() > 0) {
            this.setDefinition(adder.getDefinition());
        }
        if (adder.getTypes() != null && adder.getTypes().size() > 0) {
            this.setTypes(adder.getTypes());
        }
        if (adder.getExamples() != null && adder.getExamples().size() > 0) {
            this.setExamples(adder.getExamples());
        }
        this.allowsOtherModifiers = adder.allowsOtherModifiers();
        this.allowsOtherAdders = adder.allowsOtherAdders();
        block1: for (Adder adder3 : adder.getAvailableAdders()) {
            for (Adder adder4 : this.getAssignedAdders()) {
                if (!adder4.getXMLID().equals(adder3.getXMLID())) continue;
                adder4.setBaseCost(adder3.getBaseCost());
                continue block1;
            }
        }
        if (adder2 != null) {
            block3: for (int i = this.getAssignedAdders().size() - 1; i >= 0; --i) {
                Adder adder3;
                adder3 = this.getAssignedAdders().get(i);
                if (GenericObject.findObjectByID(adder2.getAvailableAdders(), adder3.getXMLID()) == null) continue;
                for (Adder adder4 : adder.getAvailableAdders()) {
                    if (!adder4.getXMLID().equals(adder3.getXMLID())) continue;
                    adder4.setBaseCost(adder3.getBaseCost());
                    continue block3;
                }
                this.getAssignedAdders().remove(adder3);
            }
        }
    }

    public void setTypes(ArrayList<String> arrayList) {
        this.types = arrayList;
    }

    public void setUltra(boolean bl) {
        this.ultra = bl;
    }

    public void setUseENDReserve(boolean bl) {
        this.useENDReserve = bl;
    }

    public void setUserInput(boolean bl) {
        this.userInput = bl;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setWeight(double d) {
        double d2 = d;
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            d2 = d * 1000.0 / 453.5924;
        }
        if (this.weight == d2) {
            return;
        }
        this.weight = d2;
    }

    public void setXMLID(String string) {
        this.xmlID = string;
    }

    public boolean showBuildDialog() {
        if (this.isPower() || !HeroDesigner.getInstance().getPrefs().useQuickAssign()) {
            return true;
        }
        return this.showBuildDialog;
    }

    public String toString() {
        String string = "";
        boolean bl = HeroDesigner.getInstance().getPrefs().useAbbreviations();
        HeroDesigner.getInstance().getPrefs().setUseAbbreviations(false);
        string = this.getDisplay();
        if (this.isPrefab) {
            string = "<html>" + this.getTextOutput() + "<br><b>Real Cost: " + Rounder.roundUp(this.getRealCost()) + "</b></html>";
        }
        HeroDesigner.getInstance().getPrefs().setUseAbbreviations(bl);
        return string;
    }

    public boolean usesEND() {
        Cloneable cloneable;
        boolean bl = this.usesEND;
        if (this.apperend != -1) {
            this.usesEND = this.apperend > 0;
        }
        ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
        arrayList.addAll(this.getAssignedModifiers());
        List list = this.getParentList();
        if (this.getMainPower() != null) {
            list = this.getMainPower().getParentList();
        }
        if (list != null) {
            cloneable = list.getAssignedModifiers();
            arrayList.addAll((Collection<Modifier>)((Object)cloneable));
        }
        if (GenericObject.findObjectByID(arrayList, "CHARGES") != null) {
            bl = false;
        }
        if (GenericObject.findObjectByID(arrayList, "COSTSEND") != null) {
            bl = true;
        }
        if (GenericObject.findObjectByID(arrayList, "REDUCEDEND") != null) {
            cloneable = (Modifier)GenericObject.findObjectByID(arrayList, "REDUCEDEND");
            bl = ((GenericObject)cloneable).getSelectedOption().getXMLID().equals("HALFEND");
        }
        return bl;
    }

    public boolean verifyModifiers() {
        HeroDesigner.lastEdit = System.currentTimeMillis();
        if (this instanceof CompoundPower) {
            CompoundPower compoundPower = (CompoundPower)this;
            for (GenericObject cloneable2 : compoundPower.getPowers()) {
                boolean string = cloneable2.verifyModifiers();
                if (string) continue;
                this.appAdjusted = true;
                return false;
            }
        }
        boolean bl = true;
        if (!HeroDesigner.getInstance().getPrefs().checkModsDuringEdit() || this instanceof Disadvantage) {
            return bl;
        }
        boolean bl2 = HeroDesigner.getInstance().getPrefs().removeIllegalMods();
        ArrayList<Modifier> arrayList = this.getAssignedModifiers();
        String string = "";
        if (!HeroDesigner.getAppFrame().isShowing()) {
            string = "Invalid modifier found on " + HeroDesigner.getActiveHero().getCharacterName() + ":\n\n";
        }
        if (this instanceof List && ((List)this).getObjects().size() > 0) {
            Object characteristic;
            boolean i = false;
            ArrayList<Modifier> modifier = arrayList;
            ArrayList<GenericObject> string6 = ((List)this).getObjects();
            for (GenericObject j : string6) {
                Object object2;
                Cloneable cloneable2;
                ArrayList<Object> arrayList2;
                if (j instanceof Maneuver) {
                    i = true;
                }
                if (j instanceof CompoundPower) {
                    characteristic = (CompoundPower)j;
                    ((CompoundPower)characteristic).setParent(null);
                    for (int arrayList4 = 0; arrayList4 < ((CompoundPower)characteristic).getPowers().size(); ++arrayList4) {
                        j = ((CompoundPower)characteristic).getPowers().get(arrayList4);
                        j.setParent(null);
                        arrayList2 = j.getAssignedModifiers();
                        ArrayList<Modifier> iterator = new ArrayList<Modifier>();
                        iterator.addAll(arrayList2);
                        cloneable2 = new ArrayList();
                        for (Object object2 : modifier) {
                            if (GenericObject.findObjectByID(arrayList2, ((GenericObject)object2).getXMLID()) != null) continue;
                            ((ArrayList)cloneable2).add(object2);
                        }
                        iterator.addAll((Collection<Modifier>)((Object)cloneable2));
                        j.setAssignedModifiers(iterator);
                        for (int string4 = ((ArrayList)cloneable2).size() - 1; string4 >= 0; --string4) {
                            String string2;
                            object2 = (Modifier)((ArrayList)cloneable2).get(string4);
                            iterator.remove(object2);
                            arrayList.remove(object2);
                            j.setAssignedModifiers(iterator);
                            if (!j.allowsOtherModifiers()) {
                                string2 = string + "The Common Modifier " + ((GenericObject)object2).getAlias() + " is not a legal modifier on the slot " + (j.getName().trim().length() > 0 ? j.getName() + ": " + j.getAlias() : j.getAlias()) + ".  Reason:\n\n" + j.getAlias() + " does not allow modifiers with its current configuration.\n\n" + (bl2 ? ((GenericObject)object2).getAlias() + " will be removed from the List " + this.getAlias() + "." : "");
                                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), string2, "Modifier not allowed on ability", 2);
                                this.appAdjusted = true;
                                if (bl2) {
                                    continue;
                                }
                            } else {
                                j.setListModCheck(true);
                                string2 = ((Modifier)object2).included(j);
                                j.setListModCheck(false);
                                if (string2.trim().length() > 0) {
                                    j.setListModCheck(true);
                                    string2 = ((Modifier)object2).included(j);
                                    j.setListModCheck(false);
                                    String string3 = string + "The Common Modifier " + ((GenericObject)object2).getAlias() + " is not a legal modifier on " + (this.getName().trim().length() > 0 ? this.getName() + ": " + this.getAlias() : this.getAlias()) + ".  Reason:\n\n" + string2 + "\n\n" + (bl2 ? ((GenericObject)object2).getAlias() + " will be removed from the List " + this.getAlias() + "." : "");
                                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), string3, "Modifier not allowed on ability", 2);
                                    this.appAdjusted = true;
                                    if (bl2) {
                                        bl = false;
                                        continue;
                                    }
                                }
                            }
                            iterator.add(string4, (Modifier)object2);
                            if (!((GenericObject)object2).getXMLID().equals("MODIFIER") && ((GenericObject)object2).isExclusive() && GenericObject.findObjectByID(arrayList, ((GenericObject)object2).getXMLID()) != null) continue;
                            arrayList.add(string4, (Modifier)object2);
                        }
                        j.setAssignedModifiers(arrayList2);
                        j.setParent((List)this);
                        this.setAssignedModifiers(arrayList);
                    }
                    ((CompoundPower)characteristic).setParent((List)this);
                    continue;
                }
                characteristic = j.getAssignedModifiers();
                ArrayList<Modifier> string5 = new ArrayList<Modifier>();
                string5.addAll((Collection<Modifier>)characteristic);
                arrayList2 = new ArrayList();
                for (Cloneable cloneable2 : modifier) {
                    if (GenericObject.findObjectByID((ArrayList<? extends GenericObject>)characteristic, ((GenericObject)cloneable2).getXMLID()) != null) continue;
                    arrayList2.add(cloneable2);
                }
                string5.addAll(arrayList2);
                j.setAssignedModifiers(string5);
                j.setParent(null);
                for (int k = arrayList2.size() - 1; k >= 0; --k) {
                    String string4;
                    cloneable2 = (Modifier)arrayList2.get(k);
                    string5.remove(cloneable2);
                    arrayList.remove(cloneable2);
                    j.setAssignedModifiers(string5);
                    if (!j.allowsOtherModifiers()) {
                        string4 = string + "The Common Modifier " + ((GenericObject)cloneable2).getAlias() + " is not a legal modifier on the slot " + (j.getName().trim().length() > 0 ? j.getName() + ": " + j.getAlias() : j.getAlias()) + ".  Reason:\n\n" + j.getAlias() + " does not allow modifiers with its current configuration.\n\n" + (bl2 ? ((GenericObject)cloneable2).getAlias() + " will be removed from the List " + this.getAlias() + "." : "");
                        JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), string4, "Modifier not allowed on ability", 2);
                        this.appAdjusted = true;
                        if (bl2) {
                            continue;
                        }
                    } else {
                        j.setListModCheck(true);
                        string4 = ((Modifier)cloneable2).included(j);
                        j.setListModCheck(false);
                        if (string4.trim().length() > 0) {
                            object2 = string + "The Common Modifier " + ((GenericObject)cloneable2).getAlias() + " is not a legal modifier on " + (this.getName().trim().length() > 0 ? this.getName() + ": " + this.getAlias() : this.getAlias()) + ".  Reason:\n\n" + string4 + "\n\n" + (bl2 ? ((GenericObject)cloneable2).getAlias() + " will be removed from the List " + this.getAlias() + "." : "");
                            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), object2, "Modifier not allowed on ability", 2);
                            this.appAdjusted = true;
                            if (bl2) {
                                bl = false;
                                continue;
                            }
                        }
                    }
                    string5.add(k, (Modifier)cloneable2);
                    if (!((GenericObject)cloneable2).getXMLID().equals("MODIFIER") && ((GenericObject)cloneable2).isExclusive() && GenericObject.findObjectByID(arrayList, ((GenericObject)cloneable2).getXMLID()) != null) continue;
                    arrayList.add(k, (Modifier)cloneable2);
                }
                j.setAssignedModifiers((ArrayList<Modifier>)characteristic);
                j.setParent((List)this);
                this.setAssignedModifiers(arrayList);
            }
            if (bl && i) {
                for (GenericObject j : arrayList) {
                    characteristic = ((Modifier)j).included(this);
                    if (((String)characteristic).trim().length() <= 0) continue;
                    String string5 = string + "The Common Modifier " + j.getAlias() + " is not a legal modifier on " + (this.getName().trim().length() > 0 ? this.getName() + ": " + this.getAlias() : this.getAlias()) + ".  Reason:\n\n" + (String)characteristic + "\n\n" + (bl2 ? j.getAlias() + " will be removed from the List " + this.getAlias() + "." : "");
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), string5, "Modifier not allowed on ability", 2);
                    this.appAdjusted = true;
                    if (!bl2) continue;
                    bl = false;
                }
            }
            return bl2 ? bl : true;
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            String string6;
            Modifier modifier = arrayList.get(i);
            if (!modifier.isPrivate() && !modifier.isLimitation() && this instanceof NakedModifier) continue;
            arrayList.remove(i);
            this.setAssignedModifiers(arrayList);
            if (!this.allowsOtherModifiers()) {
                string6 = string + modifier.getAlias() + " is not a legal modifier on " + (this.getName().trim().length() > 0 ? this.getName() + ": " + this.getAlias() : this.getAlias()) + ".  Reason:\n\n" + this.getAlias() + " does not allow modifiers with its current configuration.\n\n" + (bl2 ? modifier.getAlias() + " will be removed from " + this.getAlias() + "." : "");
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), string6, "Modifier not allowed on ability", 2);
                this.appAdjusted = true;
                if (bl2) {
                    continue;
                }
            } else {
                Object object;
                string6 = modifier.included(this);
                if (this instanceof Characteristic && ((Characteristic)(object = (Characteristic)this)).addModifiersToBase()) {
                    object = (Characteristic)((GenericObject)object).clone();
                    for (int j = 0; j < HeroDesigner.getActiveHero().getCharacteristics().size(); ++j) {
                        Characteristic characteristic = (Characteristic)HeroDesigner.getActiveHero().getCharacteristics().get(j);
                        if (!characteristic.getXMLID().equals(((GenericObject)object).getXMLID())) continue;
                        ((Characteristic)object).setLevels(((CharAffectingObject)object).getLevels() + (int)characteristic.getCharacteristicValue());
                        break;
                    }
                    string6 = modifier.included((GenericObject)object);
                }
                if (string6.trim().length() > 0) {
                    object = string + modifier.getAlias() + " is not a legal modifier on " + (this.getName().trim().length() > 0 ? this.getName() + ": " + this.getAlias() : this.getAlias()) + ".  Reason:\n\n" + string6 + "\n\n" + (bl2 ? modifier.getAlias() + " will be removed from " + this.getAlias() + "." : "");
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), object, "Modifier not allowed on ability", 2);
                    this.appAdjusted = true;
                    if (bl2) {
                        bl = false;
                        continue;
                    }
                }
            }
            if (!modifier.getXMLID().equals("MODIFIER") && modifier.isExclusive() && GenericObject.findObjectByID(arrayList, modifier.getXMLID()) != null) continue;
            arrayList.add(i, modifier);
        }
        this.setAssignedModifiers(arrayList);
        return bl2 ? bl : true;
    }

    static {
        allSources = new ArrayList();
        standardSFX = new String[]{"Acid", "Alien", "Air/Wind", "Animal", "Body Control", "Chi", "Cosmic Energy", "Cyberkinesis", "Darkness", "Density Alteration", "Dimensional Manipulation", "Earth/Stone", "Electricity", "Emotion Control", "Fire/Heat", "Force", "Gravity", "Ice/Cold", "Illusion", "Kinetic Energy", "Light", "Luck", "Magic/Mystic", "Magnetism", "Martial Arts", "Matter Manipulation", "Mental/Psionic", "Metamorphic", "Mutant", "Precognition", "Radiation", "Serum Based", "Shape Alteration", "Size Alteration", "Sleep/Dream", "Solar/Celestial", "Sonic", "Speedster", "Strength/Toughness", "Stretching", "Telekinetic", "Teleportation", "Time", "Vibration", "Water", "Weather", "Wood/Plant", "Miscellaneous"};
    }
}

