/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.modifiers.Linked;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.powers.CompoundPower;
import com.hero.ui.dialog.ElementalControlDialog;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.widgets.PopupMessage;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.jdom.Element;

public class ElementalControl
extends List {
    private String error;

    public ElementalControl(Element element, String string) {
        super(element, string);
        this.minimumCost = 1.0;
        this.maxCost = 9999.0;
        this.minSet = true;
        this.maxSet = true;
    }

    public ElementalControl(Element element) {
        super(element);
        this.minimumCost = 1.0;
        this.maxCost = 9999.0;
        this.minSet = true;
        this.maxSet = true;
    }

    public ElementalControl(String string) {
        super(string);
        this.minimumCost = 1.0;
        this.baseCost = 5.0;
        this.maxCost = 9999.0;
        this.minSet = true;
        this.maxSet = true;
    }

    @Override
    public void init(Element element) {
        super.init(element);
        this.abbreviation = "EC";
    }

    @Override
    public double getRealCostForChild(GenericObject genericObject) {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return super.getRealCostForChild(genericObject);
        }
        ArrayList<Adder> arrayList = genericObject.getAssignedAdders();
        ArrayList<Modifier> arrayList2 = genericObject.getAssignedModifiers();
        ArrayList arrayList3 = (ArrayList)arrayList.clone();
        arrayList3.addAll(this.getAssignedAdders());
        ArrayList arrayList4 = (ArrayList)arrayList2.clone();
        ArrayList<Modifier> arrayList5 = new ArrayList<Modifier>();
        for (int i = 0; i < this.getAssignedModifiers().size(); ++i) {
            Modifier modifier = this.getAssignedModifiers().get(i);
            if (!(modifier.getTotalValue() < 0.0) || GenericObject.findObjectByID(arrayList4, modifier.getXMLID()) != null && !modifier.getXMLID().equals("GENERIC_OBJECT") && !modifier.getXMLID().equals("CUSTOM_MODIFIER") && !modifier.getXMLID().equals("MODIFIER")) continue;
            arrayList5.add(modifier);
        }
        arrayList4.addAll(arrayList5);
        genericObject.setAssignedAdders(arrayList3);
        double d = genericObject.getActiveCost();
        genericObject.setAssignedAdders(arrayList);
        d = Math.max(this.getActiveCost(), d - this.getActiveCost());
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (Modifier modifier : arrayList4) {
            if (!(modifier.getTotalValue() < 0.0)) continue;
            d2 += modifier.getTotalValue();
        }
        double d3 = d / (1.0 + Math.abs(d2));
        if (d2 != 0.0) {
            d3 = Rounder.roundHalfDown(d3);
        }
        if (d3 < 1.0) {
            d3 = 1.0;
        }
        if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && genericObject.getMultiplier() != 1.0) {
            d3 *= genericObject.getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        } else if (HeroDesigner.getActiveHero() != null && HeroDesigner.getActiveHero().getRules().multiplierAllowed() && this.getMultiplier() != 1.0) {
            d3 *= this.getMultiplier();
            d3 = Rounder.roundHalfDown(d3);
        }
        return d3;
    }

    @Override
    public String getColumn2Output() {
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return super.getColumn2Output();
        }
        String string = "";
        if (this.getName().trim().length() > 0) {
            string = string + "<i>" + this.getName() + ":</i>  ";
        }
        string = string + this.getAlias() + ", " + (int)this.getActiveCost() * 2 + "-point powers";
        String string2 = this.getAdderString();
        if (string2.trim().length() > 0) {
            string = string + ", " + string2;
        }
        String string3 = this.getModifierString();
        string = string + string3;
        return string;
    }

    @Override
    public boolean objectAllowed(GenericObject genericObject, boolean bl) {
        Linked linked;
        Serializable serializable;
        Object object;
        Object object2;
        GenericObject genericObject2;
        if (HeroDesigner.getActiveTemplate().is6E()) {
            return super.objectAllowed(genericObject, bl);
        }
        boolean bl2 = true;
        if (genericObject instanceof CompoundPower) {
            genericObject2 = (CompoundPower)genericObject;
            for (int i = 0; i < ((CompoundPower)genericObject2).getPowers().size(); ++i) {
                object2 = ((CompoundPower)genericObject2).getPowers().get(i);
                boolean bl3 = this.objectAllowed((GenericObject)object2, bl);
                if (bl3) continue;
                return bl3;
            }
            if (((CompoundPower)genericObject2).getPowers().size() > 0) {
                return true;
            }
        }
        genericObject2 = genericObject.getParentList();
        genericObject.setParent(this);
        if (!genericObject.allowsOtherModifiers() && this.getAssignedModifiers().size() > 0) {
            this.error = genericObject.getAlias() + " is not allowed to have Modifiers assigned to it in its current configuration.\n\n" + genericObject.getAlias() + " will be placed outside of the list.";
            return false;
        }
        if (genericObject instanceof VariablePowerPool) {
            this.error = "You cannot add a VPP into an Elemental Control.  The Variable Power Pool will be placed outside of the Elemental Control.";
            bl2 = false;
        } else if (genericObject instanceof List) {
            this.error = "You cannot add a List into an Elemental Control.  New list will be placed outside of the Elemental Control.";
            bl2 = false;
        } else if (this.getAssignedModifiers().size() > 0 && HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
            Modifier modifier;
            int n;
            List list = genericObject.getParentList();
            genericObject.setParent(null);
            object2 = this.getAssignedModifiers();
            ArrayList<Modifier> arrayList = genericObject.getAssignedModifiers();
            object = (ArrayList)arrayList.clone();
            serializable = new ArrayList<Modifier>();
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                modifier = (Modifier)((ArrayList)object2).get(n);
                if (GenericObject.findObjectByID(arrayList, modifier.getXMLID()) != null) continue;
                ((ArrayList)serializable).add(modifier);
            }
            ((ArrayList)object).addAll(serializable);
            genericObject.setAssignedModifiers((ArrayList<Modifier>)object);
            for (n = ((ArrayList)serializable).size() - 1; n >= 0; --n) {
                modifier = (Modifier)((ArrayList)serializable).get(n);
                ((ArrayList)object).remove(modifier);
                genericObject.setAssignedModifiers((ArrayList<Modifier>)object);
                String string = modifier.included(genericObject);
                if (string.trim().length() > 0) {
                    this.error = modifier.getAlias() + " cannot be applied to " + genericObject.getAlias() + ".\n\nReason:  " + string + "\n\n" + genericObject.getAlias() + " will be placed outside of the Elemental Control.";
                    bl2 = false;
                    break;
                }
                ((ArrayList)object).add(modifier);
            }
            genericObject.setAssignedModifiers(arrayList);
            genericObject.setParent(list);
        }
        if (!bl2) {
            genericObject.setParent((List)genericObject2);
            return bl2;
        }
        if (GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "LINKED") != null && HeroDesigner.getActiveHero().getRules().getLinkAcrossFramework() > 0 && (object2 = (linked = (Linked)GenericObject.findObjectByID(genericObject.getAssignedModifiers(), "LINKED")).getValue()) != null && ((GenericObject)object2).getParentList() != null && (genericObject.getMainPower() == null || ((GenericObject)object2).getMainPower() == null || !genericObject.getMainPower().equals(((GenericObject)object2).getMainPower())) && (((GenericObject)object2).getParentList() instanceof Multipower || ((GenericObject)object2).getParentList() instanceof ElementalControl || ((GenericObject)object2).getParentList() instanceof VariablePowerPool)) {
            if (HeroDesigner.getActiveHero().getRules().getLinkAcrossFramework() == 2) {
                this.error = "You cannot Link two different slots of a Power Framework";
                bl2 = false;
            } else {
                String string = "Warning!  You should not Link two different slots of a Power Framework.  Use a Compound Power instead.";
                if (bl) {
                    object = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), string, true);
                    ((PopupMessage)object).setVisible(true);
                    bl = false;
                }
            }
        }
        if (!bl2) {
            genericObject.setParent((List)genericObject2);
            return bl2;
        }
        if (genericObject.getTypes().contains("SPECIAL")) {
            String string = "Warning!  " + genericObject.getDisplay() + " should not be placed in an Elemental Control (or any other Power Framework).";
            if (bl && HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() == 1) {
                object2 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), string, true);
                ((PopupMessage)object2).setVisible(true);
            } else if (HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() == 2) {
                this.error = string;
                genericObject.setParent((List)genericObject2);
                return false;
            }
            bl2 = true;
        } else if (genericObject.getOrigAPPerEnd() == 0 && genericObject.getEndUsage() == 0) {
            String string = "Warning!  Elemental Controls should not contain abilities that do not cost END (barring GM permission).";
            if (bl && HeroDesigner.getActiveHero().getRules().getNonENDUsingAbilityInEC() == 1) {
                object2 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), string, true);
                ((PopupMessage)object2).setVisible(true);
            } else if (HeroDesigner.getActiveHero().getRules().getNonENDUsingAbilityInEC() == 2) {
                this.error = string;
                genericObject.setParent((List)genericObject2);
                return false;
            }
            bl2 = true;
        } else if (genericObject instanceof CompoundPower) {
            CompoundPower compoundPower = (CompoundPower)genericObject;
            for (int i = 0; i < compoundPower.getPowers().size(); ++i) {
                GenericObject genericObject3 = compoundPower.getPowers().get(i);
                if (genericObject3.getTypes().contains("SPECIAL") && HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() > 0) {
                    object = "Warning!  " + genericObject3.getDisplay() + " should not be placed in an Elemental Control (or any other Power Framework).";
                    if (bl && HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() == 1) {
                        serializable = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), (String)object, true);
                        ((PopupMessage)serializable).setVisible(true);
                    } else if (HeroDesigner.getActiveHero().getRules().getSpecialTypeInFramework() == 2) {
                        this.error = object;
                        genericObject.setParent((List)genericObject2);
                        return false;
                    }
                    bl2 = true;
                } else {
                    if (genericObject3.getAPPerEnd() != 0 || genericObject3.getEndUsage() != 0 || HeroDesigner.getActiveHero().getRules().getNonENDUsingAbilityInEC() <= 0) continue;
                    object = "Warning!  Elemental Controls should not contain abilities that do not cost END (barring GM permission).";
                    if (bl && HeroDesigner.getActiveHero().getRules().getNonENDUsingAbilityInEC() == 1) {
                        serializable = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), (String)object, true);
                        ((PopupMessage)serializable).setVisible(true);
                    } else if (HeroDesigner.getActiveHero().getRules().getNonENDUsingAbilityInEC() == 2) {
                        this.error = object;
                        genericObject.setParent((List)genericObject2);
                        return false;
                    }
                    bl2 = true;
                }
                break;
            }
        } else if (genericObject.getActiveCost() < this.getActiveCost() * 2.0 && genericObject.getMainPower() == null || genericObject.getMainPower() != null && genericObject.getMainPower().getActiveCost() < this.getActiveCost() * 2.0) {
            String string = "The Active Cost on the Power is less than the minimum for the EC.  The cost of the slot will be increased to match the EC minimum.";
            if (bl) {
                object2 = PopupMessage.getInstance(HeroDesigner.getAppFrame(), (JPanel)HeroDesigner.getAppFrame().getContentPane(), string, true);
                ((PopupMessage)object2).setVisible(true);
            }
            bl2 = true;
        }
        genericObject.setParent((List)genericObject2);
        return bl2;
    }

    @Override
    public String getRejectionMessage() {
        if (this.error == null) {
            return "You cannot add a List into an Elemental Control.  New list will be placed outside of the Elemental Control.";
        }
        return this.error;
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("ELEMENTAL_CONTROL");
        element.setAttribute("QUANTITY", this.getQuantity() + "");
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "QUANTITY");
        if (string != null && string.trim().length() > 0) {
            try {
                this.quantity = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.quantity = 1;
            }
        } else {
            this.quantity = 1;
        }
    }

    @Override
    public GenericDialog getDialog(boolean bl, boolean bl2) {
        return new ElementalControlDialog(this, bl);
    }
}

