/*
 * Decompiled with CFR 0.152.
 */
package com.hero.objects;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.util.XMLUtility;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class Adder
extends GenericObject {
    private boolean selectable;
    private boolean selected;
    private boolean availableCheck;
    private boolean isGroup = false;
    private boolean isPrivate = false;
    private ArrayList<String> excludes;
    private ArrayList<String> requires;
    private boolean displayInString;
    private boolean showAlias;
    private boolean required;
    private boolean includeInBase;

    public Adder(Element element) {
        super(element);
    }

    public Adder() {
        this.excludes = new ArrayList();
        this.requires = new ArrayList();
        this.assignedModifiers = new ArrayList();
        this.assignedAdders = new ArrayList();
        this.multiplier = 1.0;
        this.selectable = true;
        this.selected = false;
        this.availableCheck = false;
        this.displayInString = true;
        this.required = false;
        this.showAlias = true;
        this.isPrivate = false;
    }

    @Override
    public Adder clone() {
        Adder adder = (Adder)super.clone();
        adder.setRequired(this.isRequired());
        adder.setIncludeInBase(this.includeInBase);
        return adder;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean bl) {
        this.isPrivate = bl;
    }

    public boolean includeInBase() {
        return this.includeInBase || this.isRequired();
    }

    public void setIncludeInBase(boolean bl) {
        this.includeInBase = bl;
    }

    public boolean isCustom() {
        return this.getXMLID().equals("GENERIC_OBJECT") || this.getXMLID().equals("ADDER");
    }

    @Override
    public boolean includedInTemplate() {
        if (HeroDesigner.getInstance().getPrefs().getSources().size() > 0) {
            for (String string : HeroDesigner.getInstance().getPrefs().getSources()) {
                if (!this.sources.contains(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Adder(GenericObject genericObject) {
        this.init(new Element("ADDER"));
        this.alias = genericObject.alias;
        this.availableAdders = genericObject.availableAdders;
        this.availableModifiers = genericObject.availableModifiers;
        this.baseCost = genericObject.baseCost;
        this.definition = genericObject.definition;
        this.display = genericObject.display;
        this.dynamicDisplay = genericObject.dynamicDisplay;
        this.examples = genericObject.examples;
        this.exclusive = genericObject.exclusive;
        this.fixedValue = genericObject.fixedValue;
        this.input = genericObject.input;
        this.inputLabel = genericObject.inputLabel;
        this.levelCost = genericObject.levelCost;
        this.levelMultiplier = genericObject.levelMultiplier;
        this.levelPower = genericObject.levelPower;
        this.levels = genericObject.levels;
        this.levelValue = genericObject.levelValue;
        this.maxCost = genericObject.maxCost;
        this.maxLevel = genericObject.maxLevel;
        this.maxSet = genericObject.maxSet;
        this.minimumCost = genericObject.minimumCost;
        this.minimumLevel = genericObject.minimumLevel;
        this.minSet = genericObject.minSet;
        this.name = genericObject.name;
        this.notes = genericObject.notes;
        this.options = genericObject.options;
        this.otherInputAllowed = genericObject.otherInputAllowed;
        this.selectedOption = genericObject.selectedOption;
        this.types = genericObject.types;
        this.userInput = genericObject.userInput;
        this.xmlID = genericObject.xmlID;
        this.selectable = true;
        this.showAlias = true;
        if (this.selectedOption != null) {
            this.setSelectedOption(this.selectedOption);
        }
    }

    @Override
    public void setXMLID(String string) {
        this.xmlID = string;
    }

    @Override
    protected void init(Element element) {
        super.init(element);
        this.excludes = new ArrayList();
        this.requires = new ArrayList();
        this.selectable = true;
        this.selected = false;
        this.availableCheck = false;
        this.displayInString = true;
        this.isGroup = false;
        this.showAlias = true;
        this.isPrivate = false;
        this.includeInBase = false;
        String string = XMLUtility.getValue(element, "BASECOST");
        if (string != null && string.trim().length() > 0) {
            try {
                this.baseCost = Double.parseDouble(string);
                this.selectable = true;
            }
            catch (Exception exception) {
                this.selectable = false;
            }
        } else {
            this.selectable = false;
        }
        if ((string = XMLUtility.getValue(element, "XMLID")) != null && string.trim().length() > 0) {
            this.setXMLID(string.trim());
        }
        if ((string = XMLUtility.getValue(element, "REQUIRED")) != null && string.trim().length() > 0) {
            this.required = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "INCLUDEINBASE")) != null && string.trim().length() > 0) {
            this.includeInBase = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "SHOWALIAS")) != null && string.trim().length() > 0) {
            this.showAlias = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "DISPLAYINSTRING")) != null && string.trim().toUpperCase().startsWith("N")) {
            this.displayInString = false;
        }
        List list = element.getChildren("EXCLUDES");
        for (Element element2 : list) {
            if (element2.getText() == null || element2.getText().trim().length() <= 0) continue;
            this.excludes.add(element2.getText());
        }
        list = element.getChildren("REQUIRES");
        for (Element element2 : list) {
            if (element2.getText() == null || element2.getText().trim().length() <= 0) continue;
            this.requires.add(element2.getText());
        }
        list = element.getChildren("OPTION");
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            this.selectable = true;
        }
        if (this.getOptions().size() > 0) {
            this.setSelectedOption(this.getOptions().get(0));
        }
        if (this.getAvailableAdders().size() > 0) {
            this.isGroup = true;
        }
    }

    public boolean isRequired() {
        if ((this.getOptions() == null || this.getOptions().size() == 0) && this.getLevelCost() == 0.0) {
            return false;
        }
        return this.required;
    }

    @Override
    public Element getSaveXML() {
        Element element = this.getGeneralSaveXML();
        element.setName("ADDER");
        element.setAttribute("SHOWALIAS", this.showAlias ? "Yes" : "No");
        element.setAttribute("PRIVATE", this.isPrivate ? "Yes" : "No");
        element.setAttribute("REQUIRED", this.isRequired() ? "Yes" : "No");
        element.setAttribute("INCLUDEINBASE", this.includeInBase() ? "Yes" : "No");
        element.setAttribute("DISPLAYINSTRING", this.displayInString() ? "Yes" : "No");
        element.setAttribute("GROUP", this.isGroup ? "Yes" : "No");
        if (this.getLevelCost() != 0.0) {
            element.setAttribute("LVLCOST", "" + this.getLevelCost());
            element.setAttribute("LVLVAL", "" + this.getLevelValue());
        }
        element.setAttribute("SELECTED", this.selected ? "YES" : "NO");
        return element;
    }

    @Override
    public void restoreFromSave(Element element) {
        super.restoreFromSave(element);
        String string = XMLUtility.getValue(element, "SELECTED");
        if (string != null && string.trim().toUpperCase().startsWith("Y")) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
        this.setXMLID(XMLUtility.getValue(element, "XMLID"));
        string = XMLUtility.getValue(element, "DISPLAYINSTRING");
        if (string != null && string.trim().length() > 0) {
            this.displayInString = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "REQUIRED")) != null && string.trim().length() > 0) {
            this.required = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "INCLUDEINBASE")) != null && string.trim().length() > 0) {
            this.includeInBase = string.trim().toUpperCase().startsWith("Y");
        }
        this.isPrivate = (string = XMLUtility.getValue(element, "PRIVATE")) != null && string.trim().toUpperCase().startsWith("Y");
        string = XMLUtility.getValue(element, "GROUP");
        if (string != null && string.trim().length() > 0) {
            this.isGroup = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "SHOWALIAS")) != null && string.trim().length() > 0) {
            this.showAlias = string.trim().toUpperCase().startsWith("Y");
        }
        if ((string = XMLUtility.getValue(element, "LVLCOST")) != null) {
            try {
                this.levelCost = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLUtility.getValue(element, "LVLVAL")) != null) {
            try {
                this.levelValue = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Adder) {
            Adder adder = (Adder)object;
            if (adder.isExclusive() && adder.getXMLID().equals(this.getXMLID())) {
                if (!this.getXMLID().equals("ADDER") && !this.getXMLID().equals("GENERIC_OBJECT")) {
                    if (this.getXMLID().equals("DETECT")) {
                        return this.getDisplay().equals(adder.getDisplay());
                    }
                    return true;
                }
            } else if (adder.isExclusive() && !this.getXMLID().equals("ADDER") && !this.getXMLID().equals("GENERIC_OBJECT")) {
                return false;
            }
            if (this.isAvailableCheck() || adder.isAvailableCheck()) {
                if (this.getXMLID().equals("ADDER") || this.getXMLID().equals("GENERIC_OBJECT")) {
                    return this.getDisplay().equals(adder.getDisplay());
                }
                return this.getXMLID().equals(adder.getXMLID());
            }
            if (this.getID() == adder.getID()) {
                if (this.getColumn2Output().equals(adder.getColumn2Output())) {
                    if (this.getSelectedOption() != null && adder.getSelectedOption() != null) {
                        if (this.getSelectedOption().equals(adder.getSelectedOption())) {
                            return this.getLevels() == adder.getLevels();
                        }
                        return false;
                    }
                    return this.getLevels() == adder.getLevels();
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getXMLID().hashCode();
    }

    public ArrayList<String> getExcludes() {
        if (this.excludes == null) {
            this.excludes = new ArrayList();
        }
        return this.excludes;
    }

    public ArrayList<String> getRequires() {
        return this.requires;
    }

    @Override
    public String getColumn2Output() {
        String string = this.getAdderString();
        String string2 = "";
        if (this.isSelected()) {
            if (this.showAlias) {
                string2 = string2 + this.getAlias();
            }
            string2 = string2.trim();
            if (this.getSelectedOption() != null) {
                if (string2.trim().length() > 0) {
                    string2 = string2 + " ";
                }
                string2 = string2 + this.getSelectedOption().getAlias();
            }
            if (this.getInput() != null && this.getInput().trim().length() > 0) {
                if (string2.trim().length() > 0) {
                    string2 = string2 + " ";
                }
                string2 = string2 + this.getInput();
            }
        }
        if (string.trim().length() > 0) {
            if (string2.trim().length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + string;
        }
        if (this.getLevels() > 0 && this.display.indexOf("[LVL]") < 0) {
            string2 = string2 + ":  +" + this.getLevels();
        }
        return string2;
    }

    @Override
    public double getTotalCost() {
        double d = 0.0;
        if (this.isSelected()) {
            d += this.getBaseCost();
            if (this.levelValue != 0.0) {
                d += (double)this.getLevels() / this.levelValue * this.levelCost;
            }
        } else {
            for (Adder adder : this.getAssignedAdders()) {
                d += adder.getRealCost();
            }
        }
        if (d < this.minimumCost && d < 0.0 && this.minSet) {
            d = this.getMinimumCost();
        } else if (d > this.maxCost && d > 0.0 && this.maxSet) {
            d = this.getMaxCost();
        }
        return d;
    }

    public double getTotalCost(boolean bl) {
        double d = 0.0;
        if (this.isSelected() || bl) {
            d += this.getBaseCost();
            if (this.levelValue != 0.0) {
                d += (double)this.getLevels() / this.levelValue * this.levelCost;
            }
        } else {
            for (Adder adder : this.getAssignedAdders()) {
                d += adder.getRealCost();
            }
        }
        if (d < this.minimumCost && d < 0.0 && this.minSet) {
            d = this.getMinimumCost();
        } else if (d > this.maxCost && d > 0.0 && this.maxSet) {
            d = this.getMaxCost();
        }
        return d;
    }

    public double getDoubleTotal(boolean bl) {
        double d = 0.0;
        if (this.isSelected() || !bl) {
            d += this.getBaseCost();
            if (this.levelValue != 0.0) {
                d += (double)this.getLevels() / this.levelValue * this.levelCost;
            }
        } else {
            for (Adder adder : this.getAssignedAdders()) {
                d += adder.getRealCost();
            }
        }
        if (d < this.minimumCost && d < 0.0 && this.minSet) {
            d = this.getMinimumCost();
        } else if (d > this.maxCost && d > 0.0 && this.maxSet) {
            d = this.getMaxCost();
        }
        return d;
    }

    public double getDoubleTotal() {
        return this.getDoubleTotal(false);
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Adder) {
            Adder adder = (Adder)object;
            String string = this.getAlias();
            String string2 = adder.getAlias();
            if (this.isGroup() != adder.isGroup()) {
                if (this.isGroup()) {
                    return -1;
                }
                return 1;
            }
            return string.compareTo(string2);
        }
        if (object instanceof GenericObject) {
            GenericObject genericObject = (GenericObject)object;
            return this.getAdderString().compareTo(genericObject.getAdderString());
        }
        return this.toString().compareTo(object.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void addAliasToVector(ArrayList<String> arrayList) {
        if (this.isSelected() && this.displayInString) {
            Object object = "";
            if (this.showAlias) {
                object = this.getAlias();
            }
            object = ((String)object).trim();
            if (this.getSelectedOption() != null) {
                if (((String)object).trim().length() > 0) {
                    object = (String)object + " ";
                }
                object = (String)object + this.getSelectedOption().getAlias();
            }
            if (this.getInput() != null && this.getInput().trim().length() > 0) {
                if (((String)object).trim().length() > 0) {
                    object = (String)object + " ";
                }
                object = (String)object + this.getInput();
            }
            if (this.getLevels() > 0 && this.display.indexOf("[LVL]") < 0) {
                void var3_5;
                String object2 = "+" + this.getLevels() * this.getLevelMultiplier();
                if (this.levelPower != 1) {
                    String string = "x" + NumberFormat.getIntegerInstance().format((double)this.getLevelMultiplier() * Math.pow(this.getLevelPower(), this.getLevels()));
                }
                object = (String)object + ":  " + (String)var3_5;
            }
            arrayList.add((String)object);
        }
        for (Adder adder : this.getAssignedAdders()) {
            adder.addAliasToVector(arrayList);
        }
    }

    private boolean isAvailableCheck() {
        return this.availableCheck;
    }

    public void setAvailableCheck(boolean bl) {
        this.availableCheck = bl;
    }

    @Override
    public boolean containsType(String string) {
        if (this.isSelected()) {
            return this.types.contains(string);
        }
        for (Adder adder : this.assignedAdders) {
            if (!adder.containsType(string)) continue;
            return true;
        }
        return false;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    @Override
    public String toString() {
        if (this.isSelected()) {
            return this.getAlias();
        }
        return super.toString();
    }

    public boolean displayInString() {
        if (this.alias.trim().length() == 0) {
            return false;
        }
        return this.displayInString;
    }

    public void setDisplayInString(boolean bl) {
        this.displayInString = bl;
    }
}

