/*
 * Decompiled with CFR 0.152.
 */
package com.hero;

import com.hero.HeroDesigner;
import com.hero.Template;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.util.XMLUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Rules {
    public static final int DONOTALLOW = 2;
    public static final int IGNORE = 0;
    public static final int WARN = 1;
    private int attackAPMaxResponse;
    private int basePoints;
    private int disadPoints;
    private int APPerEND;
    private int STRAPPerEND;
    private boolean equipmentAllowed;
    private boolean ncmSelected;
    private boolean ncmUserChangeable;
    private int attackAPMaxValue;
    private int availDisadPointsResponse;
    private int availTotalPointsResponse;
    private int characteristicMaxResponse;
    private int characteristicMaxValue;
    private String currentSet;
    private int defenseAPMaxResponse;
    private int defenseAPMaxValue;
    private boolean dirty;
    private int disadCategoryMaxResponse;
    private int disadCategoryMaxValue;
    private double equipmentCostConversion;
    private int equipmentCostDecimalPlaces;
    private int equipmentCostResponse;
    private String equipmentCostUnits;
    private int equipmentCostValue;
    private boolean equipmentUnitsPrefix;
    private boolean languageSimilaritiesUsed;
    private int maneuverMaxResponse;
    private int maneuverMaxValue;
    private int perkMaxResponse;
    private int perkMaxValue;
    private int powerMaxResponse;
    private int powerMaxValue;
    private int skillMaxResponse;
    private int skillMaxValue;
    private boolean penalizeNoLevel1;
    private int talentMaxResponse;
    private int talentMaxValue;
    private int linkAcrossFramework;
    private int specialTypeInFramework;
    private int nonENDUsingAbilityInEC;
    private boolean automaticallyApplyNoFigured;
    private boolean onlySellOneFigured;
    private boolean useIncreasedDamageDifferentiation;
    private boolean standardEffectAllowed;
    private boolean defaultStandardEffect;
    private boolean multiplierAllowed;
    private boolean useExpandedGrowthChart;
    private boolean literacyFree;
    private boolean nativeLiteracyFree;
    private String campaignSet;
    private boolean useNotes1;
    private String notes1Label;
    private boolean useNotes2;
    private String notes2Label;
    private boolean useNotes3;
    private String notes3Label;
    private boolean useNotes4;
    private String notes4Label;
    private boolean useNotes5;
    private String notes5Label;
    private String name;
    private boolean useSkillMaxima = false;
    private int skillMaximaLimit = 13;
    private boolean useSkillMultipliers = false;
    private Hashtable<String, Integer> characteristicMaxima = new Hashtable();
    private int skillRollBase = 9;
    private double skillRollDenominator = 5.0;
    private int charRollBase = 9;
    private double charRollDenominator = 5.0;
    private boolean languagesAsINTSkill = false;

    public int getSkillRollBase() {
        return this.skillRollBase;
    }

    public void setSkillRollBase(int n) {
        this.skillRollBase = n;
    }

    public double getSkillRollDenominator() {
        if (this.skillRollDenominator == 0.0) {
            this.skillRollDenominator = 5.0;
        }
        return this.skillRollDenominator;
    }

    public void setSkillRollDenominator(double d) {
        this.skillRollDenominator = d;
    }

    public int getCharRollBase() {
        return this.charRollBase;
    }

    public void setCharRollBase(int n) {
        this.charRollBase = n;
    }

    public double getCharRollDenominator() {
        if (this.charRollDenominator == 0.0) {
            this.charRollDenominator = 5.0;
        }
        return this.charRollDenominator;
    }

    public void setCharRollDenominator(double d) {
        this.charRollDenominator = d;
    }

    public int getCharacteristicMaxima(String string) {
        if (this.characteristicMaxima.get(string) != null) {
            return this.characteristicMaxima.get(string);
        }
        return 999;
    }

    public void setCharacteristicMaxima(Characteristic characteristic, int n) {
        this.characteristicMaxima.remove(characteristic.getXMLID());
        this.characteristicMaxima.put(characteristic.getXMLID(), n);
    }

    public boolean automaticallyApplyNoFigured() {
        return this.automaticallyApplyNoFigured;
    }

    public boolean defaultStandardEffect() {
        return this.defaultStandardEffect;
    }

    public int getAPPerEND() {
        return this.APPerEND;
    }

    public int getAttackAPMaxResponse() {
        return this.attackAPMaxResponse;
    }

    public int getAttackAPMaxValue() {
        return this.attackAPMaxValue;
    }

    public int getAvailDisadPointsResponse() {
        return this.availDisadPointsResponse;
    }

    public int getAvailTotalPointsResponse() {
        return this.availTotalPointsResponse;
    }

    public int getBasePoints() {
        return this.basePoints;
    }

    public String getCampaignSet() {
        if (this.campaignSet == null || !this.isDefault()) {
            this.campaignSet = "";
        }
        return this.campaignSet;
    }

    public int getCharacteristicMaxResponse() {
        return this.characteristicMaxResponse;
    }

    public int getCharacteristicMaxValue() {
        return this.characteristicMaxValue;
    }

    public String getCurrentSet() {
        String string = this.currentSet;
        if (this.currentSet == null || this.currentSet.trim().length() == 0) {
            string = this.campaignSet != null && this.campaignSet.trim().length() > 0 ? this.campaignSet : "Default";
        }
        return string;
    }

    public int getDefenseAPMaxResponse() {
        return this.defenseAPMaxResponse;
    }

    public int getDefenseAPMaxValue() {
        return this.defenseAPMaxValue;
    }

    public int getDisadCategoryMaxResponse() {
        return this.disadCategoryMaxResponse;
    }

    public int getDisadCategoryMaxValue() {
        return this.disadCategoryMaxValue;
    }

    public int getDisadPoints() {
        return this.disadPoints;
    }

    public double getEquipmentCostConversion() {
        if (this.equipmentCostConversion == 0.0) {
            return 1.0;
        }
        return this.equipmentCostConversion;
    }

    public int getEquipmentCostDecimalPlaces() {
        return this.equipmentCostDecimalPlaces;
    }

    public int getEquipmentCostResponse() {
        return this.equipmentCostResponse;
    }

    public String getEquipmentCostUnits() {
        return this.equipmentCostUnits;
    }

    public int getEquipmentCostValue() {
        return this.equipmentCostValue;
    }

    public int getLinkAcrossFramework() {
        return this.linkAcrossFramework;
    }

    public int getManeuverMaxResponse() {
        return this.maneuverMaxResponse;
    }

    public int getManeuverMaxValue() {
        return this.maneuverMaxValue;
    }

    public String getName() {
        return this.name;
    }

    public int getNonENDUsingAbilityInEC() {
        return this.nonENDUsingAbilityInEC;
    }

    public String getNotes1Label() {
        if (this.notes1Label == null || this.notes1Label.trim().length() == 0) {
            this.notes1Label = "Notes 1";
        }
        return this.notes1Label;
    }

    public String getNotes2Label() {
        if (this.notes2Label == null || this.notes2Label.trim().length() == 0) {
            this.notes2Label = "Notes 2";
        }
        return this.notes2Label;
    }

    public String getNotes3Label() {
        if (this.notes3Label == null || this.notes3Label.trim().length() == 0) {
            this.notes3Label = "Notes 3";
        }
        return this.notes3Label;
    }

    public String getNotes4Label() {
        if (this.notes4Label == null || this.notes4Label.trim().length() == 0) {
            this.notes4Label = "Notes 4";
        }
        return this.notes4Label;
    }

    public String getNotes5Label() {
        if (this.notes5Label == null || this.notes5Label.trim().length() == 0) {
            this.notes5Label = "Notes 5";
        }
        return this.notes5Label;
    }

    public int getPerkMaxResponse() {
        return this.perkMaxResponse;
    }

    public int getPerkMaxValue() {
        return this.perkMaxValue;
    }

    public int getPowerMaxResponse() {
        return this.powerMaxResponse;
    }

    public int getPowerMaxValue() {
        return this.powerMaxValue;
    }

    public Element getRulesXML() {
        Element element = new Element("RULES");
        if (this.currentSet == null) {
            this.currentSet = "";
        }
        if (this.name == null || this.name.trim().length() == 0) {
            this.name = this.currentSet;
            File file = new File(this.currentSet);
            if (file.exists()) {
                this.name = file.getName();
            }
        }
        element.setAttribute("name", this.name);
        element.setAttribute("path", this.currentSet);
        element.setAttribute("BASEPOINTS", "" + this.basePoints);
        element.setAttribute("DISADPOINTS", "" + this.disadPoints);
        element.setAttribute("APPEREND", "" + this.APPerEND);
        element.setAttribute("STRAPPEREND", "" + this.STRAPPerEND);
        element.setAttribute("NCMSELECTED", this.ncmSelected ? "Yes" : "No");
        element.setAttribute("NCMUSERCHANGEABLE", this.ncmUserChangeable ? "Yes" : "No");
        element.setAttribute("ATTACKAPMAXVALUE", "" + this.attackAPMaxValue);
        element.setAttribute("ATTACKAPMAXRESPONSE", "" + this.attackAPMaxResponse);
        element.setAttribute("DEFENSEAPMAXVALUE", "" + this.defenseAPMaxValue);
        element.setAttribute("DEFENSEAPMAXRESPONSE", "" + this.defenseAPMaxResponse);
        element.setAttribute("DISADCATEGORYMAXVALUE", "" + this.disadCategoryMaxValue);
        element.setAttribute("DISADCATEGORYMAXRESPONSE", "" + this.disadCategoryMaxResponse);
        element.setAttribute("AVAILDISADPOINTSRESPONSE", "" + this.availDisadPointsResponse);
        element.setAttribute("AVAILTOTALPOINTSRESPONSE", "" + this.availTotalPointsResponse);
        element.setAttribute("CHARACTERISTICMAXVALUE", "" + this.characteristicMaxValue);
        element.setAttribute("CHARACTERISTICMAXRESPONSE", "" + this.characteristicMaxResponse);
        element.setAttribute("MANEUVERMAXVALUE", "" + this.maneuverMaxValue);
        element.setAttribute("MANEUVERMAXRESPONSE", "" + this.maneuverMaxResponse);
        element.setAttribute("SKILLMAXVALUE", "" + this.skillMaxValue);
        element.setAttribute("SKILLMAXRESPONSE", "" + this.skillMaxResponse);
        element.setAttribute("PERKMAXVALUE", "" + this.perkMaxValue);
        element.setAttribute("PERKMAXRESPONSE", "" + this.perkMaxResponse);
        element.setAttribute("TALENTMAXVALUE", "" + this.talentMaxValue);
        element.setAttribute("TALENTMAXRESPONSE", "" + this.talentMaxResponse);
        element.setAttribute("POWERMAXVALUE", "" + this.powerMaxValue);
        element.setAttribute("POWERMAXRESPONSE", "" + this.powerMaxResponse);
        element.setAttribute("EQUIPMENTCOSTVALUE", "" + this.equipmentCostValue);
        element.setAttribute("EQUIPMENTCOSTRESPONSE", "" + this.equipmentCostResponse);
        element.setAttribute("EQUIPMENTCOSTUNITS", "" + this.equipmentCostUnits);
        element.setAttribute("EQUIPMENTCOSTCONVERSION", "" + this.equipmentCostConversion);
        element.setAttribute("EQUIPMENTCOSTDECIMALPLACES", "" + this.equipmentCostDecimalPlaces);
        element.setAttribute("EQUIPMENTUNITSPREFIX", this.equipmentUnitsPrefix ? "Yes" : "No");
        element.setAttribute("STANDARDEFFECTALLOWED", this.standardEffectAllowed ? "Yes" : "No");
        element.setAttribute("USEEXPANDEDGROWTHCHART", this.useExpandedGrowthChart ? "Yes" : "No");
        element.setAttribute("DEFAULTSTANDARDEFFECT", this.defaultStandardEffect ? "Yes" : "No");
        element.setAttribute("MULTIPLIERALLOWED", this.multiplierAllowed ? "Yes" : "No");
        element.setAttribute("LANGUAGESIMILARITIESUSED", this.languageSimilaritiesUsed ? "Yes" : "No");
        element.setAttribute("LITERACYFREE", this.literacyFree ? "Yes" : "No");
        element.setAttribute("NATIVELITERACYFREE", this.nativeLiteracyFree ? "Yes" : "No");
        element.setAttribute("EQUIPMENTALLOWED", this.equipmentAllowed ? "Yes" : "No");
        element.setAttribute("PENALIZENOLEVEL1", this.penalizeNoLevel1 ? "Yes" : "No");
        element.setAttribute("ONLYSELLONEFIGURED", this.onlySellOneFigured ? "Yes" : "No");
        element.setAttribute("USEINCREASEDDAMAGEDIFFERENTIATION", this.useIncreasedDamageDifferentiation ? "Yes" : "No");
        element.setAttribute("AUTOMATICALLYAPPLYNOFIGURED", this.automaticallyApplyNoFigured ? "Yes" : "No");
        element.setAttribute("LINKACROSSFRAMEWORK", "" + this.linkAcrossFramework);
        element.setAttribute("SPECIALTYPEINFRAMEWORK", "" + this.specialTypeInFramework);
        element.setAttribute("NONENDUSINGABILITYINEC", "" + this.nonENDUsingAbilityInEC);
        element.setAttribute("USESKILLMAXIMA", this.getUseSkillMaxima() ? "Yes" : "No");
        element.setAttribute("USESKILLMULTIPLIERS", this.useSkillMultipliers() ? "Yes" : "No");
        element.setAttribute("LANGUAGESASINTSKILL", this.useLanguagesAsINTSkill() ? "Yes" : "No");
        element.setAttribute("SKILLMAXIMALIMIT", "" + this.getSkillMaximaLimit());
        element.setAttribute("SKILLROLLBASE", "" + this.getSkillRollBase());
        element.setAttribute("SKILLROLLDENOMINATOR", "" + this.getSkillRollDenominator());
        element.setAttribute("CHARROLLBASE", "" + this.getCharRollBase());
        element.setAttribute("CHARROLLDENOMINATOR", "" + this.getCharRollDenominator());
        element.setAttribute("USENOTES1", this.useNotes1() ? "Yes" : "No");
        element.setAttribute("USENOTES2", this.useNotes2() ? "Yes" : "No");
        element.setAttribute("USENOTES3", this.useNotes3() ? "Yes" : "No");
        element.setAttribute("USENOTES4", this.useNotes4() ? "Yes" : "No");
        element.setAttribute("USENOTES5", this.useNotes5() ? "Yes" : "No");
        element.setAttribute("NOTES1LABEL", this.getNotes1Label());
        element.setAttribute("NOTES2LABEL", this.getNotes2Label());
        element.setAttribute("NOTES3LABEL", this.getNotes3Label());
        element.setAttribute("NOTES4LABEL", this.getNotes4Label());
        element.setAttribute("NOTES5LABEL", this.getNotes5Label());
        for (String string : this.characteristicMaxima.keySet()) {
            int n = this.characteristicMaxima.get(string);
            element.setAttribute(string + "_MAX", "" + n);
        }
        return element;
    }

    public int getSkillMaximaLimit() {
        return this.skillMaximaLimit;
    }

    public int getSkillMaxResponse() {
        return this.skillMaxResponse;
    }

    public int getSkillMaxValue() {
        return this.skillMaxValue;
    }

    public int getSpecialTypeInFramework() {
        return this.specialTypeInFramework;
    }

    public int getSTRAPPerEND() {
        if (this.isDefault() && HeroDesigner.getActiveTemplate() != null) {
            Template template = HeroDesigner.getActiveTemplate();
            if (template.getId().indexOf("Heroic") >= 0 || template.getId().indexOf("Normal") >= 0) {
                return 5;
            }
            for (Template template2 : template.getParentTemplates()) {
                if (template2.getId().indexOf("Heroic") < 0 && template2.getId().indexOf("Normal") < 0) continue;
                return 5;
            }
        }
        return this.STRAPPerEND;
    }

    public int getTalentMaxResponse() {
        return this.talentMaxResponse;
    }

    public int getTalentMaxValue() {
        return this.talentMaxValue;
    }

    public boolean getUseSkillMaxima() {
        return this.useSkillMaxima;
    }

    public boolean isDefault() {
        return this.getCurrentSet().equals("Default") && !this.dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEquipmentAllowed() {
        if (this.isDefault()) {
            if (HeroDesigner.getActiveTemplate() != null) {
                Template template = HeroDesigner.getActiveTemplate();
                if (template.getId().indexOf("Heroic") >= 0 || template.getId().indexOf("Normal") >= 0) {
                    return true;
                }
                for (Template template2 : template.getParentTemplates()) {
                    if (template2.getId().indexOf("Heroic") < 0 && template2.getId().indexOf("Normal") < 0) continue;
                    return true;
                }
            }
            return false;
        }
        return this.equipmentAllowed;
    }

    public boolean isEquipmentUnitsPrefix() {
        return this.equipmentUnitsPrefix;
    }

    public boolean isLanguageSimilaritiesUsed() {
        return this.languageSimilaritiesUsed;
    }

    public boolean isLiteracyFree() {
        return this.literacyFree;
    }

    public boolean isNativeLiteracyFree() {
        return this.nativeLiteracyFree;
    }

    public boolean isNCMSelected() {
        return this.ncmSelected;
    }

    public boolean isNCMUserChangeable() {
        return this.ncmUserChangeable;
    }

    public boolean isStandardEffectAllowed() {
        return this.standardEffectAllowed;
    }

    public void loadRulesDefinition(String string) {
        try {
            File file = new File(string);
            if (!file.exists() && HeroDesigner.getInstance().getPrefs().getRulesDir() != null) {
                file = new File(HeroDesigner.getInstance().getPrefs().getRulesDir() + File.separator + file.getName());
                string = file.getAbsolutePath();
            }
            if (!file.exists()) {
                this.useDefault();
                return;
            }
            SAXBuilder sAXBuilder = new SAXBuilder(false);
            Document document = sAXBuilder.build(file);
            sAXBuilder = null;
            Element element = document.getRootElement();
            this.restoreRules(element);
            this.currentSet = string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred reading the rules file\n     \"" + string + "\"\n\nError Message: " + exception.getMessage(), "Error loading rules", 0);
            this.useDefault();
        }
        this.campaignSet = "";
    }

    public boolean multiplierAllowed() {
        return this.multiplierAllowed;
    }

    public boolean onlySellOneFigured() {
        return this.onlySellOneFigured;
    }

    public boolean penalizeNoLevel1() {
        return this.penalizeNoLevel1;
    }

    public void restoreRules(Element element) {
        String string;
        block180: {
            block179: {
                block178: {
                    block177: {
                        block176: {
                            block175: {
                                block174: {
                                    block173: {
                                        block172: {
                                            block171: {
                                                block170: {
                                                    block169: {
                                                        block168: {
                                                            block167: {
                                                                block166: {
                                                                    String string2 = element.getAttributeValue("name");
                                                                    if (string2 != null) {
                                                                        this.name = string2;
                                                                    }
                                                                    if (this.name == null || this.name.trim().length() == 0) {
                                                                        this.name = this.currentSet;
                                                                    }
                                                                    if (this.name == null || this.name.trim().length() == 0) {
                                                                        this.name = "Custom";
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "BASEPOINTS")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.basePoints = Integer.parseInt(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.basePoints = 200;
                                                                        }
                                                                    } else {
                                                                        this.basePoints = 200;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "DISADPOINTS")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.disadPoints = Integer.parseInt(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.disadPoints = 150;
                                                                        }
                                                                    } else {
                                                                        this.disadPoints = 150;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "SKILLROLLBASE")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.skillRollBase = Integer.parseInt(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.skillRollBase = 9;
                                                                        }
                                                                    } else {
                                                                        this.skillRollBase = 9;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "SKILLROLLDENOMINATOR")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.skillRollDenominator = Double.parseDouble(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.skillRollDenominator = 5.0;
                                                                        }
                                                                    } else {
                                                                        this.skillRollDenominator = 5.0;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "CHARROLLBASE")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.charRollBase = Integer.parseInt(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.charRollBase = 9;
                                                                        }
                                                                    } else {
                                                                        this.charRollBase = 9;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "CHARROLLDENOMINATOR")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.charRollDenominator = Double.parseDouble(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.charRollDenominator = 5.0;
                                                                        }
                                                                    } else {
                                                                        this.charRollDenominator = 5.0;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "APPEREND")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.APPerEND = Integer.parseInt(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.APPerEND = 10;
                                                                        }
                                                                    } else {
                                                                        this.APPerEND = 10;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "STRAPPEREND")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.STRAPPerEND = Integer.parseInt(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.STRAPPerEND = 10;
                                                                        }
                                                                    } else {
                                                                        this.STRAPPerEND = 10;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "ATTACKAPMAXVALUE")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            this.attackAPMaxValue = Integer.parseInt(string);
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.attackAPMaxValue = 90;
                                                                        }
                                                                    } else {
                                                                        this.attackAPMaxValue = 90;
                                                                    }
                                                                    if ((string = XMLUtility.getValue(element, "ATTACKAPMAXRESPONSE")) != null && string.trim().length() > 0) {
                                                                        try {
                                                                            int n = Integer.parseInt(string);
                                                                            if (n >= 0 && n <= 2) {
                                                                                this.attackAPMaxResponse = n;
                                                                                break block166;
                                                                            }
                                                                            this.attackAPMaxResponse = 0;
                                                                        }
                                                                        catch (NumberFormatException numberFormatException) {
                                                                            this.attackAPMaxResponse = 0;
                                                                        }
                                                                    } else {
                                                                        this.attackAPMaxResponse = 0;
                                                                    }
                                                                }
                                                                if ((string = XMLUtility.getValue(element, "DEFENSEAPMAXVALUE")) != null && string.trim().length() > 0) {
                                                                    try {
                                                                        this.defenseAPMaxValue = Integer.parseInt(string);
                                                                    }
                                                                    catch (NumberFormatException numberFormatException) {
                                                                        this.defenseAPMaxValue = 90;
                                                                    }
                                                                } else {
                                                                    this.defenseAPMaxValue = 90;
                                                                }
                                                                if ((string = XMLUtility.getValue(element, "DEFENSEAPMAXRESPONSE")) != null && string.trim().length() > 0) {
                                                                    try {
                                                                        int n = Integer.parseInt(string);
                                                                        if (n >= 0 && n <= 2) {
                                                                            this.defenseAPMaxResponse = n;
                                                                            break block167;
                                                                        }
                                                                        this.defenseAPMaxResponse = 0;
                                                                    }
                                                                    catch (NumberFormatException numberFormatException) {
                                                                        this.defenseAPMaxResponse = 0;
                                                                    }
                                                                } else {
                                                                    this.defenseAPMaxResponse = 0;
                                                                }
                                                            }
                                                            if ((string = XMLUtility.getValue(element, "MANEUVERMAXVALUE")) != null && string.trim().length() > 0) {
                                                                try {
                                                                    this.maneuverMaxValue = Integer.parseInt(string);
                                                                }
                                                                catch (NumberFormatException numberFormatException) {
                                                                    this.maneuverMaxValue = 1000;
                                                                }
                                                            } else {
                                                                this.maneuverMaxValue = 1000;
                                                            }
                                                            if ((string = XMLUtility.getValue(element, "MANEUVERMAXRESPONSE")) != null && string.trim().length() > 0) {
                                                                try {
                                                                    int n = Integer.parseInt(string);
                                                                    if (n >= 0 && n <= 2) {
                                                                        this.maneuverMaxResponse = n;
                                                                        break block168;
                                                                    }
                                                                    this.maneuverMaxResponse = 0;
                                                                }
                                                                catch (NumberFormatException numberFormatException) {
                                                                    this.maneuverMaxResponse = 0;
                                                                }
                                                            } else {
                                                                this.maneuverMaxResponse = 0;
                                                            }
                                                        }
                                                        if ((string = XMLUtility.getValue(element, "DISADCATEGORYMAXVALUE")) != null && string.trim().length() > 0) {
                                                            try {
                                                                this.disadCategoryMaxValue = Integer.parseInt(string);
                                                            }
                                                            catch (NumberFormatException numberFormatException) {
                                                                this.disadCategoryMaxValue = 75;
                                                            }
                                                        } else {
                                                            this.disadCategoryMaxValue = 75;
                                                        }
                                                        if ((string = XMLUtility.getValue(element, "DISADCATEGORYMAXRESPONSE")) != null && string.trim().length() > 0) {
                                                            try {
                                                                int n = Integer.parseInt(string);
                                                                if (n >= 0 && n <= 2) {
                                                                    this.disadCategoryMaxResponse = n;
                                                                    break block169;
                                                                }
                                                                this.disadCategoryMaxResponse = 0;
                                                            }
                                                            catch (NumberFormatException numberFormatException) {
                                                                this.disadCategoryMaxResponse = 0;
                                                            }
                                                        } else {
                                                            this.disadCategoryMaxResponse = 0;
                                                        }
                                                    }
                                                    if ((string = XMLUtility.getValue(element, "AVAILDISADPOINTSRESPONSE")) != null && string.trim().length() > 0) {
                                                        try {
                                                            int n = Integer.parseInt(string);
                                                            if (n >= 0 && n <= 2) {
                                                                this.availDisadPointsResponse = n;
                                                                break block170;
                                                            }
                                                            this.availDisadPointsResponse = 0;
                                                        }
                                                        catch (NumberFormatException numberFormatException) {
                                                            this.availDisadPointsResponse = 0;
                                                        }
                                                    } else {
                                                        this.availDisadPointsResponse = 0;
                                                    }
                                                }
                                                if ((string = XMLUtility.getValue(element, "AVAILTOTALPOINTSRESPONSE")) != null && string.trim().length() > 0) {
                                                    try {
                                                        int n = Integer.parseInt(string);
                                                        if (n >= 0 && n <= 2) {
                                                            this.availTotalPointsResponse = n;
                                                            break block171;
                                                        }
                                                        this.availTotalPointsResponse = 0;
                                                    }
                                                    catch (NumberFormatException numberFormatException) {
                                                        this.availTotalPointsResponse = 0;
                                                    }
                                                } else {
                                                    this.availTotalPointsResponse = 0;
                                                }
                                            }
                                            if ((string = XMLUtility.getValue(element, "CHARACTERISTICMAXVALUE")) != null && string.trim().length() > 0) {
                                                try {
                                                    this.characteristicMaxValue = Integer.parseInt(string);
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    this.characteristicMaxValue = 1000;
                                                }
                                            } else {
                                                this.characteristicMaxValue = 1000;
                                            }
                                            if ((string = XMLUtility.getValue(element, "CHARACTERISTICMAXRESPONSE")) != null && string.trim().length() > 0) {
                                                try {
                                                    int n = Integer.parseInt(string);
                                                    if (n >= 0 && n <= 2) {
                                                        this.characteristicMaxResponse = n;
                                                        break block172;
                                                    }
                                                    this.characteristicMaxResponse = 0;
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    this.characteristicMaxResponse = 0;
                                                }
                                            } else {
                                                this.characteristicMaxResponse = 0;
                                            }
                                        }
                                        if ((string = XMLUtility.getValue(element, "SKILLMAXVALUE")) != null && string.trim().length() > 0) {
                                            try {
                                                this.skillMaxValue = Integer.parseInt(string);
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                this.skillMaxValue = 1000;
                                            }
                                        } else {
                                            this.skillMaxValue = 1000;
                                        }
                                        if ((string = XMLUtility.getValue(element, "SKILLMAXRESPONSE")) != null && string.trim().length() > 0) {
                                            try {
                                                int n = Integer.parseInt(string);
                                                if (n >= 0 && n <= 2) {
                                                    this.skillMaxResponse = n;
                                                    break block173;
                                                }
                                                this.skillMaxResponse = 0;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                this.skillMaxResponse = 0;
                                            }
                                        } else {
                                            this.skillMaxResponse = 0;
                                        }
                                    }
                                    if ((string = XMLUtility.getValue(element, "PERKMAXVALUE")) != null && string.trim().length() > 0) {
                                        try {
                                            this.perkMaxValue = Integer.parseInt(string);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            this.perkMaxValue = 1000;
                                        }
                                    } else {
                                        this.perkMaxValue = 1000;
                                    }
                                    if ((string = XMLUtility.getValue(element, "PERKMAXRESPONSE")) != null && string.trim().length() > 0) {
                                        try {
                                            int n = Integer.parseInt(string);
                                            if (n >= 0 && n <= 2) {
                                                this.perkMaxResponse = n;
                                                break block174;
                                            }
                                            this.perkMaxResponse = 0;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            this.perkMaxResponse = 0;
                                        }
                                    } else {
                                        this.perkMaxResponse = 0;
                                    }
                                }
                                if ((string = XMLUtility.getValue(element, "TALENTMAXVALUE")) != null && string.trim().length() > 0) {
                                    try {
                                        this.talentMaxValue = Integer.parseInt(string);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        this.talentMaxValue = 1000;
                                    }
                                } else {
                                    this.talentMaxValue = 1000;
                                }
                                if ((string = XMLUtility.getValue(element, "TALENTMAXRESPONSE")) != null && string.trim().length() > 0) {
                                    try {
                                        int n = Integer.parseInt(string);
                                        if (n >= 0 && n <= 2) {
                                            this.talentMaxResponse = n;
                                            break block175;
                                        }
                                        this.talentMaxResponse = 0;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        this.talentMaxResponse = 0;
                                    }
                                } else {
                                    this.talentMaxResponse = 0;
                                }
                            }
                            if ((string = XMLUtility.getValue(element, "POWERMAXVALUE")) != null && string.trim().length() > 0) {
                                try {
                                    this.powerMaxValue = Integer.parseInt(string);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.powerMaxValue = 1000;
                                }
                            } else {
                                this.powerMaxValue = 1000;
                            }
                            if ((string = XMLUtility.getValue(element, "POWERMAXRESPONSE")) != null && string.trim().length() > 0) {
                                try {
                                    int n = Integer.parseInt(string);
                                    if (n >= 0 && n <= 2) {
                                        this.powerMaxResponse = n;
                                        break block176;
                                    }
                                    this.powerMaxResponse = 0;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.powerMaxResponse = 0;
                                }
                            } else {
                                this.powerMaxResponse = 0;
                            }
                        }
                        if ((string = XMLUtility.getValue(element, "EQUIPMENTCOSTVALUE")) != null && string.trim().length() > 0) {
                            try {
                                this.equipmentCostValue = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.equipmentCostValue = 1000;
                            }
                        } else {
                            this.equipmentCostValue = 1000;
                        }
                        if ((string = XMLUtility.getValue(element, "EQUIPMENTCOSTCONVERSION")) != null && string.trim().length() > 0) {
                            try {
                                this.equipmentCostConversion = Double.parseDouble(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.equipmentCostConversion = 1.0;
                            }
                        } else {
                            this.equipmentCostConversion = 1.0;
                        }
                        if ((string = XMLUtility.getValue(element, "EQUIPMENTCOSTDECIMALPLACES")) != null && string.trim().length() > 0) {
                            try {
                                this.equipmentCostDecimalPlaces = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.equipmentCostDecimalPlaces = 1000;
                            }
                        } else {
                            this.equipmentCostDecimalPlaces = 1000;
                        }
                        if ((string = XMLUtility.getValue(element, "EQUIPMENTCOSTRESPONSE")) != null && string.trim().length() > 0) {
                            try {
                                int n = Integer.parseInt(string);
                                if (n >= 0 && n <= 2) {
                                    this.equipmentCostResponse = n;
                                    break block177;
                                }
                                this.equipmentCostResponse = 0;
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.equipmentCostResponse = 0;
                            }
                        } else {
                            this.equipmentCostResponse = 0;
                        }
                    }
                    this.equipmentCostUnits = (string = XMLUtility.getValue(element, "EQUIPMENTCOSTUNITS")) != null ? string : "$";
                    string = XMLUtility.getValue(element, "EQUIPMENTUNITSPREFIX");
                    this.equipmentUnitsPrefix = string == null || !string.trim().toUpperCase().startsWith("N");
                    string = XMLUtility.getValue(element, "USESKILLMAXIMA");
                    this.useSkillMaxima = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "USESKILLMULTIPLIERS");
                    this.useSkillMultipliers = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "LANGUAGESASINTSKILL");
                    this.languagesAsINTSkill = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "SKILLMAXIMALIMIT");
                    if (string != null && string.trim().length() > 0) {
                        try {
                            this.skillMaximaLimit = Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            this.skillMaximaLimit = 13;
                        }
                    } else {
                        this.skillMaximaLimit = 13;
                    }
                    this.onlySellOneFigured = (string = XMLUtility.getValue(element, "ONLYSELLONEFIGURED")) == null || !string.trim().toUpperCase().startsWith("N");
                    string = XMLUtility.getValue(element, "USEINCREASEDDAMAGEDIFFERENTIATION");
                    this.useIncreasedDamageDifferentiation = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "NCMSELECTED");
                    this.ncmSelected = string == null || !string.trim().toUpperCase().startsWith("N");
                    string = XMLUtility.getValue(element, "NCMUSERCHANGEABLE");
                    this.ncmUserChangeable = string == null || !string.trim().toUpperCase().startsWith("N");
                    string = XMLUtility.getValue(element, "EQUIPMENTALLOWED");
                    this.equipmentAllowed = string == null || !string.trim().toUpperCase().startsWith("N");
                    string = XMLUtility.getValue(element, "PENALIZENOLEVEL1");
                    this.penalizeNoLevel1 = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "STANDARDEFFECTALLOWED");
                    this.standardEffectAllowed = string == null || !string.trim().toUpperCase().startsWith("N");
                    string = XMLUtility.getValue(element, "USEEXPANDEDGROWTHCHART");
                    this.useExpandedGrowthChart = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "DEFAULTSTANDARDEFFECT");
                    this.defaultStandardEffect = string == null || !string.trim().toUpperCase().startsWith("N");
                    string = XMLUtility.getValue(element, "MULTIPLIERALLOWED");
                    this.multiplierAllowed = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "USENOTES1");
                    this.useNotes1 = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "USENOTES2");
                    this.useNotes2 = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "USENOTES3");
                    this.useNotes3 = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "USENOTES4");
                    this.useNotes4 = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "USENOTES5");
                    this.useNotes5 = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "NOTES1LABEL");
                    this.notes1Label = string != null && string.trim().length() > 0 ? string : "Notes 1";
                    string = XMLUtility.getValue(element, "NOTES2LABEL");
                    this.notes2Label = string != null && string.trim().length() > 0 ? string : "Notes 2";
                    string = XMLUtility.getValue(element, "NOTES3LABEL");
                    this.notes3Label = string != null && string.trim().length() > 0 ? string : "Notes 3";
                    string = XMLUtility.getValue(element, "NOTES4LABEL");
                    this.notes4Label = string != null && string.trim().length() > 0 ? string : "Notes 4";
                    string = XMLUtility.getValue(element, "NOTES5LABEL");
                    this.notes5Label = string != null && string.trim().length() > 0 ? string : "Notes 5";
                    string = XMLUtility.getValue(element, "LANGUAGESIMILARITIESUSED");
                    this.languageSimilaritiesUsed = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "LITERACYFREE");
                    this.literacyFree = string != null && string.trim().toUpperCase().startsWith("Y");
                    string = XMLUtility.getValue(element, "NATIVELITERACYFREE");
                    this.nativeLiteracyFree = string != null && string.trim().toUpperCase().startsWith("Y");
                    this.dirty = false;
                    string = XMLUtility.getValue(element, "LINKACROSSFRAMEWORK");
                    if (string != null && string.trim().length() > 0) {
                        try {
                            int n = Integer.parseInt(string);
                            if (n >= 0 && n <= 2) {
                                this.linkAcrossFramework = n;
                                break block178;
                            }
                            this.linkAcrossFramework = 2;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.linkAcrossFramework = 2;
                        }
                    } else {
                        this.linkAcrossFramework = 2;
                    }
                }
                if ((string = XMLUtility.getValue(element, "SPECIALTYPEINFRAMEWORK")) != null && string.trim().length() > 0) {
                    try {
                        int n = Integer.parseInt(string);
                        if (n >= 0 && n <= 2) {
                            this.specialTypeInFramework = n;
                            break block179;
                        }
                        this.specialTypeInFramework = 2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.specialTypeInFramework = 2;
                    }
                } else {
                    this.specialTypeInFramework = 2;
                }
            }
            if ((string = XMLUtility.getValue(element, "NONENDUSINGABILITYINEC")) != null && string.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    if (n >= 0 && n <= 2) {
                        this.nonENDUsingAbilityInEC = n;
                        break block180;
                    }
                    this.nonENDUsingAbilityInEC = 2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.nonENDUsingAbilityInEC = 2;
                }
            } else {
                this.nonENDUsingAbilityInEC = 2;
            }
        }
        this.automaticallyApplyNoFigured = (string = XMLUtility.getValue(element, "AUTOMATICALLYAPPLYNOFIGURED")) == null || !string.trim().toUpperCase().startsWith("N");
        this.characteristicMaxima = new Hashtable();
        List list = element.getAttributes();
        ArrayList<GenericObject> arrayList = HeroDesigner.getActiveTemplate().getCharacteristics();
        block74: for (int i = 0; i < list.size(); ++i) {
            Attribute attribute = (Attribute)list.get(i);
            int n = 999;
            try {
                n = Integer.parseInt(attribute.getValue());
            }
            catch (Exception exception) {
                n = 999;
            }
            if (!attribute.getName().endsWith("_MAX")) continue;
            String string3 = attribute.getName().substring(0, attribute.getName().indexOf("_MAX"));
            for (GenericObject genericObject : arrayList) {
                if (!genericObject.getXMLID().equals(string3)) continue;
                this.characteristicMaxima.put(genericObject.getXMLID(), n);
                continue block74;
            }
        }
    }

    public void saveRulesDefinition(String string) {
        try {
            Element element = this.getRulesXML();
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            XMLOutputter xMLOutputter = new XMLOutputter(format);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            xMLOutputter.output(new Document(element), (OutputStream)fileOutputStream);
            fileOutputStream.close();
            this.currentSet = string;
            HeroDesigner.getInstance().getPrefs().setLastRule(string);
            HeroDesigner.getInstance().getPrefs().setRulesDir(new File(string).getParent());
            this.dirty = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred saving the rules file.\n\nError Message: " + exception.getMessage(), "Error saving rules", 0);
        }
    }

    public void setAPPerEND(int n) {
        if (n != this.APPerEND) {
            this.dirty = true;
        }
        this.APPerEND = n;
    }

    public void setAttackAPMaxResponse(int n) {
        if (n != this.attackAPMaxResponse) {
            this.dirty = true;
        }
        this.attackAPMaxResponse = n;
    }

    public void setAttackAPMaxValue(int n) {
        if (n != this.attackAPMaxValue) {
            this.dirty = true;
        }
        this.attackAPMaxValue = n;
    }

    public void setAutomaticallyApplyNoFigured(boolean bl) {
        if (bl != this.automaticallyApplyNoFigured) {
            this.dirty = true;
        }
        this.automaticallyApplyNoFigured = bl;
    }

    public void setAvailDisadPointsResponse(int n) {
        if (n != this.availDisadPointsResponse) {
            this.dirty = true;
        }
        this.availDisadPointsResponse = n;
    }

    public void setAvailTotalPointsResponse(int n) {
        if (n != this.availTotalPointsResponse) {
            this.dirty = true;
        }
        this.availTotalPointsResponse = n;
    }

    public void setBasePoints(int n) {
        if (n != this.basePoints) {
            this.dirty = true;
        }
        this.basePoints = n;
    }

    public void setCampaignSet(String string) {
        this.campaignSet = string;
    }

    public void setCharacteristicMaxResponse(int n) {
        if (n != this.characteristicMaxResponse) {
            this.dirty = true;
        }
        this.characteristicMaxResponse = n;
    }

    public void setCharacteristicMaxValue(int n) {
        if (n != this.characteristicMaxValue) {
            this.dirty = true;
        }
        this.characteristicMaxValue = n;
    }

    public void setCurrentSet(String string) {
        this.currentSet = string;
    }

    public void setDefaultStandardEffect(boolean bl) {
        this.defaultStandardEffect = bl;
    }

    public void setDefenseAPMaxResponse(int n) {
        if (n != this.defenseAPMaxResponse) {
            this.dirty = true;
        }
        this.defenseAPMaxResponse = n;
    }

    public void setDefenseAPMaxValue(int n) {
        if (n != this.defenseAPMaxValue) {
            this.dirty = true;
        }
        this.defenseAPMaxValue = n;
    }

    public void setDisadCategoryMaxResponse(int n) {
        if (n != this.disadCategoryMaxResponse) {
            this.dirty = true;
        }
        this.disadCategoryMaxResponse = n;
    }

    public void setDisadCategoryMaxValue(int n) {
        if (n != this.disadCategoryMaxValue) {
            this.dirty = true;
        }
        this.disadCategoryMaxValue = n;
    }

    public void setDisadPoints(int n) {
        if (n != this.disadPoints) {
            this.dirty = true;
        }
        this.disadPoints = n;
    }

    public void setEquipmentAllowed(boolean bl) {
        this.equipmentAllowed = bl;
    }

    public void setEquipmentCostConversion(double d) {
        if (d != 0.0) {
            this.equipmentCostConversion = d;
        }
    }

    public void setEquipmentCostDecimalPlaces(int n) {
        this.equipmentCostDecimalPlaces = n;
    }

    public void setEquipmentCostResponse(int n) {
        if (n != this.equipmentCostResponse) {
            this.dirty = true;
        }
        this.equipmentCostResponse = n;
    }

    public void setEquipmentCostUnits(String string) {
        if (string.equals(this.equipmentCostUnits)) {
            this.dirty = true;
        }
        this.equipmentCostUnits = string;
    }

    public void setEquipmentCostValue(int n) {
        if (n != this.equipmentCostValue) {
            this.dirty = true;
        }
        this.equipmentCostValue = n;
    }

    public void setEquipmentUnitsPrefix(boolean bl) {
        if (bl != this.equipmentUnitsPrefix) {
            this.dirty = true;
        }
        this.equipmentUnitsPrefix = bl;
    }

    public void setLanguageSimilaritiesUsed(boolean bl) {
        if (bl != this.languageSimilaritiesUsed) {
            this.dirty = true;
        }
        this.languageSimilaritiesUsed = bl;
    }

    public void setLinkAcrossFramework(int n) {
        this.linkAcrossFramework = n;
    }

    public void setLiteracyFree(boolean bl) {
        if (bl != this.literacyFree) {
            this.dirty = true;
        }
        this.literacyFree = bl;
    }

    public void setManeuverMaxResponse(int n) {
        this.maneuverMaxResponse = n;
    }

    public void setManeuverMaxValue(int n) {
        this.maneuverMaxValue = n;
    }

    public void setMultiplierAllowed(boolean bl) {
        this.multiplierAllowed = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNativeLiteracyFree(boolean bl) {
        if (bl != this.nativeLiteracyFree) {
            this.dirty = true;
        }
        this.nativeLiteracyFree = bl;
    }

    public void setNCMSelected(boolean bl) {
        this.ncmSelected = bl;
    }

    public void setNCMUserChangeable(boolean bl) {
        this.ncmUserChangeable = bl;
    }

    public void setNonENDUsingAbilityInEC(int n) {
        this.nonENDUsingAbilityInEC = n;
    }

    public void setNotes1Label(String string) {
        if (this.getNotes1Label().equals(string)) {
            return;
        }
        this.notes1Label = string;
        this.dirty = true;
    }

    public void setNotes2Label(String string) {
        if (this.getNotes2Label().equals(string)) {
            return;
        }
        this.notes2Label = string;
        this.dirty = true;
    }

    public void setNotes3Label(String string) {
        if (this.getNotes3Label().equals(string)) {
            return;
        }
        this.notes3Label = string;
        this.dirty = true;
    }

    public void setNotes4Label(String string) {
        if (this.getNotes4Label().equals(string)) {
            return;
        }
        this.notes4Label = string;
        this.dirty = true;
    }

    public void setNotes5Label(String string) {
        if (this.getNotes5Label().equals(string)) {
            return;
        }
        this.notes5Label = string;
        this.dirty = true;
    }

    public void setOnlySellOneFigured(boolean bl) {
        this.onlySellOneFigured = bl;
    }

    public void setPenalizeNoLevel1(boolean bl) {
        this.penalizeNoLevel1 = bl;
    }

    public void setPerkMaxResponse(int n) {
        if (n != this.perkMaxResponse) {
            this.dirty = true;
        }
        this.perkMaxResponse = n;
    }

    public void setPerkMaxValue(int n) {
        if (n != this.perkMaxValue) {
            this.dirty = true;
        }
        this.perkMaxValue = n;
    }

    public void setPowerMaxResponse(int n) {
        if (n != this.powerMaxResponse) {
            this.dirty = true;
        }
        this.powerMaxResponse = n;
    }

    public void setPowerMaxValue(int n) {
        if (n != this.powerMaxValue) {
            this.dirty = true;
        }
        this.powerMaxValue = n;
    }

    public void setSkillMaximaLimit(int n) {
        this.skillMaximaLimit = n;
    }

    public void setSkillMaxResponse(int n) {
        if (n != this.skillMaxResponse) {
            this.dirty = true;
        }
        this.skillMaxResponse = n;
    }

    public void setSkillMaxValue(int n) {
        if (n != this.skillMaxValue) {
            this.dirty = true;
        }
        this.skillMaxValue = n;
    }

    public void setSpecialTypeInFramework(int n) {
        this.specialTypeInFramework = n;
    }

    public void setStandardEffectAllowed(boolean bl) {
        if (bl != this.standardEffectAllowed) {
            this.dirty = true;
        }
        this.standardEffectAllowed = bl;
    }

    public void setSTRAPPerEND(int n) {
        this.STRAPPerEND = n;
    }

    public void setTalentMaxResponse(int n) {
        if (n != this.talentMaxResponse) {
            this.dirty = true;
        }
        this.talentMaxResponse = n;
    }

    public void setTalentMaxValue(int n) {
        if (n != this.talentMaxValue) {
            this.dirty = true;
        }
        this.talentMaxValue = n;
    }

    public void setUseExpandedGrowthChart(boolean bl) {
        if (bl != this.useExpandedGrowthChart) {
            this.dirty = true;
        }
        this.useExpandedGrowthChart = bl;
    }

    public void setUseIncreasedDamageDifferentiation(boolean bl) {
        if (this.useIncreasedDamageDifferentiation != bl) {
            this.dirty = true;
        }
        this.useIncreasedDamageDifferentiation = bl;
    }

    public void setUseNotes1(boolean bl) {
        if (this.useNotes1 == bl) {
            return;
        }
        this.useNotes1 = bl;
        this.dirty = true;
    }

    public void setUseNotes2(boolean bl) {
        if (this.useNotes2 == bl) {
            return;
        }
        this.useNotes2 = bl;
        this.dirty = true;
    }

    public void setUseNotes3(boolean bl) {
        if (this.useNotes3 == bl) {
            return;
        }
        this.useNotes3 = bl;
        this.dirty = true;
    }

    public void setUseNotes4(boolean bl) {
        if (this.useNotes4 == bl) {
            return;
        }
        this.useNotes4 = bl;
        this.dirty = true;
    }

    public void setUseNotes5(boolean bl) {
        if (this.useNotes5 == bl) {
            return;
        }
        this.useNotes5 = bl;
        this.dirty = true;
    }

    public void setUseSkillMaxima(boolean bl) {
        this.useSkillMaxima = bl;
    }

    public void setUseSkillMultipliers(boolean bl) {
        this.useSkillMultipliers = bl;
    }

    public void setLanguagesAsINTSkill(boolean bl) {
        this.languagesAsINTSkill = bl;
    }

    public void useDefault() {
        this.name = "";
        this.basePoints = 200;
        this.disadPoints = 150;
        this.APPerEND = 10;
        this.STRAPPerEND = 10;
        this.ncmSelected = false;
        this.useSkillMaxima = false;
        this.skillMaximaLimit = 13;
        this.ncmUserChangeable = true;
        this.attackAPMaxValue = 90;
        this.attackAPMaxResponse = 0;
        this.defenseAPMaxValue = 90;
        this.defenseAPMaxResponse = 0;
        this.disadCategoryMaxValue = 75;
        this.disadCategoryMaxResponse = 0;
        this.availDisadPointsResponse = 0;
        this.availTotalPointsResponse = 0;
        this.characteristicMaxValue = 1000;
        this.characteristicMaxResponse = 0;
        this.skillMaxValue = 1000;
        this.skillMaxResponse = 0;
        this.perkMaxValue = 1000;
        this.perkMaxResponse = 0;
        this.talentMaxValue = 1000;
        this.talentMaxResponse = 0;
        this.powerMaxValue = 1000;
        this.powerMaxResponse = 0;
        this.equipmentCostValue = 1000;
        this.equipmentCostResponse = 0;
        this.equipmentCostUnits = "$";
        this.equipmentCostConversion = 1.0;
        this.equipmentCostDecimalPlaces = 0;
        this.equipmentUnitsPrefix = true;
        this.standardEffectAllowed = true;
        this.useExpandedGrowthChart = false;
        this.defaultStandardEffect = false;
        this.multiplierAllowed = false;
        this.languageSimilaritiesUsed = false;
        this.literacyFree = false;
        this.nativeLiteracyFree = true;
        this.maneuverMaxResponse = 0;
        this.maneuverMaxValue = 1000;
        this.equipmentAllowed = false;
        this.penalizeNoLevel1 = false;
        this.onlySellOneFigured = true;
        this.useIncreasedDamageDifferentiation = false;
        this.linkAcrossFramework = 2;
        this.specialTypeInFramework = 1;
        this.nonENDUsingAbilityInEC = 1;
        this.automaticallyApplyNoFigured = true;
        this.useNotes1 = false;
        this.useNotes2 = false;
        this.useNotes3 = false;
        this.useNotes4 = false;
        this.useNotes5 = false;
        this.notes1Label = "Notes 1";
        this.notes2Label = "Notes 2";
        this.notes3Label = "Notes 3";
        this.notes4Label = "Notes 4";
        this.notes5Label = "Notes 5";
        this.currentSet = "Default";
        this.campaignSet = "";
        this.dirty = false;
        this.characteristicMaxima = new Hashtable();
    }

    public boolean useExpandedGrowthChart() {
        return this.useExpandedGrowthChart;
    }

    public boolean useIncreasedDamageDifferentiation() {
        return this.useIncreasedDamageDifferentiation;
    }

    public boolean useNotes1() {
        return this.useNotes1;
    }

    public boolean useNotes2() {
        return this.useNotes2;
    }

    public boolean useNotes3() {
        return this.useNotes3;
    }

    public boolean useNotes4() {
        return this.useNotes4;
    }

    public boolean useNotes5() {
        return this.useNotes5;
    }

    public boolean useSkillMultipliers() {
        return this.useSkillMultipliers;
    }

    public boolean useLanguagesAsINTSkill() {
        return this.languagesAsINTSkill;
    }
}

