/*
 * Decompiled with CFR 0.152.
 */
package com.hero;

import com.hero.AppPrefs;
import com.hero.Hero;
import com.hero.Prefab;
import com.hero.Template;
import com.hero.event.HeroDesignerEventListenerI;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.MainContentPanel;
import com.hero.ui.dialog.AppPrefsDialog;
import com.hero.ui.dialog.CombatRecordDialog;
import com.hero.ui.dialog.ExportTemplateDialog;
import com.hero.ui.dialog.RulesDialog;
import com.hero.util.AutoUpdater;
import com.hero.util.BrowserControl;
import com.hero.util.HTMLWriter;
import com.hero.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class HeroDesigner {
    private static JFrame frame;
    private static final long serialVersionUID = -669790253180486994L;
    private boolean lowMemory = false;
    public static Hero activeHero;
    private static Template activeTemplate;
    private static GenericObject copyBuffer;
    private static ArrayList<Modifier> copiedMods;
    public static String docsFilePath;
    public static long lastEdit;
    private static ArrayList<PluginInfo> loadedPlugins;
    protected static JProgressBar loadProgress;
    public static boolean macOSX;
    static int fontSize;
    static Thread runner;
    private static HeroDesigner singleton;
    public static String version;
    private JMenuItem aboutMI;
    protected JWindow aboutWindow;
    private JRadioButtonMenuItem aiMI;
    private JRadioButtonMenuItem ai6EMI;
    private JRadioButtonMenuItem automatonMI;
    private JRadioButtonMenuItem automaton6EMI;
    private JRadioButtonMenuItem baseMI;
    private JRadioButtonMenuItem base6EMI;
    JLabel button;
    private JMenuItem checkAllModsMI;
    private JMenuItem applyPackageDealMI;
    private JMenuItem chooseTemplateMI;
    private JMenuItem addTemplateMI;
    private JMenuItem closeAllMI;
    private JMenuItem saveAllMI;
    private JMenuItem closeMI;
    private JMenuItem combatRecordExportMI;
    private JRadioButtonMenuItem computerMI;
    private JRadioButtonMenuItem computer6EMI;
    private JMenuItem discussionBoardMI;
    KeyEventDispatcher dispatcher;
    private JMenuItem exitMI;
    private JMenuItem exportToFileMI;
    private JMenu fileMenu;
    private JMenuItem getNewExportTemplatesMI;
    private JMenuItem getNewPackageDealsMI;
    private JMenuItem getNewCharactersMI;
    private JMenuItem getNewPrefabsMI;
    private JMenuItem getNewTemplatesMI;
    private JMenuItem gotoHeroGamesMI;
    private JFileChooser hdcChooser;
    private JFileChooser hdpChooser;
    private JMenu helpMenu;
    ImageIcon icon;
    protected ArrayList<Prefab> loadedPrefabs;
    protected JMenuItem loadPrefabMI;
    public MainContentPanel mainPanel;
    private JMenuBar menu;
    private JMenuItem newFromTemplateMI;
    private JMenuItem newMI;
    private JMenu newCharacterMenu;
    private JMenuItem newPrefabMI;
    protected ArrayList<Hero> openHeroes;
    private JMenuItem openMI;
    private JMenuItem openPrefabMI;
    private JRadioButtonMenuItem packageTemplateMI;
    private JMenu prefabMenu;
    private AppPrefs prefs;
    private JMenuItem previewCombatRecordMI;
    private JMenuItem previewExportMI;
    private JMenu recentMI;
    private JMenuItem rulesDefaultMI;
    private JMenuItem rulesLoadMI;
    private JMenu rulesMenu;
    private JMenuItem rulesViewMI;
    private JMenuItem saveAsMI;
    private JMenuItem saveAsPrefabMI;
    private JMenuItem saveAsTemplateMI;
    protected JMenuItem saveMI;
    private JMenuItem setExportTemplateMI;
    private JMenuItem setPrefsMI;
    private JRadioButtonMenuItem standardHeroMI;
    private JRadioButtonMenuItem standardHero6EMI;
    private JRadioButtonMenuItem standardNormalMI;
    private JRadioButtonMenuItem standardSuperMI;
    private JRadioButtonMenuItem standardSuper6EMI;
    private JLabel statusLbl;
    private JProgressBar memoryUsagePB;
    private JMenuItem tearOffMI;
    private ButtonGroup templateGroup;
    protected JMenu templateMenu;
    protected JMenu standardTemplateMenu;
    protected JMenu standard6ETemplateMenu;
    protected JMenu nonStandardTemplateMenu;
    private JMenu toolsMenu;
    protected JMenu unloadPrefabMI;
    protected JMenuItem unloadAllPrefabsMI;
    private JRadioButtonMenuItem vehicleMI;
    private JRadioButtonMenuItem vehicle6EMI;
    protected JMenuItem viewDocsMI;
    protected ButtonGroup windowGroup;
    protected JMenu windowMenu;
    protected JMenu newStandardRulesMenu;
    protected JMenu newStandard6ERulesMenu;
    protected JMenu newCustomRulesMenu;
    protected JMenuItem newSuperheroicMI;
    protected JMenuItem newSuperheroic6EMI;
    protected JMenuItem newNormalMI;
    protected JMenuItem newHeroicMI;
    protected JMenuItem newHeroic6EMI;
    protected JMenuItem newComputerMI;
    protected JMenuItem newComputer6EMI;
    protected JMenuItem newAIMI;
    protected JMenuItem newAI6EMI;
    protected JMenuItem newAutomatonMI;
    protected JMenuItem newAutomaton6EMI;
    protected JMenuItem newVehicleMI;
    protected JMenuItem newVehicle6EMI;
    protected JMenuItem newBaseMI;
    protected JMenuItem newBase6EMI;
    protected JMenu saveMenu;
    protected JMenu exportMenu;
    protected JMenu characterMenu;
    protected JMenuItem saveAsPackageDealMI;
    private ArrayList<HeroDesignerEventListenerI> mListeners = new ArrayList();
    public static boolean headless;
    private ArrayList<String> exts = null;

    public static JFrame getAppFrame() {
        return frame;
    }

    public void addListener(HeroDesignerEventListenerI heroDesignerEventListenerI) {
        this.mListeners.add(heroDesignerEventListenerI);
    }

    public void removeListener(HeroDesignerEventListenerI heroDesignerEventListenerI) {
        this.mListeners.remove(heroDesignerEventListenerI);
    }

    public void fireCharacterLoaded(Hero hero, boolean bl) {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            this.mListeners.get(i).characterLoaded(hero, bl);
        }
    }

    public void fireTemplateChanged(Template template) {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            this.mListeners.get(i).templateChanged(template);
        }
    }

    public void fireDisplayReset() {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            this.mListeners.get(i).displayReset();
        }
    }

    public void fireAppPrefsChanged() {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            this.mListeners.get(i).preferencesChanged();
        }
    }

    public void fireTabChanged() {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            this.mListeners.get(i).tabChanged();
        }
    }

    public void firePrefabLoaded(Prefab prefab) {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            this.mListeners.get(i).prefabLoaded(prefab);
        }
    }

    private HeroDesigner(boolean bl) throws Exception {
        Hero hero;
        headless = true;
        singleton = this;
        this.openHeroes = new ArrayList();
        AppPrefs appPrefs = new AppPrefs();
        appPrefs.setCheckModsDuringEdit(false);
        appPrefs.setConfirmDelete(false);
        appPrefs.setDisplayActivePoints(true);
        appPrefs.setLoadCharacters(false);
        appPrefs.setLoadPrefabs(false);
        appPrefs.setModifierIntelligenceOn(false);
        appPrefs.setNumberDigitsForRounding(2);
        appPrefs.setPromptToExportImage(false);
        appPrefs.setShowCommonLimitations(true);
        appPrefs.setWarnOnMultiple(false);
        this.prefs = appPrefs;
        this.setTemplate("builtIn.Superheroic6E.hdt", true, false, false);
        activeHero = hero = new Hero();
        this.prefs = appPrefs;
        appPrefs.setSources(GenericObject.getAllSources());
    }

    private HeroDesigner() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        try {
            frame = new JFrame("HERO Designer");
        }
        catch (Throwable throwable) {
            frame = new JFrame("HERO Designer");
        }
        singleton = this;
        this.prefs = new AppPrefs();
        this.prefs.restorePrefs();
        if (!headless) {
            try {
                object5 = Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("about.png"));
                this.icon = new ImageIcon((Image)object5);
            }
            catch (Exception exception) {
                this.icon = new ImageIcon("about.png");
            }
            this.button = new JLabel(this.icon);
            this.button.setOpaque(false);
            loadProgress = new JProgressBar(0);
            loadProgress.setIndeterminate(true);
            loadProgress.setStringPainted(true);
            loadProgress.setBorderPainted(false);
            loadProgress.setMinimumSize(new Dimension(200, 20));
            loadProgress.setForeground(Color.black);
            loadProgress.setVisible(true);
            object5 = new JPanel(new GridBagLayout());
            ((JComponent)object5).setOpaque(false);
            object4 = new GridBagConstraints();
            ((GridBagConstraints)object4).gridx = 0;
            ((GridBagConstraints)object4).gridy = 0;
            ((GridBagConstraints)object4).weightx = 1.0;
            ((GridBagConstraints)object4).weighty = 1.0;
            ((GridBagConstraints)object4).fill = 0;
            ((GridBagConstraints)object4).anchor = 10;
            ((Container)object5).add((Component)this.button, object4);
            ++((GridBagConstraints)object4).gridy;
            ((GridBagConstraints)object4).fill = 1;
            ((Container)object5).add((Component)loadProgress, object4);
            loadProgress.setString("Starting up");
            ((JComponent)object5).setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.aboutWindow = new JWindow();
            this.aboutWindow.setContentPane((Container)object5);
            try {
                this.aboutWindow.pack();
                this.aboutWindow.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.3f));
                this.aboutWindow.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowGainedFocus(WindowEvent windowEvent) {
                    }

                    @Override
                    public void windowLostFocus(WindowEvent windowEvent) {
                    }
                });
                object3 = Toolkit.getDefaultToolkit();
                object2 = ((Toolkit)object3).getScreenSize();
                this.aboutWindow.setLocation(((Dimension)object2).width / 2 - this.aboutWindow.getPreferredSize().width / 2, ((Dimension)object2).height / 2 - this.aboutWindow.getPreferredSize().height / 2);
                this.aboutWindow.setVisible(true);
            }
            catch (Exception exception) {
                this.aboutWindow.pack();
                this.aboutWindow.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.3f));
                this.aboutWindow.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowGainedFocus(WindowEvent windowEvent) {
                    }

                    @Override
                    public void windowLostFocus(WindowEvent windowEvent) {
                    }
                });
                object2 = Toolkit.getDefaultToolkit();
                object = ((Toolkit)object2).getScreenSize();
                this.aboutWindow.setLocation(((Dimension)object).width / 2 - this.aboutWindow.getPreferredSize().width / 2, ((Dimension)object).height / 2 - this.aboutWindow.getPreferredSize().height / 2);
                this.aboutWindow.setVisible(true);
            }
            loadProgress.setString("Performing security check");
            frame.setIconImage(Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("icon.png")));
            frame.setTitle("HERO Designer 6 [build " + version + "]");
            frame.setDefaultCloseOperation(0);
        }
        this.openHeroes = new ArrayList();
        this.loadedPrefabs = new ArrayList();
        this.initWidgets();
        if (!headless) {
            loadProgress.setString("Restoring preferences");
        }
        if (!headless) {
            loadProgress.setString("Initializing components");
        }
        try {
            this.setTemplate("builtIn.Superheroic6E.hdt", true, false, false);
            activeHero = object5 = new Hero();
            if (!headless) {
                loadProgress.setString("Constructing interface");
            }
            this.mainPanel = new MainContentPanel();
            try {
                object4 = Toolkit.getDefaultToolkit().createImage(ClassLoader.getSystemResource("logo.gif"));
                this.icon = new ImageIcon((Image)object4);
            }
            catch (Exception exception) {
                this.icon = new ImageIcon("logo.gif");
            }
            if (!headless) {
                object4 = new JPanel(new GridBagLayout());
                ((Container)object4).add((Component)this.mainPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                this.statusLbl = new JLabel("");
                ((Container)object4).add((Component)this.statusLbl, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
                object3 = new BigDecimal((double)Runtime.getRuntime().maxMemory() / 1048576.0);
                object3 = ((BigDecimal)object3).setScale(0, 4);
                object2 = new BigDecimal((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0);
                object2 = ((BigDecimal)object2).setScale(0, 4);
                this.memoryUsagePB = new JProgressBar(0, ((BigDecimal)object3).intValue());
                this.memoryUsagePB.setStringPainted(true);
                this.memoryUsagePB.setString(((BigDecimal)object2).toString() + "M of " + ((BigDecimal)object2).toString() + "M");
                this.memoryUsagePB.setValue(((BigDecimal)object2).intValue());
                this.memoryUsagePB.setMinimumSize(new Dimension(80, this.memoryUsagePB.getMinimumSize().height));
                this.memoryUsagePB.setVisible(false);
                ((Container)object4).add((Component)this.memoryUsagePB, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 14, 2, new Insets(0, 5, 0, 0), 0, 0));
                frame.setContentPane((Container)object4);
                this.mainPanel.setVisible(false);
                this.statusLbl.setVisible(false);
                object = new MemoryMonitor();
                ((Thread)object).start();
            }
            this.prefs.finishRestorePrefs();
            if (activeHero.equals(object5)) {
                activeHero = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        loadProgress.setString("Loading initial screens");
        this.initListeners();
        if (HeroDesigner.getActiveTemplate() == null) {
            if (!headless) {
                loadProgress.setString("Loading Superheroic template");
            }
            this.setTemplate("builtIn.Superheroic6E.hdt", true, false, true);
        }
        if (!headless) {
            loadProgress.setString("Loading plugins...");
        }
        if (!headless) {
            loadedPlugins = new ArrayList();
            object5 = new File("plugins");
            if (!((File)object5).exists()) {
                ((File)object5).mkdir();
            }
            object4 = ((File)object5).listFiles();
            block12: for (int i = 0; i < ((File[])object4).length; ++i) {
                object2 = object4[i];
                if (!((File)object2).getName().trim().toUpperCase().endsWith("JAR")) continue;
                try {
                    object = new JarFile((File)object2);
                    PluginInfo pluginInfo = new PluginInfo((JarFile)object, ((File)object2).getAbsolutePath());
                    if (pluginInfo.getMainClass().trim().length() == 0) continue;
                    URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{((File)object2).toURI().toURL()}, ClassLoader.getSystemClassLoader());
                    Class<?> clazz = uRLClassLoader.loadClass(pluginInfo.getMainClass());
                    Method[] methodArray = clazz.getMethods();
                    for (int j = 0; j < methodArray.length; ++j) {
                        Method method = methodArray[j];
                        if (!method.getName().equals("main")) continue;
                        String[] stringArray = new String[]{};
                        Object[] objectArray = new Object[]{stringArray};
                        method.invoke(null, objectArray);
                        loadedPlugins.add(pluginInfo);
                        this.logMemory("Added Plugin (" + pluginInfo.getName() + ")");
                        continue block12;
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the " + ((File)object2).getName() + " plugin.\n\nError Message: " + exception.getMessage(), "Error occurred", 0);
                }
            }
            frame.pack();
            if (this.prefs.isRestoreWindow()) {
                frame.setSize(new Dimension(this.prefs.getSizeX(), this.prefs.getSizeY()));
                if (this.prefs.getScreenX() > 0 && this.prefs.getScreenY() > 0) {
                    frame.setLocation(this.prefs.getScreenX(), this.prefs.getScreenY());
                } else {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    object2 = toolkit.getScreenSize();
                    frame.setLocation(((Dimension)object2).width / 2 - 400, ((Dimension)object2).height / 2 - 300);
                }
            } else {
                frame.setSize(950, 650);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                object2 = toolkit.getScreenSize();
                frame.setLocation(((Dimension)object2).width / 2 - 400, ((Dimension)object2).height / 2 - 300);
            }
            frame.setVisible(true);
            if (this.prefs.isRestoreWindow()) {
                frame.setExtendedState(this.prefs.getState());
            }
            this.updateRecentMenu();
        }
        if (activeHero != null) {
            this.mainPanel.updatePrefabs();
            this.mainPanel.updateTabs();
        }
    }

    public static void clearCopyBuffer() {
        copyBuffer = null;
    }

    public static Hero getActiveHero() {
        return activeHero;
    }

    public static Template getActiveTemplate() {
        return activeTemplate;
    }

    public static GenericObject getCopyBuffer() {
        GenericObject genericObject = null;
        if (copyBuffer != null) {
            try {
                genericObject = copyBuffer.clone();
                genericObject.setParent(null);
                genericObject.resetID();
                if (genericObject instanceof List) {
                    ArrayList<GenericObject> arrayList = ((List)genericObject).getObjects();
                    ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
                    for (GenericObject genericObject2 : arrayList) {
                        genericObject2 = genericObject2.clone();
                        genericObject2.resetID();
                        genericObject2.setParent((List)genericObject);
                        arrayList2.add(genericObject2);
                    }
                    ((List)genericObject).setObjects(arrayList2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return genericObject;
    }

    public static HeroDesigner getInstance() {
        if (singleton == null) {
            new HeroDesigner();
        }
        return singleton;
    }

    public static HeroDesigner getInstance(boolean bl) throws Exception {
        if (singleton == null) {
            System.out.println("Trying headless startup");
            new HeroDesigner(true);
        }
        return singleton;
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        Object object;
        Object object2;
        macOSX = System.getProperty("os.name").toUpperCase().indexOf("MAC") >= 0;
        try {
            object2 = new FileOutputStream("trace.log");
            File file = new File("HD6.jar");
            object = new PrintStream((OutputStream)object2);
            if (file.exists()) {
                System.setErr((PrintStream)object);
            }
            if (file.exists()) {
                System.setOut((PrintStream)object);
            }
            System.out.println("HERO Designer 6 log file (build " + version + ")");
            try {
                boolean bl = false;
                if (stringArray.length > 0) {
                    System.out.println("args[0] = " + stringArray[0]);
                    fontSize = Integer.parseInt(stringArray[0]);
                    bl = true;
                }
                try {
                    if (bl) {
                        UIManager.setLookAndFeel(new NimbusLookAndFeel(){

                            @Override
                            public UIDefaults getDefaults() {
                                UIDefaults uIDefaults = super.getDefaults();
                                Font font = (Font)super.getDefaults().get("defaultFont");
                                uIDefaults.put("defaultFont", font.deriveFont((float)fontSize));
                                return uIDefaults;
                            }
                        });
                    } else {
                        UIManager.setLookAndFeel(new NimbusLookAndFeel());
                    }
                }
                catch (Exception exception) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("Current system properties:  ");
            serializable = System.getProperties();
            Iterator<Object> iterator = ((Properties)serializable).keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                System.out.println("     " + string + " = " + System.getProperty(string));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object2 = HeroDesigner.getInstance();
        try {
            block11: for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                serializable = new File((String)object);
                if (!((File)serializable).exists() || !((File)serializable).getName().trim().toUpperCase().endsWith(".HDC") && !((File)serializable).getName().trim().toUpperCase().endsWith(".HDZ") && !((File)serializable).getName().trim().toUpperCase().endsWith(".HDT") && !((File)serializable).getName().trim().toUpperCase().endsWith(".HDP")) continue;
                for (Hero hero : ((HeroDesigner)object2).openHeroes) {
                    if (hero.getSaveFile() == null || !hero.getSaveFile().getAbsolutePath().toUpperCase().equals(((File)serializable).getAbsolutePath().toUpperCase())) continue;
                    if (i != stringArray.length - 1) continue block11;
                    ((HeroDesigner)object2).setActiveHero(hero);
                    continue block11;
                }
                ((HeroDesigner)object2).openHero((File)serializable, i == stringArray.length - 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred in the application.\nPlease restart HERO Designer.\n\nError Message: " + exception.getMessage(), "Error occurred", 0);
        }
    }

    private String convertOldNames(String string) {
        if (string.indexOf("Normal") >= 0) {
            return "builtIn.Normal.hdt";
        }
        if (string.indexOf("Super") >= 0) {
            return "builtIn.Superheroic.hdt";
        }
        if (string.indexOf("Hero") >= 0) {
            return "builtIn.Heroic.hdt";
        }
        return string;
    }

    private void initListeners() {
        this.tearOffMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.mainPanel.tearOff();
            }
        });
        this.rulesViewMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RulesDialog rulesDialog = new RulesDialog();
                rulesDialog.setLocationRelativeTo(frame);
                rulesDialog.setVisible(true);
                if (!rulesDialog.cancelButtonClicked()) {
                    HeroDesigner.getActiveHero().setDirty(true);
                    HeroDesigner.this.mainPanel.reset();
                    HeroDesigner.this.updateStatus();
                }
            }
        });
        this.rulesDefaultMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.prefs.setLastRule("");
                HeroDesigner.getActiveHero().getRules().useDefault();
                Hero hero = HeroDesigner.getActiveHero();
                hero.setBasePoints(hero.getRules().getBasePoints());
                hero.setDisadPoints(hero.getRules().getDisadPoints());
                hero.setNCMSelected(hero.getRules().isNCMSelected());
                HeroDesigner.this.mainPanel.reset();
                HeroDesigner.this.updateStatus();
            }
        });
        this.rulesLoadMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                while (file == null) {
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDR");
                            }

                            @Override
                            public String getDescription() {
                                return "HERO Designer Campaign Rules";
                            }
                        });
                        this.chooser.setApproveButtonText("Load Campaign Rules");
                        this.chooser.setDialogTitle("Load Campaign Rules");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        this.chooser.setCurrentDirectory(new File(HeroDesigner.this.getPrefs().getRulesDir()));
                    }
                    int n = this.chooser.showOpenDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0) continue;
                    file = this.chooser.getSelectedFile();
                    if (!file.exists()) {
                        file = null;
                        continue;
                    }
                    HeroDesigner.this.prefs.setRulesDir(file.getParent());
                    HeroDesigner.this.prefs.setLastRule(file.getAbsolutePath());
                }
                try {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    HeroDesigner.getActiveHero().getRules().loadRulesDefinition(file.getAbsolutePath());
                    Hero hero = HeroDesigner.getActiveHero();
                    hero.setBasePoints(hero.getRules().getBasePoints());
                    hero.setDisadPoints(hero.getRules().getDisadPoints());
                    hero.setNCMSelected(hero.getRules().isNCMSelected());
                    HeroDesigner.this.mainPanel.reset();
                    HeroDesigner.this.updateStatus();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!headless) {
                        JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the selected rules file.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error loading campaign rules", 0);
                    }
                }
                finally {
                    if (!headless) {
                        frame.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        this.getNewPrefabsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL("http://www.herogames.com/files/category/5-prefabs/");
            }
        });
        this.getNewTemplatesMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL("http://www.herogames.com/files/category/4-templates/");
            }
        });
        this.getNewExportTemplatesMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL("http://www.herogames.com/files/category/2-export-formats/");
            }
        });
        this.getNewPackageDealsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL("http://www.herogames.com/files/category/1-hero-designer/");
            }
        });
        this.getNewCharactersMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL("http://www.herogames.com/files/category/3-characters/");
            }
        });
        this.gotoHeroGamesMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL("http://www.herogames.com");
            }
        });
        this.discussionBoardMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL("http://www.herogames.com/forum/14-hero-designer/");
            }
        });
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (HeroDesigner.this.aboutWindow != null) {
                    HeroDesigner.this.aboutWindow.dispose();
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HeroDesigner.this.exitMI.doClick();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                if (HeroDesigner.this.aboutWindow != null) {
                    HeroDesigner.this.aboutWindow.dispose();
                }
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                if (HeroDesigner.this.aboutWindow != null) {
                    HeroDesigner.this.aboutWindow.dispose();
                }
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (HeroDesigner.this.aboutWindow != null) {
                    HeroDesigner.this.aboutWindow.dispose();
                }
            }
        });
        frame.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.setExportTemplateMI.addActionListener(new ActionListener(){
            ExportTemplateDialog dialog = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.dialog = new ExportTemplateDialog();
                this.dialog.showOpenDialog(frame);
                if (this.dialog.canceled()) {
                    return;
                }
                String string = this.dialog.getSelectedPath();
                if (string != null && string.trim().length() > 0) {
                    HeroDesigner.getActiveHero().setExportTemplate(string);
                    HeroDesigner.this.prefs.setExportTemplateDir(new File(string).getParent());
                    HeroDesigner.this.setDirty(true);
                }
            }
        });
        this.exportToFileMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able\n to export your character to any number of different\n formats (HTML, plain text, RTF, etc.), view it in your \nsystem's native viewer, and (if desired) print out\n the resulting character sheet.", "Demo Version", 1);
                    return;
                }
                if (HeroDesigner.getActiveHero().hasFileAssociations()) {
                    int n = JOptionPane.showConfirmDialog(frame, "Would you like to export the character files that have been associated with the current character?", "Export Associated Files?", 1);
                    if (n == 2) {
                        return;
                    }
                    if (n == 1) {
                        HeroDesigner.this.exportActiveCharacter();
                        return;
                    }
                    ArrayList<File> arrayList = HeroDesigner.getActiveHero().getFileAssociations();
                    HeroDesigner.this.exportActiveCharacter();
                    for (File file : arrayList) {
                        HeroDesigner.this.openHero(file, true);
                        HeroDesigner.this.exportActiveCharacter();
                    }
                } else {
                    HeroDesigner.this.exportActiveCharacter();
                }
            }
        });
        this.previewCombatRecordMI.addActionListener(new ActionListener(){
            ArrayList<String> exts;
            CombatRecordDialog selector;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able \nto export your character to any number of different \nformats (HTML, plain text, RTF, etc.), view it in your \nsystem's native viewer, and (if desired) print out \nthe resulting character sheet.", "Demo Version", 1);
                    return;
                }
                this.selector = new CombatRecordDialog((ArrayList)HeroDesigner.this.openHeroes.clone());
                this.selector.setLocationRelativeTo(frame);
                this.selector.pack();
                this.selector.setVisible(true);
                if (this.selector.cancelButtonClicked()) {
                    return;
                }
                File file = null;
                JFileChooser jFileChooser = null;
                Object object3 = null;
                while (object3 == null || ((String)object3).trim().length() == 0) {
                    if (jFileChooser == null) {
                        jFileChooser = new ExportTemplateDialog(".HCR");
                    }
                    jFileChooser.showOpenDialog(frame);
                    if (((ExportTemplateDialog)jFileChooser).canceled()) {
                        return;
                    }
                    object2 = ((ExportTemplateDialog)jFileChooser).getSelectedPath();
                    if (object2 == null || ((String)object2).trim().length() <= 0 || !((File)(object = new File((String)object2))).exists()) continue;
                    object3 = object2;
                    HeroDesigner.this.prefs.setExportTemplateDir(((File)object).getParent());
                }
                while (file == null) {
                    try {
                        object2 = new HTMLWriter(new File((String)object3));
                        this.exts = ((HTMLWriter)object2).getFileExtensions();
                        object = this.exts.get(0);
                        file = File.createTempFile("" + System.currentTimeMillis(), "." + (String)object, new File(HeroDesigner.this.prefs.getExportTemplateDir()));
                        file.deleteOnExit();
                        if (file.getParentFile().exists()) continue;
                        file.getParentFile().mkdirs();
                    }
                    catch (Exception exception) {}
                }
                try {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    object2 = new HTMLWriter(new File((String)object3));
                    object = ((HTMLWriter)object2).generateCombatRecord(this.selector.getCharacters());
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(((String)object).getBytes());
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    String string = "file://" + file.getAbsolutePath();
                    string = string.replace('\\', '/');
                    BrowserControl.displayURL(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred during the combat record export.\nPlease try again.\n\nError Message: " + exception.getMessage(), "Error exporting combat record", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.combatRecordExportMI.addActionListener(new ActionListener(){
            JFileChooser chooser;
            ArrayList<String> exts;
            CombatRecordDialog selector;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able \nto export your character to any number of different \nformats (HTML, plain text, RTF, etc.), view it in your \nsystem's native viewer, and (if desired) print out \nthe resulting character sheet.", "Demo Version", 1);
                    return;
                }
                this.selector = new CombatRecordDialog((ArrayList)HeroDesigner.this.openHeroes.clone());
                this.selector.setLocationRelativeTo(frame);
                this.selector.pack();
                this.selector.setVisible(true);
                if (this.selector.cancelButtonClicked()) {
                    return;
                }
                File file = null;
                JFileChooser jFileChooser = null;
                Object object3 = null;
                while (object3 == null || ((String)object3).trim().length() == 0) {
                    File file2;
                    if (jFileChooser == null) {
                        jFileChooser = new ExportTemplateDialog(".HCR");
                    }
                    jFileChooser.showOpenDialog(frame);
                    if (((ExportTemplateDialog)jFileChooser).canceled()) {
                        return;
                    }
                    object2 = ((ExportTemplateDialog)jFileChooser).getSelectedPath();
                    if (object2 == null || ((String)object2).trim().length() <= 0 || !(file2 = new File((String)object2)).exists()) continue;
                    object3 = object2;
                    HeroDesigner.this.prefs.setExportTemplateDir(file2.getParent());
                }
                while (file == null) {
                    try {
                        this.chooser = new JFileChooser();
                        object2 = new HTMLWriter(new File((String)object3));
                        this.exts = ((HTMLWriter)object2).getFileExtensions();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                if (exts == null || exts.size() == 0) {
                                    return true;
                                }
                                String string = file.getName();
                                String string2 = string.substring(string.lastIndexOf(".") + 1, string.length());
                                return exts.contains(string2.trim().toUpperCase());
                            }

                            @Override
                            public String getDescription() {
                                String string = "";
                                if (exts == null || exts.size() == 0) {
                                    return "All Files";
                                }
                                for (String string2 : exts) {
                                    if (string.length() > 0) {
                                        string = string + ", ";
                                    }
                                    string = string + "*." + string2;
                                }
                                return string;
                            }
                        });
                        this.chooser.setApproveButtonText("Save");
                        this.chooser.setDialogTitle("Save");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.this.prefs.getExportDir() != null && HeroDesigner.this.prefs.getExportDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getExportDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        int n = this.chooser.showSaveDialog(frame);
                        if (n == 1) {
                            return;
                        }
                        if (n != 0) continue;
                        file = this.chooser.getSelectedFile();
                        HeroDesigner.this.prefs.setExportDir(file.getParent());
                        object = file.getName();
                        String string = ".txt";
                        if (this.exts != null && this.exts.size() > 0) {
                            string = "." + this.exts.get(0);
                        }
                        if (((String)object).indexOf(".") < 0) {
                            object = (String)object + string;
                        }
                        if (!((String)object).equals(file.getName())) {
                            String string2 = "";
                            if (file.getParentFile() != null) {
                                string2 = file.getParent();
                                if (!string2.endsWith(File.separator)) {
                                    string2 = string2 + File.separator;
                                }
                            }
                            file = new File(string2 + (String)object);
                        }
                        if (!file.exists()) continue;
                        int n2 = JOptionPane.showConfirmDialog(frame, file.getName() + " already exists.\n\nOverwrite?");
                        if (n2 == 2) {
                            return;
                        }
                        if (n2 != 1) continue;
                        file = null;
                    }
                    catch (Exception exception) {}
                }
                try {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    object2 = new HTMLWriter(new File((String)object3));
                    String string = ((HTMLWriter)object2).generateCombatRecord(this.selector.getCharacters());
                    object = new FileOutputStream(file);
                    ((FileOutputStream)object).write(string.getBytes());
                    ((OutputStream)object).flush();
                    ((FileOutputStream)object).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred during the combat record export.\nPlease try again.\n\nError Message: " + exception.getMessage(), "Error exporting combat record", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.previewExportMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able\n to preview your character in any number of different\n formats (HTML, plain text, RTF, etc.), view it in your \nsystem's native viewer, and (if desired) print out\n the resulting character sheet.", "Demo Version", 1);
                    return;
                }
                File file = null;
                File file2 = null;
                JFileChooser jFileChooser = null;
                if (HeroDesigner.getActiveHero().getExportTemplate() == null) {
                    HeroDesigner.this.setDefaultExportFormat(HeroDesigner.getActiveHero());
                }
                if (HeroDesigner.getActiveHero().getExportTemplate() != null && (!((File)(object = new File(HeroDesigner.getActiveHero().getExportTemplate()))).exists() || ((File)object).isDirectory())) {
                    HeroDesigner.getActiveHero().setExportTemplate(null);
                }
                while (HeroDesigner.getActiveHero().getExportTemplate() == null || HeroDesigner.getActiveHero().getExportTemplate().trim().length() == 0) {
                    if (jFileChooser == null) {
                        jFileChooser = new ExportTemplateDialog();
                    }
                    jFileChooser.showOpenDialog(frame);
                    if (((ExportTemplateDialog)jFileChooser).canceled()) {
                        return;
                    }
                    object = ((ExportTemplateDialog)jFileChooser).getSelectedPath();
                    if (object == null || ((String)object).trim().length() <= 0) continue;
                    HeroDesigner.getActiveHero().setExportTemplate((String)object);
                    HeroDesigner.this.prefs.setExportTemplateDir(new File((String)object).getParent());
                }
                try {
                    Object object2;
                    Object object3;
                    String string;
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    object = new HTMLWriter(new File(HeroDesigner.getActiveHero().getExportTemplate()));
                    String string2 = HeroDesigner.this.prefs.getExportTemplateDir() + File.separator;
                    string2 = string2 + System.currentTimeMillis();
                    String string3 = "";
                    string3 = ((HTMLWriter)object).getFileExtensions().size() > 0 ? "." + ((HTMLWriter)object).getFileExtensions().get(0) : ".txt";
                    string2 = string2 + string3;
                    file = File.createTempFile("" + System.currentTimeMillis(), string3, new File(HeroDesigner.this.prefs.getExportTemplateDir()));
                    try {
                        file.deleteOnExit();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.out);
                    }
                    if (HeroDesigner.getActiveHero().getImageData() != null && HeroDesigner.getActiveHero().getImageData().length > 0) {
                        string2 = HeroDesigner.this.prefs.getExportTemplateDir() + File.separator;
                        string = "" + System.currentTimeMillis();
                        string2 = string2 + string;
                        object3 = "";
                        object3 = HeroDesigner.getActiveHero().getImageFileName().substring(HeroDesigner.getActiveHero().getImageFileName().lastIndexOf("."), HeroDesigner.getActiveHero().getImageFileName().length());
                        string2 = string2 + (String)object3;
                        file2 = File.createTempFile(string, (String)object3, new File(HeroDesigner.this.prefs.getExportTemplateDir()));
                        try {
                            file2.deleteOnExit();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace(System.out);
                        }
                    }
                    string = ((HTMLWriter)object).generateOutput(file2 == null ? "" : file2.getName());
                    object3 = new FileOutputStream(file);
                    ((FileOutputStream)object3).write(string.getBytes());
                    ((OutputStream)object3).flush();
                    ((FileOutputStream)object3).close();
                    if (file2 != null) {
                        object2 = new FileOutputStream(file2);
                        ((FileOutputStream)object2).write(HeroDesigner.getActiveHero().getImageData());
                        ((OutputStream)object2).flush();
                        ((FileOutputStream)object2).close();
                    }
                    frame.setCursor(Cursor.getDefaultCursor());
                    object2 = file.getAbsolutePath();
                    object2 = ((String)object2).replace('\\', '/');
                    object2 = "file://" + (String)object2;
                    BrowserControl.displayURL((String)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred during export preview.\nPlease try again.\n\nError Message: " + exception.getMessage(), "Error exporting to file", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.setPrefsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                block0: for (Hero object22 : HeroDesigner.this.openHeroes) {
                    if (object22.isDirty()) {
                        HeroDesigner.this.setActiveHero(object22);
                    }
                    while (object22.isDirty() && !AutoUpdater.isDemo()) {
                        int n;
                        object = object22.getCharacterName();
                        if (((String)object).trim().length() == 0) {
                            object = "[unknown]";
                        }
                        if ((n = JOptionPane.showConfirmDialog(frame, (String)object + " has been changed!\n\nSave changes before editing the application preferences (changes will be lost, otherwise)?")) == 2) {
                            frame.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        if (n != 0) continue block0;
                        if (object22 instanceof Prefab) {
                            HeroDesigner.this.saveAsHDC();
                            continue;
                        }
                        HeroDesigner.this.saveAsHDC(object22);
                    }
                }
                AppPrefsDialog appPrefsDialog = new AppPrefsDialog();
                if (appPrefsDialog.getSize().getHeight() > frame.getSize().getHeight() || appPrefsDialog.getSize().getWidth() > frame.getSize().getWidth()) {
                    appPrefsDialog.setSize(frame.getSize());
                    appPrefsDialog.setLocationRelativeTo(frame);
                }
                appPrefsDialog.setVisible(true);
                frame.setCursor(Cursor.getPredefinedCursor(3));
                String string = HeroDesigner.getActiveTemplate().getId();
                activeTemplate = null;
                HeroDesigner.this.setTemplate(string, string.startsWith("builtIn"), false, false);
                object = HeroDesigner.getActiveHero();
                for (Hero hero : HeroDesigner.this.openHeroes) {
                    HeroDesigner.this.setActiveHero(hero);
                    hero.resetTemplate();
                    hero.setDirty(true);
                }
                for (Prefab prefab : HeroDesigner.this.loadedPrefabs) {
                    prefab.resetTemplate();
                }
                if (object != null) {
                    activeHero = null;
                    HeroDesigner.this.setActiveHero((Hero)object);
                }
                HeroDesigner.this.setActiveCharacterMenu();
                frame.setCursor(Cursor.getPredefinedCursor(0));
                HeroDesigner.this.fireAppPrefsChanged();
            }
        });
        this.exitMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                if (AutoUpdater.isDemo()) {
                    HeroDesigner.this.prefs.savePrefs();
                    for (int i = HeroDesigner.this.mListeners.size() - 1; i >= 0; --i) {
                        ((HeroDesignerEventListenerI)HeroDesigner.this.mListeners.get(i)).applicationShutdown();
                    }
                    System.exit(0);
                }
                block1: for (Hero hero : HeroDesigner.this.openHeroes) {
                    if (hero.isDirty()) {
                        HeroDesigner.this.setActiveHero(hero);
                    }
                    while (hero.isDirty() && !AutoUpdater.isDemo()) {
                        int n;
                        String string = hero.getCharacterName();
                        if (string.trim().length() == 0) {
                            string = "[unknown]";
                        }
                        if ((n = JOptionPane.showConfirmDialog(frame, string + " has been changed!\n\nSave changes before closing?")) == 2) {
                            frame.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        if (n != 0) continue block1;
                        if (hero instanceof Prefab) {
                            HeroDesigner.this.saveAsHDC();
                            continue;
                        }
                        HeroDesigner.this.saveAsHDC(hero);
                    }
                }
                HeroDesigner.this.mainPanel.hideFrames();
                HeroDesigner.this.prefs.savePrefs();
                System.exit(0);
            }
        });
        this.helpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(docsFilePath);
                if (!file.exists()) {
                    HeroDesigner.this.viewDocsMI.setEnabled(false);
                } else {
                    HeroDesigner.this.viewDocsMI.setEnabled(true);
                }
            }
        });
        this.viewDocsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(docsFilePath);
                if (!file.exists()) {
                    HeroDesigner.this.viewDocsMI.setEnabled(false);
                    return;
                }
                String string = "file://" + file.getAbsolutePath();
                string = string.replace('\\', '/');
                BrowserControl.displayURL(string);
            }
        });
        this.applyPackageDealMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to apply package deals to your character using this function.", "Demo Version", 1);
                    return;
                }
                File[] fileArray = null;
                while (fileArray == null || fileArray.length == 0) {
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HPK");
                            }

                            @Override
                            public String getDescription() {
                                return "HERO Designer Package Deal Files";
                            }
                        });
                        this.chooser.setApproveButtonText("Apply Package Deal");
                        this.chooser.setDialogTitle("Apply Package Deal");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(true);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.this.prefs.getSaveDir() != null && HeroDesigner.this.prefs.getSaveDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getSaveDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    n = this.chooser.showOpenDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0 || (fileArray = this.chooser.getSelectedFiles())[0].exists()) continue;
                    fileArray = null;
                }
                if (fileArray == null || fileArray.length == 0) {
                    return;
                }
                for (n = 0; n < fileArray.length; ++n) {
                    if (fileArray[n].isDirectory()) continue;
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    File file = fileArray[n];
                    if (file == null || !file.exists() || !file.canRead()) continue;
                    try {
                        SAXBuilder sAXBuilder = new SAXBuilder(false);
                        Document document = sAXBuilder.build(file);
                        sAXBuilder = null;
                        Element element = document.getRootElement();
                        Hero hero = new Hero(element);
                        HeroDesigner.getActiveHero().applyPackageDeal(hero);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                HeroDesigner.this.mainPanel.updateTabs();
                HeroDesigner.this.mainPanel.updatePrefabs();
                HeroDesigner.getActiveHero().setDirty(true);
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.checkAllModsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                if (activeHero == null) {
                    return;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                boolean bl2 = HeroDesigner.this.prefs.isModifierIntelligenceOn();
                HeroDesigner.this.prefs.setModifierIntelligenceOn(true);
                int n = 0;
                for (GenericObject genericObject : activeHero.getSkills()) {
                    bl = genericObject.verifyModifiers();
                    if (bl) continue;
                    ++n;
                }
                for (GenericObject genericObject : activeHero.getPerks()) {
                    bl = genericObject.verifyModifiers();
                    if (bl) continue;
                    ++n;
                }
                for (GenericObject genericObject : activeHero.getTalents()) {
                    bl = genericObject.verifyModifiers();
                    if (bl) continue;
                    ++n;
                }
                for (GenericObject genericObject : activeHero.getManeuvers()) {
                    bl = genericObject.verifyModifiers();
                    if (bl) continue;
                    ++n;
                }
                for (GenericObject genericObject : activeHero.getPowers()) {
                    bl = genericObject.verifyModifiers();
                    if (bl) continue;
                    ++n;
                }
                for (GenericObject genericObject : activeHero.getEquipment()) {
                    bl = genericObject.verifyModifiers();
                    if (bl) continue;
                    ++n;
                }
                HeroDesigner.this.prefs.setModifierIntelligenceOn(bl2);
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "Modifier validation complete!\n\nErrors found: " + n, "Modifier Intelligence Check", 1);
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.aboutMI.addActionListener(new ActionListener(){
            JDialog dialog;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object;
                    String string = "<html><body><table border=0 cellpadding=0 cellspacing=0><tr><td align=\"left\"><b><font size=\"8\" face=\"arial, helvetica, sans-serif\">HERO Designer 6</font></b></td></tr><tr><td align=\"right\"><b><font face=\"arial, helvetica, sans-serif\">Build " + version + "</font></b></td></tr></table><br><table border=0 cellpadding=2 cellspacing=0><tr><td align=\"right\"><font face=\"arial, helvetica, sans-serif\"><b>Created By:</b></td><td><font face=\"arial, helvetica, sans-serif\">Dan Simon</font></td></tr><tr><td align=\"right\"><font face=\"arial, helvetica, sans-serif\"><b>Concept:</b></td><td><font face=\"arial, helvetica, sans-serif\">Steven S. Long and Dan Simon</font></td></tr>";
                    if (loadedPlugins.size() > 0) {
                        string = string + "<tr><td align=\"right\"><font face=\"arial, helvetica, sans-serif\"><b>Plugins:</b></td><td><font face=\"arial, helvetica, sans-serif\"><dl>";
                        for (int i = 0; i < loadedPlugins.size(); ++i) {
                            object = (PluginInfo)loadedPlugins.get(i);
                            string = string + "<dt><b>" + ((PluginInfo)object).getName() + "</b></dt>";
                            string = string + "<dd>by: " + ((PluginInfo)object).getAuthor() + "<br />";
                            string = string + ((PluginInfo)object).getDescription() + "<br /><br />Contact: " + ((PluginInfo)object).getContact() + "</dd>";
                        }
                        string = string + "</dl></font></td></tr>";
                    }
                    string = string + "</table><br><br><blockquote>&copy;2001-2020.  All Rights Reserved.  HERO Designer and the HERO Designer logos are trademarks of Hero Games.</blockquote><br><br><div align=\"center\"><font face=\"arial, helvetica, sans-serif\">Please send any questions or comments to \"jason@herogames.com\"</font></div></body></html";
                    JEditorPane jEditorPane = new JEditorPane("text/html", string);
                    jEditorPane.setEditable(false);
                    object = new JScrollPane(jEditorPane);
                    this.dialog = new JDialog(frame, "About", true);
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)object, "Center");
                    JButton jButton = new JButton("Close");
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            dialog.setVisible(false);
                        }
                    });
                    JPanel jPanel2 = new JPanel(new FlowLayout(1));
                    jPanel2.add(jButton);
                    jPanel.add((Component)jPanel2, "South");
                    jPanel.setPreferredSize(new Dimension(400, 400));
                    this.dialog.setContentPane(jPanel);
                    this.dialog.setLocationRelativeTo(frame);
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Dimension dimension = toolkit.getScreenSize();
                    this.dialog.setLocation(dimension.width / 2 - 200, dimension.height / 2 - 200);
                    this.dialog.pack();
                    this.dialog.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.newMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newSuperheroicMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Superheroic.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newSuperheroic6EMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Superheroic6E.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newNormalMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Normal.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newHeroicMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Heroic.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newHeroic6EMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Heroic6E.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newComputerMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Computer.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newComputer6EMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Computer6E.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newAIMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("AI.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newAI6EMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("AI6E.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newAutomatonMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Automaton.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newAutomaton6EMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Automaton6E.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newVehicleMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Vehicle.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newVehicle6EMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Vehicle6E.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newBaseMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Base.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newBase6EMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Hero hero = new Hero();
                    HeroDesigner.this.openHeroes.add(hero);
                    String string = hero.getCharacterName().trim().length() == 0 ? "New Hero" : hero.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Character");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(hero);
                    HeroDesigner.this.setTemplate("Base6E.hdt", true, false, true);
                    hero.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Character");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new character.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new character", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.newPrefabMI.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Prefab prefab = new Prefab("New Prefab");
                    HeroDesigner.this.openHeroes.add(prefab);
                    String string = prefab.getCharacterName().trim().length() == 0 ? "New Prefab" : prefab.getCharacterName();
                    JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
                    String string2 = "" + HeroDesigner.this.openHeroes.size();
                    if (HeroDesigner.this.openHeroes.size() < 10) {
                        jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
                    }
                    HeroDesigner.this.windowGroup.add(jRadioButtonMenuItem);
                    HeroDesigner.this.windowMenu.add(jRadioButtonMenuItem);
                    jRadioButtonMenuItem.setSelected(true);
                    jRadioButtonMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem;
                                if (!(HeroDesigner.this.windowMenu.getItem(i) instanceof JRadioButtonMenuItem) || !(jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i)).isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.logMemory("Change to New Prefab");
                                return;
                            }
                        }
                    });
                    HeroDesigner.this.setActiveHero(prefab);
                    prefab.setDirty(false);
                    HeroDesigner.this.setDirty(false);
                    HeroDesigner.this.logMemory("New Prefab");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred creating the new prefab.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error creating new prefab", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.closeMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HeroDesigner.getActiveHero() == null) {
                    return;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                while (activeHero.isDirty() && !AutoUpdater.isDemo()) {
                    int n;
                    String string = activeHero.getCharacterName();
                    if (string.trim().length() == 0) {
                        string = "[unknown]";
                    }
                    if ((n = JOptionPane.showConfirmDialog(frame, string + " has been changed!\n\nSave changes before closing?")) == 2) {
                        frame.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    if (n == 1) break;
                    if (n != 0) continue;
                    if (HeroDesigner.getActiveHero().getSaveFile() != null && HeroDesigner.getActiveHero().getSaveFile().getName().toUpperCase().endsWith(".HDP")) {
                        HeroDesigner.this.saveAsPrefab();
                        continue;
                    }
                    HeroDesigner.this.saveAsHDC();
                }
                HeroDesigner.this.closeHero();
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.saveAllMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HeroDesigner.this.openHeroes == null) {
                    return;
                }
                Hero hero = HeroDesigner.getActiveHero();
                frame.setCursor(Cursor.getPredefinedCursor(3));
                for (int i = HeroDesigner.this.openHeroes.size() - 1; i >= 0; --i) {
                    Hero hero2 = HeroDesigner.this.openHeroes.get(i);
                    activeHero = null;
                    HeroDesigner.this.setActiveHero(hero2);
                    if (AutoUpdater.isDemo()) continue;
                    String string = activeHero.getCharacterName();
                    if (string.trim().length() == 0) {
                        string = "[unknown]";
                    }
                    if (HeroDesigner.getActiveHero().getSaveFile() != null && HeroDesigner.getActiveHero().getSaveFile().getName().toUpperCase().endsWith(".HDP")) {
                        HeroDesigner.this.saveAsPrefab();
                        continue;
                    }
                    HeroDesigner.this.saveAsHDC();
                }
                HeroDesigner.this.setActiveHero(hero);
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.closeAllMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HeroDesigner.this.openHeroes == null) {
                    return;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                for (int i = HeroDesigner.this.openHeroes.size() - 1; i >= 0; --i) {
                    Object object;
                    Hero hero;
                    activeHero = hero = HeroDesigner.this.openHeroes.get(i);
                    while (activeHero.isDirty() && !AutoUpdater.isDemo()) {
                        int n;
                        object = activeHero.getCharacterName();
                        if (((String)object).trim().length() == 0) {
                            object = "[unknown]";
                        }
                        if ((n = JOptionPane.showConfirmDialog(frame, (String)object + " has been changed!\n\nSave changes before closing?")) == 2) {
                            activeHero = null;
                            HeroDesigner.this.setActiveHero(hero);
                            frame.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        if (n == 1) break;
                        if (n != 0) continue;
                        if (HeroDesigner.getActiveHero().getSaveFile() != null && HeroDesigner.getActiveHero().getSaveFile().getName().toUpperCase().endsWith(".HDP")) {
                            HeroDesigner.this.saveAsPrefab();
                            continue;
                        }
                        HeroDesigner.this.saveAsHDC();
                    }
                    HeroDesigner.this.openHeroes.remove(i);
                    object = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i);
                    HeroDesigner.this.windowGroup.remove((AbstractButton)object);
                    HeroDesigner.this.windowMenu.remove((JMenuItem)object);
                    HeroDesigner.this.logMemory("Close Character");
                }
                if (HeroDesigner.this.openHeroes.size() > 0) {
                    HeroDesigner.this.setActiveHero(HeroDesigner.this.openHeroes.get(0));
                } else {
                    HeroDesigner.this.setActiveHero(null);
                }
                HeroDesigner.this.setActiveCharacterMenu();
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.saveMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to save your character using this function.", "Demo Version", 1);
                    return;
                }
                if (HeroDesigner.getActiveHero() == null) {
                    return;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                HeroDesigner.this.saveAsHDC();
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.saveAsPrefabMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HeroDesigner.getActiveHero() == null) {
                    return;
                }
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to save your character as a prefab using this function.", "Demo Version", 1);
                    return;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                HeroDesigner.this.saveAsPrefab();
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.saveAsPackageDealMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HeroDesigner.getActiveHero() == null) {
                    return;
                }
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to create a new package deal using this function.", "Demo Version", 1);
                    return;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                HeroDesigner.this.saveAsPackageDeal();
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.saveAsTemplateMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HeroDesigner.getActiveHero() == null) {
                    return;
                }
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to create a new template using this function.", "Demo Version", 1);
                    return;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                HeroDesigner.this.saveAsTemplate();
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.saveAsMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                int n;
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to save your character using this function.", "Demo Version", 1);
                    return;
                }
                File file = null;
                String string = "";
                if (HeroDesigner.getActiveHero().getSaveFile() != null) {
                    string = HeroDesigner.getActiveHero().getSaveFile().getName();
                }
                while (file == null) {
                    String string2;
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        if (HeroDesigner.getActiveHero().isPrefab()) {
                            this.chooser.setFileFilter(new FileFilter(){

                                @Override
                                public boolean accept(File file) {
                                    if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                        return true;
                                    }
                                    return file.getName().toUpperCase().endsWith(".HDP");
                                }

                                @Override
                                public String getDescription() {
                                    return "HERO Designer Prefab Files";
                                }
                            });
                        } else {
                            this.chooser.setFileFilter(new FileFilter(){

                                @Override
                                public boolean accept(File file) {
                                    if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                        return true;
                                    }
                                    return file.getName().toUpperCase().endsWith(".HDC");
                                }

                                @Override
                                public String getDescription() {
                                    return "HERO Designer Character Files";
                                }
                            });
                        }
                        this.chooser.setApproveButtonText("Save");
                        if (HeroDesigner.getActiveHero().isPrefab()) {
                            this.chooser.setDialogTitle("Save Prefab");
                        } else {
                            this.chooser.setDialogTitle("Save Character");
                        }
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.getActiveHero().isPrefab()) {
                            if (HeroDesigner.this.prefs.getPrefabDir() != null && HeroDesigner.this.prefs.getPrefabDir().trim().length() > 0) {
                                try {
                                    this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getPrefabDir()));
                                }
                                catch (Exception exception) {}
                            }
                        } else if (HeroDesigner.this.prefs.getSaveDir() != null && HeroDesigner.this.prefs.getSaveDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getSaveDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (string.trim().length() > 0) {
                        this.chooser.setSelectedFile(new File(string));
                    }
                    n = this.chooser.showSaveDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0) continue;
                    file = this.chooser.getSelectedFile();
                    if (HeroDesigner.getActiveHero().isPrefab()) {
                        HeroDesigner.this.prefs.setPrefabDir(file.getParent());
                    } else {
                        HeroDesigner.this.prefs.setSaveDir(file.getParent());
                    }
                    object = file.getName();
                    if (((String)object).indexOf(".") < 0) {
                        object = HeroDesigner.getActiveHero().isPrefab() ? (String)object + ".hdp" : (String)object + ".hdc";
                    } else {
                        string2 = ((String)object).substring(((String)object).lastIndexOf("."), ((String)object).length());
                        if (HeroDesigner.getActiveHero().isPrefab()) {
                            if (!string2.equalsIgnoreCase(".hdp")) {
                                object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                                object = (String)object + ".hdp";
                            }
                        } else if (!string2.equalsIgnoreCase(".hdc") && !string2.equalsIgnoreCase(".hdz")) {
                            object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                            object = (String)object + ".hdc";
                        }
                    }
                    if (!((String)object).equals(file.getName())) {
                        string2 = "";
                        if (file.getParentFile() != null) {
                            string2 = file.getParent();
                            if (!string2.endsWith(File.separator)) {
                                string2 = string2 + File.separator;
                            }
                        }
                        file = new File(string2 + (String)object);
                    }
                    if (!file.exists()) continue;
                    int n2 = JOptionPane.showConfirmDialog(frame, file.getName() + " already exists.\n\nOverwrite?");
                    if (n2 == 2) {
                        return;
                    }
                    if (n2 != 1) continue;
                    file = null;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                if (file.getName().toUpperCase().endsWith(".HDC")) {
                    if (string.toUpperCase().endsWith(".HDZ")) {
                        String string3;
                        if (HeroDesigner.getActiveTemplate().getId().indexOf("temp") >= 0) {
                            Object object2;
                            n = JOptionPane.showConfirmDialog(frame, "In order to convert from a package to a character file\nyou must save the template file from the package.\n\nWould you like to do this now?");
                            if (n == 2) {
                                return;
                            }
                            if (n == 1) {
                                return;
                            }
                            object = null;
                            JFileChooser jFileChooser = null;
                            while (object == null) {
                                String string4;
                                if (jFileChooser == null) {
                                    jFileChooser = new JFileChooser();
                                    jFileChooser.setFileFilter(new FileFilter(){

                                        @Override
                                        public boolean accept(File file) {
                                            if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                                return true;
                                            }
                                            return file.getName().toUpperCase().endsWith(".HDT");
                                        }

                                        @Override
                                        public String getDescription() {
                                            return "HERO Designer Template Files";
                                        }
                                    });
                                    jFileChooser.setApproveButtonText("Save Template");
                                    jFileChooser.setDialogTitle("Save Template");
                                    jFileChooser.setFileSelectionMode(0);
                                    jFileChooser.setMultiSelectionEnabled(false);
                                    jFileChooser.setAcceptAllFileFilterUsed(false);
                                    if (HeroDesigner.this.prefs.getTemplateDir() != null && HeroDesigner.this.prefs.getTemplateDir().trim().length() > 0) {
                                        try {
                                            this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getTemplateDir()));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                                object2 = new File(HeroDesigner.getActiveTemplate().getId()).getName();
                                try {
                                    object2 = ((String)object2).substring(0, ((String)object2).length() - 17);
                                    object2 = (String)object2 + ".jpg";
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                jFileChooser.setSelectedFile(new File((String)object2));
                                int n3 = jFileChooser.showSaveDialog(frame);
                                if (n3 == 1) {
                                    return;
                                }
                                if (n3 != 0) continue;
                                object = jFileChooser.getSelectedFile();
                                string3 = ((File)object).getName();
                                if (string3.indexOf(".") < 0) {
                                    string3 = string3 + ".hdt";
                                } else {
                                    string4 = string3.substring(string3.lastIndexOf("."), string3.length());
                                    if (!string4.equalsIgnoreCase(".hdt")) {
                                        string3 = string3.substring(0, string3.lastIndexOf("."));
                                        string3 = string3 + ".hdt";
                                    }
                                }
                                if (!string3.equals(((File)object).getName())) {
                                    string4 = "";
                                    if (((File)object).getParentFile() != null) {
                                        string4 = ((File)object).getParent();
                                        if (!string4.endsWith(File.separator)) {
                                            string4 = string4 + File.separator;
                                        }
                                    }
                                    object = new File(string4 + string3);
                                }
                                if (!((File)object).exists()) continue;
                                int n4 = JOptionPane.showConfirmDialog(frame, ((File)object).getName() + " already exists.\n\nOverwrite?");
                                if (n4 == 2) {
                                    return;
                                }
                                if (n4 != 1) continue;
                                object = null;
                            }
                            object2 = new File(HeroDesigner.getActiveTemplate().getId());
                            ((File)object2).renameTo((File)object);
                            HeroDesigner.this.setTemplate(((File)object).getAbsolutePath(), false, false, false);
                            HeroDesigner.getActiveHero().resetTemplate();
                        }
                        if (HeroDesigner.getActiveHero().getImageData() != null && HeroDesigner.getActiveHero().getImageData().length > 0) {
                            n = JOptionPane.showConfirmDialog(frame, "In order to convert from a package to a character file\nyou must save the image file from the package.\n\nWould you like to do this now?");
                            if (n == 2) {
                                return;
                            }
                            if (n == 1) {
                                return;
                            }
                            object = null;
                            JFileChooser jFileChooser = null;
                            while (object == null) {
                                if (jFileChooser == null) {
                                    jFileChooser = new JFileChooser();
                                    jFileChooser.setFileFilter(new FileFilter(){

                                        @Override
                                        public boolean accept(File file) {
                                            if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                                return true;
                                            }
                                            if (file.getName().toUpperCase().endsWith(".JPG")) {
                                                return true;
                                            }
                                            if (file.getName().toUpperCase().endsWith(".GIF")) {
                                                return true;
                                            }
                                            return file.getName().toUpperCase().endsWith(".PNG");
                                        }

                                        @Override
                                        public String getDescription() {
                                            return "Image FIles";
                                        }
                                    });
                                    jFileChooser.setApproveButtonText("Save Image");
                                    jFileChooser.setDialogTitle("Save Image");
                                    jFileChooser.setFileSelectionMode(0);
                                    jFileChooser.setMultiSelectionEnabled(false);
                                    jFileChooser.setAcceptAllFileFilterUsed(false);
                                    if (HeroDesigner.this.prefs.getImageDir() != null && HeroDesigner.this.prefs.getImageDir().trim().length() > 0) {
                                        try {
                                            jFileChooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getImageDir()));
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                                jFileChooser.setSelectedFile(new File(HeroDesigner.getActiveHero().getImageFileName()));
                                int n5 = jFileChooser.showSaveDialog(frame);
                                if (n5 == 1) {
                                    return;
                                }
                                if (n5 != 0) continue;
                                object = jFileChooser.getSelectedFile();
                                String string5 = HeroDesigner.getActiveHero().getImageFileName().substring(HeroDesigner.getActiveHero().getImageFileName().lastIndexOf("."), HeroDesigner.getActiveHero().getImageFileName().length());
                                string3 = ((File)object).getName();
                                if (string3.indexOf(".") < 0) {
                                    string3 = string3 + string5;
                                } else {
                                    String string6 = string3.substring(string3.lastIndexOf("."), string3.length());
                                    if (!string6.equalsIgnoreCase(string5)) {
                                        string3 = string3.substring(0, string3.lastIndexOf("."));
                                        string3 = string3 + string5;
                                    }
                                }
                                if (!string3.equals(((File)object).getName())) {
                                    String string7 = "";
                                    if (((File)object).getParentFile() != null) {
                                        string7 = ((File)object).getParent();
                                        if (!string7.endsWith(File.separator)) {
                                            string7 = string7 + File.separator;
                                        }
                                    }
                                    object = new File(string7 + string3);
                                }
                                if (!((File)object).exists()) continue;
                                int n6 = JOptionPane.showConfirmDialog(frame, ((File)object).getName() + " already exists.\n\nOverwrite?");
                                if (n6 == 2) {
                                    return;
                                }
                                if (n6 != 1) continue;
                                object = null;
                            }
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                                fileOutputStream.write(HeroDesigner.getActiveHero().getImageData());
                                HeroDesigner.getActiveHero().setImageData(HeroDesigner.getActiveHero().getImageData(), (File)object);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                fileNotFoundException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                    activeHero.setSaveFile(file);
                    HeroDesigner.this.saveAsHDC();
                } else {
                    activeHero.setSaveFile(file);
                    HeroDesigner.this.saveAsHDC();
                }
                frame.setCursor(Cursor.getDefaultCursor());
                HeroDesigner.this.setActiveName(activeHero.getCharacterName());
            }
        });
        this.openMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to open character files and packaged files using this function.", "Demo Version", 1);
                    return;
                }
                File[] fileArray = null;
                while (fileArray == null || fileArray.length == 0) {
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                if (file.getName().toUpperCase().endsWith(".HDC")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDZ");
                            }

                            @Override
                            public String getDescription() {
                                return "HERO Designer Files";
                            }
                        });
                        this.chooser.setApproveButtonText("Open Character");
                        this.chooser.setDialogTitle("Open");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(true);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.this.prefs.getSaveDir() != null && HeroDesigner.this.prefs.getSaveDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getSaveDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    n = this.chooser.showOpenDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0) continue;
                    fileArray = this.chooser.getSelectedFiles();
                    if (!fileArray[0].exists()) {
                        fileArray = null;
                        continue;
                    }
                    HeroDesigner.this.prefs.setSaveDir(fileArray[0].getParent());
                }
                if (fileArray == null || fileArray.length == 0) {
                    return;
                }
                block3: for (n = 0; n < fileArray.length; ++n) {
                    if (fileArray[n].isDirectory()) continue;
                    for (int i = 0; i < HeroDesigner.this.openHeroes.size(); ++i) {
                        Hero hero = HeroDesigner.this.openHeroes.get(i);
                        if (hero.getSaveFile() == null || !hero.getSaveFile().getAbsolutePath().equals(fileArray[n].getAbsolutePath())) continue;
                        HeroDesigner.this.windowMenu.getItem(i).doClick();
                        continue block3;
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    HeroDesigner.this.openHero(fileArray[n], true);
                }
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.newFromTemplateMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to create a new character from a template using this function.", "Demo Version", 1);
                    return;
                }
                File file = null;
                while (file == null) {
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDT");
                            }

                            @Override
                            public String getDescription() {
                                return "HERO Designer Templates";
                            }
                        });
                        this.chooser.setApproveButtonText("Create Character");
                        this.chooser.setDialogTitle("Create Character From Template");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.this.prefs.getTemplateDir() != null && HeroDesigner.this.prefs.getTemplateDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getTemplateDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    int n = this.chooser.showOpenDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0 || (file = this.chooser.getSelectedFile()).exists()) continue;
                    file = null;
                }
                if (file == null) {
                    return;
                }
                frame.setCursor(Cursor.getPredefinedCursor(3));
                HeroDesigner.this.openHero(file, true);
                HeroDesigner.this.prefs.setTemplateDir(file.getParent());
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.openPrefabMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (AutoUpdater.isDemo()) {
                    JOptionPane.showMessageDialog(frame, "This is a demo version of HERO Designer.\n\nIf this were a fully licensed copy, you would be able to open a prefab file for edit using this function.", "Demo Version", 1);
                    return;
                }
                File[] fileArray = null;
                while (fileArray == null || fileArray.length == 0) {
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDP");
                            }

                            @Override
                            public String getDescription() {
                                return "HERO Designer Prefab Files";
                            }
                        });
                        this.chooser.setApproveButtonText("Open Prefab");
                        this.chooser.setDialogTitle("Open Prefab");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(true);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.this.prefs.getPrefabDir() != null && HeroDesigner.this.prefs.getPrefabDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getPrefabDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    n = this.chooser.showOpenDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0) continue;
                    fileArray = this.chooser.getSelectedFiles();
                    if (!fileArray[0].exists()) {
                        fileArray = null;
                        continue;
                    }
                    HeroDesigner.this.prefs.setPrefabDir(fileArray[0].getParent());
                }
                if (fileArray == null || fileArray.length == 0) {
                    return;
                }
                block3: for (n = 0; n < fileArray.length; ++n) {
                    if (fileArray[n].isDirectory()) continue;
                    for (int i = 0; i < HeroDesigner.this.openHeroes.size(); ++i) {
                        Hero hero = HeroDesigner.this.openHeroes.get(i);
                        if (hero.getSaveFile() == null || !hero.getSaveFile().getAbsolutePath().equals(fileArray[n].getAbsolutePath())) continue;
                        HeroDesigner.this.windowMenu.getItem(i).doClick();
                        continue block3;
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    HeroDesigner.this.openHero(fileArray[n], true);
                }
                frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.standardNormalMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Normal.hdt", true, true, true);
            }
        });
        this.standardHeroMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Heroic.hdt", true, true, true);
            }
        });
        this.standardHero6EMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Heroic6E.hdt", true, true, true);
            }
        });
        this.standardSuperMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Superheroic.hdt", true, true, true);
            }
        });
        this.standardSuper6EMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Superheroic6E.hdt", true, true, true);
            }
        });
        this.vehicleMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Vehicle.hdt", true, true, true);
            }
        });
        this.vehicle6EMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Vehicle6E.hdt", true, true, true);
            }
        });
        this.baseMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Base.hdt", true, true, true);
            }
        });
        this.base6EMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Base6E.hdt", true, true, true);
            }
        });
        this.automatonMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Automaton.hdt", true, true, true);
            }
        });
        this.automaton6EMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Automaton6E.hdt", true, true, true);
            }
        });
        this.computerMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Computer.hdt", true, true, true);
            }
        });
        this.computer6EMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("Computer6E.hdt", true, true, true);
            }
        });
        this.aiMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("AI.hdt", true, true, true);
            }
        });
        this.ai6EMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate("AI6E.hdt", true, true, true);
            }
        });
        this.packageTemplateMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeroDesigner.this.setTemplate(HeroDesigner.getActiveHero().getOriginalTemplateID(), false, true, true);
            }
        });
        this.chooseTemplateMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                while (file == null) {
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDT");
                            }

                            @Override
                            public String getDescription() {
                                return "HERO Designer Templates";
                            }
                        });
                        this.chooser.setApproveButtonText("Load Template");
                        this.chooser.setDialogTitle("Load Template");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.this.prefs.getTemplateDir() != null && HeroDesigner.this.prefs.getTemplateDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getTemplateDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    int n = this.chooser.showOpenDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0 || (file = this.chooser.getSelectedFile()).exists()) continue;
                    file = null;
                }
                HeroDesigner.this.setTemplate(file.getAbsolutePath(), false, true, true);
            }
        });
        this.addTemplateMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                while (file == null) {
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDT");
                            }

                            @Override
                            public String getDescription() {
                                return "HERO Designer Templates";
                            }
                        });
                        this.chooser.setApproveButtonText("Load Template");
                        this.chooser.setDialogTitle("Load Template");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(false);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.this.prefs.getTemplateDir() != null && HeroDesigner.this.prefs.getTemplateDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getTemplateDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    int n = this.chooser.showOpenDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0 || (file = this.chooser.getSelectedFile()).exists()) continue;
                    file = null;
                }
                HeroDesigner.this.addTemplate(file.getAbsolutePath());
            }
        });
        this.loadPrefabMI.addActionListener(new ActionListener(){
            JFileChooser chooser;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File[] fileArray = null;
                while (fileArray == null || fileArray.length == 0) {
                    if (this.chooser == null) {
                        this.chooser = new JFileChooser();
                        this.chooser.setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                    return true;
                                }
                                return file.getName().toUpperCase().endsWith(".HDP");
                            }

                            @Override
                            public String getDescription() {
                                return "HERO Designer Prefabs";
                            }
                        });
                        this.chooser.setApproveButtonText("Load Prefab");
                        this.chooser.setDialogTitle("Load Prefab");
                        this.chooser.setFileSelectionMode(0);
                        this.chooser.setMultiSelectionEnabled(true);
                        this.chooser.setAcceptAllFileFilterUsed(false);
                        if (HeroDesigner.this.prefs.getPrefabDir() != null && HeroDesigner.this.prefs.getPrefabDir().trim().length() > 0) {
                            try {
                                this.chooser.setCurrentDirectory(new File(HeroDesigner.this.prefs.getPrefabDir()));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    n = this.chooser.showOpenDialog(frame);
                    if (n == 1) {
                        return;
                    }
                    if (n != 0) continue;
                    fileArray = this.chooser.getSelectedFiles();
                    if (!fileArray[0].exists()) {
                        fileArray = null;
                        continue;
                    }
                    HeroDesigner.this.prefs.setPrefabDir(fileArray[0].getParent());
                }
                try {
                    block8: for (n = 0; n < fileArray.length; ++n) {
                        if (HeroDesigner.this.lowMemory) continue;
                        for (Prefab prefab : HeroDesigner.this.loadedPrefabs) {
                            if (prefab.getSaveFile() == null || !prefab.getSaveFile().getAbsolutePath().equals(fileArray[n].getAbsolutePath())) continue;
                            continue block8;
                        }
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        Object object3 = null;
                        if (fileArray[n].getName().toUpperCase().endsWith(".HDP")) {
                            object3 = new Prefab(fileArray[n], true);
                        }
                        if (HeroDesigner.this.lowMemory) continue;
                        if (object3 != null) {
                            HeroDesigner.this.loadedPrefabs.add((Prefab)object3);
                            HeroDesigner.this.firePrefabLoaded((Prefab)object3);
                        }
                        String string = ((Prefab)object3).getName().trim().length() == 0 ? "[unknown]" : ((Prefab)object3).getName();
                        JMenuItem jMenuItem = new JMenuItem(string);
                        jMenuItem.addActionListener(new PrefabActionListener((Prefab)object3, jMenuItem));
                        if (HeroDesigner.this.lowMemory) continue;
                        HeroDesigner.this.unloadPrefabMI.add(jMenuItem);
                    }
                    if (activeHero != null && !HeroDesigner.this.lowMemory) {
                        HeroDesigner.this.mainPanel.updatePrefabs();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the selected prefab.\nPlease restart HERO Designer and try again.\n\nError Message: " + exception.getMessage(), "Error loading prefab", 0);
                }
                finally {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.unloadAllPrefabsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = HeroDesigner.this.unloadPrefabMI.getItemCount() - 1; i >= 0; --i) {
                    HeroDesigner.this.unloadPrefabMI.getItem(i).doClick();
                }
            }
        });
    }

    private void initWidgets() {
        this.saveMenu = new JMenu("Save", false);
        this.exportMenu = new JMenu("Export", false);
        this.characterMenu = new JMenu("Current File", false);
        this.characterMenu.setMnemonic('C');
        this.fileMenu = new JMenu("File", false);
        this.fileMenu.setMnemonic('F');
        this.newMI = new JMenuItem("New Character (current template)");
        this.newMI.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        this.newStandardRulesMenu = new JMenu("New Character (Hero System 5th Edition Rules)");
        this.newStandard6ERulesMenu = new JMenu("New Character (Hero System 6th Edition Rules)");
        this.newCustomRulesMenu = new JMenu("New Character (Custom/Non-Standard Rules)");
        this.newNormalMI = new JMenuItem("Normal");
        this.newStandardRulesMenu.add(this.newNormalMI);
        this.newHeroicMI = new JMenuItem("Heroic");
        this.newStandardRulesMenu.add(this.newHeroicMI);
        this.newSuperheroicMI = new JMenuItem("Superheroic");
        this.newStandardRulesMenu.add(this.newSuperheroicMI);
        this.newStandardRulesMenu.addSeparator();
        this.newVehicleMI = new JMenuItem("Vehicle");
        this.newStandardRulesMenu.add(this.newVehicleMI);
        this.newBaseMI = new JMenuItem("Base");
        this.newStandardRulesMenu.add(this.newBaseMI);
        this.newAutomatonMI = new JMenuItem("Automaton");
        this.newStandardRulesMenu.add(this.newAutomatonMI);
        this.newComputerMI = new JMenuItem("Computer");
        this.newStandardRulesMenu.add(this.newComputerMI);
        this.newAIMI = new JMenuItem("AI");
        this.newStandardRulesMenu.add(this.newAIMI);
        this.newHeroic6EMI = new JMenuItem("Heroic");
        this.newStandard6ERulesMenu.add(this.newHeroic6EMI);
        this.newSuperheroic6EMI = new JMenuItem("Superheroic");
        this.newStandard6ERulesMenu.add(this.newSuperheroic6EMI);
        this.newStandard6ERulesMenu.addSeparator();
        this.newVehicle6EMI = new JMenuItem("Vehicle");
        this.newStandard6ERulesMenu.add(this.newVehicle6EMI);
        this.newBase6EMI = new JMenuItem("Base");
        this.newStandard6ERulesMenu.add(this.newBase6EMI);
        this.newAutomaton6EMI = new JMenuItem("Automaton");
        this.newStandard6ERulesMenu.add(this.newAutomaton6EMI);
        this.newComputer6EMI = new JMenuItem("Computer");
        this.newStandard6ERulesMenu.add(this.newComputer6EMI);
        this.newAI6EMI = new JMenuItem("AI");
        this.newStandard6ERulesMenu.add(this.newAI6EMI);
        this.newFromTemplateMI = new JMenuItem("Choose File...");
        this.newCustomRulesMenu.add(this.newFromTemplateMI);
        this.newCharacterMenu = new JMenu("New Character");
        this.newCharacterMenu.add(this.newMI);
        this.newCharacterMenu.add(this.newStandard6ERulesMenu);
        this.newCharacterMenu.add(this.newStandardRulesMenu);
        this.newCharacterMenu.add(this.newCustomRulesMenu);
        this.newPrefabMI = new JMenuItem("New Prefab");
        this.openMI = new JMenuItem("Open Character...");
        this.openMI.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.recentMI = new JMenu("Open Recent");
        this.openPrefabMI = new JMenuItem("Open Prefab...");
        this.closeMI = new JMenuItem("Close Character");
        this.closeMI.setEnabled(false);
        this.closeMI.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        this.closeAllMI = new JMenuItem("Close All Files");
        this.closeAllMI.setEnabled(false);
        this.saveAllMI = new JMenuItem("Save All Files");
        this.saveAllMI.setEnabled(false);
        this.saveMI = new JMenuItem("Save Character");
        this.saveMI.setEnabled(false);
        this.saveMI.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this.saveAsMI = new JMenuItem("Save Character As...");
        this.saveAsMI.setAccelerator(KeyStroke.getKeyStroke(83, 8, false));
        this.saveAsMI.setEnabled(false);
        this.saveAsPackageDealMI = new JMenuItem("Save As Package Deal...");
        this.saveAsPackageDealMI.setEnabled(false);
        this.saveAsPrefabMI = new JMenuItem("Save As Prefab...");
        this.saveAsPrefabMI.setEnabled(false);
        this.saveAsPrefabMI.setAccelerator(KeyStroke.getKeyStroke(80, 8, false));
        this.saveAsTemplateMI = new JMenuItem("Save As Template...");
        this.saveAsTemplateMI.setEnabled(false);
        this.templateMenu = new JMenu("Change Current Template", false);
        this.standard6ETemplateMenu = new JMenu("Hero System 6th Edition Rules");
        this.standardTemplateMenu = new JMenu("Hero System 5th Edition Rules");
        this.nonStandardTemplateMenu = new JMenu("Custom/Non-Standard Rules");
        this.templateMenu.add(this.standard6ETemplateMenu);
        this.templateMenu.add(this.standardTemplateMenu);
        this.templateMenu.add(this.nonStandardTemplateMenu);
        this.templateGroup = new ButtonGroup();
        this.standardNormalMI = new JRadioButtonMenuItem("Normal");
        this.templateGroup.add(this.standardNormalMI);
        this.standardTemplateMenu.add(this.standardNormalMI);
        this.standardHeroMI = new JRadioButtonMenuItem("Heroic");
        this.templateGroup.add(this.standardHeroMI);
        this.standardTemplateMenu.add(this.standardHeroMI);
        this.standardSuperMI = new JRadioButtonMenuItem("Superheroic");
        this.templateGroup.add(this.standardSuperMI);
        this.standardTemplateMenu.add(this.standardSuperMI);
        this.standardTemplateMenu.addSeparator();
        this.vehicleMI = new JRadioButtonMenuItem("Vehicle");
        this.templateGroup.add(this.vehicleMI);
        this.standardTemplateMenu.add(this.vehicleMI);
        this.baseMI = new JRadioButtonMenuItem("Base");
        this.templateGroup.add(this.baseMI);
        this.standardTemplateMenu.add(this.baseMI);
        this.automatonMI = new JRadioButtonMenuItem("Automaton");
        this.templateGroup.add(this.automatonMI);
        this.standardTemplateMenu.add(this.automatonMI);
        this.computerMI = new JRadioButtonMenuItem("Computer");
        this.templateGroup.add(this.computerMI);
        this.standardTemplateMenu.add(this.computerMI);
        this.aiMI = new JRadioButtonMenuItem("AI");
        this.templateGroup.add(this.aiMI);
        this.standardTemplateMenu.add(this.aiMI);
        this.packageTemplateMI = new JRadioButtonMenuItem("Revert to Original Template");
        this.templateGroup.add(this.packageTemplateMI);
        this.templateMenu.add(this.packageTemplateMI);
        this.standardHero6EMI = new JRadioButtonMenuItem("Heroic");
        this.templateGroup.add(this.standardHero6EMI);
        this.standard6ETemplateMenu.add(this.standardHero6EMI);
        this.standardSuper6EMI = new JRadioButtonMenuItem("Superheroic");
        this.templateGroup.add(this.standardSuper6EMI);
        this.standard6ETemplateMenu.add(this.standardSuper6EMI);
        this.standard6ETemplateMenu.addSeparator();
        this.vehicle6EMI = new JRadioButtonMenuItem("Vehicle");
        this.templateGroup.add(this.vehicle6EMI);
        this.standard6ETemplateMenu.add(this.vehicle6EMI);
        this.base6EMI = new JRadioButtonMenuItem("Base");
        this.templateGroup.add(this.base6EMI);
        this.standard6ETemplateMenu.add(this.base6EMI);
        this.automaton6EMI = new JRadioButtonMenuItem("Automaton");
        this.templateGroup.add(this.automaton6EMI);
        this.standard6ETemplateMenu.add(this.automaton6EMI);
        this.computer6EMI = new JRadioButtonMenuItem("Computer");
        this.templateGroup.add(this.computer6EMI);
        this.standard6ETemplateMenu.add(this.computer6EMI);
        this.ai6EMI = new JRadioButtonMenuItem("AI");
        this.templateGroup.add(this.ai6EMI);
        this.standard6ETemplateMenu.add(this.ai6EMI);
        this.addTemplateMI = new JMenuItem("Add Extension Template...");
        this.chooseTemplateMI = new JMenuItem("Choose File...");
        this.nonStandardTemplateMenu.add(this.chooseTemplateMI);
        this.exitMI = new JMenuItem("Exit");
        this.setPrefsMI = new JMenuItem("Preferences...");
        this.exitMI.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        this.setExportTemplateMI = new JMenuItem("Set Export Format...");
        this.setExportTemplateMI.setEnabled(false);
        this.setExportTemplateMI.setAccelerator(KeyStroke.getKeyStroke(69, 10, false));
        this.exportToFileMI = new JMenuItem("Export to File...");
        this.exportToFileMI.setEnabled(false);
        this.exportToFileMI.setAccelerator(KeyStroke.getKeyStroke(69, 2, false));
        this.combatRecordExportMI = new JMenuItem("Combat Record Export...");
        this.combatRecordExportMI.setEnabled(false);
        this.previewCombatRecordMI = new JMenuItem("Preview Combat Record...");
        this.previewCombatRecordMI.setEnabled(false);
        this.previewExportMI = new JMenuItem("Preview Character...");
        this.previewExportMI.setEnabled(false);
        this.previewExportMI.setAccelerator(KeyStroke.getKeyStroke(69, 8, false));
        this.fileMenu.add(this.newCharacterMenu);
        this.fileMenu.add(this.openMI);
        this.fileMenu.add(this.recentMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.newPrefabMI);
        this.fileMenu.add(this.openPrefabMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveAllMI);
        this.fileMenu.add(this.closeAllMI);
        this.fileMenu.addSeparator();
        this.saveMenu.add(this.saveMI);
        this.saveMenu.add(this.saveAsMI);
        this.saveMenu.addSeparator();
        this.saveMenu.add(this.saveAsPackageDealMI);
        this.saveMenu.add(this.saveAsPrefabMI);
        this.saveMenu.add(this.saveAsTemplateMI);
        this.exportMenu.add(this.setExportTemplateMI);
        this.exportMenu.add(this.previewExportMI);
        this.exportMenu.add(this.exportToFileMI);
        this.fileMenu.add(this.previewCombatRecordMI);
        this.fileMenu.add(this.combatRecordExportMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.setPrefsMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMI);
        this.prefabMenu = new JMenu("Prefabs", false);
        this.loadPrefabMI = new JMenuItem("Load Prefab...");
        this.loadPrefabMI.setAccelerator(KeyStroke.getKeyStroke(76, 2, false));
        this.unloadPrefabMI = new JMenu("Unload Prefab", false);
        this.unloadAllPrefabsMI = new JMenuItem("Unload All Prefabs");
        this.prefabMenu.add(this.loadPrefabMI);
        this.prefabMenu.add(this.unloadPrefabMI);
        this.prefabMenu.addSeparator();
        this.prefabMenu.add(this.unloadAllPrefabsMI);
        this.rulesMenu = new JMenu("Campaign Rules", false);
        this.rulesLoadMI = new JMenuItem("Load Campaign Rules...");
        this.rulesDefaultMI = new JMenuItem("Set to Hero System Default");
        this.rulesViewMI = new JMenuItem("View/Edit Campaign Rules");
        this.rulesMenu.add(this.rulesLoadMI);
        this.rulesMenu.add(this.rulesViewMI);
        this.rulesMenu.addSeparator();
        this.rulesMenu.add(this.rulesDefaultMI);
        this.helpMenu = new JMenu("Help", false);
        this.helpMenu.setMnemonic('H');
        this.aboutMI = new JMenuItem("About");
        this.aboutMI.setAccelerator(KeyStroke.getKeyStroke(65, 8, false));
        this.viewDocsMI = new JMenuItem("View Documentation...");
        this.viewDocsMI.setAccelerator(KeyStroke.getKeyStroke(68, 2, false));
        this.helpMenu.add(this.viewDocsMI);
        this.helpMenu.addSeparator();
        this.discussionBoardMI = new JMenuItem("Go to HERO Designer Forum...");
        this.discussionBoardMI.setAccelerator(KeyStroke.getKeyStroke(68, 8, false));
        this.helpMenu.add(this.discussionBoardMI);
        this.gotoHeroGamesMI = new JMenuItem("Go to HERO Games Website...");
        this.gotoHeroGamesMI.setAccelerator(KeyStroke.getKeyStroke(72, 9, false));
        this.helpMenu.add(this.gotoHeroGamesMI);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.aboutMI);
        this.toolsMenu = new JMenu("Tools", false);
        this.toolsMenu.setMnemonic('T');
        this.tearOffMI = new JMenuItem("Tear Off Selected Tab");
        this.tearOffMI.setEnabled(false);
        this.checkAllModsMI = new JMenuItem("Validate all Modifiers on Character");
        this.checkAllModsMI.setEnabled(false);
        this.applyPackageDealMI = new JMenuItem("Apply Package Deal...");
        this.applyPackageDealMI.setEnabled(false);
        this.toolsMenu.addSeparator();
        this.getNewTemplatesMI = new JMenuItem("Get New Character Templates...");
        this.getNewTemplatesMI.setAccelerator(KeyStroke.getKeyStroke(84, 9, false));
        this.toolsMenu.add(this.getNewTemplatesMI);
        this.getNewPrefabsMI = new JMenuItem("Get New Prefabs...");
        this.getNewPrefabsMI.setAccelerator(KeyStroke.getKeyStroke(80, 9, false));
        this.toolsMenu.add(this.getNewPrefabsMI);
        this.getNewExportTemplatesMI = new JMenuItem("Get New Export Formats...");
        this.getNewExportTemplatesMI.setAccelerator(KeyStroke.getKeyStroke(69, 9, false));
        this.toolsMenu.add(this.getNewExportTemplatesMI);
        this.getNewPackageDealsMI = new JMenuItem("Get New Package Deals...");
        this.toolsMenu.add(this.getNewPackageDealsMI);
        this.getNewCharactersMI = new JMenuItem("Find Pre-Defined Character Files...");
        this.toolsMenu.add(this.getNewCharactersMI);
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(this.tearOffMI);
        this.windowMenu = new JMenu("Open Files", false);
        this.windowMenu.setMnemonic('C');
        this.windowGroup = new ButtonGroup();
        this.templateMenu.setEnabled(false);
        this.prefabMenu.setEnabled(false);
        this.rulesMenu.setEnabled(false);
        this.windowMenu.setEnabled(false);
        this.menu = new JMenuBar();
        this.menu.add(this.fileMenu);
        this.menu.add(this.characterMenu);
        this.characterMenu.add(this.saveMenu);
        this.characterMenu.add(this.exportMenu);
        this.characterMenu.addSeparator();
        this.characterMenu.add(this.templateMenu);
        this.characterMenu.add(this.addTemplateMI);
        this.characterMenu.add(this.rulesMenu);
        this.characterMenu.add(this.applyPackageDealMI);
        this.characterMenu.add(this.checkAllModsMI);
        this.characterMenu.addSeparator();
        this.characterMenu.add(this.closeMI);
        this.menu.add(this.windowMenu);
        this.menu.add(this.prefabMenu);
        this.menu.add(this.toolsMenu);
        this.menu.add(this.helpMenu);
        frame.setJMenuBar(this.menu);
    }

    private void resetPrefabs() {
        if (this.loadedPrefabs == null) {
            this.loadedPrefabs = new ArrayList();
        }
        for (Prefab prefab : this.loadedPrefabs) {
            prefab.initFromSave();
            if (activeHero == null) continue;
            this.mainPanel.updatePrefabs();
        }
    }

    private void saveAsHDC() {
        this.saveAsHDC(HeroDesigner.getActiveHero());
    }

    private void saveAsHDC(Hero hero) {
        Object object;
        if (hero == null) {
            return;
        }
        String string = hero.getCharacterName();
        if (string.trim().length() == 0) {
            string = "[unknown]";
        }
        File file = hero.getSaveFile();
        this.hdcChooser = null;
        while (file == null) {
            String string2;
            if (this.hdcChooser == null) {
                this.hdcChooser = new JFileChooser();
                if (hero.isPrefab()) {
                    this.hdcChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                return true;
                            }
                            return file.getName().toUpperCase().endsWith(".HDP");
                        }

                        @Override
                        public String getDescription() {
                            return "HERO Designer Prefab Files";
                        }
                    });
                } else {
                    this.hdcChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                return true;
                            }
                            return file.getName().toUpperCase().endsWith(".HDC");
                        }

                        @Override
                        public String getDescription() {
                            return "HERO Designer Character Files";
                        }
                    });
                }
                this.hdcChooser.setApproveButtonText("Save");
                if (hero.isPrefab()) {
                    this.hdcChooser.setDialogTitle("Save Prefab");
                } else {
                    this.hdcChooser.setDialogTitle("Save Character");
                }
                this.hdcChooser.setFileSelectionMode(0);
                this.hdcChooser.setMultiSelectionEnabled(false);
                this.hdcChooser.setAcceptAllFileFilterUsed(false);
            }
            if (hero.isPrefab()) {
                if (this.prefs.getPrefabDir() != null && this.prefs.getPrefabDir().trim().length() > 0) {
                    try {
                        this.hdcChooser.setCurrentDirectory(new File(this.prefs.getPrefabDir()));
                    }
                    catch (Exception exception) {}
                }
            } else if (this.prefs.getSaveDir() != null && this.prefs.getSaveDir().trim().length() > 0) {
                try {
                    this.hdcChooser.setCurrentDirectory(new File(this.prefs.getSaveDir()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hero.getCharacterName() != null && hero.getCharacterName().trim().length() > 0) {
                try {
                    File file2;
                    if (hero.isPrefab()) {
                        file2 = new File(this.prefs.getPrefabDir() + File.separator + hero.getCharacterName() + ".hdp");
                        this.hdcChooser.setSelectedFile(file2);
                    } else {
                        file2 = new File(this.prefs.getSaveDir() + File.separator + hero.getCharacterName() + ".hdc");
                        this.hdcChooser.setSelectedFile(file2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n = this.hdcChooser.showSaveDialog(frame);
            if (n == 1) {
                return;
            }
            if (n != 0) continue;
            file = this.hdcChooser.getSelectedFile();
            this.prefs.setSaveDir(file.getParent());
            object = file.getName();
            if (((String)object).indexOf(".") < 0) {
                object = (String)object + (hero.isPrefab() ? ".hdp" : ".hdc");
            } else {
                string2 = ((String)object).substring(((String)object).lastIndexOf("."), ((String)object).length());
                if (hero.isPrefab()) {
                    if (!string2.equalsIgnoreCase(".hdp")) {
                        object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                        object = (String)object + ".hdp";
                    }
                } else if (!string2.equalsIgnoreCase(".hdc")) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                    object = (String)object + ".hdc";
                }
            }
            if (!((String)object).equals(file.getName())) {
                string2 = "";
                if (file.getParentFile() != null) {
                    string2 = file.getParent();
                    if (!string2.endsWith(File.separator)) {
                        string2 = string2 + File.separator;
                    }
                }
                file = new File(string2 + (String)object);
            }
            if (!file.exists()) continue;
            int n2 = JOptionPane.showConfirmDialog(frame, file.getName() + " already exists.\n\nOverwrite?");
            if (n2 == 2) {
                return;
            }
            if (n2 != 1) continue;
            file = null;
        }
        hero.setSaveFile(file);
        try {
            Element element = hero.getSaveXML();
            object = Format.getPrettyFormat();
            ((Format)object).setEncoding("UTF-16");
            XMLOutputter xMLOutputter = new XMLOutputter((Format)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            xMLOutputter.output(new Document(element), (OutputStream)fileOutputStream);
            fileOutputStream.close();
            hero.setDirty(false);
            this.prefs.addRecentFile(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred during the save process.\nPlease try again.\n\nError Message: " + exception.getMessage(), "Error saving " + (hero.isPrefab() ? "prefab" : "character"), 0);
        }
        this.updateStatus();
    }

    private void saveAsPrefab() {
        Object object;
        Object object2;
        if (HeroDesigner.getActiveHero() == null) {
            return;
        }
        String string = HeroDesigner.getActiveHero().getCharacterName();
        while (string != null && string.trim().length() == 0) {
            string = JOptionPane.showInputDialog(frame, "Please enter a name for the Prefab", "Save As Prefab", -1);
        }
        if (string == null) {
            return;
        }
        File file = HeroDesigner.getActiveHero().getSaveFile();
        if (file != null && !file.getName().toUpperCase().endsWith(".HDP")) {
            file = null;
        }
        while (file == null) {
            String string2;
            if (this.hdpChooser == null) {
                this.hdpChooser = new JFileChooser();
                this.hdpChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                            return true;
                        }
                        return file.getName().toUpperCase().endsWith(".HDP");
                    }

                    @Override
                    public String getDescription() {
                        return "HERO Designer Prefab Files";
                    }
                });
                this.hdpChooser.setApproveButtonText("Save Prefab");
                this.hdpChooser.setDialogTitle("Save As Prefab");
                this.hdpChooser.setFileSelectionMode(0);
                this.hdpChooser.setMultiSelectionEnabled(false);
                this.hdpChooser.setAcceptAllFileFilterUsed(false);
                if (this.prefs.getPrefabDir() != null && this.prefs.getPrefabDir().trim().length() > 0) {
                    try {
                        this.hdpChooser.setCurrentDirectory(new File(this.prefs.getPrefabDir()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            object2 = new File(this.hdpChooser.getCurrentDirectory().getAbsolutePath() + File.separator + string + ".hdp");
            this.hdpChooser.setSelectedFile((File)object2);
            int n = this.hdpChooser.showSaveDialog(frame);
            if (n == 1) {
                return;
            }
            if (n != 0) continue;
            file = this.hdpChooser.getSelectedFile();
            this.prefs.setPrefabDir(file.getParent());
            object = file.getName();
            if (((String)object).indexOf(".") < 0) {
                object = (String)object + ".hdp";
            } else {
                string2 = ((String)object).substring(((String)object).lastIndexOf("."), ((String)object).length());
                if (!string2.equalsIgnoreCase(".hdp")) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                    object = (String)object + ".hdp";
                }
            }
            if (!((String)object).equals(file.getName())) {
                string2 = "";
                if (file.getParentFile() != null) {
                    string2 = file.getParent();
                    if (!string2.endsWith(File.separator)) {
                        string2 = string2 + File.separator;
                    }
                }
                file = new File(string2 + (String)object);
            }
            if (!file.exists()) continue;
            int n2 = JOptionPane.showConfirmDialog(frame, file.getName() + " already exists.\n\nOverwrite?");
            if (n2 == 2) {
                return;
            }
            if (n2 != 1) continue;
            file = null;
        }
        try {
            object2 = new Prefab(string);
            ((Hero)object2).setSaveFile(file);
            ((Hero)object2).setSkills(HeroDesigner.getActiveHero().getSkills());
            ((Hero)object2).setPerks(HeroDesigner.getActiveHero().getPerks());
            ((Hero)object2).setTalents(HeroDesigner.getActiveHero().getTalents());
            ((Hero)object2).setManeuvers(HeroDesigner.getActiveHero().getManeuvers());
            ((Hero)object2).setPowers(HeroDesigner.getActiveHero().getPowers());
            ((Hero)object2).setDisads(HeroDesigner.getActiveHero().getDisads());
            ((Hero)object2).setEquipment(HeroDesigner.getActiveHero().getEquipment());
            Element element = ((Prefab)object2).getSaveXML();
            object = Format.getPrettyFormat();
            ((Format)object).setEncoding("UTF-16");
            XMLOutputter xMLOutputter = new XMLOutputter((Format)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            xMLOutputter.output(new Document(element), (OutputStream)fileOutputStream);
            fileOutputStream.close();
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new PrefabActionListener((Prefab)object2, jMenuItem));
            this.mainPanel.updatePrefabs();
            HeroDesigner.getActiveHero().setDirty(false);
            this.prefs.addRecentFile(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred during the save process.\nPlease try again.\n\nError Message: " + exception.getMessage(), "Error saving character", 0);
        }
        this.updateStatus();
    }

    private void saveAsTemplate() {
        Object object;
        if (HeroDesigner.getActiveHero() == null) {
            return;
        }
        File file = null;
        JFileChooser jFileChooser = null;
        String string = "";
        string = JOptionPane.showInputDialog(HeroDesigner.getAppFrame(), "Please enter a name for this template", "Enter Template Name", -1);
        if (string == null) {
            return;
        }
        while (file == null) {
            String string2;
            if (jFileChooser == null) {
                jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                            return true;
                        }
                        return file.getName().toUpperCase().endsWith(".HDT");
                    }

                    @Override
                    public String getDescription() {
                        return "HERO Designer Template Files";
                    }
                });
                jFileChooser.setApproveButtonText("Save Template");
                jFileChooser.setDialogTitle("Save As Template");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                if (this.prefs.getTemplateDir() != null && this.prefs.getTemplateDir().trim().length() > 0) {
                    try {
                        jFileChooser.setCurrentDirectory(new File(this.prefs.getTemplateDir()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            jFileChooser.setSelectedFile(new File(string + ".hdt"));
            int n = jFileChooser.showSaveDialog(frame);
            if (n == 1) {
                return;
            }
            if (n != 0) continue;
            file = jFileChooser.getSelectedFile();
            object = file.getName();
            if (((String)object).indexOf(".") < 0) {
                object = (String)object + ".hdt";
            } else {
                string2 = ((String)object).substring(((String)object).lastIndexOf("."), ((String)object).length());
                if (!string2.equalsIgnoreCase(".hdt")) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                    object = (String)object + ".hdt";
                }
            }
            if (!((String)object).equals(file.getName())) {
                string2 = "";
                if (file.getParentFile() != null) {
                    string2 = file.getParent();
                    if (!string2.endsWith(File.separator)) {
                        string2 = string2 + File.separator;
                    }
                }
                file = new File(string2 + (String)object);
            }
            if (!file.exists()) continue;
            int n2 = JOptionPane.showConfirmDialog(frame, file.getName() + " already exists.\n\nOverwrite?");
            if (n2 == 2) {
                return;
            }
            if (n2 != 1) continue;
            file = null;
        }
        try {
            Document document;
            Object object2;
            int n;
            Element element = HeroDesigner.getActiveHero().getSaveXML();
            element.removeChildren("TEMPLATE");
            element.removeChildren("IMAGE");
            element.removeChildren("RULES");
            object = element.getChild("BASIC_CONFIGURATION");
            ((Element)object).setAttribute("RULES", "");
            ((Element)object).setAttribute("TEMPLATE", "");
            Element element2 = HeroDesigner.getActiveHero().getRules().getRulesXML();
            Element element3 = HeroDesigner.getActiveTemplate().getTemplateXML();
            element3.removeChildren("CHARACTER");
            element3.removeChildren("RULES");
            element3.removeChildren("PREFAB");
            element3.addContent(element);
            element3.addContent(element2);
            element3.setAttribute("name", string);
            if (this.loadedPrefabs.size() > 0) {
                n = JOptionPane.showConfirmDialog(frame, "<html>Would you like to include the currently loaded prefabs in your template?<br><br>All included prefabs will be automatically loaded when the template is selected.</html>");
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    for (Prefab cloneable2 : this.loadedPrefabs) {
                        object2 = cloneable2.getSaveXML();
                        ((Element)object2).removeChildren("TEMPLATE");
                        ((Element)object2).removeChildren("IMAGE");
                        ((Element)object2).removeChildren("RULES");
                        object = ((Element)object2).getChild("BASIC_CONFIGURATION");
                        ((Element)object).setAttribute("RULES", "");
                        ((Element)object).setAttribute("TEMPLATE", "");
                        element3.addContent((Content)object2);
                    }
                }
            }
            if (HeroDesigner.getActiveTemplate().getPrefabs().size() > 0) {
                n = JOptionPane.showConfirmDialog(frame, "<html>Would you like to include the prefabs defined in the active template?<br><br>All included prefabs will be automatically loaded when the template is selected.</html>");
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
                        element3.addContent(prefab.getSaveXML());
                    }
                }
            }
            if ((document = element3.getDocument()) == null) {
                document = new Document(element3);
            }
            Iterator<Prefab> iterator = Format.getPrettyFormat();
            ((Format)((Object)iterator)).setEncoding("UTF-16");
            XMLOutputter xMLOutputter = new XMLOutputter((Format)((Object)iterator));
            object2 = new FileOutputStream(file);
            this.prefs.setTemplateDir(file.getParent());
            xMLOutputter.output(document, (OutputStream)object2);
            ((FileOutputStream)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred during the save process.\nPlease try again.\n\nError Message: " + exception.getMessage(), "Error saving template", 0);
        }
        this.updateStatus();
    }

    private void saveAsPackageDeal() {
        Object object;
        if (HeroDesigner.getActiveHero() == null) {
            return;
        }
        File file = null;
        JFileChooser jFileChooser = null;
        String string = "";
        string = JOptionPane.showInputDialog(HeroDesigner.getAppFrame(), "Please enter a name for this package deal", "Enter Package Deal Name", -1);
        if (string == null) {
            return;
        }
        while (file == null) {
            String string2;
            if (jFileChooser == null) {
                jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                            return true;
                        }
                        return file.getName().toUpperCase().endsWith(".HPK");
                    }

                    @Override
                    public String getDescription() {
                        return "HERO Designer Package Deal Files";
                    }
                });
                jFileChooser.setApproveButtonText("Save Package Deal");
                jFileChooser.setDialogTitle("Save As Package Deal");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                if (this.prefs.getPrefabDir() != null && this.prefs.getPrefabDir().trim().length() > 0) {
                    try {
                        jFileChooser.setCurrentDirectory(new File(this.prefs.getPrefabDir()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            jFileChooser.setSelectedFile(new File(string + ".hpk"));
            int n = jFileChooser.showSaveDialog(frame);
            if (n == 1) {
                return;
            }
            if (n != 0) continue;
            file = jFileChooser.getSelectedFile();
            this.prefs.setPrefabDir(file.getParent());
            object = file.getName();
            if (((String)object).indexOf(".") < 0) {
                object = (String)object + ".hpk";
            } else {
                string2 = ((String)object).substring(((String)object).lastIndexOf("."), ((String)object).length());
                if (!string2.equalsIgnoreCase(".hpk")) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                    object = (String)object + ".hpk";
                }
            }
            if (!((String)object).equals(file.getName())) {
                string2 = "";
                if (file.getParentFile() != null) {
                    string2 = file.getParent();
                    if (!string2.endsWith(File.separator)) {
                        string2 = string2 + File.separator;
                    }
                }
                file = new File(string2 + (String)object);
            }
            if (!file.exists()) continue;
            int n2 = JOptionPane.showConfirmDialog(frame, file.getName() + " already exists.\n\nOverwrite?");
            if (n2 == 2) {
                return;
            }
            if (n2 != 1) continue;
            file = null;
        }
        try {
            Document document;
            Object object2;
            Element element = HeroDesigner.getActiveHero().getSaveXML();
            element.removeChildren("TEMPLATE");
            element.removeChildren("IMAGE");
            element.removeChildren("RULES");
            object = element.getChild("BASIC_CONFIGURATION");
            ((Element)object).setAttribute("RULES", "");
            ((Element)object).setAttribute("TEMPLATE", "");
            Element element2 = element.getChild("CHARACTER_INFO");
            element2.setAttribute("CHARACTER_NAME", string);
            if (this.loadedPrefabs.size() > 0) {
                int n = JOptionPane.showConfirmDialog(frame, "<html>Would you like to include the currently loaded prefabs in your package deal?<br><br>All included prefabs will be automatically loaded when the package deal is selected/applied.</html>");
                if (n == 2) {
                    return;
                }
                if (n == 0) {
                    for (Prefab cloneable2 : this.loadedPrefabs) {
                        object2 = cloneable2.getSaveXML();
                        ((Element)object2).removeChildren("TEMPLATE");
                        ((Element)object2).removeChildren("IMAGE");
                        ((Element)object2).removeChildren("RULES");
                        object = ((Element)object2).getChild("BASIC_CONFIGURATION");
                        ((Element)object).setAttribute("RULES", "");
                        ((Element)object).setAttribute("TEMPLATE", "");
                        element.addContent((Content)object2);
                    }
                }
            }
            if ((document = element.getDocument()) == null) {
                document = new Document(element);
            }
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-16");
            XMLOutputter xMLOutputter = new XMLOutputter(format);
            object2 = new FileOutputStream(file);
            this.prefs.setTemplateDir(file.getParent());
            xMLOutputter.output(document, (OutputStream)object2);
            ((FileOutputStream)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred during the save process.\nPlease try again.\n\nError Message: " + exception.getMessage(), "Error saving package deal", 0);
        }
        this.updateStatus();
    }

    private void setActiveCharacterMenu() {
        Enumeration<AbstractButton> enumeration = this.windowGroup.getElements();
        while (enumeration.hasMoreElements()) {
            this.windowGroup.remove(enumeration.nextElement());
        }
        this.windowMenu.removeAll();
        for (int i = 0; i < this.openHeroes.size(); ++i) {
            Hero hero = this.openHeroes.get(i);
            String string = hero.getCharacterName().trim().length() == 0 ? "[unknown]" : hero.getCharacterName();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string + (hero.getSaveFile() != null ? " [" + hero.getSaveFile().getName() + "]" : ""));
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = HeroDesigner.this.windowMenu.getItemCount();
                    for (int i = 0; i < n; ++i) {
                        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i);
                        if (!jRadioButtonMenuItem.isSelected()) continue;
                        Hero hero = HeroDesigner.this.openHeroes.get(i);
                        HeroDesigner.this.setActiveHero(hero);
                        HeroDesigner.this.setTemplateMenuSelection();
                        HeroDesigner.this.logMemory("Change to File-based Character");
                        return;
                    }
                }
            });
            String string2 = "" + (i + 1);
            if (i < 9) {
                jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2.charAt(0), 2, false));
            }
            this.windowGroup.add(jRadioButtonMenuItem);
            this.windowMenu.add(jRadioButtonMenuItem);
            if (HeroDesigner.getActiveHero() == null || !hero.equals(HeroDesigner.getActiveHero())) continue;
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    private void setTemplateMenuSelection() {
        this.standardNormalMI.setSelected(false);
        this.standardHeroMI.setSelected(false);
        this.standardSuperMI.setSelected(false);
        this.vehicleMI.setSelected(false);
        this.baseMI.setSelected(false);
        this.automatonMI.setSelected(false);
        this.computerMI.setSelected(false);
        this.aiMI.setSelected(false);
        this.packageTemplateMI.setSelected(false);
        this.packageTemplateMI.setText("Revert to Original Template");
        if (HeroDesigner.getActiveTemplate() == null) {
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId() == null) {
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId().equals(HeroDesigner.getActiveHero().getOriginalTemplateID())) {
            this.packageTemplateMI.setVisible(false);
        } else {
            this.packageTemplateMI.setVisible(true);
        }
        if (HeroDesigner.getActiveTemplate().getId().equals("builtIn.Normal.hdt")) {
            this.standardNormalMI.setSelected(true);
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId().equals("builtIn.Heroic.hdt")) {
            this.standardHeroMI.setSelected(true);
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId().equals("builtIn.Superheroic.hdt")) {
            this.standardSuperMI.setSelected(true);
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId().equals("builtIn.Vehicle.hdt")) {
            this.vehicleMI.setSelected(true);
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId().equals("builtIn.Base.hdt")) {
            this.baseMI.setSelected(true);
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId().equals("builtIn.Automaton.hdt")) {
            this.automatonMI.setSelected(true);
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId().equals("builtIn.Computer.hdt")) {
            this.computerMI.setSelected(true);
            return;
        }
        if (HeroDesigner.getActiveTemplate().getId().equals("builtIn.AI.hdt")) {
            this.aiMI.setSelected(true);
            return;
        }
        this.packageTemplateMI.setText(HeroDesigner.getActiveTemplate().getId());
        this.packageTemplateMI.setEnabled(true);
        this.packageTemplateMI.setSelected(true);
    }

    protected void closeHero() {
        int n = this.windowMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.windowMenu.getItem(i);
            if (!jRadioButtonMenuItem.isSelected()) continue;
            this.windowGroup.remove(jRadioButtonMenuItem);
            this.windowMenu.remove(jRadioButtonMenuItem);
            this.openHeroes.remove(activeHero);
            Hero hero = null;
            if (this.openHeroes.size() > i) {
                hero = this.openHeroes.get(i);
                JRadioButtonMenuItem jRadioButtonMenuItem2 = (JRadioButtonMenuItem)this.windowMenu.getItem(i);
                jRadioButtonMenuItem2.setSelected(true);
            } else if (this.openHeroes.size() > 0) {
                hero = this.openHeroes.get(this.openHeroes.size() - 1);
                JRadioButtonMenuItem jRadioButtonMenuItem3 = (JRadioButtonMenuItem)this.windowMenu.getItem(this.openHeroes.size() - 1);
                jRadioButtonMenuItem3.setSelected(true);
            }
            this.setActiveHero(hero);
            this.logMemory("Close Character");
            break;
        }
        this.setActiveCharacterMenu();
    }

    public void openHero(File file, boolean bl) {
        block28: {
            Object object;
            if (this.lowMemory) {
                return;
            }
            for (int i = 0; i < this.openHeroes.size(); ++i) {
                object = this.openHeroes.get(i);
                if (((Hero)object).getSaveFile() == null || !((Hero)object).getSaveFile().getAbsolutePath().equals(file.getAbsolutePath())) continue;
                if (!headless) {
                    this.windowMenu.getItem(i).doClick();
                }
                return;
            }
            Utility.garbageCollect("Starting Character Open...");
            try {
                Object object2;
                Object object3;
                Hero hero = null;
                if (bl) {
                    activeHero = null;
                }
                if (file.getName().toUpperCase().endsWith(".HDC") || file.getName().toUpperCase().endsWith(".HDT")) {
                    hero = new Hero(file);
                } else if (file.getName().toUpperCase().endsWith(".HDP")) {
                    hero = new Prefab(file);
                } else {
                    object = new File("temp");
                    if (!((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                    object3 = new ZipInputStream(new FileInputStream(file));
                    object2 = ((ZipInputStream)object3).getNextEntry();
                    File file2 = null;
                    File file3 = null;
                    File file4 = null;
                    while (object2 != null) {
                        Object object4;
                        File file5 = null;
                        if (((ZipEntry)object2).getName().toUpperCase().endsWith(".HDC")) {
                            object4 = ((ZipEntry)object2).getName().substring(0, ((ZipEntry)object2).getName().toUpperCase().indexOf(".HDC"));
                            file2 = file5 = new File(object + File.separator + (String)object4 + System.currentTimeMillis() + ".hdc");
                            file5.deleteOnExit();
                        } else if (((ZipEntry)object2).getName().toUpperCase().endsWith(".HDT")) {
                            object4 = ((ZipEntry)object2).getName().substring(0, ((ZipEntry)object2).getName().toUpperCase().indexOf(".HDT"));
                            file5 = new File(object + File.separator + (String)object4 + System.currentTimeMillis() + ".hdt");
                            file5.deleteOnExit();
                            file3 = file5;
                        } else if (((ZipEntry)object2).getName().toUpperCase().endsWith(".JPG")) {
                            object4 = ((ZipEntry)object2).getName().substring(0, ((ZipEntry)object2).getName().toUpperCase().indexOf(".JPG"));
                            file5 = new File(object + File.separator + (String)object4 + System.currentTimeMillis() + ".jpg");
                            file5.deleteOnExit();
                            file4 = file5;
                        } else if (((ZipEntry)object2).getName().toUpperCase().endsWith(".GIF")) {
                            object4 = ((ZipEntry)object2).getName().substring(0, ((ZipEntry)object2).getName().toUpperCase().indexOf(".GIF"));
                            file5 = new File(object + File.separator + (String)object4 + System.currentTimeMillis() + ".gif");
                            file5.deleteOnExit();
                            file4 = file5;
                        } else if (((ZipEntry)object2).getName().toUpperCase().endsWith(".PNG")) {
                            object4 = ((ZipEntry)object2).getName().substring(0, ((ZipEntry)object2).getName().toUpperCase().indexOf(".PNG"));
                            file5 = new File(object + File.separator + (String)object4 + System.currentTimeMillis() + ".png");
                            file5.deleteOnExit();
                            file4 = file5;
                        }
                        if (file5 != null) {
                            object4 = new FileOutputStream(file5);
                            int n = 0;
                            int n2 = 0;
                            while ((n = ((ZipInputStream)object3).read()) != -1) {
                                ++n2;
                                ((FileOutputStream)object4).write(n);
                            }
                            ((OutputStream)object4).flush();
                            ((FileOutputStream)object4).close();
                            ((ZipInputStream)object3).closeEntry();
                        }
                        object2 = ((ZipInputStream)object3).getNextEntry();
                    }
                    hero = new Hero(file2, file3, file4, file);
                }
                hero.setDirty(false);
                this.openHeroes.add(hero);
                Object object5 = object = hero.getCharacterName().trim().length() == 0 ? "[unknown]" : hero.getCharacterName();
                if (!headless) {
                    object3 = new JRadioButtonMenuItem((String)object + (hero.getSaveFile() != null ? " [" + hero.getSaveFile().getName() + "]" : ""));
                    ((AbstractButton)object3).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = HeroDesigner.this.windowMenu.getItemCount();
                            for (int i = 0; i < n; ++i) {
                                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)HeroDesigner.this.windowMenu.getItem(i);
                                if (!jRadioButtonMenuItem.isSelected()) continue;
                                Hero hero = HeroDesigner.this.openHeroes.get(i);
                                HeroDesigner.this.setActiveHero(hero);
                                HeroDesigner.this.setTemplateMenuSelection();
                                return;
                            }
                        }
                    });
                    object2 = "" + this.openHeroes.size();
                    if (this.openHeroes.size() < 10) {
                        ((JMenuItem)object3).setAccelerator(KeyStroke.getKeyStroke(((String)object2).charAt(0), 2, false));
                    }
                    this.windowGroup.add((AbstractButton)object3);
                    this.windowMenu.add((JMenuItem)object3);
                    if (bl) {
                        ((AbstractButton)object3).setSelected(true);
                        activeHero = null;
                        this.setActiveHero(hero);
                        this.mainPanel.verify();
                        this.logMemory("Open Character");
                        this.setTemplateMenuSelection();
                        hero.setDirty(false);
                        this.setDirty(false);
                    } else {
                        this.fireCharacterLoaded(hero, false);
                    }
                } else {
                    this.fireCharacterLoaded(hero, false);
                }
                this.prefs.addRecentFile(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (headless) break block28;
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading your character.\nData loss may occur if the character is saved.\n\nPlease restart HERO Designer and try again.\n\n\nError Message: " + exception.getMessage(), "Error loading preferences", 0);
            }
        }
        Utility.garbageCollect("Done Opening Character");
        lastEdit = System.currentTimeMillis();
    }

    protected void updateRecentMenu() {
        if (this.recentMI == null) {
            return;
        }
        this.recentMI.removeAll();
        for (String string : this.prefs.getRecentFileList()) {
            File file = new File(string);
            if (!file.exists() || !file.canRead()) continue;
            RecentlySelectedMenuItem recentlySelectedMenuItem = new RecentlySelectedMenuItem(file);
            this.recentMI.add(recentlySelectedMenuItem);
        }
    }

    protected void updateStatus() {
        Object object;
        if (this.statusLbl == null) {
            return;
        }
        String string = "<b>Character:</b> ";
        String string2 = "<b>Rules:</b> ";
        String string3 = "<b>Last Saved:</b> ";
        String string4 = "<b>Export Format:</b> ";
        if (HeroDesigner.getActiveHero() != null) {
            if (HeroDesigner.getActiveHero().getSaveFile() != null) {
                try {
                    object = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
                    if (HeroDesigner.getActiveHero().isDirty()) {
                        string3 = string3 + "<font color=\"red\">";
                    }
                    string3 = string3 + " " + ((DateFormat)object).format(new Date(HeroDesigner.getActiveHero().getSaveFile().lastModified()));
                    if (HeroDesigner.getActiveHero().isDirty()) {
                        string3 = string3 + "</font>";
                    }
                }
                catch (Exception exception) {
                    string3 = string3 + " [unknown]";
                }
            } else {
                string3 = string3 + " Never";
            }
            string4 = HeroDesigner.getActiveHero().getExportTemplate() != null ? (((File)(object = new File(HeroDesigner.getActiveHero().getExportTemplate()))).exists() && ((File)object).isFile() ? string4 + ((File)object).getName() : string4 + "None") : string4 + "None";
            if (HeroDesigner.getActiveHero().isPrefab()) {
                string = "<b>Prefab:</b> ";
            }
            string = HeroDesigner.getActiveHero().getCharacterName().trim().length() > 0 ? string + HeroDesigner.getActiveHero().getCharacterName() : string + "[unknown]";
            if (HeroDesigner.getActiveHero().getRules().getName() != null && HeroDesigner.getActiveHero().getRules().getName().trim().length() > 0) {
                string2 = string2 + HeroDesigner.getActiveHero().getRules().getName().trim();
            } else if (HeroDesigner.getActiveHero().getRules().getCampaignSet().trim().length() > 0) {
                string2 = string2 + "Campaign Rules defined in " + HeroDesigner.getActiveHero().getRules().getCampaignSet();
            } else if (HeroDesigner.getActiveHero().getRules().getCurrentSet().equals("Default")) {
                string2 = string2 + "Default Hero System";
            } else {
                object = HeroDesigner.getActiveHero().getRules().getCurrentSet();
                while (((String)object).indexOf(".") < ((String)object).lastIndexOf(".")) {
                    object = ((String)object).substring(((String)object).indexOf(".") + 1, ((String)object).length());
                }
                if (((String)object).indexOf(File.separator) > 0) {
                    object = ((String)object).substring(((String)object).lastIndexOf(File.separator) + 1, ((String)object).length());
                }
                string2 = string2 + (String)object;
            }
        } else {
            string = string + " [none]";
        }
        object = "<b>Template:</b> ";
        object = HeroDesigner.getActiveTemplate() != null ? (String)object + HeroDesigner.getActiveTemplate().getName() : (String)object + "[none]";
        this.statusLbl.setText("<html>" + (String)object + " -- " + string2 + " -- " + string4 + " -- " + string3 + "</html>");
    }

    void setActiveTemplate(Template template) {
        activeTemplate = template;
    }

    public JMenuBar getMainMenuBar() {
        return this.menu;
    }

    public MainContentPanel getMainPanel() {
        return this.mainPanel;
    }

    public ArrayList<GenericObject> getPrefabDisads() {
        ArrayList<GenericObject> arrayList;
        List list;
        ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
        for (Prefab prefab : this.loadedPrefabs) {
            list = new List(prefab.getName());
            if (prefab.getDisads() == null || prefab.getDisads().size() == 0) continue;
            arrayList = new ArrayList<GenericObject>();
            for (GenericObject genericObject : prefab.getDisads()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getDisads() == null || prefab.getDisads().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getDisads()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getDisads() == null || prefab.getDisads().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getDisads()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        return arrayList2;
    }

    public ArrayList<GenericObject> getPrefabEquipment() {
        ArrayList<GenericObject> arrayList;
        List list;
        ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
        for (Prefab prefab : this.loadedPrefabs) {
            list = new List(prefab.getName());
            if (prefab.getEquipment() == null || prefab.getEquipment().size() == 0) continue;
            arrayList = new ArrayList<GenericObject>();
            for (GenericObject genericObject : prefab.getEquipment()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getEquipment() == null || prefab.getEquipment().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getEquipment()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getEquipment() == null || prefab.getEquipment().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getEquipment()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        if (this.getPrefs().getShowPowersPrefabsOnEquipment()) {
            for (Prefab prefab : this.loadedPrefabs) {
                list = new List(prefab.getName());
                if (prefab.getPowers() == null || prefab.getPowers().size() == 0) continue;
                arrayList = new ArrayList();
                for (GenericObject genericObject : prefab.getPowers()) {
                    if (genericObject.getParentList() != null) continue;
                    arrayList.add(genericObject);
                }
                list.setObjects(arrayList);
                arrayList2.add(list);
            }
            for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
                list = new List(prefab.getName());
                if (prefab.getPowers() == null || prefab.getPowers().size() == 0) continue;
                arrayList = new ArrayList();
                for (GenericObject genericObject : prefab.getPowers()) {
                    if (genericObject.getParentList() != null) continue;
                    arrayList.add(genericObject);
                }
                list.setObjects(arrayList);
                arrayList2.add(list);
            }
            for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
                list = new List(prefab.getName());
                if (prefab.getPowers() == null || prefab.getPowers().size() == 0) continue;
                arrayList = new ArrayList();
                for (GenericObject genericObject : prefab.getPowers()) {
                    if (genericObject.getParentList() != null) continue;
                    arrayList.add(genericObject);
                }
                list.setObjects(arrayList);
                arrayList2.add(list);
            }
        }
        return arrayList2;
    }

    public ArrayList<GenericObject> getPrefabManeuvers() {
        ArrayList<GenericObject> arrayList;
        List list;
        ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
        for (Prefab prefab : this.loadedPrefabs) {
            list = new List(prefab.getName());
            if (prefab.getManeuvers() == null || prefab.getManeuvers().size() == 0) continue;
            arrayList = new ArrayList<GenericObject>();
            for (GenericObject genericObject : prefab.getManeuvers()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getManeuvers() == null || prefab.getManeuvers().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getManeuvers()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getManeuvers() == null || prefab.getManeuvers().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getManeuvers()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        return arrayList2;
    }

    public ArrayList<GenericObject> getPrefabPerks() {
        ArrayList<GenericObject> arrayList;
        List list;
        ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
        for (Prefab prefab : this.loadedPrefabs) {
            list = new List(prefab.getName());
            if (prefab.getPerks() == null || prefab.getPerks().size() == 0) continue;
            arrayList = new ArrayList<GenericObject>();
            for (GenericObject genericObject : prefab.getPerks()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getPerks() == null || prefab.getPerks().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getPerks()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getPerks() == null || prefab.getPerks().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getPerks()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        return arrayList2;
    }

    public ArrayList<GenericObject> getPrefabPowers() {
        ArrayList<GenericObject> arrayList;
        List list;
        ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
        for (Prefab prefab : this.loadedPrefabs) {
            list = new List(prefab.getName());
            if (prefab.getPowers() == null || prefab.getPowers().size() == 0) continue;
            arrayList = new ArrayList<GenericObject>();
            for (GenericObject genericObject : prefab.getPowers()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getPowers() == null || prefab.getPowers().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getPowers()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getPowers() == null || prefab.getPowers().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getPowers()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        if (this.getPrefs().getShowEquipmentPrefabsOnPowers()) {
            for (Prefab prefab : this.loadedPrefabs) {
                list = new List(prefab.getName());
                if (prefab.getEquipment() == null || prefab.getEquipment().size() == 0) continue;
                arrayList = new ArrayList();
                for (GenericObject genericObject : prefab.getEquipment()) {
                    if (genericObject.getParentList() != null) continue;
                    arrayList.add(genericObject);
                }
                list.setObjects(arrayList);
                arrayList2.add(list);
            }
            for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
                list = new List(prefab.getName());
                if (prefab.getEquipment() == null || prefab.getEquipment().size() == 0) continue;
                arrayList = new ArrayList();
                for (GenericObject genericObject : prefab.getEquipment()) {
                    if (genericObject.getParentList() != null) continue;
                    arrayList.add(genericObject);
                }
                list.setObjects(arrayList);
                arrayList2.add(list);
            }
            for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
                list = new List(prefab.getName());
                if (prefab.getEquipment() == null || prefab.getEquipment().size() == 0) continue;
                arrayList = new ArrayList();
                for (GenericObject genericObject : prefab.getEquipment()) {
                    if (genericObject.getParentList() != null) continue;
                    arrayList.add(genericObject);
                }
                list.setObjects(arrayList);
                arrayList2.add(list);
            }
        }
        return arrayList2;
    }

    public ArrayList<GenericObject> getPrefabSkills() {
        ArrayList<GenericObject> arrayList;
        List list;
        ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
        for (Prefab prefab : this.loadedPrefabs) {
            if (prefab.getSkills() == null || prefab.getSkills().size() == 0) continue;
            list = new List(prefab.getName());
            arrayList = new ArrayList<GenericObject>();
            for (GenericObject genericObject : prefab.getSkills()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
            if (prefab.getSkills() == null || prefab.getSkills().size() == 0) continue;
            list = new List(prefab.getName());
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getSkills()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
            if (prefab.getSkills() == null || prefab.getSkills().size() == 0) continue;
            list = new List(prefab.getName());
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getSkills()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        return arrayList2;
    }

    public ArrayList<GenericObject> getPrefabTalents() {
        ArrayList<GenericObject> arrayList;
        List list;
        ArrayList<GenericObject> arrayList2 = new ArrayList<GenericObject>();
        for (Prefab prefab : this.loadedPrefabs) {
            list = new List(prefab.getName());
            if (prefab.getTalents() == null || prefab.getTalents().size() == 0) continue;
            arrayList = new ArrayList<GenericObject>();
            for (GenericObject genericObject : prefab.getTalents()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveTemplate().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getTalents() == null || prefab.getTalents().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getTalents()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        for (Prefab prefab : HeroDesigner.getActiveHero().getPrefabs()) {
            list = new List(prefab.getName());
            if (prefab.getTalents() == null || prefab.getTalents().size() == 0) continue;
            arrayList = new ArrayList();
            for (GenericObject genericObject : prefab.getTalents()) {
                if (genericObject.getParentList() != null) continue;
                arrayList.add(genericObject);
            }
            list.setObjects(arrayList);
            arrayList2.add(list);
        }
        return arrayList2;
    }

    public AppPrefs getPrefs() {
        return this.prefs;
    }

    public ArrayList<Hero> getOpenHeroes() {
        return (ArrayList)this.openHeroes.clone();
    }

    public void logMemory(String string) {
        if (headless) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM d '@'h:mm:ss a (Z)");
        BigDecimal bigDecimal = new BigDecimal((double)Runtime.getRuntime().maxMemory() / 1048576.0);
        bigDecimal = bigDecimal.setScale(2, 4);
        BigDecimal bigDecimal2 = new BigDecimal((double)Runtime.getRuntime().totalMemory() / 1048576.0);
        bigDecimal2 = bigDecimal2.setScale(2, 4);
        BigDecimal bigDecimal3 = new BigDecimal((double)Runtime.getRuntime().freeMemory() / 1048576.0);
        bigDecimal3 = bigDecimal3.setScale(2, 4);
        BigDecimal bigDecimal4 = new BigDecimal((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0);
        bigDecimal4 = bigDecimal4.setScale(2, 4);
        System.out.println(string + ":  " + simpleDateFormat.format(new Date()) + " build " + version + " Memory Usage (" + this.openHeroes.size() + " characters, " + this.loadedPrefabs.size() + " prefabs): " + bigDecimal2.toString() + "MB (total), " + bigDecimal3.toString() + "MB (free) = " + bigDecimal4.toString() + "MB (used)");
    }

    public void setActiveHero(Hero hero) {
        boolean bl = false;
        if (hero != null) {
            bl = hero.isDirty();
        }
        if (!headless && this.mainPanel.isShowing() && activeHero != null && hero != null && activeHero.getSaveFile() != null && hero.getSaveFile() != null && activeHero.getSaveFile().getAbsolutePath().equals(hero.getSaveFile().getAbsolutePath()) && activeHero.getSaveFile().getName().equals(hero.getSaveFile().getName())) {
            return;
        }
        activeHero = hero;
        if (activeHero != null) {
            lastEdit = hero.lastEdit;
            if (activeHero.getTemplatePath() != null && activeHero.getTemplatePath().trim().length() > 0) {
                this.setTemplate(activeHero.getTemplatePath(), activeHero.getTemplatePath().startsWith("builtIn."), false, false);
            } else {
                activeHero.setTemplatePath(HeroDesigner.getActiveTemplate().getId());
            }
            frame.setCursor(Cursor.getPredefinedCursor(3));
            this.setTemplateMenuSelection();
            this.mainPanel.reset();
            this.statusLbl.setText("");
            this.statusLbl.setBorder(BorderFactory.createLoweredBevelBorder());
            this.statusLbl.setOpaque(true);
            this.mainPanel.setVisible(true);
            this.statusLbl.setVisible(true);
            this.memoryUsagePB.setVisible(true);
            this.checkAllModsMI.setEnabled(true);
            this.applyPackageDealMI.setEnabled(true);
            this.closeMI.setEnabled(true);
            this.closeAllMI.setEnabled(true);
            this.saveAllMI.setEnabled(true);
            this.saveAsMI.setEnabled(true);
            this.saveAsPackageDealMI.setEnabled(true);
            this.characterMenu.setEnabled(true);
            this.tearOffMI.setEnabled(true);
            this.templateMenu.setEnabled(true);
            this.prefabMenu.setEnabled(true);
            this.rulesMenu.setEnabled(true);
            this.windowMenu.setEnabled(true);
            hero.setDirty(bl);
            this.setDirty(hero.isDirty());
            for (GenericObject genericObject : activeHero.getSkills()) {
                genericObject.verifyModifiers();
            }
            for (GenericObject genericObject : activeHero.getPerks()) {
                genericObject.verifyModifiers();
            }
            for (GenericObject genericObject : activeHero.getTalents()) {
                genericObject.verifyModifiers();
            }
            for (GenericObject genericObject : activeHero.getManeuvers()) {
                genericObject.verifyModifiers();
            }
            for (GenericObject genericObject : activeHero.getPowers()) {
                genericObject.verifyModifiers();
            }
            for (GenericObject genericObject : activeHero.getEquipment()) {
                genericObject.verifyModifiers();
            }
            frame.setCursor(Cursor.getDefaultCursor());
            this.updateStatus();
            if (activeHero.isPrefab()) {
                this.saveAsPrefabMI.setEnabled(false);
                this.saveAsTemplateMI.setEnabled(false);
                this.saveMI.setText("Save Prefab");
                this.saveAsMI.setText("Save Prefab As..");
                this.characterMenu.setText("Current Prefab");
                this.closeMI.setText("Close Prefab");
                this.exportToFileMI.setEnabled(false);
                this.previewCombatRecordMI.setEnabled(false);
                this.combatRecordExportMI.setEnabled(false);
                this.previewExportMI.setEnabled(false);
                this.setExportTemplateMI.setEnabled(false);
            } else {
                this.saveAsPrefabMI.setEnabled(true);
                this.saveAsTemplateMI.setEnabled(true);
                this.saveMI.setText("Save Character");
                this.saveAsMI.setText("Save Character As..");
                this.characterMenu.setText("Current Character");
                this.closeMI.setText("Close Character");
                this.exportToFileMI.setEnabled(true);
                this.previewCombatRecordMI.setEnabled(true);
                this.combatRecordExportMI.setEnabled(true);
                this.previewExportMI.setEnabled(true);
                this.setExportTemplateMI.setEnabled(true);
            }
            this.fireCharacterLoaded(activeHero, true);
        } else if (!headless) {
            this.mainPanel.setVisible(false);
            this.mainPanel.hideFrames();
            this.statusLbl.setVisible(false);
            this.memoryUsagePB.setVisible(false);
            this.saveMI.setEnabled(false);
            this.tearOffMI.setEnabled(false);
            this.checkAllModsMI.setEnabled(false);
            this.applyPackageDealMI.setEnabled(false);
            this.closeMI.setEnabled(false);
            this.closeAllMI.setEnabled(false);
            this.saveAllMI.setEnabled(false);
            this.saveAsPrefabMI.setEnabled(false);
            this.saveAsTemplateMI.setEnabled(false);
            this.saveAsMI.setEnabled(false);
            this.saveAsPackageDealMI.setEnabled(false);
            this.characterMenu.setEnabled(false);
            this.exportToFileMI.setEnabled(false);
            this.previewCombatRecordMI.setEnabled(false);
            this.combatRecordExportMI.setEnabled(false);
            this.previewExportMI.setEnabled(false);
            this.setExportTemplateMI.setEnabled(false);
            this.templateMenu.setEnabled(false);
            this.prefabMenu.setEnabled(false);
            this.rulesMenu.setEnabled(false);
            this.windowMenu.setEnabled(false);
            frame.validate();
        }
        if (!headless && activeHero != null) {
            frame.setTitle("HERO Designer 6 [build " + version + "] -- " + activeHero.getCharacterName() + (activeHero.getSaveFile() != null ? " [" + activeHero.getSaveFile().getName() + "]" : ""));
        } else if (!headless) {
            frame.setTitle("HERO Designer 6 [build " + version + "] -- [no characters open]");
        }
        this.updateStatus();
        Utility.garbageCollect("Changed Characters");
    }

    public void setActiveName(String string) {
        int n = this.windowMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.windowMenu.getItem(i);
            if (!jRadioButtonMenuItem.isSelected()) continue;
            if (string != null && string.trim().length() > 0) {
                jRadioButtonMenuItem.setText(string + (activeHero.getSaveFile() != null ? " [" + activeHero.getSaveFile().getName() + "]" : ""));
                frame.setTitle("HERO Designer 6 [build " + version + "] -- " + activeHero.getCharacterName() + (activeHero.getSaveFile() != null ? " [" + activeHero.getSaveFile().getName() + "]" : ""));
            } else {
                jRadioButtonMenuItem.setText("[unknown]");
                frame.setTitle("HERO Designer 6 [build " + version + "] -- [unknown]");
            }
            return;
        }
        this.updateStatus();
    }

    public void setCopyModBuffer(ArrayList<Modifier> arrayList) {
        arrayList = (ArrayList)arrayList.clone();
        for (int i = 0; i < arrayList.size(); ++i) {
            Modifier modifier = (Modifier)arrayList.get(i);
            modifier = modifier.clone();
            modifier.setParent(null);
            arrayList.set(i, modifier);
        }
        copiedMods = arrayList;
    }

    public ArrayList<Modifier> getCopyModBuffer() {
        return copiedMods;
    }

    public void setCopyBuffer(GenericObject genericObject) {
        if (genericObject != null) {
            GenericObject genericObject2 = genericObject.clone();
            genericObject2.setParent(null);
            genericObject2.setMainPower(null);
            genericObject2.resetID();
            genericObject2.setIsEquipment(false);
            genericObject2.setPower(false);
            if (genericObject2 instanceof List) {
                List list = (List)genericObject2;
                ArrayList<GenericObject> arrayList = list.getObjects();
                list.setObjects(new ArrayList<GenericObject>());
                for (int i = 0; i < arrayList.size(); ++i) {
                    GenericObject genericObject3 = arrayList.get(i).clone();
                    genericObject3.setPower(false);
                    genericObject3.setIsEquipment(false);
                    list.addObject(genericObject);
                }
            }
            copyBuffer = genericObject2;
        }
        copyBuffer = genericObject;
    }

    public void setDirty(boolean bl) {
        if (bl) {
            lastEdit = System.currentTimeMillis();
            this.updateStatus();
        }
        this.saveMI.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemplate(String string) {
        if (string == null) {
            return;
        }
        if (string.startsWith("builtIn")) {
            return;
        }
        if (string.indexOf("Sample Templates") > 0) {
            JOptionPane.showMessageDialog(frame, "You appear to be using one of the sample templates for your character.\n  It is strongly recommended that you do not do this.\n\n Either use the built in templates (via the Template menu), or use a custom template.\n\n If you are storing your custom templates in the Sample Templates directory,\n you should move them to prevent this error from repeating.", "Sample Templates use detected", 2);
        }
        if (!headless) {
            frame.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (HeroDesigner.getActiveHero() != null) {
            HeroDesigner.getActiveHero().setIsLoading(true);
        }
        String string2 = string;
        try {
            Object object;
            if (HeroDesigner.getActiveTemplate() != null && HeroDesigner.getActiveTemplate().getId().equals(string)) {
                if (!headless) {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
                return;
            }
            if (HeroDesigner.getActiveHero() != null) {
                while (HeroDesigner.getActiveHero().isDirty()) {
                    object = HeroDesigner.getActiveHero().getCharacterName();
                    if (((String)object).trim().length() == 0) {
                        object = "[unknown]";
                    }
                    int n = 1;
                    if (!headless) {
                        n = JOptionPane.showConfirmDialog(frame, (String)object + " has been changed!\n\nSave changes before adding in the new template?");
                    }
                    if (n == 2) {
                        this.setTemplateMenuSelection();
                        if (!headless) {
                            frame.setCursor(new Cursor(0));
                        }
                        return;
                    }
                    if (n == 0) {
                        this.saveMI.doClick();
                        continue;
                    }
                    if (n != 1) continue;
                    break;
                }
            }
            object = HeroDesigner.getActiveHero();
            Template template = null;
            this.logMemory("Loading template extension (" + string + ")");
            Template template2 = HeroDesigner.getActiveTemplate();
            if (template2.getId().startsWith("builtIn")) {
                template2 = template2.clone();
            }
            template = Template.getTemplate(string);
            this.logMemory("Template file loaded.");
            if (template == null) {
                HeroDesigner.getActiveHero().setIsLoading(false);
                if (!headless) {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
                if (!headless) {
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the template \"" + string + "\".\nThe template file specified was not found on the system.\n\nThe currently loaded template will be used instead.", "Error loading template", 0);
                }
            } else {
                this.logMemory("Adding template to extension hierarchy...");
                template2.addExtensionTemplate(template);
                HeroDesigner.getInstance().setActiveTemplate(template2);
                this.logMemory("Resetting prefabs...");
                this.resetPrefabs();
                this.logMemory("Resetting character...");
                ((Hero)object).resetTemplate();
                ((Hero)object).setDirty(true);
                this.logMemory("Resetting UI...");
                this.mainPanel.recalcAll();
                this.logMemory("Re-Checking Modifiers...");
                this.statusLbl.setText("");
                this.setDirty(((Hero)object).isDirty());
                for (GenericObject genericObject : activeHero.getSkills()) {
                    genericObject.verifyModifiers();
                }
                for (GenericObject genericObject : activeHero.getPerks()) {
                    genericObject.verifyModifiers();
                }
                for (GenericObject genericObject : activeHero.getTalents()) {
                    genericObject.verifyModifiers();
                }
                for (GenericObject genericObject : activeHero.getManeuvers()) {
                    genericObject.verifyModifiers();
                }
                for (GenericObject genericObject : activeHero.getPowers()) {
                    genericObject.verifyModifiers();
                }
                for (GenericObject genericObject : activeHero.getEquipment()) {
                    genericObject.verifyModifiers();
                }
                frame.setCursor(Cursor.getDefaultCursor());
                HeroDesigner.getActiveHero().setIsLoading(false);
                this.fireTemplateChanged(activeTemplate);
                this.logMemory("Character reset, template extension added.");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the selected template.\n\nError Message: " + exception.getMessage(), "Error loading template", 0);
            exception.printStackTrace();
        }
        finally {
            if (!headless) {
                frame.setCursor(Cursor.getDefaultCursor());
            }
            HeroDesigner.getActiveHero().setIsLoading(false);
        }
        Utility.garbageCollect("Set Template");
        if (!headless) {
            this.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemplate(String string, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            return;
        }
        if ((bl || string.startsWith("builtIn")) && string.indexOf("6E") <= 0) {
            string = this.convertOldNames(string);
        }
        if (string.indexOf("Sample Templates") > 0) {
            JOptionPane.showMessageDialog(frame, "You appear to be using one of the sample templates for your character.\n  It is strongly recommended that you do not do this.\n\n Either use the built in templates (via the Template menu), or use a custom template.\n\n If you are storing your custom templates in the Sample Templates directory,\n you should move them to prevent this error from repeating.", "Sample Templates use detected", 2);
        }
        if (!headless) {
            frame.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (HeroDesigner.getActiveHero() != null) {
            HeroDesigner.getActiveHero().setIsLoading(true);
        }
        String string2 = string;
        ArrayList<Prefab> arrayList = this.loadedPrefabs;
        this.loadedPrefabs = new ArrayList();
        if (string2.startsWith("builtIn.")) {
            string2 = string2.substring(string2.indexOf(".") + 1, string2.length());
        }
        try {
            Object object;
            if (bl && !string.startsWith("builtIn.")) {
                string = "builtIn." + string;
            }
            if (HeroDesigner.getActiveTemplate() != null && HeroDesigner.getActiveTemplate().getId().equals(string)) {
                if (!headless) {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
                return;
            }
            if (HeroDesigner.getActiveHero() != null) {
                while (HeroDesigner.getActiveHero().isDirty() && bl2) {
                    object = HeroDesigner.getActiveHero().getCharacterName();
                    if (((String)object).trim().length() == 0) {
                        object = "[unknown]";
                    }
                    int n = 1;
                    if (!headless) {
                        n = JOptionPane.showConfirmDialog(frame, (String)object + " has been changed!\n\nSave changes before switching templates?");
                    }
                    if (n == 2) {
                        this.setTemplateMenuSelection();
                        if (!headless) {
                            frame.setCursor(new Cursor(0));
                        }
                        return;
                    }
                    if (n == 0) {
                        this.saveMI.doClick();
                        continue;
                    }
                    if (n != 1) continue;
                    break;
                }
            }
            object = HeroDesigner.getActiveHero();
            if (bl3) {
                this.setActiveHero(null);
            }
            Cloneable cloneable = null;
            cloneable = string.startsWith("builtIn.") ? Template.getTemplate(ClassLoader.getSystemResourceAsStream(string2), string) : Template.getTemplate(string);
            if (cloneable == null) {
                if (!headless) {
                    frame.setCursor(Cursor.getDefaultCursor());
                }
                this.loadedPrefabs = arrayList;
                if (!headless) {
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the template \"" + string + "\".\nThe template file specified was not found on the system.\n\nThe currently loaded template will be used instead.", "Error loading template", 0);
                }
            } else {
                activeTemplate = cloneable;
                if (activeTemplate.isVersion1Style() && !headless) {
                    JOptionPane.showMessageDialog(frame, "<html>You appear to be using a template from an earlier version of HERO Designer.<br><br>It is <b>strongly</b> recommended that you do not do this.<br><br> Either use the built in templates (via the Template menu), or use a custom template which was created for HERO Designer version 2 or higher.</html>", "Version 1 Template Detected", 2);
                }
                this.resetPrefabs();
                if (bl3 && object != null && (activeTemplate == null || ((Hero)object).getTemplatePath() == null || !((Hero)object).getTemplatePath().equals(activeTemplate.getId()))) {
                    ((Hero)object).resetTemplate();
                }
                if (bl3 && object != null && (activeTemplate == null || ((Hero)object).getTemplatePath() == null || !((Hero)object).getTemplatePath().equals(activeTemplate.getId()))) {
                    ((Hero)object).setDirty(true);
                }
                if (bl3) {
                    this.setActiveHero((Hero)object);
                }
                if (bl3 && object != null && activeTemplate != null) {
                    ((Hero)object).setTemplatePath(activeTemplate.getId());
                }
                this.fireTemplateChanged(activeTemplate);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the selected template.\n\nError Message: " + exception.getMessage(), "Error loading template", 0);
            exception.printStackTrace();
        }
        finally {
            if (!headless) {
                frame.setCursor(Cursor.getDefaultCursor());
            }
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                try {
                    Prefab prefab = arrayList.get(i);
                    prefab.initFromSave();
                    continue;
                }
                catch (Exception exception) {
                    arrayList.remove(i);
                }
            }
            this.loadedPrefabs = arrayList;
            if (activeHero != null) {
                if (!headless) {
                    this.mainPanel.reset();
                    this.mainPanel.updateTabs();
                    this.mainPanel.updatePrefabs();
                }
                HeroDesigner.getActiveHero().setIsLoading(false);
            }
        }
        Utility.garbageCollect("Set Template");
        if (!headless) {
            this.updateStatus();
        }
    }

    private void setDefaultExportFormat(Hero hero) {
        String string = this.getDefaultExportFormatPath(HeroDesigner.getActiveTemplate());
        if (string != null) {
            File file = new File(string);
            if (!file.exists() || file.isDirectory()) {
                file = new File(this.getPrefs().getExportTemplateDir() + File.separator + file.getName());
                if (!file.exists() || file.isDirectory()) {
                    HeroDesigner.getActiveHero().setExportTemplate(null);
                } else {
                    HeroDesigner.getActiveHero().setExportTemplate(file.getAbsolutePath());
                }
            } else {
                HeroDesigner.getActiveHero().setExportTemplate(file.getAbsolutePath());
            }
        }
    }

    private String getDefaultExportFormatPath(Template template) {
        String string = template.getId();
        if (string.startsWith("builtIn")) {
            string = string.substring(8, string.length());
        }
        if (string.startsWith("AI")) {
            return this.getPrefs().getDefaultAIFormatPath();
        }
        if (string.startsWith("Automaton")) {
            return this.getPrefs().getDefaultAutomatonFormatPath();
        }
        if (string.startsWith("Base")) {
            return this.getPrefs().getDefaultBaseFormatPath();
        }
        if (string.startsWith("Computer")) {
            return this.getPrefs().getDefaultComputerFormatPath();
        }
        if (string.startsWith("Heroic")) {
            return this.getPrefs().getDefaultHeroicFormatPath();
        }
        if (string.startsWith("Normal")) {
            return this.getPrefs().getDefaultNormalFormatPath();
        }
        if (string.startsWith("Superheroic")) {
            return this.getPrefs().getDefaultSuperheroicFormatPath();
        }
        if (string.startsWith("Main")) {
            return this.getPrefs().getDefaultSuperheroicFormatPath();
        }
        if (string.startsWith("Vehicle")) {
            return this.getPrefs().getDefaultVehicleFormatPath();
        }
        if (template.getParentTemplates() != null) {
            for (Template template2 : template.getParentTemplates()) {
                String string2 = this.getDefaultExportFormatPath(template2);
                if (string2 == null) continue;
                return string2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportActiveCharacter() {
        Object object;
        Object object2;
        JFileChooser jFileChooser = null;
        JFileChooser jFileChooser2 = null;
        File file = null;
        File file2 = null;
        ExportTemplateDialog exportTemplateDialog = null;
        if (HeroDesigner.getActiveHero().getExportTemplate() == null) {
            this.setDefaultExportFormat(HeroDesigner.getActiveHero());
        }
        if (HeroDesigner.getActiveHero().getExportTemplate() != null && (!((File)(object2 = new File(HeroDesigner.getActiveHero().getExportTemplate()))).exists() || ((File)object2).isDirectory())) {
            object2 = new File(this.getPrefs().getExportTemplateDir() + File.separator + ((File)object2).getName());
            if (!((File)object2).exists() || ((File)object2).isDirectory()) {
                HeroDesigner.getActiveHero().setExportTemplate(null);
            } else {
                HeroDesigner.getActiveHero().setExportTemplate(((File)object2).getAbsolutePath());
            }
        }
        while (HeroDesigner.getActiveHero().getExportTemplate() == null || HeroDesigner.getActiveHero().getExportTemplate().trim().length() == 0) {
            File file3;
            if (exportTemplateDialog == null) {
                exportTemplateDialog = new ExportTemplateDialog();
            }
            exportTemplateDialog.setDialogTitle("Select Export Format for " + HeroDesigner.getActiveHero().getCharacterName());
            exportTemplateDialog.showOpenDialog(frame);
            if (exportTemplateDialog.canceled()) {
                return;
            }
            object2 = exportTemplateDialog.getSelectedPath();
            if (object2 == null || ((String)object2).trim().length() <= 0 || !(file3 = new File((String)object2)).exists()) continue;
            HeroDesigner.getActiveHero().setExportTemplate((String)object2);
            this.prefs.setExportTemplateDir(new File((String)object2).getParent());
        }
        while (file == null) {
            try {
                jFileChooser = new JFileChooser();
                object2 = new HTMLWriter(new File(HeroDesigner.getActiveHero().getExportTemplate()));
                this.exts = ((HTMLWriter)object2).getFileExtensions();
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                            return true;
                        }
                        if (HeroDesigner.this.exts == null || HeroDesigner.this.exts.size() == 0) {
                            return true;
                        }
                        String string = file.getName();
                        String string2 = string.substring(string.lastIndexOf(".") + 1, string.length());
                        return HeroDesigner.this.exts.contains(string2.trim().toUpperCase());
                    }

                    @Override
                    public String getDescription() {
                        String string = "";
                        if (HeroDesigner.this.exts == null || HeroDesigner.this.exts.size() == 0) {
                            return "All Files";
                        }
                        for (String string2 : HeroDesigner.this.exts) {
                            if (string.length() > 0) {
                                string = string + ", ";
                            }
                            string = string + "*." + string2;
                        }
                        return string;
                    }
                });
                jFileChooser.setApproveButtonText("Export");
                jFileChooser.setDialogTitle("Export " + HeroDesigner.getActiveHero().getCharacterName() + " to File");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                if (this.prefs.getExportDir() != null && this.prefs.getExportDir().trim().length() > 0) {
                    try {
                        jFileChooser.setCurrentDirectory(new File(this.prefs.getExportDir()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (HeroDesigner.getActiveHero().getCharacterName() != null && HeroDesigner.getActiveHero().getCharacterName().trim().length() > 0) {
                    try {
                        File file4 = new File(HeroDesigner.getActiveHero().getCharacterName() + "." + this.exts.get(0));
                        jFileChooser.setSelectedFile(file4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int n = jFileChooser.showSaveDialog(frame);
                if (n == 1) {
                    return;
                }
                if (n != 0) continue;
                file = jFileChooser.getSelectedFile();
                this.prefs.setExportDir(file.getParent());
                String string = file.getName();
                object = ".txt";
                if (this.exts != null && this.exts.size() > 0) {
                    object = "." + this.exts.get(0);
                }
                if (string.indexOf(".") < 0) {
                    string = string + (String)object;
                }
                if (!string.equals(file.getName())) {
                    String string2 = "";
                    if (file.getParentFile() != null) {
                        string2 = file.getParent();
                        if (!string2.endsWith(File.separator)) {
                            string2 = string2 + File.separator;
                        }
                    }
                    file = new File(string2 + string);
                }
                if (!file.exists()) continue;
                int n2 = 0;
                if (!headless) {
                    JOptionPane.showConfirmDialog(frame, file.getName() + " already exists.\n\nOverwrite?");
                }
                if (n2 == 2) {
                    return;
                }
                if (n2 != 1) continue;
                file = null;
            }
            catch (Exception exception) {}
        }
        if (HeroDesigner.getActiveHero().getImageData() != null && HeroDesigner.getActiveHero().getImageData().length > 0 && HeroDesigner.getActiveHero().getImageFileName().trim().length() > 0) {
            int n = 0;
            if (this.getPrefs().getPromptToExportImage() && headless) {
                n = JOptionPane.showConfirmDialog(frame, "Do you wish to include the image associated\nwith this character with the export file?");
            }
            if (n == 0) {
                if (jFileChooser2 == null) {
                    jFileChooser2 = new JFileChooser();
                    jFileChooser2.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory() && !file.getName().toUpperCase().endsWith(".PKG") && !file.getName().toUpperCase().endsWith(".APP")) {
                                return true;
                            }
                            if (file.getName().toUpperCase().endsWith(".GIF")) {
                                return true;
                            }
                            if (file.getName().toUpperCase().endsWith(".JPG")) {
                                return true;
                            }
                            return file.getName().toUpperCase().endsWith(".JPEG");
                        }

                        @Override
                        public String getDescription() {
                            return "Images Only";
                        }
                    });
                    jFileChooser2.setApproveButtonText("Save Image Copy");
                    jFileChooser2.setDialogTitle("Save Image Copy for " + HeroDesigner.getActiveHero().getCharacterName() + " Export");
                    jFileChooser2.setFileSelectionMode(0);
                    jFileChooser2.setMultiSelectionEnabled(false);
                    jFileChooser2.setAcceptAllFileFilterUsed(false);
                }
                if (this.prefs.getExportDir() != null && this.prefs.getExportDir().trim().length() > 0) {
                    try {
                        jFileChooser2.setCurrentDirectory(file.getParentFile());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String string = file.getParent();
                file2 = null;
                if (HeroDesigner.getActiveHero().getImageFileName() != null && HeroDesigner.getActiveHero().getImageFileName().trim().length() > 0) {
                    jFileChooser2.setSelectedFile(new File(HeroDesigner.getActiveHero().getImageFileName()));
                }
                while (file2 == null) {
                    int n3 = jFileChooser2.showSaveDialog(frame);
                    if (n3 == 1) {
                        return;
                    }
                    if (n3 != 0) continue;
                    file2 = jFileChooser2.getSelectedFile();
                    object = file2.getName();
                    String string3 = HeroDesigner.getActiveHero().getImageFileName();
                    String string4 = "";
                    string4 = string3 == null || string3.trim().length() == 0 || string3.lastIndexOf(".") < 0 ? ".jpg" : string3.substring(string3.lastIndexOf("."), string3.length());
                    if (((String)object).indexOf(".") < 0) {
                        object = (String)object + string4;
                    }
                    if (!((String)object).equals(file2.getName())) {
                        String string5 = "";
                        if (file2.getParentFile() != null) {
                            string5 = file2.getParent();
                            if (!string5.endsWith(File.separator)) {
                                string5 = string5 + File.separator;
                            }
                        }
                        file2 = new File(string5 + (String)object);
                    }
                    if (!file2.exists()) continue;
                    int n4 = 0;
                    if (!headless) {
                        JOptionPane.showConfirmDialog(frame, file2.getName() + " already exists.\n\nOverwrite?");
                    }
                    if (n4 == 2) {
                        return;
                    }
                    if (n4 != 1) continue;
                    file2 = null;
                }
            } else {
                file2 = null;
            }
        }
        try {
            frame.setCursor(Cursor.getPredefinedCursor(3));
            HTMLWriter hTMLWriter = new HTMLWriter(new File(HeroDesigner.getActiveHero().getExportTemplate()));
            String string = hTMLWriter.generateOutput(file2 == null ? "" : file2.getName());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            if (file2 != null) {
                object = new FileOutputStream(file2);
                ((FileOutputStream)object).write(HeroDesigner.getActiveHero().getImageData());
                ((OutputStream)object).flush();
                ((FileOutputStream)object).close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (!headless) {
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred during export.\nPlease try again.\n\nError Message: " + exception.getMessage(), "Error exporting to file", 0);
            }
        }
        finally {
            if (!headless) {
                frame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public String getActiveExport(File file, File file2) throws Exception {
        HTMLWriter hTMLWriter = new HTMLWriter(file);
        String string = hTMLWriter.generateOutput(file2 == null ? "" : file2.getName());
        return string;
    }

    public void closeAll() {
        for (int i = this.openHeroes.size() - 1; i >= 0; --i) {
            Hero hero;
            activeHero = hero = this.openHeroes.get(i);
            this.openHeroes.remove(i);
            if (!headless) {
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.windowMenu.getItem(i);
                this.windowGroup.remove(jRadioButtonMenuItem);
                this.windowMenu.remove(jRadioButtonMenuItem);
            }
            this.logMemory("Close Character");
        }
        this.setActiveHero(null);
        if (!headless) {
            this.setActiveCharacterMenu();
        }
    }

    static {
        docsFilePath = "HDDocs.pdf";
        fontSize = 12;
        runner = null;
        version = "20210301";
        headless = false;
    }

    public class MemoryMonitor
    extends Thread {
        @Override
        public void run() {
            while (true) {
                BigDecimal bigDecimal = new BigDecimal((double)Runtime.getRuntime().maxMemory() / 1048576.0);
                bigDecimal = bigDecimal.setScale(0, 4);
                BigDecimal bigDecimal2 = new BigDecimal((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0);
                bigDecimal2 = bigDecimal2.setScale(0, 4);
                HeroDesigner.this.memoryUsagePB.setString(bigDecimal2.toString() + "M of " + bigDecimal.toString() + "M");
                HeroDesigner.this.memoryUsagePB.setValue(bigDecimal2.intValue());
                if (bigDecimal.intValue() - bigDecimal2.intValue() < 5) {
                    System.gc();
                    bigDecimal = new BigDecimal((double)Runtime.getRuntime().maxMemory() / 1048576.0);
                    bigDecimal = bigDecimal.setScale(0, 4);
                    bigDecimal2 = new BigDecimal((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0);
                    bigDecimal2 = bigDecimal2.setScale(0, 4);
                    HeroDesigner.this.memoryUsagePB.setString(bigDecimal2.toString() + "M of " + bigDecimal.toString() + "M");
                    HeroDesigner.this.memoryUsagePB.setValue(bigDecimal2.intValue());
                    if (bigDecimal.intValue() - bigDecimal2.intValue() < 5) {
                        HeroDesigner.this.lowMemory = true;
                        for (int i = HeroDesigner.this.unloadPrefabMI.getItemCount() - 1; i >= 0; --i) {
                            HeroDesigner.this.unloadPrefabMI.getItem(i).doClick();
                        }
                        String string = "<html>Warning!  HD is running low on memory.<br><br>To help prevent data loss, all prefabs have been unloaded.<br><br>It is recommended that you save your work and restart the application in the not-too-distant future.</html>";
                        JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), string, "Low Memory Warning", 2);
                        if (activeHero != null) {
                            HeroDesigner.this.mainPanel.updatePrefabs();
                        }
                    }
                } else {
                    HeroDesigner.this.lowMemory = false;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class PluginInfo {
        private String author;
        private String contact;
        private String description;
        private String fileName;
        private String mainClass;
        private String name;

        public PluginInfo(JarFile jarFile, String string) throws IOException {
            Manifest manifest = jarFile.getManifest();
            this.fileName = string;
            this.name = manifest.getMainAttributes().getValue("Plugin-Name");
            this.author = manifest.getMainAttributes().getValue("Plugin-Author");
            this.contact = manifest.getMainAttributes().getValue("Plugin-Contact");
            this.description = manifest.getMainAttributes().getValue("Plugin-Description");
            this.mainClass = manifest.getMainAttributes().getValue("Main-Class");
            if (this.name == null) {
                this.name = "";
            }
            if (this.author == null) {
                this.author = "";
            }
            if (this.contact == null) {
                this.contact = "";
            }
            if (this.description == null) {
                this.description = "";
            }
            if (this.mainClass == null) {
                this.mainClass = "";
            }
        }

        public String getAuthor() {
            return this.author;
        }

        public String getContact() {
            return this.contact;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public String getName() {
            return this.name;
        }
    }

    protected class PrefabActionListener
    implements ActionListener {
        private Prefab prefab;
        private JMenuItem prefabMI;

        public PrefabActionListener(Prefab prefab, JMenuItem jMenuItem) {
            this.prefab = prefab;
            this.prefabMI = jMenuItem;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HeroDesigner.this.loadedPrefabs.remove(this.prefab);
            HeroDesigner.this.unloadPrefabMI.remove(this.prefabMI);
            HeroDesigner.this.mainPanel.updatePrefabs();
        }
    }

    private class RecentlySelectedMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = -6417429614143547439L;
        File file;

        public RecentlySelectedMenuItem(File file) {
            super(file.getAbsolutePath());
            this.file = file;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (RecentlySelectedMenuItem.this.file != null && RecentlySelectedMenuItem.this.file.exists()) {
                        HeroDesigner.this.openHero(RecentlySelectedMenuItem.this.file, true);
                    }
                }
            });
        }
    }
}

