/*
 * Decompiled with CFR 0.152.
 */
package com.hero;

import com.hero.HeroDesigner;
import com.hero.Prefab;
import com.hero.Rules;
import com.hero.Template;
import com.hero.objects.Adder;
import com.hero.objects.ElementalControl;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.Multipower;
import com.hero.objects.VariablePowerPool;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.disads.Disadvantage;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.modifiers.Modifier;
import com.hero.objects.modifiers.TimeLimit;
import com.hero.objects.perks.Follower;
import com.hero.objects.perks.Perk;
import com.hero.objects.perks.Vehicle;
import com.hero.objects.powers.Duplication;
import com.hero.objects.powers.Multiform;
import com.hero.objects.powers.Power;
import com.hero.objects.powers.Summon;
import com.hero.objects.skills.Skill;
import com.hero.objects.talents.MageSight;
import com.hero.objects.talents.Talent;
import com.hero.util.Base64;
import com.hero.util.Rounder;
import com.hero.util.Utility;
import com.hero.util.XMLUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class Hero
implements Cloneable {
    private int agePosition;
    private long ageParentID;
    private String alternateIdentities;
    private String appearance;
    private String background;
    private int basePoints;
    private String campaignName;
    private String campaignUse;
    private long characteristicCalcTime;
    private ArrayList<GenericObject> characteristics;
    private double characteristicTotal;
    protected String characterName;
    protected boolean dirty;
    private int disadPoints;
    protected ArrayList<GenericObject> disads;
    private int disadsUsed;
    private long disadsUsedCalcTime;
    protected ArrayList<GenericObject> equipment;
    private int experience;
    private String exportTemplate;
    private String eyeColor;
    private String genre;
    private String gm;
    private String hairColor;
    private double height;
    private byte[] imageData;
    private String imageFileName;
    private String imageFilePath;
    private boolean isLoading;
    protected long lastEdit;
    protected int lastTab;
    protected ArrayList<GenericObject> maneuvers;
    private Adder ncmObject;
    private int ncmPosition;
    private long ncmParentID;
    private boolean ncmSelected;
    private String notes1;
    private String notes2;
    private String notes3;
    private String notes4;
    private String notes5;
    protected File openFile;
    protected String originalTemplateID;
    protected ArrayList<GenericObject> perks;
    private String personality;
    protected String playerName;
    protected ArrayList<GenericObject> powers;
    private boolean prefabLoad;
    private String quote;
    protected Rules rules;
    protected File saveFile;
    protected ArrayList<GenericObject> skills;
    private long spentTotalCalcTime;
    private String tactics;
    protected ArrayList<GenericObject> talents;
    private String templatePath;
    private double total;
    private double weight;
    private ArrayList<Prefab> prefabs;
    private boolean mOnlineCharacter;
    private String mRole;
    private String mUse;
    private String mGender;

    public Hero() throws Exception {
        this.agePosition = 0;
        this.ageParentID = -1L;
        this.dirty = false;
        this.isLoading = false;
        this.ncmPosition = 0;
        this.ncmParentID = -1L;
        this.total = -9.99999999999E11;
        this.mOnlineCharacter = false;
        this.isLoading = true;
        Utility.garbageCollect("Loading new character/prefab");
        if (HeroDesigner.getActiveTemplate() == null) {
            throw new Exception("Null Template!");
        }
        if (HeroDesigner.getActiveHero() != null) {
            this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
        }
        this.rules = new Rules();
        if (HeroDesigner.getInstance().getPrefs().getLastRule().trim().length() == 0) {
            this.rules.useDefault();
        } else {
            this.rules.loadRulesDefinition(HeroDesigner.getInstance().getPrefs().getLastRule());
        }
        this.basePoints = this.rules.getBasePoints();
        this.disadPoints = this.rules.getDisadPoints();
        this.ncmSelected = this.rules.isNCMSelected();
        this.init();
        this.isLoading = false;
    }

    public Hero(InputStream inputStream) {
        block21: {
            this.agePosition = 0;
            this.ageParentID = -1L;
            this.dirty = false;
            this.isLoading = false;
            this.ncmPosition = 0;
            this.ncmParentID = -1L;
            this.total = -9.99999999999E11;
            this.mOnlineCharacter = false;
            this.isLoading = true;
            this.mOnlineCharacter = true;
            Utility.garbageCollect("Loading file from HD Online stream");
            String string = "builtIn.Superheroic.hdt";
            try {
                Element element = new Element("EMPTY");
                SAXBuilder sAXBuilder = new SAXBuilder(false);
                Document document = sAXBuilder.build(inputStream);
                sAXBuilder = null;
                element = document.getRootElement();
                Element element2 = element.getChild("TEMPLATE");
                if (element2 != null) {
                    Object object;
                    boolean bl = false;
                    String string2 = XMLUtility.getValue(element2, "originalPath");
                    if (string2 != null) {
                        object = new File(string2);
                        if (((File)object).exists()) {
                            if (((File)object).lastModified() > this.saveFile.lastModified()) {
                                int n = 0;
                                if (!HeroDesigner.headless) {
                                    n = JOptionPane.showConfirmDialog(HeroDesigner.getAppFrame(), "There appears to be a newer copy of the template (hdt) file used on this character.  Would you like to load the new template file?", "New Template Found for " + this.saveFile.getName(), 0);
                                }
                                if (n == 0) {
                                    HeroDesigner.getInstance().setTemplate(string2, false, false, false);
                                    if (HeroDesigner.getActiveTemplate() == null) {
                                        HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                                    }
                                    this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                                    this.templatePath = HeroDesigner.getActiveTemplate().getId();
                                    bl = true;
                                }
                            }
                        } else {
                            object = new File(HeroDesigner.getInstance().getPrefs().getTemplateDir() + File.separator + ((File)object).getName());
                            if (((File)object).exists() && ((File)object).lastModified() > this.saveFile.lastModified()) {
                                int n = 0;
                                if (!HeroDesigner.headless) {
                                    n = JOptionPane.showConfirmDialog(HeroDesigner.getAppFrame(), "There appears to be a newer copy of the template (hdt) file used on this character.  Would you like to load the new template file?", "New Template Found for " + this.saveFile.getName(), 0);
                                }
                                if (n == 0) {
                                    HeroDesigner.getInstance().setTemplate(string2, false, false, false);
                                    if (HeroDesigner.getActiveTemplate() == null) {
                                        HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                                    }
                                    this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                                    this.templatePath = HeroDesigner.getActiveTemplate().getId();
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (!bl) {
                        String string3 = this.openFile.getAbsolutePath();
                        HeroDesigner.getInstance();
                        object = new Template(element2, string3, HeroDesigner.getActiveTemplate(), new Date(this.saveFile.lastModified()));
                        HeroDesigner.getInstance().setActiveTemplate((Template)object);
                        this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                        this.templatePath = HeroDesigner.getActiveTemplate().getId();
                    }
                } else if (element.getAttributeValue("TEMPLATE") != null && element.getAttributeValue("TEMPLATE").trim().length() > 0) {
                    string = element.getAttributeValue("TEMPLATE");
                    HeroDesigner.getInstance().setTemplate(string, string.startsWith("builtIn."), false, false);
                    if (HeroDesigner.getActiveTemplate() == null) {
                        HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                    }
                    this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                    this.templatePath = HeroDesigner.getActiveTemplate().getId();
                } else {
                    Element element3 = element.getChild("BASIC_CONFIGURATION");
                    if (element3 != null && ((string = XMLUtility.getValue(element3, "TEMPLATE")) == null || string.trim().length() == 0)) {
                        string = "builtIn.Superheroic.hdt";
                    }
                    HeroDesigner.getInstance().setTemplate(string, string.startsWith("builtIn."), false, false);
                    if (HeroDesigner.getActiveTemplate() == null) {
                        HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                    }
                    this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                    this.templatePath = HeroDesigner.getActiveTemplate().getId();
                }
                this.initFromSave(document);
            }
            catch (Exception exception) {
                string = "builtIn.Superheroic.hdt";
                exception.printStackTrace();
                if (HeroDesigner.headless) break block21;
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred retrieving the template used for the saved character.\nUsing 'Standard Super' template.\n\nError Message: " + exception.getMessage(), "Error retrieving template", 0);
            }
        }
        this.isLoading = false;
    }

    public Hero(File file) {
        block24: {
            this.agePosition = 0;
            this.ageParentID = -1L;
            this.dirty = false;
            this.isLoading = false;
            this.ncmPosition = 0;
            this.ncmParentID = -1L;
            this.total = -9.99999999999E11;
            this.mOnlineCharacter = false;
            this.isLoading = true;
            Utility.garbageCollect("Loading file " + file.getAbsolutePath());
            String string = "builtIn.Superheroic.hdt";
            this.openFile = file;
            if (file.getName().trim().toUpperCase().endsWith(".HDT")) {
                this.originalTemplateID = string = file.getAbsolutePath();
                HeroDesigner.getInstance().setTemplate(string, false, false, false);
            } else {
                this.saveFile = file;
                try {
                    Element element = new Element("EMPTY");
                    if (file.exists() && file.canRead()) {
                        SAXBuilder sAXBuilder = new SAXBuilder(false);
                        Document document = sAXBuilder.build(file);
                        sAXBuilder = null;
                        element = document.getRootElement();
                        Element element2 = element.getChild("TEMPLATE");
                        if (element2 != null) {
                            Object object;
                            boolean bl = false;
                            String string2 = XMLUtility.getValue(element2, "originalPath");
                            if (string2 != null) {
                                object = new File(string2);
                                if (((File)object).exists()) {
                                    if (((File)object).lastModified() > file.lastModified()) {
                                        int n = 0;
                                        if (!HeroDesigner.headless) {
                                            n = JOptionPane.showConfirmDialog(HeroDesigner.getAppFrame(), "There appears to be a newer copy of the template (hdt) file used on this character.  Would you like to load the new template file?", "New Template Found for " + file.getName(), 0);
                                        }
                                        if (n == 0) {
                                            HeroDesigner.getInstance().setTemplate(string2, false, false, false);
                                            if (HeroDesigner.getActiveTemplate() == null) {
                                                HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                                            }
                                            this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                                            this.templatePath = HeroDesigner.getActiveTemplate().getId();
                                            bl = true;
                                        }
                                    }
                                } else {
                                    object = new File(HeroDesigner.getInstance().getPrefs().getTemplateDir() + File.separator + ((File)object).getName());
                                    if (((File)object).exists() && ((File)object).lastModified() > file.lastModified()) {
                                        int n = 0;
                                        if (!HeroDesigner.headless) {
                                            n = JOptionPane.showConfirmDialog(HeroDesigner.getAppFrame(), "There appears to be a newer copy of the template (hdt) file used on this character.  Would you like to load the new template file?", "New Template Found for " + file.getName(), 0);
                                        }
                                        if (n == 0) {
                                            HeroDesigner.getInstance().setTemplate(string2, false, false, false);
                                            if (HeroDesigner.getActiveTemplate() == null) {
                                                HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                                            }
                                            this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                                            this.templatePath = HeroDesigner.getActiveTemplate().getId();
                                            bl = true;
                                        }
                                    }
                                }
                            }
                            if (!bl) {
                                String string3 = this.openFile.getAbsolutePath();
                                HeroDesigner.getInstance();
                                object = new Template(element2, string3, HeroDesigner.getActiveTemplate(), new Date(file.lastModified()));
                                HeroDesigner.getInstance().setActiveTemplate((Template)object);
                                this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                                this.templatePath = HeroDesigner.getActiveTemplate().getId();
                            }
                        } else if (element.getAttributeValue("TEMPLATE") != null && element.getAttributeValue("TEMPLATE").trim().length() > 0) {
                            string = element.getAttributeValue("TEMPLATE");
                            HeroDesigner.getInstance().setTemplate(string, string.startsWith("builtIn."), false, false);
                            if (HeroDesigner.getActiveTemplate() == null) {
                                HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                            }
                            this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                            this.templatePath = HeroDesigner.getActiveTemplate().getId();
                        } else {
                            Element element3 = element.getChild("BASIC_CONFIGURATION");
                            if (element3 != null && ((string = XMLUtility.getValue(element3, "TEMPLATE")) == null || string.trim().length() == 0)) {
                                string = "builtIn.Superheroic.hdt";
                            }
                            HeroDesigner.getInstance().setTemplate(string, string.startsWith("builtIn."), false, false);
                            if (HeroDesigner.getActiveTemplate() == null) {
                                HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                            }
                            this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                            this.templatePath = HeroDesigner.getActiveTemplate().getId();
                        }
                    }
                }
                catch (Exception exception) {
                    string = "builtIn.Superheroic.hdt";
                    exception.printStackTrace();
                    if (HeroDesigner.headless) break block24;
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred retrieving the template used for the saved character.\nUsing 'Standard Super' template.\n\nError Message: " + exception.getMessage(), "Error retrieving template", 0);
                }
            }
        }
        this.initFromSave();
        this.isLoading = false;
    }

    protected Hero(File file, boolean bl) {
        block12: {
            this.agePosition = 0;
            this.ageParentID = -1L;
            this.dirty = false;
            this.isLoading = false;
            this.ncmPosition = 0;
            this.ncmParentID = -1L;
            this.total = -9.99999999999E11;
            this.mOnlineCharacter = false;
            this.isLoading = true;
            Utility.garbageCollect("Loading file " + file.getAbsolutePath());
            this.saveFile = file;
            this.openFile = file;
            this.prefabLoad = bl;
            String string = "builtIn.Superheroic.hdt";
            try {
                Element element = new Element("EMPTY");
                if (file.exists() && file.canRead()) {
                    SAXBuilder sAXBuilder = new SAXBuilder(false);
                    Document document = sAXBuilder.build(file);
                    sAXBuilder = null;
                    element = document.getRootElement();
                    Element element2 = element.getChild("TEMPLATE");
                    if (element2 != null) {
                        if (!bl) {
                            String string2 = this.openFile.getAbsolutePath();
                            HeroDesigner.getInstance();
                            Template template = new Template(element2, string2, HeroDesigner.getActiveTemplate(), new Date(file.lastModified()));
                            HeroDesigner.getInstance().setActiveTemplate(template);
                        }
                        this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                        this.templatePath = HeroDesigner.getActiveTemplate().getId();
                    } else if (element.getAttributeValue("TEMPLATE") != null && element.getAttributeValue("TEMPLATE").trim().length() > 0 && !bl) {
                        string = element.getAttributeValue("TEMPLATE");
                        HeroDesigner.getInstance().setTemplate(string, string.startsWith("builtIn."), false, false);
                        if (HeroDesigner.getActiveTemplate() == null) {
                            HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                        }
                        this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                        this.templatePath = HeroDesigner.getActiveTemplate().getId();
                    } else {
                        Element element3 = element.getChild("BASIC_CONFIGURATION");
                        if (element3 != null && ((string = XMLUtility.getValue(element3, "TEMPLATE")) == null || string.trim().length() == 0)) {
                            string = "builtIn.Superheroic.hdt";
                        }
                        if (!bl) {
                            HeroDesigner.getInstance().setTemplate(string, string.startsWith("builtIn."), false, false);
                            if (HeroDesigner.getActiveTemplate() == null) {
                                HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
                            }
                        }
                        this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
                        this.templatePath = HeroDesigner.getActiveTemplate().getId();
                    }
                }
            }
            catch (Exception exception) {
                string = "builtIn.Superheroic.hdt";
                exception.printStackTrace();
                if (HeroDesigner.headless) break block12;
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred retrieving the template used for the saved character.\nUsing 'Standard Super' template.\n\nError Message: " + exception.getMessage(), "Error retrieving template", 0);
            }
        }
        this.initFromSave();
        this.isLoading = false;
    }

    public void setIsLoading(boolean bl) {
        this.isLoading = bl;
    }

    public Hero(File file, File file2, File file3, File file4) {
        Object object;
        this.agePosition = 0;
        this.ageParentID = -1L;
        this.dirty = false;
        this.isLoading = false;
        this.ncmPosition = 0;
        this.ncmParentID = -1L;
        this.total = -9.99999999999E11;
        this.mOnlineCharacter = false;
        this.isLoading = true;
        Utility.garbageCollect("Loading file " + file4.getAbsolutePath());
        this.saveFile = file4;
        this.openFile = file;
        if (file2 != null) {
            HeroDesigner.getInstance().setTemplate(file2.getAbsolutePath(), false, false, false);
        } else {
            block12: {
                object = "builtIn.Superheroic.hdt";
                try {
                    Element element = new Element("EMPTY");
                    if (file != null && file.exists() && file.canRead()) {
                        SAXBuilder sAXBuilder = new SAXBuilder(false);
                        Document document = sAXBuilder.build(file);
                        sAXBuilder = null;
                        element = document.getRootElement();
                        Element element2 = element.getChild("BASIC_CONFIGURATION");
                        if (element2 != null && ((object = XMLUtility.getValue(element2, "TEMPLATE")) == null || ((String)object).trim().length() == 0)) {
                            object = "builtIn.Superheroic.hdt";
                        }
                    }
                }
                catch (Exception exception) {
                    object = "builtIn.Superheroic.hdt";
                    exception.printStackTrace();
                    if (HeroDesigner.headless) break block12;
                    JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred retrieving the template used for the saved character.\nUsing 'Standard Super' template.\n\nError Message: " + exception.getMessage(), "Error retrieving template", 0);
                }
            }
            HeroDesigner.getInstance().setTemplate((String)object, ((String)object).startsWith("builtIn."), false, false);
            if (HeroDesigner.getActiveTemplate() == null) {
                HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
            }
            this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
        }
        if (HeroDesigner.getActiveTemplate() == null) {
            HeroDesigner.getInstance().setTemplate("builtIn.Superheroic.hdt", true, false, false);
        }
        this.originalTemplateID = HeroDesigner.getActiveTemplate().getId();
        this.templatePath = HeroDesigner.getActiveTemplate().getId();
        this.initFromSave();
        if (file3 != null && file3.exists()) {
            this.imageData = new byte[(int)file3.length()];
            this.imageFileName = file3.getName();
            this.imageFilePath = file3.getAbsolutePath();
            try {
                object = new FileInputStream(file3);
                ((FileInputStream)object).read(this.imageData);
                ((FileInputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.isLoading = false;
    }

    public Hero(Element element, Template template) {
        this.agePosition = 0;
        this.ageParentID = -1L;
        this.dirty = false;
        this.isLoading = false;
        this.ncmPosition = 0;
        this.ncmParentID = -1L;
        this.total = -9.99999999999E11;
        this.mOnlineCharacter = false;
        this.isLoading = true;
        Utility.garbageCollect("Loading file from template");
        HeroDesigner.getInstance().setActiveTemplate(template);
        this.originalTemplateID = template.getId();
        this.templatePath = template.getId();
        this.init();
        this.restoreCharacter(element);
        this.isLoading = false;
    }

    public Hero(Element element) {
        this.agePosition = 0;
        this.ageParentID = -1L;
        this.dirty = false;
        this.isLoading = false;
        this.ncmPosition = 0;
        this.ncmParentID = -1L;
        this.total = -9.99999999999E11;
        this.mOnlineCharacter = false;
        this.isLoading = true;
        Utility.garbageCollect("Loading file from template");
        HeroDesigner.getInstance();
        Template template = HeroDesigner.getActiveTemplate();
        this.originalTemplateID = template.getId();
        this.templatePath = template.getId();
        this.init();
        this.restoreCharacter(element);
        this.isLoading = false;
    }

    public void setUse(String string) {
        this.mUse = string != null ? (string.equals("Solo") || string.equals("Group") || string.equals("Master") ? string : "") : "";
    }

    public String getUse() {
        if (this.mUse == null) {
            this.mUse = "";
        }
        return this.mUse;
    }

    public void setRole(String string) {
        this.mRole = string != null ? (string.equals("Protagonist") || string.equals("Antagonist") || string.equals("Neutral/NPC") ? string : "") : "";
    }

    public String getRole() {
        if (this.mRole == null) {
            this.mRole = "";
        }
        return this.mRole;
    }

    public void setGender(String string) {
        this.mGender = string != null ? (string.equals("Male") || string.equals("Female") || string.equals("Other") || string.equals("None") ? string : "") : "";
    }

    public String getGender() {
        if (this.mGender == null) {
            this.mGender = "";
        }
        return this.mGender;
    }

    public Properties getMetaData() {
        Properties properties = new Properties();
        properties.setProperty("RulesEdition", HeroDesigner.getActiveTemplate().is6E() ? "6th Edition" : "5th Edition");
        if (HeroDesigner.getActiveTemplate() != null) {
            properties.setProperty("TemplateName", HeroDesigner.getActiveTemplate().getName());
        } else {
            properties.setProperty("TemplateName", "[Unknown]");
        }
        this.total = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l = 0L;
        ArrayList<GenericObject> arrayList = this.getCharacteristics();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
            n = (int)((double)n + genericObject.getRealCost());
            if (!(genericObject.getActiveCost() > (double)l)) continue;
            l = Rounder.roundHalfUp(genericObject.getActiveCost());
        }
        properties.setProperty("CharacteristicPoints", "" + n);
        arrayList = this.getSkills();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
            n2 = (int)((double)n2 + genericObject.getRealCost());
            if (!(genericObject.getActiveCost() > (double)l)) continue;
            l = Rounder.roundHalfUp(genericObject.getActiveCost());
        }
        properties.setProperty("SkillsPoints", "" + n2);
        arrayList = this.getPerks();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
            n4 = (int)((double)n4 + genericObject.getRealCost());
            if (!(genericObject.getActiveCost() > (double)l)) continue;
            l = Rounder.roundHalfUp(genericObject.getActiveCost());
        }
        properties.setProperty("PerksPoints", "" + n4);
        arrayList = this.getTalents();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
            n3 = (int)((double)n3 + genericObject.getRealCost());
            if (!(genericObject.getActiveCost() > (double)l)) continue;
            l = Rounder.roundHalfUp(genericObject.getActiveCost());
        }
        properties.setProperty("TalentsPoints", "" + n3);
        arrayList = this.getManeuvers();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
            n5 = (int)((double)n5 + genericObject.getRealCost());
            if (!(genericObject.getActiveCost() > (double)l)) continue;
            l = Rounder.roundHalfUp(genericObject.getActiveCost());
        }
        properties.setProperty("ManeuversPoints", "" + n5);
        arrayList = this.getPowers();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
            n6 = (int)((double)n6 + genericObject.getRealCost());
            if (!(genericObject.getActiveCost() > (double)l)) continue;
            l = Rounder.roundHalfUp(genericObject.getActiveCost());
        }
        properties.setProperty("PowersPoints", "" + n6);
        properties.setProperty("TotalPoints", "" + this.total);
        properties.setProperty("MaxActivePoints", "" + l);
        properties.setProperty("DisadPoints", "" + this.getDisadsUsed());
        properties.setProperty("ImageDataAssigned", this.getImageData() != null && this.getImageData().length > 0 ? "Yes" : "No");
        return properties;
    }

    public ArrayList<Prefab> getPrefabs() {
        return this.prefabs;
    }

    protected void applyPackageDeal(Hero hero) {
        boolean bl;
        block0: for (Prefab cloneable : hero.getPrefabs()) {
            for (Prefab prefab : this.prefabs) {
                if (!prefab.getName().equals(cloneable.getName())) continue;
                continue block0;
            }
            this.prefabs.add(cloneable);
        }
        for (GenericObject genericObject : hero.getCharacteristics()) {
            for (GenericObject genericObject2 : this.getCharacteristics()) {
                if (!genericObject2.getXMLID().equals(genericObject.getXMLID())) continue;
                genericObject2.setLevels(genericObject2.getLevels() + genericObject.getLevels());
            }
        }
        block4: for (GenericObject genericObject : hero.getDisads()) {
            for (GenericObject genericObject3 : this.getDisads()) {
                if (genericObject3.getID() != genericObject.getID()) continue;
                continue block4;
            }
            this.addDisad(genericObject);
        }
        block6: for (GenericObject genericObject : hero.getSkills()) {
            for (GenericObject genericObject4 : this.getSkills()) {
                if (genericObject4.getID() != genericObject.getID()) continue;
                continue block6;
            }
            for (GenericObject genericObject5 : this.getSkills()) {
                bl = false;
                if (genericObject5.getXMLID().equals(genericObject.getXMLID()) && genericObject5.isExclusive()) {
                    bl = true;
                } else if (genericObject5.getTextOutput().equals(genericObject.getTextOutput())) {
                    bl = true;
                }
                if (!bl) continue;
            }
            this.addSkill(genericObject);
        }
        block9: for (GenericObject genericObject : hero.getPerks()) {
            for (GenericObject genericObject6 : this.getPerks()) {
                if (genericObject6.getID() != genericObject.getID()) continue;
                continue block9;
            }
            for (GenericObject genericObject7 : this.getPerks()) {
                bl = false;
                if (genericObject7.getXMLID().equals(genericObject.getXMLID()) && genericObject7.isExclusive()) {
                    bl = true;
                } else if (genericObject7.getTextOutput().equals(genericObject.getTextOutput())) {
                    bl = true;
                }
                if (!bl) continue;
            }
            this.addPerk(genericObject);
        }
        block12: for (GenericObject genericObject : hero.getTalents()) {
            for (GenericObject genericObject8 : this.getTalents()) {
                if (genericObject8.getID() != genericObject.getID()) continue;
                continue block12;
            }
            for (GenericObject genericObject9 : this.getTalents()) {
                bl = false;
                if (genericObject9.getXMLID().equals(genericObject.getXMLID()) && genericObject9.isExclusive()) {
                    bl = true;
                } else if (genericObject9.getTextOutput().equals(genericObject.getTextOutput())) {
                    bl = true;
                }
                if (!bl) continue;
            }
            this.addTalent(genericObject);
        }
        block15: for (GenericObject genericObject : hero.getManeuvers()) {
            for (GenericObject genericObject10 : this.getManeuvers()) {
                if (genericObject10.getID() != genericObject.getID()) continue;
                continue block15;
            }
            for (GenericObject genericObject11 : this.getManeuvers()) {
                bl = false;
                if (genericObject11.getXMLID().equals(genericObject.getXMLID()) && genericObject11.isExclusive()) {
                    bl = true;
                } else if (genericObject11.getTextOutput().equals(genericObject.getTextOutput())) {
                    bl = true;
                }
                if (!bl) continue;
            }
            this.addManeuver(genericObject);
        }
        block18: for (GenericObject genericObject : hero.getPowers()) {
            for (GenericObject genericObject12 : this.getPowers()) {
                if (genericObject12.getID() != genericObject.getID()) continue;
                continue block18;
            }
            for (GenericObject genericObject13 : this.getPowers()) {
                bl = false;
                if (genericObject13.getXMLID().equals(genericObject.getXMLID()) && genericObject13.isExclusive()) {
                    bl = true;
                } else if (genericObject13.getTextOutput().equals(genericObject.getTextOutput())) {
                    bl = true;
                }
                if (!bl) continue;
            }
            this.addPower(genericObject);
        }
        block21: for (GenericObject genericObject : hero.getEquipment()) {
            for (GenericObject genericObject14 : this.getEquipment()) {
                if (genericObject14.getID() != genericObject.getID()) continue;
                continue block21;
            }
            for (GenericObject genericObject15 : this.getEquipment()) {
                bl = false;
                if (genericObject15.getXMLID().equals(genericObject.getXMLID()) && genericObject15.isExclusive()) {
                    bl = true;
                } else if (genericObject15.getTextOutput().equals(genericObject.getTextOutput())) {
                    bl = true;
                }
                if (!bl) continue;
            }
            this.addEquipment(genericObject);
        }
    }

    protected void addDisad(GenericObject genericObject) {
        if (genericObject instanceof List) {
            for (GenericObject genericObject2 : this.disads) {
                if (genericObject2.getParentID() != genericObject.getID()) continue;
                ((List)genericObject).addObject(genericObject2);
                genericObject2.setParent((List)genericObject);
            }
        }
        if (genericObject.getParentID() > 0L) {
            for (GenericObject genericObject2 : this.disads) {
                if (!(genericObject2 instanceof List) || genericObject2.getID() != genericObject.getParentID()) continue;
                ((List)genericObject2).addObject(genericObject);
                genericObject.setParent((List)genericObject2);
            }
        }
        this.getDisads().add(genericObject);
    }

    protected void addEquipment(GenericObject genericObject) {
        genericObject.setPower(true);
        genericObject.setIsEquipment(true);
        if (genericObject instanceof List) {
            for (GenericObject genericObject2 : this.equipment) {
                if (genericObject2.getParentID() != genericObject.getID()) continue;
                ((List)genericObject).addObject(genericObject2);
                genericObject2.setParent((List)genericObject);
            }
        }
        if (genericObject.getParentID() > 0L) {
            for (GenericObject genericObject2 : this.equipment) {
                if (!(genericObject2 instanceof List) || genericObject2.getID() != genericObject.getParentID()) continue;
                ((List)genericObject2).addObject(genericObject);
                genericObject.setParent((List)genericObject2);
            }
        }
        this.getEquipment().add(genericObject);
    }

    protected void addManeuver(GenericObject genericObject) {
        if (genericObject instanceof List) {
            for (GenericObject genericObject2 : this.maneuvers) {
                if (genericObject2.getParentID() != genericObject.getID()) continue;
                ((List)genericObject).addObject(genericObject2);
                genericObject2.setParent((List)genericObject);
            }
        }
        if (genericObject.getParentID() > 0L) {
            for (GenericObject genericObject2 : this.maneuvers) {
                if (!(genericObject2 instanceof List) || genericObject2.getID() != genericObject.getParentID()) continue;
                ((List)genericObject2).addObject(genericObject);
                genericObject.setParent((List)genericObject2);
            }
        }
        this.maneuvers.add(genericObject);
    }

    protected void addPerk(GenericObject genericObject) {
        if (genericObject instanceof List) {
            for (GenericObject genericObject2 : this.perks) {
                if (genericObject2.getParentID() != genericObject.getID()) continue;
                ((List)genericObject).addObject(genericObject2);
                genericObject2.setParent((List)genericObject);
            }
        }
        if (genericObject.getParentID() > 0L) {
            for (GenericObject genericObject2 : this.perks) {
                if (!(genericObject2 instanceof List) || genericObject2.getID() != genericObject.getParentID()) continue;
                ((List)genericObject2).addObject(genericObject);
                genericObject.setParent((List)genericObject2);
            }
        }
        this.perks.add(genericObject);
    }

    protected void addPower(GenericObject genericObject) {
        genericObject.setPower(true);
        genericObject.setIsEquipment(false);
        if (genericObject instanceof List) {
            for (GenericObject genericObject2 : this.powers) {
                if (genericObject2.getParentID() != genericObject.getID()) continue;
                ((List)genericObject).addObject(genericObject2);
                genericObject2.setParent((List)genericObject);
            }
        }
        if (genericObject.getParentID() > 0L) {
            for (GenericObject genericObject2 : this.powers) {
                if (!(genericObject2 instanceof List) || genericObject2.getID() != genericObject.getParentID()) continue;
                ((List)genericObject2).addObject(genericObject);
                genericObject.setParent((List)genericObject2);
            }
        }
        for (Modifier modifier : genericObject.getAssignedModifiers()) {
            if (!(modifier instanceof TimeLimit)) continue;
            modifier.setParent(genericObject);
            modifier.setSelectedOption(modifier.getSelectedOption());
        }
        this.powers.add(genericObject);
    }

    protected void addSkill(GenericObject genericObject) {
        if (genericObject instanceof List) {
            for (GenericObject genericObject2 : this.skills) {
                if (genericObject2.getParentID() != genericObject.getID()) continue;
                ((List)genericObject).addObject(genericObject2);
                genericObject2.setParent((List)genericObject);
            }
        }
        if (genericObject.getParentID() > 0L) {
            for (GenericObject genericObject2 : this.skills) {
                if (!(genericObject2 instanceof List) || genericObject2.getID() != genericObject.getParentID()) continue;
                ((List)genericObject2).addObject(genericObject);
                genericObject.setParent((List)genericObject2);
            }
        }
        this.skills.add(genericObject);
    }

    protected void addTalent(GenericObject genericObject) {
        if (genericObject instanceof List) {
            for (GenericObject genericObject2 : this.talents) {
                if (genericObject2.getParentID() != genericObject.getID()) continue;
                ((List)genericObject).addObject(genericObject2);
                genericObject2.setParent((List)genericObject);
            }
        }
        if (genericObject.getParentID() > 0L) {
            for (GenericObject genericObject2 : this.talents) {
                if (!(genericObject2 instanceof List) || genericObject2.getID() != genericObject.getParentID()) continue;
                ((List)genericObject2).addObject(genericObject);
                genericObject.setParent((List)genericObject2);
            }
        }
        this.talents.add(genericObject);
    }

    public Adder getAgeObject() {
        HeroDesigner.getInstance();
        if (HeroDesigner.getActiveTemplate().getNCMObject() == null) {
            return null;
        }
        if (!this.ncmHasAge()) {
            return null;
        }
        if (this.ncmObject.getSelectedOption() == null) {
            return null;
        }
        Adder adder = null;
        adder = this.ncmObject.getSelectedOption().clone();
        if (adder.getXMLID().equals(this.ncmObject.getXMLID())) {
            return null;
        }
        adder.setID(this.ncmObject.getSelectedOption().getID());
        adder.setBaseCost(adder.getBaseCost() - this.getBaseNCMObject().getBaseCost());
        adder.setPosition(this.agePosition);
        if (this.ageParentID > 0L) {
            List list = null;
            for (GenericObject genericObject : this.disads) {
                if (!(genericObject instanceof List) || genericObject.getID() != this.ageParentID) continue;
                list = (List)genericObject;
                break;
            }
            if (list != null) {
                adder.setParent(list);
                if (!list.getObjects().contains(adder)) {
                    list.getObjects().add(adder);
                }
            }
        }
        if (this.isNCMSelected()) {
            adder.setSelected(true);
        } else {
            adder.setSelected(false);
        }
        if (adder == null) {
            return null;
        }
        if (adder.getAlias().trim().length() == 0) {
            adder.setAlias(adder.getDisplay());
        }
        return adder;
    }

    public String getAlternateIdentities() {
        return this.alternateIdentities;
    }

    public String getAppearance() {
        return this.appearance;
    }

    public String getBackground() {
        return this.background;
    }

    Adder getBaseNCMObject() {
        if (!this.ncmHasAge()) {
            return null;
        }
        Adder adder = null;
        for (Adder adder2 : this.ncmObject.getOptions()) {
            if (!adder2.getXMLID().equals(this.ncmObject.getXMLID())) continue;
            adder = adder2;
        }
        return adder;
    }

    public int getBasePoints() {
        return this.basePoints;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public String getCampaignUse() {
        return this.campaignUse;
    }

    public Characteristic getCharacteristic(int n) {
        Characteristic characteristic = null;
        for (int i = 0; i < this.characteristics.size(); ++i) {
            Characteristic characteristic2 = (Characteristic)this.characteristics.get(i);
            if (characteristic2.getType() != n) continue;
            characteristic = characteristic2;
        }
        return characteristic;
    }

    public ArrayList<GenericObject> getCharacteristics() {
        return this.characteristics;
    }

    public double getCharacteristicsTotal() {
        if (this.characteristicCalcTime > 0L && this.characteristicCalcTime > this.lastEdit) {
            return this.characteristicTotal;
        }
        this.characteristicTotal = 0.0;
        for (GenericObject genericObject : this.characteristics) {
            this.characteristicTotal += genericObject.getRealCost();
        }
        this.characteristicCalcTime = System.currentTimeMillis();
        return this.characteristicTotal;
    }

    public String getCharacterName() {
        return this.characterName;
    }

    public int getDisadPoints() {
        return this.disadPoints;
    }

    public ArrayList<GenericObject> getDisads() {
        return this.disads;
    }

    public int getDisadsUsed() {
        if (this.disadsUsedCalcTime > 0L && this.disadsUsedCalcTime > this.lastEdit) {
            return this.disadsUsed;
        }
        if (this.isNCMSelected() && this.getNCMObject() != null) {
            if (GenericObject.findObjectByID(this.getDisads(), "NCM") == null) {
                this.getDisads().add(this.getNCMObject());
                if (this.getAgeObject() != null) {
                    this.getDisads().add(this.getAgeObject());
                }
            }
        } else if (GenericObject.findObjectByID(this.getDisads(), "NCM") != null) {
            this.getDisads().remove(this.getNCMObject());
            if (this.getAgeObject() != null) {
                this.getDisads().remove(this.getAgeObject());
            }
        }
        this.disadsUsed = 0;
        ArrayList<GenericObject> arrayList = this.getDisads();
        for (GenericObject genericObject : arrayList) {
            this.disadsUsed = (int)((double)this.disadsUsed + genericObject.getRealCost());
        }
        this.disadsUsedCalcTime = System.currentTimeMillis();
        return this.disadsUsed;
    }

    public ArrayList<GenericObject> getEquipment() {
        if (this.equipment == null) {
            this.equipment = new ArrayList();
        }
        if (!this.isPrefab() && !this.getRules().isEquipmentAllowed()) {
            return new ArrayList<GenericObject>();
        }
        return this.equipment;
    }

    public int getExperience() {
        return this.experience;
    }

    public String getExportTemplate() {
        if (this.exportTemplate == null) {
            return null;
        }
        File file = new File(this.exportTemplate);
        if (file.exists()) {
            return this.exportTemplate;
        }
        return null;
    }

    public String getEyeColor() {
        return this.eyeColor;
    }

    public Adder getFullNCMObject() {
        HeroDesigner.getInstance();
        if (HeroDesigner.getActiveTemplate().getNCMObject() == null) {
            return null;
        }
        return this.ncmObject;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getGm() {
        return this.gm;
    }

    public String getHairColor() {
        return this.hairColor;
    }

    public int getHeight() {
        if (!HeroDesigner.getInstance().getPrefs().isMetric()) {
            return (int)Rounder.roundHalfUp(this.height);
        }
        int n = (int)Rounder.roundHalfUp(this.height * 2.54);
        return n;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public String getImageFileName() {
        if (this.imageFileName == null) {
            this.imageFileName = "";
        }
        return this.imageFileName;
    }

    public int getLastTabIndex() {
        if (this.lastTab < 0 || this.lastTab > 9) {
            this.lastTab = 0;
        }
        return this.lastTab;
    }

    public ArrayList<GenericObject> getManeuvers() {
        return this.maneuvers;
    }

    public Adder getNCMObject() {
        HeroDesigner.getInstance();
        if (HeroDesigner.getActiveTemplate().getNCMObject() == null) {
            return null;
        }
        if (this.ncmObject == null) {
            return null;
        }
        Adder adder = null;
        adder = this.ncmObject.clone();
        adder.setID(this.ncmObject.getID());
        if (this.isNCMSelected()) {
            adder.setSelected(true);
        } else if (this.ncmObject != null) {
            adder.setSelected(false);
        }
        if (this.ncmHasAge() && (!adder.getSelectedOption().getXMLID().equals(adder.getXMLID()) || adder.getSelectedOption().getAlias().equals(adder.getSelectedOption().getDisplay()))) {
            adder.setOptions(new ArrayList<Adder>());
            adder.setSelectedOption(null);
            adder.setBaseCost(this.getBaseNCMObject().getBaseCost());
            adder.setPosition(this.ncmPosition);
        }
        if (adder.getAlias().trim().length() == 0) {
            adder.setAlias(adder.getDisplay());
        }
        if (this.ncmParentID > 0L) {
            List list = null;
            for (GenericObject genericObject : this.disads) {
                if (!(genericObject instanceof List) || genericObject.getID() != this.ncmParentID) continue;
                list = (List)genericObject;
                break;
            }
            if (list != null) {
                adder.setParent(list);
                if (!list.getObjects().contains(adder)) {
                    list.getObjects().add(adder);
                }
            }
        }
        return adder;
    }

    public String getNotes1() {
        if (this.notes1 == null) {
            this.notes1 = "";
        }
        return this.notes1;
    }

    public String getNotes2() {
        if (this.notes2 == null) {
            this.notes2 = "";
        }
        return this.notes2;
    }

    public String getNotes3() {
        if (this.notes3 == null) {
            this.notes3 = "";
        }
        return this.notes3;
    }

    public String getNotes4() {
        if (this.notes4 == null) {
            this.notes4 = "";
        }
        return this.notes4;
    }

    public String getNotes5() {
        if (this.notes5 == null) {
            this.notes5 = "";
        }
        return this.notes5;
    }

    public String getOriginalTemplateID() {
        return this.originalTemplateID;
    }

    public ArrayList<GenericObject> getPerks() {
        return this.perks;
    }

    public String getPersonality() {
        return this.personality;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public ArrayList<GenericObject> getPowers() {
        return this.powers;
    }

    public String getQuote() {
        return this.quote;
    }

    public Rules getRules() {
        if (this.rules == null) {
            this.rules = new Rules();
            if (HeroDesigner.getInstance().getPrefs().getLastRule().trim().length() <= 0) {
                this.rules.useDefault();
            } else {
                this.rules.loadRulesDefinition(HeroDesigner.getInstance().getPrefs().getLastRule());
            }
        }
        return this.rules;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public Element getSaveXML() {
        Element element;
        Element element2 = new Element("CHARACTER");
        element2.setAttribute("version", "6.0");
        Element element3 = new Element("BASIC_CONFIGURATION");
        element3.setAttribute("BASE_POINTS", "" + this.getBasePoints());
        element3.setAttribute("DISAD_POINTS", "" + this.getDisadPoints());
        element3.setAttribute("EXPERIENCE", "" + this.getExperience());
        if (this.isNCMSelected() && this.ncmObject != null) {
            element = this.ncmObject.getSaveXML();
            element.setName("NCM");
            element3.addContent(element);
        }
        if (this.exportTemplate != null) {
            element3.setAttribute("EXPORT_TEMPLATE", this.exportTemplate);
        }
        element2.addContent(element3);
        element = new Element("CHARACTER_INFO");
        element.setAttribute("CHARACTER_NAME", this.getCharacterName());
        element.setAttribute("ALTERNATE_IDENTITIES", this.getAlternateIdentities());
        element.setAttribute("PLAYER_NAME", this.getPlayerName());
        element.setAttribute("HEIGHT", "" + this.height);
        element.setAttribute("WEIGHT", "" + this.weight);
        element.setAttribute("HAIR_COLOR", this.getHairColor());
        element.setAttribute("EYE_COLOR", this.getEyeColor());
        element.setAttribute("CAMPAIGN_NAME", this.getCampaignName());
        element.setAttribute("GENRE", this.getGenre());
        element.setAttribute("GM", this.getGm());
        Element element4 = new Element("BACKGROUND");
        element4.addContent(this.getBackground());
        element.addContent(element4);
        Element element5 = new Element("PERSONALITY");
        element5.addContent(this.getPersonality());
        element.addContent(element5);
        Element element6 = new Element("QUOTE");
        element6.addContent(this.getQuote());
        element.addContent(element6);
        Element element7 = new Element("TACTICS");
        element7.addContent(this.getTactics());
        element.addContent(element7);
        Element element8 = new Element("CAMPAIGN_USE");
        element8.addContent(this.getCampaignUse());
        element.addContent(element8);
        Element element9 = new Element("APPEARANCE");
        element9.addContent(this.getAppearance());
        element.addContent(element9);
        Element element10 = new Element("NOTES1");
        element10.addContent(this.getNotes1());
        element.addContent(element10);
        Element element11 = new Element("NOTES2");
        element11.addContent(this.getNotes2());
        element.addContent(element11);
        Element element12 = new Element("NOTES3");
        element12.addContent(this.getNotes3());
        element.addContent(element12);
        Element element13 = new Element("NOTES4");
        element13.addContent(this.getNotes4());
        element.addContent(element13);
        Element element14 = new Element("NOTES5");
        element14.addContent(this.getNotes5());
        element.addContent(element14);
        element2.addContent(element);
        Element element15 = new Element("CHARACTERISTICS");
        for (GenericObject object52 : this.characteristics) {
            element15.addContent(object52.getSaveXML());
        }
        element2.addContent(element15);
        Element element16 = new Element("SKILLS");
        for (GenericObject genericObject : this.skills) {
            element16.addContent(genericObject.getSaveXML());
        }
        element2.addContent(element16);
        Element element17 = new Element("PERKS");
        for (GenericObject genericObject : this.perks) {
            element17.addContent(genericObject.getSaveXML());
        }
        element2.addContent(element17);
        Element element18 = new Element("TALENTS");
        for (GenericObject genericObject : this.talents) {
            element18.addContent(genericObject.getSaveXML());
        }
        element2.addContent(element18);
        Element element19 = new Element("MARTIALARTS");
        for (GenericObject genericObject : this.maneuvers) {
            element19.addContent(genericObject.getSaveXML());
        }
        element2.addContent(element19);
        Element element20 = new Element("POWERS");
        for (GenericObject genericObject : this.powers) {
            element20.addContent(genericObject.getSaveXML());
        }
        element2.addContent(element20);
        Element element21 = new Element("DISADVANTAGES");
        for (GenericObject genericObject : this.disads) {
            element21.addContent(genericObject.getSaveXML());
        }
        element2.addContent(element21);
        if (this.equipment != null) {
            Element element22 = new Element("EQUIPMENT");
            for (GenericObject genericObject : this.equipment) {
                element22.addContent(genericObject.getSaveXML());
            }
            element2.addContent(element22);
        }
        if (!this.isPrefab()) {
            if (this.imageData != null && this.getImageFileName() != null && this.imageData.length > 0 && this.getImageFileName().trim().length() > 0) {
                try {
                    String string = Base64.encodeBytes(this.imageData);
                    Element element23 = new Element("IMAGE");
                    CDATA cDATA = new CDATA(string);
                    element23.setContent(cDATA);
                    element23.setAttribute("FileName", this.getImageFileName());
                    element23.setAttribute("FilePath", this.imageFilePath == null ? "" : this.imageFilePath);
                    element2.addContent(element23);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.getRules().isDefault()) {
                element3.setAttribute("RULES", "Default");
            } else {
                Element element24 = this.getRules().getRulesXML();
                element2.addContent(element24);
            }
            HeroDesigner.getInstance();
            if (HeroDesigner.getActiveTemplate().getId().startsWith("builtIn")) {
                HeroDesigner.getInstance();
                element2.setAttribute("TEMPLATE", HeroDesigner.getActiveTemplate().getId());
            } else {
                HeroDesigner.getInstance();
                Element element25 = HeroDesigner.getActiveTemplate().getTemplateXML();
                if (element25.getAttributeValue("originalPath") == null) {
                    HeroDesigner.getInstance();
                    element25.setAttribute("originalPath", HeroDesigner.getActiveTemplate().getId());
                }
                element25.removeChildren("CHARACTER");
                element25.removeChildren("PREFAB");
                element25.removeChildren("RULES");
                element25.detach();
                element2.addContent(element25);
            }
            for (Prefab prefab : this.prefabs) {
                Element element26 = prefab.getSaveXML();
                element26.removeChildren("TEMPLATE");
                element26.removeChildren("IMAGE");
                element26.removeChildren("RULES");
                element3 = element26.getChild("BASIC_CONFIGURATION");
                element3.setAttribute("RULES", "");
                element3.setAttribute("TEMPLATE", "");
                element2.addContent(element26);
            }
        } else {
            HeroDesigner.getInstance();
            element2.setAttribute("TEMPLATE", HeroDesigner.getActiveTemplate().getId());
        }
        return element2;
    }

    public ArrayList<GenericObject> getSkills() {
        if (this.skills == null) {
            this.skills = new ArrayList();
        }
        return this.skills;
    }

    public double getSpentTotal() {
        if (this.spentTotalCalcTime > 0L && this.spentTotalCalcTime > this.lastEdit && this.spentTotalCalcTime > HeroDesigner.lastEdit) {
            return this.total;
        }
        this.total = 0.0;
        ArrayList<GenericObject> arrayList = this.getCharacteristics();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
        }
        arrayList = this.getSkills();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
        }
        arrayList = this.getPerks();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
        }
        arrayList = this.getTalents();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
        }
        arrayList = this.getManeuvers();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
        }
        arrayList = this.getPowers();
        for (GenericObject genericObject : arrayList) {
            this.total += genericObject.getRealCost();
        }
        this.spentTotalCalcTime = System.currentTimeMillis();
        return this.total;
    }

    public String getTactics() {
        return this.tactics;
    }

    public ArrayList<GenericObject> getTalents() {
        return this.talents;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public int getWeight() {
        if (!HeroDesigner.getInstance().getPrefs().isMetric()) {
            int n = (int)Rounder.roundHalfUp(this.weight);
            return n;
        }
        int n = (int)Rounder.roundHalfUp(this.weight * 453.5924) / 1000;
        return n;
    }

    protected void init() {
        Template template = HeroDesigner.getActiveTemplate();
        this.characteristics = new ArrayList();
        this.skills = new ArrayList();
        this.perks = new ArrayList();
        this.talents = new ArrayList();
        this.maneuvers = new ArrayList();
        this.powers = new ArrayList();
        this.disads = new ArrayList();
        this.equipment = new ArrayList();
        this.prefabs = new ArrayList();
        this.experience = 0;
        this.ncmObject = template.getNCMObject() != null ? template.getNCMObject().clone() : null;
        this.characterName = "";
        this.alternateIdentities = "";
        this.playerName = "";
        this.height = 78.74015748031496;
        this.weight = 220.4622476037958;
        this.hairColor = "Brown";
        this.eyeColor = "Brown";
        this.campaignName = "";
        this.genre = "";
        this.gm = "";
        this.background = "";
        this.personality = "";
        this.quote = "";
        this.tactics = "";
        this.campaignUse = "";
        this.appearance = "";
        this.exportTemplate = null;
        ArrayList<GenericObject> arrayList = template.getCharacteristics();
        for (GenericObject genericObject : arrayList) {
            genericObject = genericObject.clone();
            genericObject.setID(System.currentTimeMillis() + (long)((int)(Math.random() * 1000.0)));
            genericObject.setPower(false);
            this.characteristics.add(genericObject);
        }
    }

    protected void initFromSave() {
        block4: {
            try {
                if (this.openFile != null && this.openFile.exists() && this.openFile.canRead()) {
                    SAXBuilder sAXBuilder = new SAXBuilder(false);
                    Document document = sAXBuilder.build(this.openFile);
                    this.initFromSave(document);
                } else {
                    this.initFromSave(null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (HeroDesigner.headless) break block4;
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the character.\nData loss may occur if you save.\n\nPlease shut down Hero Designer and restart.\n\nError Message: " + exception.getMessage(), "Error loading character", 0);
            }
        }
    }

    protected void initFromSave(Document document) {
        block48: {
            this.init();
            if (!this.prefabLoad) {
                HeroDesigner.activeHero = this;
            }
            Template template = HeroDesigner.getActiveTemplate();
            try {
                Object object;
                int n;
                Object object2;
                Object object3;
                Parent parent;
                Element element;
                block47: {
                    element = new Element("EMPTY");
                    Element element2 = new Element("EMPTY");
                    if (document != null) {
                        try {
                            parent = document;
                            element2 = element = ((Document)parent).getRootElement();
                            if (this.openFile != null && this.openFile.getName().trim().toUpperCase().endsWith(".HDT")) {
                                element = element.getChild("CHARACTER");
                            }
                            if (element == null) {
                                return;
                            }
                            if (this.prefabLoad && (object3 = XMLUtility.getValue(element, "NAME")) != null && ((String)object3).trim().length() > 0) {
                                this.characterName = object3;
                            }
                            if (!this.isPrefab()) {
                                Object object4;
                                object3 = element.getChild("RULES");
                                boolean bl = false;
                                if (object3 != null) {
                                    object4 = XMLUtility.getValue((Element)object3, "path");
                                    object2 = new File((String)object4);
                                    if (!((File)object2).exists()) {
                                        object2 = new File(HeroDesigner.getInstance().getPrefs().getRulesDir() + File.separator + ((File)object2).getName());
                                    }
                                    if (((File)object2).exists() && ((File)object2).lastModified() > this.saveFile.lastModified()) {
                                        n = 0;
                                        if (!HeroDesigner.headless) {
                                            JOptionPane.showConfirmDialog(HeroDesigner.getAppFrame(), "There appears to be a newer copy of the campaign rules (hdr) file used on this character.  Would you like to load the new rules file?", "New Campaign Rules Found for " + this.saveFile.getName(), 0);
                                        }
                                        if (n == 0) {
                                            object = new Rules();
                                            ((Rules)object).loadRulesDefinition(((File)object2).getAbsolutePath());
                                            this.rules = object;
                                            bl = true;
                                        }
                                    }
                                    if (!bl) {
                                        Rules rules = new Rules();
                                        if (this.openFile != null) {
                                            rules.setCurrentSet(this.openFile.getName());
                                        } else {
                                            rules.setCurrentSet("HD Online Character");
                                        }
                                        rules.restoreRules((Element)object3);
                                        this.rules = rules;
                                        bl = true;
                                    }
                                }
                                if (!bl) {
                                    if (this.openFile != null && this.openFile.getName().trim().toUpperCase().endsWith(".HDT") && element == null) {
                                        object4 = element2.getChild("RULES");
                                        this.rules = new Rules();
                                        if (object4 != null) {
                                            this.rules.setCurrentSet(this.openFile.getName());
                                            this.rules.restoreRules((Element)object4);
                                        } else if (HeroDesigner.getInstance().getPrefs().getLastRule().trim().length() > 0) {
                                            this.rules.useDefault();
                                        } else {
                                            this.rules.loadRulesDefinition(HeroDesigner.getInstance().getPrefs().getLastRule());
                                        }
                                        return;
                                    }
                                    object4 = element.getChild("BASIC_CONFIGURATION");
                                    if (object4 != null) {
                                        if (this.openFile != null && this.openFile.getName().trim().toUpperCase().endsWith(".HDT")) {
                                            object2 = element2.getChild("RULES");
                                            this.rules = new Rules();
                                            if (object2 != null) {
                                                this.rules.setCurrentSet(this.openFile.getName());
                                                this.rules.restoreRules((Element)object2);
                                            } else if (HeroDesigner.getInstance().getPrefs().getLastRule().trim().length() == 0) {
                                                this.rules.useDefault();
                                            } else {
                                                this.rules.loadRulesDefinition(HeroDesigner.getInstance().getPrefs().getLastRule());
                                            }
                                        } else {
                                            object2 = XMLUtility.getValue((Element)object4, "RULES");
                                            if (this.rules == null && (object2 == null || ((String)object2).trim().length() == 0 || ((String)object2).trim().equalsIgnoreCase("Default"))) {
                                                this.rules = new Rules();
                                                this.rules.useDefault();
                                            } else if (this.rules == null) {
                                                File file = new File((String)object2);
                                                if (file.exists()) {
                                                    this.rules = new Rules();
                                                    this.rules.loadRulesDefinition((String)object2);
                                                } else {
                                                    if (HeroDesigner.getInstance().getPrefs().getDefaultRulesDir() != null) {
                                                        file = new File(HeroDesigner.getInstance().getPrefs().getDefaultRulesDir() + File.separator + file.getName());
                                                    }
                                                    if (file.exists()) {
                                                        this.rules = new Rules();
                                                        this.rules.loadRulesDefinition((String)object2);
                                                    } else {
                                                        this.rules = new Rules();
                                                        this.rules.useDefault();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (HeroDesigner.headless) break block47;
                            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the template.\nData loss may occur if you save.\n\nPlease shut down Hero Designer and restart.\n\nError Message: " + exception.getMessage(), "Error loading template", 0);
                        }
                    }
                }
                this.restoreCharacter(element);
                if (this.isPrefab() || (parent = element.getChild("IMAGE")) == null || !(((Element)parent).getContent(0) instanceof CDATA)) break block48;
                object3 = (CDATA)((Element)parent).getContent(0);
                String string = ((Text)object3).getText();
                boolean bl = false;
                this.imageFileName = ((Element)parent).getAttributeValue("FileName");
                this.imageFilePath = ((Element)parent).getAttributeValue("FilePath");
                if (this.imageFilePath != null && this.imageFilePath.trim().length() > 0) {
                    object2 = new File(this.imageFilePath);
                    if (!((File)object2).exists()) {
                        object2 = new File(HeroDesigner.getInstance().getPrefs().getImageDir() + File.separator + ((File)object2).getName());
                    }
                    if (((File)object2).exists() && ((File)object2).lastModified() > this.saveFile.lastModified()) {
                        n = 0;
                        if (!HeroDesigner.headless) {
                            n = JOptionPane.showConfirmDialog(HeroDesigner.getAppFrame(), "There appears to be a newer copy of the image file used on this character.  Would you like to load the new image file?", "New Image Found for " + this.saveFile.getName(), 0);
                        }
                        if (n == 0) {
                            try {
                                this.imageData = new byte[(int)((File)object2).length()];
                                object = new FileInputStream((File)object2);
                                ((FileInputStream)object).read(this.imageData);
                                ((FileInputStream)object).close();
                                bl = true;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!bl) {
                    this.imageData = Base64.decode(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (HeroDesigner.headless) break block48;
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the character.\nData loss may occur if you save.\n\nPlease shut down Hero Designer and restart.\n\nError Message: " + exception.getMessage(), "Error loading character", 0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void restoreCharacter(Element element) {
        block131: {
            Template template = HeroDesigner.getActiveTemplate();
            try {
                Element element2;
                Element element3;
                Element element4;
                Iterator<GenericObject> iterator;
                Object object;
                Object object22;
                Object object32;
                Element element5;
                Object object4;
                Object object5;
                Object object62;
                Object object17;
                Object object18;
                Element element22;
                if (!this.isPrefab()) {
                    this.ncmObject = template.getNCMObject() != null ? template.getNCMObject().clone() : null;
                    element22 = element.getChild("BASIC_CONFIGURATION");
                    if (element22 != null) {
                        object18 = element22.getChild("NCM");
                        if (this.ncmObject != null && object18 != null) {
                            this.ncmObject.restoreFromSave((Element)object18);
                            this.ncmSelected = true;
                        } else {
                            this.ncmSelected = false;
                        }
                        object17 = XMLUtility.getValue(element22, "BASE_POINTS");
                        if (object17 != null && ((String)object17).trim().length() > 0) {
                            try {
                                this.basePoints = Integer.parseInt((String)object17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((object17 = XMLUtility.getValue(element22, "EXPORT_TEMPLATE")) != null && ((String)object17).trim().length() > 0) {
                            File exception;
                            File object162 = new File((String)object17);
                            if (object162.exists()) {
                                this.exportTemplate = object162.getAbsolutePath();
                            } else if (HeroDesigner.getInstance().getPrefs().getDefaultExportDir() != null && (exception = new File(HeroDesigner.getInstance().getPrefs().getDefaultExportDir() + File.separator + object162.getName())).exists()) {
                                this.exportTemplate = exception.getAbsolutePath();
                            }
                        }
                        if ((object17 = XMLUtility.getValue(element22, "DISAD_POINTS")) != null && ((String)object17).trim().length() > 0) {
                            try {
                                this.disadPoints = Integer.parseInt((String)object17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((object17 = XMLUtility.getValue(element22, "EXPERIENCE")) != null && ((String)object17).trim().length() > 0) {
                            try {
                                this.experience = Integer.parseInt((String)object17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if ((element22 = element.getChild("CHARACTER_INFO")) != null) {
                    object18 = XMLUtility.getValue(element22, "CHARACTER_NAME");
                    if (object18 != null && ((String)object18).trim().length() > 0) {
                        this.characterName = object18;
                    }
                    if ((object18 = XMLUtility.getValue(element22, "PLAYER_NAME")) != null && ((String)object18).trim().length() > 0) {
                        this.playerName = object18;
                    }
                    if (!this.isPrefab()) {
                        object18 = XMLUtility.getValue(element22, "ALTERNATE_IDENTITIES");
                        if (object18 != null && ((String)object18).trim().length() > 0) {
                            this.alternateIdentities = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "IMAGE_PATH")) != null && ((String)object18).trim().length() > 0) {
                            object17 = new File((String)object18);
                            if (((File)object17).exists() && ((File)object17).canRead()) {
                                this.imageData = new byte[(int)((File)object17).length()];
                                FileInputStream fileInputStream = new FileInputStream((File)object17);
                                fileInputStream.read(this.imageData);
                                this.imageFileName = ((File)object17).getName();
                                this.imageFilePath = ((File)object17).getAbsolutePath();
                            } else {
                                object17 = new File(HeroDesigner.getInstance().getPrefs().getImageDir() + File.separator + ((File)object17).getName());
                                if (((File)object17).exists() && ((File)object17).canRead()) {
                                    this.imageData = new byte[(int)((File)object17).length()];
                                    FileInputStream fileInputStream = new FileInputStream((File)object17);
                                    fileInputStream.read(this.imageData);
                                    this.imageFileName = ((File)object17).getName();
                                    this.imageFilePath = ((File)object17).getAbsolutePath();
                                }
                            }
                        }
                        if ((object18 = XMLUtility.getValue(element22, "HEIGHT")) != null && ((String)object18).trim().length() > 0) {
                            try {
                                this.height = Double.parseDouble((String)object18);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((object18 = XMLUtility.getValue(element22, "WEIGHT")) != null && ((String)object18).trim().length() > 0) {
                            try {
                                this.weight = Double.parseDouble((String)object18);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((object18 = XMLUtility.getValue(element22, "HAIR_COLOR")) != null && ((String)object18).trim().length() > 0) {
                            this.hairColor = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "EYE_COLOR")) != null && ((String)object18).trim().length() > 0) {
                            this.eyeColor = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "CAMPAIGN_NAME")) != null && ((String)object18).trim().length() > 0) {
                            this.campaignName = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "GENRE")) != null && ((String)object18).trim().length() > 0) {
                            this.genre = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "GM")) != null && ((String)object18).trim().length() > 0) {
                            this.gm = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "BACKGROUND")) != null && ((String)object18).trim().length() > 0) {
                            this.background = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "PERSONALITY")) != null && ((String)object18).trim().length() > 0) {
                            this.personality = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "QUOTE")) != null && ((String)object18).trim().length() > 0) {
                            this.quote = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "TACTICS")) != null && ((String)object18).trim().length() > 0) {
                            this.tactics = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "CAMPAIGN_USE")) != null && ((String)object18).trim().length() > 0) {
                            this.campaignUse = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "APPEARANCE")) != null && ((String)object18).trim().length() > 0) {
                            this.appearance = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "NOTES1")) != null && ((String)object18).trim().length() > 0) {
                            this.notes1 = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "NOTES2")) != null && ((String)object18).trim().length() > 0) {
                            this.notes2 = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "NOTES3")) != null && ((String)object18).trim().length() > 0) {
                            this.notes3 = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "NOTES4")) != null && ((String)object18).trim().length() > 0) {
                            this.notes4 = object18;
                        }
                        if ((object18 = XMLUtility.getValue(element22, "NOTES5")) != null && ((String)object18).trim().length() > 0) {
                            this.notes5 = object18;
                        }
                    }
                }
                object18 = new Hashtable();
                for (GenericObject genericObject : template.getSkills()) {
                    if (genericObject instanceof Skill) {
                        ((Hashtable)object18).put(genericObject.getXMLID(), genericObject);
                        continue;
                    }
                    if (!(genericObject instanceof List)) continue;
                    List list = (List)genericObject;
                    for (GenericObject genericObject2 : list.getObjects()) {
                        if (!(genericObject2 instanceof Skill)) continue;
                        ((Hashtable)object18).put(genericObject2.getXMLID(), genericObject2);
                    }
                }
                object17 = new Hashtable();
                for (GenericObject genericObject : template.getPerks()) {
                    if (genericObject instanceof Perk) {
                        ((Hashtable)object17).put(genericObject.getXMLID(), genericObject);
                        continue;
                    }
                    if (!(genericObject instanceof List)) continue;
                    List list = (List)genericObject;
                    for (GenericObject genericObject3 : list.getObjects()) {
                        if (!(genericObject3 instanceof Perk)) continue;
                        ((Hashtable)object17).put(genericObject3.getXMLID(), genericObject3);
                    }
                }
                Hashtable<String, GenericObject> hashtable = new Hashtable<String, GenericObject>();
                for (GenericObject genericObject : template.getTalents()) {
                    if (genericObject instanceof Talent || genericObject instanceof MageSight) {
                        hashtable.put(genericObject.getXMLID(), genericObject);
                        continue;
                    }
                    if (!(genericObject instanceof List)) continue;
                    List list = (List)genericObject;
                    for (GenericObject genericObject4 : list.getObjects()) {
                        if (!(genericObject4 instanceof Talent) && !(genericObject4 instanceof MageSight)) continue;
                        hashtable.put(genericObject4.getXMLID(), genericObject4);
                    }
                }
                Hashtable<String, GenericObject> hashtable2 = new Hashtable<String, GenericObject>();
                for (GenericObject genericObject : template.getMartialArts()) {
                    if (genericObject instanceof Maneuver) {
                        hashtable2.put(genericObject.getDisplay(), genericObject);
                        continue;
                    }
                    if (!(genericObject instanceof List)) continue;
                    List list = (List)genericObject;
                    ArrayList<GenericObject> arrayList = list.getObjects();
                    object62 = arrayList.iterator();
                    while (object62.hasNext()) {
                        object5 = object62.next();
                        hashtable2.put(((GenericObject)object5).getDisplay(), (GenericObject)object5);
                    }
                }
                Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                for (GenericObject genericObject : template.getPowers()) {
                    if (genericObject instanceof Power) {
                        hashtable3.put(genericObject.getXMLID(), genericObject);
                        continue;
                    }
                    if (!(genericObject instanceof List)) continue;
                    List list = (List)genericObject;
                    object62 = list.getObjects().iterator();
                    while (object62.hasNext()) {
                        object5 = object62.next();
                        if (object5 instanceof Power) {
                            hashtable3.put(((GenericObject)object5).getXMLID(), object5);
                            continue;
                        }
                        if (!(object5 instanceof List)) continue;
                        object4 = (List)object5;
                        for (GenericObject genericObject5 : ((List)object4).getObjects()) {
                            if (!(genericObject5 instanceof Power)) continue;
                            hashtable3.put(genericObject5.getXMLID(), genericObject5);
                        }
                    }
                }
                Hashtable<String, GenericObject> hashtable4 = new Hashtable<String, GenericObject>();
                for (GenericObject genericObject : template.getDisads()) {
                    if (genericObject instanceof Disadvantage) {
                        hashtable4.put(genericObject.getXMLID(), genericObject);
                        continue;
                    }
                    if (!(genericObject instanceof List)) continue;
                    object62 = (List)genericObject;
                    object5 = ((List)object62).getObjects().iterator();
                    while (object5.hasNext()) {
                        object4 = (GenericObject)object5.next();
                        if (!(object4 instanceof Disadvantage)) continue;
                        hashtable4.put(((GenericObject)object4).getXMLID(), genericObject);
                    }
                }
                Element element6 = element.getChild("CHARACTERISTICS");
                if (element6 != null) {
                    for (Object object62 : this.characteristics) {
                        object5 = element6.getChild(((GenericObject)object62).getXMLID());
                        if (object5 == null) continue;
                        ((GenericObject)object62).restoreFromSave((Element)object5);
                        ((GenericObject)object62).setPower(false);
                    }
                }
                if ((element5 = element.getChild("SKILLS")) != null) {
                    object62 = element5.getChildren("LIST");
                    object5 = object62.iterator();
                    while (object5.hasNext()) {
                        object4 = (Element)object5.next();
                        List list = new List((Element)object4);
                        list.restoreFromSave((Element)object4);
                        this.addSkill(list);
                    }
                    for (GenericObject genericObject : HeroDesigner.getActiveTemplate().getSkillEnhancers()) {
                        Element element7 = element5.getChild(genericObject.getXMLID());
                        if (element7 == null) continue;
                        GenericObject genericObject6 = genericObject.clone();
                        genericObject6.restoreFromSave(element7);
                        this.addSkill(genericObject6);
                    }
                    object4 = element5.getChildren("SKILL");
                    object5 = object4.iterator();
                    while (object5.hasNext()) {
                        String string;
                        Element element8 = (Element)object5.next();
                        if (element8 == null || (object32 = (GenericObject)((Hashtable)object18).get(string = XMLUtility.getValue(element8, "XMLID"))) == null) continue;
                        object32 = ((GenericObject)object32).clone();
                        ((GenericObject)object32).restoreFromSave(element8);
                        this.addSkill((GenericObject)object32);
                    }
                    Collections.sort(this.skills, new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (object instanceof GenericObject && object2 instanceof GenericObject) {
                                GenericObject genericObject = (GenericObject)object;
                                GenericObject genericObject2 = (GenericObject)object2;
                                return genericObject.getPosition() - genericObject2.getPosition();
                            }
                            return object.toString().compareTo(object2.toString());
                        }

                        @Override
                        public boolean equals(Object object) {
                            return false;
                        }
                    });
                }
                if ((object62 = element.getChild("PERKS")) != null) {
                    object5 = ((Element)object62).getChildren("LIST");
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        Element element9 = (Element)object4.next();
                        List list = new List(element9);
                        list.restoreFromSave(element9);
                        this.addPerk(list);
                    }
                    for (GenericObject genericObject : HeroDesigner.getActiveTemplate().getSkillEnhancers()) {
                        object32 = ((Element)object62).getChild(genericObject.getXMLID());
                        if (object32 == null) continue;
                        GenericObject genericObject7 = genericObject.clone();
                        genericObject7.restoreFromSave((Element)object32);
                        this.addPerk(genericObject7);
                    }
                    java.util.List list = ((Element)object62).getChildren("PERK");
                    object4 = list.iterator();
                    while (object4.hasNext()) {
                        Element element10 = (Element)object4.next();
                        if (element10 == null || (object22 = (GenericObject)((Hashtable)object17).get(object32 = XMLUtility.getValue(element10, "XMLID"))) == null) continue;
                        object22 = ((GenericObject)object22).clone();
                        ((GenericObject)object22).restoreFromSave(element10);
                        this.addPerk((GenericObject)object22);
                    }
                    Collections.sort(this.perks, new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (object instanceof GenericObject && object2 instanceof GenericObject) {
                                GenericObject genericObject = (GenericObject)object;
                                GenericObject genericObject2 = (GenericObject)object2;
                                return genericObject.getPosition() - genericObject2.getPosition();
                            }
                            return object.toString().compareTo(object2.toString());
                        }

                        @Override
                        public boolean equals(Object object) {
                            return false;
                        }
                    });
                }
                if ((object5 = element.getChild("TALENTS")) != null) {
                    object4 = ((Element)object5).getChildren("LIST");
                    Iterator iterator2 = object4.iterator();
                    while (iterator2.hasNext()) {
                        Element element11 = (Element)iterator2.next();
                        object32 = new List(element11);
                        ((List)object32).restoreFromSave(element11);
                        this.addTalent((GenericObject)object32);
                    }
                    java.util.List list = ((Element)object5).getChildren("TALENT");
                    for (Object object32 : list) {
                        GenericObject genericObject;
                        if (object32 == null || hashtable.get(object22 = XMLUtility.getValue(object32, "XMLID")) == null || (genericObject = (GenericObject)hashtable.get(object22)) == null) continue;
                        GenericObject genericObject8 = genericObject.clone();
                        genericObject8.restoreFromSave((Element)object32);
                        this.addTalent(genericObject8);
                    }
                    Collections.sort(this.talents, new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (object instanceof GenericObject && object2 instanceof GenericObject) {
                                GenericObject genericObject = (GenericObject)object;
                                GenericObject genericObject2 = (GenericObject)object2;
                                return genericObject.getPosition() - genericObject2.getPosition();
                            }
                            return object.toString().compareTo(object2.toString());
                        }

                        @Override
                        public boolean equals(Object object) {
                            return false;
                        }
                    });
                }
                if ((object4 = element.getChild("MARTIALARTS")) != null) {
                    void var19_140;
                    java.util.List list = ((Element)object4).getChildren("LIST");
                    for (Object object32 : list) {
                        object22 = new List((Element)object32);
                        ((List)object22).restoreFromSave((Element)object32);
                        this.addManeuver((GenericObject)object22);
                    }
                    java.util.List list2 = ((Element)object4).getChildren("EXTRADC");
                    object32 = null;
                    for (GenericObject genericObject : HeroDesigner.getActiveTemplate().getMartialArts()) {
                        if (!genericObject.getXMLID().equals("EXTRADC")) continue;
                        object32 = genericObject;
                        break;
                    }
                    Iterator iterator3 = list2.iterator();
                    if (object32 != null) {
                        while (iterator3.hasNext()) {
                            object22 = (Element)iterator3.next();
                            GenericObject genericObject = ((GenericObject)object32).clone();
                            genericObject.restoreFromSave((Element)object22);
                            this.addManeuver(genericObject);
                        }
                    }
                    java.util.List list3 = ((Element)object4).getChildren("RANGEDDC");
                    object22 = null;
                    for (GenericObject genericObject : HeroDesigner.getActiveTemplate().getMartialArts()) {
                        if (!genericObject.getXMLID().equals("RANGEDDC")) continue;
                        object22 = genericObject;
                        break;
                    }
                    Iterator iterator4 = list3.iterator();
                    if (object22 != null) {
                        while (iterator4.hasNext()) {
                            Element element12 = (Element)iterator4.next();
                            GenericObject genericObject = ((GenericObject)object22).clone();
                            genericObject.restoreFromSave(element12);
                            this.addManeuver(genericObject);
                        }
                    }
                    Object var19_138 = null;
                    for (GenericObject genericObject : HeroDesigner.getActiveTemplate().getMartialArts()) {
                        if (!genericObject.getXMLID().equals("WEAPON_ELEMENT")) continue;
                        GenericObject genericObject9 = genericObject;
                        break;
                    }
                    java.util.List list4 = ((Element)object4).getChildren("WEAPON_ELEMENT");
                    Iterator iterator5 = list4.iterator();
                    if (var19_140 != null) {
                        while (iterator5.hasNext()) {
                            Element element13 = (Element)iterator5.next();
                            GenericObject genericObject = var19_140.clone();
                            genericObject.restoreFromSave(element13);
                            this.addManeuver(genericObject);
                        }
                    }
                    java.util.List list5 = ((Element)object4).getChildren("MANEUVER");
                    block41: for (Element element14 : list5) {
                        if (element14 == null) continue;
                        object = XMLUtility.getValue(element14, "DISPLAY");
                        for (GenericObject genericObject15 : template.getMartialArts()) {
                            if (genericObject15 instanceof Maneuver) {
                                if (!genericObject15.getDisplay().equals(object)) continue;
                                genericObject15 = genericObject15.clone();
                                genericObject15.restoreFromSave(element14);
                                this.addManeuver(genericObject15);
                                continue block41;
                            }
                            if (!(genericObject15 instanceof List)) continue;
                            List list6 = (List)genericObject15;
                            ArrayList<GenericObject> arrayList = list6.getObjects();
                            for (GenericObject genericObject10 : arrayList) {
                                if (!genericObject10.getDisplay().equals(object)) continue;
                                genericObject10 = genericObject10.clone();
                                genericObject10.restoreFromSave(element14);
                                this.addManeuver(genericObject10);
                                continue block41;
                            }
                        }
                        iterator = new Maneuver(element14);
                        ((Maneuver)((Object)iterator)).restoreFromSave(element14);
                        ((Maneuver)((Object)iterator)).setCustom(true);
                        this.addManeuver((GenericObject)((Object)iterator));
                    }
                    Collections.sort(this.maneuvers, new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (object instanceof GenericObject && object2 instanceof GenericObject) {
                                GenericObject genericObject = (GenericObject)object;
                                GenericObject genericObject2 = (GenericObject)object2;
                                return genericObject.getPosition() - genericObject2.getPosition();
                            }
                            return object.toString().compareTo(object2.toString());
                        }

                        @Override
                        public boolean equals(Object object) {
                            return false;
                        }
                    });
                }
                if ((element4 = element.getChild("POWERS")) != null) {
                    java.util.List list = element4.getChildren("LIST");
                    for (Object object22 : list) {
                        List list7 = new List((Element)object22);
                        list7.restoreFromSave((Element)object22);
                        this.addPower(list7);
                    }
                    java.util.List list8 = element4.getChildren("MULTIPOWER");
                    for (Object object22 : list8) {
                        Multipower multipower = new Multipower((Element)object22);
                        multipower.restoreFromSave((Element)object22);
                        this.addPower(multipower);
                    }
                    java.util.List list9 = element4.getChildren("ELEMENTAL_CONTROL");
                    for (Object object22 : list9) {
                        ElementalControl elementalControl = new ElementalControl((Element)object22);
                        elementalControl.restoreFromSave((Element)object22);
                        this.addPower(elementalControl);
                    }
                    java.util.List list10 = element4.getChildren("VPP");
                    for (Object object22 : list10) {
                        VariablePowerPool variablePowerPool = new VariablePowerPool((Element)object22);
                        variablePowerPool.restoreFromSave((Element)object22);
                        this.addPower(variablePowerPool);
                    }
                    object22 = element4.getChildren("POWER");
                    object32 = object22.iterator();
                    while (object32.hasNext()) {
                        String string;
                        GenericObject genericObject;
                        Element element15 = (Element)object32.next();
                        if (element15 == null || (genericObject = (GenericObject)hashtable3.get(string = XMLUtility.getValue(element15, "XMLID"))) == null) continue;
                        GenericObject genericObject11 = genericObject.clone();
                        genericObject11.restoreFromSave(element15);
                        this.addPower(genericObject11);
                    }
                    object22 = element4.getChildren("SKILL");
                    object32 = object22.iterator();
                    while (object32.hasNext()) {
                        String string;
                        GenericObject genericObject;
                        Element element16 = (Element)object32.next();
                        if (element16 == null || (genericObject = (GenericObject)((Hashtable)object18).get(string = XMLUtility.getValue(element16, "XMLID"))) == null) continue;
                        GenericObject genericObject12 = genericObject.clone();
                        genericObject12.restoreFromSave(element16);
                        this.addPower(genericObject12);
                    }
                    object22 = element4.getChildren("PERK");
                    object32 = object22.iterator();
                    while (object32.hasNext()) {
                        String string;
                        GenericObject genericObject;
                        Element element17 = (Element)object32.next();
                        if (element17 == null || (genericObject = (GenericObject)((Hashtable)object17).get(string = XMLUtility.getValue(element17, "XMLID"))) == null) continue;
                        GenericObject genericObject13 = genericObject.clone();
                        genericObject13.restoreFromSave(element17);
                        this.addPower(genericObject13);
                    }
                    object22 = element4.getChildren("TALENT");
                    object32 = object22.iterator();
                    while (object32.hasNext()) {
                        String string;
                        GenericObject genericObject;
                        Element element18 = (Element)object32.next();
                        if (element18 == null || (genericObject = (GenericObject)hashtable.get(string = XMLUtility.getValue(element18, "XMLID"))) == null) continue;
                        GenericObject genericObject14 = genericObject.clone();
                        genericObject14.restoreFromSave(element18);
                        this.addPower(genericObject14);
                    }
                    for (GenericObject genericObject : this.characteristics) {
                        object22 = element4.getChildren(genericObject.getXMLID());
                        object32 = object22.iterator();
                        block53: while (object32.hasNext()) {
                            Element element19 = (Element)object32.next();
                            if (element19 == null) continue;
                            object = genericObject.getXMLID();
                            for (GenericObject genericObject15 : this.characteristics) {
                                if (!genericObject15.getXMLID().equals(object)) continue;
                                genericObject15 = genericObject15.clone();
                                genericObject15.restoreFromSave(element19);
                                genericObject15.setPower(true);
                                this.addPower(genericObject15);
                                continue block53;
                            }
                        }
                    }
                    Collections.sort(this.powers, new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (object instanceof GenericObject && object2 instanceof GenericObject) {
                                GenericObject genericObject = (GenericObject)object;
                                GenericObject genericObject2 = (GenericObject)object2;
                                return genericObject.getPosition() - genericObject2.getPosition();
                            }
                            return object.toString().compareTo(object2.toString());
                        }

                        @Override
                        public boolean equals(Object object) {
                            return false;
                        }
                    });
                }
                if ((element3 = element.getChild("EQUIPMENT")) != null) {
                    java.util.List list = element3.getChildren("LIST");
                    for (Object object22 : list) {
                        List list11 = new List((Element)object22);
                        list11.restoreFromSave((Element)object22);
                        this.addEquipment(list11);
                    }
                    java.util.List list12 = element3.getChildren("MULTIPOWER");
                    for (Object object22 : list12) {
                        Multipower multipower = new Multipower((Element)object22);
                        multipower.restoreFromSave((Element)object22);
                        this.addEquipment(multipower);
                    }
                    java.util.List list13 = element3.getChildren("ELEMENTAL_CONTROL");
                    for (Object object22 : list13) {
                        ElementalControl elementalControl = new ElementalControl((Element)object22);
                        elementalControl.restoreFromSave((Element)object22);
                        this.addEquipment(elementalControl);
                    }
                    java.util.List list14 = element3.getChildren("VPP");
                    for (Object object22 : list14) {
                        VariablePowerPool variablePowerPool = new VariablePowerPool((Element)object22);
                        variablePowerPool.restoreFromSave((Element)object22);
                        this.addEquipment(variablePowerPool);
                    }
                    object22 = element3.getChildren("POWER");
                    object32 = object22.iterator();
                    while (object32.hasNext()) {
                        String string;
                        GenericObject genericObject;
                        Element element20 = (Element)object32.next();
                        if (element20 == null || (genericObject = (GenericObject)hashtable3.get(string = XMLUtility.getValue(element20, "XMLID"))) == null) continue;
                        GenericObject genericObject16 = genericObject.clone();
                        genericObject16.restoreFromSave(element20);
                        this.addEquipment(genericObject16);
                    }
                    object22 = element3.getChildren("SKILL");
                    object32 = object22.iterator();
                    while (object32.hasNext()) {
                        String string;
                        GenericObject genericObject;
                        Element element21 = (Element)object32.next();
                        if (element21 == null || (genericObject = (GenericObject)((Hashtable)object18).get(string = XMLUtility.getValue(element21, "XMLID"))) == null) continue;
                        GenericObject genericObject17 = genericObject.clone();
                        genericObject17.restoreFromSave(element21);
                        this.addEquipment(genericObject17);
                    }
                    object22 = element3.getChildren("PERK");
                    object32 = object22.iterator();
                    while (object32.hasNext()) {
                        String string;
                        GenericObject genericObject;
                        Element element23 = (Element)object32.next();
                        if (element23 == null || (genericObject = (GenericObject)((Hashtable)object17).get(string = XMLUtility.getValue(element23, "XMLID"))) == null) continue;
                        GenericObject genericObject18 = genericObject.clone();
                        genericObject18.restoreFromSave(element23);
                        this.addEquipment(genericObject18);
                    }
                    object22 = element3.getChildren("TALENT");
                    object32 = object22.iterator();
                    while (object32.hasNext()) {
                        String string;
                        GenericObject genericObject;
                        Element element24 = (Element)object32.next();
                        if (element24 == null || (genericObject = (GenericObject)hashtable.get(string = XMLUtility.getValue(element24, "XMLID"))) == null) continue;
                        GenericObject genericObject19 = genericObject.clone();
                        genericObject19.restoreFromSave(element24);
                        this.addEquipment(genericObject19);
                    }
                    for (GenericObject genericObject : this.characteristics) {
                        object22 = element3.getChildren(genericObject.getXMLID());
                        object32 = object22.iterator();
                        block64: while (object32.hasNext()) {
                            Element element25 = (Element)object32.next();
                            if (element25 == null) continue;
                            object = genericObject.getXMLID();
                            for (GenericObject genericObject15 : this.characteristics) {
                                if (!genericObject15.getXMLID().equals(object)) continue;
                                genericObject15 = genericObject15.clone();
                                genericObject15.restoreFromSave(element25);
                                genericObject15.setPower(true);
                                this.addEquipment(genericObject15);
                                continue block64;
                            }
                        }
                    }
                    Collections.sort(this.equipment, new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (object instanceof GenericObject && object2 instanceof GenericObject) {
                                GenericObject genericObject = (GenericObject)object;
                                GenericObject genericObject2 = (GenericObject)object2;
                                return genericObject.getPosition() - genericObject2.getPosition();
                            }
                            return object.toString().compareTo(object2.toString());
                        }

                        @Override
                        public boolean equals(Object object) {
                            return false;
                        }
                    });
                }
                if ((element2 = element.getChild("DISADVANTAGES")) != null) {
                    object32 = element2.getChildren("LIST");
                    object22 = object32.iterator();
                    while (object22.hasNext()) {
                        Element element26 = (Element)object22.next();
                        List list = new List(element26);
                        list.restoreFromSave(element26);
                        this.addDisad(list);
                    }
                    java.util.List list = element2.getChildren("DISAD");
                    for (Element element27 : list) {
                        String string;
                        if (element27 == null || (object = (GenericObject)hashtable4.get(string = XMLUtility.getValue(element27, "XMLID"))) == null) continue;
                        object = ((GenericObject)object).clone();
                        ((GenericObject)object).restoreFromSave(element27);
                        this.addDisad((GenericObject)object);
                    }
                    java.util.List list15 = element2.getChildren("ADDER");
                    for (Element element28 : list15) {
                        if (element28 == null || (object = XMLUtility.getValue(element28, "XMLID")) == null) continue;
                        iterator = new Adder(element28);
                        ((Adder)((Object)iterator)).restoreFromSave(element28);
                        if (((GenericObject)((Object)iterator)).getXMLID().equals("NCM")) {
                            this.ncmPosition = ((GenericObject)((Object)iterator)).getPosition();
                            this.ncmParentID = ((GenericObject)((Object)iterator)).getParentID();
                            continue;
                        }
                        this.agePosition = ((GenericObject)((Object)iterator)).getPosition();
                        this.ageParentID = ((GenericObject)((Object)iterator)).getParentID();
                    }
                    if (this.isNCMSelected()) {
                        this.disads.add(this.getNCMObject());
                        if (this.getAgeObject() != null) {
                            this.getDisads().add(this.getAgeObject());
                        }
                    }
                    Collections.sort(this.disads, new Comparator(){

                        public int compare(Object object, Object object2) {
                            if (object instanceof GenericObject && object2 instanceof GenericObject) {
                                GenericObject genericObject = (GenericObject)object;
                                GenericObject genericObject2 = (GenericObject)object2;
                                return genericObject.getPosition() - genericObject2.getPosition();
                            }
                            return object.toString().compareTo(object2.toString());
                        }

                        @Override
                        public boolean equals(Object object) {
                            return false;
                        }
                    });
                }
                object32 = element.getChildren("PREFAB");
                this.prefabs = new ArrayList();
                if (object32 != null && object32.size() > 0) {
                    for (int i = 0; i < object32.size(); ++i) {
                        Prefab prefab = new Prefab((Element)object32.get(i));
                        this.prefabs.add(prefab);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (HeroDesigner.headless) break block131;
                JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading the character.\nData loss may occur if you save.\n\nPlease shut down Hero Designer and restart.\n\nError Message: " + exception.getMessage(), "Error loading character", 0);
            }
        }
        HeroDesigner.lastEdit = System.currentTimeMillis();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public boolean isNCMSelected() {
        if (this.ncmObject == null) {
            return false;
        }
        return this.ncmSelected;
    }

    public boolean isPrefab() {
        return false;
    }

    boolean ncmHasAge() {
        if (this.ncmObject.getOptions().size() == 0) {
            return false;
        }
        boolean bl = false;
        for (Adder adder : this.ncmObject.getOptions()) {
            if (!adder.getXMLID().equals(this.ncmObject.getXMLID())) continue;
            bl = true;
        }
        return bl;
    }

    public void resetTemplate() {
        if (HeroDesigner.getActiveTemplate() == null) {
            return;
        }
        String string = this.templatePath;
        this.templatePath = HeroDesigner.getActiveTemplate().getId();
        this.initFromSave();
    }

    public void setAlternateIdentities(String string) {
        if (this.alternateIdentities.equals(string)) {
            return;
        }
        this.alternateIdentities = string;
        this.setDirty(true);
    }

    public void setAppearance(String string) {
        if (this.appearance.equals(string)) {
            return;
        }
        this.appearance = string;
        this.setDirty(true);
    }

    public void setBackground(String string) {
        if (this.background.equals(string)) {
            return;
        }
        this.background = string;
        this.setDirty(true);
    }

    public void setBasePoints(int n) {
        if (this.basePoints == n) {
            return;
        }
        this.basePoints = n;
        this.setDirty(true);
    }

    public void setCampaignName(String string) {
        if (this.campaignName.equals(string)) {
            return;
        }
        this.campaignName = string;
        this.setDirty(true);
    }

    public void setCampaignUse(String string) {
        if (this.campaignUse.equals(string)) {
            return;
        }
        this.campaignUse = string;
        this.setDirty(true);
    }

    public void setCharacterName(String string) {
        if (this.characterName.equals(string)) {
            return;
        }
        this.characterName = string;
        HeroDesigner.getInstance().setActiveName(string);
        HeroDesigner.getInstance().updateStatus();
        this.setDirty(true);
    }

    public void setDirty(boolean bl) {
        if (bl) {
            this.lastEdit = System.currentTimeMillis();
            HeroDesigner.getInstance().setDirty(bl);
        }
        if (this.dirty == bl) {
            return;
        }
        this.dirty = bl;
        HeroDesigner.getInstance().setDirty(this.dirty);
    }

    public void setDisadPoints(int n) {
        if (this.disadPoints == n) {
            return;
        }
        this.disadPoints = n;
        this.setDirty(true);
    }

    protected void setDisads(ArrayList<GenericObject> arrayList) {
        this.disads = arrayList;
    }

    protected void setEquipment(ArrayList<GenericObject> arrayList) {
        this.equipment = arrayList;
    }

    public void setExperience(int n) {
        if (this.experience == n) {
            return;
        }
        this.experience = n;
        this.setDirty(true);
    }

    public void setExportTemplate(String string) {
        File file;
        if (this.exportTemplate != null && string != null) {
            if (this.exportTemplate.equals(string)) {
                this.setDirty(true);
            }
        } else {
            this.setDirty(true);
        }
        this.exportTemplate = string != null ? ((file = new File(string)).exists() ? string : null) : null;
    }

    public void setEyeColor(String string) {
        if (this.eyeColor.equals(string)) {
            return;
        }
        this.eyeColor = string;
        this.setDirty(true);
    }

    public void setGenre(String string) {
        if (this.genre.equals(string)) {
            return;
        }
        this.genre = string;
        this.setDirty(true);
    }

    public void setGm(String string) {
        if (this.gm.equals(string)) {
            return;
        }
        this.gm = string;
        this.setDirty(true);
    }

    public void setHairColor(String string) {
        if (this.hairColor.equals(string)) {
            return;
        }
        this.hairColor = string;
        this.setDirty(true);
    }

    public void setHeight(int n) {
        double d = n;
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            d = (double)n / 2.54;
        }
        if (this.height == d) {
            return;
        }
        this.height = d;
        this.setDirty(true);
    }

    public void setImageData(byte[] byArray, File file) {
        this.imageData = byArray;
        if (file == null) {
            this.imageFileName = "";
            this.imageFilePath = "";
        } else {
            this.imageFileName = file.getName();
            this.imageFilePath = file.getAbsolutePath();
        }
        this.setDirty(true);
    }

    public void setLastTabIndex(int n) {
        this.lastTab = n;
    }

    protected void setManeuvers(ArrayList<GenericObject> arrayList) {
        this.maneuvers = arrayList;
    }

    public void setNCMSelected(boolean bl) {
        this.ncmSelected = bl;
    }

    public void setNotes1(String string) {
        if (this.getNotes1().equals(string)) {
            return;
        }
        this.notes1 = string;
        this.setDirty(true);
    }

    public void setNotes2(String string) {
        if (this.getNotes2().equals(string)) {
            return;
        }
        this.notes2 = string;
        this.setDirty(true);
    }

    public void setNotes3(String string) {
        if (this.getNotes3().equals(string)) {
            return;
        }
        this.notes3 = string;
        this.setDirty(true);
    }

    public void setNotes4(String string) {
        if (this.getNotes4().equals(string)) {
            return;
        }
        this.notes4 = string;
        this.setDirty(true);
    }

    public void setNotes5(String string) {
        if (this.getNotes5().equals(string)) {
            return;
        }
        this.notes5 = string;
        this.setDirty(true);
    }

    protected void setPerks(ArrayList<GenericObject> arrayList) {
        this.perks = arrayList;
    }

    public void setPersonality(String string) {
        if (this.personality.equals(string)) {
            return;
        }
        this.personality = string;
        this.setDirty(true);
    }

    public void setPlayerName(String string) {
        if (this.playerName.equals(string)) {
            return;
        }
        this.playerName = string;
        this.setDirty(true);
    }

    protected void setPowers(ArrayList<GenericObject> arrayList) {
        this.powers = arrayList;
    }

    public void setQuote(String string) {
        if (this.quote.equals(string)) {
            return;
        }
        this.quote = string;
        this.setDirty(true);
    }

    public void setSaveFile(File file) {
        this.saveFile = file;
        this.openFile = file;
    }

    protected void setSkills(ArrayList<GenericObject> arrayList) {
        this.skills = arrayList;
    }

    public void setTactics(String string) {
        if (this.tactics.equals(string)) {
            return;
        }
        this.tactics = string;
        this.setDirty(true);
    }

    protected void setTalents(ArrayList<GenericObject> arrayList) {
        this.talents = arrayList;
    }

    public void setTemplatePath(String string) {
        this.templatePath = string;
    }

    public void setWeight(int n) {
        double d = n;
        if (HeroDesigner.getInstance().getPrefs().isMetric()) {
            d = (double)n * 1000.0 / 453.5924;
        }
        if (this.weight == d) {
            return;
        }
        this.weight = d;
        this.setDirty(true);
    }

    public boolean hasFileAssociations() {
        File file;
        GenericObject genericObject;
        int n;
        boolean bl = false;
        for (n = 0; n < this.getPerks().size(); ++n) {
            if (!(this.getPerks().get(n) instanceof Follower ? ((Follower)(genericObject = (Follower)this.getPerks().get(n))).getFilePath() != null && ((Follower)genericObject).getFilePath().trim().length() > 0 && (file = new File(((Follower)genericObject).getFilePath())).exists() : this.getPerks().get(n) instanceof Vehicle && ((Vehicle)(genericObject = (Vehicle)this.getPerks().get(n))).getFilePath() != null && ((Vehicle)genericObject).getFilePath().trim().length() > 0 && (file = new File(((Vehicle)genericObject).getFilePath())).exists())) continue;
            return true;
        }
        for (n = 0; n < this.getPowers().size(); ++n) {
            if (!(this.getPowers().get(n) instanceof Duplication ? ((Duplication)(genericObject = (Duplication)this.getPowers().get(n))).getFilePath() != null && ((Duplication)genericObject).getFilePath().trim().length() > 0 && (file = new File(((Duplication)genericObject).getFilePath())).exists() : (this.getPowers().get(n) instanceof Multiform ? ((Multiform)(genericObject = (Multiform)this.getPowers().get(n))).getFilePath() != null && ((Multiform)genericObject).getFilePath().trim().length() > 0 && (file = new File(((Multiform)genericObject).getFilePath())).exists() : this.getPowers().get(n) instanceof Summon && ((Summon)(genericObject = (Summon)this.getPowers().get(n))).getFilePath() != null && ((Summon)genericObject).getFilePath().trim().length() > 0 && (file = new File(((Summon)genericObject).getFilePath())).exists()))) continue;
            return true;
        }
        return bl;
    }

    public ArrayList<File> getFileAssociations() {
        File file;
        GenericObject genericObject;
        int n;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (n = 0; n < this.getPerks().size(); ++n) {
            if (this.getPerks().get(n) instanceof Follower) {
                genericObject = (Follower)this.getPerks().get(n);
                if (((Follower)genericObject).getFilePath() == null || ((Follower)genericObject).getFilePath().trim().length() <= 0 || !(file = new File(((Follower)genericObject).getFilePath())).exists()) continue;
                arrayList.add(file);
                continue;
            }
            if (!(this.getPerks().get(n) instanceof Vehicle) || ((Vehicle)(genericObject = (Vehicle)this.getPerks().get(n))).getFilePath() == null || ((Vehicle)genericObject).getFilePath().trim().length() <= 0 || !(file = new File(((Vehicle)genericObject).getFilePath())).exists()) continue;
            arrayList.add(file);
        }
        for (n = 0; n < this.getPowers().size(); ++n) {
            if (this.getPowers().get(n) instanceof Duplication) {
                genericObject = (Duplication)this.getPowers().get(n);
                if (((Duplication)genericObject).getFilePath() == null || ((Duplication)genericObject).getFilePath().trim().length() <= 0 || !(file = new File(((Duplication)genericObject).getFilePath())).exists()) continue;
                arrayList.add(file);
                continue;
            }
            if (this.getPowers().get(n) instanceof Multiform) {
                genericObject = (Multiform)this.getPowers().get(n);
                if (((Multiform)genericObject).getFilePath() == null || ((Multiform)genericObject).getFilePath().trim().length() <= 0 || !(file = new File(((Multiform)genericObject).getFilePath())).exists()) continue;
                arrayList.add(file);
                continue;
            }
            if (!(this.getPowers().get(n) instanceof Summon) || ((Summon)(genericObject = (Summon)this.getPowers().get(n))).getFilePath() == null || ((Summon)genericObject).getFilePath().trim().length() <= 0 || !(file = new File(((Summon)genericObject).getFilePath())).exists()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }
}

