/*
 * Decompiled with CFR 0.152.
 */
package com.hero;

import com.hero.Hero;
import com.hero.HeroDesigner;
import com.hero.Prefab;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;
import com.hero.ui.dialog.AvailableModifiersDialog;
import com.hero.util.XMLUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AppPrefs {
    public static final int NEVER = 3;
    public static final int ALWAYS = 1;
    public static final int PROMPT = 2;
    private int state = 0;
    private int sizeX = 800;
    private int sizeY = 550;
    private int screenX = 0;
    private int screenY = 0;
    private String saveDir = "";
    private String exportDir = "";
    private String imageDir = "";
    private String templateDir = "";
    private String defaultExportDir = "";
    private String defaultRulesDir = "";
    private String prefabDir = "";
    private String rulesDir = "";
    private String lastRule = "";
    private int maxMemory = 128;
    private boolean loadCharacters = true;
    private boolean loadPrefabs = true;
    private boolean restoreWindow = true;
    private boolean rememberDialogPosition = true;
    private int dialogX = 800;
    private int dialogY = 550;
    private int dialogScreenX = 0;
    private int dialogScreenY = 0;
    private int modX = 0;
    private int modY = 0;
    private int modScreenX = 0;
    private int modScreenY = 0;
    private int numberDigitsForRounding = 1;
    private String exportTemplateDir = "ExportTemplates";
    private boolean modifierIntelligenceOn = true;
    private boolean checkDuringEdit = true;
    private boolean removeIllegalMods = true;
    private boolean metric = true;
    private boolean displayActivePoints = true;
    private boolean useAbbreviations = false;
    private boolean useWG = true;
    private boolean useQuickAssign = true;
    private boolean confirmDelete = true;
    private boolean warnOnMultiple = true;
    private boolean showCommonLimitations = true;
    private ArrayList<String> recentFiles = new ArrayList();
    private int tabPosition = 1;
    private Hashtable<String, Integer[]> tearOffPrefs = new Hashtable();
    private ArrayList<String> sources;
    private int refreshTemplateOnRestore = 2;
    private int refreshRulesOnRestore = 2;
    private boolean showPopupDefinitions = false;
    private boolean showEquipmentPrefabsOnPowers = true;
    private boolean showPowersPrefabsOnEquipment = true;
    private boolean promptToExportImage = false;
    private String browserExecutablePath = null;
    private String defaultAIFormatPath = null;
    private String defaultAutomatonFormatPath = null;
    private String defaultBaseFormatPath = null;
    private String defaultComputerFormatPath = null;
    private String defaultHeroicFormatPath = null;
    private String defaultNormalFormatPath = null;
    private String defaultSuperheroicFormatPath = null;
    private String defaultVehicleFormatPath = null;
    private int minimumHeapSize = 32;
    private int maximumHeapSize = 64;
    private boolean flagForcedModifiers = true;
    public static final int ADD_MOST_EXPENSIVE = 1;
    public static final int ADD_LEAST_EXPENSIVE = 2;
    public static final int ADD_MOST_LEVELS = 3;
    public static final int ADD_LEAST_LEVELS = 4;
    public static final int ADD_BOTH = 5;
    public static final int ADD_PACKAGE_DEAL = 6;
    public static final int ADD_EXISTING = 7;
    private boolean sourcesLocked = false;

    public void setBrowserExecutablePath(String string) {
        this.browserExecutablePath = string;
    }

    public String getBrowserExecutablePath() {
        return this.browserExecutablePath;
    }

    public boolean getPromptToExportImage() {
        return this.promptToExportImage;
    }

    public void setPromptToExportImage(boolean bl) {
        this.promptToExportImage = bl;
    }

    public boolean flagForcedModifiers() {
        return this.flagForcedModifiers;
    }

    public void setFlagForcedModifiers(boolean bl) {
        this.flagForcedModifiers = bl;
    }

    public boolean getShowEquipmentPrefabsOnPowers() {
        return this.showEquipmentPrefabsOnPowers;
    }

    public void setShowEquipmentPrefabsOnPowers(boolean bl) {
        this.showEquipmentPrefabsOnPowers = bl;
    }

    public boolean getShowPowersPrefabsOnEquipment() {
        return this.showPowersPrefabsOnEquipment;
    }

    public void setShowPowersPrefabsOnEquipment(boolean bl) {
        this.showPowersPrefabsOnEquipment = bl;
    }

    public int getPackageDealConflictResolution() {
        return 5;
    }

    public boolean showPopupDefinitions() {
        return this.showPopupDefinitions;
    }

    public void setShowPopupDefinitions(boolean bl) {
        this.showPopupDefinitions = bl;
    }

    public ArrayList<String> getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        if (this.sources.size() == 0 && !this.sourcesLocked) {
            ArrayList arrayList = (ArrayList)GenericObject.getAllSources().clone();
            if (arrayList.contains("Sidekick") && arrayList.contains("Hero System Fifth Edition Rule Book")) {
                arrayList.remove("Sidekick");
            }
            return arrayList;
        }
        if (this.sources.contains("Sidekick") && this.sources.contains("Hero System Fifth Edition Rule Book")) {
            this.sources.remove("Sidekick");
        }
        return this.sources;
    }

    public void setSources(ArrayList<String> arrayList) {
        this.sources = arrayList;
        this.sourcesLocked = true;
    }

    public Hashtable<String, Integer[]> getTearOffPrefs() {
        return this.tearOffPrefs;
    }

    public int getTabPosition() {
        return this.tabPosition;
    }

    public void setTabPosition(int n) {
        HeroDesigner.getInstance().mainPanel.setTabPlacement(n);
        this.tabPosition = n;
    }

    public void addRecentFile(File file) {
        if (this.recentFiles == null) {
            this.recentFiles = new ArrayList();
        }
        if (this.recentFiles.contains(file.getAbsolutePath())) {
            this.recentFiles.remove(file.getAbsolutePath());
        }
        while (this.recentFiles.size() >= 10) {
            this.recentFiles.remove(9);
        }
        this.recentFiles.add(0, file.getAbsolutePath());
        HeroDesigner.getInstance().updateRecentMenu();
    }

    public ArrayList<String> getRecentFileList() {
        return this.recentFiles;
    }

    public String adjustTitle(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            string2 = string2 + "" + c;
        }
        return string2;
    }

    protected void finishRestorePrefs() {
        try {
            Object object;
            Object object2;
            Iterator iterator;
            File file = new File("appPrefs.xml");
            if (!file.exists()) {
                return;
            }
            SAXBuilder sAXBuilder = new SAXBuilder(false);
            Document document = sAXBuilder.build(file);
            sAXBuilder = null;
            Element element = document.getRootElement();
            String string = null;
            Enumeration<JScrollPane> enumeration = HeroDesigner.getInstance().mainPanel.components.keys();
            while (enumeration.hasMoreElements()) {
                JScrollPane jScrollPane = enumeration.nextElement();
                iterator = HeroDesigner.getInstance().mainPanel.components.get(jScrollPane).toString();
                object2 = this.adjustTitle((String)((Object)iterator));
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                string = XMLUtility.getValue(element, (String)object2 + "WIDTH");
                if (string != null && string.trim().length() > 0) {
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if ((string = XMLUtility.getValue(element, (String)object2 + "HEIGHT")) != null && string.trim().length() > 0) {
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if ((string = XMLUtility.getValue(element, (String)object2 + "X")) != null && string.trim().length() > 0) {
                    try {
                        n3 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if ((string = XMLUtility.getValue(element, (String)object2 + "Y")) != null && string.trim().length() > 0) {
                    try {
                        n4 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if ((string = XMLUtility.getValue(element, (String)object2 + "TORN")) != null && string.trim().length() > 0) {
                    try {
                        n5 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (n <= 0 || n2 <= 0) continue;
                object = new Integer[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5)};
                this.tearOffPrefs.put((String)((Object)iterator), (Integer[])object);
            }
            HeroDesigner.getInstance().mainPanel.setStates();
            string = XMLUtility.getValue(element, "LOAD_CHARS");
            if (string != null && string.trim().toUpperCase().startsWith("N")) {
                this.loadCharacters = false;
            }
            if ((string = XMLUtility.getValue(element, "SHOW_EQUIPMENT_PREFABS_ON_POWERS")) != null && string.trim().toUpperCase().startsWith("F")) {
                this.showEquipmentPrefabsOnPowers = false;
            }
            if ((string = XMLUtility.getValue(element, "SHOW_POWERS_PREFABS_ON_EQUIPMENT")) != null && string.trim().toUpperCase().startsWith("F")) {
                this.showPowersPrefabsOnEquipment = false;
            }
            if ((string = XMLUtility.getValue(element, "SHOW_POPUP_DEFINITIONS")) != null && string.trim().toUpperCase().startsWith("T")) {
                this.showPopupDefinitions = true;
            }
            if ((string = XMLUtility.getValue(element, "TAB_POSITION")) != null) {
                try {
                    int n = Integer.parseInt(string);
                    if (n > 0 && n < 5) {
                        HeroDesigner.getInstance().mainPanel.setTabPlacement(n);
                        this.tabPosition = n;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element, "LOAD_PREFABS")) != null && string.trim().toUpperCase().startsWith("N")) {
                this.loadPrefabs = false;
            }
            if ((string = XMLUtility.getValue(element, "SKILLSLIDER")) != null && string.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    HeroDesigner.getInstance().mainPanel.skillsPanel.mainSplit.setDividerLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element, "PERKSLIDER")) != null && string.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    HeroDesigner.getInstance().mainPanel.perksPanel.mainSplit.setDividerLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element, "TALENTSLIDER")) != null && string.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    HeroDesigner.getInstance().mainPanel.talentsPanel.mainSplit.setDividerLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element, "MARTIALARTSLIDER")) != null && string.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    HeroDesigner.getInstance().mainPanel.maneuversPanel.mainSplit.setDividerLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element, "POWERSLIDER")) != null && string.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    HeroDesigner.getInstance().mainPanel.powersPanel.mainSplit.setDividerLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element, "DISADSLIDER")) != null && string.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    HeroDesigner.getInstance().mainPanel.disadsPanel.mainSplit.setDividerLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element, "EQUIPMENTSLIDER")) != null && string.trim().length() > 0) {
                try {
                    int n = Integer.parseInt(string);
                    HeroDesigner.getInstance().mainPanel.equipmentPanel.mainSplit.setDividerLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.loadCharacters) {
                List list = element.getChildren("CHARACTER");
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    File file2;
                    if (!HeroDesigner.headless) {
                        HeroDesigner.loadProgress.setString("Loading characters....");
                    }
                    if (!(file2 = new File(string2 = XMLUtility.getValue((Element)(object2 = (Element)iterator.next()), "FILE_LOC"))).exists() || string2 == null || string2.trim().length() <= 0) continue;
                    HeroDesigner.getInstance().openHero(new File(string2), true);
                }
            }
            HeroDesigner.getInstance();
            if (HeroDesigner.getActiveTemplate() == null) {
                HeroDesigner.getInstance().setTemplate("Superheroic.hdt", true, false, true);
            }
            if (this.loadPrefabs) {
                List list = element.getChildren("PREFAB");
                iterator = list.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    Element element2;
                    String string3;
                    File file3;
                    if (!HeroDesigner.headless) {
                        HeroDesigner.loadProgress.setString("Loading prefabs....");
                    }
                    if (!(file3 = new File(string3 = XMLUtility.getValue(element2 = (Element)iterator.next(), "FILE_LOC"))).exists() || string3 == null || string3.trim().length() <= 0) continue;
                    try {
                        Prefab prefab = null;
                        if (!string3.toUpperCase().endsWith(".HDP")) continue;
                        prefab = new Prefab(file3, true);
                        HeroDesigner.getInstance().loadedPrefabs.add(prefab);
                        String string4 = prefab.getName().trim().length() == 0 ? "[unknown]" : prefab.getName();
                        object = new JMenuItem(string4);
                        HeroDesigner heroDesigner = HeroDesigner.getInstance();
                        Objects.requireNonNull(heroDesigner);
                        ((AbstractButton)object).addActionListener(new HeroDesigner.PrefabActionListener(heroDesigner, prefab, (JMenuItem)object));
                        HeroDesigner.getInstance().unloadPrefabMI.add((JMenuItem)object);
                        bl = true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred loading previously loaded Prefabs.\n\nError Message: " + exception.getMessage(), "Error loading prefabs", 0);
                    }
                }
                if (bl && HeroDesigner.getInstance().mainPanel != null) {
                    HeroDesigner.getInstance().mainPanel.updatePrefabs();
                }
            }
            ArrayList<Modifier> arrayList = new ArrayList<Modifier>();
            for (Element element3 : element.getChildren("MODIFIER")) {
                String string5 = XMLUtility.getValue(element3, "XMLID");
                Modifier modifier = null;
                if (string5 != null && string5.trim().length() > 0) {
                    for (GenericObject genericObject : HeroDesigner.getActiveTemplate().getModifiers()) {
                        if (!genericObject.getXMLID().equals(string5)) continue;
                        modifier = (Modifier)genericObject.clone();
                        break;
                    }
                }
                if (modifier == null) {
                    modifier = Modifier.getInstance(element3);
                }
                if (modifier == null) continue;
                modifier.restoreFromSave(element3);
                if (modifier.getDisplay() == null || modifier.getDisplay().trim().length() == 0) {
                    modifier.setDisplay(modifier.getAlias());
                }
                modifier.setFullDisplay(true);
                arrayList.add(modifier);
            }
            AvailableModifiersDialog.setRecentlySelectedList(arrayList);
            Element element4 = element.getChild("SOURCES");
            if (element4 == null || this.sources.size() == 0) {
                this.sources = GenericObject.getAllSources();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred restoring your saved preferences.\n\nError Message: " + exception.getMessage(), "Error loading preferences", 0);
        }
    }

    protected void restorePrefs() {
        try {
            Object object2;
            Element element;
            File file = new File("appPrefs.xml");
            if (!file.exists()) {
                return;
            }
            SAXBuilder sAXBuilder = new SAXBuilder(false);
            Document document = sAXBuilder.build(file);
            sAXBuilder = null;
            Element element2 = document.getRootElement();
            String string = XMLUtility.getValue(element2, "FRAME_STATE");
            if (string != null && string.trim().length() > 0) {
                try {
                    this.state = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.state = 0;
                }
            } else {
                this.state = 0;
            }
            if ((element = element2.getChild("SOURCES")) != null) {
                this.sources = new ArrayList();
                for (Object object2 : element.getChildren("SOURCE")) {
                    this.sources.add(((Element)object2).getTextTrim());
                }
            }
            if ((string = XMLUtility.getValue(element2, "MINIMUM_HEAP_SIZE")) != null && string.trim().length() > 0) {
                try {
                    this.minimumHeapSize = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "MAXIMUM_HEAP_SIZE")) != null && string.trim().length() > 0) {
                try {
                    this.maximumHeapSize = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "REFRESH_TEMPLATE_ON_RESTORE")) != null && string.trim().length() > 0) {
                try {
                    this.refreshTemplateOnRestore = Integer.parseInt(string);
                    if (this.refreshTemplateOnRestore > 3) {
                        this.refreshTemplateOnRestore = 3;
                    }
                    if (this.refreshTemplateOnRestore < 1) {
                        this.refreshTemplateOnRestore = 3;
                    }
                }
                catch (Exception exception) {
                    this.refreshTemplateOnRestore = 3;
                }
            }
            if ((string = XMLUtility.getValue(element2, "BROWSER_PATH")) != null && string.trim().length() > 0) {
                this.browserExecutablePath = string.trim();
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULT_AI_FORMAT")) != null && string.trim().length() > 0) {
                this.defaultAIFormatPath = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULT_AUTOMATON_FORMAT")) != null && string.trim().length() > 0) {
                this.defaultAutomatonFormatPath = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULT_BASE_FORMAT")) != null && string.trim().length() > 0) {
                this.defaultBaseFormatPath = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULT_COMPUTER_FORMAT")) != null && string.trim().length() > 0) {
                this.defaultComputerFormatPath = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULT_HEROIC_FORMAT")) != null && string.trim().length() > 0) {
                this.defaultHeroicFormatPath = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULT_NORMAL_FORMAT")) != null && string.trim().length() > 0) {
                this.defaultNormalFormatPath = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULT_SUPERHEROIC_FORMAT")) != null && string.trim().length() > 0) {
                this.defaultSuperheroicFormatPath = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULT_VEHICLE_FORMAT")) != null && string.trim().length() > 0) {
                this.defaultVehicleFormatPath = string;
            }
            if ((string = XMLUtility.getValue(element2, "REFRESH_RULES_ON_RESTORE")) != null && string.trim().length() > 0) {
                try {
                    this.refreshRulesOnRestore = Integer.parseInt(string);
                    if (this.refreshRulesOnRestore > 3) {
                        this.refreshRulesOnRestore = 3;
                    }
                    if (this.refreshRulesOnRestore < 1) {
                        this.refreshRulesOnRestore = 3;
                    }
                }
                catch (Exception exception) {
                    this.refreshTemplateOnRestore = 3;
                }
            }
            if ((string = XMLUtility.getValue(element2, "RESTORE_WINDOW")) != null && string.trim().toUpperCase().startsWith("N")) {
                this.restoreWindow = false;
            }
            if ((string = XMLUtility.getValue(element2, "MODIFIER_INTELLIGENCE")) != null && string.trim().toUpperCase().startsWith("N")) {
                this.modifierIntelligenceOn = false;
            }
            if ((string = XMLUtility.getValue(element2, "CHECK_MODS_DURING_EDIT")) != null && string.trim().toUpperCase().startsWith("N")) {
                this.checkDuringEdit = false;
            }
            if ((string = XMLUtility.getValue(element2, "REMOVE_ILLEGAL_MODS")) != null && string.trim().toUpperCase().startsWith("N")) {
                this.removeIllegalMods = false;
            }
            this.metric = (string = XMLUtility.getValue(element2, "METRIC")) == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "DISPLAYACTIVEPOINTS");
            this.displayActivePoints = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "REMEMBER_DIALOG");
            this.rememberDialogPosition = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "USE_ABBREVIATIONS");
            this.useAbbreviations = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "USE_WG");
            this.useWG = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "USE_QUICKASSIGN");
            this.useQuickAssign = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "CONFIRM_DELETE");
            this.confirmDelete = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "WARN_ON_MULTIPLE");
            this.warnOnMultiple = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "SHOW_COMMON_LIMITATIONS");
            this.showCommonLimitations = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "PROMPT_TO_EXPORT_IMAGE");
            this.promptToExportImage = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "FLAG_FORCED_MODIFIERS");
            this.flagForcedModifiers = string == null || !string.trim().toUpperCase().startsWith("N");
            string = XMLUtility.getValue(element2, "EXPORTTEMPLATEDIR");
            if (string != null) {
                this.exportTemplateDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "NUMBERDIGITSROUNDING")) != null && string.trim().length() > 0) {
                try {
                    this.numberDigitsForRounding = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "DIALOGX")) != null && string.trim().length() > 0) {
                try {
                    this.dialogX = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "DIALOGY")) != null && string.trim().length() > 0) {
                try {
                    this.dialogY = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "DIALOGSCREENX")) != null && string.trim().length() > 0) {
                try {
                    this.dialogScreenX = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "DIALOGSCREENY")) != null && string.trim().length() > 0) {
                try {
                    this.dialogScreenY = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "MODX")) != null && string.trim().length() > 0) {
                try {
                    this.modX = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "MODY")) != null && string.trim().length() > 0) {
                try {
                    this.modY = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "MODSCREENX")) != null && string.trim().length() > 0) {
                try {
                    this.modScreenX = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "MODSCREENY")) != null && string.trim().length() > 0) {
                try {
                    this.modScreenY = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = XMLUtility.getValue(element2, "SIZEX");
            this.sizeX = 800;
            if (string != null && string.trim().length() > 0) {
                try {
                    this.sizeX = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = XMLUtility.getValue(element2, "SIZEY");
            this.sizeY = 550;
            if (string != null && string.trim().length() > 0) {
                try {
                    this.sizeY = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((string = XMLUtility.getValue(element2, "SCREENX")) != null && string.trim().length() > 0) {
                try {
                    this.screenX = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.screenX = -1;
                }
            } else {
                this.screenX = -1;
            }
            if ((string = XMLUtility.getValue(element2, "SCREENY")) != null && string.trim().length() > 0) {
                try {
                    this.screenY = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.screenY = -1;
                }
            } else {
                this.screenY = -1;
            }
            if ((string = XMLUtility.getValue(element2, "SAVEDIR")) != null && string.trim().length() > 0) {
                this.saveDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "EXPORTDIR")) != null && string.trim().length() > 0) {
                this.exportDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "IMAGEDIR")) != null && string.trim().length() > 0) {
                this.imageDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "TEMPLATEDIR")) != null && string.trim().length() > 0) {
                this.templateDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULTRULESDIR")) != null && string.trim().length() > 0) {
                this.defaultRulesDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "DEFAULTEXPORTDIR")) != null && string.trim().length() > 0) {
                this.defaultExportDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "PREFABDIR")) != null && string.trim().length() > 0) {
                this.prefabDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "RULESDIR")) != null && string.trim().length() > 0) {
                this.rulesDir = string;
            }
            if ((string = XMLUtility.getValue(element2, "LASTRULE")) != null && string.trim().length() > 0) {
                this.lastRule = string;
            }
            List list = element2.getChildren("RECENT_FILE");
            object2 = list.iterator();
            this.recentFiles = new ArrayList();
            while (object2.hasNext()) {
                File file2;
                Element element3 = (Element)object2.next();
                String string2 = element3.getTextTrim();
                if (string2.length() <= 0 || !(file2 = new File(string2)).exists() || !file2.canRead()) continue;
                this.recentFiles.add(file2.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(HeroDesigner.getAppFrame(), "An error occurred restoring your saved preferences.\n\nError Message: " + exception.getMessage(), "Error loading preferences", 0);
        }
    }

    protected void savePrefs() {
        try {
            Object object;
            ArrayList<Modifier> arrayList;
            Element element = new Element("APP_PREFS");
            if (HeroDesigner.getAppFrame().getExtendedState() == 0) {
                element.setAttribute("SIZEX", HeroDesigner.getAppFrame().getSize().width + "");
                element.setAttribute("SIZEY", "" + HeroDesigner.getAppFrame().getSize().height);
                element.setAttribute("SCREENX", "" + (int)HeroDesigner.getAppFrame().getLocationOnScreen().getX());
                element.setAttribute("SCREENY", "" + (int)HeroDesigner.getAppFrame().getLocationOnScreen().getY());
            } else {
                element.setAttribute("SIZEX", "" + this.sizeX);
                element.setAttribute("SIZEY", "" + this.sizeY);
                element.setAttribute("SCREENX", this.screenX + "");
                element.setAttribute("SCREENY", this.screenY + "");
            }
            element.setAttribute("MINIMUM_HEAP_SIZE", "" + this.minimumHeapSize);
            element.setAttribute("MAXIMUM_HEAP_SIZE", "" + this.maximumHeapSize);
            Element element2 = new Element("SOURCES");
            for (int i = 0; i < this.getSources().size(); ++i) {
                arrayList = this.getSources().get(i).toString();
                Element object22 = new Element("SOURCE");
                object22.setText((String)((Object)arrayList));
                element2.addContent(object22);
            }
            element.addContent(element2);
            Enumeration<String> enumeration = this.tearOffPrefs.keys();
            while (enumeration.hasMoreElements()) {
                arrayList = enumeration.nextElement().toString();
                Integer[] integerArray = this.tearOffPrefs.get(arrayList);
                arrayList = this.adjustTitle((String)((Object)arrayList));
                element.setAttribute((String)((Object)arrayList) + "WIDTH", integerArray[0].toString());
                element.setAttribute((String)((Object)arrayList) + "HEIGHT", integerArray[1].toString());
                element.setAttribute((String)((Object)arrayList) + "X", integerArray[2].toString());
                element.setAttribute((String)((Object)arrayList) + "Y", integerArray[3].toString());
                element.setAttribute((String)((Object)arrayList) + "TORN", integerArray[4].toString());
            }
            if (this.browserExecutablePath != null && this.browserExecutablePath.trim().length() > 0) {
                element.setAttribute("BROWSER_PATH", this.browserExecutablePath);
            }
            element.setAttribute("REFRESH_TEMPLATE_ON_RESTORE", "" + this.refreshTemplateOnRestore);
            element.setAttribute("PROMPT_TO_EXPORT_IMAGE", "" + (this.promptToExportImage ? "YES" : "NO"));
            element.setAttribute("FLAG_FORCED_MODIFIERS", "" + (this.flagForcedModifiers ? "YES" : "NO"));
            element.setAttribute("SHOW_POPUP_DEFINITIONS", "" + this.showPopupDefinitions);
            element.setAttribute("SHOW_EQUIPMENT_PREFABS_ON_POWERS", "" + this.showEquipmentPrefabsOnPowers);
            element.setAttribute("SHOW_POWERS_PREFABS_ON_EQUIPMENT", "" + this.showPowersPrefabsOnEquipment);
            element.setAttribute("REFRESH_RULES_ON_RESTORE", "" + this.refreshRulesOnRestore);
            element.setAttribute("SKILLSLIDER", "" + HeroDesigner.getInstance().mainPanel.skillsPanel.mainSplit.getDividerLocation());
            element.setAttribute("PERKSLIDER", "" + HeroDesigner.getInstance().mainPanel.perksPanel.mainSplit.getDividerLocation());
            element.setAttribute("TALENTSLIDER", "" + HeroDesigner.getInstance().mainPanel.talentsPanel.mainSplit.getDividerLocation());
            element.setAttribute("MARTIALARTSLIDER", "" + HeroDesigner.getInstance().mainPanel.maneuversPanel.mainSplit.getDividerLocation());
            element.setAttribute("POWERSLIDER", "" + HeroDesigner.getInstance().mainPanel.powersPanel.mainSplit.getDividerLocation());
            element.setAttribute("DISADSLIDER", "" + HeroDesigner.getInstance().mainPanel.disadsPanel.mainSplit.getDividerLocation());
            element.setAttribute("EQUIPMENTSLIDER", "" + HeroDesigner.getInstance().mainPanel.equipmentPanel.mainSplit.getDividerLocation());
            element.setAttribute("MAX_MEMORY", "" + this.maxMemory);
            if (this.saveDir != null) {
                element.setAttribute("SAVEDIR", this.saveDir);
            }
            if (this.exportDir != null) {
                element.setAttribute("EXPORTDIR", this.exportDir);
            }
            if (this.imageDir != null) {
                element.setAttribute("IMAGEDIR", this.imageDir);
            }
            if (this.templateDir != null) {
                element.setAttribute("TEMPLATEDIR", this.templateDir);
            }
            if (this.defaultRulesDir != null) {
                element.setAttribute("DEFAULTRULESDIR", this.defaultRulesDir);
            }
            if (this.defaultExportDir != null) {
                element.setAttribute("DEFAULTEXPORTDIR", this.defaultExportDir);
            }
            if (this.prefabDir != null) {
                element.setAttribute("PREFABDIR", this.prefabDir);
            }
            if (this.rulesDir != null) {
                element.setAttribute("RULESDIR", this.rulesDir);
            }
            if (this.lastRule != null) {
                element.setAttribute("LASTRULE", this.lastRule);
            }
            element.setAttribute("FRAME_STATE", "" + HeroDesigner.getAppFrame().getExtendedState());
            element.setAttribute("TAB_POSITION", "" + HeroDesigner.getInstance().mainPanel.getTabPlacement());
            element.setAttribute("LOAD_CHARS", this.loadCharacters ? "Yes" : "No");
            element.setAttribute("LOAD_PREFABS", this.loadPrefabs ? "Yes" : "No");
            element.setAttribute("RESTORE_WINDOW", this.restoreWindow ? "Yes" : "No");
            element.setAttribute("REMEMBER_DIALOG", this.rememberDialogPosition ? "Yes" : "No");
            element.setAttribute("MODIFIER_INTELLIGENCE", this.modifierIntelligenceOn ? "Yes" : "No");
            element.setAttribute("CHECK_MODS_DURING_EDIT", this.checkDuringEdit ? "Yes" : "No");
            element.setAttribute("REMOVE_ILLEGAL_MODS", this.removeIllegalMods ? "Yes" : "No");
            element.setAttribute("METRIC", this.metric ? "Yes" : "No");
            element.setAttribute("DISPLAYACTIVEPOINTS", this.displayActivePoints ? "Yes" : "No");
            element.setAttribute("USE_ABBREVIATIONS", this.useAbbreviations ? "Yes" : "No");
            element.setAttribute("USE_QUICKASSIGN", this.useQuickAssign ? "Yes" : "No");
            element.setAttribute("CONFIRM_DELETE", this.confirmDelete ? "Yes" : "No");
            element.setAttribute("WARN_ON_MULTIPLE", this.warnOnMultiple ? "Yes" : "No");
            element.setAttribute("SHOW_COMMON_LIMITATIONS", this.showCommonLimitations ? "Yes" : "No");
            element.setAttribute("USE_WG", this.useWG ? "Yes" : "No");
            element.setAttribute("NUMBERDIGITSROUNDING", "" + this.numberDigitsForRounding);
            element.setAttribute("DIALOGX", "" + this.dialogX);
            element.setAttribute("DIALOGY", "" + this.dialogY);
            element.setAttribute("DIALOGSCREENX", "" + this.dialogScreenX);
            element.setAttribute("DIALOGSCREENY", "" + this.dialogScreenY);
            element.setAttribute("MODX", "" + this.modX);
            element.setAttribute("MODY", "" + this.modY);
            element.setAttribute("MODSCREENX", "" + this.modScreenX);
            element.setAttribute("MODSCREENY", "" + this.modScreenY);
            element.setAttribute("EXPORTTEMPLATEDIR", this.exportTemplateDir);
            if (this.defaultAIFormatPath != null) {
                element.setAttribute("DEFAULT_AI_FORMAT", this.defaultAIFormatPath);
            }
            if (this.defaultAutomatonFormatPath != null) {
                element.setAttribute("DEFAULT_AUTOMATON_FORMAT", this.defaultAutomatonFormatPath);
            }
            if (this.defaultBaseFormatPath != null) {
                element.setAttribute("DEFAULT_BASE_FORMAT", this.defaultBaseFormatPath);
            }
            if (this.defaultComputerFormatPath != null) {
                element.setAttribute("DEFAULT_COMPUTER_FORMAT", this.defaultComputerFormatPath);
            }
            if (this.defaultHeroicFormatPath != null) {
                element.setAttribute("DEFAULT_HEROIC_FORMAT", this.defaultHeroicFormatPath);
            }
            if (this.defaultNormalFormatPath != null) {
                element.setAttribute("DEFAULT_NORMAL_FORMAT", this.defaultNormalFormatPath);
            }
            if (this.defaultSuperheroicFormatPath != null) {
                element.setAttribute("DEFAULT_SUPERHEROIC_FORMAT", this.defaultSuperheroicFormatPath);
            }
            if (this.defaultVehicleFormatPath != null) {
                element.setAttribute("DEFAULT_VEHICLE_FORMAT", this.defaultVehicleFormatPath);
            }
            for (String string : this.recentFiles) {
                Element element3 = new Element("RECENT_FILE");
                element3.addContent(string);
                element.addContent(element3);
            }
            for (Hero hero : HeroDesigner.getInstance().openHeroes) {
                Element element4 = new Element("CHARACTER");
                if (hero.getSaveFile() == null) continue;
                element4.setAttribute("FILE_LOC", hero.getSaveFile().getAbsolutePath());
                element.addContent(element4);
            }
            for (Prefab prefab : HeroDesigner.getInstance().loadedPrefabs) {
                Element element5 = new Element("PREFAB");
                if (prefab.getSaveFile() == null) continue;
                element5.setAttribute("FILE_LOC", prefab.getSaveFile().getAbsolutePath());
                element.addContent(element5);
            }
            arrayList = AvailableModifiersDialog.getRecentlySelectedList();
            if (arrayList != null) {
                for (Modifier modifier : arrayList) {
                    object = modifier.getSaveXML();
                    element.addContent((Content)object);
                }
            }
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            XMLOutputter xMLOutputter = new XMLOutputter(format);
            object = new FileOutputStream("appPrefs.xml");
            xMLOutputter.output(new Document(element), (OutputStream)object);
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getMinimumHeapSize() {
        return this.minimumHeapSize;
    }

    public void setMinimumHeapSize(int n) {
        this.minimumHeapSize = n;
    }

    public int getMaximumHeapSize() {
        return this.maximumHeapSize;
    }

    public void setMaximumHeapSize(int n) {
        this.maximumHeapSize = n;
    }

    public void setRefreshTemplateOnRestore(int n) {
        if (n < 1 || n > 3) {
            return;
        }
        this.refreshTemplateOnRestore = n;
    }

    public int getRefreshTemplateOnRestore() {
        return this.refreshTemplateOnRestore;
    }

    public void setRefreshRulesOnRestore(int n) {
        if (n < 1 || n > 3) {
            return;
        }
        this.refreshRulesOnRestore = n;
    }

    public int getRefreshRulesOnRestore() {
        return this.refreshRulesOnRestore;
    }

    public String getLastRule() {
        if (this.lastRule == null) {
            this.lastRule = "";
        }
        if (this.lastRule.trim().length() > 0) {
            File file = new File(this.lastRule);
            if (file.exists() && file.isFile()) {
                return this.lastRule;
            }
            return "";
        }
        return this.lastRule;
    }

    public void setLastRule(String string) {
        this.lastRule = string == null ? "" : string;
    }

    public boolean useWG() {
        return this.useWG;
    }

    public void setUseWG(boolean bl) {
        this.useWG = bl;
    }

    public boolean useQuickAssign() {
        return this.useQuickAssign;
    }

    public void setUseQuickAssign(boolean bl) {
        this.useQuickAssign = bl;
    }

    public boolean confirmDelete() {
        return this.confirmDelete;
    }

    public boolean warnOnMultiple() {
        return this.warnOnMultiple;
    }

    public boolean showCommonLimitations() {
        return this.showCommonLimitations;
    }

    public void setConfirmDelete(boolean bl) {
        this.confirmDelete = bl;
    }

    public void setWarnOnMultiple(boolean bl) {
        this.warnOnMultiple = bl;
    }

    public void setShowCommonLimitations(boolean bl) {
        this.showCommonLimitations = bl;
    }

    public boolean useAbbreviations() {
        return this.useAbbreviations;
    }

    public void setUseAbbreviations(boolean bl) {
        this.useAbbreviations = bl;
    }

    public boolean isMetric() {
        return this.metric;
    }

    public void setMetric(boolean bl) {
        this.metric = bl;
    }

    public boolean displayActivePoints() {
        return this.displayActivePoints;
    }

    public void setDisplayActivePoints(boolean bl) {
        this.displayActivePoints = bl;
    }

    public int getDialogScreenX() {
        return this.dialogScreenX;
    }

    public int getDialogScreenY() {
        return this.dialogScreenY;
    }

    public int getDialogX() {
        return this.dialogX;
    }

    public int getDialogY() {
        return this.dialogY;
    }

    public String getExportDir() {
        return this.exportDir;
    }

    public String getImageDir() {
        return this.imageDir;
    }

    public boolean isLoadCharacters() {
        return this.loadCharacters;
    }

    public boolean isLoadPrefabs() {
        return this.loadPrefabs;
    }

    public int getMaxMemory() {
        return this.maxMemory;
    }

    public int getNumberDigitsForRounding() {
        return this.numberDigitsForRounding;
    }

    public String getPrefabDir() {
        return this.prefabDir;
    }

    public String getRulesDir() {
        return this.rulesDir;
    }

    public boolean isRememberDialogPosition() {
        return this.rememberDialogPosition;
    }

    public boolean isRestoreWindow() {
        return this.restoreWindow;
    }

    public String getSaveDir() {
        return this.saveDir;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getState() {
        return this.state;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public String getDefaultRulesDir() {
        return this.defaultRulesDir;
    }

    public String getDefaultExportDir() {
        return this.defaultExportDir;
    }

    public void setDialogScreenX(int n) {
        this.dialogScreenX = n;
    }

    public void setDialogScreenY(int n) {
        this.dialogScreenY = n;
    }

    public void setDialogX(int n) {
        this.dialogX = n;
    }

    public void setDialogY(int n) {
        this.dialogY = n;
    }

    public void setExportDir(String string) {
        this.exportDir = string;
    }

    public void setImageDir(String string) {
        this.imageDir = string;
    }

    public void setLoadCharacters(boolean bl) {
        this.loadCharacters = bl;
    }

    public void setLoadPrefabs(boolean bl) {
        this.loadPrefabs = bl;
    }

    public void setMaxMemory(int n) {
        this.maxMemory = n;
    }

    public void setNumberDigitsForRounding(int n) {
        this.numberDigitsForRounding = n;
    }

    public void setPrefabDir(String string) {
        this.prefabDir = string;
    }

    public void setRulesDir(String string) {
        this.rulesDir = string;
    }

    public void setRememberDialogPosition(boolean bl) {
        this.rememberDialogPosition = bl;
    }

    public void setRestoreWindow(boolean bl) {
        this.restoreWindow = bl;
    }

    public void setSaveDir(String string) {
        this.saveDir = string;
    }

    public void setScreenX(int n) {
        this.screenX = n;
    }

    public void setScreenY(int n) {
        this.screenY = n;
    }

    public void setSizeX(int n) {
        this.sizeX = n;
    }

    public void setSizeY(int n) {
        this.sizeY = n;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void setTemplateDir(String string) {
        this.templateDir = string;
    }

    public void setDefaultRulesDir(String string) {
        this.defaultRulesDir = string;
    }

    public void setDefaultExportDir(String string) {
        this.defaultExportDir = string;
    }

    public String getExportTemplateDir() {
        return this.exportTemplateDir;
    }

    public void setExportTemplateDir(String string) {
        this.exportTemplateDir = string;
    }

    public boolean isModifierIntelligenceOn() {
        return this.modifierIntelligenceOn;
    }

    public boolean checkModsDuringEdit() {
        if (!this.modifierIntelligenceOn) {
            return false;
        }
        return this.checkDuringEdit;
    }

    public boolean removeIllegalMods() {
        if (!this.checkModsDuringEdit()) {
            return false;
        }
        return this.removeIllegalMods;
    }

    public void setModifierIntelligenceOn(boolean bl) {
        this.modifierIntelligenceOn = bl;
    }

    public void setCheckModsDuringEdit(boolean bl) {
        this.checkDuringEdit = bl;
    }

    public void setRemoveIllegalMods(boolean bl) {
        this.removeIllegalMods = bl;
    }

    public int getModScreenX() {
        return this.modScreenX;
    }

    public int getModScreenY() {
        return this.modScreenY;
    }

    public int getModX() {
        return this.modX;
    }

    public int getModY() {
        return this.modY;
    }

    public void setModScreenX(int n) {
        this.modScreenX = n;
    }

    public void setModScreenY(int n) {
        this.modScreenY = n;
    }

    public void setModX(int n) {
        this.modX = n;
    }

    public void setModY(int n) {
        this.modY = n;
    }

    public String getDefaultAIFormatPath() {
        return this.defaultAIFormatPath;
    }

    public void setDefaultAIFormatPath(String string) {
        this.defaultAIFormatPath = string;
    }

    public String getDefaultAutomatonFormatPath() {
        return this.defaultAutomatonFormatPath;
    }

    public void setDefaultAutomatonFormatPath(String string) {
        this.defaultAutomatonFormatPath = string;
    }

    public String getDefaultBaseFormatPath() {
        return this.defaultBaseFormatPath;
    }

    public void setDefaultBaseFormatPath(String string) {
        this.defaultBaseFormatPath = string;
    }

    public String getDefaultComputerFormatPath() {
        return this.defaultComputerFormatPath;
    }

    public void setDefaultComputerFormatPath(String string) {
        this.defaultComputerFormatPath = string;
    }

    public String getDefaultHeroicFormatPath() {
        return this.defaultHeroicFormatPath;
    }

    public void setDefaultHeroicFormatPath(String string) {
        this.defaultHeroicFormatPath = string;
    }

    public String getDefaultNormalFormatPath() {
        return this.defaultNormalFormatPath;
    }

    public void setDefaultNormalFormatPath(String string) {
        this.defaultNormalFormatPath = string;
    }

    public String getDefaultSuperheroicFormatPath() {
        return this.defaultSuperheroicFormatPath;
    }

    public void setDefaultSuperheroicFormatPath(String string) {
        this.defaultSuperheroicFormatPath = string;
    }

    public String getDefaultVehicleFormatPath() {
        return this.defaultVehicleFormatPath;
    }

    public void setDefaultVehicleFormatPath(String string) {
        this.defaultVehicleFormatPath = string;
    }
}

