![Logo](https://github.com/ElectricCoffee/SirenRPG/blob/master/src/graphics/svg-logo.png)

# Beta 2.1.1

Note that this engine is still in development! Much of the engine is not finalised yet, and more is still left to be written and added. Please keep this in mind if you want to download and read the rules.

Be sure to check out the [wiki](https://github.com/ElectricCoffee/SirenRPG/wiki) if you have questions.

## :package: Downloads and Compilation

You can find the latest version of the PDF [here](https://github.com/ElectricCoffee/SirenRPG/releases)

If you instead prefer to compile from source, you need a LaTeX compiler with a package manager. TeXLive works well.

## :bulb: Premise

The idea here is to make a system that is

1. Simple enough to be pick-up and play.
2. Doesn't require special dice.
3. Can be learned in an afternoon.
4. Is general enough to be used in any setting.
5. Is extensible.

### 🤸 Simple Enough to Be Picked up and Played

It is important that the system is simple. That anyone can sit down, read the book, and get a somewhat intuitive understanding of how the game is to be played.

### :game_die: No Special Dice

For the sake of accessibility, it's important that regular D6 dice are used for the game.
If everyone is to pick it up and play it, it's also important that everyone has access to the correct dice.
A set of polyhedral, for example, are easy to come by, but are often much more expensive than a set of D6s, as those are often included with most board games.

### :clock2: Can Be Learned in an Afternoon

It's important that it doesn't take too long to learn the system, particularly not as a GM.
Spending days trudging through rule-books, only to forget half the rules by the end of it is no way to go.

### 🧙 Setting Neutral

The system should be usable regardless of the setting and genre of the game played.
It should be dynamic enough to fit Noir, Sci-Fi, Adventure, Fantasy, etc.

### :star2: Extensible

Lastly, it should be extensible.
Everything in this guide is only meant to be preliminary, if anything needs to be thrown out or replaced, then the player may do so if they wish.
Does hacking apply better to the setting than burglary?
Then replace one with the other.

## :couple: Collaboration

I wanted this to be an open source project from the start, and make it freely available to anyone interested.

Anyone who wishes to collaborate is free to do so, but keep in mind that any additions need to follow the basic premise.
I don't want to end up with a rulebook 500 pages long by the end of it all, since that defeats the purpose of something learnable in (about) an afternoon.

### :thought_balloon: If you wish to collaborate

Please feel free to submit an _issue_ if you feel something is poorly explained, or add a _pull request_ if you want to add something to the system.
I am open for new ideas!

## 💵 Donations

If you wish to make donations for the project, I have setup a few options to help you do so:

- [Patreon](https://www.patreon.com/sirenRPG) if you wish to give monthly donations.
- [Ko-fi](https://ko-fi.com/sirenrpg) if you wish to give a single donation.
